# licence.sh
# -----------------------------------------------------------------------------
#
# Licensing information module.  See below for package identification,
# copyright notice, and full text of the licence document.
#
# -----------------------------------------------------------------------------
#
APPNAME=${APPNAME-"${cmd-"mingw-pkg"}"}
APPDESC=${APPDESC-"MinGW Package Builder Tool"}
APPVERSION=${APPVERSION-"`basename "$libexecdir"`"}

APPSUITE_CMD=${cmd-"$APPNAME"}
test "x$APPSUITE_CMD" = "x$APPNAME" || APPSUITE_CMD="$cmd ($APPNAME)"

AUTHOR=${AUTHOR-"Keith Marshall"}
COPYRIGHT_HOLDER=${COPYRIGHT_HOLDER-"MinGW.org Project"}
COPYRIGHT_YEARS=${COPYRIGHT_YEARS-"2011-2020"}

# Copyright notice.
#
cat <<-ETX
$APPDESC, $APPSUITE_CMD version $APPVERSION
Written by $AUTHOR, Copyright (C) $COPYRIGHT_YEARS, $COPYRIGHT_HOLDER

ETX

# Licence document (full text).
#
test "x$3" = xfull && cat <<-ETX
$APPNAME is licensed under the terms of the MIT/X11 licence.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

ETX

# Licence reference information (short form).
#
test "x$3" = xshort && cat <<-ETX
$APPNAME is free software.  It is provided "as is", WITHOUT WARRANTY
of any kind; not even a WARRANTY OF MERCHANTABILITY nor of FITNESS FOR ANY
PARTICULAR PURPOSE; please refer to the source code distribution, or run:

  \$ $cmd --licence

to see the full licence, for copying and distribution conditions.

ETX

exit 0

# $RCSfile: licence.sh,v $: end of file
