/*
 * Decompiled with CFR 0.152.
 */
package org.ccc.atools.mediator;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.ccc.atools.mediator.Console;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleColorProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;

public class AToolUI
implements Console {
    private int resultForConsole = 0;

    public void dispose() {
    }

    @Override
    public void execForConsole(String[] command) {
        this.execForUIConsole(command);
    }

    private void execForUIConsole(String[] command) {
        this.execForUIConsole(command, null);
    }

    private void execForUIConsole(String[] command, File directory) {
        Process rawProc = null;
        try {
            rawProc = DebugPlugin.exec((String[])command, (File)directory);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return;
        }
        this.showConsole(rawProc);
    }

    private void showConsole(Process rawProc) {
        if (rawProc == null) {
            return;
        }
        Launch launch = new Launch(null, "run", null);
        IProcess proc = DebugPlugin.newProcess((ILaunch)launch, (Process)rawProc, (String)"org.ccc.atools");
        IOConsole console = AToolUI.getConsole(proc, "org.ccc.atools");
        IOConsoleOutputStream consoleStream = console instanceof MessageConsole ? ((MessageConsole)console).newMessageStream() : console.newOutputStream();
        IStreamListener streamlistener = new IStreamListener(){

            public void streamAppended(String text, IStreamMonitor monitor) {
                this.println(text);
            }

            private void print(String message) {
                try {
                    consoleStream.write(message);
                }
                catch (IOException e) {
                    ConsolePlugin.log((Throwable)e);
                }
            }

            private void println(String message) {
                this.print(String.valueOf(message) + "\n");
            }
        };
        proc.getStreamsProxy().getOutputStreamMonitor().addListener(streamlistener);
        proc.getStreamsProxy().getErrorStreamMonitor().addListener(streamlistener);
        IDebugEventSetListener listener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                DebugEvent[] debugEventArray = events;
                int n = events.length;
                int n2 = 0;
                while (n2 < n) {
                    DebugEvent event = debugEventArray[n2];
                    this.handleDebugEvent(event);
                    ++n2;
                }
            }

            private void handleDebugEvent(DebugEvent event) {
                Object obj = event.getSource();
                ITerminate dt = null;
                if (event.getKind() == 8 && obj instanceof ITerminate && proc == (dt = (ITerminate)obj)) {
                    AToolUI.this.resultForConsole |= 1;
                    System.out.println("[Info] Process is finished.");
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(listener);
        console.activate();
    }

    private static String createLaunchConfiguration(Process rawProc) {
        ProcessHandle.Info procInfo = rawProc.info();
        Optional<String> commandLine = procInfo.commandLine();
        return commandLine.isPresent() ? commandLine.get() : "";
    }

    private static IOConsole getConsole(IProcess proc, String name) {
        org.eclipse.ui.console.IConsole console;
        org.eclipse.ui.console.IConsole[] consoles;
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        org.eclipse.ui.console.IConsole[] iConsoleArray = consoles = conMan.getConsoles();
        int n = consoles.length;
        int n2 = 0;
        while (n2 < n) {
            console = iConsoleArray[n2];
            if (name.equals(console.getName())) {
                return (IOConsole)console;
            }
            ++n2;
        }
        console = new ProcessConsole(proc, new IConsoleColorProvider(){

            public boolean isReadOnly() {
                return false;
            }

            public Color getColor(String streamIdentifer) {
                return AToolUI.getDisplay().getSystemColor(9);
            }

            public void connect(IProcess process, IConsole console) {
            }

            public void disconnect() {
            }
        });
        conMan.addConsoles(new org.eclipse.ui.console.IConsole[]{console});
        return console;
    }

    @Override
    public int getResultForConsole() {
        return this.resultForConsole;
    }

    private int getResultForUIConsole(String[] command) {
        return 0;
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

