/*
 * Decompiled with CFR 0.152.
 */
package jdd.util;

import jdd.util.Allocator;
import jdd.util.Test;
import jdd.util.math.FastRandom;

public final class Array {
    public static final int[] resize(int[] nArray, int n, int n2) {
        int[] nArray2 = Allocator.allocateIntArray(n2);
        if (n > n2) {
            n = n2;
        }
        Array.fast_copy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public static final short[] resize(short[] sArray, int n, int n2) {
        short[] sArray2 = Allocator.allocateShortArray(n2);
        if (n > n2) {
            n = n2;
        }
        Array.fast_copy(sArray, 0, sArray2, 0, n);
        return sArray2;
    }

    public static final void copy(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        if (nArray == nArray2 && n2 < n3 && n2 + n >= n3) {
            Array.fast_copy_backward(nArray, n2, nArray2, n3, n);
            return;
        }
        Array.fast_copy(nArray, n2, nArray2, n3, n);
    }

    private static final void fast_copy(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        System.arraycopy(nArray, n, nArray2, n2, n3);
    }

    private static final void fast_copy(short[] sArray, int n, short[] sArray2, int n2, int n3) {
        System.arraycopy(sArray, n, sArray2, n2, n3);
    }

    private static final void fast_copy_foward(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            nArray2[n2 + i] = nArray[n + i];
        }
    }

    private static final void fast_copy_foward(short[] sArray, int n, short[] sArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            sArray2[n2 + i] = sArray[n + i];
        }
    }

    private static final void fast_copy_backward(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        while (n3 != 0) {
            nArray2[n2 + --n3] = nArray[n + n3];
        }
    }

    public static final int[] clone(int[] nArray) {
        int[] nArray2 = Allocator.allocateIntArray(nArray.length);
        Array.fast_copy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public static final boolean[] clone(boolean[] blArray) {
        boolean[] blArray2 = new boolean[blArray.length];
        System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
        return blArray2;
    }

    public static final void set(int[] nArray, int n) {
        Array.set(nArray, n, nArray.length);
    }

    public static final void set(int[] nArray, int n, int n2) {
        int n3 = n2;
        while (n3 != 0) {
            nArray[--n3] = n;
        }
    }

    public static final void set(boolean[] blArray, boolean bl) {
        int n = blArray.length;
        while (n != 0) {
            blArray[--n] = bl;
        }
    }

    public static final int count(int[] nArray, int n) {
        int n2 = 0;
        int n3 = nArray.length;
        while (n3 != 0) {
            if (nArray[--n3] != n) continue;
            ++n2;
        }
        return n2;
    }

    public static final int count(boolean[] blArray, boolean bl) {
        int n = blArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (blArray[i] != bl) continue;
            ++n2;
        }
        return n2;
    }

    public static void reverse(Object[] objectArray, int n) {
        int n2 = n / 2;
        --n;
        for (int i = 0; i < n2; ++i) {
            int n3 = n - i;
            Object object = objectArray[n3];
            objectArray[n3] = objectArray[i];
            objectArray[i] = object;
        }
    }

    public static void reverse(int[] nArray, int n) {
        int n2 = n / 2;
        --n;
        for (int i = 0; i < n2; ++i) {
            int n3 = n - i;
            int n4 = nArray[n3];
            nArray[n3] = nArray[i];
            nArray[i] = n4;
        }
    }

    public static void reverse(double[] dArray, int n) {
        int n2 = n / 2;
        --n;
        for (int i = 0; i < n2; ++i) {
            int n3 = n - i;
            double d = dArray[n3];
            dArray[n3] = dArray[i];
            dArray[i] = d;
        }
    }

    public static final void shuffle(int[] nArray) {
        Array.shuffle(nArray, nArray.length);
    }

    public static final void shuffle(int[] nArray, int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = FastRandom.mtrand() % n;
            int n3 = nArray[i];
            nArray[i] = nArray[n2];
            nArray[n2] = n3;
        }
    }

    public static final void disturb(int[] nArray, int n) {
        if (n < 16) {
            Array.shuffle(nArray, n);
        } else {
            int n2 = Math.max(4, n / 20);
            while (n2-- > 0) {
                int n3 = FastRandom.mtrand() % n;
                int n4 = FastRandom.mtrand() % n;
                int n5 = nArray[n4];
                nArray[n4] = nArray[n3];
                nArray[n3] = n5;
            }
        }
    }

    public static final int[] permutation(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        Array.shuffle(nArray);
        return nArray;
    }

    public static final boolean equals(boolean[] blArray, boolean[] blArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (blArray[i] == blArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean equals(short[] sArray, short[] sArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (sArray[i] == sArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean equals(byte[] byArray, byte[] byArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean equals(int[] nArray, int[] nArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static void internal_test() {
        Test.start("Array");
        int[] nArray = new int[]{2, 3};
        int[] nArray2 = Array.resize(nArray, 2, 5);
        Test.check(nArray2.length == 5, "new array size OK");
        Test.check(nArray2[0] == 2 && nArray2[1] == 3, "old data copied");
        int[] nArray3 = Array.resize(nArray, 2, 1);
        Test.check(nArray3.length == 1, "new array size OK, even when decreasing");
        Array.set(nArray2, 5);
        for (int i = 0; i < nArray2.length; ++i) {
            Test.check(nArray2[i] == 5, "array set");
        }
        int[] nArray4 = new int[1024];
        for (int i = 0; i < 1024; ++i) {
            nArray4[i] = i;
        }
        Test.checkEquality(nArray4[0], 0, "Im an idiot");
        Array.copy(nArray4, nArray4, 1023, 0, 1);
        Test.checkEquality(nArray4[0], 0, "Im still an idiot");
        Test.checkEquality(nArray4[1], 0, "backward_copy 1");
        Test.checkEquality(nArray4[1023], 1022, "backward_copy 2");
        Array.copy(nArray4, nArray4, 1023, 1, 0);
        Test.checkEquality(nArray4[3], 3, "forward_copy 1");
        Test.checkEquality(nArray4[1023], 1022, "forward_copy 2, not touched!");
        Test.checkEquality(nArray4[1022], 1022, "forward_copy 3, has been chagned back!");
        Test.end();
    }
}

