/*
 * Decompiled with CFR 0.152.
 */
package jdd.graph;

import java.util.Enumeration;
import java.util.Vector;
import jdd.graph.Edge;
import jdd.graph.GraphPrinter;
import jdd.graph.Node;
import jdd.util.Test;

public class Graph {
    protected Vector nodes;
    protected Vector edges;
    protected int count_nodes;
    protected int count_edges;
    boolean directed;

    public Graph(boolean bl) {
        this.directed = bl;
        this.nodes = new Vector();
        this.edges = new Vector();
        this.count_nodes = 1;
        this.count_edges = 1;
    }

    public Vector getNodes() {
        return this.nodes;
    }

    public Vector getEdges() {
        return this.edges;
    }

    public int numOfNodes() {
        return this.nodes.size();
    }

    public int numOfEdges() {
        return this.edges.size();
    }

    public boolean isDirected() {
        return this.directed;
    }

    public Node addNode(Node node) {
        Node node2 = this.findNode(node);
        if (node2 == null) {
            node.id = this.count_nodes++;
            this.nodes.add(node);
        }
        return node;
    }

    public Node addNode() {
        Node node = new Node(this.count_nodes++);
        this.nodes.add(node);
        return node;
    }

    public Node addCopy(Node node) {
        Node node2 = this.addNode();
        this.copyAttibutes(node2, node);
        return node2;
    }

    public void copyAttibutes(Node node, Node node2) {
        node.label = node2.label;
        node.flags = node2.flags;
        node.weight = node2.weight;
    }

    public Edge addEdge(Node node, Node node2) {
        Edge edge = this.findEdge(node, node2);
        if (edge == null) {
            edge = new Edge(node, node2, this.count_edges++);
            this.edges.add(edge);
            edge.next = node.firstOut;
            node.firstOut = edge;
            edge.prev = node2.firstIn;
            node2.firstIn = edge;
        }
        return edge;
    }

    public Edge addCopy(Node node, Node node2, Edge edge) {
        Edge edge2 = this.addEdge(node, node2);
        this.copyAttibutes(edge2, edge);
        return edge2;
    }

    public void copyAttibutes(Edge edge, Edge edge2) {
        edge.flags = edge2.flags;
        edge.weight = edge2.weight;
        edge.label = edge2.label;
    }

    public void removeEdge(Edge edge) {
        this.edges.remove(edge);
        this.removeForwardList(edge, edge.n1);
        this.removeBackwardList(edge, edge.n2);
    }

    protected void removeForwardList(Edge edge, Node node) {
        while (node.firstOut != null && node.firstOut == edge) {
            node.firstOut = node.firstOut.next;
        }
        Edge edge2 = node.firstOut;
        Edge edge3 = null;
        while (edge2 != null) {
            if (edge2 == edge) {
                edge3.next = edge2.next;
            } else {
                edge3 = edge2;
            }
            edge2 = edge2.next;
        }
    }

    protected void removeBackwardList(Edge edge, Node node) {
        while (node.firstIn != null && node.firstIn == edge) {
            node.firstIn = node.firstIn.prev;
        }
        Edge edge2 = node.firstIn;
        Edge edge3 = null;
        while (edge2 != null) {
            if (edge2 == edge) {
                edge3.prev = edge2.prev;
            } else {
                edge3 = edge2;
            }
            edge2 = edge2.prev;
        }
    }

    public void removeNode(Node node) {
        this.nodes.remove(node);
        Edge edge = node.firstOut;
        while (edge != null) {
            this.edges.remove(edge);
            this.removeBackwardList(edge, edge.n2);
            edge = edge.next;
        }
        edge = node.firstIn;
        while (edge != null) {
            this.edges.remove(edge);
            this.removeForwardList(edge, edge.n1);
            edge = edge.prev;
        }
        node.firstOut = null;
        node.firstIn = null;
    }

    public void removeAllEdges() {
        this.edges.removeAllElements();
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            node.firstOut = null;
            node.firstIn = null;
        }
    }

    public void removeAllNodes() {
        this.edges.removeAllElements();
        this.nodes.removeAllElements();
    }

    protected Edge findEdge(Node node, Node node2) {
        Enumeration enumeration = this.edges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (edge.n1 == node && edge.n2 == node2) {
                return edge;
            }
            if (this.directed || edge.n1 != node2 || edge.n2 != node) continue;
            return edge;
        }
        return null;
    }

    protected Node findNode(Node node) {
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            Node node2 = (Node)enumeration.nextElement();
            if (node != node2) continue;
            return node;
        }
        return null;
    }

    public Node findNode(String string) {
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (!string.equals(node.getLabel())) continue;
            return node;
        }
        return null;
    }

    public void show() {
        GraphPrinter.show(this);
    }

    public void show(Node node) {
        GraphPrinter.show(node);
    }

    public void showDot(String string) {
        GraphPrinter.showDot(string, this, this.directed);
    }

    public static void internal_test() {
        Test.start("Graph");
        Graph graph = new Graph(false);
        Node node = graph.addNode();
        Node node2 = graph.addNode();
        Node node3 = graph.addNode();
        graph.addEdge(node, node2);
        graph.addEdge(node, node2);
        graph.addEdge(node2, node);
        Test.checkEquality(graph.numOfNodes(), 3, "numOfNodes (1)");
        Test.checkEquality(graph.numOfEdges(), 1, "numOfEdges (1)");
        graph.removeNode(node);
        Test.checkEquality(graph.numOfNodes(), 2, "numOfNodes (2)");
        Test.checkEquality(graph.numOfEdges(), 0, "numOfEdges (2)");
        Graph graph2 = new Graph(true);
        Node node4 = graph2.addNode();
        Node node5 = graph2.addNode();
        Node node6 = graph2.addNode();
        Edge edge = graph2.addEdge(node4, node5);
        Edge edge2 = graph2.addEdge(node4, node5);
        Edge edge3 = graph2.addEdge(node5, node4);
        Test.check(edge == edge2);
        Test.checkEquality(graph2.numOfNodes(), 3, "numOfNodes (3)");
        Test.checkEquality(graph2.numOfEdges(), 2, "numOfEdges (3)");
        graph2.removeEdge(edge3);
        graph2.removeNode(node6);
        Test.checkEquality(graph2.numOfNodes(), 2, "numOfNodes (4)");
        Test.checkEquality(graph2.numOfEdges(), 1, "numOfEdges (4)");
        Node node7 = graph2.addNode();
        graph2.addNode(node6);
        Test.check(node6.firstOut == null, "n23 connected no where yet...");
        Edge edge4 = graph2.addEdge(node6, node7);
        Test.check(node6.firstOut == edge4, "n23 connected to n24 now...");
        Test.check(node6.firstOut.n1 == node6, "linked list consitency (1)");
        Test.check(node6.firstOut.n2 == node7, "linked list consitency (2)");
        Test.checkEquality(graph2.numOfNodes(), 4, "numOfNodes (5)");
        Test.checkEquality(graph2.numOfEdges(), 2, "numOfEdges (5)");
        graph2.removeNode(node7);
        Test.check(node6.firstOut == null, "n23 connected nowhere again...");
        Test.checkEquality(graph2.numOfNodes(), 3, "numOfNodes (6)");
        Test.checkEquality(graph2.numOfEdges(), 1, "numOfEdges (6)");
        Test.check(node4.firstOut != null && node4.firstOut.next == null, "linked list consitency (3)");
        Node node8 = graph2.addNode();
        Edge edge5 = graph2.addEdge(node5, node6);
        Edge edge6 = graph2.addEdge(node5, node8);
        Test.checkEquality(graph2.numOfEdges(), 3, "numOfEdges (7)");
        graph2.removeNode(node6);
        Test.check(node6.firstIn == null, "firstIn (1)");
        Test.check(node8.firstIn == edge6, "firstIn (2)");
        Test.checkEquality(graph2.numOfEdges(), 2, "numOfEdges (8)");
        Test.end();
    }
}

