/*
 * Decompiled with CFR 0.152.
 */
package jdd.des.petrinets;

import jdd.des.petrinets.PetrinetIO;
import jdd.des.petrinets.Place;
import jdd.des.petrinets.PlaceEnumeration;
import jdd.des.petrinets.Transition;
import jdd.des.petrinets.TransitionEnumeration;
import jdd.util.Array;
import jdd.util.Test;
import jdd.util.math.BitMatrix;

public class Petrinet {
    private int num_places;
    private int num_transitions;
    private int curr_places;
    private int curr_transitions;
    Place[] places;
    Transition[] transitions;
    BitMatrix a_plus;
    BitMatrix a_minus;
    int[] M_i;

    public Petrinet(int n, int n2) {
        this.num_places = n;
        this.num_transitions = n2;
        this.curr_transitions = 0;
        this.curr_places = 0;
        this.places = new Place[this.num_places];
        this.transitions = new Transition[this.num_transitions];
        this.a_plus = new BitMatrix(n2, n);
        this.a_minus = new BitMatrix(n2, n);
        this.M_i = new int[n];
        Array.set(this.M_i, 0);
    }

    public int numberOfPlaces() {
        return this.curr_places;
    }

    public int numberOfTransitions() {
        return this.curr_transitions;
    }

    public Transition getTransitionByIndex(int n) {
        return this.transitions[n];
    }

    public Place getPlaceByIndex(int n) {
        return this.places[n];
    }

    public void add(Place place) {
        if (this.curr_places >= this.num_places) {
            return;
        }
        this.places[this.curr_places] = place;
        place.index = this.curr_places;
        this.M_i[this.curr_places] = place.getTokens();
        ++this.curr_places;
    }

    public void add(Transition transition) {
        if (this.curr_transitions >= this.num_transitions) {
            return;
        }
        this.transitions[this.curr_transitions] = transition;
        transition.index = this.curr_transitions++;
    }

    public void add(Place place, Transition transition) {
        this.a_minus.set(transition.index, place.index);
    }

    public void add(Transition transition, Place place) {
        this.a_plus.set(transition.index, place.index);
    }

    public TransitionEnumeration createTransitionEnumeration() {
        return new TransitionEnumeration(this);
    }

    public void incomingTransitions(TransitionEnumeration transitionEnumeration, Place place) {
        transitionEnumeration.init(place.index, this.num_places, this.num_transitions, this.a_plus.getSet());
    }

    public void outgoingTransitions(TransitionEnumeration transitionEnumeration, Place place) {
        transitionEnumeration.init(place.index, this.num_places, this.num_transitions, this.a_minus.getSet());
    }

    public PlaceEnumeration createPlaceEnumeration() {
        return new PlaceEnumeration(this);
    }

    public void incomingPlaces(PlaceEnumeration placeEnumeration, Transition transition) {
        placeEnumeration.init(transition.index * this.num_places, 1, this.num_places, this.a_minus.getSet());
    }

    public void outgoingPlaces(PlaceEnumeration placeEnumeration, Transition transition) {
        placeEnumeration.init(transition.index * this.num_places, 1, this.num_places, this.a_plus.getSet());
    }

    public void show() {
        PetrinetIO.show(this);
    }

    BitMatrix getAPlus() {
        return this.a_plus;
    }

    BitMatrix getAMinus() {
        return this.a_minus;
    }

    int[] getM() {
        return this.M_i;
    }

    public static void internal_test() {
        Test.start("Petrinet");
        Petrinet petrinet = new Petrinet(4, 3);
        Place place = new Place("p1", 1);
        Place place2 = new Place("p2", 0);
        Place place3 = new Place("p3", 0);
        Place place4 = new Place("p4", 0);
        petrinet.add(place);
        petrinet.add(place2);
        petrinet.add(place3);
        petrinet.add(place4);
        Test.checkEquality(petrinet.numberOfPlaces(), 4, "4 places");
        Test.check(petrinet.M_i[0] == 1);
        Test.check(petrinet.M_i[1] == 0);
        Test.check(petrinet.M_i[2] == 0);
        Test.check(petrinet.M_i[3] == 0);
        Transition transition = new Transition("t1");
        Transition transition2 = new Transition("t2");
        Transition transition3 = new Transition("t3");
        petrinet.add(transition);
        petrinet.add(transition2);
        petrinet.add(transition3);
        Test.checkEquality(petrinet.numberOfTransitions(), 3, "3 transitions");
        petrinet.add(place, transition);
        petrinet.add(place, transition2);
        petrinet.add(transition, place2);
        petrinet.add(transition, place3);
        petrinet.add(transition2, place3);
        petrinet.add(place3, transition3);
        petrinet.add(transition3, place4);
        TransitionEnumeration transitionEnumeration = petrinet.createTransitionEnumeration();
        petrinet.incomingTransitions(transitionEnumeration, place3);
        Test.checkEquality(transitionEnumeration.getSize(), 2, " | -p3 |");
        petrinet.outgoingTransitions(transitionEnumeration, place3);
        Test.checkEquality(transitionEnumeration.getSize(), 1, " | p3- |");
        PlaceEnumeration placeEnumeration = petrinet.createPlaceEnumeration();
        petrinet.incomingPlaces(placeEnumeration, transition2);
        Test.checkEquality(placeEnumeration.getSize(), 1, " | *t2 |");
        petrinet.outgoingPlaces(placeEnumeration, transition);
        Test.checkEquality(placeEnumeration.getSize(), 2, " | t1* |");
        Test.end();
    }
}

