#!/usr/bin/ruby
# -*- coding:utf-8 -*-

require 'nkf'


# ==============================================================================
# get_neologd_entries
# ==============================================================================

get_neologd_entries = Proc.new do
	file = File.new("id.def", "r")
		lines = file.readlines
	file.close

	id_num = []
	id_str = []
	p = 0

	# mozcの品詞idと品詞漢字のペアを作る
	# (例) 品詞id 品詞漢字
	# (例) 1827 名詞,一般,*,*,*,*,*
	# 収録対象は一般名詞と固有名詞
	lines.length.times do |i|
		s = lines[i].chomp

		# neologdの品詞漢字はmozcの品詞漢字より要素が1つ少ないので、
		# mozcの品詞漢字の最後の要素をカットする
		# (mozc) 1827 名詞,一般,*,*,*,*,*
		# (neol) 1285 名詞,一般,*,*,*,*
		if s.index(" 名詞,一般,*,*,*,*,*") != nil
			s = s.split(",")[0..-2].join(",")
			s = s.split(" ")
			id_num[p] = s[0]
			id_str[p] = s[1]
			p = p + 1
		elsif s.index(" 名詞,固有名詞,") != nil &&
		# 地域名のidは除外する
		# neologdに含まれる地域名のバリエーションは多すぎるので、
		# 地域名は郵便番号データから生成する。
		# そうすることで最新の地名を収録できるメリットもある
		s.index(",地域,") == nil
			s = s.split(",")[0..-2].join(",")
			s = s.split(" ")
			id_num[p] = s[0]
			id_str[p] = s[1]
			p = p + 1
		end
	end

	# mecab-user-dict-seedを読み込む
	file = File.new($filename, "r")
		lines = file.readlines
	file.close

	l2 = []
	p = 0

	# mecab-user-dict-seedをmozc形式に変換
	lines.length.times do |i|
		# 並びの例
		# 古城,1288,1288,4607,名詞,固有名詞,一般,*,*,*,古城,コジョウ,コジョー
		s = lines[i].chomp.split(",")

		# neologの漢字品詞にマッチするmozcの漢字品詞の配列番号を取得
		hinsi = s[4..-4].join(",")
		hinsi = id_str.index(hinsi)

		# 収録対象外の品詞idだった場合はスキップ
		if hinsi == nil
			next
		end

		# mozcの漢字品詞の配列番号からmozcの品詞idを取得
		id = id_num[hinsi]

		# 英数字のみの表記を除外
		if s[-3].length == s[-3].bytesize ||
		# 20文字を超える表記を除外
		s[-3].length > 20 ||
		# 1文字の表記を除外
		s[-3].length == 1 ||
		# 数字を含む表記を除外
		# 「712円」「青森県道39号」「第1231話」などキリがないので
		s[-3].match(/[0-9]/) != nil ||
		s[-3].match(/会社|法人|議会|選挙/) != nil ||
		s[-2].match(/カブシキ(ガイシャ|カイシャ)|ユウゲン(ガイシャ|カイシャ)/) != nil ||
		s[-3].match(/村立|町立|市立|区立|県立/) != nil ||
		s[-3].match(/村営|町営|市営|市歌|県営/) != nil ||
		s[-3].match(/北海道|青森県|岩手県|宮城県|秋田県/) != nil ||
		s[-3].match(/山形県|福島県|東京都|神奈川県|埼玉県/) != nil ||
		s[-3].match(/千葉県|茨城県|栃木県|群馬県|山梨県/) != nil ||
		s[-3].match(/新潟県|長野県|富山県|石川県|福井県/) != nil ||
		s[-3].match(/愛知県|岐阜県|静岡県|三重県|大阪府/) != nil ||
		s[-3].match(/兵庫県|京都府|滋賀県|奈良県|和歌山県/) != nil ||
		s[-3].match(/鳥取県|島根県|岡山県|広島県|山口県/) != nil ||
		s[-3].match(/徳島県|香川県|愛媛県|高知県|福岡県/) != nil ||
		s[-3].match(/佐賀県|長崎県|熊本県|大分県|宮崎県/) != nil ||
		s[-3].match(/鹿児島県|沖縄県/) != nil
			next
		end

		# 読み,表記,id の順に並べる
		l2[p] = [s[-2], s[-3], id]
		p = p + 1
	end

	lines = l2
	l2 = []
	lines = lines.sort

	# 単語フィルタを読み込む
	file = File.new("../src/filter.txt", "r")
		filter = file.readlines
	file.close

	filter.length.times do |i|
		# 単語が正規表現になっている場合は正規表現を生成する
		if filter[i].index("/") == 0
			filter[i] = /#{filter[i].chomp[1..-2]}/
		else
			filter[i] = filter[i].chomp
		end
	end

	# フィルタリング対象のidを指定
	id_filter = id_num[id_str.index("名詞,固有名詞,一般,*,*,*")]

	dicfile = File.new("neologd.pairs", "w")

	lines.length.times do |i|
		s1 = lines[i]
		s2 = lines[i - 1]

		# 読み+表記が重複するエントリを除外
		if s1[0..1] == s2[0..1] ||
		# 読みの文字数より表記の文字数が多いものを除外
		# （例）ミョウジョウ 明星食品株式会社
		s1[0].length < s1[1].length ||
		# 読みの文字数が表記の文字数の4倍以上のものを除外
		# 多少の不具合が出るかもしれないが割り切る
		# （例）アカシショウガッコウアカイシショウガッコウ 明石小学校
		s1[0].length >= s1[1].length * 4
			next
		end

		# フィルタリング対象のエントリをチェック
		if s1[2] == id_filter
			filter.length.times do |c|
				if s1[1].index(filter[c]) != nil
					s1[1] = ""
					break
				end
			end
		end

		if s1[1] == ""
			next
		end

		# mozc形式のneologd.txtを出力
		# 読みのカタカナをひらがなに変換
		# 「tr('ァ-ヴ', 'ぁ-ゔ')」よりnkfのほうが速い
		yomi = NKF.nkf("--hiragana -w -W", s1[0])
		yomi = yomi.tr('ゐゑ', 'いえ')

		# 読みと表記のペアを作る
		dicfile.puts yomi + "	" + s1[1]
	end

	dicfile.close
end


# ==============================================================================
# main
# ==============================================================================

targetfiles = ARGV

if ARGV == []
	puts "Usage: ruby script.rb [FILE]"
	exit
end

targetfiles.length.times do |i|
	$filename = targetfiles[i]

	get_neologd_entries.call
end
