# This program computes running time averaged over <numtimes> runs
# excluding the lowest and highest values. 
# This program must be used together with run.py.

import subprocess
import sys
import os
from pathlib import Path
import re

def pretty_print(arg):
    isfirst = 1
    for element in arg:
        if isfirst == 1:
            st = str(element)
            isfirst = 0
        else:
            st = st + "\t" + str(element)
    print(st)

strengths = [2, 3]
# times of repetition
numtimes = 12

# acts
p = Path("./")
actsfiles = list(p.glob("**/*.acts"))
modes = [(" -Dchandler=no ", ".noconst"), (" -Dchandler=solver ", ".csp"), \
(" ", ".mft")]

for inp in actsfiles:
    input = str(inp)
    for strength in strengths:
        for mode in modes:
            (commandoption, filesuffix) = mode
            output = input + "." + str(strength) + filesuffix
            outputlog = output + ".stat"
            filename = os.path.basename(input)
            name, ext = os.path.splitext(filename)
            chandler = filesuffix[1:]
            row = [name, "acts", chandler, strength]
            runtimes = []
 
            for i in range(0, numtimes):
                logfile = outputlog + str(i).zfill(2)
                if os.path.isfile(logfile):
                    with open(logfile, "r") as outfile:
                        lines = outfile.readlines()
                        for line in lines:
                            if "Time (seconds)" in line:
                                runtime = re.search(r'([+-]?[0-9]+\.?[0-9]*)',line).group(0)
                                runtimes.append(float(runtime))
#            print(runtimes)
            if len(runtimes) > 2:
                min_value = min(runtimes)
                max_value = max(runtimes)
                ave_value = (sum(runtimes) - min_value - max_value) / (len(runtimes)-2)
                row.append(ave_value)
            else:
                row.append("NA")
            pretty_print(row)

# bach (ipogbdd)
p = Path("./")
bachfiles = list(p.glob("**/*.bach"))
modes = [(" -chandler no ", ".noconst"), (" -chandler up ", ".bddup"), \
(" -chandler down ", ".bdddown"), (" -chandler conj ", ".bddconj"), \
(" -chandler sat ", ".sat")]
# modes = [(" -chandler down ", ".bdddown"), (" -chandler sat ", ".sat")]

for inp in bachfiles:
    input = str(inp)
    for strength in strengths:
        for mode in modes:
            (commandoption, filesuffix) = mode
            output = input + "." + str(strength) + filesuffix
            outputlog = output + ".stat"
            filename = os.path.basename(input)
            name, ext = os.path.splitext(filename)
            chandler = filesuffix[1:]
            row = [name, "bach", chandler, strength]
            runtimes = []
 
            for i in range(0, numtimes):
                logfile = outputlog + str(i).zfill(2)
                if os.path.isfile(logfile):
                    with open(logfile, "r") as outfile:
                        lines = outfile.readlines()
                        for line in lines:
                            if "Time (seconds)" in line:
                                runtime = re.search(r'([+-]?[0-9]+\.?[0-9]*)',line).group(0)
                                runtimes.append(float(runtime))
 #           print(runtimes)
            if len(runtimes) > 2:
                min_value = min(runtimes)
                max_value = max(runtimes)
                ave_value = (sum(runtimes) - min_value - max_value) / (len(runtimes)-2)
                row.append(ave_value)
            else:
                row.append("NA")
            pretty_print(row)
