/*
 * Decompiled with CFR 0.152.
 */
package bits;

import bits.INumber;
import naturalnumbers.NaturalNumber;
import naturalnumbers.exceptions.NumberException;

public class Number
implements INumber {
    private boolean[] bitArray;
    private String name;
    private boolean overflow;

    public static void main(String[] args) throws NumberException {
        Number number1 = new Number(2401L);
        Number number2 = new Number(number1, 12);
        System.out.println(number1.toString());
        System.out.println(number2.toString());
    }

    public Number(boolean[] bitArray, boolean overflow) throws NumberException {
        this("", bitArray, overflow);
        this.setName(super.toString());
    }

    public Number(long n) throws NumberException {
        this("", n);
        this.setName(super.toString());
    }

    public Number(Number n, int padsize) throws NumberException {
        this("", n, padsize);
        this.setName(super.toString());
    }

    public Number(String name, boolean[] bitArray, boolean overflow) throws NumberException {
        if (bitArray == null) {
            throw new NumberException("A null bitArray was passed to a constructor.");
        }
        if (bitArray.length > NaturalNumber.getLength()) {
            throw new NumberException("Attempted to use too large of a number in Number constructor.");
        }
        this.setBitArray(bitArray);
        this.setOverflow(overflow);
        this.setName(name);
    }

    public Number(String name, long n) throws NumberException {
        if (n < 0L) {
            throw new NumberException("A negative long was passed to a constructor.");
        }
        if (n == 0L) {
            this.setBitArray(new boolean[1]);
            this.setOverflow(false);
            this.setName(name);
        }
        if (n > 0L) {
            int size = (int)(Math.log(n) / Math.log(2.0)) + 1;
            if (size > NaturalNumber.getLength()) {
                throw new NumberException("Attempted to use too large of a number in Number constructor.");
            }
            this.setBitArray(new boolean[size]);
            this.setOverflow(false);
            int count = 0;
            long current = n;
            while (current > 0L) {
                long bit = current - 2L * (current / 2L);
                if (bit == 1L) {
                    this.setBit(count, true);
                } else {
                    this.setBit(count, false);
                }
                current /= 2L;
                ++count;
            }
            this.setName(name);
        }
    }

    public Number(String name, Number n, int padsize) throws NumberException {
        if (n == null) {
            throw new NumberException("A null Number was passed to a constructor.");
        }
        if (padsize < 0) {
            throw new NumberException("A negative int was passed to a constructor.");
        }
        if (n.getSize() < padsize) {
            this.setBitArray(new boolean[padsize]);
            int i = 0;
            while (i < n.getSize()) {
                this.setBit(i, n.getBit(i));
                ++i;
            }
        } else {
            if (n.getSize() > NaturalNumber.getLength()) {
                throw new NumberException("Attempted to use too large of a number in Number constructor.");
            }
            this.setBitArray(new boolean[n.getSize()]);
            int i = 0;
            while (i < n.getSize()) {
                this.setBit(i, n.getBit(i));
                ++i;
            }
        }
        this.setName(name);
    }

    public boolean equals(Number n) {
        if (n == null) {
            return false;
        }
        if (!(n instanceof Number)) {
            return false;
        }
        return this.getName().compareTo(n.getName()) == 0;
    }

    @Override
    public boolean getBit(int i) throws NumberException {
        if (i < 0 || i > this.getSize() - 1) {
            throw new NumberException("Attempted to index out of range in method getBit.");
        }
        return this.getBitArray()[i];
    }

    @Override
    public boolean[] getBitArray() {
        return this.bitArray;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getSize() {
        return this.bitArray.length;
    }

    public boolean isOverflow() {
        return this.overflow;
    }

    @Override
    public void setBit(int i, boolean b) throws NumberException {
        if (i < 0 || i > this.getSize() - 1) {
            throw new NumberException("Attempted to index out of range in method setBit.");
        }
        this.getBitArray()[i] = b;
    }

    @Override
    public void setBitArray(boolean[] bitArray) throws NumberException {
        if (bitArray == null) {
            throw new NumberException("A null boolean[] was passed to a constructor.");
        }
        this.bitArray = bitArray;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setOverflow(boolean overflow) {
        this.overflow = overflow;
    }

    public String toString() {
        String res = "<";
        res = String.valueOf(res) + this.name + "=";
        int i = this.getSize() - 1;
        while (i >= 0) {
            try {
                res = this.getBit(i) ? String.valueOf(res) + "1" : String.valueOf(res) + "0";
            }
            catch (NumberException e) {
                e.printStackTrace();
            }
            --i;
        }
        res = String.valueOf(res) + ">";
        return res;
    }
}

