/*
 * Decompiled with CFR 0.152.
 */
package bits;

import bits.BooleanLiteral;
import bits.BooleanVariable;
import bits.Conjunction;
import bits.IBooleanLiteral;
import bits.IBooleanVariable;
import bits.IClause;
import bits.IProblem;
import bits.Problem;
import bits.exceptions.ClauseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Clause
extends ArrayList<IBooleanLiteral>
implements IClause {
    private static final long serialVersionUID = -9088489304501148454L;

    public static IClause newClause() {
        return new Clause();
    }

    public static IClause randomClause(IBooleanVariable[] bv) throws Exception {
        IClause ret = Clause.newClause();
        int number = bv.length;
        int i = 0;
        while (i < number) {
            double r = Math.random();
            int choice = (int)(3.0 * r);
            if (choice == 0) {
                // empty if block
            }
            if (choice == 1) {
                ret.add((BooleanLiteral)BooleanLiteral.getBooleanLiteral(bv[i], false));
            }
            if (choice == 2) {
                ret.add((BooleanLiteral)BooleanLiteral.getBooleanLiteral(bv[i], true));
            }
            ++i;
        }
        return ret;
    }

    @Override
    public boolean add(BooleanLiteral b) throws Exception {
        if (b == null) {
            throw new ClauseException("A null IBooleanLiteral was passed to the add method.");
        }
        if (!this.contains(b)) {
            super.add(b);
            return true;
        }
        return false;
    }

    @Override
    public void addLiteral(IBooleanLiteral bl) throws Exception {
        if (bl == null) {
            throw new ClauseException("Null IBooleanLiteral was passed to addLiteral method.");
        }
        this.add(bl);
    }

    @Override
    public Object clone() {
        try {
            return this.duplicate();
        }
        catch (Exception e) {
            System.out.println("Attempt failed to use method clone.");
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int compareTo(IClause o) throws Exception {
        if (o == null) {
            throw new ClauseException("A null Object was passed to the compareTo method.");
        }
        int d = super.size() - ((ArrayList)((Object)o)).size();
        if (d != 0) {
            return d;
        }
        Object[] thisIt = this.toArray();
        Arrays.sort(thisIt);
        IBooleanLiteral thisFirst = (IBooleanLiteral)thisIt[0];
        Object[] oIt = o.toArray();
        Arrays.sort(oIt);
        IBooleanLiteral oFirst = (IBooleanLiteral)oIt[0];
        return thisFirst.compareTo(oFirst);
    }

    @Override
    public int compareTo(Object o) {
        try {
            return this.compareTo((IClause)o);
        }
        catch (Exception e) {
            System.out.println("The compareTo method failed on Object " + o + ".");
            e.printStackTrace();
            return Integer.MAX_VALUE;
        }
    }

    @Override
    public boolean contains(IBooleanLiteral bl) throws Exception {
        if (bl == null) {
            throw new ClauseException("A null IBooleanLiteral was passed to the contains method.");
        }
        for (IBooleanLiteral obj : this) {
            IBooleanLiteral blc = obj;
            if (!blc.equals(bl)) continue;
            return true;
        }
        return false;
    }

    public IBooleanLiteral differsSinglyFrom(IClause c) throws Exception {
        IBooleanVariable cminusthisbv;
        if (c == null) {
            return null;
        }
        if (this.size() != c.size()) {
            return null;
        }
        IClause thisminusc = this.minus(c);
        if (thisminusc.size() != 1) {
            return null;
        }
        IClause cminusthis = ((Clause)c).minus(this);
        if (cminusthis.size() != 1) {
            return null;
        }
        IBooleanLiteral thisminuscbl = thisminusc.getLiteralAt(0);
        IBooleanVariable thisminuscbv = thisminuscbl.getBooleanVariable();
        if (!thisminuscbv.equals(cminusthisbv = cminusthis.getLiteralAt(0).getBooleanVariable())) {
            return null;
        }
        return thisminuscbl;
    }

    public boolean dominates(IClause clause) throws Exception {
        if (clause == null) {
            return true;
        }
        if (this.isEmpty()) {
            return true;
        }
        int i = 0;
        while (i < this.size()) {
            if (!clause.contains(this.getLiteralAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Object duplicate() throws Exception {
        Clause cl = new Clause();
        int i = 0;
        while (i < this.size()) {
            cl.add((BooleanLiteral)this.getLiteralAt(i));
            ++i;
        }
        return cl;
    }

    @Override
    public boolean equals(IClause o) throws Exception {
        if (o == null) {
            throw new ClauseException("Null IClause was passed to method equals.");
        }
        if (o == this) {
            return true;
        }
        IClause ic = o;
        if (!this.dominates(ic)) {
            return false;
        }
        return ((Clause)o).dominates(this);
    }

    @Override
    public boolean evaluate() {
        Iterator<IBooleanLiteral> it = this.iterator();
        while (it.hasNext()) {
            if (!it.next().evaluate()) continue;
            return true;
        }
        return false;
    }

    @Override
    public IBooleanVariable[] getBooleanVariables() {
        ArrayList<IBooleanVariable> res = new ArrayList<IBooleanVariable>();
        IBooleanLiteral[] bl = this.toArray();
        int i = 0;
        while (i < bl.length) {
            IBooleanVariable curr = bl[i].getBooleanVariable();
            if (!res.contains(curr)) {
                res.add(curr);
            }
            ++i;
        }
        return res.toArray(new IBooleanVariable[0]);
    }

    @Override
    public void getBooleanVariables(List<IBooleanVariable> hs) throws Exception {
        if (hs == null) {
            throw new ClauseException("A null List was passed to the getBooleanVariables method.");
        }
        IBooleanLiteral[] bl = this.toArray(new IBooleanLiteral[0]);
        int i = 0;
        while (i < bl.length) {
            hs.add(bl[i].getBooleanVariable());
            ++i;
        }
    }

    @Override
    public IBooleanLiteral getLiteralAt(int n) throws ClauseException {
        if (n < 0) {
            throw new ClauseException("A negative number was passed to getLiteralAt method.");
        }
        return (IBooleanLiteral)super.get(n);
    }

    public IClause intersection(IClause clause) throws Exception {
        if (clause == null) {
            return null;
        }
        if (this.isEmpty()) {
            return this;
        }
        IClause ret = Clause.newClause();
        for (IBooleanLiteral curr : this) {
            if (!clause.contains(curr)) continue;
            ret.add((BooleanLiteral)curr);
        }
        return ret;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean isMemberOf(List<IClause> h) throws Exception {
        if (h == null) {
            throw new ClauseException("A null List was passed to isMemberOf method.");
        }
        for (IClause obj : h) {
            IClause curr = obj;
            if (!curr.equals(this)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSatisfied() {
        return this.evaluate();
    }

    public boolean isSensitiveTo(IBooleanVariable bv) throws ClauseException {
        if (bv == null) {
            throw new ClauseException("A null IBooleanVariable was passed to isSensitiveTo method.");
        }
        for (IBooleanLiteral bl : this) {
            if (!bv.equals(bl.getBooleanVariable())) continue;
            boolean startValue = this.evaluate();
            bv.setValue(!bv.getValue());
            boolean endValue = this.evaluate();
            bv.setValue(!bv.getValue());
            if (startValue == endValue) continue;
            return true;
        }
        return false;
    }

    public boolean isSingleton() {
        return this.size() == 1;
    }

    @Override
    public Iterator<IBooleanLiteral> iterator() {
        return super.iterator();
    }

    public IClause minus(IClause o) throws Exception {
        if (o == null) {
            throw new ClauseException("Null IClause was passed to minus method.");
        }
        IClause ret = (IClause)this.clone();
        int i = 0;
        while (i < o.size()) {
            ret.remove(o.getLiteralAt(i));
            ++i;
        }
        return ret;
    }

    @Override
    public IClause nor(IBooleanVariable bv) throws Exception {
        return this.orNot(bv);
    }

    @Override
    public IClause or(IBooleanVariable bv) throws Exception {
        if (bv == null) {
            throw new ClauseException("A null IBooleanVariable was passed to the or method.");
        }
        this.addLiteral(BooleanLiteral.getBooleanLiteral(bv, false));
        return this;
    }

    @Override
    public IClause orNot(IBooleanVariable bv) throws Exception {
        if (bv == null) {
            throw new ClauseException("A null IBooleanVariable was passed to the orNot method.");
        }
        this.addLiteral(BooleanLiteral.getBooleanLiteral(bv, true));
        return this;
    }

    @Override
    public boolean remove(IBooleanLiteral b) {
        return super.remove(b);
    }

    @Override
    public IBooleanLiteral removeClause(int i) {
        return (IBooleanLiteral)super.remove(i);
    }

    @Override
    public IClause resolve(IBooleanLiteral ib) throws Exception {
        if (ib == null) {
            throw new ClauseException("Null IBooleanLiteral was passed to resolve method.");
        }
        return this.resolve(ib.getBooleanVariable(), !ib.isBarred());
    }

    @Override
    public IClause resolve(IBooleanVariable b, boolean value) throws Exception {
        if (b == null) {
            throw new ClauseException("Null IBooleanVariable was passed to resolve method.");
        }
        IClause c = (IClause)this.clone();
        for (IBooleanLiteral obj : this) {
            IBooleanLiteral bl = obj;
            if (!bl.getBooleanVariable().equals(b)) continue;
            if (bl.isBarred() == value) {
                c.remove(bl);
                continue;
            }
            c = null;
            break;
        }
        return c;
    }

    @Override
    public int size() {
        return super.size();
    }

    public IClause substitute(Map<IBooleanLiteral, IBooleanLiteral> h) throws Exception {
        if (h == null) {
            throw new ClauseException("Null java.util.Map was passed to substitute method.");
        }
        boolean didsomething = true;
        while (didsomething) {
            didsomething = false;
            int i = 0;
            while (i < this.size()) {
                IBooleanLiteral ib = this.getLiteralAt(i);
                IBooleanLiteral tr = h.get(ib);
                if (tr != null && tr instanceof IBooleanLiteral && !tr.equals(ib)) {
                    this.removeClause(i);
                    this.add(tr);
                    didsomething = true;
                }
                ++i;
            }
        }
        return this;
    }

    public IClause substitute(Map<IBooleanLiteral, IBooleanLiteral> h, IClause c) throws Exception {
        if (h == null) {
            throw new ClauseException("Null java.util.Map was passed to substitute method.");
        }
        boolean didsomething = true;
        while (didsomething) {
            didsomething = false;
            int i = 0;
            while (i < c.size()) {
                IBooleanLiteral ib = c.getLiteralAt(i);
                IBooleanLiteral tr = h.get(ib);
                if (tr != null && tr instanceof IBooleanLiteral && !tr.equals(ib)) {
                    c.removeClause(i);
                    c.add((BooleanLiteral)tr);
                    didsomething = true;
                }
                ++i;
            }
        }
        return this;
    }

    public IProblem ThreeSATProblem() throws Exception {
        if (this.size() < 4) {
            return new Problem(new IClause[]{this});
        }
        Clause left = new Clause();
        left.add(this.getLiteralAt(0));
        left.add(this.getLiteralAt(1));
        Clause right = new Clause();
        int i = 2;
        while (i < this.size()) {
            right.add(this.getLiteralAt(i));
            ++i;
        }
        IBooleanVariable bv = BooleanVariable.getBooleanVariable();
        IBooleanLiteral blunbarred = BooleanLiteral.getBooleanLiteral(bv, false);
        IBooleanLiteral blbarred = BooleanLiteral.getBooleanLiteral(bv, true);
        left.add(blunbarred);
        right.add(blbarred);
        Conjunction problem = new Conjunction(left.ThreeSATProblem(), right.ThreeSATProblem());
        return problem;
    }

    @Override
    public IBooleanLiteral[] toArray() {
        return super.toArray(new IBooleanLiteral[0]);
    }

    @Override
    public String toCode() throws ClauseException {
        if (this.size() < 1) {
            return null;
        }
        String ret = ((BooleanLiteral)this.getLiteralAt(0)).toCode();
        int i = 1;
        while (i < this.size()) {
            ret = String.valueOf(ret) + "*" + ((BooleanLiteral)this.getLiteralAt(i)).toCode();
            ++i;
        }
        return ret;
    }

    @Override
    public IBooleanLiteral[] toSortedArray() {
        Object[] obj = this.toArray(new IBooleanLiteral[0]);
        Arrays.sort(obj);
        return obj;
    }

    @Override
    public String toString() {
        String res = "{";
        IBooleanLiteral[] obj = this.toSortedArray();
        int j = 0;
        while (j < obj.length) {
            res = String.valueOf(res) + obj[j];
            ++j;
        }
        return String.valueOf(res) + "}";
    }

    public IProblem unsatisfiedClause() throws Exception {
        int literals = this.size();
        if (literals == 0) {
            return Problem.trivialProblem();
        }
        Problem p = new Problem();
        int lit = 0;
        while (lit < literals) {
            BooleanLiteral curr = (BooleanLiteral)this.getLiteralAt(lit);
            IBooleanVariable currbv = curr.getBooleanVariable();
            IBooleanLiteral newcurr = BooleanLiteral.getBooleanLiteral(currbv, !curr.isBarred());
            Clause currcl = new Clause();
            currcl.add((BooleanLiteral)newcurr);
            p.add(currcl);
            ++lit;
        }
        return p;
    }
}

