/*
 * Decompiled with CFR 0.152.
 */
package v1;

import java.util.TreeSet;
import v1.AtomicExpressionForVariableOrdering;
import v1.EqualTo;
import v1.Error;
import v1.GTE;
import v1.GreaterThan;
import v1.LTE;
import v1.LessThan;
import v1.Main;
import v1.NoParameterNameException;
import v1.OutOfTokenStreamException;
import v1.PList;
import v1.RelationOverDoublePair;
import v1.TokenHandler;
import v1.VOAndOperator;
import v1.VOEqualityOperator;
import v1.VOIfOperator;
import v1.VOIfthenelseOperator;
import v1.VOInequalityOperator;
import v1.VONode;
import v1.VONotOperator;
import v1.VOOrOperator;

class ParseForVariableOrdering {
    private TokenHandler t;
    private PList parameterList;
    private TreeSet<Integer> constrainedParameters = new TreeSet();
    int[][] distance;

    ParseForVariableOrdering(TokenHandler t, PList parameterList) {
        this.t = t;
        this.parameterList = parameterList;
        this.distance = new int[parameterList.size()][parameterList.size()];
        int i = 0;
        while (i < parameterList.size()) {
            int j = 0;
            while (j < parameterList.size()) {
                this.distance[i][j] = -1;
                ++j;
            }
            ++i;
        }
    }

    VONode parseExpression() {
        String nextToken;
        block4: {
            nextToken = this.t.peepToken();
            try {
                if (nextToken != null) break block4;
                Error.printError(Main.language == Main.Language.JP ? "\u5236\u7d04\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059" : "Invalid constraints");
                return null;
            }
            catch (OutOfTokenStreamException e) {
                Error.printError(Main.language == Main.Language.JP ? "\u5236\u7d04\u5f0f\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059" : "Invalid constraints");
                return null;
            }
        }
        if (nextToken.equals("(")) {
            return this.expressionWithParentheses();
        }
        Error.printError(Main.language == Main.Language.JP ? "\u5236\u7d04\u306b'('\u304c\u3042\u308a\u307e\u305b\u3093" : "( expected in constraints");
        return null;
    }

    private VONode expressionWithParentheses() throws OutOfTokenStreamException {
        String token = this.t.getToken();
        if (!token.equals("(")) {
            Error.printError(Main.language == Main.Language.JP ? "\u5236\u7d04\u306b'('\u304c\u3042\u308a\u307e\u305b\u3093" : "( expected in constraints");
            return null;
        }
        if (this.t.peepToken() == null) {
            throw new OutOfTokenStreamException();
        }
        VONode res = this.t.peepToken().equals("(") ? this.expressionWithParentheses() : this.expressionBody();
        if (!this.t.getToken().equals(")")) {
            Error.printError(Main.language == Main.Language.JP ? "\u5236\u7d04\u306b')'\u304c\u3042\u308a\u307e\u305b\u3093" : ") expected in constraints");
            return null;
        }
        return res;
    }

    private VONode expressionBody() throws OutOfTokenStreamException {
        String nextNextToken = this.t.peepNextToken();
        if (nextNextToken == null) {
            throw new OutOfTokenStreamException();
        }
        if (nextNextToken.equals("(")) {
            return this.boolExpression();
        }
        return this.atomExpression();
    }

    private VONode boolExpression() throws OutOfTokenStreamException {
        String token = this.t.peepToken();
        if (this.t.peepToken() == null) {
            throw new OutOfTokenStreamException();
        }
        if (token.equals("not")) {
            return this.notExpression();
        }
        if (token.equals("==")) {
            return this.equalityExpression();
        }
        if (token.equals("<>")) {
            return this.inequalityExpression();
        }
        if (token.equals("or")) {
            return this.orExpression();
        }
        if (token.equals("and")) {
            return this.andExpression();
        }
        if (token.equals("if")) {
            return this.ifExpression();
        }
        if (token.equals("ite")) {
            return this.iteExpression();
        }
        Error.printError(String.valueOf(token) + " is not a valid operator");
        return null;
    }

    private VONode notExpression() throws OutOfTokenStreamException {
        VONotOperator res = new VONotOperator();
        this.t.getToken();
        res.Child = this.parseExpression();
        return res;
    }

    private VONode equalityExpression() throws OutOfTokenStreamException {
        VOEqualityOperator res = new VOEqualityOperator();
        this.t.getToken();
        res.Left = this.parseExpression();
        res.Right = this.parseExpression();
        return res;
    }

    private VONode inequalityExpression() throws OutOfTokenStreamException {
        VOInequalityOperator res = new VOInequalityOperator();
        this.t.getToken();
        res.Left = this.parseExpression();
        res.Right = this.parseExpression();
        return res;
    }

    /*
     * Unable to fully structure code
     */
    private VONode orExpression() throws OutOfTokenStreamException {
        res = new VOOrOperator();
        this.t.getToken();
        res.ChildList.add(this.parseExpression());
        res.ChildList.add(this.parseExpression());
        if (this.t.peepToken() != null) ** GOTO lbl14
        throw new OutOfTokenStreamException();
lbl-1000:
        // 1 sources

        {
            res.ChildList.add(this.parseExpression());
            if (this.t.peepToken() != null) continue;
            throw new OutOfTokenStreamException();
lbl14:
            // 2 sources

            ** while (!this.t.peepToken().equals((Object)")"))
        }
lbl15:
        // 1 sources

        return res;
    }

    /*
     * Unable to fully structure code
     */
    private VONode andExpression() throws OutOfTokenStreamException {
        res = new VOAndOperator();
        this.t.getToken();
        res.ChildList.add(this.parseExpression());
        res.ChildList.add(this.parseExpression());
        if (this.t.peepToken() != null) ** GOTO lbl14
        throw new OutOfTokenStreamException();
lbl-1000:
        // 1 sources

        {
            res.ChildList.add(this.parseExpression());
            if (this.t.peepToken() != null) continue;
            throw new OutOfTokenStreamException();
lbl14:
            // 2 sources

            ** while (!this.t.peepToken().equals((Object)")"))
        }
lbl15:
        // 1 sources

        return res;
    }

    private VONode ifExpression() throws OutOfTokenStreamException {
        VOIfOperator res = new VOIfOperator();
        this.t.getToken();
        res.Left = this.parseExpression();
        res.Right = this.parseExpression();
        return res;
    }

    private VONode iteExpression() throws OutOfTokenStreamException {
        VOIfthenelseOperator res = new VOIfthenelseOperator();
        this.t.getToken();
        res.Left = this.parseExpression();
        res.Middle = this.parseExpression();
        res.Right = this.parseExpression();
        return res;
    }

    private VONode atomExpression() throws OutOfTokenStreamException {
        String token = this.t.getToken();
        if (token.equals("==")) {
            return this.equalityAtomExpression();
        }
        if (token.equals("<>")) {
            return this.inequalityAtomExpression();
        }
        if (token.equals("===")) {
            return this.arithmeticEqualityAtomExpression(new EqualTo(), new EqualTo());
        }
        if (token.equals("!==")) {
            return this.artithmeticInequalityAtomExpression(new EqualTo(), new EqualTo());
        }
        if (token.equals("<")) {
            return this.arithmeticEqualityAtomExpression(new LessThan(), new GreaterThan());
        }
        if (token.equals(">")) {
            return this.arithmeticEqualityAtomExpression(new GreaterThan(), new LessThan());
        }
        if (token.equals("<=")) {
            return this.arithmeticEqualityAtomExpression(new LTE(), new GTE());
        }
        if (token.equals(">=")) {
            return this.arithmeticEqualityAtomExpression(new GTE(), new LTE());
        }
        Error.printError(Main.language == Main.Language.JP ? "\u5236\u7d04\u5f0f\u306b == \u304b <> \u304c\u5fc5\u8981\u3067\u3059" : "== or <> expected in constraints");
        return null;
    }

    private VONode artithmeticInequalityAtomExpression(RelationOverDoublePair com1, RelationOverDoublePair com2) throws OutOfTokenStreamException {
        VONotOperator res = new VONotOperator();
        res.Child = this.arithmeticEqualityAtomExpression(com1, com2);
        return res;
    }

    private VONode inequalityAtomExpression() throws OutOfTokenStreamException {
        VONotOperator res = new VONotOperator();
        res.Child = this.equalityAtomExpression();
        return res;
    }

    private VONode arithmeticEqualityAtomExpression(RelationOverDoublePair com1, RelationOverDoublePair com2) throws OutOfTokenStreamException {
        String token1 = this.t.peepToken();
        String token2 = this.t.peepNextToken();
        if (token1 == null || token2 == null) {
            throw new OutOfTokenStreamException();
        }
        if (!token1.equals("[") && !token2.equals("[")) {
            String val1 = this.t.getToken();
            String val2 = this.t.getToken();
            return new AtomicExpressionForVariableOrdering(this.parameterList.size());
        }
        if (!token1.equals("[") && token2.equals("[")) {
            String val1 = this.t.getToken();
            this.t.getToken();
            String para1 = this.t.getToken();
            if (!this.t.getToken().equals("]")) {
                Error.printError(Main.language == Main.Language.JP ? "\u5236\u7d04\u5f0f\u306b]\u304c\u5fc5\u8981\u3067\u3059" : "] expected in constraints");
            }
            return this.compareArithmeticParameterAndValue(para1, val1, com2);
        }
        this.t.getToken();
        String para1 = this.t.getToken();
        if (!this.t.getToken().equals("]")) {
            Error.printError(Main.language == Main.Language.JP ? "\u5236\u7d04\u5f0f\u306b]\u304c\u5fc5\u8981\u3067\u3059" : "] expected in constraints");
        }
        if ((token1 = this.t.peepToken()) == null) {
            throw new OutOfTokenStreamException();
        }
        if (!token1.equals("[")) {
            String val1 = this.t.getToken();
            return this.compareArithmeticParameterAndValue(para1, val1, com1);
        }
        this.t.getToken();
        String para2 = this.t.getToken();
        if (!this.t.getToken().equals("]")) {
            Error.printError(Main.language == Main.Language.JP ? "\u5236\u7d04\u5f0f\u306b]\u304c\u5fc5\u8981\u3067\u3059" : "] expected in constraints");
        }
        return this.compareArithmeticParameterAndParameter(para1, para2, com1);
    }

    private VONode equalityAtomExpression() throws OutOfTokenStreamException {
        String token1 = this.t.peepToken();
        String token2 = this.t.peepNextToken();
        if (token1 == null || token2 == null) {
            throw new OutOfTokenStreamException();
        }
        if (!token1.equals("[") && !token2.equals("[")) {
            String val1 = this.t.getToken();
            String val2 = this.t.getToken();
            return new AtomicExpressionForVariableOrdering(this.parameterList.size());
        }
        if (!token1.equals("[") && token2.equals("[")) {
            String val1 = this.t.getToken();
            this.t.getToken();
            String para1 = this.t.getToken();
            if (!this.t.getToken().equals("]")) {
                Error.printError(Main.language == Main.Language.JP ? "\u5236\u7d04\u5f0f\u306b]\u304c\u5fc5\u8981\u3067\u3059" : "] expected in constraints");
            }
            return this.compareParameterAndValue(para1, val1);
        }
        this.t.getToken();
        String para1 = this.t.getToken();
        if (!this.t.getToken().equals("]")) {
            Error.printError(Main.language == Main.Language.JP ? "\u5236\u7d04\u5f0f\u306b]\u304c\u5fc5\u8981\u3067\u3059" : "] expected in constraints");
        }
        if ((token1 = this.t.peepToken()) == null) {
            throw new OutOfTokenStreamException();
        }
        if (!token1.equals("[")) {
            String val1 = this.t.getToken();
            return this.compareParameterAndValue(para1, val1);
        }
        this.t.getToken();
        String para2 = this.t.getToken();
        if (!this.t.getToken().equals("]")) {
            Error.printError(Main.language == Main.Language.JP ? "\u5236\u7d04\u5f0f\u306b]\u304c\u5fc5\u8981\u3067\u3059" : "] expected in constraints");
        }
        return this.compareParameterAndParameter(para1, para2);
    }

    private VONode compareParameterAndValue(String para, String val) {
        int parameterID = 0;
        try {
            parameterID = this.parameterList.getID(para);
            this.constrainedParameters.add(parameterID);
        }
        catch (NoParameterNameException e) {
            Error.printError(Main.language == Main.Language.JP ? "\u5236\u7d04\u4e2d\u306e\u56e0\u5b50\u540d\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059" : "Invalid parameter name in constraints");
        }
        return new AtomicExpressionForVariableOrdering(parameterID, this.parameterList.size());
    }

    private VONode compareArithmeticParameterAndValue(String para, String val, RelationOverDoublePair com) {
        int parameterID = 0;
        try {
            parameterID = this.parameterList.getID(para);
            this.constrainedParameters.add(parameterID);
        }
        catch (NoParameterNameException e) {
            Error.printError(Main.language == Main.Language.JP ? "\u5236\u7d04\u4e2d\u306e\u56e0\u5b50\u540d\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059" : "Invalid parameter name in constraints");
        }
        return new AtomicExpressionForVariableOrdering(parameterID, this.parameterList.size());
    }

    private VONode compareParameterAndParameter(String para1, String para2) {
        int parameterID1 = 0;
        int parameterID2 = 0;
        try {
            parameterID1 = this.parameterList.getID(para1);
            parameterID2 = this.parameterList.getID(para2);
            this.constrainedParameters.add(parameterID1);
            this.constrainedParameters.add(parameterID2);
        }
        catch (NoParameterNameException e) {
            Error.printError(Main.language == Main.Language.JP ? "\u5236\u7d04\u4e2d\u306e\u56e0\u5b50\u540d\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059" : "Invalid parameter name in constraints");
        }
        return new AtomicExpressionForVariableOrdering(parameterID1, parameterID2, this.parameterList.size());
    }

    private VONode compareArithmeticParameterAndParameter(String para1, String para2, RelationOverDoublePair com) {
        int parameterID1 = 0;
        int parameterID2 = 0;
        try {
            parameterID1 = this.parameterList.getID(para1);
            parameterID2 = this.parameterList.getID(para2);
            this.constrainedParameters.add(parameterID1);
            this.constrainedParameters.add(parameterID2);
        }
        catch (NoParameterNameException e) {
            Error.printError(Main.language == Main.Language.JP ? "\u5236\u7d04\u4e2d\u306e\u56e0\u5b50\u540d\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059" : "Invalid parameter name in constraints");
        }
        return new AtomicExpressionForVariableOrdering(parameterID1, parameterID2, this.parameterList.size());
    }
}

