/*
 * Decompiled with CFR 0.152.
 */
package jdd.util.math;

import jdd.util.Test;

public final class Prime {
    private static final int NUM_TRIALS = 8;

    private static final long witness(long l, long l2, long l3) {
        if (l2 == 0L) {
            return 1L;
        }
        long l4 = Prime.witness(l, l2 / 2L, l3);
        if (l4 == 0L) {
            return 0L;
        }
        long l5 = l4 * l4 % l3;
        if (l5 == 1L && l4 != 1L && l4 != l3 - 1L) {
            return 0L;
        }
        if (l2 % 2L == 1L) {
            l5 = l * l5 % l3;
        }
        return l5;
    }

    public static final boolean isPrime(int n) {
        if (n < 20 && (n == 1 || n == 2 || n == 3 || n == 5 || n == 7 || n == 11 || n == 13 || n == 17 || n == 19)) {
            return true;
        }
        if (n % 2 == 0 || n % 3 == 0 || n % 5 == 0 || n % 7 == 0 || n % 11 == 0 || n % 13 == 0 || n % 17 == 0 || n % 19 == 0) {
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            if (Prime.witness(2L + (long)(Math.random() * (double)(n - 2)), n - 1, n) == 1L) continue;
            return false;
        }
        return true;
    }

    public static final int nextPrime(int n) {
        if (n % 2 == 0) {
            ++n;
        }
        while (!Prime.isPrime(n)) {
            n += 2;
        }
        return n;
    }

    public static final int prevPrime(int n) {
        if (n % 2 == 0) {
            --n;
        }
        while (!Prime.isPrime(n)) {
            n -= 2;
        }
        return n;
    }

    private static boolean dumb_prime_check(int n) {
        int n2 = (int)Math.sqrt(n);
        if (n == 0) {
            return false;
        }
        if (n == 1) {
            return true;
        }
        for (int i = 2; i <= n2; ++i) {
            if (n % i != 0) continue;
            return false;
        }
        return true;
    }

    private static int dumb_next_prime(int n) {
        while (!Prime.dumb_prime_check(n)) {
            ++n;
        }
        return n;
    }

    public static void internal_test() {
        int n;
        int n2;
        Test.start("Prime");
        Test.check(Prime.isPrime(1), "1 is prime");
        Test.check(Prime.isPrime(2), "2 is prime");
        Test.check(Prime.isPrime(3), "3 is prime");
        Test.check(!Prime.isPrime(4), "4 is NOT prime");
        Test.check(Prime.isPrime(5), "5 is prime");
        Test.check(!Prime.isPrime(6), "6 is NOT prime");
        Test.check(Prime.isPrime(7), "7 is prime");
        Test.check(!Prime.isPrime(8), "8 is NOT prime");
        Test.check(!Prime.isPrime(256), "256 is NOT prime");
        Test.check(!Prime.isPrime(13221), "13221 is NOTprime");
        boolean bl = false;
        for (n2 = 0; !bl && n2 < 3000; ++n2) {
            n = (int)(Math.random() * 1234567.0);
            if (Prime.isPrime(n) == Prime.dumb_prime_check(n)) continue;
            bl = true;
        }
        Test.check(!bl, "isPrime failed");
        for (n2 = 0; !bl && n2 < 3000; ++n2) {
            n = (int)(Math.random() * 1234567.0);
            if (Prime.nextPrime(n) == Prime.dumb_next_prime(n)) continue;
            bl = true;
        }
        Test.check(!bl, "nextPrime failed");
        Test.end();
    }
}

