/*
 * JgclGeometry  \\ȃIuWFNgւ̕ϊs߂̃NX
 * Jun ̕\IuWFNgւ̕ϊsB
 *
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 *
 * $Id: JudanTransformerJun.java,v 1.3 2000/04/28 07:37:56 shikano Exp $
 */
package jp.co.sra.judan;

import sra.jun.opengl.objects.*;
import sra.jun.opengl.display.*;
import jp.go.ipa.jgcl.*;
import java.awt.Color;
import java.util.*;
import java.io.*;
import jp.co.sra.judan.*;

/*
 * JgclGeometry  \\ȃIuWFNgւ̕ϊs߂̃NX
 * Jun ̕\IuWFNgւ̕ϊsB
 *
 * @version $Revision: 1.3 $
 * @author $Author: shikano $
 */
public class JudanTransformerJun extends JudanTransformerAbstract {

    /**
     * ϊs
     * 
     * @param geometry JGCL 􉽃IuWFNg
     */
    public void transform(JgclGeometry geometry) {
	JunOpenGL3dObject obj = JudanTransform.asJunOpenGL3dObject(geometry);
	transformedObjects.addElement(obj);
    }

    /**
     * ϊs
     *
     * @param geometry JGCL 􉽃IuWFNg
     * @param Color    IuWFNg̐F
     */
    public void transform(JgclGeometry geometry, Color aColor) {
	JunOpenGL3dObject obj = JudanTransform.asJunOpenGL3dObject(geometry);
	obj.paint_(aColor);
	transformedObjects.addElement(obj);
    }

    /**
     * ϊs
     *
     * @param geometry JGCL 􉽃IuWFNg
     * @param Color    IuWFNg̐F
     * @param strippleFactor ̌`
     */
    public void transform(JgclGeometry geometry, Color aColor, int stippleFactor) {
	JunOpenGL3dObject obj = JudanTransform.asJunOpenGL3dObject(geometry);
	obj.paint_(aColor);
	if (obj instanceof JunOpenGL3dPolyline) {
  	    ((JunOpenGL3dPolyline)obj).stippleFactor_(stippleFactor);
	    ((JunOpenGL3dPolyline)obj).stipplePattern_((short)46390);
	}
	transformedObjects.addElement(obj);
    }

    /**
     * ϊs
     *
     * @param geometry JGCL 􉽃IuWFNg
     * @param Color    IuWFNg̐F
     * @param lineWidth ̕
     */
    public void transform(JgclGeometry geometry, Color aColor, float lineWidth) {
  	JunOpenGL3dObject obj = JudanTransform.asJunOpenGL3dObject(geometry);
	obj.paint_(aColor);
	if (obj instanceof JunOpenGL3dPolyline)
	    ((JunOpenGL3dPolyline)obj).lineWidth_(lineWidth);
	transformedObjects.addElement(obj);
    }
    /**
     * \s
     */
    public void show() {
  	JunOpenGL3dCompoundObject compoundObject =
  	    new JunOpenGL3dCompoundObject();
  	compoundObject.addAll_(transformedObjects);
  	compoundObject.show();
    }

    /*
     *  Lisp \
     */
    public void toLispSExpression() {
	toLispSExpression(new BufferedWriter(new PrintWriter(System.out)));
    }

    /*
     *  Lisp \
     */
    public void toLispSExpression(BufferedWriter writer) {
	JunOpenGLDisplayModel model = new JunOpenGLDisplayModel();
	JunOpenGL3dCompoundObject compoundObject =
	    new JunOpenGL3dCompoundObject();
	compoundObject.addAll_(transformedObjects);
	try {
	    model.saveToLST10_object_(writer, compoundObject);
	}
	catch (IOException ex) {
	    //System.out.println("File not found");
	    throw new JgclFatal();
	}
    }
}
