/*
 * Ȑ/Ȗʂ́uKȁvp[^͈͂߂NX
 *
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 *
 * $Id: JudanSuitableParameterSection.java,v 1.5 2000/04/28 07:37:55 shikano Exp $
 */
package jp.co.sra.judan;

//import java.util.*;

import jp.go.ipa.jgcl.*;
import jp.co.sra.judan.*;

/**
 * Ȑ/Ȗʂ́uKȁvp[^͈͂߂NX
 * ɖȗvfɂ(\)Kȃp[^͈͂ԂB
 *
 * @version $Revision: 1.5 $, $Date: 2000/04/28 07:37:55 $
 * @author $Author: shikano $
 */

public class JudanSuitableParameterSection {
    private static final double INFINITE_LIMIT = 1.0;

    /**
     * Ȑ̓Kȃp[^͈͂Ԃ
     *
     * @param geometry Jgcl̋Ȑvf(JgclParametricCurvẽCX^Xł邱)
     * @return Kȃp[^͈
     * @see JgclGeometry
     */
    public static JgclParameterSection asCurve(JgclGeometry geometry) {
	JgclParametricCurve curve = (JgclParametricCurve)geometry;
	double start;
	double increase;

	// Line
	if (geometry instanceof JgclLine2D ||
	    geometry instanceof JgclLine3D) {
	    start = - INFINITE_LIMIT;
	    increase = INFINITE_LIMIT * 2.0;
	}
	// Circle or Ellipse
	else if (geometry instanceof JgclCircle2D ||
		 geometry instanceof JgclCircle3D ||
		 geometry instanceof JgclEllipse2D ||
		 geometry instanceof JgclEllipse3D) {
	    start = 0.0;
	    increase = Math.PI * 2.0;
	}
	// Hyperbola or Parabola
	else if (geometry instanceof JgclHyperbola2D ||
		 geometry instanceof JgclHyperbola3D ||
		 geometry instanceof JgclParabola2D ||
		 geometry instanceof JgclParabola3D) {
	    start = -3.0;
	    increase = 6.0;
	}
	// BoundedCurve
	else if (geometry instanceof JgclBoundedCurve2D ||
		 geometry instanceof JgclBoundedCurve3D) {
	    return curve.parameterDomain().section();
	}
	// SurfaceCurve3D
	else if (geometry instanceof JgclSurfaceCurve3D) {
	    JgclSurfaceCurve3D surfaceCurve = (JgclSurfaceCurve3D)geometry;
	    if (surfaceCurve.masterRepresentation()
		== JgclPreferredSurfaceCurveRepresentation.CURVE_3D)
		return asCurve(surfaceCurve.curve3d());
	    else
		throw new JgclNotSupported();
	}
	// Other Geometry is not supported.
	else {
	    System.out.println(geometry.getClass().getName());
	    throw new JgclInvalidArgumentValue();
	}
	return new JgclParameterSection(start, increase);
    }

    /**
     * Ȗʂ̓Kȃp[^͈͂Ԃ
     *
     * @param geometry Jgcl̋Ȗʗvf(JgclParametricSurfacẽCX^Xł邱)
     * @return U/V̓Kȃp[^͈
     * @see JgclGeometry
     */
    public static JgclParameterSection[] asSurface(JgclGeometry geometry) {
	JgclParametricSurface surface = (JgclParametricSurface)geometry;
	double uStart;
	double uIncrease;
	double vStart;
	double vIncrease;

	// Plane
	if (geometry instanceof JgclPlane3D) {
	    uStart = vStart = - INFINITE_LIMIT;
	    uIncrease = vIncrease = INFINITE_LIMIT * 2.0;
	}
	// CylindricalSurface
	else if (geometry instanceof JgclCylindricalSurface3D) {
	    uStart = 0.0;
	    uIncrease = Math.PI * 2.0;
	    vStart = - INFINITE_LIMIT;
	    vIncrease = INFINITE_LIMIT * 2.0;
	}
	// ConicalSurface
	else if (geometry instanceof JgclConicalSurface3D) {
	    JgclConicalSurface3D con = (JgclConicalSurface3D)surface;
	    uStart = 0.0;
	    uIncrease = Math.PI * 2.0;
	    double vLength = con.radius() / Math.tan(con.semiAngle());
	    vStart = - vLength * 2.0;
	    vIncrease = vLength * 2.0;
	}
	// SphericalcalSurface
	else if (geometry instanceof JgclSphericalSurface3D) {
	    uStart = 0.0;
	    uIncrease = Math.PI * 2.0;
	    vStart = -Math.PI / 2.0 - 0.000000000000001;
	    vIncrease = Math.PI - 0.000000000000001;
	}
	// BoundedSurface
	else if (geometry instanceof JgclBoundedSurface3D) {
	    uStart    = surface.uParameterDomain().section().start();
	    uIncrease = surface.uParameterDomain().section().increase();
	    vStart    = surface.vParameterDomain().section().start();
	    vIncrease = surface.vParameterDomain().section().increase();
	}
	// JgclSurfaceOfRevolution3D
	else if (geometry instanceof JgclSurfaceOfRevolution3D) {
	    JgclSurfaceOfRevolution3D rvs = (JgclSurfaceOfRevolution3D)geometry;
	    JgclParameterSection vsec = asCurve(rvs.sweptCurve());
	    uStart = 0.0;
	    uIncrease = Math.PI * 2.0;
	    vStart = vsec.start();
	    vIncrease = vsec.increase();
	}
	// JgclSurfaceOfLinearExtrusion3D
	else if (geometry instanceof JgclSurfaceOfLinearExtrusion3D) {
	    JgclSurfaceOfLinearExtrusion3D les = (JgclSurfaceOfLinearExtrusion3D)geometry;
	    JgclParameterSection vsec = asCurve(les.sweptCurve());
	    uStart = vsec.start();
	    uIncrease = vsec.increase();
	    vStart = - INFINITE_LIMIT;
	    vIncrease = INFINITE_LIMIT * 2.0;
	}
	// Other Geometry is not supported.
	else {
	    System.out.println(geometry.getClass().getName());
	    throw new JgclNotSupported();
	}
	JgclParameterSection[] sol
	    = {new JgclParameterSection(uStart, uIncrease),
	       new JgclParameterSection(vStart, vIncrease)};
	return sol;
    }
}
