/*
 * Java Geometry Handling Library Test Environment
 * JudanMethod Object for Method "offset"
 *
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 *
 * $Id: JudanMethodOffset3D.java,v 1.4 2000/04/20 13:27:54 ryo Exp $
 */
package jp.co.sra.judan;

import java.lang.reflect.*;
import jp.go.ipa.jgcl.*;
import jp.co.sra.judan.*;

import java.awt.Color;
import sra.jun.opengl.objects.*;

/**
 * @version $Revision: 1.4 $
 * @author $Author: ryo $
 */

public class JudanMethodOffset3D extends JudanMethod {

    /**
     * RXgN^
     *
     * @param geometry    􉽃IuWFNg
     * @param methodName  \bh̖O
     * @param argClasses  \bh̃NX
     * @param argEntities \bhɗ^̃IuWFNg
     */
    public JudanMethodOffset3D(JgclGeometry geometry,
			      String methodName,
			      Class[] argClasses,
			      Object[] argEntities) {
	if (geometry instanceof JgclParametricSurface) {
	    if (argClasses.length == 5) {
		argClasses[2] = double.class;
		argClasses[3] = int.class;
	    } else {	// for JgclBoundedSurface3D
		argClasses[0] = double.class;
		argClasses[1] = int.class;
	    }
	}
	
	setFields(geometry, methodName, argClasses, argEntities);
    }

    /**
     * sʂ𕶎Ƃďo͂
     */
    public void output() {
	Object res = (Object)result;
    
	JgclBsplineSurface3D result3d = (JgclBsplineSurface3D)result;
	result3d.output(System.out);
    }

    /**
     * sʂOtBbNXƂďo͂
     */
    public static void view(Object result, JgclGeometry geometry) {
	JudanTransformer resultView = makeView(result, geometry);
	resultView.show();
    }

    /**
     * sʂ̃OtBbNX
     *
     * @param result	s(_܂͌̔z)
     */
    public static JudanTransformer makeView(Object result,JgclGeometry geom) {
  	Object res = (Object)result;

	JgclBsplineSurface3D result3d = (JgclBsplineSurface3D)result;
	JgclParametricSurface3D surface = (JgclParametricSurface3D)result3d;
	JgclParametricSurface3D surface2 = (JgclParametricSurface3D)geom;

	JudanTransformer resultView =
	    new JudanTransformer(new JudanTransformerJun());
  	resultView.transform(surface2, Color.green);
  	resultView.transform(surface, Color.red);

	return resultView;
    }
    
    public JudanTransformer makeView() {
	return makeView(result, geometry);
    }
}
