/*
 * Java Geometry Handling Library Test Environment
 * JudanMethod Object for Method "offset"
 *
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 *
 * $Id: JudanMethodOffset2D.java,v 1.4 2000/04/20 13:27:54 ryo Exp $
 */
package jp.co.sra.judan;

import java.lang.reflect.*;
import jp.go.ipa.jgcl.*;
import jp.co.sra.judan.*;

import java.awt.Color;
import sra.jun.opengl.objects.*;

/**
 * @version $Revision: 1.4 $
 * @author $Author: ryo $
 */

public class JudanMethodOffset2D extends JudanMethod {

    /**
     * RXgN^
     *
     * @param geometry    􉽃IuWFNg
     * @param methodName  \bh̖O
     * @param argClasses  \bh̃NX
     * @param argEntities \bhɗ^̃IuWFNg
     */
    public JudanMethodOffset2D(JgclGeometry geometry,
			      String methodName,
			      Class[] argClasses,
			      Object[] argEntities) {

	if (geometry instanceof JgclParametricCurve2D){
	    if (argClasses.length == 4) {
		argClasses[1] = double.class;
		argClasses[2] = int.class;
	    } else {	// for JgclBoundedCurve2D
		argClasses[0] = double.class;
		argClasses[1] = int.class;
	    }
	}
	else {
	    throw new JgclFatal();
	}

	setFields(geometry, methodName, argClasses, argEntities);
    }

    /**
     * sʂ𕶎Ƃďo͂
     */
    public void output() {
	Object res = (Object)result;
    
	JgclBsplineCurve2D result2d = (JgclBsplineCurve2D)result;
	result2d.output(System.out);
    }

    /**
     * sʂOtBbNXƂďo͂
     */
    public static void view(Object result,JgclGeometry geometry) {
	JudanTransformer resultView = makeView(result, geometry);
	resultView.show();
    }

    /**
     * sʂ̃OtBbNX
     *
     * @param result	s(_܂͌̔z)
     */
    public static JudanTransformer makeView(Object result,JgclGeometry geom) {
  	Object res = (Object)result;

	JgclBsplineCurve2D result2d = (JgclBsplineCurve2D)result;
	JgclParametricCurve2D curve = (JgclParametricCurve2D)result2d;
	JgclParametricCurve2D curve2 = (JgclParametricCurve2D)geom;

	JudanTransformer resultView =
	    new JudanTransformer(new JudanTransformerJun());
	resultView.transform(curve, Color.red);
	resultView.transform(curve2, Color.green);

	return resultView;
    }

    /**
     * sʂ̃OtBbNX
     *
     * @param result	s(_܂͌̔z)
     */
    public JudanTransformer makeView() {
	return makeView(result, geometry);
    }
    
}
