/*
 * Java Geometry Handling Library Test Environment
 * JudanMethod Object for Method "loft surface"
 *
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 *
 * $Id: JudanMethodLoft.java,v 1.2 2000/04/20 13:27:54 ryo Exp $
 */
package jp.co.sra.judan;

import java.lang.reflect.*;
import jp.go.ipa.jgcl.*;
import jp.co.sra.judan.*;

import java.awt.Color;
import sra.jun.opengl.objects.*;

/**
 * @version $Revision: 1.2 $
 * @author $Author: ryo $
 */

public class JudanMethodLoft extends JudanMethod {
    private final JgclBsplineCurve3D curve;
    private final JgclVector3D vector;
    private final double length;

    /**
     * RXgN^
     *
     * @param geometry    􉽃IuWFNg
     * @param methodName  \bh̖O
     * @param argClasses  \bh̃NX
     * @param argEntities \bhɗ^̃IuWFNg
     */
    public JudanMethodLoft(JgclGeometry geometry,
			   String methodName,
			   Class[] argClasses,
			   Object[] argEntities) {
  	if (!(geometry instanceof jp.go.ipa.jgcl.JgclBsplineCurve3D)) {
	    throw new JgclFatal();
	}

	Class cls;
 	try {
	    cls = Class.forName("jp.go.ipa.jgcl.JgclVector3D");
	}
 	catch (ClassNotFoundException e) {
 	    throw new JgclFatal();
 	}
	if (!cls.isAssignableFrom(argClasses[0])) {
	    throw new JgclFatal();
	}
	argClasses[0] = cls;
	argClasses[1] = double.class;

	setFields(geometry, methodName, argClasses, argEntities);
	this.curve = (JgclBsplineCurve3D)geometry;
	this.vector = (JgclVector3D)argEntities[0];
	this.length = ((Double)argEntities[1]).doubleValue();
    }

    /**
     * sʂ𕶎Ƃďo͂
     */
    public void output() {
	JgclBsplineSurface3D bss = (JgclBsplineSurface3D)result;
	curve.output(System.out);
	bss.output(System.out);
    }

    /**
     * sʂOtBbNXƂďo͂
     */
    public static void view(Object result,
			    JgclBsplineCurve3D curve,
			    JgclVector3D vector,
			    double length) {
	JudanTransformer resultView = makeView(result, curve, vector, length);
	resultView.show();
    }

    /**
     * sʂ̃OtBbN
     *
     * @param result	s(_܂͌̔z)
     */
    public static JudanTransformer makeView(Object result,
					    JgclBsplineCurve3D curve,
					    JgclVector3D vector,
					    double length) {
	JgclBsplineSurface3D bss = (JgclBsplineSurface3D)result;
	JgclLine3D line =
	    new JgclLine3D(curve.coordinates
			   (curve.parameterDomain().section().start()),
			   vector.unitized());
	JgclTrimmedCurve3D trc = new JgclTrimmedCurve3D(line, 0.0, length, true);

	JudanTransformer resultView =
	    new JudanTransformer(new JudanTransformerJun());
	resultView.transform(curve, Color.red);
	resultView.transform(trc, Color.yellow);
	resultView.transform(bss, Color.blue);
	return resultView;
    }

    /**
     * sʂ̃OtBbN
     */
    public JudanTransformer makeView() {
	return makeView(result, curve, vector, length);
    }
}
