/*
 * Java Geometry Handling Library Test Environment
 * JudanMethod Object for Method "fillet"
 *
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 *
 * $Id: JudanMethodFillet.java,v 1.7 2000/04/20 13:27:53 ryo Exp $
 */
package jp.co.sra.judan;

import java.lang.reflect.*;
import jp.go.ipa.jgcl.*;
import jp.co.sra.judan.*;

import java.awt.Color;
import sra.jun.opengl.objects.*;

/**
 * @version $Revision: 1.7 $
 * @author $Author: ryo $
 */

public class JudanMethodFillet extends JudanMethod {
    private final double radius;

    /**
     * RXgN^
     *
     * @param geometry    􉽃IuWFNg
     * @param methodName  \bh̖O
     * @param argClasses  \bh̃NX
     * @param argEntities \bhɗ^̃IuWFNg
     */
    public JudanMethodFillet(JgclGeometry geometry,
			    String methodName,
			    Class[] argClasses,
			    Object[] argEntities) {
	// Jgcl*Curve2D   -> JgclParametricCurve2D ɕύX
	// Jgcl*Surface3D -> JgclParametricSurface3D ɕύX
	Class cls;
 	try {
	    Class geomClass = geometry.getClass();
	    if ((cls = Class.forName("jp.go.ipa.jgcl.JgclParametricCurve2D")).
		isAssignableFrom(geomClass)) {
		if (argClasses.length == 6) {
		    if (!cls.isAssignableFrom(argClasses[2])) {
			throw new JgclFatal();
		    }
		    argClasses[1] = int.class;
		    argClasses[2] = cls;
		    argClasses[4] = int.class;
		    argClasses[5] = double.class;
		    radius = ((Double)argEntities[5]).doubleValue();
		} else {	// for JgclBoundedCurve2D
		    cls = Class.forName("jp.go.ipa.jgcl.JgclBoundedCurve2D");
		    if (!cls.isAssignableFrom(argClasses[1])) {
			throw new JgclFatal();
		    }

		    argClasses[0] = int.class;
		    argClasses[1] = cls;
		    argClasses[2] = int.class;
		    argClasses[3] = double.class;
		    radius = ((Double)argEntities[3]).doubleValue();
		}
	    }
	    else if ((cls = Class.forName("jp.go.ipa.jgcl.JgclParametricSurface3D")).
		     isAssignableFrom(geomClass)) {
		if (argClasses.length == 8) {
		    if (!cls.isAssignableFrom(argClasses[3])) {
			throw new JgclFatal();
		    }
		    argClasses[2] = int.class;
		    argClasses[3] = cls;
		    argClasses[6] = int.class;
		    argClasses[7] = double.class;
		    radius = ((Double)argEntities[7]).doubleValue();
		} else {	// for JgclBoundedSurface3D
		    cls = Class.forName("jp.go.ipa.jgcl.JgclBoundedSurface3D");
		    if (!cls.isAssignableFrom(argClasses[1])) {
			throw new JgclFatal();
		    }
		    argClasses[2] = int.class;
		    argClasses[0] = int.class;
		    argClasses[1] = cls;
		    argClasses[2] = int.class;
		    argClasses[3] = double.class;
		    radius = ((Double)argEntities[3]).doubleValue();
		}
	    }
	    else {
		throw new JgclFatal();
	    }
 	}
 	catch (ClassNotFoundException e) {
 	    throw new JgclFatal();
 	}
	setFields(cls, geometry, methodName, argClasses, argEntities);
    }

    /**
     * sʂ𕶎Ƃďo͂
     */
    public void output() {
	Object[] res = (Object[])result;
    	if (res.length == 0) {
	    System.out.println("Number of solution is 0");
	    return;
	}

  	if (res[0] instanceof jp.go.ipa.jgcl.JgclFilletObject2D) {
  	    JgclFilletObject2D[] result2d = (JgclFilletObject2D[])result;
  	    for (int ijk = 0; ijk < result2d.length; ijk++)
		result2d[ijk].output(System.out);
  	}
    	else if (res[0] instanceof jp.go.ipa.jgcl.JgclFilletObject3D) {
    	    JgclFilletObject3D[] result3d = (JgclFilletObject3D[])result;
    	    for (int ijk = 0; ijk < result3d.length; ijk++)
	        result3d[ijk].output(System.out);
    	}
    }

    /**
     * sʂOtBbNXƂďo͂
     */
    public static void view(Object result, double radius) {
	JudanTransformer resultView = makeView(result, radius);
	resultView.show();
    }

    /**
     * sʂOtBbN
     *
     * @param result	s(_܂͌̔z)
     * @param radius	a
     */
    public static JudanTransformer makeView(Object result, double radius) {
  	Object[] res = (Object[])result;

	int nSolution = res.length;
	if (nSolution == 0) {
	    System.out.println("Number of solution is 0");
	    return null;
	}

	JudanTransformer resultView =
	    new JudanTransformer(new JudanTransformerJun());

  	if (res[0] instanceof jp.go.ipa.jgcl.JgclFilletObject2D) {
  	    JgclFilletObject2D[] result2d = (JgclFilletObject2D[])result;
  	    JgclParametricCurve2D curve1 = result2d[0].pointOnCurve1().basisCurve();
  	    JgclParametricCurve2D curve2 = result2d[0].pointOnCurve2().basisCurve();
	    boolean smallFan = true;

    	    resultView.transform(curve1, Color.blue);
    	    resultView.transform(curve2, Color.green);

  	    for (int i = 0; i < nSolution; i++) {
  		resultView.transform(result2d[i].center(), Color.black);
  		resultView.transform(result2d[i].pointOnCurve1(), Color.black);
 		resultView.transform(result2d[i].pointOnCurve2(), Color.black);
  		resultView.transform(result2d[i].toCurve(smallFan), Color.red, (float)1.0);
  	    }
  	}
  	else if (res[0] instanceof jp.go.ipa.jgcl.JgclFilletObject3D) {
  	    JgclFilletObject3D[] result3d = (JgclFilletObject3D[])result;
  	    JgclParametricSurface3D surface1 = result3d[0].sectionAt(0).pointOnSurface1().basisSurface();
  	    JgclParametricSurface3D surface2 = result3d[0].sectionAt(0).pointOnSurface2().basisSurface();
	    boolean smallFan = true;

    	    resultView.transform(surface1, Color.blue);
    	    resultView.transform(surface2, Color.green);

	    JgclFilletSection3D section;
  	    for (int i = 0; i < nSolution; i++) {
		for (int j = 0; j < result3d[i].nSections(); j++) {
		    section = result3d[i].sectionAt(j);
		    resultView.transform(section.center(), Color.black);
		    resultView.transform(section.pointOnSurface1(), Color.black);
		    resultView.transform(section.pointOnSurface2(), Color.black);
  		    resultView.transform(section.toCurve(smallFan), Color.red, (float)1.0);
		}
  	    }
  	}
	return resultView;
    }

    /**
     * sʂOtBbN
     *
     */
    public JudanTransformer makeView() {
	return makeView(result, radius);
    }

}
