/*
 * P̃xNg\ۃNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclVector1D.java,v 1.21 2000/08/11 06:19:04 shikano Exp $
 */

package jp.go.ipa.jgcl;

/**
 * P̃xNg\ۃNXB
 *
 * @version $Revision: 1.21 $, $Date: 2000/08/11 06:19:04 $
 * @author Information-technology Promotion Agency, Japan
 * @see JgclPoint1D
 */

public abstract class JgclVector1D extends JgclVector {

    /**
     * P̃[xNgB
     */
    public static final JgclVector1D zeroVector;

    /**
     * P̃O[oȍWn X ̒PʃxNgB
     */
    public static final JgclVector1D xUnitVector;

    /**
     * P̃O[oȍWn -X ̒PʃxNgB
     */
    public static final JgclVector1D nagativeXUnitVector;

    /**
     * static ȃtB[hɒlݒ肷B
     */
    static {
	zeroVector = new JgclLiteralVector1D(0.0);
	xUnitVector = new JgclLiteralVector1D(1.0, true);
	nagativeXUnitVector = new JgclLiteralVector1D(-1.0, true);
    }

    /**
     * PʃxNg
     * @serial
     */
    private JgclVector1D unitized;

    /**
     * IuWFNg\zB
     * <p>
     * 悤ƂxNg
     * PʃxNgł邩ǂȂꍇA
     * PʃxNgłȂƂۏ؂Ăꍇɂ́A
     * ̃RXgN^gpB
     * </p>
     */
    protected JgclVector1D() {
	super();

	unitized = null;
    }

    /**
     * IuWFNg\zB
     * <p>
     * 悤ƂxNg
     * PʃxNgł邩ǂꍇɂ́A
     * ̃RXgN^gpB
     * </p>
     * 
     * @param confirmedAsUnitized	悤ƂxNg
     *					PʃxNgłȂ <code>true</code>A
     *					Ȃ <code>false</code>
     */
    protected JgclVector1D(boolean confirmedAsUnitized) {
	super();

	unitized = (confirmedAsUnitized) ? this : null;
    }

    /**
     * P̃[xNgԂB
     *
     * @return	P̃[xNg
     */
    public static JgclVector1D zeroVector() {
	return zeroVector;
    }

    /**
     * P̃O[oȍWn X ̒PʃxNgԂB
     *
     * @return	P̃O[oȍWn X ̒PʃxNg
     */
    public static JgclVector1D xUnitVector() {
	return xUnitVector;
    }

    /**
     * ԂB
     * <p>
     *  1 ԂB
     * </p>
     * 
     * @return	PȂ̂ŁA 1
     */
    public int dimension() {
	return 1;
    }

    /**
     * PۂԂB
     * <p>
     *  true ԂB
     * </p>
     * 
     * @return		PȂ̂ <code>true</code>
     */
    public boolean is1D() {
	return true;
    }

    /**
     * xNg X Ԃۃ\bhB
     * 
     * @return	xNg X 
     */
    public abstract double x();

    /**
     * PʉxNgԂB
     * 
     * @return		PʉxNg
     */
    public JgclVector1D unitized() {
	if (unitized != null)
	    return unitized;

	// 1D unitized vector always takes 1 as x
	if (!(x() < 0.0))
	    return (unitized = xUnitVector);
	else
	    return (unitized = nagativeXUnitVector);
    }
	
    /**
     * e̕𔽓]xNgԂB
     *
     * @return	this 𔽓]xNg
     */
    public JgclVector1D reverse() {
	return new JgclLiteralVector1D(-x());
    }

    /**
     * ςԂB
     * 
     * @param mate	ς鑊̃xNg
     * @return	
     */
    public double dotProduct(JgclVector1D mate) {
	return x() * mate.x();
    }

    /**
     * xNgm̘aԂB
     * 
     * @param mate	a鑊̃xNg
     * @return		xNg̘a (this + mate)
     */
    public JgclVector1D add(JgclVector1D mate) {
	return new JgclLiteralVector1D(x()+mate.x());
    }

    /**
     * xNgm̍ԂB
     * 
     * @param mate	鑊̃xNg
     * @return		xNg̍ (this - mate)
     */
    public JgclVector1D subtract(JgclVector1D mate) {
	return new JgclLiteralVector1D(x()-mate.x());
    }

    /**
     * ^ꂽXP[悶xNgԂB
     * 
     * @param scale	XP[
     * @return		(this * scale)
     */
    public JgclVector1D multiply(double scale) {
	return new JgclLiteralVector1D(x() * scale);
    }

    /**
     * ^ꂽXP[ŊxNgԂB
     * 
     * @param scale	XP[
     * @return		(this / scale)
     */
    public JgclVector1D divide(double scale) {
	return new JgclLiteralVector1D(x() / scale);
    }

    /**
     * QxNg̓ꐫ𔻒肷B
     * 
     * @param mate	̑ΏۂƂȂxNg
     * @return	this  mate űe덷vȓ
     *		̃xNgłƂ݂Ȃ trueAȂ false
     * @see	JgclConditionOfOperation
     */
    public boolean identical(JgclVector1D mate) {
	double dTol;
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();

	dTol = condition.getToleranceForDistance();
	return Math.abs(x() - mate.x()) < dTol;
    }

    /**
     * xNg̑傫ԂB
     * 
     * @return		xNg̑傫 abs(x)
     */
    public double length() {
	return Math.abs(x());
    }

    /**
     * xNg̑傫ԂB
     * 
     * @return		xNg̑傫 abs(x)
     */
    public double magnitude() {
	return Math.abs(x());
    }

    /**
     * xNg̃mԂB
     * 
     * @return		xNg̃m (x * x)
     */
    public double norm() {
	double val = x();
	return val * val;
    }

    /**
     * P̓_ (JgclPoint1D) ɕϊB
     *
     * @return	_̈ʒuxNgƂ݂Ȃ_
     */
    public JgclPoint1D toPoint1D() {
        return JgclPoint1D.of(x());
    }

    /**
     * JgclLiteralVector1D ̃CX^X𐶐B
     *
     * @param x	X 
     * @return	JgclLiteralVector1D ̃CX^X
     */
    public static JgclLiteralVector1D of(double x) {
	return new JgclLiteralVector1D(x);
    }
}
