/*
 * [eBeBIȏsȂe static \bhNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclUtil.java,v 1.10 2000/04/26 09:39:27 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * [eBeBIȏsȂe static \bhNXB
 *
 * @version $Revision: 1.10 $, $Date: 2000/04/26 09:39:27 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclUtil {
    /**
     * ̃NX̃CX^X͍Ȃ
     */
    private JgclUtil() {
    }

    /*
     * double ̂Pz̗vfA̒l̑傫ŏɃ\[gB
     *
     * @param array	double ̂Pz
     * @see	#sortDoubleArray(double[], int, int)
     */
    public static void sortDoubleArray(double[] array) {
	sortDoubleArray(array, 0, array.length);
    }

    /*
     * double ̂Pz̎w͈͓̗̔vfA̒l̑傫ŏɃ\[gB
     * <p>
     * array[low]  array[up] ܂łA̒l̑傫ŏɃ\[gB
     * </p>
     *
     * @param array	double ̂Pz
     * @param low	\[g̑Ώ۔͈͂̊JnCfbNX
     * @param up	\[g̑Ώ۔͈͂̏ICfbNX
     * @see	#sortDoubleArray(double[])
     */
    public static void sortDoubleArray(double[] array, int low, int up) {
	int lidx = low;
	int uidx = up;
	double key = array[(low + up) / 2];
	double swap;

	for (; lidx < uidx; ) {
	    for (; array[lidx] < key; lidx++)
		/* nop */;
	    for (; key < array[uidx]; uidx--)
		/* nop */;

	    if ( lidx <= uidx ) {
		swap = array[uidx];
		array[uidx]=array[lidx];
		array[lidx]=swap;
		lidx++; uidx--;
	    }
	}

	if (low < uidx) sortDoubleArray(array, low, uidx);
	if (lidx < up) sortDoubleArray(array, lidx, up);
    }

    /**
     * Ƀ\[gꂽ double ̂PzɂāA
     * ^ꂽlzȂ̍őlvf̃CfbNX
     * <p>
     * (array[v] &lt;= value && value &lt; array[v + 1]) 𖞂l v ԂB
     * </p>
     * <p>
     * value &lt; array[min] Ȃ (min - 1) ԂB
     * </p>
     * <p>
     * array[max] &lt;= value Ȃ max ԂB
     * </p>
     *
     * @param array	double ̂Pz
     * @param min	\[g̑Ώ۔͈͂̊JnCfbNX
     * @param max	\[g̑Ώ۔͈͂̏ICfbNX
     * @param value	ΏۂƂl
     * @return		value zȂ̍őlvf̃CfbNX
     */
    public static int bsearchDoubleArray(double[] array, int min,
					 int max, double value) {
	if (value < array[min])
	    return min-1;
	else if (array[max] <= value)
	    return max;
	else {
	    int mid;

	    while(min + 1 < max) {
		mid = (min + max)/2;
		if (value < array[mid])
		    max = mid;
		else
		    min = mid;
	    }
	    return min;
	}
    }

    /**
     * ^ꂽ̋tƂ邩ǂB
     *
     * @param value	tƂ邩ǂl
     * @return		tƂ̂ł trueAłȂ false
     * @see	JgclMachineEpsilon#DOUBLE
     */
    public static boolean isReciprocatable(double value) {
	if (Math.abs(value) < JgclMachineEpsilon.DOUBLE)
	    return false;
	return true;
    }

    /**
     * ^ꂽ̎̏ZSǂB
     * <p>
     * (a / b) Sǂ𒲂ׂB
     * </p>
     *
     * @param a	폜
     * @param b	
     * @return	SɊ̂ł trueAłȂ false
     * @see	#isReciprocatable(double)
     */
    public static boolean isDividable(double a, double b) {
	double c;

	// Division by floating point does never throw any exception.
	c = b/a; // reverse

	if (Double.isNaN(c) ||
	    !isReciprocatable(c))
	    //Math.abs(c) < JgclMachineEpsilon.DOUBLE)
	    return false;
	return true;
    }
}
