/*
 * Q : gȐ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclTrimmedCurve2D.java,v 1.70 2000/08/11 06:19:03 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Vector;
import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * Q : gȐ\NXB
 * <p>
 * gȐ́AȐ̈ꕔLƂLȐłB
 * ꕔLƂ邱Ƃg~OA
 * LƂԂ̂Ƃg~OԂƂB
 * </p>
 * <p>
 * ̃NX̃CX^X́A
 * <ul>
 * <li> g~ȎΏۂƂȂȐ basisCurve
 * <li> g~OԂ̎n_Ȑ̃p[^l tParam1 邢͍Wl tPnt1
 * <li> g~OԂ̏I_Ȑ̃p[^l tParam2 邢͍Wl tPnt2
 * <li> g~OԂ̎n_Ƃ tParam1  tPnt1 ̂ǂD悷邩 masterRepresentation1
 * <li> g~OԂ̏I_Ƃ tParam2  tPnt2 ̂ǂD悷邩 masterRepresentation2
 * <li>	gȐȐƓۂtO senseAgreement
 * </ul>
 * ێB
 * </p>
 * <p>
 * gȐ̂̂̒`͗LŔIȂ̂łA
 * p[^Ԃ [0, |tParam2 - tParam1|] ƂB
 * </p>
 * <p>
 * <a name="CONSTRAINTS">[Ԃ̍S]</a>
 * </p>
 * <p>
 * tPnt1  null ł\ȂȀꍇɂ
 * masterRepresentation1 ̒l
 * JgclTrimmingPreference.PARAMETER łȂ΂ȂȂB
 * </p>
 * <p>
 * l
 * tPnt2  null ł\ȂȀꍇɂ
 * masterRepresentation2 ̒l
 * JgclTrimmingPreference.PARAMETER łȂ΂ȂȂB
 * </p>
 * <p>
 * tParam1, tParam2 
 * basisCurve ̃p[^`Ɏ܂ĂȂ΂ȂȂB
 * </p>
 * <p>
 * ȐIłꍇA
 * senseAgreement  true  ł (tParam1 &lt; tParam2)
 * senseAgreement  false ł (tParam1 &gt; tParam2)
 * łȂ΂ȂȂB
 * </p>
 * <p>
 * ȐIłꍇA
 * senseAgreement  true  ł
 * tParam2 ̒l (tParam1 &lt; tParam2) 𖞂悤
 * ̃CX^X̓ŎIɏCB
 * l
 * senseAgreement  false ł
 * tParam1 ̒l (tParam1 &gt; tParam2) 𖞂悤
 * ̃CX^X̓ŎIɏCB
 * </p>
 *
 * @version $Revision: 1.70 $, $Date: 2000/08/11 06:19:03 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclTrimmedCurve2D extends JgclBoundedCurve2D {

    /**
     * ȐB
     * @serial
     */
    private JgclParametricCurve2D basisCurve;

    /**
     * g~OԂ̎n_WlB
     * <p>
     * KvɉăLbVB
     * </p>
     * @serial
     */
    private JgclPoint2D tPnt1;

    /**
     * g~OԂ̏I_WlB
     * <p>
     * KvɉăLbVB
     * </p>
     * @serial
     */
    private JgclPoint2D tPnt2;

    /**
     * g~OԂ̎n_Ȑ̃p[^lB
     * @serial
     */
    private double tParam1;

    /**
     * g~OԂ̏I_Ȑ̃p[^lB
     * @serial
     */
    private double tParam2;

    /**
     * g~OԂ̎n_Ƃ tParam1  tPnt1 ̂ǂD悷邩B
     * @serial
     * @see	JgclTrimmingPreference
     */
    private int masterRepresentation1;

    /**
     * g~OԂ̏I_Ƃ tParam2  tPnt2 ̂ǂD悷邩B
     * @serial
     * @see	JgclTrimmingPreference
     */
    private int masterRepresentation2;

    /**
     * gȐȐƓۂtOB
     * @serial
     */
    private boolean senseAgreement;

    /**
     * ^ꂽp[^lA
     * ̃gȐ̕Ȑ̃p[^`͈͓̔ɂ邩ۂ𒲂ׂB
     * <p>
     * param AȐ̃p[^`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param param	Ȑɑ΂p[^l
     * @return 	KvɉāA܂񂾃p[^l
     * @see	JgclParametricCurve#checkValidity(double)
     * @see	JgclParameterDomain#wrap(double)
     * @see	JgclParameterOutOfRange
     */
    private double checkParamValidity(double param)
    {
	if (basisCurve.isPeriodic()) {
	    JgclParameterDomain domain = basisCurve.parameterDomain();
	    return domain.wrap(param);
	}
	basisCurve.checkValidity(param);
	return param;
    }

    /**
     * ^ꂽWl (̃gȐ̕Ȑɑ΂) p[^l̊Ԃ
     * 邩ۂ𒲂ׂB
     * <p>
     * pnt  param ̊ԂɐȂꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * pnt  null ł΁Ã\bh͉ȂB
     * </p>
     *
     * @param pnt	Wl
     * @param param	Ȑɑ΂p[^l
     * @see	JgclInvalidArgumentValue
     */
    private void checkPointValidity(JgclPoint2D pnt, double param)
    {
	if (pnt != null) {
	    if (!basisCurve.coordinates(param).identical(pnt))
		throw new JgclInvalidArgumentValue();
	}
    }

    /**
     * etB[hɒlݒ肷B
     * <p>
     * ̒l <a href="#CONSTRAINTS">[Ԃ̍S]</a> 𖞂Ȃꍇɂ́A
     * JgclParameterOutOfRange  JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param basicCurve	Ȑ
     * @param tPnt1	g~OԂ̎n_Wl
     * @param tPnt2	g~OԂ̏I_Wl
     * @param tParam1	g~OԂ̎n_p[^l
     * @param tParam2	g~OԂ̏I_p[^l
     * @param masterRepresentation1	tPnt1  tParam1 ̂ǂD悷邩l
     * @param masterRepresentation2	tPnt2  tParam2 ̂ǂD悷邩l
     * @param senseAgreement	gȐȐƓۂtO
     * @see	JgclTrimmingPreference
     * @see	JgclParameterOutOfRange
     * @see	JgclInvalidArgumentValue
     */
    private void setParams(JgclParametricCurve2D basisCurve,
			   JgclPoint2D tPnt1, JgclPoint2D tPnt2,
			   double tParam1, double tParam2,
			   int masterRepresentation1,
			   int masterRepresentation2,
			   boolean senseAgreement)
    {
	this.basisCurve = basisCurve;
	tParam1 = checkParamValidity(tParam1); this.tParam1 = tParam1;
	tParam2 = checkParamValidity(tParam2); this.tParam2 = tParam2;
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double pTol = condition.getToleranceForParameter();

	if (Math.abs(tParam2 - tParam1) < pTol)
	    throw new JgclInvalidArgumentValue();

	checkPointValidity(tPnt1, tParam1); this.tPnt1 = tPnt1;
	checkPointValidity(tPnt2, tParam2); this.tPnt2 = tPnt2;
	this.masterRepresentation1 = masterRepresentation1;
	this.masterRepresentation2 = masterRepresentation2;

	if (basisCurve.isPeriodic()) {
	    JgclParameterSection sec = basisCurve.parameterDomain().section();
	    if (senseAgreement) {
		if (tParam1 > tParam2)
		    this.tParam2 = tParam2 += sec.increase();
	    }
	    else {
		if (tParam1 < tParam2)
		    this.tParam1 = tParam1 += sec.increase();
	    }
	}
	else {
	    if (senseAgreement) {
		if (tParam1 > tParam2)
		    throw new JgclInvalidArgumentValue();
	    }
	    else {
		if (tParam1 < tParam2)
		    throw new JgclInvalidArgumentValue();
	    }
	}
	// now always senseAgreement == (tParam1 < tParam2)

	this.senseAgreement = senseAgreement;
    }

    /**
     * etB[hɐݒ肷l̂̂^ăIuWFNg\zB
     * <p>
     * ̒l <a href="#CONSTRAINTS">[Ԃ̍S]</a> 𖞂Ȃꍇɂ́A
     * JgclParameterOutOfRange  JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param basicCurve	Ȑ
     * @param tPnt1	g~OԂ̎n_Wl
     * @param tPnt2	g~OԂ̏I_Wl
     * @param tParam1	g~OԂ̎n_p[^l
     * @param tParam2	g~OԂ̏I_p[^l
     * @param masterRepresentation1	tPnt1  tParam1 ̂ǂD悷邩l
     * @param masterRepresentation2	tPnt2  tParam2 ̂ǂD悷邩l
     * @param senseAgreement	gȐȐƓۂtO
     * @see	JgclTrimmingPreference
     * @see	JgclParameterOutOfRange
     * @see	JgclInvalidArgumentValue
     */
    JgclTrimmedCurve2D(JgclParametricCurve2D basisCurve,
		       JgclPoint2D tPnt1, JgclPoint2D tPnt2,
		       double tParam1, double tParam2,
		       int masterRepresentation1,
		       int masterRepresentation2,
		       boolean senseAgreement)
    {
	super();
	setParams(basisCurve, tPnt1, tPnt2, tParam1, tParam2,
		  masterRepresentation1, masterRepresentation2,
		  senseAgreement);
    }

    /**
     * Ȑƃg~OԂ̗[_Wl^ăIuWFNg\zB
     * <p>
     * ̃RXgN^̓ł́A
     * tPnt1, tPnt2 ɑΉȐ̃p[^l tParam1, tParam2 
     * ߂B̏Ɏs (܂A^ꂽWlȐɂȂ) ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * masterRepresentation1, masterRepresentation2 ̒l͂Ƃ
     * JgclTrimmingPreference.POINT ƂB
     * </p>
     * <p>
     * ̂悤ɗpӂl <a href="#CONSTRAINTS">[Ԃ̍S]</a> 𖞂Ȃꍇɂ́A
     * JgclParameterOutOfRange  JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param basicCurve	Ȑ
     * @param tPnt1	g~OԂ̎n_̍Wl
     * @param tPnt2	g~OԂ̏I_̍Wl
     * @param senseAgreement	gȐȐƓۂtO
     * @see	JgclTrimmingPreference
     * @see	JgclParameterOutOfRange
     * @see	JgclInvalidArgumentValue
     * @see	JgclParametricCurve2D#pointToParameter(JgclPoint2D)
     */
    public JgclTrimmedCurve2D(JgclParametricCurve2D basisCurve,
			      JgclPoint2D tPnt1, JgclPoint2D tPnt2,
			      boolean senseAgreement) {
	super();
	setParams(basisCurve, tPnt1, tPnt2,
		  basisCurve.pointToParameter(tPnt1),
		  basisCurve.pointToParameter(tPnt2),
		  JgclTrimmingPreference.POINT,
		  JgclTrimmingPreference.POINT,
		  senseAgreement);
    }

    /**
     * Ȑƃg~OԂ̗[_̕Ȑł̃p[^l^ăIuWFNg\zB
     * <p>
     * ̃RXgN^̓ł́A
     * tParam1, tParam ɑΉȐ̍Wl tPnt1, tPnt2 
     * ߂B̏Ɏs (܂A^ꂽp[^l
     * Ȑ̃p[^`OĂ) ꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * <p>
     * masterRepresentation1, masterRepresentation2 ̒l͂Ƃ
     * JgclTrimmingPreference.PARAMETER ƂB
     * </p>
     * <p>
     * ̂悤ɗpӂl <a href="#CONSTRAINTS">[Ԃ̍S]</a> 𖞂Ȃꍇɂ́A
     * JgclParameterOutOfRange  JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param basicCurve	Ȑ
     * @param tParam1	g~OԂ̎n_\p[^l
     * @param tParam2	g~OԂ̏I_\p[^l
     * @param senseAgreement	gȐȐƓۂtO
     * @see	JgclParametricCurve2D#coordinates(double)
     * @see	JgclTrimmingPreference
     * @see	JgclParameterOutOfRange
     * @see	JgclInvalidArgumentValue
     */
    public JgclTrimmedCurve2D(JgclParametricCurve2D basisCurve,
			      double tParam1, double tParam2,
			      boolean senseAgreement)
    {
	super();
	setParams(basisCurve, 
		  basisCurve.coordinates(tParam1),
		  basisCurve.coordinates(tParam2),
		  tParam1, tParam2,
		  JgclTrimmingPreference.PARAMETER,
		  JgclTrimmingPreference.PARAMETER,
		  senseAgreement);
    }

    /**
     * Ȑƃg~OԂ\p[^ԗ^ăIuWFNg\zB
     * <p>
     * pint ̊Jnl tParam1AIl tParam2 ƂB
     * ܂ pint ̑lł senseAgreement  trueA
     * łȂ senseAgreement  false ƂB
     * </p>
     * <p>
     * tPnt1, tPnt2 ̒l͂Ƃ null ƂB
     * </p>
     * <p>
     * masterRepresentation1, masterRepresentation2 ̒l͂Ƃ
     * JgclTrimmingPreference.PARAMETER ƂB
     * </p>
     * <p>
     * ̂悤ɗpӂl <a href="#CONSTRAINTS">[Ԃ̍S]</a> 𖞂Ȃꍇɂ́A
     * JgclParameterOutOfRange  JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param basicCurve	Ȑ
     * @param pint	g~OԂ\p[^
     * @see	JgclTrimmingPreference
     * @see	JgclParameterOutOfRange
     * @see	JgclInvalidArgumentValue
     */
    public JgclTrimmedCurve2D(JgclParametricCurve2D basisCurve,
			      JgclParameterSection pint)
    {
	super();
	setParams(basisCurve, null, null, pint.start(), pint.end(),
		  JgclTrimmingPreference.PARAMETER,
		  JgclTrimmingPreference.PARAMETER,
		  pint.increase() > 0);
    }

    /**
     * ̃gȐ̕ȐԂB
     * 
     * @return	Ȑ
     */
    public JgclParametricCurve2D basisCurve() {
	return this.basisCurve;
    }

    /**
     * ̃gȐ̃g~OԂ̎n_WlԂB
     * <p>
     * LbVs킸Aݒl̂܂ܕԂB
     * </p>
     * 
     * @return	g~OԂ̎n_̍Wl
     */
    public JgclPoint2D tPnt1() {
	return this.tPnt1;
    }

    /**
     * ̃gȐ̃g~OԂ̏I_WlԂB
     * <p>
     * LbVs킸Aݒl̂܂ܕԂB
     * </p>
     * 
     * @return	g~OԂ̏I_̍Wl
     */
    public JgclPoint2D tPnt2() {
	return this.tPnt2;
    }

    /**
     * ̃gȐ̃g~OԂ̎n_Ȑ̃p[^lԂB
     * 
     * @return	g~OԂ̎n_Ȑ̃p[^l
     */
    public double tParam1() {
	return this.tParam1;
    }

    /**
     * ̃gȐ̃g~OԂ̏I_Ȑ̃p[^lԂB
     * 
     * @return	g~OԂ̏I_Ȑ̃p[^l
     */
    public double tParam2() {
	return this.tParam2;
    }

    /**
     * ̃gȐ masterRepresentation1 ԂB
     * 
     * @return	masterRepresentation1 ̒l
     * @see	JgclTrimmingPreference
     */
    public int masterRepresentation1() {
	return this.masterRepresentation1;
    }

    /**
     * ̃gȐ masterRepresentation2 ԂB
     * 
     * @return	masterRepresentation2 ̒l
     * @see	JgclTrimmingPreference
     */
    public int masterRepresentation2() {
	return this.masterRepresentation2;
    }

    /**
     * ̃gȐ senseAgreement ԂB
     * 
     * @return	gȐȐƓȂ trueAȂ false
     */
    public boolean senseAgreement() {
	return this.senseAgreement;
    }

    /**
     * ̃gȐɑ΂ė^ꂽp[^lA
     * Ȑɑ΂p[^lɕϊB
     * <p>
     * ^ꂽp[^l̋Ȑ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	gȐɑ΂p[^l
     * @return	Ȑɑ΂p[^l
     */
    public double toBasisParameter(double param) {
	checkValidity(param);
	if (senseAgreement) {
	    // s = t - t1, i.e. t = s + t1
	    return param + tParam1;
	}
	else {
	    // s = t1 - t, i.e. t = t1 - s
	    return tParam1 - param;
	}
    }

    /**
     * ̃gȐɑ΂ė^ꂽp[^ԂA
     * Ȑɑ΂p[^ԂɕϊB
     * <p>
     * ^ꂽp[^Ԃ̋Ȑ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	gȐɑ΂p[^
     * @return	Ȑɑ΂p[^
     */
    public JgclParameterSection toBasisParameter(JgclParameterSection pint) {
	double start = toBasisParameter(pint.start());
	double end = toBasisParameter(pint.end());

	return new JgclParameterSection(start, end - start);
    }

    /**
     * ̃gȐ̕Ȑɑ΂ė^ꂽp[^lA
     * ̃gȐɑ΂p[^lɕϊB
     * 
     * @param param	Ȑɑ΂p[^l
     * @return	gȐɑ΂p[^l
     */
    public double toOwnParameter(double param) {
	if (basisCurve.isPeriodic()) {
	    double absInc = basisCurve.parameterDomain().section().absIncrease();
	    if (senseAgreement == true) {
		while (param < tParam1)
		    param += absInc;
		while (tParam2 < param)
		    param -= absInc;
		if (param < tParam1) {
		    if ((tParam1 - param) > ((param + absInc) - tParam2))
			param += absInc;
		}
	    } else {
		while (param < tParam2)
		    param += absInc;
		while (tParam1 < param)
		    param -= absInc;
		if (param < tParam2) {
		    if ((tParam2 - param) > ((param + absInc) - tParam1))
			param += absInc;
		}
	    }
	}

	return (senseAgreement) ? (param - tParam1) : (tParam1 - param);
    }

    /**
     * ^ꂽp[^Ԃɂ邱̋Ȑ̎ԏł̒ (̂) ԂB
     * <p>
     * pint ̑l͕ł܂ȂB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ̋Ȑ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param pint	Ȑ̒߂p[^
     * @return	w肳ꂽp[^ԂɂȐ̒
     * @see	JgclParameterOutOfRange
     */
    public double length(JgclParameterSection pint)
    {
        return basisCurve.length(toBasisParameter(pint));
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̍WlԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		Wl
     * @see	JgclParameterOutOfRange
     */
    public JgclPoint2D coordinates(double param)
    {
	return basisCurve.coordinates(toBasisParameter(param));
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̐ڃxNgԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		ڃxNg
     * @see	JgclParameterOutOfRange
     */
    public JgclVector2D tangentVector(double param) 
    {
	JgclVector2D tang = basisCurve.tangentVector(toBasisParameter(param));

	if (senseAgreement)
	    return tang;
	else
	    return tang.multiply(-1);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̋ȗԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		ȗ
     * @see	JgclParameterOutOfRange
     */
    public JgclCurveCurvature2D curvature(double param)
    {
	return basisCurve.curvature(toBasisParameter(param));
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̓֐ԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		֐
     * @see	JgclParameterOutOfRange
     */
    public JgclCurveDerivative2D evaluation(double param)
    {
	JgclCurveDerivative2D curv = 
	    basisCurve.evaluation(toBasisParameter(param));
	if (senseAgreement)
	    return curv;
	else {
	    JgclCurveDerivative2D rcurv =
		new JgclCurveDerivative2D(curv.d0D(), curv.d1D().multiply(-1),
					  curv.d2D());
	    return rcurv;
	}
    }

    /**
     * 炩̉Zɂēꂽp[^lA
     * ̋Ȑ̒`ɋIɎ߂B
     * <p>
     * l`悩OꂷĂāA
     * IɎ߂邱ƂKłȂꍇɂ́ADouble.NaN ԂB
     * </p>
     *
     * @param param	炩̉Zɂēꂽp[^l
     * @return	`Ɏ߂p[^l
     * @see	JgclParametricCurve2D#parameterValidity(double)
     */
    private double forceComputedParameter(double param) {
	switch(parameterValidity(param)) {
	case JgclParameterValidity.OUTSIDE:
	    param = Double.NaN;
	    break;

	case JgclParameterValidity.TOLERATED_LOWER_LIMIT:
	    param = parameterDomain().section().lower();
	    break;

	case JgclParameterValidity.TOLERATED_UPPER_LIMIT:
	    param = parameterDomain().section().upper();
	    break;

	default:
	    break;
	}

	return param;
    }

    /**
     * ̋Ȑ̓ٓ_ԂB
     * <p>
     * ٓ_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @return	ٓ_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    public JgclPointOnCurve2D[] singular() throws JgclIndefiniteSolution {
	Vector singularVec = new Vector();
	JgclPointOnCurve2D[] singular = basisCurve.singular();
	JgclParameterDomain domain = parameterDomain();

	for (int i = 0; i < singular.length; i++) {
	    double param = toOwnParameter(singular[i].parameter());
	    param = forceComputedParameter(param);

	    if (Double.isNaN(param) == true)
		continue;

	    try {
		singularVec.addElement(new JgclPointOnCurve2D(this, param, doCheckDebug));
	    }
	    catch(JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }

	}
	JgclPointOnCurve2D[] thisSingular =
	    new JgclPointOnCurve2D[singularVec.size()];
	singularVec.copyInto(thisSingular);
	return thisSingular;
    }

    /**
     * ̋Ȑ̕ϋȓ_ԂB
     * <p>
     * ϋȓ_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @return	ϋȓ_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    public JgclPointOnCurve2D[] inflexion() throws JgclIndefiniteSolution {
	Vector inflexionVec = new Vector();
	JgclPointOnCurve2D[] inflexion = basisCurve.inflexion();
	JgclParameterDomain domain = parameterDomain();

	for (int i = 0; i < inflexion.length; i++) {
	    double param = toOwnParameter(inflexion[i].parameter());
	    param = forceComputedParameter(param);

	    if (Double.isNaN(param) == true)
		continue;

	    try {
		inflexionVec.addElement
		    (new JgclPointOnCurve2D(this, param, doCheckDebug));
	    }
	    catch(JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }

	}
	JgclPointOnCurve2D[] thisInflexion =
	    new JgclPointOnCurve2D[inflexionVec.size()];
	inflexionVec.copyInto(thisInflexion);
	return thisInflexion;
    }

    /**
     * ^ꂽ_炱̋Ȑւ̓e_߂B
     * <p>
     * e_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param point	e̓_
     * @return	e_
     * @exception JgclIndefiniteSolution	sł
     */
    public JgclPointOnCurve2D[] projectFrom(JgclPoint2D point)
	throws JgclIndefiniteSolution
    {
	Vector projvec = new Vector();
	JgclPointOnCurve2D[] proj = basisCurve.projectFrom(point);
	JgclParameterDomain domain = parameterDomain();

	for (int i = 0; i < proj.length; i++) {
	    JgclPointOnCurve2D proj2;
	    double param = toOwnParameter(proj[i].parameter());
	    param = forceComputedParameter(param);

	    if (Double.isNaN(param) == true)
		continue;

	    try {
		proj2 = new JgclPointOnCurve2D(this, param, doCheckDebug);
	    }
	    catch(JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }

	    projvec.addElement(proj2);
	}
	JgclPointOnCurve2D[] prj = new JgclPointOnCurve2D[projvec.size()];
	projvec.copyInto(prj);
	return prj;
    }

    /**
     * ̋Ȑ̎w̋ԂA^ꂽ덷Œߎ|CԂB
     * <p>
     * ʂƂĕԂ|C\_
     * ̋Ȑx[XȐƂ JgclPointOnCurve2D 
     * 邱Ƃ҂łB
     * </p>
     * <p>
     * section ̒lÃxWGȐ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param section	ߎp[^
     * @param tolerance	̋e덷
     * @return		̋Ȑ̎w̋Ԃ𒼐ߎ|C
     * @see	JgclParameterOutOfRange
     */
    public JgclPolyline2D toPolyline(JgclParameterSection pint,
				     JgclToleranceForDistance tol) 
    {
	JgclPolyline2D pl = basisCurve.toPolyline(toBasisParameter(pint), tol);
	JgclPoint2D[] pnts = new JgclPoint2D[pl.nPoints()];

	for (int i = 0; i < pnts.length; i++) {
	    JgclPointOnCurve2D p = (JgclPointOnCurve2D)pl.pointAt(i);
	    pnts[i] = new JgclPointOnCurve2D(this, toOwnParameter(p.parameter()), doCheckDebug);
	}

	return new JgclPolyline2D(pnts);
    }

    /**
     * ̋Ȑ̎w̋ԂɍČL Bspline ȐԂB
     * <p>
     * pint ̒lÂaXvCȐ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param pint	L Bspline ȐōČp[^
     * @return		̋Ȑ̎w̋ԂČL Bspline Ȑ
     * @see	JgclParameterOutOfRange
     */
    public JgclBsplineCurve2D toBsplineCurve(JgclParameterSection pint) {
	return basisCurve.toBsplineCurve(toBasisParameter(pint));
    }

    /**
     * ̋ȐƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * ̋Ȑ̕ȐƑ̋Ȑ̌_߂ɁA
     * ̓ł̋Ȑ̃g~OԂ̓Ɏ܂Ă
     * u_vƂĂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    private JgclIntersectionPoint2D[] doIntersect(JgclParametricCurve2D mate,
						  boolean doExchange) {
	Vector intsvec = new Vector();

	JgclIntersectionPoint2D[] ints;
	try {
	    ints = basisCurve.intersect(mate);
	} catch (JgclIndefiniteSolution e) {
	    ints = new JgclIntersectionPoint2D[0];	// ??
	}
	JgclParameterDomain domain = parameterDomain();

	for (int i = 0; i < ints.length; i++) {
	    double param = toOwnParameter(ints[i].pointOnCurve1().parameter());

	    param = forceComputedParameter(param);

	    if (Double.isNaN(param) == true)
		continue;

	    JgclPointOnCurve2D pnts = new JgclPointOnCurve2D(this, param, doCheckDebug);

	    JgclIntersectionPoint2D ints2 = 
		new JgclIntersectionPoint2D(pnts, ints[i].pointOnCurve2(), doCheckDebug);

	    intsvec.addElement(ints2);
	}

	JgclIntersectionPoint2D[] xints =
	    new JgclIntersectionPoint2D[intsvec.size()];
	intsvec.copyInto(xints);
	if (doExchange)
	    for (int i = 0; i < xints.length; i++)
		xints[i] = xints[i].exchange();

	return xints;
    }

    /**
     * ̋ȐƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return	_̔z
     */
    public JgclIntersectionPoint2D[] intersect(JgclParametricCurve2D mate) {
	return doIntersect(mate, false);
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclLine2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclCircle2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (ȉ~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȉ~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclEllipse2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclParabola2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (oȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (oȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclHyperbola2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (|C) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (|C)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclPolyline2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (xWGȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (xWGȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclPureBezierCurve2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (aXvCȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (aXvCȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclBsplineCurve2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (gȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (gȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclTrimmedCurve2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (ȐZOg) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȐZOg)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclCompositeCurveSegment2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (Ȑ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ (Ȑ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     * @see	#doIntersect(JgclParametricCurve2D, boolean)
     */
    JgclIntersectionPoint2D[] intersect(JgclCompositeCurve2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * Ȑɑ΂p[^l
     * gȐɑ΂p[^lւ̕ϊ\NXB
     * @see	#interfere(JgclBoundedCurve2D, boolean)
     */
    class ToTrimConversion extends JgclParameterConversion2D {
	/**
	 * gȐB
	 */
	JgclTrimmedCurve2D curve;

	/**
	 * gȐ^ăIuWFNg\zB
	 *
	 * @param curve	gȐ
	 */
	ToTrimConversion(JgclTrimmedCurve2D curve) {
	    this.curve = curve;
	}

	/**
	 * Ȑɑ΂p[^lgȐɑ΂p[^l֕ϊB
	 * 
	 * @param param	Ȑɑ΂p[^l
	 * @return	gȐɑ΂p[^l
	 */
	double convParameter(double param) {
	    return curve.toOwnParameter(param);
	}

	/**
	 * Ȑɑ΂p[^lϊΏۂłgȐԂB
	 * 
	 * @param param Ȑɑ΂p[^l
	 * @return	gȐ
	 */
	JgclParametricCurve2D convCurve(double param) {
	    return curve;
	}
    }

    /**
     * aXvCȐɑ΂p[^l
     * gȐɑ΂p[^lւ̕ϊ\NXB
     * @see	#interfere(JgclBoundedCurve2D, boolean)
     */
    class BsplineConversion extends JgclParameterConversion2D {
	/**
	 * gȐB
	 */
	JgclTrimmedCurve2D curve;

	/**
	 * aXvCȐB
	 */
	JgclBoundedCurve2D bcurve;

	/**
	 * gȐƂaXvCȐ^ăIuWFNg\zB
	 *
	 * @param curve	gȐ
	 * @param bcurve	aXvCȐ
	 */
	BsplineConversion(JgclTrimmedCurve2D curve,
			  JgclBoundedCurve2D bcurve) {
	    this.curve = curve;
	    this.bcurve = bcurve;
	}

	/**
	 * aXvCȐɑ΂p[^lgȐɑ΂p[^l֕ϊB
	 * <p>
	 * ^ꂽp[^lɑΉaXvCȐ̓_
	 * gȐ̕ȐɏĂȂꍇɂ
	 * JgclInvalidArgumentValue ̗O𔭐B
	 * </p>
	 * 
	 * @param param	aXvCȐɑ΂p[^l
	 * @return	gȐɑ΂p[^l
	 * @see	JgclParametricCurve2D#pointToParameter(JgclPoint2D)
	 * @see	JgclInvalidArgumentValue
	 */
	double convParameter(double param) {
	    JgclPointOnCurve2D pnt = new JgclPointOnCurve2D(bcurve, param, doCheckDebug);
	    double bparam = curve.basisCurve().pointToParameter(pnt);
	    return curve.toOwnParameter(bparam);
	}

	/**
	 * aXvCȐɑ΂p[^lϊΏۂłgȐԂB
	 * 
	 * @param param	aXvCȐɑ΂p[^l
	 * @return	gȐ
	 */
	JgclParametricCurve2D convCurve(double param) {
	    return curve;
	}
    }

    /**
     * ̗LȐƑ̗LȐ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		Ȑ̊̔z
     */
    public JgclCurveCurveInterference2D[] interfere(JgclBoundedCurve2D mate) {
	return this.interfere(mate, false);
    }

    /**
     * ̗LȐƑ̗LȐ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̋Ȑ̕ȐƑ̗LȐ̊߂ɁA
     * ̓̂̋Ȑ̃g~OԂ̓Ɏ܂Ă镔
     * uvƂĂB
     * ȂA̋Ȑ̕ȐLłȂꍇɂ́A
     * Ȑ̃g~OԂLaXvCȐɕϊA
     * ̗LaXvCȐƑ̗LȐ̊x[X̊ƂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     * @see	JgclTrimmedCurve2D.ToTrimConversion
     * @see	JgclTrimmedCurve2D.BsplineConversion
     */
    JgclCurveCurveInterference2D[] interfere(JgclBoundedCurve2D mate,
					     boolean doExchange) {
	JgclCurveCurveInterferenceList intfList
	    = new JgclCurveCurveInterferenceList(this, mate);
	JgclParameterDomain domain = parameterDomain();
	JgclBoundedCurve2D bcurve;
	JgclParameterConversion2D conv;
	JgclParameterSection sec =
	    new JgclParameterSection(tParam1, tParam2 - tParam1);

	if (basisCurve instanceof JgclBoundedCurve2D) {
	    bcurve = (JgclBoundedCurve2D)basisCurve;
	    conv = new ToTrimConversion(this);
	}
	else {
	    bcurve = basisCurve.toBsplineCurve(sec);
	    conv = new BsplineConversion(this, bcurve);
	}

	JgclCurveCurveInterference2D[] intf;
	if (!doExchange) {
	    intf = bcurve.interfere(mate);
	} else {
	    intf = mate.interfere(bcurve);
	}

	Vector vec = new Vector();

	for (int i = 0; i < intf.length; i++) {
	    JgclCurveCurveInterference2D trimintf;
	    if (!doExchange) {
		trimintf = intf[i].trim1(sec, conv);
	    } else {
		trimintf = intf[i].trim2(sec, conv);
	    }
	    if (trimintf != null)
		vec.addElement(trimintf);
	}
	JgclCurveCurveInterference2D[] interf =
	    new JgclCurveCurveInterference2D[vec.size()];
	vec.copyInto(interf);
	return interf;
    }

    /**
     * ̗LȐƑ̗LȐ () ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ ()
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#interfere(JgclBoundedCurve2D, boolean)
     */
    JgclCurveCurveInterference2D[] interfere(JgclBoundedLine2D mate,
					     boolean doExchange)
    {
	return this.interfere((JgclBoundedCurve2D)mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (|C) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (|C)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#interfere(JgclBoundedCurve2D, boolean)
     */
    JgclCurveCurveInterference2D[] interfere(JgclPolyline2D mate,
					     boolean doExchange)
    {
	return this.interfere((JgclBoundedCurve2D)mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (xWGȐ) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (xWGȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#interfere(JgclBoundedCurve2D, boolean)
     */
    JgclCurveCurveInterference2D[] interfere(JgclPureBezierCurve2D mate,
					     boolean doExchange)
    {
	return this.interfere((JgclBoundedCurve2D)mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (aXvCȐ) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (aXvCȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#interfere(JgclBoundedCurve2D, boolean)
     */
    JgclCurveCurveInterference2D[] interfere(JgclBsplineCurve2D mate,
					     boolean doExchange)
    {
	return this.interfere((JgclBoundedCurve2D)mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (gȐ) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (gȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#interfere(JgclBoundedCurve2D, boolean)
     */
    JgclCurveCurveInterference2D[] interfere(JgclTrimmedCurve2D mate,
					     boolean doExchange) {
	return this.interfere((JgclBoundedCurve2D)mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (ȐZOg) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (ȐZOg)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#interfere(JgclBoundedCurve2D, boolean)
     */
    JgclCurveCurveInterference2D[] interfere(JgclCompositeCurveSegment2D mate,
					     boolean doExchange) {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (Ȑ) ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̗LȐ (Ȑ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		
     * @see	#interfere(JgclBoundedCurve2D, boolean)
     */
    JgclCurveCurveInterference2D[] interfere(JgclCompositeCurve2D mate,
					     boolean doExchange) {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̋Ȑ̎w̋ԂItZbgȐA
     * ^ꂽ덷ŋߎ Bspline Ȑ߂B
     * 
     * @param pint	ItZbgp[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.LEFT/RIGHT)
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ̃ItZbgȐߎ Bspline Ȑ
     * @see	JgclWhichSide
     */
    public JgclBsplineCurve2D
	offsetByBsplineCurve(JgclParameterSection pint,
			     double magni,
                             int side,
                             JgclToleranceForDistance tol) {
	JgclOfst2D doObj = new JgclOfst2D(this,pint,magni,side,tol);
	return doObj.offset();
    }

    /**
     * ̋Ȑ̎w̋ԂItZbgȐA
     * ^ꂽ덷ŋߎLȐ߂B
     * 
     * @param pint	ItZbgp[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.LEFT/RIGHT)
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ̃ItZbgȐߎLȐ
     * @see	JgclWhichSide
     */
    public JgclBoundedCurve2D
        offsetByBoundedCurve(JgclParameterSection pint,
			     double magni,
                             int side,
                             JgclToleranceForDistance tol)
    {
	JgclParameterSection basisPint = this.toBasisParameter(pint);
	int basisSide = (this.senseAgreement() == true)
	    ? side : JgclWhichSide.reverse(side);

	return this.basisCurve().offsetByBoundedCurve(basisPint, magni, basisSide, tol);
    }

    /**
     * ̋Ȑ̎w̋ԂƁA̋Ȑ̎w̋ԂɂtBbg߂B
     * <p>
     * tBbg݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param pint1	̋Ȑ̃p[^
     * @param side1	̋Ȑ̂ǂ瑤ɃtBbg߂邩tO
     *			(JgclWhichSide.LEFTȂ΍ARIGHTȂΉEABOTHȂΗ)
     * @param mate	̋Ȑ
     * @param pint2	̋Ȑ̃p[^
     * @param side2	̋Ȑ̂ǂ瑤ɃtBbg߂邩tO
     *			(JgclWhichSide.LEFTȂ΍ARIGHTȂΉEABOTHȂΗ)
     * @param radius	tBbga
     * @param doExchange	tBbg point1/2 邩ǂ
     * @return		tBbg̔z
     * @exception JgclIndefiniteSolution	s (ł͔Ȃ)
     */
    JgclFilletObject2D[]
	doFillet(JgclParameterSection pint1, int side1, JgclParametricCurve2D mate,
		 JgclParameterSection pint2, int side2, double radius,
		 boolean doExchange)
	throws JgclIndefiniteSolution
    {
	Vector intsvec = new Vector();

	JgclFilletObject2D[] flts;
	try {
	    flts = basisCurve.fillet(toBasisParameter(pint1), side1, mate, pint2, side2, radius);
	} catch (JgclIndefiniteSolution e) {
	    flts = new JgclFilletObject2D[1];
	    flts[0] = (JgclFilletObject2D)e.suitable();
	}
	JgclParameterDomain domain = parameterDomain();

	for (int i = 0; i < flts.length; i++) {
	    double param = toOwnParameter(flts[i].pointOnCurve1().parameter());

	    JgclPointOnCurve2D pnt = new JgclPointOnCurve2D(this, param, doCheckDebug);

	    if (!doExchange)
		flts[i] = new JgclFilletObject2D(radius, flts[i].center(), pnt, flts[i].pointOnCurve2());
	    else
		flts[i] = new JgclFilletObject2D(radius, flts[i].center(), flts[i].pointOnCurve2(), pnt);
	}
	return flts;
    }

    /**
     * ̋ȐƑ̋ȐƂ̋ʐڐ߂B
     * <p>
     * ʐڐ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * _ł͎ĂȂ߁A
     * JgclNotSupported	̗O𔭐B
     * </p>
     *
     * @param mate	̋Ȑ
     * @return		ʐڐ̔z
     * @exception	JgclNotSupported	܂̂ƂAȂ@\ł
     */
    public JgclCommonTangent2D[] commonTangent(JgclParametricCurve2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋ȐƂ̋ʖ@߂B
     * <p>
     * ʖ@݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * _ł͎ĂȂ߁A
     * JgclNotSupported	̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		ʖ@̔z
     * @exception	JgclNotSupported	܂̂ƂAȂ@\ł
     */
    public JgclCommonNormal2D[]	commonNormal(JgclParametricCurve2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋Ȑ̃p[^`ԂB
     * <p>
     * [0, |tParam2 - tParam1|] ԂB
     * </p>
     * 
     * @return	LŔIȃp[^`
     */
    JgclParameterDomain getParameterDomain() {
	try {
	    return new JgclParameterDomain(false, 0,
					   Math.abs(tParam2 - tParam1));
	}
	catch (JgclInvalidArgumentValue e) {
	    // should never be occurred
	    throw new JgclFatal();
	}
    }

    /**
     * ̊􉽗vfR`󂩔ۂԂB
     *
     * @return	ȐR`ł trueAłȂ false
     */
    public boolean isFreeform() {
	return this.basisCurve.isFreeform();
    }

    /**
     * ̗LȐ̊Jn_ԂB
     * <p>
     * masterRepresentation1  PARAMETER Ȃ΁AȐ tParam1 ŕ]lԂB
     * masterRepresentation1  POINT Ȃ΁AtPnt1 ԂB
     * </p>
     *
     * @return	Jn_
     */
    public JgclPoint2D startPoint() {
	JgclPoint2D pnt1;

	try {
	    if (this.tPnt1 == null ||
		masterRepresentation1 == JgclTrimmingPreference.PARAMETER)
		pnt1 = basisCurve.coordinates(tParam1);
	    else
		pnt1 = this.tPnt1;
	}
	catch (JgclParameterOutOfRange e) {
	    // should never be occurred
	    throw new JgclFatal();
	}
	if (this.tPnt1 == null)
	    this.tPnt1 = pnt1;
	return pnt1;
    }

    /**
     * ̗LȐ̏I_ԂB
     * <p>
     * masterRepresentation2  PARAMETER Ȃ΁AȐ tParam2 ŕ]lԂB
     * masterRepresentation2  POINT Ȃ΁AtPnt2 ԂB
     * </p>
     *
     * @return	I_
     */
    public JgclPoint2D endPoint() {
	JgclPoint2D pnt2;

	try {
	    if (this.tPnt2 == null ||
		masterRepresentation2 == JgclTrimmingPreference.PARAMETER)
		pnt2 = basisCurve.coordinates(tParam2);
	    else
		pnt2 = this.tPnt2;
	}
	catch (JgclParameterOutOfRange e) {
	    // should never be occurred
	    throw new JgclFatal();
	}
	if (this.tPnt2 == null)
	    this.tPnt2 = pnt2;
	return pnt2;
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricCurve2D#TRIMMED_CURVE_2D JgclParametricCurve2D.TRIMMED_CURVE_2D}
     */
    int type() {
	return TRIMMED_CURVE_2D;
    }

    /**
     * ̋ȐA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricCurve2D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator2D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclParametricCurve2D tBasisCurve =
	    this.basisCurve().transformBy(reverseTransform,
					  transformationOperator,
					  transformedGeometries);
	JgclPoint2D tTPnt1 = null;
	JgclPoint2D tTPnt2 = null;
	if (this.masterRepresentation1() == JgclTrimmingPreference.POINT)
	    tTPnt1 = this.tPnt1().transformBy(reverseTransform,
					      transformationOperator,
					      transformedGeometries);
	if (this.masterRepresentation2() == JgclTrimmingPreference.POINT)
	    tTPnt2 = this.tPnt2().transformBy(reverseTransform,
					      transformationOperator,
					      transformedGeometries);

	return new JgclTrimmedCurve2D(tBasisCurve,
				      tTPnt1, tTPnt2,
				      this.tParam1(), this.tParam2(),
				      this.masterRepresentation1(),
				      this.masterRepresentation2(),
				      this.senseAgreement());
    }

    /**
     * ̋Ȑ|C̕܂ނۂԂB
     *
     * @return	̋Ȑ|Cł邩A
     *		܂͎g\镔iƂă|C܂ނȂ trueA
     *		łȂ false
     */
    protected boolean hasPolyline() {
	return basisCurve.hasPolyline();
    }

    /**
     * ̋Ȑ|C̕łłĂ邩ۂԂB
     *
     * @return	̋Ȑ|Cł邩A
     *		܂͎g\镔iƂă|C܂ނȂ trueA
     *		łȂ false
     */
    protected boolean isComposedOfOnlyPolylines() {
	return basisCurve.isComposedOfOnlyPolylines();
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tbasisCurve");
        basisCurve.output(writer, indent + 2);
	if (tPnt1 != null) {
	    writer.println(indent_tab + "\ttPnt1");
	    tPnt1.output(writer, indent + 2);
	}
	if (tPnt2 != null) {
	    writer.println(indent_tab + "\ttPnt2");
	    tPnt2.output(writer, indent + 2);
	}
        writer.println(indent_tab + "\ttParam1\t" + tParam1);
        writer.println(indent_tab + "\ttParam2\t" + tParam2);
        writer.println(indent_tab + "\tmasterRepresentation1\t"
		+ JgclTrimmingPreference.toString(masterRepresentation1));
        writer.println(indent_tab + "\tmasterRepresentation2\t"
		+ JgclTrimmingPreference.toString(masterRepresentation2));
        writer.println(indent_tab + "\tsenseAgreement\t" + senseAgreement);
        writer.println(indent_tab + "End");
    }
}
