/*
 * Ȗʓm̊̃XgNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclSurfaceSurfaceInterferenceList.java,v 1.17 2000/04/26 09:39:25 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * Ȗʓm̊̃XgNX
 *
 * @version $Revision: 1.17 $, $Date: 2000/04/26 09:39:25 $
 * @author Information-technology Promotion Agency, Japan
 */
class JgclSurfaceSurfaceInterferenceList
{
    static int debugFlag = 0;
    static final int DEBUG_TRACE = 1;
    static final int OMIT_BOUNDARY_CHECK = 2;

    static final boolean REMOVE_NO_LENGTH_SEGMENT = false;

    /**
     * Ȗ A
     */
    JgclParametricSurface3D surfaceA;

    /**
     * Ȗ A ̒`
     */
    JgclParameterDomain uParameterDomainA;
    JgclParameterDomain vParameterDomainA;

    /**
     * Ȗ B
     */
    JgclParametricSurface3D surfaceB;

    /**
     * Ȗ B ̒`
     */
    JgclParameterDomain uParameterDomainB;
    JgclParameterDomain vParameterDomainB;

    /**
     * ̋e덷 (IuWFNg\zꂽ_ł)
     */
    JgclToleranceForDistance dTol;

    /**
     * _̃Xg
     */
    Vector listOfPoints;

    /**
     * ̃Xg
     */
    Vector listOfCurves;

    /**
     * fĂZOg̃Xg
     */
    Vector listOfCurveSegments;

    /*
     * IuWFNg\z
     *
     * @param	surfaceA	Ȗ A
     * @param	surfaceB	Ȗ B
     */
    JgclSurfaceSurfaceInterferenceList(JgclParametricSurface3D surfaceA,
				       JgclParametricSurface3D surfaceB)
    {
	if ((surfaceA == null) || (surfaceB == null))
	    throw new JgclNullArgument();

	this.surfaceA = surfaceA;
	this.uParameterDomainA = surfaceA.uParameterDomain();
	this.vParameterDomainA = surfaceA.vParameterDomain();

	this.surfaceB = surfaceB;
	this.uParameterDomainB = surfaceB.uParameterDomain();
	this.vParameterDomainB = surfaceB.vParameterDomain();

	JgclConditionOfOperation cond = JgclConditionOfOperation.getCondition();
	this.dTol = cond.getToleranceForDistanceAsObject();

	this.listOfPoints = new Vector();
	this.listOfCurves = new Vector();
	this.listOfCurveSegments = new Vector();
    }

    /**
     * Ȗʂ̂p[^lt߂łŨp[^̋e덷߂B
     *
     * ToleranceForDistance Zo
     *
     * @param	surface	Ȗ
     * @param	uParam	Up[^l
     * @param	vParam	Vp[^l
     */
    private double getToleranceForParameterU(JgclParametricSurface surface,
					     double uParam, double vParam)
    {
	return dTol.toToleranceForParameterU((JgclParametricSurface3D)surface,
					     uParam, vParam).value();
    }

    /**
     * ڑ_Ȗʂ̂ȂڂzꍇɃp[^l␳
     *
     * @param domain		p[^hC
     * @param param		Ώۃp[^
     * @param lastParam		Õp[^
     * @return			␳ꂽp[^
     */
    private static double adjustParam(JgclParameterDomain domain,
				      double param,
				      double lastParam) {
	if (domain.isNonPeriodic())
	    return param;

	double absInc = domain.section().absIncrease();
	double threshold = lastParam - absInc / 2.0;
	while (param < threshold)
	    param += absInc;
	threshold = lastParam + absInc / 2.0;
	while (param > threshold)
	    param -= absInc;
	return param;
    }

    /**
     * 2Dp[^ԂŕĂ邩ǂ𒲂ׂ
     *
     * @param uDomain		Ũp[^hC
     * @param vDomain		Ṽp[^hC
     * @param uSParam		n_Up[^
     * @param vSParam		n_Vp[^
     * @param uEParam		I_Up[^
     * @param vEParam		I_Vp[^
     * @param closed3D		3DŕĂ邩?
     * @return			Ă邩ǂ
     */
    private static boolean checkClosed2D(JgclParameterDomain uDomain,
					 JgclParameterDomain vDomain,
					 double uSParam, double vSParam,
					 double uEParam, double vEParam,
					 boolean closed3D) {
	if (!closed3D)
	    return false;	// 3DŊJĂȂKJĂ

	if (uDomain.isPeriodic()) {
	    if (Math.abs(uEParam - uSParam) > uDomain.section().absIncrease() / 2.0)
		return false;
	}
	if (vDomain.isPeriodic()) {
	    if (Math.abs(vEParam - vSParam) > vDomain.section().absIncrease() / 2.0)
		return false;
	}
	return true;
    }

    /**
     * Ȗʂ̂p[^lt߂łṼp[^̋e덷߂B
     *
     * ToleranceForDistance Zo
     *
     * @param	surface	Ȗ
     * @param	uParam	Up[^l
     * @param	vParam	Vp[^l
     */
    private double getToleranceForParameterV(JgclParametricSurface surface,
					     double uParam, double vParam)
    {
	return dTol.toToleranceForParameterV((JgclParametricSurface3D)surface,
					     uParam, vParam).value();
    }

    /*
     * _̃p[^lƂ݂Ȃ邩ۂAɊւ萔
     */
    private static final int PARAMETERS_NOT_IDENTICAL   = 0x0;
    private static final int PARAMETERS_IDENTICAL       = 0x1;
    private static final int PARAMETERS_CROSSBOUNDARY_U_A = 0x2;
    private static final int PARAMETERS_CROSSBOUNDARY_V_A = 0x4;
    private static final int PARAMETERS_CROSSBOUNDARY_U_B = 0x8;
    private static final int PARAMETERS_CROSSBOUNDARY_V_B = 0x10;

    /**
     * _̃p[^lƂ݂Ȃ邩ۂA\
     */
    class ParametricalIdentityOfTwoIntersections {
	/**
	 * _̃p[^lƂ݂Ȃ邩ۂA\
	 */
	private int value;

	/**
	 * IuWFNg\z
	 */
	ParametricalIdentityOfTwoIntersections() {
	    setNonIdentical();
	}

	/**
	 * _̃p[^lƂ݂ȂȂ̂Ƃ
	 */
	private void setNonIdentical() {
	    value = PARAMETERS_NOT_IDENTICAL;
	}

	/**
	 * _̃p[^lƂ݂Ȃ̂Ƃ
	 */
	private void setIdentical() {
	    value |= PARAMETERS_IDENTICAL;
	}

	/**
	 * _̃p[^lȖ A UÊׂƂ
	 */
	private void setCrossBoundaryOfAu()
	{
	    value |= PARAMETERS_CROSSBOUNDARY_U_A;
	}

	/**
	 * _̃p[^lȖ A VÊׂƂ
	 */
	private void setCrossBoundaryOfAv()
	{
	    value |= PARAMETERS_CROSSBOUNDARY_V_A;
	}

	/**
	 * _̃p[^lȖ B UÊׂƂ
	 */
	private void setCrossBoundaryOfBu()
	{
	    value |= PARAMETERS_CROSSBOUNDARY_U_B;
	}

	/**
	 * _̃p[^lȖ B VÊׂƂ
	 */
	private void setCrossBoundaryOfBv()
	{
	    value |= PARAMETERS_CROSSBOUNDARY_V_B;
	}

	/**
	 * _̃p[^lƂ݂Ȃ邩ۂ
	 */
	private boolean isIdentical()
	{
	    return ((value & PARAMETERS_IDENTICAL) != 0);
	}

	/**
	 * _̃p[^lȖ A ŰEׂۂ
	 */
	private boolean isCrossBoundaryOfAu()
	{
	    return ((value & PARAMETERS_CROSSBOUNDARY_U_A) != 0);
	}

	/**
	 * _̃p[^lȖ A V̋Eׂۂ
	 */
	private boolean isCrossBoundaryOfAv()
	{
	    return ((value & PARAMETERS_CROSSBOUNDARY_V_A) != 0);
	}

	/**
	 * _̃p[^lȖ B ŰEׂۂ
	 */
	private boolean isCrossBoundaryOfBu()
	{
	    return ((value & PARAMETERS_CROSSBOUNDARY_U_B) != 0);
	}

	/**
	 * _̃p[^lȖ B V̋Eׂۂ
	 */
	private boolean isCrossBoundaryOfBv()
	{
	    return ((value & PARAMETERS_CROSSBOUNDARY_V_B) != 0);
	}
    }

    /**
     * _̏
     */
    class PointInfo
    {
	/**
	 * _̍Wl (null Ȃ)
	 */
	JgclPoint3D coord;

	/**
	 * _̋Ȗ A łŨp[^l
	 */
	double uParamA;

	/**
	 * _̋Ȗ A łṼp[^l
	 */
	double vParamA;

	/**
	 * _̋Ȗ B łŨp[^l
	 */
	double uParamB;

	/**
	 * _̋Ȗ B łṼp[^l
	 */
	double vParamB;

	/**
	 * Ȗ A  [uv]ParamA t߂ł̃p[^Űe덷
	 */
	double pTolAu;

	/**
	 * Ȗ A  [uv]ParamA t߂ł̃p[^V̋e덷
	 */
	double pTolAv;

	/**
	 * Ȗ B  [uv]ParamB t߂ł̃p[^Űe덷
	 */
	double pTolBu;

	/**
	 * Ȗ B  [uv]ParamB t߂ł̃p[^V̋e덷
	 */
	double pTolBv;

	/**
	 * IuWFNg\z
	 *
	 * @param	coord	_̍Wl (null Ȃ)
	 * @param	uParamA	_̋Ȗ A łUp[^l
	 * @param	vParamA	_̋Ȗ A łVp[^l
	 * @param	uParamB	_̋Ȗ B łUp[^l
	 * @param	vParamB	_̋Ȗ B łVp[^l
	 */
	PointInfo(JgclPoint3D coord,
		  double uParamA, double vParamA,
		  double uParamB, double vParamB)
	{
	    this.coord = coord;	// null Ȃ

	    this.uParamA = uParamA;
	    this.vParamA = vParamA;
	    this.uParamB = uParamB;
	    this.vParamB = vParamB;

	    this.pTolAu = getToleranceForParameterU(surfaceA, uParamA, vParamA);
	    this.pTolAv = getToleranceForParameterV(surfaceA, uParamA, vParamA);
	    this.pTolBu = getToleranceForParameterU(surfaceB, uParamB, vParamB);
	    this.pTolBv = getToleranceForParameterV(surfaceB, uParamB, vParamB);
	}

	/**
	 * IuWFNg\z
	 *
	 * @param	coord	_̍Wl (null Ȃ)
	 * @param	uParamA	_̋Ȗ A łUp[^l
	 * @param	vParamA	_̋Ȗ A łVp[^l
	 * @param	uParamB	_̋Ȗ B łUp[^l
	 * @param	vParamB	_̋Ȗ B łVp[^l
	 * @param	pTolAu	Ȗ A  [uv]ParamA t߂łUp[^̋e덷
	 * @param	pTolAv	Ȗ A  [uv]ParamA t߂łVp[^̋e덷
	 * @param	pTolBu	Ȗ B  [uv]ParamB t߂łUp[^̋e덷
	 * @param	pTolBv	Ȗ B  [uv]ParamB t߂łVp[^̋e덷
	 */
	PointInfo(JgclPoint3D coord,
		  double uParamA, double vParamA,
		  double uParamB, double vParamB,
		  double pTolAu, double pTolAv,
		  double pTolBu, double pTolBv)
	{
	    this.coord = coord;	// null Ȃ

	    this.uParamA = uParamA;
	    this.vParamA = vParamA;
	    this.uParamB = uParamB;
	    this.vParamB = vParamB;

	    this.pTolAu = pTolAu;
	    this.pTolAv = pTolAv;
	    this.pTolBu = pTolBu;
	    this.pTolBv = pTolBv;
	}

	private JgclPoint3D coordinates() {
	    if (coord != null)
		return coord;

	    JgclPoint3D pntA = surfaceA.coordinates(uParamA, vParamA);
	    JgclPoint3D pntB = surfaceB.coordinates(uParamB, vParamB);
	    return pntA.linearInterpolate(pntB, 0.5);
	}

	/**
	 * _̃p[^lƂ݂Ȃ邩ۂAɂĂ̏𓾂
	 *
	 * @param	mate	_̏
	 */
	private ParametricalIdentityOfTwoIntersections getParametricalIdentityWith(PointInfo mate)
	{
	    ParametricalIdentityOfTwoIntersections result =
		new ParametricalIdentityOfTwoIntersections();

	    if (this == mate) {
		result.setIdentical();
		return result;
	    }

	    double diffAu = Math.abs(this.uParamA - mate.uParamA);
	    double diffAv = Math.abs(this.vParamA - mate.vParamA);
	    double diffBu = Math.abs(this.uParamB - mate.uParamB);
	    double diffBv = Math.abs(this.vParamB - mate.vParamB);

	    double pTolAu = Math.max(this.pTolAu, mate.pTolAu);
	    double pTolAv = Math.max(this.pTolAv, mate.pTolAv);
	    double pTolBu = Math.max(this.pTolBu, mate.pTolBu);
	    double pTolBv = Math.max(this.pTolBv, mate.pTolBv);

	    if ((uParameterDomainA.isPeriodic() == true) &&
		(Math.abs(diffAu - uParameterDomainA.section().absIncrease()) < pTolAu))
		result.setCrossBoundaryOfAu();

	    if ((vParameterDomainA.isPeriodic() == true) &&
		(Math.abs(diffAv - vParameterDomainA.section().absIncrease()) < pTolAv))
		result.setCrossBoundaryOfAv();

	    if ((uParameterDomainB.isPeriodic() == true) &&
		(Math.abs(diffBu - uParameterDomainB.section().absIncrease()) < pTolBu))
		result.setCrossBoundaryOfBu();

	    if ((vParameterDomainB.isPeriodic() == true) &&
		(Math.abs(diffBv - vParameterDomainB.section().absIncrease()) < pTolBv))
		result.setCrossBoundaryOfBv();

	    if (((result.isCrossBoundaryOfAu() == true) || (diffAu < pTolAu)) &&
		((result.isCrossBoundaryOfAv() == true) || (diffAv < pTolAv)) &&
		((result.isCrossBoundaryOfBu() == true) || (diffBu < pTolBu)) &&
		((result.isCrossBoundaryOfBv() == true) || (diffBv < pTolBv)))
		result.setIdentical();

	    return result;
	}

	/**
	 * _Ƃ݂Ȃ邩ۂ
	 *
	 * @param	mate	_̏
	 */
	private boolean isIdenticalWith(PointInfo mate)
	{
	    if ((this.coord != null) && (mate.coord != null)) {
		if (this.coord.identical(mate.coord) != true)
		    return false;
	    }

	    return this.getParametricalIdentityWith(mate).isIdentical();
	}

	/**
	 * _Eɂ邩ǂ
	 *
	 * @retrun	Eɂtrue
	 */
	private boolean isBoundary() {
	    double u_param_a, v_param_a, u_param_b, v_param_b;
	    PointInfo pinfo;
	    for (int i = 0; i < 8; i++) {
		u_param_a = uParamA;
		v_param_a = vParamA;
		u_param_b = uParamB;
		v_param_b = vParamB;
		if (i < 2) {
		    if (uParameterDomainA.isPeriodic() || uParameterDomainA.isInfinite())
			continue;
		    if (i == 0)
			u_param_a = uParameterDomainA.section().start();
		    else
			u_param_a = uParameterDomainA.section().end();
		} else if (i < 4) {
		    if (vParameterDomainA.isPeriodic() || vParameterDomainA.isInfinite())
			continue;
		    if (i == 2)
			v_param_a = vParameterDomainA.section().start();
		    else
			v_param_a = vParameterDomainA.section().end();
		} else if (i < 6) {
		    if (uParameterDomainB.isPeriodic() || uParameterDomainB.isInfinite())
			continue;
		    if (i == 4)
			u_param_b = uParameterDomainB.section().start();
		    else
			u_param_b = uParameterDomainB.section().end();
		} else {
		    if (vParameterDomainB.isPeriodic() || vParameterDomainB.isInfinite())
			continue;
		    if (i == 6)
			v_param_b = vParameterDomainB.section().start();
		    else
			v_param_b = vParameterDomainB.section().end();
		}
		pinfo = new PointInfo(null, u_param_a, v_param_a, u_param_b, v_param_b);
		if (isIdenticalWith(pinfo))
		    return true;
	    }

	    return false;
	}

	/**
	 * ^ꂽp[^̋E̍Ԃ
	 */
	private double getBoundaryGap(int which, int side) {
	    double para;

	    switch (which) {
	    default: throw new JgclFatal();
	    case Wp_Au: para = uParamA; break;
	    case Wp_Av: para = vParamA; break;
	    case Wp_Bu: para = uParamB; break;
	    case Wp_Bv: para = vParamB; break;
	    }

	    if (side == UPPER)
		return Math.abs(1.0 - para);
	    else
		return Math.abs(para);
	}
    }

    // BoundaryInfo indicator
    static final int Wp_No = 0;
    static final int Wp_Au = 1;
    static final int Wp_Av = 2;
    static final int Wp_Bu = 3;
    static final int Wp_Bv = 4;

    static final int Wp_START = 1;
    static final int Wp_END = 5;

    // which boundary of surface
    static final int LOWER = 0;
    static final int UPPER = 1;

    static final int Wside_START = 0;
    static final int Wside_END = 2;

    /**
     * Ȗʂ̋E\NX
     */
    final class BoundaryInfo {
	int wend;
	int param;
	boolean is_boundary;
	PointInfo pi;

	void setBoundaryInfo(double gap) {
	    double g;

	    for (int i = Wp_START; i < Wp_END; i++) {
		for (int j = Wside_START; j < Wside_END; j++) {
		    g = pi.getBoundaryGap(i, j);
		    if (g < gap && param != i) {
			gap = g;
			param = i;
			wend = j;
		    }
		}
	    }
	}

	BoundaryInfo(int ref_param, PointInfo pi) {
	    double pTol = JgclConditionOfOperation.getCondition()
		.getToleranceForParameter();
	    param = ref_param;
	    is_boundary = true;
	    this.pi = pi;

	    setBoundaryInfo(pTol);
	}
    }

    /**********************************************************************
     *
     * Refinement
     *
     **********************************************************************/

    final class RefineInfo {
	JgclPoint3D sA_pnt, sB_pnt;
	JgclVector3D[] Atang;
	JgclVector3D[] Btang;
	double fx_param;
	BoundaryInfo bi;

	RefineInfo() {
	}

	double[] setupParams(PointInfo pi) {
	    double[] param = new double[3];

	    switch (bi.param) {
	    case Wp_Au:
		fx_param = pi.uParamA; param[0] = pi.vParamA;
		param[1] = pi.uParamB; param[2] = pi.vParamB;
		break;
	    case Wp_Av:
		param[0] = pi.uParamA; fx_param = pi.vParamA;
		param[1] = pi.uParamB; param[2] = pi.vParamB;
		break;
	    case Wp_Bu:
		param[0] = pi.uParamA; param[1] = pi.vParamA;
		fx_param = pi.uParamB; param[2] = pi.vParamB;
		break;
	    case Wp_Bv:
		param[0] = pi.uParamA; param[1] = pi.vParamA;
		param[2] = pi.uParamB; fx_param = pi.vParamB;
		break;
	    }

	    return param;
	}

	void fillParam(double[] param) {
	    double[] A = new double[2];
	    double[] B = new double[2];

	    switch (bi.param) {
	    case Wp_Au:
		A[0] = fx_param; A[1] = param[0];
		B[0] = param[1]; B[1] = param[2];
		break;
	    case Wp_Av:
		A[0] = param[0]; A[1] = fx_param;
		B[0] = param[1]; B[1] = param[2];
		break;
	    case Wp_Bu:
		A[0] = param[0]; A[1] = param[1];
		B[0] = fx_param; B[1] = param[2];
		break;
	    case Wp_Bv:
		A[0] = param[0]; A[1] = param[1];
		B[0] = param[2]; B[1] = fx_param;
		break;
	    }

	    A[0] = surfaceA.uParameterDomain().force(A[0]);
	    A[1] = surfaceA.vParameterDomain().force(A[1]);
	    B[0] = surfaceB.uParameterDomain().force(B[0]);
	    B[1] = surfaceB.vParameterDomain().force(B[1]);

	    sA_pnt = surfaceA.coordinates(A[0], A[1]);
	    sB_pnt = surfaceB.coordinates(B[0], B[1]);

	    Atang = surfaceA.tangentVector(A[0], A[1]);
	    Btang = surfaceB.tangentVector(B[0], B[1]);
	    Btang[0] = Btang[0].multiply(-1);
	    Btang[1] = Btang[1].multiply(-1);
	}

	JgclVector3D[] getVectors() {
	    JgclVector3D[] vecs = null;
	    switch(bi.param) {
	    case Wp_Au:
		{
		    JgclVector3D[] v = { Atang[1], Btang[0], Btang[1] };
		    vecs = v;
		}
		break;

	    case Wp_Av:
		{
		    JgclVector3D[] v = { Atang[0], Btang[0], Btang[1] };
		    vecs = v;
		}
		break;

	    case Wp_Bu:
		{
		    JgclVector3D[] v = { Atang[0], Atang[1], Btang[1] };
		    vecs = v;
		}
		break;

	    case Wp_Bv:
		{
		    JgclVector3D[] v = { Atang[0], Atang[1], Btang[0] };
		    vecs = v;
		}
		break;
	    }
	    return vecs;
	}
    }

    private RefineInfo ri;

    private double[] setupParams(PointInfo pi, PointInfo b_pi) {
	BoundaryInfo bi;
	bi = ri.bi = new BoundaryInfo(Wp_No, pi);

	if (bi.param == Wp_No) {
	    /*
	     * point is in the internal area of surfaces
	     *
	     * select a parameter which gap with previous points is maximum
	     * as fixed one
	     */
	    double Au_gap = Math.abs(pi.uParamA - b_pi.uParamA);
	    double Av_gap = Math.abs(pi.vParamA - b_pi.vParamA);
	    double Bu_gap = Math.abs(pi.uParamB - b_pi.uParamB);
	    double Bv_gap = Math.abs(pi.vParamB - b_pi.vParamB);
	    double c_gap;

	    /* at first */ {
		c_gap = Au_gap;
		bi.param = Wp_Au;
	    }
	    if (c_gap < Av_gap) {
		c_gap = Av_gap;
		bi.param = Wp_Av;
	    }
	    if (c_gap < Bu_gap) {
		c_gap = Bu_gap;
		bi.param = Wp_Bu;
	    }
	    if (c_gap < Bv_gap) {
		c_gap = Bv_gap;
		bi.param = Wp_Bv;
	    }
	} else {
	    /*
	     * point is on boundary
	     *
	     * select a parameter which is at boundary as fixed one
	     * BUT if previous point is on same boundary,
	     * select another parameter of same surface as fixed
	     * in order to avoid to converge same coordinates with
	     * previous point
	     * 
	     */
	    BoundaryInfo b_bi = new BoundaryInfo(Wp_No, b_pi);
	    double pTol = JgclConditionOfOperation.getCondition()
		.getToleranceForParameter();

	    if ((b_bi.param == bi.param && b_bi.wend == bi.wend) ||
		b_bi.param == Wp_No) {
		switch (bi.param) {
		case Wp_Au:
		    if ((Math.abs(pi.uParamA - b_pi.uParamA) < pTol) &&
			(Math.abs(pi.vParamA - b_pi.vParamA) > pTol))
			bi.param = Wp_Av;
		    break;

		case Wp_Av:
		    if ((Math.abs(pi.vParamA - b_pi.vParamA) < pTol) &&
			(Math.abs(pi.uParamA - b_pi.uParamA) > pTol))
			bi.param = Wp_Au;
		    break;

		case Wp_Bu:
		    if ((Math.abs(pi.uParamB - b_pi.uParamB) < pTol) &&
			(Math.abs(pi.vParamB - b_pi.vParamB) > pTol))
			bi.param = Wp_Bv;
		    break;

		case Wp_Bv:
		    if ((Math.abs(pi.vParamB - b_pi.vParamB) < pTol) &&
			(Math.abs(pi.uParamB - b_pi.uParamB) > pTol))
			bi.param = Wp_Bu;
		    break;
		}
	    }
	}
	return ri.setupParams(pi);
    }

    private double[] reSetupParams(PointInfo pi) {
	BoundaryInfo bi = ri.bi;
	BoundaryInfo nbi = new BoundaryInfo(bi.param, pi);

	if (nbi.param == bi.param) {
	    switch (nbi.param) {
	    case Wp_Au:	nbi.param = Wp_Av;	break;
	    case Wp_Av:	nbi.param = Wp_Au;	break;
	    case Wp_Bu:	nbi.param = Wp_Bv;	break;
	    case Wp_Bv:	nbi.param = Wp_Bu;	break;
	    }
	}
	ri.bi = nbi;

	return ri.setupParams(pi);
    }

    /*
     * F of F(x) = 0
     */
    private class nlFunc implements JgclRealFunction {
	private nlFunc() {
	    super();
	}

	public double[] evaluate(double[] parameter) {
	    double[] vctr = new double[3];
	    JgclVector3D evec;

	    /*
	     * sA_pnt & sB_pnt are already computed by previous cnv_func()
	     */
	    evec = ri.sA_pnt.subtract(ri.sB_pnt);
	    vctr[0] = evec.x();
	    vctr[1] = evec.y();
	    vctr[2] = evec.z();

	    return vctr;
	}
    }

    /*
     * partial derivatives of F
     */
    private class dnlFunc implements JgclRealFunction {
	int idx;
	private dnlFunc(int idx) {
	    super();
	    this.idx = idx;
	}

	public double[] evaluate(double[] parameter) {
	    JgclVector3D[] vecs = ri.getVectors();

	    double[] mtrx = new double[3];
	    for (int i = 0; i < 3; i++) {
		switch (idx) {
		default:
		case 0: mtrx[i] = vecs[i].x(); break;
		case 1: mtrx[i] = vecs[i].y(); break;
		case 2: mtrx[i] = vecs[i].z(); break;
		}
	    }
	    return mtrx;
	}
    }

    /*
     * convergence test
     */
    private class cnvFunc implements JgclBooleanFunctionWithRealVariables {
	private cnvFunc() {
	    super();
	}

	public boolean evaluate(double[] parameter) {
	    ri.fillParam(parameter);
	    return ri.sA_pnt.identical(ri.sB_pnt);
	}
    }

    // XXX: clip should use ?ParameterDomain?

    private void clipParam(int n, double param[]) {
	if (param[n] < 0.0) param[n] = 0.0;
	if (param[n] > 1.0) param[n] = 1.0;
    }

    private boolean setbackParams(PointInfo pi, double[] param,
				  PointInfo b_pi, PointInfo a_pi)
    {
	double[] A_param = new double[2];
	double[] B_param = new double[2];
	JgclVector2D evec1, evec2;

	// XXX: clip
	switch (ri.bi.param) {
	case Wp_Au:
	    clipParam(1, param); clipParam(2, param);
	    A_param[0] = pi.uParamA; A_param[1] = param[0];
	    B_param[0] = param[1]; B_param[1] = param[2];
	    break;
	case Wp_Av:
	    clipParam(1, param); clipParam(2, param);
	    A_param[0] = param[0]; A_param[1] = pi.vParamA;
	    B_param[0] = param[1]; B_param[1] = param[2];
	    break;
	case Wp_Bu:
	    clipParam(2, param);
	    A_param[0] = param[0]; A_param[1] = param[1];
	    B_param[0] = pi.uParamB; B_param[1] = param[2];
	    break;
	case Wp_Bv:
	    clipParam(2, param);
	    A_param[0] = param[0]; A_param[1] = param[1];
	    B_param[0] = param[2]; B_param[1] = pi.vParamB;
	    break;
	}

	evec1 = new JgclLiteralVector2D(A_param[0] - b_pi.uParamA,
					A_param[1] - b_pi.vParamA);
	evec2 = new JgclLiteralVector2D(pi.uParamA - b_pi.uParamA,
					pi.vParamA - b_pi.vParamA);
	if (evec1.dotProduct(evec2) < 0.0)
	    return false;

	evec1 = new JgclLiteralVector2D(A_param[0] - a_pi.uParamA,
					A_param[1] - a_pi.vParamA);
	evec2 = new JgclLiteralVector2D(pi.uParamA - a_pi.uParamA,
					pi.vParamA - a_pi.vParamA);
	if (evec1.dotProduct(evec2) < 0.0)
	    return false;

	evec1 = new JgclLiteralVector2D(B_param[0] - b_pi.uParamB,
					B_param[1] - b_pi.vParamB);
	evec2 = new JgclLiteralVector2D(pi.uParamB - b_pi.uParamB,
					pi.vParamB - b_pi.vParamB);
	if (evec1.dotProduct(evec2) < 0.0)
	    return false;

	evec1 = new JgclLiteralVector2D(B_param[0] - a_pi.uParamB,
					B_param[1] - a_pi.vParamB);
	evec2 = new JgclLiteralVector2D(pi.uParamB - a_pi.uParamB,
					pi.vParamB - a_pi.vParamB);
	if (evec1.dotProduct(evec2) < 0.0)
	    return false;

	pi.uParamA = A_param[0];
	pi.vParamA = A_param[1];
	pi.uParamB = B_param[0];
	pi.vParamB = B_param[1];

	return true;
    }

    private boolean refinePointInfo(PointInfo pinfo,
				    PointInfo b_pinfo,
				    PointInfo a_pinfo,
				    boolean do_retry)
    {
	double[] param;
	ri = new RefineInfo();

	nlFunc nl_func = new nlFunc();
	JgclRealFunction[] dnl_func = new JgclRealFunction[3];
	dnl_func[0] = new dnlFunc(0);
	dnl_func[1] = new dnlFunc(1);
	dnl_func[2] = new dnlFunc(2);
	cnvFunc cnv_func = new cnvFunc();

	param = setupParams(pinfo, b_pinfo);

	param = JgclMath.solveSimultaneousEquations(nl_func, dnl_func,
						    cnv_func, param);
	if (param == null && do_retry) {
	    // make another parameter fixed, then retry
	    param = reSetupParams(pinfo);
	    param = JgclMath.solveSimultaneousEquations(nl_func, dnl_func,
							cnv_func, param);
	}

	if (param == null) {
	    return false;
	}

	if (!setbackParams(pinfo, param, b_pinfo, a_pinfo)) {
	    return false;
	}
	return true;
    }

    /**
     * _ǉ
     *
     * ɗ^ꂽ_ƓƂ݂Ȃ_ɑ݂Ƃɂ́A
     * ɗ^ꂽ_͒ǉȂ
     *
     * @param	theIntersection	_
     */
    void addIntersectionPoint(PointInfo theIntersection)
    {
	for (Enumeration e = listOfPoints.elements(); e.hasMoreElements();)
	    if (theIntersection.isIdenticalWith((PointInfo)e.nextElement()) == true)
		return;

	listOfPoints.addElement(theIntersection);
    }

    /**
     * _ǉ
     *
     * ɗ^ꂽ_ƓƂ݂Ȃ_ɑ݂Ƃɂ́A
     * ɗ^ꂽ_͒ǉȂ
     *
     * @param	coord	_̍Wl (null Ȃ)
     * @param	uParamA	_̋Ȗ A łŨp[^l
     * @param	vParamA	_̋Ȗ A łṼp[^l
     * @param	uParamB	_̋Ȗ B łŨp[^l
     * @param	vParamB	_̋Ȗ B łṼp[^l
     */
    void addAsIntersectionPoint(JgclPoint3D coord,
				double uParamA,
				double vParamA,
				double uParamB,
				double vParamB)
    {
	if ((debugFlag & DEBUG_TRACE) != 0) {
	    coord.output(System.out);

	    surfaceA.coordinates(uParamA, vParamA).output(System.out);
	    surfaceB.coordinates(uParamB, vParamB).output(System.out);
	}

	addIntersectionPoint(new PointInfo(coord, uParamA, vParamA, uParamB, vParamB));
    }

    /**
     * _ǉ
     *
     * ɗ^ꂽ_ƓƂ݂Ȃ_ɑ݂Ƃɂ́A
     * ɗ^ꂽ_͒ǉȂ
     *
     * @param	coord	_̍Wl (null Ȃ)
     * @param	uParamA	_̋Ȗ A łŨp[^l
     * @param	vParamA	_̋Ȗ A łṼp[^l
     * @param	uParamB	_̋Ȗ B łŨp[^l
     * @param	vParamB	_̋Ȗ B łṼp[^l
     * @param	pTolAu	Ȗ A  [uv]ParamA t߂łŨp[^̋e덷
     * @param	pTolAv	Ȗ A  [uv]ParamA t߂łṼp[^̋e덷
     * @param	pTolBu	Ȗ B  [uv]ParamB t߂łŨp[^̋e덷
     * @param	pTolBv	Ȗ B  [uv]ParamB t߂łṼp[^̋e덷
     */
    void addAsIntersectionPoint(JgclPoint3D coord,
				double uParamA,
				double vParamA,
				double uParamB,
				double vParamB,
				double pTolAu,
				double pTolAv,
				double pTolBu,
				double pTolBv)

    {
	addIntersectionPoint(new PointInfo(coord, uParamA, vParamA, uParamB, vParamB,
					   pTolAu, pTolAv, pTolBu, pTolBv));
    }

    /**
     * ̏
     * (|CɌ)
     */
    class CurveInfo
    {
	Vector segments;

	private CurveInfo(CurveSegmentInfo firstSegment) {
	    segments = new Vector();
	    segments.addElement(firstSegment);
	}

	private int nPoints() {
	    int nPoints = segmentAt(0).nPoints();
	    for (int i = 1; i < nSegments(); i++)
		nPoints += segmentAt(i).nPoints() - 1;
	    return nPoints;
	}

	private int nSegments() {
	    return segments.size();
	}

	private CurveSegmentInfo segmentAt(int index) {
	    return (CurveSegmentInfo)segments.elementAt(index);
	}

	/**
	 * ̊Jn_
	 */
	private PointInfo headPoint() {
	    CurveSegmentInfo headSeg = (CurveSegmentInfo)segments.elementAt(0);
	    return headSeg.headPoint();
	}

	/**
	 * ̏I_
	 */
	private PointInfo tailPoint() {
	    CurveSegmentInfo tailSeg = (CurveSegmentInfo)segments.elementAt(nSegments()-1);
	    return tailSeg.tailPoint();
	}

	/**
	 * Ă邩ǂԂ
	 *
	 * @return	Ătrue
	 */
	private boolean isClosed() {
	    if (nPoints() <= 2)
		return false;

	    return headPoint().isIdenticalWith(tailPoint());
	}

	/**
	 * Sł([Eɂ)ǂԂ
	 *
	 * @return	Słtrue
	 */
	private boolean isComplete() {
	    if ((debugFlag & OMIT_BOUNDARY_CHECK) != 0)
		return true;

	    /*
	     * if both of start & end points are on boundary,
	     * return as a complete solution immediately
	     */
	    if (headPoint().isBoundary() && tailPoint().isBoundary())
		return true;

	    return false;
	}

	/**
	 * ^ꂽZOgn_ɌqĂ΁Athis Ƀ}[W
	 *
	 * @param mate	̌ZOg
	 * @return	qĂ trueAłȂ false
	 */
	private boolean addAtHead(CurveSegmentInfo mate) {
	    ParametricalIdentityOfTwoIntersections identity;

	    // this   mate
	    // -----------
	    // Head - Head
	    identity = this.headPoint().getParametricalIdentityWith(mate.headPoint());
	    if (identity.isIdentical()) {
		mate.reverse();
		segments.insertElementAt(mate, 0);
		mate.setKilled();
		return true;
	    }

	    // Head - Tail
	    identity = this.headPoint().getParametricalIdentityWith(mate.tailPoint());
	    if (identity.isIdentical() == true) {
		segments.insertElementAt(mate, 0);
		mate.setKilled();
		return true;
	    }

	    return false;
	}

	/**
	 * ^ꂽZOgI_ɌqĂ΁Athis Ƀ}[W
	 *
	 * @param mate	̌ZOg
	 * @return	qĂ trueAłȂ false
	 */
	private boolean addAtTail(CurveSegmentInfo mate) {
	    ParametricalIdentityOfTwoIntersections identity;

	    // this   mate
	    // -----------
	    // Tail - Head
	    identity = this.tailPoint().getParametricalIdentityWith(mate.headPoint());
	    if (identity.isIdentical() == true) {
		segments.addElement(mate);
		mate.setKilled();
		return true;
	    }

	    // Tail - Tail
	    identity = this.tailPoint().getParametricalIdentityWith(mate.tailPoint());
	    if (identity.isIdentical() == true) {
		mate.reverse();
		segments.addElement(mate);
		mate.setKilled();
		return true;
	    }

	    return false;
	}

	/**
	 * ^ꂽZOgqĂ΁Athis Ƀ}[W
	 *
	 * @param mate	̌ZOg
	 * @return	qĂ trueAłȂ false
	 */
	private boolean mergeIfConnectWith(CurveSegmentInfo mate) {
	    if (addAtHead(mate))
		return true;

	    return addAtTail(mate);
	}

	/**
	 * JgclIntersectionCurve3DɂĕԂ
	 *
	 * @return	
	 */
	private JgclIntersectionCurve3D getIntersection(boolean doExchange) {
	    CurveSegmentInfo segInfo;
	    PointInfo pInfo;
	    double firstUParamA, firstVParamA, firstUParamB, firstVParamB;
	    double lastUParamA, lastVParamA, lastUParamB, lastVParamB;
	    lastUParamA = lastVParamA = lastUParamB = lastVParamB = 0.0;
	    firstUParamA = firstVParamA = firstUParamB = firstVParamB = 0.0;
	    int i, j, k;
	    for (i = 0; i < nSegments(); i++) {
		segInfo = segmentAt(i);
		pInfo = segInfo.pointAt(0);
		if (i == 0) {
		    firstUParamA = lastUParamA = pInfo.uParamA;
		    firstVParamA = lastVParamA = pInfo.vParamA;
		    firstUParamB = lastUParamB = pInfo.uParamB;
		    firstVParamB = lastVParamB = pInfo.vParamB;
		}
		for (j = 1; j < segInfo.nPoints(); j++) {
		    pInfo = segInfo.pointAt(j);
		    lastUParamA = adjustParam(uParameterDomainA, pInfo.uParamA, lastUParamA);
		    lastVParamA = adjustParam(vParameterDomainA, pInfo.vParamA, lastVParamA);
		    lastUParamB = adjustParam(uParameterDomainB, pInfo.uParamB, lastUParamB);
		    lastVParamB = adjustParam(vParameterDomainB, pInfo.vParamB, lastVParamB);
		    pInfo.uParamA = lastUParamA;
		    pInfo.vParamA = lastVParamA;
		    pInfo.uParamB = lastUParamB;
		    pInfo.vParamB = lastVParamB;
		}
	    }
	    
	    int nPnts, nPntsA, nPntsB;
	    boolean closed;
	    if (headPoint().isIdenticalWith(tailPoint())) {
		nPnts = nPoints() - 1;
		closed = true;
	    } else {
		nPnts = nPoints();
		closed = false;
	    }

	    boolean closedA = checkClosed2D(uParameterDomainA, vParameterDomainA,
					    firstUParamA, firstVParamA,
					    lastUParamA, lastVParamA, closed);
	    if (closedA)
		nPntsA = nPoints() - 1;
	    else
		nPntsA = nPoints();
	    boolean closedB = checkClosed2D(uParameterDomainB, vParameterDomainB,
					    firstUParamB, firstVParamB,
					    lastUParamB, lastVParamB, closed);
	    if (closedB)
		nPntsB = nPoints() - 1;
	    else
		nPntsB = nPoints();

	    Vector v3d = new Vector();
	    Vector v2dA = new Vector();
	    Vector v2dB = new Vector();
	    int n = 0;

	    for (i = k = 0; i < nSegments(); i++) {
		segInfo = segmentAt(i);
		pInfo = segInfo.pointAt(0);
		if (i == 0) {
		    v3d.addElement(pInfo.coordinates());
		    v2dA.addElement(new JgclCartesianPoint2D(pInfo.uParamA, pInfo.vParamA));
		    v2dB.addElement(new JgclCartesianPoint2D(pInfo.uParamB, pInfo.vParamB));
		    k++;
		}
		for (j = 1; j < segInfo.nPoints(); j++, k++) {
		    pInfo = segInfo.pointAt(j);
		    JgclPoint3D prevP = (JgclPoint3D)v3d.elementAt(k - 1 - n);
		    if (!REMOVE_NO_LENGTH_SEGMENT &&
			prevP.identical(pInfo.coordinates())) {
			n++;
			if (k == nPoints() - 1) {
			    /*
			     * case 1: open
			     *  .----------.----------.
			     *  nPoints-3  nPoints-2  nPoints-1
			     *  nPnts-3    nPnts-2    nPnts-1
			     *
			     * case 2: closed
			     *  .----------.----------.(== 0)
			     *  nPoints-3  nPoints-2  nPoints-1
			     *  nPnts-2    nPnts-1    nPnts
			     *
			     * In both case, the last point (== nPoints()-1)
			     * should not be removed.
			     * So remove a point just before the last point.
			     */
			    v3d.removeElementAt(k - n);
			    v2dA.removeElementAt(k - n);
			    v2dB.removeElementAt(k - n);
			}
			else {
			    continue;
			}
		    }

		    if (k != nPnts)
			v3d.addElement(pInfo.coordinates());
		    if (k != nPntsA)
			v2dA.addElement(new JgclCartesianPoint2D(pInfo.uParamA, pInfo.vParamA));
		    if (k != nPntsB)
			v2dB.addElement(new JgclCartesianPoint2D(pInfo.uParamB, pInfo.vParamB));
		}
	    }

	    JgclPoint3D[] pnts3d = new JgclPoint3D[nPnts-n]; v3d.copyInto(pnts3d);
	    JgclPoint2D[] pnts2dA = new JgclPoint2D[nPntsA-n]; v2dA.copyInto(pnts2dA);
	    JgclPoint2D[] pnts2dB = new JgclPoint2D[nPntsB-n]; v2dB.copyInto(pnts2dB);

	    JgclPolyline3D pol3d = new JgclPolyline3D(pnts3d, closed);
	    JgclPolyline2D pol2dA = new JgclPolyline2D(pnts2dA, closedA);
	    JgclPolyline2D pol2dB = new JgclPolyline2D(pnts2dB, closedB);
	    if (!doExchange)
		return new JgclIntersectionCurve3D(pol3d,
						   surfaceA, pol2dA,
						   surfaceB, pol2dB,
						   JgclPreferredSurfaceCurveRepresentation.CURVE_3D);
	    else
		return new JgclIntersectionCurve3D(pol3d,
						   surfaceB, pol2dB,
						   surfaceA, pol2dA,
						   JgclPreferredSurfaceCurveRepresentation.CURVE_3D);
	}

	private void refine() {
	    for (Enumeration e = segments.elements(); e.hasMoreElements();) {
		CurveSegmentInfo ci = (CurveSegmentInfo)e.nextElement();
		ci.refine();
	    }
	}
    }

    static final int SAMEP_MAX_RETRY = 4;

    /**
     * fĂZOg̏
     * (|CɌ)
     */
    class CurveSegmentInfo
    {
	/**
	 * _̐(!= z̐)
	 */
	int nPoints;

	/**
	 * ZOg(PointInfo̔z)
	 */
	PointInfo[] points;

	/**
	 * L
	 */
	boolean killed = false;

	/**
	 * ]Ă邩ǂ
	 */
	boolean reversed = false;

	/**
	 * IuWFNg\z
	 *
	 * @param	pol3	3̌
	 * @param	pol2A	Ȗ A ̃p[^ԏ2̌
	 * @param	pol2B	Ȗ B ̃p[^ԏ2̌
	 */
	CurveSegmentInfo(JgclPolyline3D pol3,
			 JgclPolyline2D pol2A,
			 JgclPolyline2D pol2B)
	{
	    nPoints = pol3.nSegments() + 1;
	    points = new PointInfo[nPoints];
	    for (int i = 0; i < nPoints; i++) {
		JgclPoint2D pnt = pol2A.pointAt(i);
		double paramAu = pnt.x();
		double paramAv = pnt.y();
		pnt = pol2B.pointAt(i);
		double paramBu = pnt.x();
		double paramBv = pnt.y();
		paramAu = uParameterDomainA.wrap(paramAu);
		paramAv = vParameterDomainA.wrap(paramAv);
		paramBu = uParameterDomainB.wrap(paramBu);
		paramBv = vParameterDomainB.wrap(paramBv);

		points[i] = new PointInfo(pol3.pointAt(i),
					  paramAu, paramAv,
					  paramBu, paramBv);
	    }
	}

	/**
	 * IuWFNg\z
	 *
	 * @param	pol3		3̌
	 * @param	pol2A		Ȗ A ̃p[^ԏ2̌
	 * @param	pol2B		Ȗ B ̃p[^ԏ2̌
	 * @param	headPTolAu	̊Jn_t߂ł̋Ȗ A  U ̃p[^̋e덷
	 * @param	headPTolAv	̊Jn_t߂ł̋Ȗ A  V ̃p[^̋e덷
	 * @param	headPTolBu	̊Jn_t߂ł̋Ȗ B  U ̃p[^̋e덷
	 * @param	headPTolBv	̊Jn_t߂ł̋Ȗ B  V ̃p[^̋e덷
	 * @param	tailPTolAu	̏I_t߂ł̋Ȗ A  U ̃p[^̋e덷
	 * @param	tailPTolAv	̏I_t߂ł̋Ȗ A  V ̃p[^̋e덷
	 * @param	tailPTolBu	̏I_t߂ł̋Ȗ B  U ̃p[^̋e덷
	 * @param	tailPTolBv	̏I_t߂ł̋Ȗ B  V ̃p[^̋e덷
	 */
	CurveSegmentInfo(JgclPolyline3D pol3,
			 JgclPolyline2D pol2A,
			 JgclPolyline2D pol2B,
			 double headPTolAu,
			 double headPTolAv,
			 double headPTolBu,
			 double headPTolBv,
			 double tailPTolAu,
			 double tailPTolAv,
			 double tailPTolBu,
			 double tailPTolBv)
	{
	    nPoints = pol3.nSegments() + 1;
	    points = new PointInfo[nPoints];
	    for (int i = 0; i < nPoints; i++) {
		JgclPoint2D pnt = pol2A.pointAt(i);
		double paramAu = pnt.x();
		double paramAv = pnt.y();
		pnt = pol2B.pointAt(i);
		double paramBu = pnt.x();
		double paramBv = pnt.y();
		paramAu = uParameterDomainA.wrap(paramAu);
		paramAv = vParameterDomainA.wrap(paramAv);
		paramBu = uParameterDomainB.wrap(paramBu);
		paramBv = vParameterDomainB.wrap(paramBv);

		if (i == 0)
		    points[i] = new PointInfo(pol3.pointAt(i),
					      paramAu, paramAv,
					      paramBu, paramBv,
					      headPTolAu, headPTolAv,
					      headPTolBu, headPTolBv);
		else if (i == nPoints - 1)
		    points[i] = new PointInfo(pol3.pointAt(i),
					      paramAu, paramAv,
					      paramBu, paramBv,
					      tailPTolAu, tailPTolAv,
					      tailPTolBu, tailPTolBv);
		else
		    points[i] = new PointInfo(pol3.pointAt(i),
					      paramAu, paramAv,
					      paramBu, paramBv);
	    }
	}

	private int nPoints() {
	    return nPoints;
	}

	private void nPoints(int newN) {
	    nPoints = newN;
	}

	private PointInfo pointAt(int index) {
	    if (reversed)
		index = nPoints - index - 1;

	    return points[index];
	}

	private void pointAt(int index, PointInfo newPi) {
	    points[index] = newPi;
	}

	private boolean isValidIndex(int index) {
	    if (index < 0 || index >= nPoints())
		return false;

	    return true;
	}

	private boolean isKilled() {
	    return killed;
	}

	private void setKilled() {
	    killed = true;
	}

	private void reverse() {
	    if (reversed)
		reversed = false;
	    else
		reversed = true;
	}

	/**
	 * Jn_
	 */
	private PointInfo headPoint() {
	    return pointAt(0);
	}

	/**
	 * I_
	 */
	private PointInfo tailPoint() {
	    return pointAt(nPoints()-1);
	}

	/**
	 * LȒĂ邩ǂׂ
	 *
	 * @retrun	LȒĂȂtrue
	 */
	private void isValidLengthPolyline() {
	    if (isKilled())
		return;

	    if (nPoints() > 2)
		return;

	    if (!headPoint().isIdenticalWith(tailPoint()))
		return;

	    setKilled();
	}

	private boolean isIdenticalWith(int this_i, CurveSegmentInfo mate, int mate_i) {
	    if (!isValidIndex(this_i) || !mate.isValidIndex(mate_i))
		return false;

	    return pointAt(this_i).isIdenticalWith(mate.pointAt(mate_i));
	}

	/**
	 * ZOgmdĂ邩ǂׂ
	 * dĂ镔ɂāȀd폜
	 * SɈvĂꍇ́A폜
	 *
	 * @param mate	̌ZOg
	 */
	private void isSamePolyline(CurveSegmentInfo mate) {
	    if (this.isKilled() || mate.isKilled())
		return;

	    /*
	     * deside that which segment is longer
	     */
	    int longer;
	    CurveSegmentInfo l_crv, s_crv;
	    if (this.nPoints() >= mate.nPoints()) {
		l_crv = this;
		s_crv = mate;
	    } else {
		l_crv = mate;
		s_crv = this;
	    }

	    /*
	     * find first coincidence
	     */
	    int so_s;
	    int l_i;
	    int s_i = -1;
	    for (l_i = 0; l_i < l_crv.nPoints(); l_i++) {
		if (l_crv.pointAt(l_i).isIdenticalWith(s_crv.headPoint())) {
		    /* start point of short segment is coincide with long segment */
		    s_i = 0;
		    break;
		} else if (l_crv.pointAt(l_i).isIdenticalWith(s_crv.tailPoint())) {
		    /* last point of short segment is coincide with long segment */
		    s_i = s_crv.nPoints() - 1;
		    break;
		}
	    }

	    if ((so_s = s_i) == -1)
		return;

	    /*
	     * find next coincidence
	     */
	    int l_inc, s_inc, rty;

	    l_inc = s_inc = 0;
	    for (rty = 1; rty < SAMEP_MAX_RETRY; rty++) {
		if (l_crv.isIdenticalWith(l_i + 1,   s_crv, s_i + rty) ||
		    l_crv.isIdenticalWith(l_i + rty, s_crv, s_i + 1)) {		// FF
		    l_inc = 1;
		    s_inc = 1;
		    break;
		} else if (l_crv.isIdenticalWith(l_i + 1,   s_crv, s_i - rty) ||
			   l_crv.isIdenticalWith(l_i + rty, s_crv, s_i - 1)) {	// FB
		    l_inc = 1;
		    s_inc = (- 1);
		    break;
		} else if (l_crv.isIdenticalWith(l_i - 1,   s_crv, s_i + rty) ||
			   l_crv.isIdenticalWith(l_i - rty, s_crv, s_i + 1)) {	// BF
		    l_inc = (- 1);
		    s_inc = 1;
		    break;
		} else if (l_crv.isIdenticalWith(l_i - 1,   s_crv, s_i - rty) ||
			   l_crv.isIdenticalWith(l_i - rty, s_crv, s_i - 1)) { 	// BB
		    l_inc = (- 1);
		    s_inc = (- 1);
		    break;
		}
	    }

	    if (rty == SAMEP_MAX_RETRY)		// just one coincidence
		return;

	    /*
	     * find last coincidence
	     */
	    int so_e = -1;
	    while (true) {
		l_i += l_inc;
		s_i += s_inc;

		if (!l_crv.isValidIndex(l_i) || !s_crv.isValidIndex(s_i))
		    break;

		if (!l_crv.isIdenticalWith(l_i, s_crv, s_i)) {
		    for (rty = 1; rty < SAMEP_MAX_RETRY; rty++)
			if (l_crv.isIdenticalWith(l_i + rty * l_inc, s_crv, s_i)) {
			    l_i += rty * l_inc;
			    break;
			}
		    if (rty == SAMEP_MAX_RETRY) {
			for (rty = 1; rty < SAMEP_MAX_RETRY; rty++)
			    if (l_crv.isIdenticalWith(l_i, s_crv, s_i + rty * s_inc)) {
				s_i += rty * s_inc;
				break;
			    }
			if (rty == SAMEP_MAX_RETRY)
			    break;
		    }
		}

		so_e = s_i;
	    }
	    if (so_e == -1)
		throw new JgclFatal();

	    /*
	     * remove overlapped section from shorter segment
	     *
	     * !!! IMPORTANT !!!
	     * currently we believe and pray that obtained overlapped section
	     * contains an end point of short segment.
	     */
	    if (so_s > so_e) {
		int tmp  = so_s;
		so_s = so_e;
		so_e = tmp;
	    }

	    if ((so_e - so_s + 1) == s_crv.nPoints()) {
		/*
		 * whole of short segment is in long segment
		 */
		s_crv.setKilled();
		return;
	    }

	    if (so_s == 0) {
		/*
		 * front half of short segment is in long segment
		 */
		int s_uip = s_crv.nPoints();
		int s_j;
		for (s_i = 0, s_j = so_e; s_j < s_uip; s_i++, s_j++) {
		    s_crv.pointAt(s_i, s_crv.pointAt(s_j));
		}
		s_crv.nPoints(s_i);

	    } else if (so_e == (s_crv.nPoints() - 1)) {
		/*
		 * rear half of short segment is in long segment
		 */
		s_crv.nPoints(so_s + 1);
	    }

	    if (s_crv.nPoints() <= 1) {
		/*
		 * if the remainder is just one point, that segment is useless.
		 * so return as (whole of short segment is in longer segment).
		 */
		s_crv.setKilled();
		return;
	    }

	    return;
	}

	private void refine() {
	    for (int i = 0; i < nPoints; i++) {
		PointInfo a_point, point, b_point;

		point = points[i];

		if (i == 0)
		    a_point = points[0];
		else
		    a_point = points[i-1];

		if (i == nPoints - 1)
		    b_point = points[nPoints - 1];
		else
		    b_point = points[i+1];

		refinePointInfo(point, b_point, a_point, true);
	    }
	}
    }

    /*
     * ȌZOg폜
    private void removeKilledCurves() {
	Vector newList = new Vector();
	for (Enumeration el = listOfCurveSegments.elements(); el.hasMoreElements();) {
	    CurveSegmentInfo ci = (CurveSegmentInfo)el.nextElement();
	    if (!ci.isKilled())
		newList.addElement(ci);
	}
	listOfCurveSegments = newList;
    }
     */

    /**
     * ZOgǉ
     *
     * @param	theCurve	
     */
    void addCurve(CurveSegmentInfo theCurve)
    {
	listOfCurveSegments.addElement(theCurve);
    }

    /**
     * ZOgǉ
     *
     * @param	pol3	3̌
     * @param	pol2A	Ȗ A ̃p[^ԏ2̌
     * @param	pol2B	Ȗ B ̃p[^ԏ2̌
     */
    void addAsIntersectionCurve(JgclPolyline3D pol3,
				JgclPolyline2D pol2A,
				JgclPolyline2D pol2B)
    {
	addCurve(new CurveSegmentInfo(pol3, pol2A, pol2B));
    }

    /**
     * ZOgƂĒǉ
     *
     * @param	pol3		3̌
     * @param	pol2A		Ȗ A ̃p[^ԏ2̌
     * @param	pol2B		Ȗ B ̃p[^ԏ2̌
     * @param	headPTolAu	̊Jn_t߂ł̋Ȗ A  U ̃p[^̋e덷
     * @param	headPTolAv	̊Jn_t߂ł̋Ȗ A  V ̃p[^̋e덷
     * @param	headPTolBu	̊Jn_t߂ł̋Ȗ B  U ̃p[^̋e덷
     * @param	headPTolBv	̊Jn_t߂ł̋Ȗ B  V ̃p[^̋e덷
     * @param	tailPTolAu	̏I_t߂ł̋Ȗ A  U ̃p[^̋e덷
     * @param	tailPTolAv	̏I_t߂ł̋Ȗ A  V ̃p[^̋e덷
     * @param	tailPTolBu	̏I_t߂ł̋Ȗ B  U ̃p[^̋e덷
     * @param	tailPTolBv	̏I_t߂ł̋Ȗ B  V ̃p[^̋e덷
     */
    void addAsIntersectionCurve(JgclPolyline3D pol3,
				JgclPolyline2D pol2A,
				JgclPolyline2D pol2B,
				double headPTolAu,
				double headPTolAv,
				double headPTolBu,
				double headPTolBv,
				double tailPTolAu,
				double tailPTolAv,
				double tailPTolBu,
				double tailPTolBv)
    {
	addCurve(new CurveSegmentInfo(pol3, pol2A, pol2B,
				      headPTolAu, headPTolAv, headPTolBu, headPTolBv,
				      tailPTolAu, tailPTolAv, tailPTolBu, tailPTolBv));
    }

    /**
     * fĂZOgȂ
     */
    void connectIntersectionCurves()
    {
	if (REMOVE_NO_LENGTH_SEGMENT) {
	    /*
	     * remove no-length solutions
	     */
	    for (Enumeration el = listOfCurveSegments.elements(); el.hasMoreElements();) {
		CurveSegmentInfo ci = (CurveSegmentInfo)el.nextElement();
		ci.isValidLengthPolyline();
	    }
	}

	/*
	 * remove overlapped solutions
	 */
	//removeKilledCurves();
	int nCurves = listOfCurveSegments.size();
	CurveSegmentInfo ci1, ci2;
	int i, j;
	for (i = 0; i < nCurves; i++) {
	    ci1 = (CurveSegmentInfo)listOfCurveSegments.elementAt(i);

	    for (j = i + 1; j < nCurves; j++) {
		ci2 = (CurveSegmentInfo)listOfCurveSegments.elementAt(j);
		ci1.isSamePolyline(ci2);
	    }
	}

	/*
	 * sort by the number of points
	 */
	//removeKilledCurves();
	nCurves = listOfCurveSegments.size();
	for (i = 0; i < nCurves; i++) {
	    ci1 = (CurveSegmentInfo)listOfCurveSegments.elementAt(i);
	    if (ci1.isKilled())
		continue;

	    for (j = i + 1; j < nCurves; j++) {
		ci2 = (CurveSegmentInfo)listOfCurveSegments.elementAt(j);
		if (ci2.isKilled())
		    continue;

		if (ci2.nPoints() < ci1.nPoints()) {
		    listOfCurveSegments.setElementAt(ci2, i);
		    listOfCurveSegments.setElementAt(ci1, j);
		    ci1 = ci2;
		}
	    }
	}

	/*
	 * connect
	 */
	//int nSolution = 0;
	CurveInfo oneCurve;
	//Vector listOfIncompleteCurves = new Vector();
	boolean is_closed;
	boolean found;
	for (i = 0; i < nCurves; i++) {
	    ci1 = (CurveSegmentInfo)listOfCurveSegments.elementAt(i);
	    if (ci1.isKilled())
		continue;

	    oneCurve = new CurveInfo(ci1);

	    do {
		found = false;
		for (j = i + 1; !(is_closed = oneCurve.isClosed()) && j < nCurves; j++) {
		    ci2 = (CurveSegmentInfo)listOfCurveSegments.elementAt(j);
		    if (ci2.isKilled())
			continue;

		    if (oneCurve.mergeIfConnectWith(ci2)) {
			found = true;
			break;
		    }
		}
	    } while (found);

	    /*
	     * is oneCurve complete ?
	     */
	    if (is_closed || oneCurve.isComplete()) {
		listOfCurves.addElement(oneCurve);
		//nSolution++;
	    } else {
		//listOfIncompleteCurves.addElement(ci1);
	    }
	}
    }

    void refine() {
	for (Enumeration e = listOfCurves.elements(); e.hasMoreElements();) {
	    CurveInfo ints = (CurveInfo)e.nextElement();
	    ints.refine();
	}
    }

    /**
     * _ƌ̃Xg JgclSurfaceSurfaceInterference3D ̔zƂĕԂ
     */
    JgclSurfaceSurfaceInterference3D[] toJgclSurfaceSurfaceInterference3DArray(boolean doExchange)
    {
	int totalSize = listOfPoints.size() + listOfCurves.size();
	int i;

	JgclSurfaceSurfaceInterference3D[] result = new JgclSurfaceSurfaceInterference3D[totalSize];
	i = 0;

	for (Enumeration e = listOfPoints.elements(); e.hasMoreElements();)
	{
	    PointInfo ints = (PointInfo)e.nextElement();
	    if (!doExchange)
		result[i++] = (ints.coord == null)
		    ? new JgclIntersectionPoint3D(surfaceA, ints.uParamA, ints.vParamA,
						  surfaceB, ints.uParamB, ints.vParamB,
						  JgclGeometry.doCheckDebug)
		    : new JgclIntersectionPoint3D(ints.coord,
						  surfaceA, ints.uParamA, ints.vParamA,
						  surfaceB, ints.uParamB, ints.vParamB,
						  JgclGeometry.doCheckDebug);
	    else
		result[i++] = (ints.coord == null)
		    ? new JgclIntersectionPoint3D(surfaceB, ints.uParamB, ints.vParamB,
						  surfaceA, ints.uParamA, ints.vParamA,
						  JgclGeometry.doCheckDebug)
		    : new JgclIntersectionPoint3D(ints.coord,
						  surfaceB, ints.uParamB, ints.vParamB,
						  surfaceA, ints.uParamA, ints.vParamA,
						  JgclGeometry.doCheckDebug);
	}

	for (Enumeration e = listOfCurves.elements(); e.hasMoreElements();)
	{
	    CurveInfo ints = (CurveInfo)e.nextElement();
	    result[i++] = ints.getIntersection(doExchange);
	}

	return result;
    }
}

// end of file
