/*
 * R : ʂ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclSurfaceOfLinearExtrusion3D.java,v 1.44 2000/08/11 06:19:03 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Vector;
import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : ʂ\NXB
 * <p>
 * ʂƂ́A
 * RȐɂ܂| (XC[v) OՂȖʂƂ݂Ȃ̂łB
 * </p>
 * <p>
 * ̃NX̃CX^X́A
 * XC[vׂRȐ sweptCurve
 * 
 * sweptCurve XC[vxNg extrusionAxis
 * ێB
 * AsweptCurve  {@link JgclSweptSurface3D X[p[NX} ŕێB
 * </p>
 * <p>
 * ʂ U ̃p[^`́AsweptCurve ̃p[^`ɈvB
 * V ̃p[^`͖ŔIłB
 * </p>
 * <p>
 * (u, v) p[^Ƃ钌 P(u, v) ̃pgbN\́Aȉ̒ʂB
 * <pre>
 *	P(u, v) = sweptCurve(u) + v * extrusionAxis
 * </pre>
 *
 * @version $Revision: 1.44 $, $Date: 2000/08/11 06:19:03 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclSurfaceOfLinearExtrusion3D extends JgclSweptSurface3D {
    /**
     * XC[vB
     * @serial
     */
    private JgclVector3D extrusionAxis;

    /**
     * XC[vȐƃXC[v^ăIuWFNg\zB
     * <p>
     * sweptCurve 邢 extrusionAxis  null ̏ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param sweptCurve	XC[vȐ
     * @param extrusionAxis	XC[v
     * @see	JgclInvalidArgumentValue
     */
    public JgclSurfaceOfLinearExtrusion3D(JgclParametricCurve3D sweptCurve,
					  JgclVector3D extrusionAxis)
    {
	super(sweptCurve);
	setExtrusionAxis(extrusionAxis);
    }

    /**
     * XC[vtB[hɐݒ肷B
     * <p>
     * extrusionAxis  null ̏ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param extrusionAxis	XC[v
     * @see	JgclInvalidArgumentValue
     */
    private void setExtrusionAxis(JgclVector3D extrusionAxis)
    {
	if (extrusionAxis == null) {
	    throw new JgclInvalidArgumentValue();
	}
	this.extrusionAxis = extrusionAxis;
    }

    /**
     * ̋Ȗʂ́AXC[vԂB
     * 
     * @return	XC[v
     */
    public JgclVector3D extrusionAxis() {
	return extrusionAxis;
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̍WlԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param	uParam	U ̃p[^l
     * @param	vParam	V ̃p[^l
     * @return		Wl
     * @see	JgclParameterOutOfRange
     */
    public JgclPoint3D coordinates(double uParam, double vParam)
    {
	return sweptCurve().coordinates(uParam).add(extrusionAxis.multiply(vParam));
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̐ڃxNgԂB
     * <p>
     * ł̐ڃxNgƂ́Ap[^ U/V ̊eXɂĂ̈ꎟΓ֐łB
     * </p>
     * <p>
     * ʂƂĕԂz̗vf 2 łB
     * z̍ŏ̗vfɂ U p[^ɂĂ̐ڃxNgA
     * Ԗڂ̗vfɂ V p[^ɂĂ̐ڃxNg܂ށB
     * </p>
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param	uParam	U ̃p[^l
     * @param	vParam	V ̃p[^l
     * @return		ڃxNg
     * @see	JgclParameterOutOfRange
     */
    public JgclVector3D[] tangentVector(double uParam, double vParam)
    {
	JgclVector3D[] tng = new JgclVector3D[2];

	tng[0] = sweptCurve().tangentVector(uParam);
	tng[1] = extrusionAxis;
	return tng;
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̕Γ֐ԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param uParam	U ̃p[^l
     * @param vParam	V ̃p[^l
     * @return		Γ֐
     * @see	JgclParameterOutOfRange
     */
    public JgclSurfaceDerivative3D evaluation(double uParam, double vParam)
    {
	JgclCurveDerivative3D crv_drv;
	JgclPoint3D d0;
	JgclVector3D du, dv, duu, duv, dvv;

	crv_drv = sweptCurve().evaluation(uParam);
	d0 = crv_drv.d0D().add(extrusionAxis.multiply(vParam));;
	du = crv_drv.d1D();
	dv = extrusionAxis;
	duu = crv_drv.d2D();
	dvv = duv = JgclVector3D.zeroVector;
	return new JgclSurfaceDerivative3D(d0, du, dv, duu, duv, dvv);
    }

    /**
     * ^ꂽ_炱̋Ȗʂւ̓e_߂B
     * <p>
     * e_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param point	e̓_
     * @return		e_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    public JgclPointOnSurface3D[] projectFrom(JgclPoint3D point)
	throws JgclIndefiniteSolution
    {
	// make plane include the sweptCurve.
	JgclLine3D line = new JgclLine3D(JgclPoint3D.origin, extrusionAxis);
	JgclPoint3D point_on_curve = sweptCurve().getPointNotOnLine(line);
	JgclVector3D normal = extrusionAxis;
	JgclPlane3D plane = new JgclPlane3D(point_on_curve, normal);

	// make projection from point to above plane.
	JgclPointOnSurface3D lpoint = plane.projectFrom(point)[0];

	// make a CartesianTransformationOperator of lpoint.
	JgclAxis2Placement3D position = new 
	    JgclAxis2Placement3D(lpoint, normal,
				 normal.verticalVector().unitized());
	JgclCartesianTransformationOperator3D cto = new
	    JgclCartesianTransformationOperator3D(position, 1.0);

	// make projection on above plane.
	JgclPointOnCurve3D[] lproj = sweptCurve().projectFrom(lpoint);
	// make projection to SweptSurface.
	JgclPointOnSurface3D[] proj = new JgclPointOnSurface3D[lproj.length];
	JgclVector3D vector = point.subtract(lpoint);
	double flag = 1.0;
	if (!normal.identicalDirection(vector)) {
	    flag = -1.0;
	}
	double vParam = flag * Math.sqrt(vector.norm() / normal.norm());
	for (int i = 0; i < lproj.length; i++) {
	    double uParam = lproj[i].parameter();
	    proj[i] = new JgclPointOnSurface3D(this, uParam , vParam, doCheckDebug);
	}

	return proj;
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂA^ꂽ덷ŕʋߎ
     * iq_QԂB
     * <p>
     * ʂƂĕԂiq_Q\_́A
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D 
     * 邱Ƃ҂łB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @param tol	̋e덷
     * @return		̋Ȗʂ̎w̋Ԃ𕽖ʋߎiq_Q
     * @see	JgclPointOnSurface3D
     * @see	JgclParameterOutOfRange
     */
    public JgclMesh3D
    toMesh(JgclParameterSection uPint,
	   JgclParameterSection vPint,
	   JgclToleranceForDistance tol)
    {
	return this.makeMesh(1, uPint, vPint, tol);
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂA
     * ^ꂽ덷ŕʋߎiq_QԂB
     * <p>
     * ʂƂĕԂiq_Q\_́A
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D 
     * 邱Ƃ҂łB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param meshType	toMesh Ȃ 1 AtoNonStructuredPoints Ȃ 2
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @param tol	̋e덷
     * @return	̋Ȗʂ̎w̋Ԃ𕽖ʋߎiq_Q
     * @see	JgclPointOnSurface3D
     * @see	JgclParameterOutOfRange
     */
    private JgclMesh3D
    makeMesh(int meshType,
	     JgclParameterSection uPint,
	     JgclParameterSection vPint,
	     JgclToleranceForDistance tol)
    {
	JgclPointOnSurface3D[][] mesh;
	JgclPolyline3D pol;
	int u_npnts;
	JgclPointOnCurve3D poc;
	double uParam;
	double vStart = vPint.start();
	double vEnd = vPint.end();
	double vMiddle = (vStart + vEnd) / 2.0;
	int i;

	/*
	 * XC[vȐ^ꂽe덷Ń|CߎB
	 */
	pol = sweptCurve().toPolyline(uPint, tol);
	u_npnts = pol.nPoints();

	if (meshType == 1) {
	    mesh = new JgclPointOnSurface3D[u_npnts][2];
	} else {
	    mesh = new JgclPointOnSurface3D[u_npnts][3];
	}

	/*
	 * U̓|C̋ߎ̃p[^AV̓p[^Ԃ̗[Ŋiq_\B
	 */
	for (i = 0; i < u_npnts; i++) {
	    poc = (JgclPointOnCurve3D)pol.pointAt(i);
	    uParam = poc.parameter();
	    try {
		mesh[i][0] = new JgclPointOnSurface3D(this, uParam, vStart, doCheckDebug);
		if (meshType == 1) {
		    mesh[i][1] = new JgclPointOnSurface3D(this, uParam, vEnd,    doCheckDebug);
		} else {
		    mesh[i][1] = new JgclPointOnSurface3D(this, uParam, vMiddle, doCheckDebug);
		    mesh[i][2] = new JgclPointOnSurface3D(this, uParam, vEnd,    doCheckDebug);
		}
	    } catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }
	}

	return new JgclMesh3D(mesh, false);
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂɍČ
     * L Bspline ȖʂԂB
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @return		̋Ȗʂ̎w̋ԂČL Bspline Ȗ
     * @see	JgclParameterOutOfRange
     */
    public JgclBsplineSurface3D
	toBsplineSurface(JgclParameterSection uPint,
			 JgclParameterSection vPint)
    {
	JgclBsplineCurve3D uBsplineCurve = this.sweptCurve().toBsplineCurve(uPint);

	int uNPoints = uBsplineCurve.nControlPoints();
	int vNPoints = 2;

	JgclPoint3D[][] controlPoints = new JgclPoint3D[uNPoints][vNPoints];
	double[][] weights = new double[uNPoints][vNPoints];

	JgclVector3D vLowerVec = this.extrusionAxis().multiply(vPint.start());
	JgclVector3D vUpperVec = this.extrusionAxis().multiply(vPint.end());

	for (int ui = 0; ui < uNPoints; ui++) {
	    JgclPoint3D uPoint = uBsplineCurve.controlPointAt(ui);
	    controlPoints[ui][0] = uPoint.add(vLowerVec);
	    controlPoints[ui][1] = uPoint.add(vUpperVec);
	    weights[ui][0] = weights[ui][1] = uBsplineCurve.weightAt(ui);
	}

	return new JgclBsplineSurface3D(uBsplineCurve.knotData(),
					JgclBsplineKnot.quasiUniformKnotsOfLinearOneSegment,
					controlPoints, weights);
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂItZbgȖʂ
     * ^ꂽ덷ŋߎ Bspline Ȗʂ߂B
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.FRONT/BACK)
     * @param tol     	̋e덷
     * @return		̋Ȗʂ̎w̋`Ԃ̃ItZbgȖʂߎ Bspline Ȗ
     * @see	JgclWhichSide
     */
    public JgclBsplineSurface3D
	offsetByBsplineSurface(JgclParameterSection uPint,
			       JgclParameterSection vPint,
			       double magni,
			       int side,
			       JgclToleranceForDistance tol)
    {
   	JgclOfst3D doObj = new JgclOfst3D(this,uPint,vPint,magni,side,tol);
	return doObj.offset(); 
    }
    
    /*
     * ̋Ȗʂ U p[^̈ʒuɂ铙p[^ȐԂB
     *
     * @param uParam	U ̃p[^l
     * @return	w U p[^lł̓p[^Ȑ
     */
    public JgclParametricCurve3D uIsoParametricCurve(double uParam) {
	return new JgclLine3D(sweptCurve().coordinates(uParam), extrusionAxis);
    }

    /*
     * ̋Ȗʂ V p[^̈ʒuɂ铙p[^ȐԂB
     *
     * @param vParam	V ̃p[^l
     * @return	w V p[^lł̓p[^Ȑ
     */
    public JgclParametricCurve3D vIsoParametricCurve(double vParam) {
	JgclVector3D moveVec = extrusionAxis.multiply(vParam);
	return sweptCurve().parallelTranslate(moveVec);
    }

    /**
     * ̋Ȗʂ U ̃p[^`ԂB
     * <p>
     * XC[vȐ̃p[^`ԂB
     * </p>
     * 
     * @return	U ̃p[^`
     */
    JgclParameterDomain getUParameterDomain() {
	return sweptCurve().parameterDomain();
    }

    /**
     * ̋Ȗʂ V ̃p[^`ԂB
     * <p>
     * ŔIȒ`ԂB
     * </p>
     * 
     * @return	V ̃p[^`
     */
    JgclParameterDomain getVParameterDomain() {
	return new JgclParameterDomain();
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricSurface3D#SURFACE_OF_LINEAR_EXTRUSION_3D JgclParametricSurface3D.SURFACE_OF_LINEAR_EXTRUSION_3D}
     */
    int type() {
	return SURFACE_OF_LINEAR_EXTRUSION_3D;
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂA
     * ^ꂽ덷ŕʋߎ_QԂB
     * <p>
     * ʂƂē_Q͈ʂɁAʑIɂ􉽓IɂAiqł͂ȂB
     * </p>
     * <p>
     * scalingFactor ́A͗pł͂ȂAo͗p̈łB
     * scalingFactor ɂ́Avf 2 ̔z^B
     * scalingFactor[0] ɂ U ̏kڔ{A
     * scalingFactor[1] ɂ V ̏kڔ{ԂB
     * ̒l͉炩̐Βlł͂ȂA
     * p[^̐iޑx T ɑ΂āA
     * U/V ɂĎԏŋȖʏ̓_iޑx Pu/Pv \ΒlłB
     * ܂Ap[^ T iނƁA
     * ԏł̋Ȗʏ̓_ U ł Pu (scalingFactor[0])A
     * V ł Pv (scalingFactor[1]) iނƂ\ĂB
     * T ̑傫͖Ȃ̂ŁA̒lQƂۂɂ́A
     * scalingFactor[0]  scalingFactor[1] ̔䂾pׂłB
     * ȂA̒l͂܂łڈłAȑx̂ł͂ȂB
     * </p>
     * <p>
     * ʂƂĕԂ Vector Ɋ܂܂evf
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D
     * ł邱Ƃ҂łB
     * </p>
     *
     * @param uParameterSection	U ̃p[^
     * @param vParameterSection	V ̃p[^
     * @param tolerance	̋e덷
     * @param scalingFactor	_QOp`ۂɗLpƎv U/V ̏kڔ{
     * @return	_Q܂ Vector
     * @see	JgclPointOnSurface3D
     */
    public Vector toNonStructuredPoints(JgclParameterSection uParameterSection,
					JgclParameterSection vParameterSection,
					double tolerance,
					double[] scalingFactor) {
	Vector result = new Vector();

	JgclMesh3D mesh = this.makeMesh(2, uParameterSection, vParameterSection,
					new JgclToleranceForDistance(tolerance));

	double uScale = 0.0;
	for (int u = 0; u < mesh.uNPoints(); u++) {
	    if (u > 0)
		uScale += mesh.pointAt(u, 0).distance(mesh.pointAt((u - 1), 0));
	    for (int v = 0; v < mesh.vNPoints(); v++)
		result.addElement(mesh.pointAt(u, v));
	}
	uScale /= uParameterSection.increase();

	scalingFactor[0] = uScale;
	scalingFactor[1] = 1.0;

	return result;
    }

    /**
     * ̋ȖʂA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricSurface3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclParametricCurve3D tSweptCurve =
	    this.sweptCurve().transformBy(reverseTransform,
					  transformationOperator,
					  transformedGeometries);
	JgclVector3D tExtrusionAxis =
	    this.extrusionAxis.transformBy(reverseTransform,
					  transformationOperator,
					  transformedGeometries);
	return new JgclSurfaceOfLinearExtrusion3D(tSweptCurve, tExtrusionAxis);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tsweptCurve");
        sweptCurve().output(writer, indent + 2);
        writer.println(indent_tab + "\textrusionAxis");
        extrusionAxis.output(writer, indent + 2);
        writer.println(indent_tab + "End");
    }
}

