/*
 * 2BezierȖʂ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclPureBezierSurfaceWithGivenControlPointsArray2D.java,v 1.5 2000/04/26 09:39:22 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Vector;
import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * 2BezierȖʂ\NX
 *
 * @version $Revision: 1.5 $, $Date: 2000/04/26 09:39:22 $
 * @author Information-technology Promotion Agency, Japan
 */
class JgclPureBezierSurfaceWithGivenControlPointsArray2D
extends JgclFreeformSurfaceWithGivenControlPointsArray2D {
    /**
     * _(Əd)3zƂė^đ/LBezierȖʂ\z
     *
     * @param cpArray		_Ad݂\z
     */
    JgclPureBezierSurfaceWithGivenControlPointsArray2D(double[][][] cpArray) {
	super(cpArray);
    }

    /**
     * U̎Ԃ
     * 
     * @return		U̎
     */
    public int uDegree() {
	return uNControlPoints() - 1;
    }

    /**
     * V̎Ԃ
     * 
     * @return		V̎
     */
    public int vDegree() {
	return vNControlPoints() - 1;
    }

    /**
     * ^ꂽp[^ł̍Wl߂
     * 
     * @param	uParam	Ũp[^l
     * @param	vParam	Ṽp[^l
     * @return		Wl
     * @see		JgclPoint2D
     */
    public JgclPoint2D coordinates(double uParam, double vParam)
    {
	double[][][] cntlPnts;
	int uUicp, vUicp;
	double[][] bzc;
	double[] d0D;
	boolean isPoly = isPolynomial();

	uParam = checkUParameter(uParam);
	vParam = checkVParameter(vParam);
	cntlPnts = toDoubleArray();
	uUicp = cntlPnts.length;
	vUicp = cntlPnts[0].length;
	bzc = new double[uUicp][];

	/*
	 * evaluate for V-direction
	 */
	for (int i = 0; i < uUicp; i++) {
	    bzc[i] = JgclPureBezierCurveEvaluation.coordinates(cntlPnts[i], vParam);
	}

	/*
	 * evaluate for U-direction
	 */
	d0D = JgclPureBezierCurveEvaluation.coordinates(bzc, uParam);
	if (!isPoly) {
	    convRational0Deriv(d0D);
	}
	return new JgclCartesianPoint2D(d0D);
    }

    /**
     * ^ꂽp[^ł̐ڃxNg߂
     * 
     * @param uParam	Ũp[^
     * @param vParam	Ṽp[^
     * @return		ڃxNg[0]:U̐ڃxNg [1]:V̐ڃxNg
     * @see		JgclVector2D
     */
    public JgclVector2D[] tangentVector(double uParam, double vParam)
    {
	double[][][] cntlPnts;
	int uUicp, vUicp;
	double[][] pp, dd, tt;
	double[][] ld1D = new double[2][];
	JgclVector2D[] d1D = new JgclVector2D[2];
	boolean isPoly = isPolynomial();

	uParam = checkUParameter(uParam);
	vParam = checkVParameter(vParam);
	cntlPnts = toDoubleArray();
	uUicp = cntlPnts.length;
	vUicp = cntlPnts[0].length;
	pp = new double[uUicp][3];
	tt = new double[uUicp][3];

	/*
	 * evaluate for V-direction
	 */
	for (int i = 0; i < uUicp; i++) {
	    JgclPureBezierCurveEvaluation.evaluation(cntlPnts[i], vParam,
						     pp[i], tt[i], null, null);
	}

	/*
	 * evaluate for U-direction
	 */
	ld1D[0] = new double[3];
	if (isPoly) {
	    JgclPureBezierCurveEvaluation.evaluation(pp, uParam, null, ld1D[0], null, null);
	    ld1D[1] = JgclPureBezierCurveEvaluation.coordinates(tt, uParam);
	} else {
	    double[] ld0D = new double[3];
	    JgclPureBezierCurveEvaluation.evaluation(pp, uParam, ld0D, ld1D[0], null, null);
	    ld1D[1] = JgclPureBezierCurveEvaluation.coordinates(tt, uParam);
	    convRational1Deriv(ld0D, ld1D[0], ld1D[1]);
	}
	for (int i = 0; i < 2; i++) {
	    d1D[i] = new JgclLiteralVector2D(ld1D[i]);
	}
	return d1D;
    }

    /**
     * ̒ԃf[^̗̈l
     * @return	̒ԃf[^̗̈
     */
    double [][][][] allocateIntermediateDoubleArrayForDividing() {
	boolean isPoly = isPolynomial();
	int uUicp = uNControlPoints();
	int vUicp = vNControlPoints();
	double [][][][] bzss_array = new double [2][][][];
	for (int i = 0; i < 2; i++)
	    bzss_array[i] = allocateDoubleArray(isPoly, uUicp, vUicp);
	return bzss_array;
    }

    /**
     * ^ꂽŨp[^2
     *
     * @param uParam	Ũp[^l
     * @return	ꂽBezierȖ
     * @exception JgclParameterOutOfRange p[^`͈̔͊Oł
     */
    public JgclPureBezierSurfaceWithGivenControlPointsArray2D[] uDivide(double uParam)
    {
	return uDivide(uParam, allocateIntermediateDoubleArrayForDividing());
    }

    /**
     * ^ꂽŨp[^2
     *
     * @param uParam	Ũp[^l
     * @param bzssArray	̒ԃf[^̗̈
     * @return	ꂽBezierȖ
     * @exception JgclParameterOutOfRange p[^`͈̔͊Oł
     */
    JgclPureBezierSurfaceWithGivenControlPointsArray2D[] uDivide(double uParam,
								 double [][][][] bzssArray)
    {
	double[][][] cntlPnts;
	double [][] bzc;
	double [][][] bzcsArray;
	JgclPureBezierSurfaceWithGivenControlPointsArray2D[] bzss;
	int uUicp = uNControlPoints();
	int vUicp = vNControlPoints();
	int i, j, k;

	uParam = checkUParameter(uParam);
	cntlPnts = toDoubleArray();
	bzc = new double[uUicp][];
	bzcsArray = new double[2][uUicp][];

	for (i = 0; i < vUicp; i++) {
	    for (j = 0; j < uUicp; j++) {
		bzc[j] = cntlPnts[j][i];
		bzcsArray[0][j] = bzssArray[0][j][i];
		bzcsArray[1][j] = bzssArray[1][j][i];
	    }
	    try {
		JgclPureBezierCurveEvaluation.divide(bzc, uParam, bzcsArray);
	    } catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }
	}

	bzss = new JgclPureBezierSurfaceWithGivenControlPointsArray2D[2];
	for (i = 0; i < 2; i++) {
	    try {
		bzss[i] = new JgclPureBezierSurfaceWithGivenControlPointsArray2D(bzssArray[i]);
	    } catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }
	}
	return bzss;
    }

    /**
     * ^ꂽṼp[^2
     *
     * @param vParam	Ṽp[^l
     * @return	ꂽBezierȖ
     * @exception JgclParameterOutOfRange p[^`͈̔͊Oł
     */
    public JgclPureBezierSurfaceWithGivenControlPointsArray2D[] vDivide(double vParam)
    {
	return vDivide(vParam, allocateIntermediateDoubleArrayForDividing());
    }

    /**
     * ^ꂽṼp[^2
     *
     * @param vParam	Ṽp[^l
     * @param bzssArray	̒ԃf[^̗̈
     * @return	ꂽBezierȖ
     * @exception JgclParameterOutOfRange p[^`͈̔͊Oł
     */
    JgclPureBezierSurfaceWithGivenControlPointsArray2D[] vDivide(double vParam,
								 double [][][][] bzssArray)
    {
	double[][][] cntlPnts;
	double [][][] bzcsArray;
	JgclPureBezierSurfaceWithGivenControlPointsArray2D[] bzss;
	int uUicp = uNControlPoints();
	int vUicp = vNControlPoints();
	int i, j;

	vParam = checkVParameter(vParam);
	cntlPnts = toDoubleArray();
	bzcsArray = new double[2][][];

	for (i = 0; i < uUicp; i++) {
	    bzcsArray[0] = bzssArray[0][i];
	    bzcsArray[1] = bzssArray[1][i];
	    try {
		JgclPureBezierCurveEvaluation.divide(cntlPnts[i], vParam, bzcsArray);
	    } catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }
	}

	bzss = new JgclPureBezierSurfaceWithGivenControlPointsArray2D[2];
	for (i = 0; i < 2; i++) {
	    try {
		bzss[i] = new JgclPureBezierSurfaceWithGivenControlPointsArray2D(bzssArray[i]);
	    } catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }
	}
	return bzss;
    }

    /**
     * Ũp[^hC𒲂ׂ
     * 
     * @return		Ũp[^hCԂ
     */
    JgclParameterDomain getUParameterDomain() {
	try {
	    return new JgclParameterDomain(false, 0.0, 1.0);
	}
	catch (JgclInvalidArgumentValue e) {
	    // should never be occurred
	    throw new JgclFatal();
	}
    }

    /**
     * Ṽp[^hC𒲂ׂ
     * 
     * @return		Ṽp[^hCԂ
     */
    JgclParameterDomain getVParameterDomain() {
	try {
	    return new JgclParameterDomain(false, 0.0, 1.0);
	}
	catch (JgclInvalidArgumentValue e) {
	    // should never be occurred
	    throw new JgclFatal();
	}
    }

    /*
     * Ũp[^Lǂׂ
     *
     * @return		ۂ߂ꂽp[^
     * @exception JgclParameterOutOfRange p[^`͈̔͊Oł
     */
    private double checkUParameter(double param)
    {
	checkUValidity(param);
	return uParameterDomain().force(param);
    }

    /*
     * Ṽp[^Lǂׂ
     *
     * @return		ۂ߂ꂽp[^
     * @exception JgclParameterOutOfRange p[^`͈̔͊Oł
     */
    private double checkVParameter(double param)
    {
	checkVValidity(param);
	return vParameterDomain().force(param);
    }

    /**
     * o̓Xg[Ɍ`o
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tuNControlPoints\t" + uNControlPoints());
        writer.println(indent_tab + "\tvNControlPoints\t" + vNControlPoints());

        writer.println(indent_tab + "\tcontrolPoints");
	double[][][] cntlPnts = toDoubleArray();
	for (int i = 0; i < cntlPnts.length; i++) {
            for (int j = 0; j < cntlPnts[i].length; j++) {
		writer.print(indent_tab + "\t");
		for (int k = 0; k < cntlPnts[i][j].length; k++) {
		    if (k == 0)
			writer.print("" + cntlPnts[i][j][k]);
		    else
			writer.print(", " + cntlPnts[i][j][k]);
		}
		writer.println("");
            }
        }

        writer.println(indent_tab + "End");
    }
}
