/*
 * Q : L () xWGȐїLxWGȐ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclPureBezierCurve2D.java,v 1.91 2000/08/11 06:19:00 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;
import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * Q : L () xWGȐїLxWGȐ\NX
 * <p>
 * ̃NXɓLȑ\tB[h͓ɂȂB
 * _ȂǂێtB[hɂẮA
 * {@link JgclFreeformCurveWithControlPoints2D X[p[NX̉} QƁB
 * </p>
 * <p>
 * xWGȐ̃p[^` [0, 1] ƂȂB
 * </p>
 * <p>
 * t p[^ƂxWGȐ P(t) ̃pgbN\́Aȉ̒ʂB
 * <pre>
 *	n = _̐ - 1
 *	bi = controlPoints[i]
 *	wi = weights[i]
 * </pre>
 * ƂāALxWGȐ
 * <pre>
 *	P(t) =	(bi * Bn,i(t)) ̑a		(i = 0, ..., n)
 * </pre>
 * LxWGȐ
 * <pre>
 *		(wi * bi * Bn,i(t)) ̑a
 *	P(t) =	-------------------------- 	(i = 0, ..., n)
 *		(wi * Bn,i(t)) ̑a
 * </pre>
 *  Bn,i(t) ̓o[X^C֐łB
 * </p>
 *
 * @version $Revision: 1.91 $, $Date: 2000/08/11 06:19:00 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclPureBezierCurve2D extends JgclFreeformCurveWithControlPoints2D {
    /**
     * _^đȐƂăIuWFNg\zB
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformCurveWithControlPoints2D#JgclFreeformCurveWithControlPoints2D(JgclPoint2D[])
     * super}(controlPoints)
     * ĂяoĂ邾łB
     * </p>
     *
     * @param controlPoints	_̔z
     */
    public JgclPureBezierCurve2D(JgclPoint2D[] controlPoints) {
	super(controlPoints);
    }

    /**
     * _Ədݗ^ėLȐƂăIuWFNg\zB
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformCurveWithControlPoints2D#JgclFreeformCurveWithControlPoints2D(JgclPoint2D[], double[])
     * super}(controlPoints, weights)
     * ĂяoĂ邾łB
     * </p>
     *
     * @param controlPoints	_̔z
     * @param weights		d݂̔z
     */
    public JgclPureBezierCurve2D(JgclPoint2D[] controlPoints,
				 double[] weights) {
	super(controlPoints, weights);
    }

    /**
     * _Ədݗ^
     * Ȑ (邢͗LȐ) ƂăIuWFNg\zB
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformCurveWithControlPoints2D#JgclFreeformCurveWithControlPoints2D(JgclPoint2D[], double[], boolean)
     * super}(controlPoints, weights, doCheck)
     * ĂяoĂ邾łB
     * </p>
     *
     * @param controlPoints	_̔zB
     * @param weights		d݂̔z
     * @param doCheck		̃`FbN邩ǂ
     */
    public JgclPureBezierCurve2D(JgclPoint2D[] controlPoints,
				 double[] weights,
				 boolean doCheck) {
	super(controlPoints, weights, doCheck);
    }

    /**
     * _ (Əd) 񎟌zŗ^
     * Ȑ (邢͗LȐ) ƂăIuWFNg\zB
     * <p>
     * ̃RXgN^́A
     * {@link JgclFreeformCurveWithControlPoints2D#JgclFreeformCurveWithControlPoints2D(double[][])
     * super}(cpArray)
     * ĂяoĂ邾łB
     * </p>
     *
     * @param cpArray	_ (яd) ̔z
     */
    JgclPureBezierCurve2D(double[][] cpArray) {
	super(cpArray);
    }

    /**
     * ̋Ȑ̎ԂB
     * 
     * @return	
     */
    public int degree() {
	return  nControlPoints() - 1;
    }

    /**
     * ̋Ȑ̑\ԂB
     * <p>
     * ʂƂēz R ̗vf́A
     * ̋ȐLł 2A
     * Lł 3 łB
     * </p>
     * <p>
     * LȐ̏ꍇA
     * R[0]  X A
     * R[1]  Y 
     * ̑\\B
     * </p>
     * <p>
     * LȐ̏ꍇA
     * R[0]  WX A
     * R[1]  WY 
     * R[2]  W 
     * ̑\\B
     * </p>
     *
     * @param isPoly	Lł邩ǂ
     * @return	̔z
     * @see	#polynomialCurve(boolean)
     */
    public JgclRealPolynomial[] polynomial(boolean isPoly) {
        int ijk, kji, mno, klm;
	int binml;
	int uicp = nControlPoints();
        double[][] dDcoef = toDoubleArray(isPoly);
	int npoly = dDcoef[0].length;
	double[] coef = new double[uicp];
	JgclRealPolynomial[] polynomial = new JgclRealPolynomial[npoly];

	for (klm = 0; klm < npoly; klm++) {
	    for (ijk = 0; ijk < uicp; ijk++)
		coef[ijk] = dDcoef[ijk][klm];

	    // forward differences
	    for (ijk = 0; ijk < uicp; ijk++)
		for (mno = uicp - 1; ijk < mno; mno--)
		    coef[mno] -= coef[mno - 1];

	    // nCr
	    binml = 1;
	    for (ijk = 1, kji = uicp - 2; ijk < kji; ijk++, kji--) {
		binml = (binml * (uicp - ijk)) / ijk;
		coef[ijk] *= binml;
		coef[kji] *= binml;
	    }

	    if (ijk == kji) {
		binml = (binml * (uicp - ijk)) / ijk;
		coef[ijk] *= binml;
	    }

	    polynomial[klm] = new JgclRealPolynomial(coef);
	}

        return polynomial;
    }

    /**
     * ̋ȐČ鑽ȐԂB
     *
     * @param isPoly	Lł邩ǂ
     * @return	Ȑ
     * @see	#polynomial(boolean)
     */
    public JgclPolynomialCurve2D polynomialCurve(boolean isPoly) {
	JgclRealPolynomial[] poly = polynomial(isPoly);
	if (isPoly) {
	    return new JgclPolynomialCurve2D(poly[0], poly[1]);
	}
	else {
	    return new JgclPolynomialCurve2D(poly[0], poly[1], poly[2]);
	}
    }

    /**
     * ^ꂽp[^ԂA̋Ȑ̒`ɑ΂ėLۂ𒲂ׂB
     * <p>
     * section ̑l͕ł\ȂB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ̋Ȑ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param  pint    `FbNp[^
     * @return         KvɉĂ̋Ȑ̒`Ɋۂ߂ꂽp[^
     * @see	JgclParametricCurve#checkValidity(JgclParameterSection)
     * @see	JgclParameterOutOfRange
     */
    JgclParameterSection checkBoundary(JgclParameterSection pint) {
	checkValidity(pint);
        double start = pint.start();
        if (start < 0.0) start = 0.0;
        else if (start > 1.0) start = 1.0;
        double end = pint.end();
        if (end < 0.0) end = 0.0;
        else if (end > 1.0) end = 1.0;

        return new JgclParameterSection(start, end - start);
    }

    /**
     * ^ꂽp[^Ԃɂ邱̋Ȑ̎ԏł̒ (̂) ԂB
     * <p>
     * pint ̑l͕ł܂ȂB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ̋Ȑ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param pint	Ȑ̒߂p[^
     * @return	w肳ꂽp[^ԂɂȐ̒
     * @see	JgclParameterOutOfRange
     */
    public double length(JgclParameterSection pint) {
        // check boundary
        pint = checkBoundary(pint);

        JgclRealFunctionWithOneVariable realFunction;
        if (!isPolynomial()) {
            realFunction
                = new JgclRealFunctionWithOneVariable() {
                        public double evaluate(double parameter) {
                            return tangentVector(parameter).length();
                        }
                    };
        }
        else {
            JgclRealPolynomial[] poly = polynomial(isPolynomial());
            final JgclRealPolynomial[] deriv =
                new JgclRealPolynomial[poly.length];

            for (int ijk = 0; ijk < 2; ijk++)
                deriv[ijk] = poly[ijk].derive();

            realFunction
                = new JgclRealFunctionWithOneVariable() {
                        public double evaluate(double parameter) {
                            final double[] tang = new double[2];
                            for (int ijk = 0; ijk < 2; ijk++)
                                tang[ijk] = deriv[ijk].evaluate(parameter);
                            
                            return Math.sqrt(tang[0] * tang[0] +
                                             tang[1] * tang[1]);
                        }
                    };
        }
        double dTol = getToleranceForDistance() / 2.0;

        return JgclMath.getDefiniteIntegral(realFunction, pint, dTol);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̍WlԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		Wl
     * @see	JgclParameterOutOfRange
     */
    public JgclPoint2D coordinates(double param)
    {
	double[][] cntlPnts;
	double[] d0D;
	boolean isPoly = isPolynomial();

	param = checkParameter(param);
	cntlPnts = toDoubleArray(isPoly);
	d0D = JgclPureBezierCurveEvaluation.coordinates(cntlPnts, param);
	if (!isPoly) {
	    convRational0Deriv(d0D);
	}
	return new JgclCartesianPoint2D(d0D[0], d0D[1]);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̐ڃxNgԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		ڃxNg
     * @see	JgclParameterOutOfRange
     */
    public JgclVector2D tangentVector(double param)
    {
	double[][] cntlPnts;
	double[] d1D = new double[3];
	boolean isPoly = isPolynomial();

	param = checkParameter(param);
	cntlPnts = toDoubleArray(isPoly);
	if (isPoly) {
	    JgclPureBezierCurveEvaluation.evaluation(cntlPnts, param, null, d1D, null, null);
	} else {
	    double[] d0D = new double[3];

	    JgclPureBezierCurveEvaluation.evaluation(cntlPnts, param, d0D, d1D, null, null);
	    convRational1Deriv(d0D, d1D);
	}
	return new JgclLiteralVector2D(d1D[0], d1D[1]);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̋ȗԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		ȗ
     * @see	JgclParameterOutOfRange
     */
    public JgclCurveCurvature2D curvature(double param)
    {
	int degree;
	JgclCurveDerivative2D deriv;
	boolean tang0;
	double tang_leng;
	double dDcrv;
	JgclVector2D dDnrm;
	JgclCurveCurvature2D crv;
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double tol_d = condition.getToleranceForDistance();

	degree = degree();
	deriv = evaluation(param);

	tang_leng = deriv.d1D().norm();
	if (tang_leng < (tol_d * tol_d)) {
	    tang0 = true;
	} else {
	    tang0 = false;
	}

	if ((degree < 2) || (tang0 == true)) {
	    dDcrv = 0.0;
	    dDnrm = JgclVector2D.zeroVector;
	} else {
	    double ewvec;

	    tang_leng = Math.sqrt(tang_leng);
	    dDcrv = tang_leng * tang_leng * tang_leng;

	    ewvec = deriv.d1D().zOfCrossProduct(deriv.d2D());
	    dDcrv = Math.abs(ewvec) / dDcrv;

	    if (ewvec < 0.0) {
		dDnrm = new JgclLiteralVector2D(deriv.d1D().y(),
						(- deriv.d1D().x()));
	    } else {
		dDnrm = new JgclLiteralVector2D((- deriv.d1D().y()),
						deriv.d1D().x());
	    }

	    dDnrm = dDnrm.unitized();
	}

	return new JgclCurveCurvature2D(dDcrv, dDnrm);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̓֐ԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		֐
     * @see	JgclParameterOutOfRange
     */
    public JgclCurveDerivative2D evaluation(double param)
    {
	double[][] cntlPnts;
	double[] ld0D = new double[3];
	double[] ld1D = new double[3];
	double[] ld2D = new double[3];
	JgclPoint2D d0D;
	JgclVector2D d1D;
	JgclVector2D d2D;
	boolean isPoly = isPolynomial();

	param = checkParameter(param);
	cntlPnts = toDoubleArray(isPoly);
	JgclPureBezierCurveEvaluation.evaluation(cntlPnts, param, ld0D, ld1D, ld2D, null);
	if (!isPoly) {
	    convRational2Deriv(ld0D, ld1D, ld2D);
	}
	d0D = new JgclCartesianPoint2D(ld0D[0], ld0D[1]);
	d1D = new JgclLiteralVector2D(ld1D[0], ld1D[1]);
	d2D = new JgclLiteralVector2D(ld2D[0], ld2D[1]);
	return new JgclCurveDerivative2D(d0D, d1D, d2D);
    }

    /**
     * ̋Ȑ́A^ꂽp[^ɑ΂ubT~ǑʂԂB
     * <p>
     * parameters ̗vf́A̋Ȑ̎ɈvĂKvB
     * </p>     
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param	parameters	p[^l̔z
     * @return	ubT~ǑʂłWl
     * @see	JgclParameterOutOfRange
     */
    public JgclPoint2D blossoming(double[] parameters)
    {
	double[] adjustedParameters = new double[this.nControlPoints() - 1];
	for (int i = 0; i < this.nControlPoints() - 1; i++)
	    adjustedParameters[i] = this.checkParameter(parameters[i]);
	boolean isPoly = this.isPolynomial();

	double[] d0D =
	    JgclPureBezierCurveEvaluation.blossoming(this.toDoubleArray(isPoly),
						     adjustedParameters);
	if (isPoly == true)
	    return new JgclCartesianPoint2D(d0D[0], d0D[1]);
	else
	    return new JgclHomogeneousPoint2D(d0D[0], d0D[1], d0D[2]);
    }

    /**
     * ̋Ȑ̓ٓ_ԂB
     * <p>
     * ٓ_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @return		ٓ_̔z
     * @exception	JgclIndefiniteSolution	ȐŜkނĂ
     */
    public JgclPointOnCurve2D[] singular() throws JgclIndefiniteSolution {
        int uicp = nControlPoints();
        int uicp_1 = uicp - 1;
        int ijk, klm;
        JgclParameterDomain pdmn;
        Vector paramVec = new Vector();

        for (ijk = 1; ijk < uicp; ijk++) {
            if (!startPoint().identical(controlPointAt(ijk))) {
                break;
            }
        }
        if (ijk == uicp) {
            throw new JgclIndefiniteSolution(this);
        }

        if (startPoint().identical(controlPointAt(1))) {
            paramVec.addElement(new Double(0.0));
        }
        if (endPoint().identical(controlPointAt(uicp_1 - 1))) {
            paramVec.addElement(new Double(1.0));
        }

        JgclRealPolynomial pointPoly[] = polynomial(isPolynomial());
		int polySize = pointPoly.length;
        JgclRealPolynomial tangPoly[] = new JgclRealPolynomial[polySize];
        JgclRealPolynomial dotePoly[] = new JgclRealPolynomial[2];

        for (klm = 0; klm < polySize; klm++) {
            tangPoly[klm] = pointPoly[klm].derive();
        }

        if (!isRational()) {
            for (klm = 0; klm < 2; klm++)
            dotePoly[klm] = tangPoly[klm].multiply(tangPoly[klm]);
        }
        else {
            for (klm = 0; klm < 2; klm++) {
                JgclRealPolynomial work0, work1, sub;
                work0 = pointPoly[2].multiply(tangPoly[klm]);
                work1 = tangPoly[2].multiply(pointPoly[klm]);
                sub = work0.subtract(work1);
                dotePoly[klm] = sub.multiply(sub);
            }
        }

        JgclComplexPolynomial dtPoly;

        try {
            dtPoly = dotePoly[0].add(dotePoly[1]).normalize().toComplexPolynomial();
        }
        catch(JgclInvalidArgumentValue e) {
            throw new JgclFatal();
        }

        JgclComplex[] root;

        try {
            root = dtPoly.getRootsByDKA();
        }
        catch (JgclComplexPolynomial.DKANotConverge e) {
            root = e.getValues();
        }
        catch (JgclComplexPolynomial.ImpossibleEquation e) {
            throw new JgclFatal();
        }
        catch (JgclComplexPolynomial.IndefiniteEquation e) {
            throw new JgclFatal();
        }

        pdmn = parameterDomain();
        for (ijk = 0; ijk < root.length; ijk++) {
            if (!pdmn.isValid(root[ijk].real())){
                continue;
            }
            if (root[ijk].real() < 0.0) 
                root[ijk] = new JgclComplex(0.0);
            if (root[ijk].real() > 1.0)
                root[ijk] = new JgclComplex(1.0);

            JgclPoint2D point;
            JgclVector2D tangent;

            try {
                point = coordinates(root[ijk].real());
                tangent = tangentVector(root[ijk].real());
            }
            catch (JgclParameterOutOfRange e) {
                throw new JgclFatal();
            }

            double dTol2 = getToleranceForDistance2();
            if (tangent.norm() > dTol2)
                continue;

            for (klm = 0; klm < paramVec.size(); klm++) {
                if (identicalParameter(root[ijk].real(),
                                       ((Double)paramVec.elementAt(klm)).doubleValue())) {
                    break;
                }
            }
            if (klm < paramVec.size())
                continue;

            paramVec.addElement(new Double(root[ijk].real()));
        }

        JgclPointOnCurve2D singularPoint[] =
            new JgclPointOnCurve2D[paramVec.size()];
        for (ijk = 0; ijk < paramVec.size(); ijk++) {
            singularPoint[ijk] = new JgclPointOnCurve2D
                (this,((Double)paramVec.elementAt(ijk)).doubleValue(), doCheckDebug);
        }
        return singularPoint;
    }

    /**
     * ̋Ȑ̕ϋȓ_ԂB
     * <p>
     * ϋȓ_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @return	ϋȓ_̔z
     * @exception	JgclIndefiniteSolution	sł (̋Ȑ͒ł)
     */
    public JgclPointOnCurve2D[] inflexion() throws JgclIndefiniteSolution {
        int uicp = nControlPoints();
        int uicp_1 = uicp - 1;
        JgclPoint2D[] cp = controlPoints();
        int ijk, klm, mno;

        if (uicp_1 < 2) {
            throw new JgclIndefiniteSolution(this);
        }

        Vector paramVec = new Vector();
        Vector crvVec = new Vector();
        JgclVector2D collinearDir;
        if ((collinearDir = JgclPoint2D.collinear(cp, 0, uicp_1)) != null) {
            throw new JgclIndefiniteSolution(this);
        }
        
        JgclCurveCurvature2D crv;
        if ((collinearDir = JgclPoint2D.collinear(cp, 0, 2)) != null) {
            crv = curvature(0.0);
            paramVec.addElement(new Double(0.0));
            crvVec.addElement(crv);
        }

        if ((collinearDir = JgclPoint2D.collinear(cp, uicp_1 - 2, uicp_1))
            != null) {
            crv = curvature(1.0);
            paramVec.addElement(new Double(1.0));
            crvVec.addElement(crv);
        }

	JgclPolynomialCurve2D polyCurve = polynomialCurve(isPolynomial());
	JgclRealPolynomial crossPoly = polyCurve.crossProductD1D2();

        JgclRealPolynomial normalizedPoly = crossPoly.normalize();
        JgclComplexPolynomial complexPoly =
	        normalizedPoly.toComplexPolynomial();
        
        JgclComplex[] root;

        try {
            root = complexPoly.getRootsByDKA();
        }
        catch (JgclComplexPolynomial.DKANotConverge e) {
            root = e.getValues();
        }
        catch (JgclComplexPolynomial.ImpossibleEquation e) {
            throw new JgclFatal();
        }
        catch (JgclComplexPolynomial.IndefiniteEquation e) {
            throw new JgclFatal();
        }

        JgclParameterDomain pdmn = parameterDomain();
        for (ijk = 0; ijk < root.length; ijk++) {
            if (!pdmn.isValid(root[ijk].real()))
                continue;

            if (root[ijk].real() < 0.0) 
                root[ijk] = new JgclComplex(0.0);
            if (root[ijk].real() > 1.0)
                root[ijk] = new JgclComplex(1.0);

            crv = curvature(root[ijk].real());
            double dTol = getToleranceForDistance();
            if (Math.abs(crv.curvature()) > dTol)
                continue;

            double intvl = 1.0 / uicp_1;
            double stake;
            for (klm = 0; klm < paramVec.size(); klm++) {
                if (Math.abs(root[ijk].real() -
                             ((Double)paramVec.elementAt(klm)).
                             doubleValue()) < intvl) {
                    for (mno = 1; mno < uicp_1; mno++) {
                        stake = mno * intvl;
                        if (((root[ijk].real() - stake) *
                             (((Double)paramVec.elementAt(klm)).
                              doubleValue() - stake)) < 0.0)
                            break;
                    }
                    if (mno == uicp_1) {
                        if (Math.abs(crv.curvature())
                             < Math.abs(((JgclCurveCurvature2D)crvVec.
                                         elementAt(klm)).curvature())) {
                            paramVec.addElement(new Double(root[ijk].real()));
                            crvVec.addElement(crv);
                        }
                        break;
                    }
                }
            }
            if (klm < paramVec.size())
                continue;

            paramVec.addElement(new Double(root[ijk].real()));
            crvVec.addElement(crv);
        }

        JgclPointOnCurve2D[] inflexion =
            new JgclPointOnCurve2D[paramVec.size()];
        for (ijk = 0; ijk < paramVec.size(); ijk++)
            inflexion[ijk] = new JgclPointOnCurve2D
                (this, ((Double)paramVec.elementAt(ijk)).doubleValue(), doCheckDebug);
        
        return inflexion;
    }

    /**
     * ^ꂽ_炱̋Ȑւ̓e_߂B
     * <p>
     * e_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * Ȑ̂_ P(t) ^ꂽ_֌xNg
     * P(t) ɂڃxNg P'(t) ̓ς\ D(t) 𐶐A
     * ӂƂ㐔 D(t) = 0 ĂB
     * </p>
     * 
     * @param point	e̓_
     * @return	e_̔z
     */
    public JgclPointOnCurve2D[] projectFrom(JgclPoint2D mate) {
	JgclRealPolynomial pointPoly[] = polynomial(isPolynomial());
	JgclRealPolynomial offsPoly[] = new JgclRealPolynomial[2];
	int coef_size = pointPoly.length;

	if (isRational()) {
	    offsPoly[0] = pointPoly[2].multiply(mate.x());
	    offsPoly[1] = pointPoly[2].multiply(mate.y());
	}
	else {
	    double coef[][] = {{ mate.x() }, { mate.y() }};
	    offsPoly[0] = new JgclRealPolynomial(coef[0]);
	    offsPoly[1] = new JgclRealPolynomial(coef[1]);
	}

	for (int i = 0; i < 2; i++)
	    pointPoly[i] = pointPoly[i].subtract(offsPoly[i]);

	JgclRealPolynomial tangPoly[] = new JgclRealPolynomial[coef_size];
	JgclRealPolynomial dotePoly[] = new JgclRealPolynomial[2];

	// polynomial of tangent vector
	for (int klm = 0; klm < coef_size; klm++)
	    tangPoly[klm] = pointPoly[klm].derive();

	if (!isRational()) {
	    for (int klm = 0; klm < 2; klm++)
		dotePoly[klm] = pointPoly[klm].multiply(tangPoly[klm]);
	} else {
	    JgclRealPolynomial work0, work1, work2, sub;
	    double[] work3;

	    for (int klm = 0; klm < 2; klm++) {
		work0 = pointPoly[2].multiply(tangPoly[klm]);
		work1 = tangPoly[2].multiply(pointPoly[klm]);
		// ((a * t^n) * (nb * t^(n-1))) - ((na * t^(n-1)) * (b * t^n)) == 0
		work2 = work0.subtract(work1);
		work3 = work2.coefficientsBetween(0, (work2.degree() - 1));
		sub = new JgclRealPolynomial(work3);

		dotePoly[klm] = pointPoly[klm].multiply(sub);
	    }
	}

	JgclComplexPolynomial dtPoly;

	try {
	    dtPoly = dotePoly[0].add(dotePoly[1]).toComplexPolynomial();
	}
	catch(JgclInvalidArgumentValue e) {
	    throw new JgclFatal();
	}

	JgclComplex[] root;

	try {
	    root = dtPoly.getRootsByDKA();
	}
	catch (JgclComplexPolynomial.DKANotConverge e) {
	    root = e.getValues();
	}
	catch (JgclComplexPolynomial.ImpossibleEquation e) {
	    throw new JgclFatal();
	}
	catch (JgclComplexPolynomial.IndefiniteEquation e) {
	    throw new JgclFatal();
	}

	JgclPointOnGeometryList projList = new JgclPointOnGeometryList();
	JgclParameterDomain domain = parameterDomain();
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double dTol = condition.getToleranceForDistance();

	for (int i = 0; i < root.length; i++) {
	    JgclPointOnCurve2D proj;

	    double par = root[i].real();

	    if (!domain.isValid(par))
		continue;

	    if (par > 1.0)
		par = 1.0;
	    if (par < 0.0)
		par = 0.0;

	    proj = checkProjection(par, mate, dTol*dTol);
	    if (proj != null)
		projList.addPoint(proj);
	}
	return projList.toJgclPointOnCurve2DArray();
    }

    /**
     * ̗LȐŜɍČL Bspline ȐԂB
     * 
     * @return	̋ȐŜČL Bspline Ȑ
     */
    public JgclBsplineCurve2D toBsplineCurve() {
	double[] www =
	    (this.isRational()) ? this.weights : this.makeUniformWeights();

	return new JgclBsplineCurve2D(JgclBsplineKnot.quasiUniformKnotsOfLinearOneSegment,
				      this.controlPoints, www);
    }

    /**
     * ̋Ȑ̎w̋ԂɍČL Bspline ȐԂB
     * 
     * @param pint	L Bspline ȐōČp[^
     * @return		̋Ȑ̎w̋ԂČL Bspline Ȑ
     */
    public JgclBsplineCurve2D toBsplineCurve(JgclParameterSection pint) {
	return this.truncate(pint).toBsplineCurve();
    }

    /**
     * ̋ȐƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		_̔z
     */
    public JgclIntersectionPoint2D[] intersect(JgclParametricCurve2D mate) {
	return mate.intersect(this, true);
    }

    /**
     * ̃xWGȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * xWGȐƒ̌_\㐔ɋAĉĂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclLine2D mate, boolean doExchange) {
	JgclAxis2Placement2D placement =
	    new JgclAxis2Placement2D(mate.pnt(), mate.dir());
	JgclCartesianTransformationOperator2D transform =
	    new JgclCartesianTransformationOperator2D(placement, 1.0);
	int uicp = nControlPoints();
	JgclPoint2D[] newCp = new JgclPoint2D[uicp];

	for (int i = 0; i < uicp; i++)
	    newCp[i] = transform.toLocal(controlPointAt(i));

	double[] weights = weights();
	if (isRational()) {
	    double max_weight = 0.0;
	    for (int i = 0; i < uicp; i++)
		if (Math.abs(weights[i]) > max_weight)
		    max_weight = weights[i];
	    
	    if (max_weight > 0.0)
		for (int i = 0; i < uicp; i++) {
		    weights[i] /= max_weight;
		}
	}
	// ̐_(newCp) Bezier Curve 
	JgclPureBezierCurve2D bzc = new JgclPureBezierCurve2D(newCp, weights, doCheckDebug);

	JgclRealPolynomial[]  realPoly = bzc.polynomial(isPolynomial());
	JgclComplexPolynomial compPoly = realPoly[1].toComplexPolynomial();
			
	JgclComplex[] roots;
	try {
	    roots = compPoly.getRootsByDKA();
	}
	catch (JgclComplexPolynomial.DKANotConverge e) {
	    roots = e.getValues();
	}
	catch (JgclComplexPolynomial.ImpossibleEquation e) {
	    throw new JgclFatal();
	}
	catch (JgclComplexPolynomial.IndefiniteEquation e) {
	    throw new JgclFatal();
	}

	int nRoots = roots.length;
	    
	// ̃`FbN
	Vector lineParam = new Vector();
	Vector bzcParam  = new Vector();
	Vector bzcPoints = new Vector();

	for (int j = 0; j < nRoots; j++) {
	    double realRoot = roots[j].real();
	    if (bzc.parameterValidity(realRoot) == JgclParameterValidity.OUTSIDE)
		continue;
	    
	    if (realRoot < 0.0) realRoot = 0.0;
	    if (realRoot > 1.0) realRoot = 1.0;
	    
	    JgclPoint2D workPoint = bzc.coordinates(realRoot);
	    double dTol = bzc.getToleranceForDistance();

	    int paramNum = bzcParam.size();
	    if (Math.abs(workPoint.y()) < dTol) {
		int k;
		for (k = 0; k < paramNum; k++) {
		    double paramA =
			((Double)bzcParam.elementAt(k)).doubleValue();
		    double paramB =
			((Double)lineParam.elementAt(k)).doubleValue();
		    if ((Math.abs(paramB - workPoint.x()) < dTol)
			&& (bzc.identicalParameter(realRoot, paramA)))
			break;
		}
		if (k >= paramNum) {
		    bzcParam.addElement(new Double(realRoot));
		    lineParam.addElement(new Double(workPoint.x()));
		    bzcPoints.addElement(transform.toEnclosed(workPoint));
		}
	    }
	}

	int num = bzcParam.size();
	JgclIntersectionPoint2D[] intersectPoint = new
	    JgclIntersectionPoint2D[num];
	double mateLength = mate.dir().length();
	for (int i = 0; i < num; i++) {
	    double work = ((Double)lineParam.elementAt(i)).doubleValue() / mateLength;;
	    JgclPointOnCurve2D pointOnLine = new JgclPointOnCurve2D(mate, work, doCheckDebug);

	    work = ((Double)bzcParam.elementAt(i)).doubleValue();
	    JgclPointOnCurve2D pointOnBzc = new	JgclPointOnCurve2D(this, work, doCheckDebug);
	    
	    JgclPoint2D coordinates = (JgclPoint2D)bzcPoints.elementAt(i);
	    
	    if (!doExchange)
		intersectPoint[i] = new JgclIntersectionPoint2D
		    (coordinates, pointOnBzc, pointOnLine, doCheckDebug);
	    else
		intersectPoint[i] = new JgclIntersectionPoint2D
		    (coordinates, pointOnLine, pointOnBzc, doCheckDebug);
	}

	return intersectPoint;
    }

    /**
     * ̃xWGȐƑ̋Ȑ (~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ~̃NX́u~ vs. xWGȐv̌_Z\bh
     * {@link JgclCircle2D#intersect(JgclPureBezierCurve2D, boolean)
     * JgclCircle2D.intersect(JgclPureBezierCurve2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclCircle2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̃xWGȐƑ̋Ȑ (ȉ~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȉ~̃NX́uȉ~ vs. xWGȐv̌_Z\bh
     * {@link JgclEllipse2D#intersect(JgclPureBezierCurve2D, boolean)
     * JgclEllipse2D.intersect(JgclPureBezierCurve2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (ȉ~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclEllipse2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̃xWGȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ̃NX́u vs. xWGȐv̌_Z\bh
     * {@link JgclParabola2D#intersect(JgclPureBezierCurve2D, boolean)
     * JgclParabola2D.intersect(JgclPureBezierCurve2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclParabola2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̃xWGȐƑ̋Ȑ (oȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * oȐ̃NX́uoȐ vs. xWGȐv̌_Z\bh
     * {@link JgclHyperbola2D#intersect(JgclPureBezierCurve2D, boolean)
     * JgclHyperbola2D.intersect(JgclPureBezierCurve2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (oȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclHyperbola2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̃xWGȐƑ̋Ȑ (|C) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * |C̃NX́u|C vs. xWGȐv̌_Z\bh
     * {@link JgclPolyline2D#intersect(JgclPureBezierCurve2D, boolean)
     * JgclPolyline2D.intersect(JgclPureBezierCurve2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (|C)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclPolyline2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̃xWGȐƑ̋Ȑ (xWGȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsBzcBzc2D#intersection(JgclPureBezierCurve2D, JgclPureBezierCurve2D, boolean)
     * JgclIntsBzcBzc2D.intersection}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (xWGȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclPureBezierCurve2D mate, boolean doExchange) {
	return JgclIntsBzcBzc2D.intersection(this, mate, doExchange);
    }

    /**
     * ̃xWGȐƑ̋Ȑ (aXvCȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsBzcBsc2D#intersection(JgclPureBezierCurve2D, JgclBsplineCurve2D, boolean)
     * JgclIntsBzcBsc2D.intersection}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (aXvCȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclBsplineCurve2D mate, boolean doExchange) {
	return JgclIntsBzcBsc2D.intersection(this, mate, doExchange);
    }

    /**
     * ̃xWGȐƑ̋Ȑ (gȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * gȐ̃NX́ugȐ vs. xWGȐv̌_Z\bh
     * {@link JgclTrimmedCurve2D#intersect(JgclPureBezierCurve2D, boolean)
     * JgclTrimmedCurve2D.intersect(JgclPureBezierCurve2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (gȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclTrimmedCurve2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̃xWGȐƑ̋Ȑ (ȐZOg) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȐZOg̃NX́uȐZOg vs. xWGȐv̌_Z\bh
     * {@link JgclCompositeCurveSegment2D#intersect(JgclPureBezierCurve2D, boolean)
     * JgclCompositeCurveSegment2D.intersect(JgclPureBezierCurve2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (ȐZOg)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclCompositeCurveSegment2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̃xWGȐƑ̋Ȑ (Ȑ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȐNX́uȐ vs. xWGȐv̌_Z\bh
     * {@link JgclCompositeCurve2D#intersect(JgclPureBezierCurve2D, boolean)
     * JgclCompositeCurve2D.intersect(JgclPureBezierCurve2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate      ̋Ȑ (Ȑ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclCompositeCurve2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LEȐ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		Ȑ̊̔z
     */
    public JgclCurveCurveInterference2D[] interfere(JgclBoundedCurve2D mate) {
	return mate.interfere(this, true);
    }

    /**
     * ̗LȐƑ̗LȐ () ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ̃NX́u vs. xWGȐv̊Z\bh
     * {@link JgclBoundedLine2D#interfere(JgclPureBezierCurve2D, boolean)
     * JgclBoundedLine2D.interfere(JgclPureBezierCurve2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̗LȐ ()
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference2D[] interfere(JgclBoundedLine2D mate,
					     boolean doExchange)
    {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (|C) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * |C̃NX́u|C vs. xWGȐv̊Z\bh
     * {@link JgclPolyline2D#interfere(JgclPureBezierCurve2D, boolean)
     * JgclPolyline2D.interfere(JgclPureBezierCurve2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̗LȐ (|C)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference2D[] interfere(JgclPolyline2D mate,
					     boolean doExchange)
    {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (xWGȐ) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsBzcBzc2D#interference(JgclPureBezierCurve2D, JgclPureBezierCurve2D, boolean)
     * JgclIntsBzcBzc2D.interference}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̗LȐ (xWGȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference2D[] interfere(JgclPureBezierCurve2D mate,
					     boolean doExchange)
    {
	return JgclIntsBzcBzc2D.interference(this, mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (aXvCȐ) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsBzcBsc2D#interference(JgclPureBezierCurve2D, JgclBsplineCurve2D, boolean)
     * JgclIntsBzcBsc2D.interference}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̗LȐ (aXvCȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference2D[] interfere(JgclBsplineCurve2D mate,
					     boolean doExchange)
    {
	return JgclIntsBzcBsc2D.interference(this, mate, doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (gȐ) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * gȐ̃NX́ugȐ vs. xWGȐv̊Z\bh
     * {@link JgclTrimmedCurve2D#interfere(JgclPureBezierCurve2D, boolean)
     * JgclTrimmedCurve2D.interfere(JgclPureBezierCurve2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̗LȐ (gȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference2D[] interfere(JgclTrimmedCurve2D mate,
					     boolean doExchange) {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (ȐZOg) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȐZOg̃NX́uȐZOg vs. xWGȐv̊Z\bh
     * {@link JgclCompositeCurveSegment2D#interfere(JgclPureBezierCurve2D, boolean)
     * JgclCompositeCurveSegment2D.interfere(JgclPureBezierCurve2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̗LȐ (ȐZOg)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference2D[] interfere(JgclCompositeCurveSegment2D mate,
					     boolean doExchange) {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (Ȑ) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȐNX́uȐ vs. xWGȐv̊Z\bh
     * {@link JgclCompositeCurve2D#interfere(JgclPureBezierCurve2D, boolean)
     * JgclCompositeCurve2D.interfere(JgclPureBezierCurve2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̗LȐ (Ȑ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference2D[] interfere(JgclCompositeCurve2D mate,
					     boolean doExchange) {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̋Ȑ̎w̋ԂItZbgȐA
     * ^ꂽ덷ŋߎ Bspline Ȑ߂B
     * 
     * @param pint	ItZbgp[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.LEFT/RIGHT)
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ̃ItZbgȐߎ Bspline Ȑ
     * @see	JgclWhichSide
     */
    public JgclBsplineCurve2D
	offsetByBsplineCurve(JgclParameterSection pint,
			     double magni,
                             int side,
			     JgclToleranceForDistance tol) {
	JgclOfst2D doObj = new JgclOfst2D(this,pint,magni,side,tol);
	return doObj.offset();
    }

    /**
     * ̋ȐƑ̋ȐƂ̋ʐڐ߂B
     * <p>
     * ʐڐ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * _ł͎ĂȂ߁A
     * JgclNotSupported	̗O𔭐B
     * </p>
     *
     * @param mate	̋Ȑ
     * @return		ʐڐ̔z
     * @exception	JgclNotSupported	܂̂ƂAȂ@\ł
     */
    public JgclCommonTangent2D[] commonTangent(JgclParametricCurve2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋ȐƂ̋ʖ@߂B
     * <p>
     * ʖ@݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * _ł͎ĂȂ߁A
     * JgclNotSupported	̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		ʖ@̔z
     * @exception	JgclNotSupported	܂̂ƂAȂ@\ł
     */
    public JgclCommonNormal2D[]	commonNormal(JgclParametricCurve2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̃xWGȐA^ꂽp[^lœɕB
     * <p>
     * param ̒lÃxWGȐ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * <p>
     * ʂƂēz̗vf 2 ŁA
     * ŏ̗vfɁun_番_܂ł\xWGȐvA
     * Ԗڂ̗vfɁu_I_܂ł\xWGȐv
     * B
     * </p>
     * 
     * @param	param	p[^l
     * @return		̃xWGȐ܂ޔz
     * @see	JgclParameterOutOfRange
     */
    public JgclPureBezierCurve2D[] divide(double param)
    {
	double[][] cntlPnts;
	double[][][] bzcs_array;
	JgclPureBezierCurve2D[] bzcs;
	boolean isPoly = isPolynomial();

	param = checkParameter(param);
	cntlPnts = toDoubleArray(isPoly);
	try {
	    bzcs_array = JgclPureBezierCurveEvaluation.divide(cntlPnts, param);
	} catch (JgclInvalidArgumentValue e) {
	    throw new JgclFatal();
	}
	bzcs = new JgclPureBezierCurve2D[2];
	for (int i = 0; i < 2; i++) {
	    try {
		bzcs[i] = new JgclPureBezierCurve2D(bzcs_array[i]);
	    } catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }
	}

	return bzcs;
    }

    /**
     * ̃xWGȐA^ꂽp[^ԂŐؒfB
     * <p>
     * section ̑l̏ꍇɂ́Ais]xWGȐԂB
     * </p>
     * <p>
     * section ̒lÃxWGȐ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param section	ؒfĎc\p[^
     * @return	ؒfĎc\xWGȐ
     * @see	JgclParameterOutOfRange
     */
    public JgclPureBezierCurve2D truncate(JgclParameterSection section)
    {
	double start_par, end_par;
	JgclPureBezierCurve2D t_bzc;

	start_par = checkParameter(section.lower());
	end_par = checkParameter(section.upper());

	t_bzc = divide(start_par)[1];
	end_par = (end_par - start_par) / (1.0 - start_par);

	t_bzc = t_bzc.divide(end_par)[0];

	if (section.increase() < 0.0)
	    t_bzc = t_bzc.reverse();

	return t_bzc;
    }

    /**
     * ̋Ȑ̎w̋ԂA^ꂽ덷Œߎ|CԂB
     * <p>
     * ʂƂĕԂ|C\_
     * ̋Ȑx[XƂ JgclPointOnCurve2D 
     * 邱Ƃ҂łB
     * </p>
     * <p>
     * section ̒lÃxWGȐ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param section	ߎp[^
     * @param tolerance	̋e덷
     * @return		̋Ȑ̎w̋Ԃ𒼐ߎ|C
     * @see	JgclParameterOutOfRange
     */
    public JgclPolyline2D toPolyline(JgclParameterSection section,
				     JgclToleranceForDistance tolerance)
    {
	JgclPureBezierCurve2D root_bzc;
	double sp, ep;
	IntervalInfo root_info;
	JgclBinaryTree pnt_tree;
	int no_pnts;
	JgclPoint2D[] pnts;
	FillInfo fill_info;
	double tol = tolerance.value();
	double tol_2 = tol * tol;
	JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
	double tol_p = condition.getToleranceForParameter();

	root_bzc = truncate(section.positiveIncrease());
	sp = checkParameter(section.lower());
	ep = checkParameter(section.upper());
	root_info = new IntervalInfo(root_bzc, sp, ep);
	
	pnt_tree = new JgclBinaryTree(root_info);

	no_pnts = divideInterval(2, pnt_tree.rootNode(), tol_2);

	pnts = new JgclPoint2D[no_pnts];
	if (true) {
	    fill_info = new FillInfo(this, pnts, 0, tol_p, ep);
	    pnt_tree.rootNode().preOrderTraverse(new fillArray(), fill_info);
	} else {
	    Enumeration enum = pnt_tree.rootNode().preOrderEnumeration();
	    JgclBinaryTree.Node node;
	    IntervalInfo bi;
	    int i = 0;

	    while (enum.hasMoreElements()) {
		node = (JgclBinaryTree.Node)enum.nextElement();
		if ((node.left() == null) && (node.right() == null)) {
		    bi = (IntervalInfo)node.data();

		    try {
			pnts[i++] = new JgclPointOnCurve2D
			    (bi.bzc().controlPointAt(0), this, bi.sp());
			if (i == (no_pnts - 1)) {
			    pnts[i] = new JgclPointOnCurve2D
				(bi.bzc().controlPointAt(bi.bzc().nControlPoints()-1),
				 this, bi.ep());
			}
		    } catch (JgclInvalidArgumentValue e) {
			throw new JgclFatal();
		    }
		}
	    }
	}

	if (no_pnts == 2 && pnts[0].identical(pnts[1]))
	    throw new JgclZeroLength();

	if (section.increase() > 0.0) {
	    return new JgclPolyline2D(pnts);
	} else {
	    return new JgclPolyline2D(pnts).reverse();
	}
    }

    /**
     * xWGȐ̂ԂNXB
     */
    private class IntervalInfo {
	/**
	 * ̋ԂɑΉ (וꂽ) xWGȐB
	 */
	private JgclPureBezierCurve2D bzc;

	/**
	 * ̋Ԃ̊Jn_ɑΉ錳Ȑ̃p[^lB
	 */
	private double sp;

	/**
	 * ̋Ԃ̏I_ɑΉ錳Ȑ̃p[^lB
	 */
	private double ep;

	/**
	 * etB[h̒l^ăIuWFNg\zB
	 *
	 * @param bzc	ԂɑΉ (וꂽ) xWGȐ
	 * @param sp	Ԃ̊Jn_ɑΉ錳Ȑ̃p[^l
	 * @param ep	Ԃ̏I_ɑΉ錳Ȑ̃p[^l
	 */
	private IntervalInfo(JgclPureBezierCurve2D bzc, double sp, double ep) {
	    super();
	    this.bzc = bzc;
	    this.sp = sp;
	    this.ep = ep;
	}

	/**
	 * ̋ԂɑΉ (וꂽ) xWGȐԂB
	 *
	 * @return	̋ԂɑΉ (וꂽ) xWGȐ
	 */
	private JgclPureBezierCurve2D bzc() {
	    return bzc;
	}

	/**
	 * ̋Ԃ̊Jn_ɑΉ錳Ȑ̃p[^lԂB
	 *
	 * @return	̋Ԃ̊Jn_ɑΉ錳Ȑ̃p[^l
	 */
	private double sp() {
	    return sp;
	}

	/**
	 * ̋Ԃ̏I_ɑΉ錳Ȑ̃p[^lԂB
	 *
	 * @return	̋Ԃ̏I_ɑΉ錳Ȑ̃p[^l
	 */
	private double ep() {
	    return ep;
	}
    }

    /**
     * ̋Ȑ̂Ԃ𒼐ߎ_߂邽߂̔zNXB
     */
    private class FillInfo {
	/**
	 * ̋ȐB
	 */
	private JgclParametricCurve2D basisCurve;

	/**
	 * ̋Ȑ̂Ԃ𒼐ߎ_B
	 */
	private JgclPoint2D[] pnts;

	/**
	 * ̑ pnts[index] ɑ΂čsȂׂł邱ƂlB
	 */
	private int index;

	/**
	 * p[^l̋e덷B
	 * <p>
	 * ܂̂ƂALɗpĂȂB
	 * </p>
	 */
	private double tol_p;

	/**
	 * ߎp[^Ԃ̏B
	 * <p>
	 * ܂̂ƂALɗpĂȂB
	 * </p>
	 */
	private double ep;

	/**
	 * etB[h̒l^ăIuWFNg\zB
	 *
	 * @param basisCurve	̋Ȑ
	 * @param pnts	̋Ȑ̂Ԃ𒼐ߎ_
	 * @param index	pnts[] ւ́uv̑̍ۂ̑ʒuCfbNX
	 * @param tol_p	p[^l̋e덷
	 * @param ep	ߎp[^Ԃ̏
	 */
	private FillInfo(JgclParametricCurve2D basisCurve,
			 JgclPoint2D[] pnts,
			 int index,
			 double tol_p,
			 double ep) {
	    super();
	    this.basisCurve = basisCurve;
	    this.pnts = pnts;
	    this.index = index;
	    this.tol_p = tol_p;
	    this.ep = ep;
	}
    }

    /**
     * ̃xWGȐ́A^ꂽԂ𒼐ߎ_𔭐B
     * <p>
     * _̏ crnt_node ȉ̓񕪖ؓɎ߂B
     * </p>
     *
     * @param no_pnts	Ȑ𒼐ߎ_̓_̐
     * @param crnt_node	Ԃێ񕪖؂̃m[h
     * @param tol_2	ߎ̐xƂė^ꂽűe덷v
     * @return	Ȑ𒼐ߎ_̓_̐
     * @see #checkInterval(JgclPureBezierCurve2D.IntervalInfo, double)
     */
    private int divideInterval(int no_pnts,
			       JgclBinaryTree.Node crnt_node,
			       double tol_2) {
	IntervalInfo crnt_info;
	double mid_param;

	JgclBinaryTree.Node left_node;
	IntervalInfo left_info;
	JgclPureBezierCurve2D left_bzc;

	JgclBinaryTree.Node right_node;
	IntervalInfo right_info;
	JgclPureBezierCurve2D right_bzc;

	final double half_point = 0.5;
	JgclPureBezierCurve2D[] div_bzcs;

	no_pnts++;

	crnt_info = (IntervalInfo)crnt_node.data();
	mid_param = (crnt_info.sp() + crnt_info.ep()) / 2.0;

	/*
	 * divide current interval into two
	 */
	try {
	    div_bzcs = crnt_info.bzc().divide(half_point);
	} catch (JgclParameterOutOfRange e) {
	    throw new JgclFatal();
	}
	left_bzc = div_bzcs[0];
	right_bzc = div_bzcs[1];

	left_info = new IntervalInfo(left_bzc, crnt_info.sp(), mid_param);
	left_node = crnt_node.makeLeft(left_info);

	right_info = new IntervalInfo(right_bzc, mid_param, crnt_info.ep());
	right_node = crnt_node.makeRight(right_info);

	/*
	 * check
	 */
	if (!checkInterval(left_info, tol_2))
	    no_pnts = divideInterval(no_pnts, left_node, tol_2);

	if (!checkInterval(right_info, tol_2))
	    no_pnts = divideInterval(no_pnts, right_node, tol_2);

	return no_pnts;
    }

    /**
     * ̋Ȑ́A^ꂽԂ́uvw̐x菬ۂԂB
     *
     * @param bi	Ȑ̋
     * @param tol_2	ߎ̐xƂė^ꂽűe덷v̎
     * @return	Ԃ́uvw̐x菬 trueAłȂ false
     */
    private boolean checkInterval(IntervalInfo bi, double tol_2) {
	JgclPureBezierCurve2D bzc = bi.bzc();
	int uicp_1 = bzc.nControlPoints() - 1;

	JgclVector2D edirs;
	JgclPoint2D ppnt;
	double dist;

	int i;

	edirs = bzc.controlPointAt(uicp_1).subtract(bzc.controlPointAt(0));

	for (i = 1; i < uicp_1; i++) {
	    ppnt = projectPointLine(bzc.controlPointAt(i), bzc.controlPointAt(0), edirs);
	    dist = bzc.controlPointAt(i).subtract(ppnt).norm();
	    if (dist > tol_2)
		return false;
	}
	return true;
    }

    /**
     * _钼ɓeB
     *
     * @param dApnt	e̓_
     * @param dB_pnt	̓_
     * @param dB_dir	̕xNg
     * @return	e_
     */
    private JgclPoint2D projectPointLine(JgclPoint2D dApnt,
					 JgclPoint2D dB_pnt,
					 JgclVector2D dB_dir) {
	double magni_dir;	/* magnitude of dB_dir */
	JgclVector2D euvec;	/* unitized vector of line */
	JgclVector2D evpp;	/* vector from dB_pnt to dApnt */
	double edot;		/* dot product */
	double m_eps = JgclMachineEpsilon.DOUBLE;

	if ((magni_dir = dB_dir.magnitude()) < m_eps)
	    euvec = JgclVector2D.zeroVector;
	else
	    euvec = dB_dir.divide(magni_dir);

	evpp = dApnt.subtract(dB_pnt);
	edot = euvec.dotProduct(evpp);

	return dB_pnt.add(euvec.multiply(edot));
    }

    /**
     * qm[hȂm[h́uf[^v
     * ^ꂽzɑ JgclBinaryTree.TraverseProcB
     */
    private class fillArray implements JgclBinaryTree.TraverseProc {
	/**
	 * qm[hȂm[h́uf[^v^ꂽzɑB
	 * <p>
	 * pdata  {@link JgclPureBezierCurve2D.FillInfo JgclPureBezierCurve2D.FillInfo} NX
	 * CX^XłȂ΂ȂȂB
	 * </p>
	 *
	 * @param node	ΏۂƂȂm[h
	 * @param ctl	Jnm[h node ܂ł̐[ (QƂȂ)
	 * @param pdata	m[h́uf[^vz
	 * @see #toPolyline(JgclParameterSection, JgclToleranceForDistance)
	 */
	public boolean doit(JgclBinaryTree.Node node, int ctl, Object pdata) {
	    if ((node.left() == null) && (node.right() == null)) {
		try {
		    FillInfo fill_info = (FillInfo)pdata;
		    int idx = fill_info.index;
		    IntervalInfo bi = (IntervalInfo)node.data();

		    fill_info.pnts[idx++] = new JgclPointOnCurve2D
			(bi.bzc().controlPointAt(0), fill_info.basisCurve, bi.sp());

		    if (idx == (fill_info.pnts.length - 1))
			fill_info.pnts[idx++] = new JgclPointOnCurve2D
			    (bi.bzc().controlPointAt(bi.bzc().nControlPoints()-1),
			     fill_info.basisCurve, bi.ep());
		    fill_info.index = idx;
		}
		catch (JgclInvalidArgumentValue e) {
		    throw new JgclFatal();
		}
	    }
	    return false;
	}
    }

    /**
     * ̗LȐ̊Jn_ԂB
     *
     * @return	Jn_
     */
    public JgclPoint2D startPoint() {
	return controlPointAt(0);
    }

    /**
     * ̗LȐ̏I_ԂB
     *
     * @return	I_
     */
    public JgclPoint2D endPoint() {
	int index = nControlPoints() - 1;
	return controlPointAt(index);
    }

    /**
     * ̃xWGȐ𔽓]xWGȐԂB
     *
     * @return	]xWGȐ
     */
    JgclPureBezierCurve2D reverse() {
	boolean isRat = isRational();
	int uicp = nControlPoints();
	JgclPoint2D[] rCp = new JgclPoint2D[uicp];
	double[] rWt = null;
	int i, j;

	if (isRat)
	    rWt = new double[uicp];
	for (i = 0, j = uicp - 1; i < uicp; i++, j--) {
	    rCp[i] = controlPointAt(j);
	    if (isRat)
		rWt[i] = weightAt(j);
	}
	try {
	    if (isRat)
		return new JgclPureBezierCurve2D(rCp, rWt);
	    else
		return new JgclPureBezierCurve2D(rCp);
	} catch (JgclInvalidArgumentValue e) {
	    throw new JgclFatal();
	}
    }

    /**
     * ̋Ȑ̃p[^`ԂB
     * 
     * @return	p[^`
     */
    JgclParameterDomain getParameterDomain() {
	try {
	    return new JgclParameterDomain(false, 0.0, 1.0);
	}
	catch (JgclInvalidArgumentValue e) {
	    // should never be occurred
	    throw new JgclFatal();
	}
    }

    /*
     * ^ꂽp[^lA̋Ȑ̒`ɑ΂ėLۂ𒲂ׂB
     * <p>
     * ^ꂽp[^l̋Ȑ̒`OĂꍇɂ
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     *
     * @param param	p[^l
     * @return	KvɉĂ̋Ȑ̒`Ɋۂ߂ꂽp[^l
     * @see	JgclParametricCurve#checkValidity(double)
     * @see	JgclParameterDomain#force(double)
     * @see	JgclParameterOutOfRange
     */
    private double checkParameter(double param)
    {
	checkValidity(param);
	return parameterDomain().force(param);
    }

    /**
     * ̋ȐA`̂܂܂ɂāAグȐԂB
     *
     * @return	`ŁAオȐ
     */
    public JgclPureBezierCurve2D elevateOneDegree() {
	boolean isPoly = this.isPolynomial();
	int nCP = this.nControlPoints();

	double[][] newCP =
	    JgclFreeformCurveWithControlPoints2D.allocateDoubleArray(isPoly,
								     (nCP + 1));
	this.setCoordinatesToDoubleArray(isPoly, nCP, newCP);
	JgclPureBezierCurveEvaluation.elevateOneDegree(nCP, newCP);

	return new JgclPureBezierCurve2D(newCP);
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricCurve2D#PURE_BEZIER_CURVE_2D JgclParametricCurve2D.PURE_BEZIER_CURVE_2D}
     */
    int type() {
	return PURE_BEZIER_CURVE_2D;
    }

    /**
     * ̋ȐA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricCurve2D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator2D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclPoint2D[] tControlPoints =
	    JgclPoint2D.transform(this.controlPoints,
				  reverseTransform,
				  transformationOperator,
				  transformedGeometries);
	if (this.isPolynomial() == true)
	    return new JgclPureBezierCurve2D(tControlPoints);
	else
	    return new JgclPureBezierCurve2D(tControlPoints, this.weights);

    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);
	StringBuffer buf = new StringBuffer();

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tcontrolPoints");
	for (int i = 0; i < nControlPoints(); i++) {
	    controlPointAt(i).output(writer, indent + 2);
        }
	if (weights() != null) {
	    writer.println(indent_tab + "\tweights ");
	    int i = 0;
	    while(true) {
		for (int j =0; j < 10 && i < weights().length; j++, i++){
		    writer.print(" " + weightAt(i));
		}
		writer.println();
		if (i < weights().length) {
		    writer.print(indent_tab + "\t");
		} else {
		    break;
		}
	    }
	}
        writer.println(indent_tab + "End");
    }
}
