/*
 * 3D _xWGȖʂւ̐̑߂NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclProjPntBzs3D.java,v 1.11 2000/08/11 06:19:00 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * 3D _xWGȖʂւ̐̑߂NX
 *
 * @version $Revision: 1.11 $, $Date: 2000/08/11 06:19:00 $
 * @author Information-technology Promotion Agency, Japan
 */
final class JgclProjPntBzs3D
{
    /**
     * NX̃CX^X쐬邽߂̃CX^X
     */
    private static JgclProjPntBzs3D myOwnInstance = new JgclProjPntBzs3D();

    /**
     * IuWFNg\z
     */
    private JgclProjPntBzs3D()
    {
    }

    /*
     * ^ꂽxWGȖʂ U ̈ꎟΓ֐\xWGȖʂԂ : gh3pdrv_bzs()
     */
    private static JgclPureBezierSurface3D getPartialDerivForU(JgclPureBezierSurface3D bzs)
    {
	int degree = bzs.uDegree();
	int uncp = bzs.uNControlPoints() - 1;
	int vncp = bzs.vNControlPoints();

	JgclPoint3D[][] partialDerivControlPoints = new JgclPoint3D[uncp][vncp];
	JgclPureBezierSurface3D partialDeriv;

	if (bzs.isPolynomial() == true)
	{
	    for (int j = 0; j < vncp; j++)
	    {
		for (int i = 0; i < uncp; i++)
		{
		    partialDerivControlPoints[i][j]
			= bzs.controlPointAt(i + 1, j)
			.subtract(bzs.controlPointAt(i, j)).multiply(degree).toPoint3D();
		}
	    }
	    partialDeriv = new JgclPureBezierSurface3D(partialDerivControlPoints);

	} else {
	    double[][] partialDerivWeights = new double[uncp][vncp];

	    for (int j = 0; j < vncp; j++)
	    {
		for (int i = 0; i < uncp; i++)
		{
		    partialDerivControlPoints[i][j]
			= bzs.controlPointAt(i + 1, j)
			.subtract(bzs.controlPointAt(i, j)).multiply(degree).toPoint3D();
		    partialDerivWeights[i][j] = (bzs.weightAt(i + 1, j) -
						 bzs.weightAt(i,     j)) * degree;
		}
	    }

	    partialDeriv = new JgclPureBezierSurface3D(partialDerivControlPoints,
						       partialDerivWeights,
						       false);
	}

	return partialDeriv;
    }

    /*
     * ^ꂽxWGȖʂ V ̈ꎟΓ֐\xWGȖʂԂ : gh3pdrv_bzs()
     */
    private static JgclPureBezierSurface3D getPartialDerivForV(JgclPureBezierSurface3D bzs)
    {
	int degree = bzs.vDegree();
	int uncp = bzs.uNControlPoints();
	int vncp = bzs.vNControlPoints() - 1;

	JgclPoint3D[][] partialDerivControlPoints = new JgclPoint3D[uncp][vncp];
	JgclPureBezierSurface3D partialDeriv;

	if (bzs.isPolynomial() == true)
	{
	    for (int j = 0; j < vncp; j++)
	    {
		for (int i = 0; i < uncp; i++)
		{
		    partialDerivControlPoints[i][j]
			= bzs.controlPointAt(i, j + 1)
			.subtract(bzs.controlPointAt(i, j)).multiply(degree).toPoint3D();
		}
	    }
	    partialDeriv = new JgclPureBezierSurface3D(partialDerivControlPoints);

	} else {
	    double[][] partialDerivWeights = new double[uncp][vncp];

	    for (int j = 0; j < vncp; j++)
	    {
		for (int i = 0; i < uncp; i++)
		{
		    partialDerivControlPoints[i][j]
			= bzs.controlPointAt(i, j + 1)
			.subtract(bzs.controlPointAt(i, j)).multiply(degree).toPoint3D();
		    partialDerivWeights[i][j] = (bzs.weightAt(i, j + 1) -
						 bzs.weightAt(i, j)) * degree;
		}
	    }

	    partialDeriv = new JgclPureBezierSurface3D(partialDerivControlPoints,
						       partialDerivWeights,
						       false);
	}

	return partialDeriv;
    }

    /**
     * P̃xWGȖ
     */
    private class BezierSurface1D
    {
	/**
	 * _
	 */
	double[][] controlPoints;

	/**
	 * d
	 */
	double[][] weights;

	/**
	 * IuWFNg\z
	 */
	BezierSurface1D()
	{
	}

	/**
	 * U̐_̐Ԃ
	 * 
	 * @return	U̐_̐
	 */
	int uNControlPoints()
	{
	    return controlPoints.length;
	}

	/**
	 * V̐_̐Ԃ
	 * 
	 * @return	V̐_̐
	 */
	int vNControlPoints()
	{
	    return controlPoints[0].length;
	}

	/**
	 * U̎Ԃ
	 * 
	 * @return	U̎
	 */
	int uDegree()
	{
	    return uNControlPoints() - 1;
	}

	/**
	 * V̎Ԃ
	 * 
	 * @return	V̎
	 */
	int vDegree()
	{
	    return vNControlPoints() - 1;
	}

	/**
	 * (i, j)Ԃ߂̐_Ԃ
	 * 
	 * @param	i	ŨCfbNX(iԂ)
	 * @param	j	ṼCfbNX(jԂ)
	 * @return		_
	 */
	double controlPointAt(int i,
			      int j)
	{
	    return controlPoints[i][j];
	}
    }

    /* gh3prod_bzsbzs(3, ...), gh3dpf_bzsbzs() */
    /**
     * ̒`̃xWGȖʂ̓ς\xWG֐Ԃ
     *
     * @param	bzs1	xWGȖʂP
     * @param	bzs2	xWGȖʂQ
     * @return	̃xWGȖʂ̓ς\xWG֐
     */
    private static BezierSurface1D getProductFunctionOf3D(JgclPureBezierSurface3D bzs1,
							  JgclPureBezierSurface3D bzs2)
    {
	int uDeg1 = bzs1.uDegree();
	int vDeg1 = bzs1.vDegree();

	int uDeg2 = bzs2.uDegree();
	int vDeg2 = bzs2.vDegree();

	int uDeg = uDeg1 + uDeg2;
	int vDeg = vDeg1 + vDeg2;

	int uNcp = uDeg + 1;
	int vNcp = vDeg + 1;

	double[] uBinCoef1 = JgclMath.pascalTriangle(bzs1.uNControlPoints());
	double[] vBinCoef1 = JgclMath.pascalTriangle(bzs1.vNControlPoints());
	double[] uBinCoef2 = JgclMath.pascalTriangle(bzs2.uNControlPoints());
	double[] vBinCoef2 = JgclMath.pascalTriangle(bzs2.vNControlPoints());
	double[] uBinCoef  = JgclMath.pascalTriangle(uNcp);
	double[] vBinCoef  = JgclMath.pascalTriangle(vNcp);

	BezierSurface1D prodFunc = myOwnInstance.new BezierSurface1D();
	prodFunc.controlPoints = new double[uNcp][vNcp];
	prodFunc.weights = null;

	int j_vDeg1 = 0 - vDeg1;
	for (int j = 0; j <= vDeg; j++)
	{
	    int max0j = Math.max(0, j_vDeg1);
	    int mindj = Math.min(vDeg2, j);

	    int i_uDeg1 = 0 - uDeg1;
	    for (int i = 0; i <= uDeg; i++)
	    {
		int max0i = Math.max(0, i_uDeg1);
		int mindi = Math.min(uDeg2, i);

		double rl = 0.0;
		int l     = max0i;
		int i_l   = i - max0i;

		for (; l <= mindi;)
		{
		    double rm = 0.0;
		    int m     = max0j;
		    int j_m   = j - max0j;

		    for (; m <= mindj;)
		    {
			JgclPoint3D b3p1 = bzs1.controlPointAt(i_l, j_m);
			JgclPoint3D b3p2 = bzs2.controlPointAt(l, m);

			rm += vBinCoef2[m] * vBinCoef1[j_m]
			    * ((b3p1.x() * b3p2.x()) +
			       (b3p1.y() * b3p2.y()) +
			       (b3p1.z() * b3p2.z()));

			m++;
			j_m--;
		    }

		    rl += uBinCoef2[l] * uBinCoef1[i_l] * rm;

		    l++;
		    i_l--;
		}

		prodFunc.controlPoints[i][j] = rl / (uBinCoef[i] * vBinCoef[j]);

		i_uDeg1++;
	    }

	    j_vDeg1++;
	}

	return prodFunc;
    }

    /* gh3prod_bzsbzs(1, ...), gh3prdf_bzfbzf() */
    /**
     * ̒`̃xWG֐ () ς\xWG֐Ԃ
     *
     * @param	bzs1	xWG֐P
     * @param	bzs2	xWG֐Q
     * @return	̃xWG֐ () ς\xWG֐
     */
    private static BezierSurface1D getProductFunctionOf1D(BezierSurface1D bzs1,
							  BezierSurface1D bzs2)
    {
	int uDeg1 = bzs1.uDegree();
	int vDeg1 = bzs1.vDegree();

	int uDeg2 = bzs2.uDegree();
	int vDeg2 = bzs2.vDegree();

	int uDeg = uDeg1 + uDeg2;
	int vDeg = vDeg1 + vDeg2;

	int uNcp = uDeg + 1;
	int vNcp = vDeg + 1;

	double[] uBinCoef1 = JgclMath.pascalTriangle(bzs1.uNControlPoints());
	double[] vBinCoef1 = JgclMath.pascalTriangle(bzs1.vNControlPoints());
	double[] uBinCoef2 = JgclMath.pascalTriangle(bzs2.uNControlPoints());
	double[] vBinCoef2 = JgclMath.pascalTriangle(bzs2.vNControlPoints());
	double[] uBinCoef  = JgclMath.pascalTriangle(uNcp);
	double[] vBinCoef  = JgclMath.pascalTriangle(vNcp);

	BezierSurface1D prodFunc = myOwnInstance.new BezierSurface1D();
	prodFunc.controlPoints = new double[uNcp][vNcp];
	prodFunc.weights = null;

	int j_vDeg1 = 0 - vDeg1;
	for (int j = 0; j <= vDeg; j++)
	{
	    int max0j = Math.max(0, j_vDeg1);
	    int mindj = Math.min(vDeg2, j);

	    int i_uDeg1 = 0 - uDeg1;
	    for (int i = 0; i <= uDeg; i++)
	    {
		int max0i = Math.max(0, i_uDeg1);
		int mindi = Math.min(uDeg2, i);

		double rl = 0.0;
		int l     = max0i;
		int i_l   = i - max0i;

		for (; l <= mindi;)
		{
		    double rm = 0.0;
		    int m     = max0j;
		    int j_m   = j - max0j;

		    for (; m <= mindj;)
		    {
			double b1p1 = bzs1.controlPointAt(i_l, j_m);
			double b1p2 = bzs2.controlPointAt(l, m);

			rm += vBinCoef2[m] * vBinCoef1[j_m] * (b1p1 * b1p2);

			m++;
			j_m--;
		    }

		    rl += uBinCoef2[l] * uBinCoef1[i_l] * rm;

		    l++;
		    i_l--;
		}

		prodFunc.controlPoints[i][j] = rl / (uBinCoef[i] * vBinCoef[j]);

		i_uDeg1++;
	    }

	    j_vDeg1++;
	}

	return prodFunc;
    }

    /**
     * xWG֐̍\xWG֐Ԃ
     *
     * @param	bzf1	xWG֐P
     * @param	bzf2	xWG֐Q
     * @return	bzf1 - bzf2
     */
    private static BezierSurface1D makeSubtractOfTwoProdFunctions(BezierSurface1D bzf1,
								  BezierSurface1D bzf2)
    {
	BezierSurface1D diff = myOwnInstance.new BezierSurface1D();
	diff.controlPoints = new double[bzf1.uNControlPoints()][bzf1.vNControlPoints()];
	diff.weights = null;

	// System.out.println("bzsf1 : " + bzf1.uNControlPoints() + ", " + bzf1.vNControlPoints());
	// System.out.println("bzsf2 : " + bzf2.uNControlPoints() + ", " + bzf2.vNControlPoints());

	for (int i = 0; i < bzf1.uNControlPoints(); i++)
	    for (int j = 0; j < bzf1.vNControlPoints(); j++)
		diff.controlPoints[i][j] = bzf1.controlPoints[i][j]
                                         - bzf2.controlPoints[i][j];

	return diff;
    }

    /**
     * _xWGȖʏ̂_ւ̃xNgƁA
     * ̋Ȗʏ̓_ł̕Γ֐xNgƂ̓ς̒l\
     * Q̃xWGȖʂ쐬
     *
     * @param	pnt	_
     * @param	bzs	xWGȖ
     * @return	Q̃xWGȖ
     */
    private static JgclPureBezierSurfaceWithGivenControlPointsArray2D
    makeBezierSurface2D(JgclPoint3D pnt, JgclPureBezierSurface3D bzs)
    {
	/*
	 * bzs  pnt _ƂWnɈڂ
	 */
	int uncp = bzs.uNControlPoints();
	int vncp = bzs.vNControlPoints();
	JgclPoint3D[][] transformedControlPoints = new JgclPoint3D[uncp][vncp];

	JgclPureBezierSurface3D eB;	// transformed bzs
	BezierSurface1D eBdpB;		// (eB(u, v), eB(u, v))

	JgclPureBezierSurface3D eBdu;	// U partial deriv. of eB
	JgclPureBezierSurface3D eBdv;	// V partial deriv. of eB

	BezierSurface1D eBdpu;		// (eB(u,v), (deB(u,v) / du))
	BezierSurface1D eBmdpu;		// degree-elevated eBdpu

	BezierSurface1D eBdpv;		// (eB(u,v), (deB(u,v) / dv))
	BezierSurface1D eBmdpv;		// degree-elevated eBdpv

	BezierSurface1D bzf_w = myOwnInstance.new BezierSurface1D();
					// aux. bezier function for degree elevation
	BezierSurface1D eBdpt1;		// work area
	BezierSurface1D eBdpt2;		// work area
	BezierSurface1D eBdpt3;		// work area
	BezierSurface1D eBde;		// work pointer

	if (bzs.isPolynomial() == true)
	{
	    for (int u = 0; u < uncp; u++)
		for (int v = 0; v < vncp; v++)
		    transformedControlPoints[u][v]
			= bzs.controlPointAt(u, v).subtract(pnt).toPoint3D();

	    eB = new JgclPureBezierSurface3D(transformedControlPoints);
	}
	else
	{
	    // Lł΁AWɕϊĂ
	    for (int u = 0; u < uncp; u++)
		for (int v = 0; v < vncp; v++)
		    transformedControlPoints[u][v]
			= bzs.controlPointAt(u, v).subtract(pnt)
			.multiply(bzs.weightAt(u, v)).toPoint3D();

	    eB = new JgclPureBezierSurface3D(transformedControlPoints, bzs.weights());
	}

	if (bzs.isRational() == true)
	    eBdpB = getProductFunctionOf3D(eB, eB);
	else
	    eBdpB = null;

	/*
	 * (eB(u,v), (deB(u,v) / du))
	 */
	eBdu = getPartialDerivForU(eB);
	eBdpu = getProductFunctionOf3D(eB, eBdu);
	eBde = eBdpu;

	if (bzs.isRational() == true)
	{
	    bzf_w.controlPoints = eB.weights;
	    eBdpt1 = getProductFunctionOf1D(bzf_w, eBdpu);

	    bzf_w.controlPoints = eBdu.weights;
	    eBdpt2 = getProductFunctionOf1D(bzf_w, eBdpB);

	    eBdpt3 = makeSubtractOfTwoProdFunctions(eBdpt1, eBdpt2);
	    eBde = eBdpt3;
	}
	
	double[][] bzf_de_cntrl_pnts_21 = new double[2][1];
	bzf_de_cntrl_pnts_21[0][0] = 1.0;
	bzf_de_cntrl_pnts_21[1][0] = 1.0;

	bzf_w.controlPoints = bzf_de_cntrl_pnts_21;
	eBmdpu = getProductFunctionOf1D(bzf_w, eBde);

	/*
	 * (eB(u,v), (deB(u,v) / dv))
	 */
	eBdv = getPartialDerivForV(eB);
	eBdpv = getProductFunctionOf3D(eB, eBdv);
	eBde = eBdpv;

	if (bzs.isRational() == true)
	{
	    bzf_w.controlPoints = eB.weights;
	    eBdpt1 = getProductFunctionOf1D(bzf_w, eBdpv);

	    bzf_w.controlPoints = eBdv.weights;
	    eBdpt2 = getProductFunctionOf1D(bzf_w, eBdpB);

	    eBdpt3 = makeSubtractOfTwoProdFunctions(eBdpt1, eBdpt2);
	    eBde = eBdpt3;
	}
	
	double[][] bzf_de_cntrl_pnts_12 = new double[1][2];
	bzf_de_cntrl_pnts_12[0][0] = 1.0;
	bzf_de_cntrl_pnts_12[0][1] = 1.0;

	bzf_w.controlPoints = bzf_de_cntrl_pnts_12;
	eBmdpv = getProductFunctionOf1D(bzf_w, eBde);

	/*
	 * (BezierSurface1D, BezierSurface1D) => BezierSurface2D
	 */
	double[][][] controlPoints = 
	    JgclFreeformSurfaceWithGivenControlPointsArray2D.
	    allocateDoubleArray(true, eBmdpu.uNControlPoints(), eBmdpu.vNControlPoints());

	for (int i = 0; i < eBmdpu.uNControlPoints(); i++) {
	    for (int j = 0; j < eBmdpu.vNControlPoints(); j++) {
		controlPoints[i][j][0] = eBmdpu.controlPoints[i][j];
		controlPoints[i][j][1] = eBmdpv.controlPoints[i][j];
	    }
	}

	return new JgclPureBezierSurfaceWithGivenControlPointsArray2D(controlPoints);
    }

    /**
     * ̃p[^l̑gƂ݂Ȃ邩ۂ
     *
     * @param	pos		p[^l̑g
     * @param	paramPair	p[^l̑g
     * @param	dTol		̋e덷
     */
    private static boolean twoPointsCoincide(JgclPointOnSurface3D pos,
					     double[] paramPair,
					     JgclToleranceForDistance dTol)
    {
	JgclPoint3D crd0
	    = pos.basisSurface().coordinates(pos.uParameter(), pos.vParameter());
	JgclPoint3D crd1
	    = pos.basisSurface().coordinates(paramPair[0],     paramPair[1]);

	if (crd0.distance2(crd1) > dTol.squared())
	    return false;

	double uDiff = pos.uParameter() - paramPair[0];
	double vDiff = pos.vParameter() - paramPair[1];

	if ((Math.abs(uDiff) < dTol.toToleranceForParameterU(pos.basisSurface(),
							     pos.uParameter(),
							     pos.vParameter()).value()) &&
	    (Math.abs(vDiff) < dTol.toToleranceForParameterV(pos.basisSurface(),
							     pos.uParameter(),
							     pos.vParameter()).value()))
	    return true;

	return false;
    }

    /**
     * ^ꂽp[^̑gƂăXgɉ
     *
     * @param bzs	xWGȖ
     * @param paramPair	p[^̑g
     * @param	dTol	̋e덷
     * @param	zpl	̃Xg
     */
    private static void addAsSolution(JgclPureBezierSurface3D bzs,
				      double[] paramPair,
				      JgclToleranceForDistance dTol,
				      Vector zpl)
    {
	for (Enumeration e = zpl.elements(); e.hasMoreElements() ;)
	{
	    if (twoPointsCoincide((JgclPointOnSurface3D)e.nextElement(),
				  paramPair, dTol) == true)
		return;
	}

	zpl.addElement(new JgclPointOnSurface3D(bzs,
						paramPair[0],
						paramPair[1]));
    }

    /**
     * Q̃xWGȖʂ (0, 0) ƂȂp[^l (u, v) ߂
     *
     * @param	bzs3D	R̃xWGȖ
     * @param	bzs	Q̃xWGȖ
     * @param	uLbp	Q̃xWGȖʂ U ̃p[^l
     * @param	uUbp	Q̃xWGȖʂ U ̃p[^l
     * @param	vLbp	Q̃xWGȖʂ V ̃p[^l
     * @param	vUbp	Q̃xWGȖʂ V ̃p[^l
     * @param	dTol	̋e덷
     * @param	zpl	Q̃xWGȖʂ (0, 0) ƂȂp[^l (u, v) ̃Xg
     * @param	buf4Div	̋Ȗʕŗpobt@
     */
    private static void getZeroPoints(JgclPureBezierSurface3D bzs3D,
				      JgclPureBezierSurfaceWithGivenControlPointsArray2D bzs,
				      double uLbp,
				      double uUbp,
				      double vLbp,
				      double vUbp,
				      JgclToleranceForDistance dTol,
				      Vector zpl)
    {
	double[] paramCenter = new double[2];
	paramCenter[0] = (uLbp + uUbp) / 2.0;
	paramCenter[1] = (vLbp + vUbp) / 2.0;

	// bzs ̑ݔ͈͂`𓾂
	JgclEnclosingBox2D box = bzs.approximateEnclosingBox();

	// `_ (0, 0) ܂܂ȂȂ΁AȂ
	if ((box.min().x() > 0.0) ||
	    (box.min().y() > 0.0) ||
	    (box.max().x() < 0.0) ||
	    (box.max().y() < 0.0))
	    return;

	// `\ɏȂ΁Azero point list ɉ
	if ((box.min().x() > (- dTol.value())) &&
	    (box.min().y() > (- dTol.value())) &&
	    (box.max().x() <    dTol.value())  &&
	    (box.max().y() <    dTol.value()))
	{
	    addAsSolution(bzs3D, paramCenter, dTol, zpl);
	    return;
	}

	// l
	JgclPureBezierSurfaceWithGivenControlPointsArray2D[] uBzs   = bzs.uDivide(0.5);
	JgclPureBezierSurfaceWithGivenControlPointsArray2D[] u0vBzs = uBzs[0].vDivide(0.5);
	JgclPureBezierSurfaceWithGivenControlPointsArray2D[] u1vBzs = uBzs[1].vDivide(0.5);

	// ꂼɂāAzero point 𒲂ׂ
	getZeroPoints(bzs3D, u0vBzs[0],
		      uLbp, paramCenter[0],
		      vLbp, paramCenter[1], dTol, zpl);
	getZeroPoints(bzs3D, u0vBzs[1],
		      uLbp, paramCenter[0],
		      paramCenter[1], vUbp, dTol, zpl);
	getZeroPoints(bzs3D, u1vBzs[0],
		      paramCenter[0], uUbp,
		      vLbp, paramCenter[1], dTol, zpl);
	getZeroPoints(bzs3D, u1vBzs[1],
		      paramCenter[0], uUbp,
		      paramCenter[1], vUbp, dTol, zpl);
    }

    /**
     * xWGȖʂ̋EԂ
     *
     * @param	bzs	xWGȖ
     * @param	i	E̔ԍ
     */
    private static JgclPureBezierCurve3D getBoundary(JgclPureBezierSurface3D bzs,
						     int i)
    {
	JgclPoint3D[] controlPoints;
	double[] weights = null;
	int anotherIndex;

	switch (i)
	{
	case 0: /* U = 0 */ anotherIndex = 0;			break;
	case 1: /* U = 1 */ anotherIndex = bzs.uDegree();	break;
	case 2: /* V = 0 */ anotherIndex = 0;			break;
	case 3: /* V = 1 */ anotherIndex = bzs.vDegree();	break;
	default: return null;
	}

	if (i <= 1)
	{
	    controlPoints = new JgclPoint3D[bzs.vNControlPoints()];
	    for (i = 0; i < bzs.vNControlPoints(); i++)
		controlPoints[i] = bzs.controlPointAt(anotherIndex, i);
	    if (bzs.isRational() == true) {
		weights = new double[bzs.vNControlPoints()];
		for (i = 0; i < bzs.vNControlPoints(); i++)
		    weights[i] = bzs.weightAt(anotherIndex, i);
	    }
	}
        else
	{
	    controlPoints = new JgclPoint3D[bzs.uNControlPoints()];
	    for (i = 0; i < bzs.uNControlPoints(); i++)
		controlPoints[i] = bzs.controlPointAt(i, anotherIndex);
	    if (bzs.isRational() == true) {
		weights = new double[bzs.uNControlPoints()];
		for (i = 0; i < bzs.uNControlPoints(); i++)
		    weights[i] = bzs.weightAt(i, anotherIndex);
	    }
	}

	if (bzs.isPolynomial() == true)
	    return new JgclPureBezierCurve3D(controlPoints);
	else
	    return new JgclPureBezierCurve3D(controlPoints, weights);
    }

    /**
     * xWGȖʂ̋Eɗ鐂߂
     *
     * @param	pnt	_
     * @param	bzs	xWGȖ
     * @param	dTol	̋e덷
     * @param	aTol	px̋e덷
     * @param	zpl	Q̃xWGȖʂ (0, 0) ƂȂp[^l (u, v) ̔z
     */
    private static void computeWithBoundary(JgclPoint3D pnt,
					    JgclPureBezierSurface3D bzs,
					    JgclToleranceForDistance dTol,
					    JgclToleranceForAngle aTol,
					    Vector zpl)
    {
	double param;
	JgclPureBezierCurve3D bzc;
	JgclPointOnCurve3D[] feet;
	double[] paramPair = new double[2];
	JgclVector3D footVector;
	JgclVector3D[] tangents;

	for (int i = 0; i < 4; i++)
	{
	    param = ((i % 2) == 0) ? 0.0 : 1.0;
	    bzc = getBoundary(bzs, i);
	    feet = bzc.projectFrom(pnt);

	    if (feet.length <= 0)
	    {
		if ((pnt.distance2(bzc.controlPointAt(0)) > dTol.squared()) != true)
		{
		    if (i < 2)
		    {
			paramPair[0] = param;
			paramPair[1] = 0.0;
		    }
		    else
		    {
			paramPair[0] = 0.0;
			paramPair[1] = param;
		    }
		    addAsSolution(bzs, paramPair, dTol, zpl);
		}

		if ((pnt.distance2(bzc.controlPointAt(bzc.degree())) > dTol.squared()) != true)
		{
		    if (i < 2)
		    {
			paramPair[0] = param;
			paramPair[1] = 1.0;
		    }
		    else
		    {
			paramPair[0] = 1.0;
			paramPair[1] = param;
		    }
		    addAsSolution(bzs, paramPair, dTol, zpl);
		}

		continue;
	    }

	    for (int j = 0; j < feet.length; j++)
	    {
		if (i < 2)
		{
		    paramPair[0] = param;
		    paramPair[1] = feet[j].parameter();
		}
		else
		{
		    paramPair[0] = feet[j].parameter();
		    paramPair[1] = param;
		}

		if (pnt.distance2(feet[j].coordinates()) > dTol.squared())
		{
		    footVector = feet[j].coordinates().subtract(pnt).unitized();
		    tangents = bzs.tangentVector(paramPair[0], paramPair[1]);
		    if ((footVector.dotProduct(tangents[0].unitized()) > aTol.value()) ||
			(footVector.dotProduct(tangents[1].unitized()) > aTol.value()))
			continue;
		}

		addAsSolution(bzs, paramPair, dTol, zpl);
	    }
	}
    }

    /**
     * 3D _xWGȖʂւ̐̑߂NX
     *
     * @param	pnt	_
     * @param	bzs	xWGȖ
     * @return	̑̔z
     * @see	JgclPointOnSurface3D
     */
    static JgclPointOnSurface3D[] projection(JgclPoint3D pnt,
					     JgclPureBezierSurface3D bzs)
    {
	JgclToleranceForDistance dTol
	    = JgclConditionOfOperation.getCondition().getToleranceForDistanceAsObject();
	JgclToleranceForAngle aTol
	    = JgclConditionOfOperation.getCondition().getToleranceForAngleAsObject();

	Vector zeroPointList = new Vector();

	JgclPureBezierSurfaceWithGivenControlPointsArray2D eBmdp =
	    makeBezierSurface2D(pnt, bzs);
	getZeroPoints(bzs, eBmdp, 0.0, 1.0, 0.0, 1.0, dTol, zeroPointList);

	computeWithBoundary(pnt, bzs, dTol, aTol, zeroPointList);

	JgclPointOnSurface3D[] result = new JgclPointOnSurface3D[zeroPointList.size()];
	zeroPointList.copyInto(result);

	return result;
    }

    /**
     * fobOpCvOB
     */
    public static void main(String[] argv)
    {
	JgclPoint3D[][] controlPoints = new JgclPoint3D[4][4];

	controlPoints[0][0]
	    = new JgclCartesianPoint3D(-906.190856934,	1146.898925781,	2000.000000000);
	controlPoints[1][0]
	    = new JgclCartesianPoint3D(46.812759399,	1270.228881836,	1000.000000000);
	controlPoints[2][0]
	    = new JgclCartesianPoint3D(943.757324219,	1281.440673828,	1000.000000000);
	controlPoints[3][0]
	    = new JgclCartesianPoint3D(1594.042114258,	1102.051757813,	2000.000000000);

	controlPoints[0][1]
	    = new JgclCartesianPoint3D(-794.072753906,	-277.000549316,	0.000000000);
	controlPoints[1][1]
	    = new JgclCartesianPoint3D(259.837097168,	-108.823440552,	0.000000000);
	controlPoints[2][1]
	    = new JgclCartesianPoint3D(1022.239990234,	-176.094284058,	0.000000000);
	controlPoints[3][1]
	    = new JgclCartesianPoint3D(1560.406738281,	-512.448486328,	0.000000000);

	controlPoints[0][2]
	    = new JgclCartesianPoint3D(-558.624816895,	-1644.841064453,	0.000000000);
	controlPoints[1][2]
	    = new JgclCartesianPoint3D(428.014221191,	-1330.910400391,	0.000000000);
	controlPoints[2][2]
	    = new JgclCartesianPoint3D(1246.476074219,	-1476.663940430,	0.000000000);
	controlPoints[3][2]
	    = new JgclCartesianPoint3D(1829.490112305,	-2037.254272461,	0.000000000);

	controlPoints[0][3]
	    = new JgclCartesianPoint3D(-502.565795898,	-2833.292480469,	1000.000000000);
	controlPoints[1][3]
	    = new JgclCartesianPoint3D(349.531555176,	-2519.362060547,	0.000000000);
	controlPoints[2][3]
	    = new JgclCartesianPoint3D(1033.451782227,	-2597.844726563,	500.000000000);
	controlPoints[3][3]
	    = new JgclCartesianPoint3D(1268.899780273,	-3068.740478516,	1000.00000000);

	JgclPoint3D pnt = new JgclCartesianPoint3D(574.673950195, -1225.472839355, 3300.000000000);
	JgclPureBezierSurface3D bzs = new JgclPureBezierSurface3D(controlPoints);
	JgclPointOnSurface3D[] feet;
	//try
	//{
	    feet = bzs.projectFrom(pnt);
	//}
	//catch (JgclIndefiniteSolution e)
	//{
	//    feet = new JgclPointOnSurface3D[1];
	//    feet[0] = (JgclPointOnSurface3D)e.suitable();
	//}

	for (int i = 0; i < feet.length; i++)
	{
	    JgclPoint3D coord = feet[i].coordinates();
	    System.out.println("" + coord.x() + ", " + coord.y() + ", " + coord.z() +
			       " (" + feet[i].uParameter() + ", " + feet[i].vParameter() + ")");
	}

	/*
	 * solutions by GHL
	 *
	 * 1110.039439435705845, -1873.073499380423300, 275.300229335716381
	 *	(0.716023034576210, 0.745925374008948)
	 *
	 * 18.232798954902169, -1728.225976249814948, 243.533115228460275
	 *	(0.221145955409156, 0.737372916351887)
	 *
	 * 237.995939897379287, 72.902444530493824, 497.372987478862456
	 *	(0.367881981641403, 0.279059129883535)
	 */
    }
}

// end of file
