/*
 * R : Ȑ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclPolynomialCurve3D.java,v 1.28 2000/04/26 13:21:16 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : Ȑ\NXB
 * <p>
 * ̃NX̃CX^Xɂ́AR X, Y, Z 
 * O̑ (X, Y, Z) ŕ\ȐƁA
 * l̑ (WX, WY, WZ, W) ŕ\LȐB
 * </p>
 * <p>
 * X, Y, Z  WX, XY, WZ, W ̊e\͓ł̂ƂB
 * </p>
 *
 * @version $Revision: 1.28 $, $Date: 2000/04/26 13:21:16 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclPolynomialCurve3D extends JgclParametricCurve3D {
    /**
     * Ȑ X \ (L̏ꍇ WX ) B
     * @serial
     */
    private final JgclRealPolynomial polyX;

    /**
     * Ȑ Y \ (L̏ꍇ WY ) B
     * @serial
     */
    private final JgclRealPolynomial polyY;

    /**
     * Ȑ Z \ (L̏ꍇ WZ ) B
     * @serial
     */
    private final JgclRealPolynomial polyZ;

    /**
     * Ȑ W \ (L̏ꍇ̂) B
     * @serial
     */
    private final JgclRealPolynomial polyW;

    /**
     * ꎟ֐\ȐB
     * <p>
     * ̃tB[h̓CX^X̓ł̂ݗpB
     * </p>
     * @serial
     */
    private JgclPolynomialCurve3D derivativeCurve;

    /**
     * ^ɃIuWFNg\z邱Ƃ͂łȂB
     */
    private JgclPolynomialCurve3D() {
	super();
	polyX = null;
	polyY = null;
	polyZ = null;
	polyW = null;
    }

    /**
     *  (integral polynomial) ȐƂăIuWFNg\zB
     *
     * @param	xPoly	X \
     * @param	yPoly	Y \
     * @param	zPoly	Z \
     */
    public JgclPolynomialCurve3D(JgclRealPolynomial xPoly,
				  JgclRealPolynomial yPoly,
				  JgclRealPolynomial zPoly)
    {
	if ((xPoly == null) || (yPoly == null) || (zPoly == null))
	    throw new JgclFatal("one of arguments is null");

	if ((xPoly.degree() != yPoly.degree()) ||
	    (xPoly.degree() != zPoly.degree()))
	    throw new JgclFatal("given polynomials have different degrees");

	polyX = xPoly;
	polyY = yPoly;
	polyZ = zPoly;
	polyW = null;

	derivativeCurve = null;
    }

    /**
     * L (rational polynomial) ȐƂăIuWFNg\zB
     * <p>
     * Ȑ̑ꐬɂĂ̑̒l X ł͂Ȃ WX \ƂɒӁB
     * 񐬕ɂĂ̑̒lAlɁAY ł͂Ȃ WY \B
     * OɂĂ̑̒lAlɁAZ ł͂Ȃ WZ \B
     * </p>
     *
     * @param	wxPoly	WX \
     * @param	wyPoly	WY \
     * @param	wzPoly	WZ \
     * @param	wPoly	W  \
     */
    public JgclPolynomialCurve3D(JgclRealPolynomial wxPoly,
				  JgclRealPolynomial wyPoly,
				  JgclRealPolynomial wzPoly,
				  JgclRealPolynomial wPoly)
    {
	if ((wxPoly == null) || (wyPoly == null) || (wzPoly == null) || (wPoly == null))
	    throw new JgclFatal("one of arguments is null");

	if ((wxPoly.degree() != wPoly.degree()) || 
	    (wxPoly.degree() != wPoly.degree()) || 
	    (wzPoly.degree() != wPoly.degree()))
	    throw new JgclFatal("given polynomials have different degrees");

	polyX = wxPoly;
	polyY = wyPoly;
	polyZ = wzPoly;
	polyW = wPoly;

	derivativeCurve = null;
    }

    /**
     * ̑Ȑ̎ԂB
     * 
     * @return	Ȑ̎
     */
    public int degree() {
	return polyX.degree();
    }

    /**
     * ̋Ȑ`ۂԂB
     *
     * @return	`Ȃ trueAłȂ false
     */
    public boolean isIntegral() {
	return (polyW == null);
    }

    /**
     * ̋ȐL`ۂԂB
     *
     * @return	L`Ȃ trueAłȂ false
     */
    public boolean isRational() {
	return (polyW != null);
    }

    /**
     * ̋Ȑ̓֐\ȐԂB
     *
     * @return	֐\Ȑ
     */
    private JgclPolynomialCurve3D derivative() {
	if (derivativeCurve == null) {
	    if (isIntegral()) {
		derivativeCurve =
		    new JgclPolynomialCurve3D(polyX.derive(), polyY.derive(), polyZ.derive());
	    } else {
		derivativeCurve =
		    new JgclPolynomialCurve3D(polyX.derive(), polyY.derive(), polyZ.derive(),
					      polyW.derive());
	    }
	}

	return derivativeCurve;
    }

    /**
     * ̋ȐA^ꂽxNgɏ]ĕsړȐԂB
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     *
     * @param moveVec	sړ̕Ɨʂ\xNg
     * @return		sړ̋Ȑ
     * @see	JgclNotSupported
     */
    public JgclParametricCurve3D parallelTranslate(JgclVector3D moveVec) {
	throw new JgclNotSupported();
    }

    /**
     * ̋Ȑ̃p[^`ԂB
     * 
     * @return	ŔIȃp[^`
     */
    JgclParameterDomain getParameterDomain() {
	return new JgclParameterDomain();
    }

    /**
     * ̋Ȑ􉽓IɕĂ邩ۂԂB
     *
     * @return	 false
     */
    boolean getClosedFlag() {
	return false;	// ???
    }

    /**
     * ̊􉽗vfR`󂩔ۂԂB
     *
     * @return	 true
     */
    public boolean isFreeform() {
	return true;
    }

    /**
     * ̋Ȑ𐮑ȐłƂāA^ꂽp[^lŕ]B
     * 
     * @param	param	p[^l
     * @return		Wl
     */
    private JgclLiteralVector3D evaluateAsIntegral(double param) {
	return new JgclLiteralVector3D(polyX.evaluate(param),
				       polyY.evaluate(param),
				       polyZ.evaluate(param));
    }

    /**
     * ̋ȐLȐłƂāA^ꂽp[^lŕ]B
     * 
     * @param	param	p[^l
     * @return		Wl
     */
    private JgclHomogeneousVector3D evaluateAsRational(double param) {
	return new JgclHomogeneousVector3D(polyX.evaluate(param),
					   polyY.evaluate(param),
					   polyZ.evaluate(param),
					   polyW.evaluate(param));
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̍WlԂB
     * 
     * @param	param	p[^l
     * @return		Wl
     */
    private JgclPoint3D evaluateD0(double param) {
	JgclPoint3D result;

	if (isIntegral()) {
	    JgclLiteralVector3D D0 = evaluateAsIntegral(param);
	    result = new JgclCartesianPoint3D(D0.x(), D0.y(), D0.z());
	} else {
	    JgclHomogeneousVector3D D0H = evaluateAsRational(param);
	    result = new JgclHomogeneousPoint3D(D0H.wx(), D0H.wy(), D0H.wz(), D0H.w());
	}

	return result;
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̈ꎟ֐ԂB
     * 
     * @param	param	p[^
     * @return		ꎟ֐
     */
    private JgclVector3D evaluateD1(double param) {
	JgclVector3D result;

	if (isIntegral()) {
	    result = derivative().evaluateAsIntegral(param);
	} else {
	    /*
	     * p(t)  = h(t)  / w(t)	: h = (wx, wy)
	     * h(t)  = w(t)  * p(t)
	     * h'(t) = w'(t) * p(t) + w(t) * p'(t)
	     * p'(t) = (h'(t) - w'(t) * p(t)) / w(t)
	     */
	    JgclHomogeneousVector3D D0H = evaluateAsRational(param);
	    JgclHomogeneousVector3D D1H = derivative().evaluateAsRational(param);

	    JgclVector3D D0 = D0H;
	    JgclVector3D D1 = new JgclHomogeneousVector3D
		((D1H.wx() - (D1H.w() * D0.x())),
		 (D1H.wy() - (D1H.w() * D0.y())),
		 (D1H.wz() - (D1H.w() * D0.z())),
		 D0H.w());
	    result = D1;
	}

	return result;
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̈ꎟ/񎟓֐ԂB
     * <p>
     * ʂƂēz̗vf 2 ŁA
     * ŏ̗vfɈꎟ֐A
     * Ԗڂ̗vfɓ񎟓֐
     * B
     * </p>
     * 
     * @param	param	p[^
     * @return		֐̔z
     */
    private JgclVector3D[] evaluateD1D2(double param) {
	JgclVector3D[] result = new JgclVector3D[2];

	if (isIntegral()) {
	    result[0] = derivative().evaluateAsIntegral(param);
	    result[1] = derivative().derivative().evaluateAsIntegral(param);
	} else {
	    JgclHomogeneousVector3D D0H = evaluateAsRational(param);
	    JgclHomogeneousVector3D D1H = derivative().evaluateAsRational(param);
	    JgclHomogeneousVector3D D2H = derivative().derivative().evaluateAsRational(param);

	    JgclVector3D D0 = D0H;
	    JgclVector3D D1 = new JgclHomogeneousVector3D
		((D1H.wx() - (D1H.w() * D0.x())),
		 (D1H.wy() - (D1H.w() * D0.y())),
		 (D1H.wz() - (D1H.w() * D0.z())),
		 D0H.w());
	    JgclVector3D D2 = new JgclHomogeneousVector3D
		((D2H.wx() - ((2.0 * D1H.w() * D1.x()) + (D2H.w() * D0.x()))),
		 (D2H.wy() - ((2.0 * D1H.w() * D1.y()) + (D2H.w() * D0.y()))),
		 (D2H.wz() - ((2.0 * D1H.w() * D1.z()) + (D2H.w() * D0.z()))),
		 D0H.w());
	    result[0] = D1;
	    result[1] = D2;
	}

	return result;
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̈ꎟ//O֐ԂB
     * <p>
     * ʂƂēz̗vf 3 ŁA
     * ŏ̗vfɈꎟ֐A
     * Ԗڂ̗vfɓ񎟓֐A
     * OԖڂ̗vfɎO֐
     * B
     * </p>
     * 
     * @param	param	p[^
     * @return		֐̔z
     */
    private JgclVector3D[] evaluateD1D2D3(double param) {
	JgclVector3D[] result = new JgclVector3D[3];

	if (isIntegral()) {
	    result[0] = derivative().evaluateAsIntegral(param);
	    result[1] = derivative().derivative().evaluateAsIntegral(param);
	    result[2] = derivative().derivative().derivative().evaluateAsIntegral(param);
	} else {
	    JgclHomogeneousVector3D D0H = evaluateAsRational(param);
	    JgclHomogeneousVector3D D1H = derivative().evaluateAsRational(param);
	    JgclHomogeneousVector3D D2H = derivative().derivative().evaluateAsRational(param);
	    JgclHomogeneousVector3D D3H = derivative().derivative().derivative().evaluateAsRational(param);

	    JgclVector3D D0 = D0H;
	    JgclVector3D D1 = new JgclHomogeneousVector3D
		((D1H.wx() - (D1H.w() * D0.x())),
		 (D1H.wy() - (D1H.w() * D0.y())),
		 (D1H.wz() - (D1H.w() * D0.z())),
		 D0H.w());
	    JgclVector3D D2 = new JgclHomogeneousVector3D
		((D2H.wx() - ((2.0 * D1H.w() * D1.x()) + (D2H.w() * D0.x()))),
		 (D2H.wy() - ((2.0 * D1H.w() * D1.y()) + (D2H.w() * D0.y()))),
		 (D2H.wz() - ((2.0 * D1H.w() * D1.z()) + (D2H.w() * D0.z()))),
		 D0H.w());
	    JgclVector3D D3 = new JgclHomogeneousVector3D
		((D3H.wx() - ((3.0 * ((D1H.w() * D2.x()) + (D2H.w() * D1.x()))) + (D3H.w() * D0.x()))),
		 (D3H.wy() - ((3.0 * ((D1H.w() * D2.y()) + (D2H.w() * D1.y()))) + (D3H.w() * D0.y()))),
		 (D3H.wz() - ((3.0 * ((D1H.w() * D2.z()) + (D2H.w() * D1.z()))) + (D3H.w() * D0.z()))),
		 D0H.w());

	    result[0] = D1;
	    result[1] = D2;
	    result[2] = D3;
	}

	return result;
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̍WlԂB
     * 
     * @param	param	p[^l
     * @return		Wl
     */
    public JgclPoint3D coordinates(double param) {
	return evaluateD0(param);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̐ڃxNgԂB
     * 
     * @param	param	p[^l
     * @return		ڃxNg
     */
    public JgclVector3D tangentVector(double param) {
	return evaluateD1(param);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̋ȗԂB
     * 
     * @param	param	p[^l
     * @return		ȗ
     */
    public JgclCurveCurvature3D curvature(double param) {
	JgclVector3D[] D1D2 = evaluateD1D2(param);
	JgclVector3D     D1 = D1D2[0];
	JgclVector3D     D2 = D1D2[1];
	double       D1Leng = D1.length();
	JgclVector3D crsProd = D1.crossProduct(D2);
	double    curvature = crsProd.magnitude() / (D1Leng * D1Leng * D1Leng);
	JgclVector3D normal = crsProd.crossProduct(D1).unitized();
	return new JgclCurveCurvature3D(curvature, normal);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̃CԂB
     * 
     * @param	param	p[^l
     * @return		C
     */
    public double torsion(double param) {
	JgclVector3D[] D1D2D3 = evaluateD1D2D3(param);
	JgclVector3D       D1 = D1D2D3[0];
	JgclVector3D       D2 = D1D2D3[1];
	JgclVector3D       D3 = D1D2D3[2];
	double         D1Leng = D1.length();
	JgclVector3D  crsProd = D1.crossProduct(D2);
	double          leng3 = D1Leng * D1Leng * D1Leng;
	double      curvature = crsProd.magnitude() / leng3;
	return crsProd.dotProduct(D3) / (leng3 * leng3 * curvature * curvature);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̓֐ԂB
     *
     * @param	param	p[^l
     * @return		֐
     */
    public JgclCurveDerivative3D evaluation(double param) {
	JgclPoint3D      D0 = evaluateD0(param);
	JgclVector3D[] D1D2D3 = evaluateD1D2D3(param);
	return new JgclCurveDerivative3D(D0, D1D2D3[0], D1D2D3[1], D1D2D3[2]);
    }

    /**
     * ̋Ȑ̓ٓ_ԂB
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @return		ٓ_̔z
     * @see	JgclNotSupported
     */
    public JgclPointOnCurve3D[] singular() {
	throw new JgclNotSupported();
    }

    /**
     * ̋Ȑ̕ϋȓ_ԂB
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @return		ϋȓ_̔z
     * @see	JgclNotSupported
     */
    public JgclPointOnCurve3D[] inflexion() {
	throw new JgclNotSupported();
    }

    /**
     * ^ꂽ_炱̋Ȑւ̓e_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param point	e̓_
     * @return		e_̔z
     * @see	JgclNotSupported
     */
    public JgclPointOnCurve3D[] projectFrom(JgclPoint3D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋Ȑ̎w̋ԂA^ꂽ덷Œߎ|CԂB
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     *
     * @param section	ߎp[^
     * @param tolerance	̋e덷
     * @return		̋Ȑ̎w̋Ԃ𒼐ߎ|C
     * @see	JgclNotSupported
     */
    public JgclPolyline3D toPolyline(JgclParameterSection section,
				     JgclToleranceForDistance tolerance) {
	throw new JgclNotSupported();
    }

    /**
     * ̋Ȑ̎w̋ԂɍČL Bspline ȐԂB
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param section	L Bspline ȐōČp[^
     * @return		̋Ȑ̎w̋ԂČL Bspline Ȑ
     * @see	JgclNotSupported
     */
    public JgclBsplineCurve3D toBsplineCurve(JgclParameterSection section) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param	mate	̋Ȑ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param	mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (~) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param	mate	̋Ȑ (~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclCircle3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (ȉ~) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param	mate	̋Ȑ (ȉ~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclEllipse3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param	mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclParabola3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (oȐ) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param	mate	̋Ȑ (oȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclHyperbola3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (|C) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param	mate	̋Ȑ (|C)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclPolyline3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (xWGȐ) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param	mate	̋Ȑ (xWGȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (aXvCȐ) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param	mate	̋Ȑ (aXvCȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (gȐ) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param	mate	̋Ȑ (gȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclTrimmedCurve3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (ȐȐZOg) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param	mate	̋Ȑ (ȐȐZOg)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclCompositeCurveSegment3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȑ (ȐȐ) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param	mate	̋Ȑ (ȐȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclCompositeCurve3D mate, boolean doExchange) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȗʂ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȗ
     * @return		_̔z
     * @see	JgclNotSupported
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricSurface3D mate)
	throws JgclIndefiniteSolution 
    {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȗ (Ȗ) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȗ (Ȗ)
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclElementarySurface3D mate,
					       boolean doExchange)
	throws JgclIndefiniteSolution 
    {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȗ (xWGȖ) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȗ (xWGȖ)
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclPureBezierSurface3D mate,
					boolean doExchange)
	throws JgclIndefiniteSolution 
    {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋Ȗ (aXvCȖ) ̌_߂B
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȗ (aXvCȖ)
     * @return		_̔z
     * @see	JgclNotSupported
     */
    JgclIntersectionPoint3D[] intersect(JgclBsplineSurface3D mate,
					boolean doExchange)
	throws JgclIndefiniteSolution 
    {
	throw new JgclNotSupported();
    }

    /**
     * ^ꂽp[^Ԃɂ邱̋Ȑ̎ԏł̒ (̂) ԂB
     * 
     * @param pint	Ȑ̒߂p[^
     * @return	w肳ꂽp[^ԂɂȐ̒
     */
    public double length(JgclParameterSection pint) {
	// p[^̃`FbNKvH
	double dTol = getToleranceForDistance() / 2.0;
	return JgclMath.getDefiniteIntegral
	    (new JgclRealFunctionWithOneVariable() {
		public double evaluate(double parameter) {
		    return tangentVector(parameter).length();
		}
	    },
		pint, dTol);
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricCurve3D#POLYNOMIAL_CURVE_3D JgclParametricCurve3D.POLYNOMIAL_CURVE_3D}
     */
    int type() {
	return POLYNOMIAL_CURVE_3D;
    }

    /**
     * ̋ȐA^ꂽǏWn Z ̎ɁA
     * ^ꂽpx]ȐԂB
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     *
     * @param trns	ǏWn瓾ꂽWϊZq
     * @param rCos	cos(]px)
     * @param rSin	sin(]px)
     * @return		]̋Ȑ
     * @see	JgclNotSupported
     */
    JgclParametricCurve3D rotateZ(JgclCartesianTransformationOperator3D trns,
				  double rCos, double rSin) {
	throw new JgclNotSupported();
    }

    /**
     * ̋Ȑ̓_ŁA^ꂽɂȂ_ԂB
     * <p>
     * ܂̂ƂA̋@\̓T|[gĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     *
     * @param line	
     * @return		^ꂽɂȂ_
     * @see	JgclNotSupported
     */
    JgclPoint3D getPointNotOnLine(JgclLine3D line) {
	throw new JgclNotSupported();
    }

    /**
     * ̋Ȑ\Ă鑽zɓĕԂB
     *
     * @return    ̔z
     */
    private JgclRealPolynomial[] toPolynomialArray() {
	if (isIntegral()) {
	    JgclRealPolynomial[] polyArray = {polyX, polyY, polyZ};
	    return polyArray;
	}
	else {
	    JgclRealPolynomial[] polyArray = {polyX, polyY, polyZ, polyW};
	    return polyArray;			
	}
    } 

    /**
     * ̋Ȑ̈ꎟ֐Ɠ񎟓֐̊Oς\߂B
     *
     * @return    ꎟ֐Ɠ񎟓֐̊Oς\鑽
     */
    public JgclRealPolynomial[] crossProductD1D2() {
	JgclPolynomialCurve3D d1 = derivative();
	JgclPolynomialCurve3D d2 = d1.derivative();
	JgclRealPolynomial crossPoly1;
	JgclRealPolynomial crossPoly2;
	JgclRealPolynomial[] d1Poly;
	JgclRealPolynomial[] d2Poly;
	JgclRealPolynomial[] crossPoly;

	if (isIntegral()) {
	    d1Poly = d1.toPolynomialArray();
	    d2Poly = d2.toPolynomialArray();
	}
	else {
	    JgclRealPolynomial workPoly;
	    JgclRealPolynomial workPoly1;
	    JgclRealPolynomial workPoly2;
	    JgclRealPolynomial workPoly3;
	    JgclRealPolynomial workPoly4;;
	    JgclRealPolynomial[] d0WPoly = toPolynomialArray();			
	    JgclRealPolynomial[] d1WPoly = d1.toPolynomialArray();
	    JgclRealPolynomial[] d2WPoly = d2.toPolynomialArray();

	    d1Poly = new JgclRealPolynomial[3];
	    d2Poly = new JgclRealPolynomial[3];

	    for (int klm = 0; klm < 3; klm++) {
		workPoly1 = polyW.multiply(d1WPoly[klm]);
		workPoly2 = d1.polyW.multiply(d0WPoly[klm]);
		d1Poly[klm] = workPoly1.subtract(workPoly2);

		workPoly = polyW.multiply(polyW);
		workPoly1 = workPoly.multiply(d2WPoly[klm]);
		workPoly = d1.polyW.multiply(d0WPoly[klm]);
		workPoly2 = workPoly.multiply(d1WPoly[klm]);
		workPoly = d1.polyW.multiply(d1.polyW);
		workPoly3 = workPoly.multiply(d0WPoly[klm]);
		workPoly = d2.polyW.multiply(polyW);
		workPoly4 = workPoly.multiply(d0WPoly[klm]);

		workPoly = workPoly2.subtract(workPoly3).multiply(2.0);
		d2Poly[klm] = workPoly1.subtract(workPoly).subtract(workPoly4);
	    }
	}

	crossPoly = new JgclRealPolynomial[3];
	for (int ijk = 0; ijk < 3; ijk++) {
	    crossPoly1 = d1Poly[(ijk + 1) % 3].multiply
		(d2Poly[(ijk + 2) % 3]);
	    crossPoly2 = d1Poly[(ijk + 2) % 3].multiply
		(d2Poly[(ijk + 1) % 3]);
	    crossPoly[ijk] = crossPoly1.subtract(crossPoly2);
	}

	return crossPoly;
    }

    /**
     * ̋ȐA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricCurve3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	throw new JgclNotSupported();
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param	writer	o̓Xg[
     * @param	indent	Cfg̐[
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);
	StringBuffer buf = new StringBuffer();

        writer.println(indent_tab + getClassName());
	if (this.polyW == null) {
	    writer.print(indent_tab + "\tpolyX");
	    writer.print(" [" + this.polyX.coefficientAt(0));
	    for (int i = 1; i <= this.polyX.degree(); i++)
		writer.print(", " + this.polyX.coefficientAt(i));
	    writer.println("]");

	    writer.print(indent_tab + "\tpolyY");
	    writer.print(" [" + this.polyY.coefficientAt(0));
	    for (int i = 1; i <= this.polyY.degree(); i++)
		writer.print(", " + this.polyY.coefficientAt(i));
	    writer.println("]");

	    writer.print(indent_tab + "\tpolyZ");
	    writer.print(" [" + this.polyZ.coefficientAt(0));
	    for (int i = 1; i <= this.polyZ.degree(); i++)
		writer.print(", " + this.polyZ.coefficientAt(i));
	    writer.println("]");
	} else {
	    writer.print(indent_tab + "\tpolyWX");
	    writer.print(" [" + this.polyX.coefficientAt(0));
	    for (int i = 1; i <= this.polyX.degree(); i++)
		writer.print(", " + this.polyX.coefficientAt(i));
	    writer.println("]");

	    writer.print(indent_tab + "\tpolyWY");
	    writer.print(" [" + this.polyY.coefficientAt(0));
	    for (int i = 1; i <= this.polyY.degree(); i++)
		writer.print(", " + this.polyY.coefficientAt(i));
	    writer.println("]");

	    writer.print(indent_tab + "\tpolyWZ");
	    writer.print(" [" + this.polyZ.coefficientAt(0));
	    for (int i = 1; i <= this.polyZ.degree(); i++)
		writer.print(", " + this.polyZ.coefficientAt(i));
	    writer.println("]");

	    writer.print(indent_tab + "\tpolyW");
	    writer.print(" [" + this.polyW.coefficientAt(0));
	    for (int i = 1; i <= this.polyW.degree(); i++)
		writer.print(", " + this.polyW.coefficientAt(i));
	    writer.println("]");
	}
    }

    // Debug : integral
    /**
     * fobOp\bh 1
     */
    private static void test1(String argv[]) throws JgclInvalidArgumentValue {
	JgclPoint3D[] cntrlPoints = new JgclPoint3D[4];
	cntrlPoints[0] = new JgclCartesianPoint3D( 0.0,  0.0,  0.0);
	cntrlPoints[1] = new JgclCartesianPoint3D(10.0, 10.0,  1.0);
	cntrlPoints[2] = new JgclCartesianPoint3D(20.0, 10.0, -1.0);
	cntrlPoints[3] = new JgclCartesianPoint3D(30.0,  0.0,  0.0);
	JgclRealPolynomial[] polynomial =
	    (new JgclPureBezierCurve3D(cntrlPoints)).polynomial(true);
	JgclPolynomialCurve3D polynomialCurve =
	    new JgclPolynomialCurve3D(polynomial[0], polynomial[1],
				      polynomial[2]);

	for (int i = 0; i <= 100; i++) {
	    double param = 0.01 * i;
	    JgclPoint3D          crd = polynomialCurve.coordinates(param);
	    JgclVector3D         tng = polynomialCurve.tangentVector(param);
	    JgclCurveCurvature3D crv = polynomialCurve.curvature(param);
	    System.out.println(crd.x() + "\t" + crd.y() + "\t" + crd.z() + "\t" +
			       tng.x() + "\t" + tng.y() + "\t" + tng.z() + "\t" +
			       crv.curvature());
	}
    }

    // Debug : rational
    /**
     * fobOp\bh 2
     */
    private static void test2(String argv[]) throws JgclInvalidArgumentValue {
	JgclPoint3D[] cntrlPoints = new JgclPoint3D[4];
	cntrlPoints[0] = new JgclCartesianPoint3D( 0.0,  0.0,  0.0);
	cntrlPoints[1] = new JgclCartesianPoint3D(10.0, 10.0,  1.0);
	cntrlPoints[2] = new JgclCartesianPoint3D(20.0, 10.0, -1.0);
	cntrlPoints[3] = new JgclCartesianPoint3D(30.0,  0.0,  0.0);
	double[] weights = new double[4];
	weights[0] = 1.0;
	weights[1] = 1.0;
	weights[2] = 1.0;
	weights[3] = 1.0;
	JgclRealPolynomial[] polynomial =
	    (new JgclPureBezierCurve3D(cntrlPoints, weights)).polynomial(false);
	JgclPolynomialCurve3D polynomialCurve =
	    new JgclPolynomialCurve3D(polynomial[0], polynomial[1],
				      polynomial[2], polynomial[3]);

	for (int i = 0; i <= 100; i++) {
	    double param = 0.01 * i;
	    JgclPoint3D          crd = polynomialCurve.coordinates(param);
	    JgclVector3D         tng = polynomialCurve.tangentVector(param);
	    JgclCurveCurvature3D crv = polynomialCurve.curvature(param);
	    System.out.println(crd.x() + "\t" + crd.y() + "\t" + crd.z() + "\t" +
			       tng.x() + "\t" + tng.y() + "\t" + tng.z() + "\t" +
			       crv.curvature());
	}
    }

    // Debug
    /**
     * fobOpCvOB
     */
    public static void main(String argv[]) {
	try {
	    // test1(argv);
	    test2(argv);
	}
	catch (JgclInvalidArgumentValue e) {
	}
    }
}

/* end of file */
