/*
 * Q : |C\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclPolyline2D.java,v 1.83 2000/08/11 06:19:00 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Vector;
import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * Q : |C\NXB
 * <p>
 * |ĆAߓ_̗ points 
 * `ۂ\tO closed
 * Œ`B
 * </p>
 * <p>
 * closed ̒l true łΕ`ƂāAfalse łΊJ`ƂĈB
 * `̃|ĆA
 * ɍŏƍŌ̐ߓ_Ԑ̂ƂĈB
 * </p>
 * <p>
 * |C̃p[^`́A
 * אڂߓ_̊Ԃ̃p[^Ԃ̑傫 1 ƂāA
 * ȐSł [0, N] ƂȂB
 *  N ́A
 * |CJ`ł (ߓ_̐ - 1)A
 * `ł (ߓ_̐) ɂȂB
 * </p>
 * <p>
 * t p[^Ƃ|C P(t) ̃pgbN\́Aȉ̒ʂB
 * <pre>
 *	P(t) = (1 - (t - s)) * points[s] + (t - s) * points[s + 1]
 * </pre>
 *  s  t zȂő̐B
 * </p>
 *
 * @version $Revision: 1.83 $, $Date: 2000/08/11 06:19:00 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclPolyline2D extends JgclBoundedCurve2D {
    /**
     * ʑIɗאڂߓ_̊􉽓Iȓꐫ`FbN邩ǂtO
     * <p>
     * ܂̂Ƃ false (ꐫ`FbNȂ) ƂĂB
     * </p>
     */
    private static final boolean CHECK_SAME_POINTS = false;

    /**
     * p[^lɑΉZOgƋǏIȃp[^l\NX
     */
    private class PolyParam {
	/**
	 * ZOg̊Jn_
	 */
	JgclPoint2D sp;

	/**
	 * ZOg̏I_
	 */
	JgclPoint2D ep;

	/**
	 * ǏIȃp[^l
	 */
	double weight;

	/**
	 * (Kꂽ) Iȃp[^l
	 */
	double param;

	/**
	 * ZOg̔ԍ (0 x[X)
	 */
        int index;
    }

    /**
     * ߓ_̔zB
     * @serial
     */
    private JgclPoint2D[] points;

    /**
     * `ۂ\tOB
     * @serial
     */
    private boolean closed;

    /**
     * ̃CX^X̃tB[h̒lݒ肷B
     * <p>
     * closed  false ̏ꍇA
     * points ̗vf 2 菬
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * closed  true ̏ꍇA
     * points ̗vf 3 菬
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param points	ߓ_̔z
     * @param closed	Ă邩ۂ\tO
     * @see	JgclInvalidArgumentValue
     */
    private void setPoints(JgclPoint2D[] points, boolean closed) {
	if (!closed && points.length < 2 ||
	    closed && points.length < 3)
	    throw new JgclInvalidArgumentValue();

	this.closed = closed;
	this.points = new JgclPoint2D[points.length];

	this.points[0] = points[0];
	for (int i = 1; i < points.length; i++) {
	    if (CHECK_SAME_POINTS) {
		if (points[i].identical(points[i-1]))
		    throw new JgclInvalidArgumentValue();
	    }
	    this.points[i] = points[i];
	}
	if (CHECK_SAME_POINTS) {
	    if (closed && points[0].identical(points[points.length-1]))
		throw new JgclInvalidArgumentValue();
	}
    }

    /**
     * ߓ_ƕ`ۂ\tO^ăIuWFNg\zB
     * <p>
     * closed  false ̏ꍇA
     * points ̗vf 2 菬
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * closed  true ̏ꍇA
     * points ̗vf 3 菬
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param points	ߓ_̔z
     * @param closed	Ă邩ۂ\tO
     * @see	JgclInvalidArgumentValue
     */
    public JgclPolyline2D(JgclPoint2D[] points, boolean closed) {
	super();
	setPoints(points, closed);
    }

    /**
     * ߓ_^ĊJ`ƂăIuWFNg\zB
     * <p>
     * points ̗vf 2 菬
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param points	ߓ_̔z
     * @see	JgclInvalidArgumentValue
     */
    public JgclPolyline2D(JgclPoint2D[] points) {
	super();
	setPoints(points, false);
    }

    /**
     * ^ꂽLȐw̋e덷Œߎ̂ƂăIuWFNg\zB
     * 
     * @param curve	LȐ
     * @param tol	̋e덷
     * @see	JgclBoundedCurve2D#toPolyline(JgclToleranceForDistance)
     */
    public JgclPolyline2D(JgclBoundedCurve2D curve,
			  JgclToleranceForDistance tol) {
	super();
	JgclPolyline2D pl = curve.toPolyline(tol);
	this.points = pl.points;
	this.closed = pl.closed;
    }

    /**
     * ^ꂽȐ̎w̋Ԃw̋e덷Œߎ̂ƂăIuWFNg\zB
     * 
     * @param curve	Ȑ
     * @param pint	ߎp[^
     * @param tol	̋e덷
     * @see JgclParametricCurve2D#toPolyline(JgclParameterSection, JgclToleranceForDistance)
     */
    public JgclPolyline2D(JgclParametricCurve2D curve,
			  JgclParameterSection pint,
			  JgclToleranceForDistance tol)
    {
	super();
	JgclPolyline2D pl = curve.toPolyline(pint, tol);
	this.points = pl.points;
	this.closed = pl.closed;
    }

    /**
     * ̃|C̐ߓ_̔zԂB
     * 
     * @return	ߓ_̔z
     */
    public JgclPoint2D[] points() {
	JgclPoint2D[] pnts = new JgclPoint2D[points.length];

	for (int i = 0; i < points.length; i++)
	    pnts[i] = points[i];
	return pnts;
    }

    /**
     * ̃|C i Ԃ߂̐ߓ_ԂB
     * <p>
     * ̃|C`ŁAi ߓ_̐ɓꍇ́A0 Ԗڂ̐ߓ_ԂB
     * </p>
     *
     * @return	i Ԃ߂̐ߓ_
     */
    public JgclPoint2D pointAt(int i) {
	if (closed() && i == nPoints())
	    return points[0];

	return points[i];
    }

    /**
     * ̃|C`ł邩ۂԂB
     * 
     * @return	`ł trueAȂ false
     */
    public boolean closed() {
	return this.closed;
    }

    /**
     * ̃|C̐ߓ_̐ԂB
     * 
     * @return	ߓ_̐
     */
    public int nPoints() {
	return points.length;
    }

    /**
     * ̃|C̃ZOg̐ԂB
     * <p>
     * ̃|C`ł΁A
     * ZOg̐͐ߓ_̐ɓB
     * J`ł (ߓ_̐ - 1) ԂB
     * </p>
     *
     * @return	ZOg̐
     */
    public int nSegments() {
	if (closed())
	    return nPoints();

	return nPoints() - 1;
    }

    /**
     * ^ꂽp[^lɑΉZOgƋǏIȃp[^l̏ԂB
     * <p>
     * param ̒l i.0 ̏ꍇɂ i Ԗڂ̃ZOg̏ԂB
     * Ai ZOg̐ɓꍇɂ (i - 1) Ԗڂ̃ZOg̏ԂB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return	param ɑΉZOgƋǏIȃp[^l̏
     * @see	JgclParametricCurve#checkValidity(double)
     * @see	JgclParameterOutOfRange
     */
    private PolyParam checkParameter(double param)
    {
	PolyParam p = new PolyParam();

	int n = closed ? points.length : points.length-1;

	if (closed) {
	    param = parameterDomain().wrap(param);
	}
	else {
	    checkValidity(param);
	}

	int idx = (int)Math.floor(param);
	if (idx < 0)
	    idx = 0;
	if (n-1 < idx)
	    idx = n-1;

	p.sp = points[idx];
	if (idx+1 == points.length)
	    p.ep = points[0];	// only closed case
	else
	    p.ep = points[idx+1];

	p.weight = param - idx;
	p.param = param;
        p.index = idx;

	return p;
    }

    /**
     * ΏۂƂȂp[^ԂɊ܂܂ZOgɔCӂ̏{߂̒ۃNXB
     */
    private abstract class LineSegmentAccumulator {

	/**
	 * ^ꂽ_ɂāA炩̏sȂۃ\bhB
	 * <p>
	 * ̃\bh
	 * {@link #accumulate(JgclParameterSection) accumulate(JgclParameterSection)}
	 * ̒ŌĂяoB
	 * </p>
	 * <p>
	 * ^ꂽ_́A
	 * ɂZOg̒[_ł킯ł͂ȂA
	 * ZOg̒ԓ_ł邩ȂB
	 * </p>
	 *
	 * @param sp	Jn_
	 * @param ep	I_
	 * @param sParam	sp ɑΉp[^l
	 * @param eParam	ep ɑΉp[^l
	 */
	abstract void doit(JgclPoint2D sp, JgclPoint2D ep,
			   double sParam, double eParam);

	/**
	 * 炩̏n߂邽߂̏sȂۃ\bhB
	 * <p>
	 * ̃\bh
	 * {@link #accumulate(JgclParameterSection) accumulate(JgclParameterSection)}
	 * ̒
	 * {@link #doit(JgclPoint2D, JgclPoint2D, double, double)
	 * doit(JgclPoint2D, JgclPoint2D, double, double)}
	 * ĂяoOɌĂяoB
	 * </p>
	 */
	abstract void allocate(int nsegs);

	/**
	 * ^ꂽp[^ԂɊ܂܂ZOg 
	 * {@link #doit(JgclPoint2D, JgclPoint2D, double, double)
	 * doit(JgclPoint2D, JgclPoint2D, double, double)}
	 * ĂяoB
	 */
	void accumulate(JgclParameterSection pint)
	{
	    PolyParam sPolyParam = checkParameter(pint.start());
	    PolyParam ePolyParam = checkParameter(pint.end());
	    JgclPoint2D sPoint;
	    JgclPoint2D ePoint;
	    JgclParameterDomain domain = parameterDomain();
	    boolean wrapAround;

	    if (domain.isPeriodic())
		wrapAround = (sPolyParam.param > ePolyParam.param);
	    else
		wrapAround = false;

	    if (wrapAround) {
		allocate(nPoints() - sPolyParam.index + ePolyParam.index);

		sPoint = coordinates(sPolyParam.param);
		ePoint = sPolyParam.ep;
		doit(sPoint, ePoint,
		     sPolyParam.param, (double)sPolyParam.index+1);
	    
		for (int seg = sPolyParam.index + 1; seg < nPoints(); seg++) {
		    int wrappedSeg1 = (seg + 1) % nPoints();
		    doit(points[seg], points[wrappedSeg1],
			 (double)seg, (double)(seg+1));
		}

		for (int seg = 0; seg < ePolyParam.index; seg++) {
		    int wrappedSeg1 = (seg + 1) % nPoints();
		    doit(points[seg], points[wrappedSeg1],
			 (double)seg, (double)(seg+1));
		}

		sPoint = ePolyParam.sp;
		ePoint = coordinates(ePolyParam.param);
		doit(sPoint, ePoint,
		     (double)ePolyParam.index, ePolyParam.param);
	    }
	    else if (sPolyParam.index == ePolyParam.index) {
		allocate(1);

		sPoint = coordinates(sPolyParam.param);
		ePoint = coordinates(ePolyParam.param);
		doit(sPoint, ePoint, sPolyParam.param, ePolyParam.param);
	    }
	    else {
		allocate(ePolyParam.index - sPolyParam.index + 1);

		sPoint = coordinates(sPolyParam.param);
		ePoint = sPolyParam.ep;
		doit(sPoint, ePoint,
		     sPolyParam.param, (double)sPolyParam.index+1);

		for (int seg = sPolyParam.index + 1;
		     seg < ePolyParam.index; seg++)
		    doit(points[seg], points[seg + 1],
			 (double)seg, (double)(seg+1));

		sPoint = ePolyParam.sp;
		ePoint = coordinates(ePolyParam.param);
		doit(sPoint, ePoint,
		     (double)ePolyParam.index, ePolyParam.param);
	    }
	}
    }

    /**
     * {@link #length(JgclParameterSection) length(JgclParameterSection)}
     * 邽߂ LineSegmentAccumulator ̎B
     */
    private class LengthAccumulator extends LineSegmentAccumulator {
	/**
	 * Ȑ̎w̋Ԃ̒B
	 */
	double leng;

	/**
	 * leng  0 ɏB
	 *
	 * @param nsegs	ΏۂƂȂZOg̐
	 */
	void allocate(int nsegs) {
	    leng = 0.0;
	}

	/**
	 * ^ꂽ_Ԃ̋ leng ɑB
	 *
	 * @param sp	Jn_
	 * @param ep	I_
	 * @param sParam	sp ɑΉp[^l
	 * @param eParam	ep ɑΉp[^l
	 */
	void doit(JgclPoint2D sp, JgclPoint2D ep,
		  double sParam, double eParam) {
	    leng += sp.distance(ep);
	}

	/**
	 * Ȑ̎w̋Ԃ̒ԂB
	 *
	 * @param leng ̒l
	 */
	double extract() {
	    return leng;
	}
    }

    /**
     * ^ꂽp[^Ԃɂ邱̋Ȑ̎ԏł̒ (̂) ԂB
     * <p>
     * pint ̑l͕ł܂ȂB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param pint	Ȑ̒߂p[^
     * @return	w肳ꂽp[^ԂɂȐ̒
     * @see	JgclParameterOutOfRange
     */
    public double length(JgclParameterSection pint)
    {
	if (pint.increase() < 0.0) {
	    return length(pint.reverse());
	}

	LengthAccumulator acc = new LengthAccumulator();

	acc.accumulate(pint);
	return acc.extract();
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̍WlԂB
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		Wl
     * @see	JgclParametricCurve#checkValidity(double)
     * @see	JgclParameterOutOfRange
     */
    public JgclPoint2D coordinates(double param)
    {
	PolyParam p = checkParameter(param);
	return p.ep.linearInterpolate(p.sp, p.weight);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̐ڃxNgԂB
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		ڃxNg
     * @see	JgclParametricCurve#checkValidity(double)
     * @see	JgclParameterOutOfRange
     */
    public JgclVector2D tangentVector(double param) 
    {
	PolyParam p = checkParameter(param);
	return p.ep.subtract(p.sp);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̋ȗԂB
     * <p>
     * |C̋ȗ́A 0 łB
     * </p>
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		ȗ
     * @see	JgclParametricCurve#checkValidity(double)
     * @see	JgclParameterOutOfRange
     */
    public JgclCurveCurvature2D curvature(double param)
    {
	checkParameter(param);
	return new JgclCurveCurvature2D(0.0, JgclVector2D.zeroVector());
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̓֐ԂB
     * <p>
     * ^ꂽp[^Ԃ`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param param	p[^l
     * @return		֐
     * @see	JgclParametricCurve#checkValidity(double)
     * @see	JgclParameterOutOfRange
     */
    public JgclCurveDerivative2D evaluation(double param)
    {
	return new JgclCurveDerivative2D(coordinates(param),
					 tangentVector(param),
					 JgclVector2D.zeroVector());
    }

    /**
     * {@link #singular() singular()}
     * 邽߂ LineSegmentAccumulator ̎B
     */
    private class SingularAccumulator extends LineSegmentAccumulator {
        private JgclParametricCurve2D curve;
        private Vector singularVec;
        private JgclVector2D prevTangVec;

        SingularAccumulator(JgclParametricCurve2D curve) {
            this.curve = curve;
        }

        void allocate(int nsegs) {
            singularVec = new Vector();
            prevTangVec = null;
        }

        void doit(JgclPoint2D sp, JgclPoint2D ep,
                  double sParam, double eParam) {
            JgclVector2D tangVec = ep.subtract(sp);
            if (prevTangVec != null) {
                if (!tangVec.identicalDirection(prevTangVec)) {
                    JgclPointOnCurve2D candidate =
                        new JgclPointOnCurve2D(curve, sParam, doCheckDebug);
                    singularVec.addElement(candidate);
                }
            }
            prevTangVec = tangVec;
        }

        JgclPointOnCurve2D[] extract() {
            JgclPointOnCurve2D[] singular =
                new JgclPointOnCurve2D[singularVec.size()];
            singularVec.copyInto(singular);
            return singular;
        }
    }

    /**
     * ̋Ȑ̓ٓ_ԂB
     * <p>
     * ٓ_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @return		ٓ_̔z
     */
     public JgclPointOnCurve2D[] singular() {
         SingularAccumulator acc = new SingularAccumulator(this);
         acc.accumulate(parameterDomain().section());

         return acc.extract();
     }

    /**
     * ̋Ȑ̕ϋȓ_ԂB
     * <p>
     * |Cɂ͕ϋȓ_݂͑Ȃ̂ƂāA 0 ̔zԂB
     * </p>
     * 
     * @return	ϋȓ_̔z
     */
     public JgclPointOnCurve2D[] inflexion() {
         return new JgclPointOnCurve2D[0];
     }

    /**
     * {@link #projectFrom(JgclPoint2D) projectFrom(JgclPoint2D)}
     * 邽߂ LineSegmentAccumulator ̎B
     */
    private class ProjectionAccumulator extends LineSegmentAccumulator {
	JgclPointOnGeometryList projList;
	JgclPoint2D point;
	double dTol;
	JgclPolyline2D curv;

	ProjectionAccumulator(JgclPolyline2D curv, JgclPoint2D point,
			      double dTol) {
	    this.point = point;
	    this.dTol = dTol;
	    this.curv = curv;
	}

	void allocate(int nsegs) {
	    projList = new JgclPointOnGeometryList();
	}

	void doit(JgclPoint2D sp, JgclPoint2D ep,
		  double sParam, double eParam) {
	    JgclLine2D line;
	    try {
		line = new JgclLine2D(sp, ep);
	    } catch (JgclInvalidArgumentValue e) {	// segment is reduced
		return;
	    }
	    JgclPointOnCurve2D proj = line.project1From(point);
	    double length = line.dir().length();
	    double param = proj.parameter();
	    double fromSp = param * length;

	    if (-dTol <= fromSp && fromSp <= length+dTol) {
		// parameter on Polyline
		if (param < 0.0) param = 0.0;
		else if (param > 1.0) param = 1.0;
		double p2 = sParam + (eParam - sParam) * param;
		projList.addPoint(curv, p2);
	    }
	}

	JgclPointOnCurve2D[] extract() {
	    return projList.toJgclPointOnCurve2DArray();
	}
    }

    /**
     * ^ꂽ_炱̋Ȑւ̓e_߂B
     * <p>
     * e_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param point	e̓_
     * @return	e_
     */
    public JgclPointOnCurve2D[] projectFrom(JgclPoint2D point) {
	double dTol = getToleranceForDistance();

	ProjectionAccumulator acc =
	    new ProjectionAccumulator(this, point, dTol);

	try {
	    acc.accumulate(parameterDomain().section());
	}
	catch(JgclParameterOutOfRange e) {
	    throw new JgclFatal();
	}
	return acc.extract();
    }

    /**
     * {@link #toPolyline(JgclParameterSection, JgclToleranceForDistance)
     * toPolyline(JgclParameterSection, JgclToleranceForDistance)}
     * 邽߂ LineSegmentAccumulator ̎B
     */
    private class ToPolylineAccumulator extends LineSegmentAccumulator {
	Vector pntVec;
	JgclPoint2D lastPoint;
	JgclPolyline2D curv;

	ToPolylineAccumulator(JgclPolyline2D curv) {
	    this.curv = curv;
	}

	void allocate(int nsegs) {
	    pntVec = new Vector();
	    lastPoint = null;
	}

	void doit(JgclPoint2D sp, JgclPoint2D ep,
		  double sParam, double eParam) {
	    if (lastPoint == null) {
		lastPoint = new JgclPointOnCurve2D(curv, sParam, doCheckDebug);
		pntVec.addElement(lastPoint);
	    }

	    JgclPoint2D newPoint = new JgclPointOnCurve2D(curv, eParam, doCheckDebug);
	    if (!newPoint.identical(lastPoint)) {
		pntVec.addElement(newPoint);
		lastPoint = newPoint;
	    }
	}

	JgclPolyline2D extract() {
	    int nPnts = pntVec.size();
	    if (nPnts < 2)
		throw new JgclZeroLength();

	    JgclPoint2D[] pntsArray = new JgclPoint2D[nPnts];
	    pntVec.copyInto(pntsArray);
	    return new JgclPolyline2D(pntsArray);
	}
    }

    /**
     * ̋Ȑ̎w̋ԂA^ꂽ덷Œߎ|CԂB
     * <p>
     * ʂƂĕԂ|C\_
     * ̋Ȑx[XƂ JgclPointOnCurve2D 
     * 邱Ƃ҂łB
     * </p>
     * 
     * @param pint	ߎp[^
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ𒼐ߎ|C
     */
    public JgclPolyline2D toPolyline(JgclParameterSection pint,
				     JgclToleranceForDistance tol) 
    {
	if (pint.increase() < 0.0) {
	    return toPolyline(pint.reverse(), tol).reverse();
	}

	ToPolylineAccumulator acc = new ToPolylineAccumulator(this);

	acc.accumulate(pint);
	return acc.extract();
    }

    /**
     * ̗LȐŜɍČL Bspline ȐԂB
     * 
     * @return	̋ȐŜČL Bspline Ȑ
     */
    public JgclBsplineCurve2D toBsplineCurve() {
	int degree = 1;
	boolean periodic = this.closed();
	int uicp = this.nPoints();
	int uik = (periodic == false) ? uicp : (uicp + 2);
	int[] knotMultiplicities = new int[uik];
	double[] knots = new double[uik];
	JgclPoint2D[] controlPoints = new JgclPoint2D[uicp];
	double[] weights = new double[uicp];

	int ik = (periodic == false) ? 0 : 1;
	if (periodic == false) {
	    ik = 0;
	} else {
	    ik = 1;
	    knots[0]       = (- 1.0);
	    knots[uik - 1] = uicp + 1;
	    knotMultiplicities[0]       = 1;
	    knotMultiplicities[uik - 1] = 1;
	}
	for (int i = 0; i < uicp; i++, ik++) {
	    knots[ik] = i;
	    if ((periodic == false) &&
		((i == 0) || (i == (this.nPoints() - 1))))
		knotMultiplicities[ik] = 2;
	    else
		knotMultiplicities[ik] = 1;

	    controlPoints[i] = this.pointAt(i);
	    weights[i] = 1.0;
	}

	return new JgclBsplineCurve2D(degree, periodic,
				      knotMultiplicities, knots,
				      controlPoints,
				      weights);
    }

    /**
     * ̋Ȑ̎w̋ԂɍČL Bspline ȐԂB
     * 
     * @param pint	L Bspline ȐōČp[^
     * @return		̋Ȑ̎w̋ԂČL Bspline Ȑ
     */
    public JgclBsplineCurve2D toBsplineCurve(JgclParameterSection pint) {
	JgclPolyline2D target;
	if (this.closed() == true) {
	    if (pint.absIncrease() >= this.parameterDomain().section().absIncrease()) {
		target = this;
		if (pint.increase() < 0.0)
		    target = target.reverse();
	    } else {
		target = this.toPolyline(pint, this.getToleranceForDistanceAsObject());
	    }
	} else {
	    target = this.toPolyline(pint, this.getToleranceForDistanceAsObject());
	}
	return target.toBsplineCurve();
    }

    /**
     * ̋ȐƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		_̔z
     */
    public JgclIntersectionPoint2D[] intersect(JgclParametricCurve2D mate) {
	return mate.intersect(this, true);
    }

    /**
     * ̃|C̎w̃ZOg̒߂B
     *
     * @param nseg	ZOg̐
     * @param segIdx	߂ZOg̔ԍ (0 x[X)
     * @return	w̃ZOg̒
     */
    private double segLength(int nseg, int segIdx) {
	int head_pnt_idx;
	int tail_pnt_idx;

	if (closed()) {
	    while (segIdx < 0)
		segIdx += nseg;
	    while (segIdx > (nseg - 1))
		segIdx -= nseg;
	}

	head_pnt_idx = segIdx;

	if (closed() && (head_pnt_idx == nSegments())) {
	    tail_pnt_idx = 0;
	} else {
	    tail_pnt_idx = head_pnt_idx + 1;
	}

	return points[head_pnt_idx].distance(points[tail_pnt_idx]);
    }

    /**
     * ̋ȐƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * <ul>
     * <li>	eZOgɂāA[_ʂ钼lA̒Ƒ̋ȐƂ̌_߂B
     * <li>	̏ŋ߂_̓ŁAΉZOg̓ɂ̂u_vƂB
     * </ul>
     * </p>
     * 
     * @param mate	̋Ȑ
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    private JgclIntersectionPoint2D[] doIntersect(JgclParametricCurve2D mate, boolean doExchange) {
  	int nSeg = nSegments();
	JgclCurveCurveInterferenceList intf =
	    new JgclCurveCurveInterferenceList(this, mate);

	for (int i = 0; i < nSeg; i++) {
	    JgclLine2D realSegment;
	    JgclBoundedLine2D segment;
	    try {
		realSegment = new JgclLine2D(pointAt(i), pointAt(i+1));
		segment = new JgclBoundedLine2D(pointAt(i), pointAt(i+1));
	    } catch (JgclInvalidArgumentValue e) {	// segment is reduced
		continue;
	    }

	    JgclIntersectionPoint2D[] segIntersect;
	    try {
		segIntersect = realSegment.intersect(mate);
	    } catch (JgclIndefiniteSolution e) {
		// ZOg̒_ǉĂ
    		segIntersect = new JgclIntersectionPoint2D[1];
    		JgclPoint2D segmentMidPoint = realSegment.coordinates(0.5);
  		double paramOnMate = mate.pointToParameter(segmentMidPoint);
    		segIntersect[0] =
    		    new JgclIntersectionPoint2D(realSegment, 0.5,
    						mate, paramOnMate, doCheckDebug);
	    }
	    if ((segIntersect == null) || (segIntersect.length == 0))
		continue;

	    int segResolution = segIntersect.length;
	    for (int j = 0; j < segResolution; j++) {
		JgclPoint2D point = segIntersect[j].coordinates();
		double segParam = segIntersect[j].pointOnCurve1().parameter();
		int validity = segment.parameterValidity(segParam);

		switch (validity) {
		case JgclParameterValidity.OUTSIDE:
		    continue;
		case JgclParameterValidity.TOLERATED_LOWER_LIMIT:
		    if (segParam < 0.0) {
			if ((!closed()) && (i == 0)) {
  			    segParam = 0.0;
			}
			else {
			    segParam = segLength(nSeg, i) * segParam / segLength(nSeg, (i - 1));
			}
		    }
		    break;
		case JgclParameterValidity.TOLERATED_UPPER_LIMIT:
		    if (segParam > 1.0) {
			if ((!closed()) && (i == (nSeg - 1))) {
 			    segParam = 1.0;
			}
			else {
			    segParam = 1.0 + (segLength(nSeg, i) * (segParam - 1.0)) / segLength(nSeg, (i + 1));
			}
		    }
		    break;
		default: // JgclParameterValidity.PROPERLY_INSIDE
		    break;
		}
		intf.addAsIntersection(point, segParam + i,
				  segIntersect[j].pointOnCurve2().parameter());
	    }
	}

	return intf.toJgclIntersectionPoint2DArray(doExchange);
    }

    /**
     * ̃|CƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * this.{@link #doIntersect(JgclParametricCurve2D, boolean)
     * doIntersect}(mate, doExchange) ĂłB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclLine2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̃|CƑ̋Ȑ (~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * this.{@link #doIntersect(JgclParametricCurve2D, boolean)
     * doIntersect}(mate, doExchange) ĂłB
     * </p>
     * 
     * @param mate	̋Ȑ (~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclCircle2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̃|CƑ̋Ȑ (ȉ~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * this.{@link #doIntersect(JgclParametricCurve2D, boolean)
     * doIntersect}(mate, doExchange) ĂłB
     * </p>
     * 
     * @param mate	̋Ȑ (ȉ~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclEllipse2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̃|CƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * this.{@link #doIntersect(JgclParametricCurve2D, boolean)
     * doIntersect}(mate, doExchange) ĂłB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclParabola2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̃|CƑ̋Ȑ (oȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * this.{@link #doIntersect(JgclParametricCurve2D, boolean)
     * doIntersect}(mate, doExchange) ĂłB
     * </p>
     * 
     * @param mate	̋Ȑ (oȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclHyperbola2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̃|CƑ̋Ȑ (|C) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsPolPol2D#intersection(JgclPolyline2D, JgclPolyline2D, boolean)
     * JgclIntsPolPol2D.intersection}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (|C)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclPolyline2D mate, boolean doExchange) {
	return JgclIntsPolPol2D.intersection(this, mate, doExchange);
    }

    /**
     * ̃|CƑ̋Ȑ (xWGȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * this.{@link #doIntersect(JgclParametricCurve2D, boolean)
     * doIntersect}(mate, doExchange) ĂłB
     * </p>
     * 
     * @param mate	̋Ȑ (xWGȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclPureBezierCurve2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̃|CƑ̋Ȑ (aXvCȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * this.{@link #doIntersect(JgclParametricCurve2D, boolean)
     * doIntersect}(mate, doExchange) ĂłB
     * </p>
     * 
     * @param mate	̋Ȑ (aXvCȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclBsplineCurve2D mate, boolean doExchange) {
	return doIntersect(mate, doExchange);
    }

    /**
     * ̃|CƑ̋Ȑ (gȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * gȐ̃NX́ugȐ vs. |Cv̌_Z\bh
     * {@link JgclTrimmedCurve2D#intersect(JgclPolyline2D, boolean)
     * JgclTrimmedCurve2D.intersect(JgclPolyline2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (gȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclTrimmedCurve2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̃|CƑ̋Ȑ (ȐZOg) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȐZOg̃NX́uȐZOg vs. |Cv̌_Z\bh
     * {@link JgclCompositeCurveSegment2D#intersect(JgclPolyline2D, boolean)
     * JgclCompositeCurveSegment2D.intersect(JgclPolyline2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȐZOg)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclCompositeCurveSegment2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̃|CƑ̋Ȑ (Ȑ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * Ȑ̃NX́uȐ vs. |Cv̌_Z\bh
     * {@link JgclCompositeCurve2D#intersect(JgclPolyline2D, boolean)
     * JgclCompositeCurve2D.intersect(JgclPolyline2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (Ȑ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return	_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclCompositeCurve2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LEȐ̊߂B
     * <p>
     * ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		Ȑ̊̔z
     */
    public JgclCurveCurveInterference2D[] interfere(JgclBoundedCurve2D mate) {
	return mate.interfere(this, true);
    }

    /**
     * ̗LȐƑ̗LȐ () ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ̃NX́u vs. |Cv̊Z\bh
     * {@link JgclBoundedLine2D#interfere(JgclPolyline2D, boolean)
     * JgclBoundedLine2D.interfere(JgclPolyline2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̗LȐ ()
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference2D[] interfere(JgclBoundedLine2D mate,
					     boolean doExchange)
    {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (|C) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsPolPol2D#interference(JgclPolyline2D, JgclPolyline2D)
     * JgclIntsPolPol2D.interference}(this, mate)
     * 
     * JgclIntsPolPol2D.interference(mate, this)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (|C)
     * @param doExchange	ڐG this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference2D[] interfere(JgclPolyline2D mate,
					     boolean doExchange)
    {
	if (!doExchange) {
	    return JgclIntsPolPol2D.interference(this, mate);
	} else {
	    return JgclIntsPolPol2D.interference(mate, this);
	}
    }

    /**
     * ^ꂽ̑ΏۂƂȂȐ̃|CɕύXB
     *
     * @param sourceInterferences	̔z
     * @param doExchange	ڐG this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    private JgclCurveCurveInterference2D[]
    convertInterferences(JgclCurveCurveInterference2D[] sourceInterferences,
			 boolean doExchange)
    {
	Vector resultVector = new Vector();

	for (int i = 0; i < sourceInterferences.length; i++) {
	    JgclCurveCurveInterference2D intf;
	    if (!doExchange)
		intf = sourceInterferences[i].changeCurve1(this);
	    else
		intf = sourceInterferences[i].changeCurve2(this);
	    if (intf != null)
		resultVector.addElement(intf);
	}

	JgclCurveCurveInterference2D[] result =
	    new JgclCurveCurveInterference2D[resultVector.size()];
	resultVector.copyInto(result);
	return result;
    }

    /**
     * ̗LȐƑ̗LȐ (xWGȐ) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̃|CLaXvCȐɕϊA
     * aXvCȐ̃NX́uaXvCȐ vs. xWGȐv̊Z\bh
     * {@link JgclBsplineCurve2D#interfere(JgclPureBezierCurve2D, boolean)
     * JgclBsplineCurve2D.interfere(JgclPureBezierCurve2D, boolean)}
     * ĂяoĂB
     * </p>
     * 
     * @param mate	̗LȐ (xWGȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference2D[] interfere(JgclPureBezierCurve2D mate,
					     boolean doExchange) {
	return this.convertInterferences(this.toBsplineCurve().interfere(mate, doExchange),
					 doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (aXvCȐ) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̃|CLaXvCȐɕϊA
     * aXvCȐ̃NX́uaXvCȐ vs. aXvCȐv̊Z\bh
     * {@link JgclBsplineCurve2D#interfere(JgclBsplineCurve2D, boolean)
     * JgclBsplineCurve2D.interfere(JgclBsplineCurve2D, boolean)}
     * ĂяoĂB
     * </p>
     * 
     * @param mate	̗LȐ (aXvCȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference2D[] interfere(JgclBsplineCurve2D mate,
					     boolean doExchange) {
	return this.convertInterferences(this.toBsplineCurve().interfere(mate, doExchange),
					 doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (gȐ) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * gȐ̃NX́ugȐ vs. |Cv̊Z\bh
     * {@link JgclTrimmedCurve2D#interfere(JgclPolyline2D, boolean)
     * JgclTrimmedCurve2D.interfere(JgclPolyline2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̗LȐ (gȐ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference2D[] interfere(JgclTrimmedCurve2D mate,
					     boolean doExchange) {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (ȐZOg) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȐZOg̃NX́uȐZOg vs. |Cv̊Z\bh
     * {@link JgclCompositeCurveSegment2D#interfere(JgclPolyline2D, boolean)
     * JgclCompositeCurveSegment2D.interfere(JgclPolyline2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̗LȐ (ȐZOg)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference2D[] interfere(JgclCompositeCurveSegment2D mate,
					     boolean doExchange) {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̗LȐƑ̗LȐ (Ȑ) ̊߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * Ȑ̃NX́uȐ vs. |Cv̊Z\bh
     * {@link JgclCompositeCurve2D#interfere(JgclPolyline2D, boolean)
     * JgclCompositeCurve2D.interfere(JgclPolyline2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̗LȐ (Ȑ)
     * @param doExchange	 this  mate ̈ʒu邩ǂ
     * @return		Ȑ̊̔z
     */
    JgclCurveCurveInterference2D[] interfere(JgclCompositeCurve2D mate,
					     boolean doExchange) {
	return mate.interfere(this, !doExchange);
    }

    /**
     * ̃|C̎Ȍ_߂B
     * <p>
     * Ȍ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     *
     * @return	Ȍ_̔z
     */
    public JgclIntersectionPoint2D[] selfIntersect() {
	return JgclSelfIntsPol2D.intersection(this);
    }

    /**
     * ̃|C̎Ȋ߂B
     * <p>
     * Ȋ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     *
     * @return		Ȋ̔z
     */
    public JgclCurveCurveInterference2D[] selfInterfere() {
	return JgclSelfIntsPol2D.interference(this);
    }

    /**
     * ̋Ȑ̎w̋ԂItZbgȐA
     * ^ꂽ덷ŋߎ镡Ȑ߂B
     * <p>
     * ʂƂē镡Ȑ͂̃|C̃ItZbgȐɌɍČB
     * āÃ\bh̓ł tol ̒l͎QƂȂB
     * </p>
     * 
     * @param pint	ItZbgp[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.LEFT/RIGHT)
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ̃ItZbgȐߎ镡Ȑ
     * @see	JgclWhichSide
     */
    public JgclCompositeCurve2D
    offsetByCompositeCurve(JgclParameterSection pint,
			   double magni,
			   int side,
			   JgclToleranceForDistance tol)
    {
	boolean offsettedIsPeriodic = false;
	if (this.isPeriodic() == true) {
	    if ((this.parameterDomain().section().absIncrease() - pint.absIncrease()) <
		this.getToleranceForParameter())
		offsettedIsPeriodic = true;
	}

	JgclBoundedLine2D[] boundedLines = this.toBoundedLines(pint);
	int nBoundedLines = boundedLines.length;

	JgclCompositeCurveSegment2D[] offsetted =
	    new JgclCompositeCurveSegment2D[2 * nBoundedLines];

	JgclBoundedLine2D prevOffsettedCurve = null;
	JgclBoundedLine2D crntOffsettedCurve = null;
	JgclBoundedLine2D firstOffsettedCurve = null;

	int transition;

	for (int i = 0; i <= nBoundedLines; i++) {
	    /*
	     * offset the curve
	     */
	    if (i == nBoundedLines) {
		crntOffsettedCurve = firstOffsettedCurve;
	    } else {
		crntOffsettedCurve = (JgclBoundedLine2D)
		    boundedLines[i].offsetByBoundedCurve(magni, side, tol);
		if (i == 0)
		    firstOffsettedCurve = crntOffsettedCurve;

		transition = JgclTransitionCode.CONTINUOUS;
		if ((offsettedIsPeriodic == false) && (i == (nBoundedLines - 1)))
		    transition = JgclTransitionCode.DISCONTINUOUS;

		offsetted[2 * i] =
		    new JgclCompositeCurveSegment2D(transition, true,
						    crntOffsettedCurve);
	    }

	    /*
	     * offset the corner
	     */
	    if (i == 0) {
		// start point at first offsetted segment
		; // do nothing
	    } else if ((i == nBoundedLines) && (offsettedIsPeriodic == false)) {
		// start point at first offsetted segment, but offsetted is open
		offsetted[2 * i - 1] = null;
	    } else if (prevOffsettedCurve.epnt().identical(crntOffsettedCurve.spnt()) == true) {
		// end point at prev. and start point at crnt. are identical
		offsetted[2 * i - 1] = null;
	    } else {
		JgclPoint2D center = (i < nBoundedLines)
		    ? boundedLines[i].spnt() : boundedLines[0].spnt();
		JgclTrimmedCurve2D offsettedCorner =
		    JgclCircle2D.makeTrimmedCurve(center,
						  prevOffsettedCurve.epnt(),
						  crntOffsettedCurve.spnt());
		transition = JgclTransitionCode.CONTINUOUS;

		offsetted[2 * i - 1] =
		    new JgclCompositeCurveSegment2D(transition, true,
						    offsettedCorner);
	    }

	    prevOffsettedCurve = crntOffsettedCurve;
	}

	Vector listOfOffsetted = new Vector();
	for (int i = 0; i < (2 * nBoundedLines); i++)
	    if (offsetted[i] != null)
		listOfOffsetted.addElement(offsetted[i]);

	offsetted = new JgclCompositeCurveSegment2D[listOfOffsetted.size()];
	listOfOffsetted.copyInto(offsetted);

	return new JgclCompositeCurve2D(offsetted, offsettedIsPeriodic);
    }

    /**
     * ̋Ȑ̎w̋ԂItZbgȐA
     * ^ꂽ덷ŋߎ Bspline Ȑ߂B
     * <p>
     * ʂƂē Bspline Ȑ͂̃|C̃ItZbgȐɌɍČB
     * āÃ\bh̓ł tol ̒l͎QƂȂB
     * </p>
     * 
     * @param pint	ItZbgp[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.LEFT/RIGHT)
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ̃ItZbgȐߎ Bspline Ȑ
     * @see	JgclWhichSide
     */
    public JgclBsplineCurve2D
	offsetByBsplineCurve(JgclParameterSection pint,
			     double magni,
                             int side,
                             JgclToleranceForDistance tol)
    {
	JgclCompositeCurve2D cmc =
	    this.offsetByCompositeCurve(pint, magni, side, tol);

	return cmc.toBsplineCurve();
    }

    /**
     * ̋Ȑ̎w̋ԂItZbgȐA
     * ^ꂽ덷ŋߎLȐ߂B
     * <p>
     * ʂƂēLȐ͂̃|C̃ItZbgȐɌɍČB
     * āÃ\bh̓ł tol ̒l͎QƂȂB
     * </p>
     * 
     * @param pint	ItZbgp[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.LEFT/RIGHT)
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ̃ItZbgȐߎLȐ
     * @see	JgclWhichSide
     */
    public JgclBoundedCurve2D
        offsetByBoundedCurve(JgclParameterSection pint,
			     double magni,
                             int side,
                             JgclToleranceForDistance tol)
    {
	return this.offsetByCompositeCurve(pint, magni, side, tol);
    }

    /**
     * {@link #doFillet(JgclParameterSection, int, JgclParametricCurve2D, JgclParameterSection, int, double, boolean)
     * doFillet(JgclParameterSection, int, JgclParametricCurve2D, JgclParameterSection, int, double, boolean)}
     * 邽߂ LineSegmentAccumulator ̎B
     */
    private class FilletAccumulator extends LineSegmentAccumulator {
	JgclParametricCurve2D mate;
	JgclPolyline2D curve;
	JgclParameterSection mateSec;
	int mateSide;
	int mySide;
	double radius;
	boolean doExchange;
	JgclFilletObjectList fltList;
	JgclParameterSection sec;	// staic value

	FilletAccumulator(JgclParametricCurve2D mate,
			  JgclParameterSection mateSec,
			  int mateSide,
			  JgclPolyline2D curve,
			  int mySide,
			  double radius,
			  boolean doExchange) {
	    this.curve = curve;
	    this.mate = mate;
	    this.mateSec = mateSec;
	    this.mateSide = mateSide;
	    this.mySide = mySide;
	    this.radius = radius;
	    this.doExchange = doExchange;
	    sec = new JgclParameterSection(0.0, 1.0);
	}

	void allocate(int nsegs) {
	    fltList = new JgclFilletObjectList();
	}

	void doit(JgclPoint2D sp, JgclPoint2D ep,
		  double sParam, double eParam) {
	    JgclBoundedLine2D blin = new JgclBoundedLine2D(sp, ep);
	    JgclFilletObject2D[] flts;
	    try {
		flts = blin.doFillet(sec, mySide, mate, mateSec, mateSide, radius, false);
	    } catch (JgclIndefiniteSolution e) {
		flts = new JgclFilletObject2D[1];
		flts[0] = (JgclFilletObject2D)e.suitable();
	    }
	    JgclFilletObject2D thisFlt;

	    for (int i = 0; i < flts.length; i++) {
		double param = sParam + (eParam - sParam) * flts[i].pointOnCurve1().parameter();

		JgclPointOnCurve2D thisPnt = new JgclPointOnCurve2D(curve, param, doCheckDebug);
		if (!doExchange)
		    thisFlt = new JgclFilletObject2D(radius, flts[i].center(), thisPnt, flts[i].pointOnCurve2());
		else
		    thisFlt = new JgclFilletObject2D(radius, flts[i].center(), flts[i].pointOnCurve2(), thisPnt);
		fltList.addFillet(thisFlt);
	    }
	}

	JgclFilletObject2D[] extract() {
	    return fltList.toJgclFilletObject2DArray(false);
	}
    }

    /**
     * ̃|C̎w̋ԂƑ̋Ȑ̎w̋ԂɂtBbg߂B
     *
     * @param pint1	̋Ȑ̃p[^
     * @param side1	̋Ȑ̂ǂ瑤ɃtBbg߂邩tO
     *			(JgclWhichSide.LEFTȂ΍ARIGHTȂΉEABOTHȂΗ)
     * @param mate	̋Ȑ
     * @param pint2	̋Ȑ̃p[^
     * @param side2	̋Ȑ̂ǂ瑤ɃtBbg߂邩tO
     *			(JgclWhichSide.LEFTȂ΍ARIGHTȂΉEABOTHȂΗ)
     * @param radius	tBbga
     * @param doExchange	tBbg point1/2 邩ǂ
     * @return		tBbg̔z
     * @exception JgclIndefiniteSolution	s (ł͔Ȃ)
     * @see	JgclWhichSide
     */
    JgclFilletObject2D[]
    doFillet(JgclParameterSection pint1, int side1, JgclParametricCurve2D mate,
	     JgclParameterSection pint2, int side2, double radius,
	     boolean doExchange)
	throws JgclIndefiniteSolution
    {
	FilletAccumulator acc =
	    new FilletAccumulator(mate, pint2, side2, this, side1, radius, doExchange);
	acc.accumulate(pint1);
	return acc.extract();
    }

    /**
     * ̋ȐƑ̋ȐƂ̋ʐڐ߂B
     * <p>
     * ʐڐ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * _ł͎ĂȂ߁A
     * JgclNotSupported	̗O𔭐B
     * </p>
     *
     * @param mate	̋Ȑ
     * @return		ʐڐ̔z
     * @exception	JgclNotSupported	܂̂ƂAȂ@\ł
     */
    public JgclCommonTangent2D[] commonTangent(JgclParametricCurve2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋ȐƂ̋ʖ@߂B
     * <p>
     * ʖ@݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * _ł͎ĂȂ߁A
     * JgclNotSupported	̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		ʖ@̔z
     * @exception	JgclNotSupported	܂̂ƂAȂ@\ł
     */
    public JgclCommonNormal2D[]	commonNormal(JgclParametricCurve2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̃|C𔽓]|CԂB
     *
     * @return	]|C
     */
    JgclPolyline2D reverse() {
	int uip = nPoints();
	JgclPoint2D[] rPnts = new JgclPoint2D[uip];
	int i, j;

	if (closed) {
	    rPnts[0] = points[0];
	    i = 1;
	} else {
	    i = 0;
	}
	for (j = uip - 1; i < uip; i++, j--) {
	    rPnts[i] = points[j];
	}
	return new JgclPolyline2D(rPnts, closed);
    }

    /**
     * ̃|C̑ݔ͈͂`ԂB
     *
     * @return	ݔ͈͂`
     */
    JgclEnclosingBox2D enclosingBox() {
	double min_crd_x;
	double min_crd_y;
	double max_crd_x;
	double max_crd_y;

	max_crd_x = min_crd_x = pointAt(0).x();
	max_crd_y = min_crd_y = pointAt(0).y();

	for (int i = 1; i < nPoints(); i++) {
	    min_crd_x = Math.min(min_crd_x, pointAt(i).x());
	    min_crd_y = Math.min(min_crd_y, pointAt(i).y());
	    max_crd_x = Math.max(max_crd_x, pointAt(i).x());
	    max_crd_y = Math.max(max_crd_y, pointAt(i).y());
	}
	return new JgclEnclosingBox2D(min_crd_x, min_crd_y, max_crd_x, max_crd_y);
    }

    /**
     * ̋Ȑ̃p[^`ԂB
     * 
     * @return	p[^`
     */
    JgclParameterDomain getParameterDomain() {
	double n = closed ? points.length : points.length-1;

	try {
	    return new JgclParameterDomain(closed, 0, n);
	}
	catch (JgclInvalidArgumentValue e) {
	    // should never be occurred
	    throw new JgclFatal();
	}
    }

    /**
     * ̊􉽗vfR`󂩔ۂԂB
     *
     * @return	 true
     */
    public boolean isFreeform() {
	return true;
    }

    /**
     * ̗LȐ̊Jn_ԂB
     * <p>
     * Ȑ`̏ꍇ null ԂB
     * </p>
     *
     * @return	Jn_
     */
    public JgclPoint2D startPoint() {
	if (isPeriodic())
	    return null;

	return points[0];
    }

    /**
     * ̗LȐ̏I_ԂB
     * <p>
     * Ȑ`̏ꍇ null ԂB
     * </p>
     *
     * @return	I_
     */
    public JgclPoint2D endPoint() {
	if (isPeriodic())
	    return null;

	return points[points.length-1];
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricCurve2D#POLYLINE_2D JgclParametricCurve2D.POLYLINE_2D}
     */
    int type() {
	return POLYLINE_2D;
    }

    /**
     * {@link #toBoundedLines(JgclParameterSection)
     * toBoundedLines(JgclParameterSection)}
     * 邽߂ LineSegmentAccumulator ̎B
     */
    private class ToBoundedLinesAccumulator extends LineSegmentAccumulator {
	JgclBoundedLine2D[] boundedLines;
	int index;
	boolean rvrs;

	ToBoundedLinesAccumulator(boolean reverse) {
	    rvrs = reverse;
	}

	void allocate(int nsegs) {
	    boundedLines = new JgclBoundedLine2D[nsegs];
	    if (rvrs == false)
		index = 0;
	    else
		index = nsegs - 1;
	}

	void doit(JgclPoint2D sp, JgclPoint2D ep,
		  double sParam, double eParam) {
	    if (rvrs == false)
		boundedLines[index++] = new JgclBoundedLine2D(sp, ep, false);
	    else
		boundedLines[index--] = new JgclBoundedLine2D(ep, sp, false);
	}

	JgclBoundedLine2D[] extract() {
	    return boundedLines;
	}
    }

    /**
     * ̃|C̎w̋ԂɕϊB
     *
     * @param pint	ɕϊp[^
     * @return	w肳ꂽԂϊ
     */
    public JgclBoundedLine2D[] toBoundedLines(JgclParameterSection pint) {
	ToBoundedLinesAccumulator acc =
	    new ToBoundedLinesAccumulator(pint.increase() < 0.0);
	acc.accumulate(pint);
	return acc.extract();
    }

    /**
     * ̃|CŜɕϊB
     *
     * @return	ȐŜϊ
     */
    public JgclBoundedLine2D[] toBoundedLines() {
	return this.toBoundedLines(this.parameterDomain().section());
    }

    /**
     * ̋ȐA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricCurve2D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator2D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclPoint2D[] tPoints =
	    JgclPoint2D.transform(this.points,
				  reverseTransform,
				  transformationOperator,
				  transformedGeometries);
	return new JgclPolyline2D(tPoints, this.closed);
    }

    /**
     * ̋Ȑ|C̕܂ނۂԂB
     *
     * @return	 true
     */
    protected boolean hasPolyline() {
	return true;
    }

    /**
     * ̋Ȑ|C̕łłĂ邩ۂԂB
     *
     * @return	 true
     */
    protected boolean isComposedOfOnlyPolylines() {
	return true;
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tpoints");
	for (int i = 0; i < nPoints(); i++) {
	    points[i].output(writer, indent + 2);
        }
        writer.println(indent_tab + "\tclosed\t" + closed);
        writer.println(indent_tab + "End");
    }
}
