/*
 * `vf̓_̃Xg߂̃NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclPointOnGeometryList.java,v 1.3 2000/04/26 09:39:18 hideit Exp $
 */

package jp.go.ipa.jgcl;
import java.util.*;

/**
 * `vf̓_̃Xg߂̃NX
 *
 * @version $Revision: 1.3 $, $Date: 2000/04/26 09:39:18 $
 * @author Information-technology Promotion Agency, Japan
 */

class JgclPointOnGeometryList {
    /**
     * `vf̓_̃Xg
     * @see Vector
     */
    Vector list;

    /*
     * RXgN^
     */
    JgclPointOnGeometryList() {
	super();
	list = new Vector();
    }

    /*
     * 2DȐ̓_ǉB
     * ɓ݂Ƃ͒ǉȂB
     * @param thePointOnCurve	ǉ2DȐ̓_
     * @see	JgclPointOnCurve2D
     */
    void addPoint(JgclPointOnCurve2D thePointOnCurve) {
	JgclPointOnCurve2D mate;

	for (Enumeration en = list.elements(); en.hasMoreElements();) {
	    if (thePointOnCurve.parametricallyIdentical((JgclPointOnCurve2D)en.nextElement()))
		return;
	}
	list.addElement(thePointOnCurve);
    }

    /*
     * 2DȐ̓_ǉB
     * ɓ݂Ƃ͒ǉȂB
     * @param thePointOnCurve	ǉ2DȐ̓_
     * @see	JgclPointOnCurve2D
     */
    void addPoint(JgclParametricCurve2D curve,
		  double parameter) {
	addPoint(new JgclPointOnCurve2D(curve, parameter, JgclGeometry.doCheckDebug));
    }

    /*
     * 3DȐ̓_ǉB
     * ɓ݂Ƃ͒ǉȂB
     * @param thePointOnCurve	ǉ3DȐ̓_
     * @see	JgclPointOnCurve3D
     */
    void addPoint(JgclPointOnCurve3D thePointOnCurve) {
	JgclPointOnCurve3D mate;

	for (Enumeration en = list.elements(); en.hasMoreElements();) {
	    if (thePointOnCurve.parametricallyIdentical((JgclPointOnCurve3D)en.nextElement()))
		return;
	}
	list.addElement(thePointOnCurve);
    }

    /*
     * 3DȐ̓_ǉB
     * ɓ݂Ƃ͒ǉȂB
     * @param thePointOnCurve	ǉ3DȐ̓_
     * @see	JgclPointOnCurve3D
     */
    void addPoint(JgclParametricCurve3D curve,
		  double parameter) {
	addPoint(new JgclPointOnCurve3D(curve, parameter, JgclGeometry.doCheckDebug));
    }

    /**
     * 2DȐ̓_zƂĎoB
     * @return	2DȐ̓_̔z
     * @see	JgclPointOnCurve2D
     */
    JgclPointOnCurve2D[] toJgclPointOnCurve2DArray() {
	JgclPointOnCurve2D[] pocs = new JgclPointOnCurve2D[list.size()];
	list.copyInto(pocs);
	return pocs;
    }

    /**
     * 3DȐ̓_zƂĎoB
     * @return	3DȐ̓_̔z
     * @see	JgclPointOnCurve3D
     */
    JgclPointOnCurve3D[] toJgclPointOnCurve3DArray() {
	JgclPointOnCurve3D[] pocs = new JgclPointOnCurve3D[list.size()];
	list.copyInto(pocs);
	return pocs;
    }
}

// end of file
