/*
 * P̓_\ۃNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclPoint1D.java,v 1.18 2000/08/11 06:18:56 shikano Exp $
 *
 */

package jp.go.ipa.jgcl;

/**
 * P̓_\ۃNXB
 *
 * @version $Revision: 1.18 $, $Date: 2000/08/11 06:18:56 $
 * @author Information-technology Promotion Agency, Japan
 * @see JgclVector1D
 */

public abstract class JgclPoint1D extends JgclPoint {
    /**
     * P̌_ (0)B
     */
    public static final JgclPoint1D origin;

    /**
     * static ȃtB[hɒlݒ肷B
     */
    static {
	origin = new JgclCartesianPoint1D(0.0);
    }

    /**
     * IuWFNg\zB
     */
    protected JgclPoint1D(){
        super();
    }

    /**
     * ԂB
     * <p>
     *  1 ԂB
     * </p>
     *
     * @return	PȂ̂ŁA 1
     */
    public int dimension() {
        return 1;
    }

    /**
     * PۂԂ
     *
     * <p>
     *  true ԂB
     * </p>
     * 
     * @return		PȂ̂ŁA <code>true</code>
     */
    public boolean is1D() {
        return true;
    }

    /**
     * _ X WlԂۃ\bhB
     *
     * @return	_ X Wl
     */
    public abstract double x();
  
    /**
     * ̓_ɗ^ꂽxNg𑫂_ԂB
     *
     * @param vector	_ɑxNg
     * @return	^ꂽxNg𑫂_ (this + vector)
     */
    public JgclPoint1D add(JgclVector1D vector) {
        return new JgclCartesianPoint1D(x() + vector.x());
    }

    /**
     * ̓_^ꂽxNg_ԂB
     *
     * @param vector	_xNg
     * @return	^ꂽxNg_ (this - vector)
     */
    public JgclPoint1D subtract(JgclVector1D vector) {
        return new JgclCartesianPoint1D(x() - vector.x());
    }

    /**
     * ̓_ɗ^ꂽXP[悶_ԂB
     *
     * @param scale	XP[
     * @return	(this * scale)
     */
    public JgclPoint1D multiply(double scale) {
        return new JgclCartesianPoint1D(x() * scale);
    }

    /**
     * ̓_^ꂽXP[Ŋ_ԂB
     *
     * @param scale	XP[
     * @return	(this / scale)
     */
    public JgclPoint1D divide(double scale) {
        return new JgclCartesianPoint1D(x() / scale);
    }

    /**
     * ̓_Ɨ^ꂽ_Ő^ԂʂԂB
     *
     * @param mate	`Ԃ̑ƂȂ_
     * @param weightForThis	gɑ΂d (ɑ΂d݂ 1 - weightForThis)
     * @return	`Ԃʂ̓_ (weightForThis * this + (1 - weightForThis) * mate)
     */
    public JgclPoint1D linearInterpolate(JgclPoint1D mate,
					 double weightForThis) {
        return new JgclCartesianPoint1D(
            this.x() * weightForThis + mate.x() * (1 - weightForThis));
    }

    /**
     * ̓_Ɨ^ꂽ_̒_ԂB
     *
     * @param mate	_߂鑊ƂȂ_
     * @return	_ (0.5 * this + 0.5 * mate)
     */
    public JgclPoint1D midPoint(JgclPoint1D mate) {
        return linearInterpolate(mate, 0.5);
    }

    /**
     * Q_̓ꐫ𔻒肷B
     *
     * @param mate	̑ΏۂƂȂ_
     * @return	this  mate űe덷vȓ
     *		̓_łƂ݂Ȃ trueAȂ false
     * @see	JgclConditionOfOperation
     */ 
    public boolean identical(JgclPoint1D mate) {
        return Math.abs(x() - mate.x()) < getToleranceForDistance();
    }

    /**
     * ̓_P̃xNg (JgclVector1D) ɕϊB
     *
     * @return	_̃xNgƂ݂ȂxNg
     */
    public JgclVector1D toVector1D() {
        return new JgclLiteralVector1D(x());
    }

    /**
     * JgclCartesianPoint1D ̃CX^X𐶐B
     *
     * @param x	X 
     * @return	JgclCartesianPoint1D ̃CX^X
     */
    public static JgclCartesianPoint1D of(double x) {
	return new JgclCartesianPoint1D(x);
    }
}
