/*
 * Q̃pgbNȋȐ̃NXKw̃[gƂȂ钊ۃNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclParametricCurve2D.java,v 1.63 2000/08/11 06:18:54 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Vector;
import java.util.Enumeration;

/**
 * Q̃pgbNȋȐ̃NXKw̃[gƂȂ钊ۃNXB
 * <p>
 * ̃NX́A̎lŕ\p[^ t ̒lɂāA
 * ʒu肳Q̋Ȑ P(t) Sʂ\B
 * </p>
 *
 * @version $Revision: 1.63 $, $Date: 2000/08/11 06:18:54 $
 * @author Information-technology Promotion Agency, Japan
 * @see JgclParametricCurve3D
 */

public abstract class JgclParametricCurve2D extends JgclParametricCurve {
    /**
     * Ȑ Line ł邱Ƃ萔
     */
    static final int LINE_2D = 1;

    /**
     * Ȑ Bounded Line ł邱Ƃ萔
     */
    static final int BOUNDED_LINE_2D = 2;

    /**
     * Ȑ Circle ł邱Ƃ萔
     */
    static final int CIRCLE_2D = 10;

    /**
     * Ȑ Ellipse ł邱Ƃ萔
     */
    static final int ELLIPSE_2D = 11;

    /**
     * Ȑ Hyperbola ł邱Ƃ萔
     */
    static final int HYPERBOLA_2D = 12;

    /**
     * Ȑ Parabola ł邱Ƃ萔
     */
    static final int PARABOLA_2D = 13;

    /**
     * Ȑ Polyline ł邱Ƃ萔
     */
    static final int POLYLINE_2D = 20;

    /**
     * Ȑ Bspline Curve ł邱Ƃ萔
     */
    static final int BSPLINE_CURVE_2D = 21;

    /**
     * Ȑ Pure Bezier Curve ł邱Ƃ萔
     */
    static final int PURE_BEZIER_CURVE_2D = 22;

    /**
     * Ȑ Trimmed Curve ł邱Ƃ萔
     */
    static final int TRIMMED_CURVE_2D = 23;

    /**
     * Ȑ Composite Curve ł邱Ƃ萔
     */
    static final int COMPOSITE_CURVE_2D = 24;

    /**
     * Ȑ Composite Curve Segment ł邱Ƃ萔
     */
    static final int COMPOSITE_CURVE_SEGMENT_2D = 25;

    /**
     * Ȑ Polynomial Curve ł邱Ƃ萔
     */
    static final int POLYNOMIAL_CURVE_2D = 30;

    /**
     * ^ɃIuWFNg\zB
     */
    protected JgclParametricCurve2D() {
	super();
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̍WlԂۃ\bhB
     * 
     * @param param	p[^l
     * @return		Wl
     */
    public abstract JgclPoint2D coordinates(double param);

    /**
     * ̋Ȑ́A^ꂽp[^lł̐ڃxNgԂۃ\bhB
     * 
     * @param param	p[^l
     * @return		ڃxNg
     */
    public abstract JgclVector2D tangentVector(double param);

    /**
     * ̋Ȑ́A^ꂽp[^lł̋ȗԂۃ\bhB
     * 
     * @param param	p[^l
     * @return		ȗ
     */
    public abstract JgclCurveCurvature2D curvature(double param);

    /**
     * ̋Ȑ́A^ꂽp[^lł̓֐Ԃۃ\bhB
     * 
     * @param param	p[^l
     * @return		֐
     */
    public abstract JgclCurveDerivative2D evaluation(double param);

    /**
     * ̋Ȑ̓ٓ_Ԃۃ\bhB
     * <p>
     * ٓ_Ƃ́A
     * ڃxNg̑傫 0 ɂȂ_A
     * 邢͂̑OŐڃxNgsAƂȂ_łB
     * </p>
     * <p>
     * ٓ_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @return		ٓ_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    public abstract JgclPointOnCurve2D[] singular() throws JgclIndefiniteSolution;

    /**
     * ̋Ȑ̕ϋȓ_Ԃۃ\bhB
     * <p>
     * ϋȓ_Ƃ́ȂOŋȗS݂̑TChړ_łB
     * </p>
     * <p>
     * ϋȓ_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @return		ϋȓ_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    public abstract JgclPointOnCurve2D[] inflexion() throws JgclIndefiniteSolution;

    /**
     * ^ꂽp[^l̓_A
     * _̋Ȑɓe_ (܂A_炱̋Ȑւ̐̑) 
     * 邩ǂԂB
     * <p>
     * ^ꂽp[^l̓_e_ł΁A̓_\_ԂB
     * ^ꂽp[^l̓_e_łȂ null ԂB
     * </p>
     * 
     * @param Bparam	e_̃p[^l
     * @param p		e̓_
     * @param dTol2	̋e덷̎
     * @return		e_IuWFNg
     * @see	#projectFrom(JgclPoint2D)
     */
    protected JgclPointOnCurve2D checkProjection(double Bparam,
						 JgclPoint2D p,
						 double dTol2)
    {
	JgclPointOnCurve2D result = null;

	if (!isValid(Bparam)) {
	    return null;
	}

	JgclPoint2D Bpnt = coordinates(Bparam);
	JgclVector2D Bpnt2A = p.subtract(Bpnt);
	double norm = Bpnt2A.norm();

	if (norm > dTol2) {
	    JgclCurveCurvature2D Bcurv = curvature(Bparam);
	    double dist_from_Bnrml = Bpnt2A.zOfCrossProduct(Bcurv.normal());

	    if (dist_from_Bnrml * dist_from_Bnrml > dTol2) {
		return null;
	    }
	}

	try {
	    return new JgclPointOnCurve2D(Bpnt, this, Bparam, doCheckDebug);
	}
	catch (JgclInvalidArgumentValue e) {
	    throw new JgclFatal();
	}
    }

    /**
     * ^ꂽ̃p[^l̋Ȑœ̓_Ƃ݂Ȃ邩ǂԂB
     * <p>
     * ̃p[^l̊Ԃ̋Ȑ̓̂肪A
     * ݐݒ肳Ă鉉Z̋̋e덷
     * ̃p[^l͓̓_\Ă̂ƂB
     * </p>
     * 
     * @param own_prm1	p[^l 1
     * @param own_prm2	p[^l 2
     * @return		̓_Ƃ݂ȂȂ trueAłȂ false
     */
    public boolean identicalParameter(double own_prm1, double own_prm2) {
	JgclPoint2D o1_crd, o2_crd;
	JgclParameterDomain pdmn;
	JgclParameterSection pint;
	double leng;

	checkValidity(own_prm1);
	checkValidity(own_prm2);

	o1_crd = coordinates(own_prm1);
	o2_crd = coordinates(own_prm2);

	if (!o1_crd.identical(o2_crd))
	    return false;

	pdmn = parameterDomain();

	double pTol;
	double increase = 0.0;
	if (pdmn.isInfinite())
	    pTol = JgclMachineEpsilon.DOUBLE;
	else {
	    increase = Math.abs(pdmn.section().increase());
	    if (increase < 1.0)
		pTol = JgclMachineEpsilon.DOUBLE * increase;
	    else
		pTol = JgclMachineEpsilon.DOUBLE;
	}

	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double savedPTol = condition.getToleranceForParameter();

	condition.makeCopyWithToleranceForParameter(pTol).push();
	try {

	    if (own_prm1 > own_prm2)
		pint = new JgclParameterSection(own_prm2, own_prm1 - own_prm2);
	    else
		pint = new JgclParameterSection(own_prm1, own_prm2 - own_prm1);

	    leng = length(pint);

	    double dTol = condition.getToleranceForDistance();
	    if (leng < dTol)
		return true;

	    if (!pdmn.isPeriodic())
		return false;
	    else {
		double start = (own_prm1 > own_prm2) ? own_prm1 : own_prm2;

		increase = increase - pint.increase();
		pint = new JgclParameterSection(start, increase);
		leng = length(pint);

		if (leng < dTol)
		    return true;
	    }
	    return false;
	}
	finally {
	    JgclConditionOfOperation.pop();
	}
    }

    /**
     * ^ꂽ_炱̋Ȑւ̓e_߂钊ۃ\bhB
     * <p>
     * e_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param point	e̓_
     * @return		e_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    public abstract JgclPointOnCurve2D[] projectFrom(JgclPoint2D point)
	throws JgclIndefiniteSolution;

    /**
     * ̋Ȑ̎w̋ԂA^ꂽ덷Œߎ|CԂۃ\bhB
     * <p>
     * ʂƂĕԂ|C\_ JgclPointOnCurve2D 
     * 邱Ƃ҂łB
     * </p>
     * 
     * @param pint	ߎp[^
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ𒼐ߎ|C
     * @see		JgclPointOnCurve2D
     */
    public abstract JgclPolyline2D
	toPolyline(JgclParameterSection pint, JgclToleranceForDistance tol);

    /**
     * ̋Ȑ̎w̋ԂɍČL Bspline ȐԂۃ\bhB
     * 
     * @param pint	L Bspline ȐōČp[^
     * @return		̋Ȑ̎w̋ԂČL Bspline Ȑ
     */
    public abstract JgclBsplineCurve2D
	toBsplineCurve(JgclParameterSection pint);

    /**
     * ̋ȐƑ̋Ȑ̌_߂钊ۃ\bhB
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    public abstract JgclIntersectionPoint2D[]
	intersect(JgclParametricCurve2D mate)
	 throws JgclIndefiniteSolution;

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂钊ۃ\bh (internal use) B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     *
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    abstract JgclIntersectionPoint2D[]
	intersect(JgclLine2D mate, boolean doExchange)
	 throws JgclIndefiniteSolution;

    /**
     * ̋ȐƑ̋Ȑ (~) ̌_߂钊ۃ\bh (internal use) B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     *
     * @param mate	̋Ȑ (~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    abstract JgclIntersectionPoint2D[]
	intersect(JgclCircle2D mate, boolean doExchange)
	 throws JgclIndefiniteSolution;

    /**
     * ̋ȐƑ̋Ȑ (ȉ~) ̌_߂钊ۃ\bh (internal use) B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     *
     * @param mate	̋Ȑ (ȉ~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    abstract JgclIntersectionPoint2D[]
	intersect(JgclEllipse2D mate, boolean doExchange)
	 throws JgclIndefiniteSolution;

    /**
     * ̋ȐƑ̋Ȑ (oȐ) ̌_߂钊ۃ\bh (internal use) B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     *
     * @param mate	̋Ȑ (oȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    abstract JgclIntersectionPoint2D[]
	intersect(JgclHyperbola2D mate, boolean doExchange)
	 throws JgclIndefiniteSolution;

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂钊ۃ\bh (internal use) B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     *
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    abstract JgclIntersectionPoint2D[]
	intersect(JgclParabola2D mate, boolean doExchange)
	 throws JgclIndefiniteSolution;

    /**
     * ̋ȐƑ̋Ȑ (|C) ̌_߂钊ۃ\bh (internal use) B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     *
     * @param mate	̋Ȑ (|C)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    abstract JgclIntersectionPoint2D[]
	intersect(JgclPolyline2D mate, boolean doExchange);

    /**
     * ̋ȐƑ̋Ȑ (xWGȐ) ̌_߂钊ۃ\bh (internal use) B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     *
     * @param mate	̋Ȑ (xWGȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    abstract JgclIntersectionPoint2D[]
	intersect(JgclPureBezierCurve2D mate, boolean doExchange);

    /**
     * ̋ȐƑ̋Ȑ (aXvCȐ) ̌_߂钊ۃ\bh (internal use) B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     *
     * @param mate	̋Ȑ (aXvCȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    abstract JgclIntersectionPoint2D[]
	intersect(JgclBsplineCurve2D mate, boolean doExchange);

    /**
     * ̋ȐƑ̋Ȑ (gȐ) ̌_߂钊ۃ\bh (internal use) B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     *
     * @param mate	̋Ȑ (gȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    abstract JgclIntersectionPoint2D[]
	intersect(JgclTrimmedCurve2D mate, boolean doExchange);

    /**
     * ̋ȐƑ̋Ȑ (ȐZOg) ̌_߂钊ۃ\bh (internal use) B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     *
     * @param mate	̋Ȑ (ȐZOg)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    abstract JgclIntersectionPoint2D[]
	intersect(JgclCompositeCurveSegment2D mate, boolean doExchange);

    /**
     * ̋ȐƑ̋Ȑ (Ȑ) ̌_߂钊ۃ\bh (internal use) B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     *
     * @param mate	̋Ȑ (Ȑ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    abstract JgclIntersectionPoint2D[]
	intersect(JgclCompositeCurve2D mate, boolean doExchange);

    /**
     * ̋Ȑ̎w̋ԂItZbgȐA
     * ^ꂽ덷ŋߎ Bspline Ȑ߂钊ۃ\bhB
     * 
     * @param pint	ItZbgp[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.LEFT/RIGHT)
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ̃ItZbgȐߎ Bspline Ȑ
     * @see	JgclWhichSide
     */
    public abstract JgclBsplineCurve2D
        offsetByBsplineCurve(JgclParameterSection pint,
			     double magni, 
			     int side,
			     JgclToleranceForDistance tol);

    /**
     * ̋Ȑ̎w̋ԂItZbgȐA
     * ^ꂽ덷ŋߎLȐ߂B
     * 
     * @param pint	ItZbgp[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.LEFT/RIGHT)
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ̃ItZbgȐߎLȐ
     * @see	JgclWhichSide
     */
    public JgclBoundedCurve2D
        offsetByBoundedCurve(JgclParameterSection pint,
			     double magni, 
			     int side,
			     JgclToleranceForDistance tol)
    {
	return this.offsetByBsplineCurve(pint, magni, side, tol);
    }

    /**
     * ̋Ȑ̎w̋ԂƁA̋Ȑ̎w̋ԂɂtBbg߂B
     * <p>
     * tBbg݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param pint1	̋Ȑ̃p[^
     * @param side1	̋Ȑ̂ǂ瑤ɃtBbg߂邩tO
     *			(JgclWhichSide.LEFTȂ΍ARIGHTȂΉEABOTHȂΗ)
     * @param mate	̋Ȑ
     * @param pint2	̋Ȑ̃p[^
     * @param side2	̋Ȑ̂ǂ瑤ɃtBbg߂邩tO
     *			(JgclWhichSide.LEFTȂ΍ARIGHTȂΉEABOTHȂΗ)
     * @param radius	tBbga
     * @return		tBbg̔z
     * @exception JgclIndefiniteSolution	s (ł͔Ȃ)
     * @see	JgclWhichSide
     */
    public JgclFilletObject2D[]
	fillet(JgclParameterSection pint1, int side1,
	       JgclParametricCurve2D mate, JgclParameterSection pint2, int side2,
	       double radius)
	throws JgclIndefiniteSolution
    {
	return JgclFiltCrvCrv2D.fillet(this, pint1, side1, mate, pint2, side2, radius);
    }

    /**
     * ̋ȐƑ̋ȐƂ̋ʐڐ߂钊ۃ\bh (͎Ȃ) B
     * <p>
     * ʐڐ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		ʐڐ̔z
     */
    public abstract JgclCommonTangent2D[]
	commonTangent(JgclParametricCurve2D mate);

    /**
     * ̋ȐƑ̋ȐƂ̋ʖ@߂钊ۃ\bh (͎Ȃ) B
     * <p>
     * ʖ@݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		ʖ@̔z
     */
    public abstract JgclCommonNormal2D[]
	commonNormal(JgclParametricCurve2D mate);

    /**
     * ̋Ȑ̎ԂB
     * <p>
     *  2 ԂB
     * </p>
     *
     * @return QȂ̂ŁA 2
     */
    public int dimension() {
	return 2;
    }

    /**
     * ̋ȐQۂԂB
     * <p>
     *  true ԂB
     * </p>
     * 
     * @return	QȂ̂ŁA true
     */
    public boolean is2D() {
	return true;
    }

    /**
     * ̋Ȑ̗vfʂԂۃ\bhB
     *
     * @return	vf
     * @see	#LINE_2D
     * @see	#BOUNDED_LINE_2D
     * @see	#CIRCLE_2D
     * @see	#ELLIPSE_2D
     * @see	#HYPERBOLA_2D
     * @see	#PARABOLA_2D
     * @see	#POLYLINE_2D
     * @see	#BSPLINE_CURVE_2D
     * @see	#PURE_BEZIER_CURVE_2D
     * @see	#TRIMMED_CURVE_2D
     * @see	#COMPOSITE_CURVE_2D
     * @see	#COMPOSITE_CURVE_SEGMENT_2D
     * @see	#POLYNOMIAL_CURVE_2D
     */
    abstract int type();

    /**
     * ^ꂽ_ P 炱̋Ȑւ̓e_̓ŁAP ɍł߂_ԂB
     * <p>
     * e_݂Ȃꍇɂ null ԂB
     * </p>
     * 
     * @param pnt	e̓_
     * @return		e̓_ɍł߂e_
     * @see	#projectFrom(JgclPoint2D)
     * @see	#nearestProjectWithDistanceFrom(JgclPoint2D, double)
     */
    public JgclPointOnCurve2D nearestProjectFrom(JgclPoint2D pnt) {
	JgclPointOnCurve2D[] proj;
	try {
	    proj = projectFrom(pnt);
	}
	catch (JgclIndefiniteSolution e) {
	    proj = new JgclPointOnCurve2D[1];
	    proj[0] = (JgclPointOnCurve2D)e.suitable();
	}

	if (proj.length == 0)
	    return null;

	double dist = proj[0].distance2(pnt);
	int idx = 0;

	// find nearest point
	for (int i = 1; i < proj.length; i++) {
	    double dist2 = proj[i].distance2(pnt);

	    if (dist2 < dist) {
		dist = dist2;
		idx = i;
	    }
	}

	return proj[idx];
    }

    /**
     * ^ꂽ_ P 炱̋Ȑւ̓e_̓ŁAP ̋w̒lɍł߂_ԂB
     * <p>
     * e_݂Ȃꍇɂ null ԂB
     * </p>
     * 
     * @param pnt	e̓_
     * @param distance	
     * @return		w肵ɍł߂e_
     * @see	#projectFrom(JgclPoint2D)
     * @see	#nearestProjectFrom(JgclPoint2D)
     */
    public JgclPointOnCurve2D nearestProjectWithDistanceFrom(JgclPoint2D pnt,
							     double distance) {
	JgclPointOnCurve2D[] proj;
	try {
	    proj = projectFrom(pnt);
	}
	catch (JgclIndefiniteSolution e) {
	    proj = new JgclPointOnCurve2D[1];
	    proj[0] = (JgclPointOnCurve2D)e.suitable();
	}

	if (proj.length == 0)
	    return null;

	double diff = Math.abs(distance - proj[0].distance(pnt));
	int idx = 0;

	// find nearest point
	for (int i = 1; i < proj.length; i++) {
	    double diff2 = Math.abs(distance - proj[i].distance(pnt));

	    if (diff2 < diff) {
		diff = diff2;
		idx = i;
	    }
	}

	return proj[idx];
    }

    /**
     * ^ꂽ_́A̋Ȑł̃p[^l߂B
     * <p>
     * ^ꂽ_̋ȐɏĂ̂ƂāA
     * ̓_ɑΉp[^l߂B
     * </p>
     * <p>
     * ̃\bh͈̓ȉ̒ʂB
     * <ul>
     * <li> nearestProjectFrom(pnt) gāA
     *		^ꂽ_ P ɍł߂e_ Q 𓾂
     * <li> Q ݂āA
     *		P  Q ݐݒ肳Ă鉉Zœ̓_Ƃ݂Ȃ΁A
     *		Q ̃p[^lԂ
     * <li> ̋ȐLŊJȐŁA
     *		[_ P ɈvȂ΁Ãp[^lԂ
     * <li> ̋Ȑ|C̕Ȃ΁A|CɕϊA
     *		̃|C̒_ P ƈv̂΁A
     *		̃p[^lԂ
     * <li> ȏ̂ɂĂ͂܂Ȃ΁AJgclInvalidArgumentValue 𓊂
     * </ul>
     * </p>
     *
     * @param pnt	Ȑ̓_
     * @return		Ήp[^l
     * @see	JgclInvalidArgumentValue
     * @see	#nearestProjectFrom(JgclPoint2D)
     * @see	JgclConditionOfOperation
     */
    public double pointToParameter(JgclPoint2D pnt) {
	// e_ identical H
	JgclPointOnCurve2D proj = nearestProjectFrom(pnt);
	if ((proj != null) && (pnt.identical(proj)))
	    return proj.parameter();

	// [_ꍇA炪 identical H
	if (this.isFinite() && this.isOpen()) {
	    double param;

	    param = this.parameterDomain().section().lower();
	    if (pnt.identical(new JgclPointOnCurve2D(this, param)))
		return param;

	    param = this.parameterDomain().section().upper();
	    if (pnt.identical(new JgclPointOnCurve2D(this, param)))
		return param;
	}

	// |C̉ӏꍇAidentical Ȓ_邩H
	if (this.hasPolyline() == true) {
	    JgclBoundedCurve2D bounded = (JgclBoundedCurve2D)this;
	    JgclPolyline2D polyline = bounded.toPolyline(getToleranceForDistanceAsObject());
	    JgclPointOnCurve2D pos;

	    for (int i = 0; i < polyline.nPoints(); i++) {
		pos = (JgclPointOnCurve2D)polyline.pointAt(i);
		if (pnt.identical(pos))
		    return pos.parameter();
	    }
	}

	throw new JgclInvalidArgumentValue();
    }

    /**
     * ^ꂽp[^l̂̋Ȑɑ΂鐳𒲂ׂB
     * <p>
     * <ul>
     * <li> ^ꂽp[^l P A̋Ȑ̒` ([_܂) ɂ
     *		JgclParameterValidity.PROPERLY_INSIDE ԂB
     * <li> ł͂ȂAP ̋Ȑ̒`扺菬A
     *		̍ԏł̋ɒul
     *		ݐݒ肳Ă鉉Z
     *		̋e덷ꍇɂ
     *		JgclParameterValidity.TOLERATED_LOWER_LIMIT ԂB
     * <li> ł͂ȂAP ̋Ȑ̒`傫A
     *		̍ԏł̋ɒul
     *		ݐݒ肳Ă鉉Z
     *		̋e덷ꍇɂ
     *		JgclParameterValidity.TOLERATED_UPPER_LIMIT ԂB
     * <li> ̂łȂ΁A
     *		JgclParameterValidity.OUTSIDE ԂB
     * <ul>
     * </p>
     *
     * @param  param   p[^l
     * @return         p[^l̂̋Ȑɑ΂鐳
     * @see	JgclParameterValidity
     */
    int parameterValidity(double param) {
	JgclParameterDomain pDomain = this.parameterDomain();

	if (pDomain.isInfinite() || pDomain.isPeriodic())
	    return JgclParameterValidity.PROPERLY_INSIDE;

	double lower = pDomain.section().lower();
	double upper = pDomain.section().upper();
	double deltaDenom = 100;
	double delta = (upper - lower) / deltaDenom;
	double tol4Norm = this.getToleranceForDistance2();
	double endParam;
	JgclVector2D tangentVector;
	double tangentNorm = 0.0;
	double tol4Param;

	if (param < lower) {
	    endParam = lower;
	    while (endParam < upper) {
		tangentVector = this.tangentVector(endParam);
		if ((tangentNorm = tangentVector.norm()) > tol4Norm)
		    break;
		endParam += delta;
	    }
	    if (!(tangentNorm > tol4Norm))
		return JgclParameterValidity.OUTSIDE;

	    tol4Param = this.getToleranceForDistance() / Math.sqrt(tangentNorm);
	    if ((lower - param) < tol4Param)
		return JgclParameterValidity.TOLERATED_LOWER_LIMIT;
	    else
		return JgclParameterValidity.OUTSIDE;
	}

	if (upper < param) {
	    endParam = upper;
	    while (endParam > lower) {
		tangentVector = this.tangentVector(endParam);
		if ((tangentNorm = tangentVector.norm()) > tol4Norm)
		    break;
		endParam -= delta;
	    }
	    if (!(tangentNorm > tol4Norm))
		return JgclParameterValidity.OUTSIDE;

	    tol4Param = this.getToleranceForDistance() / Math.sqrt(tangentNorm);
	    if ((param - upper) < tol4Param)
		return JgclParameterValidity.TOLERATED_UPPER_LIMIT;
	    else
		return JgclParameterValidity.OUTSIDE;
	}

	return JgclParameterValidity.PROPERLY_INSIDE;
    }

    /**
     * ̋ȐA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected abstract JgclParametricCurve2D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator2D transformationOperator,
		  java.util.Hashtable transformedGeometries);

    /**
     * ̋ȐA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    public synchronized JgclParametricCurve2D
    transformBy(boolean reverseTransform,
		JgclCartesianTransformationOperator2D transformationOperator,
		java.util.Hashtable transformedGeometries)
    {
	if (transformedGeometries == null)
	    return this.doTransformBy(reverseTransform,
				      transformationOperator,
				      transformedGeometries);

	JgclParametricCurve2D transformed = (JgclParametricCurve2D)transformedGeometries.get(this);
	if (transformed == null) {
	    transformed = this.doTransformBy(reverseTransform,
					     transformationOperator,
					     transformedGeometries);
	    transformedGeometries.put(this, transformed);
	}
	return transformed;
    }

    /**
     * ̋ȐA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    public synchronized JgclParametricCurve2D
    transformBy(JgclCartesianTransformationOperator2D transformationOperator,
		java.util.Hashtable transformedGeometries)
    {
	return transformBy(false, transformationOperator, transformedGeometries);
    }

    /**
     * ̋ȐA^ꂽ􉽓IϊZqŋtϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŋtϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŋtϊ̂ԂB
     * </p>
     *
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	tϊ̊􉽗vf
     */
    public synchronized JgclParametricCurve2D
    reverseTransformBy(JgclCartesianTransformationOperator2D transformationOperator,
		       java.util.Hashtable transformedGeometries)
    {
	return transformBy(true, transformationOperator, transformedGeometries);
    }

    /**
     * ̋Ȑ|C̕܂ނۂԂB
     * <p>
     * ʂ true ̏ꍇA
     * ̋Ȑ {@link JgclBoundedCurve2D JgclBoundedCurve2D} ł͂łB
     * </p>
     *
     * @return	̋Ȑ|Cł邩A
     *		܂͎g\镔iƂă|C܂ނȂ trueA
     *		łȂ false
     */
    protected boolean hasPolyline() {
	return false;
    }

    /**
     * ̋Ȑ|C̕łłĂ邩ۂԂB
     * <p>
     * ʂ true ̏ꍇA
     * ̋Ȑ {@link JgclBoundedCurve2D JgclBoundedCurve2D} ł͂łB
     * </p>
     *
     * @return	̋Ȑ|Cł邩A
     *		܂͎g\镔iƂă|C܂ނȂ trueA
     *		łȂ false
     */
    protected boolean isComposedOfOnlyPolylines() {
	return false;
    }
}

