/*
 * package private $B$N%a%=%C%I$r%F%9%H$9$k$?$a$N%/%i%9(B
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclPackageTest.java,v 1.3 2000/04/26 09:39:12 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Vector;
import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * package private $B$N%a%=%C%I$r%F%9%H$9$k$?$a$N%/%i%9(B
 *
 * @version $Revision: 1.3 $, $Date: 2000/04/26 09:39:12 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclPackageTest {

    public JgclPackageTest() {
	super();
    }

    /**
     * $B%F%9%H$N7k2L$,(B true $B$J$i(B "OK" $B$r(B false $B$J$i(B "NG" $B$rI=<($9$k(B 
     *
     * @param result	$B%F%9%H7k2L(B
     */
    private void resultPrint(boolean result) {
	if (result) {
	    System.out.println("OK.");
	} else {
	    System.out.println("NG.");
	}
    }

    /*************************************************************************
     *
     * JgclPointOnPoint1D.coordinates()
     *
     *************************************************************************/

    /*
     * JgclPointOnPoint1D.coordinates()
     *
     * @param point $B%F%9%HMQ$NE@$N%$%s%9%?%s%9(B
     */
    public JgclPoint1D coordinatesPointOnPoint1D(JgclPointOnPoint1D point) {
	return point.coordinates();
    }

    /*************************************************************************
     *
     * JgclPoint2D
     *
     *************************************************************************/

    /*
     * Test 2.2.59 - 60 $B$N%F%9%H(B
     * (JgclPoint2D $B$N(B package private method $B$N%F%9%H(B)
     *
     * @param point $B%F%9%HMQ$NE@%$%s%9%?%s%9(B
     */
    public void test2_2_59to60(JgclPoint2D point) {
	JgclPoint2D orig = point;

	/*
	 * 2.2.59 to3D() $B$N%F%9%H(B(3D$B2=(B)
	 *
	 * [$B%F%9%H9`L\(B] $B%a%=%C%I$r<B9T$7!"(Bxy$BJ?LL$K<M1F$7$?(B2$B<!85$NE@$r(B
	 *              $BJV$9$3$H$r3NG'$9$k!#(B
	 */
	System.out.print("// Test 2.2.59 : ");
	JgclPoint3D p1 = orig.to3D();
	JgclPoint3D p2 = orig.to3D(0);
	JgclPoint3D p3 = orig.to3D(100);
	resultPrint(p1 instanceof JgclPoint3D && p2 instanceof JgclPoint3D &&
		    p3 instanceof JgclPoint3D &&
		    orig.x() == p1.x() && orig.x() == p2.x() &&
		    orig.x() == p3.x() && orig.y() == p1.y() &&
		    orig.y() == p2.y() && orig.y() == p3.y() &&
		    p1.z() == 0 && p2.z() == 0 && p3.z() == 100);

	/*
	 * 2.2.60 literal() $B$N%F%9%H(B(JgclCartesianPoint2D $B$X$N%*%V%8%'%/%HJQ49(B)
	 *
	 * [$B%F%9%H9`L\(B] JgclCartesianPoint2D $B$N%*%V%8%'%/%H$KJQ49$5$l$?E@$r(B
	 *              $BJV$9$3$H$r3NG'$9$k!#(B
	 */
	System.out.print("// Test 2.2.60 : ");
	resultPrint(orig.literal() instanceof JgclCartesianPoint2D);
    }


    /*************************************************************************
     *
     * JgclPointOnPoint2D.coordinates()
     * JgclPointOnCurve2D.coordinates()
     *
     *************************************************************************/

    /*
     * JgclPointOnPoint2D.coordinates()
     *
     * @param point $B%F%9%HMQ$NE@$N%$%s%9%?%s%9(B
     */
    public JgclPoint2D coordinatesPointOnPoint2D(JgclPointOnPoint2D point) {
	return point.coordinates();
    }

    /*
     * JgclPointOnCurve2D.coordinates()
     *
     * @param point $B%F%9%HMQ$NE@$N%$%s%9%?%s%9(B
     */
    public JgclPoint2D coordinatesPointOnCurve2D(JgclPointOnCurve2D point) {
	return point.coordinates();
    }

    /*************************************************************************
     *
     * JgclIntersectionPoint2D
     *
     *************************************************************************/

    /**
     * JgclIntersectionPoint2D $B$N%*%V%8%'%/%H@8@.$N%F%9%HMQ4X?t(B
     * (Test 2.2.04($B@5>o%1!<%9(B), 2.2.64 $B$K;HMQ(B)
     *
     * $B0J2<$N%F%9%HMQ$NE@$NG[Ns$rJV$9!#(B
     *
     *    point[0-1] : Test 2.3.04 $BMQ%$%s%9%?%s%9(B
     *    point[2-4] : Test 2.3.64 $BMQ%$%s%9%?%s%9(B
     *
     * @return $B8rE@$NG[Ns(B
     */
    public JgclPoint2D[] intersectionPoint2DCreateTestNormal() {
        JgclCartesianPoint2D coord;
	JgclLine2D[] line = new JgclLine2D[2];
	JgclPointOnCurve2D[] pocs = new JgclPointOnCurve2D[2];
        JgclIntersectionPoint2D[] points = new JgclIntersectionPoint2D[5];

	coord = JgclPoint2D.of(1, 2);
	line[0] = new JgclLine2D(JgclPoint2D.of(0, 2), JgclVector2D.of(1, 0));
	line[1] = new JgclLine2D(JgclPoint2D.of(1, 0), JgclVector2D.of(0, 1));
	pocs[0] = new JgclPointOnCurve2D(line[0], 1);
	pocs[1] = new JgclPointOnCurve2D(line[1], 2);

	// Test 2.2.4 $B7A>uMWAG(B x $B7A>uMWAG!"(Bcoordinates$B$"$j(B (1)
	points[0] = new JgclIntersectionPoint2D(coord, pocs[0], pocs[1], true);

	// Test 2.2.64 $B7A>uMWAG(B x $B7A>uMWAG!"(Bcoordinates$B$J$7(B
	points[2] = new JgclIntersectionPoint2D(pocs[0], pocs[1], true);

	// Test 2.2.64 $B@~(B x $B@~!"(Bcoordinates$B$"$j(B
	points[3] = new JgclIntersectionPoint2D(coord, line[0], 1, line[1], 2, true);
	// Test 2.2.64 $B@~(B x $B@~!"(Bcoordinates$B$J$7(B
	points[4] = new JgclIntersectionPoint2D(line[0], 1, line[1], 2, true);

	// Test 2.2.4 $B7A>uMWAG(B x $B7A>uMWAG!"(Bcoordinates$B$"$j(B (2)
	// ($BB>$N%F%9%HMQ%$%s%9%?%s%9(B)
        coord = JgclPoint2D.of(100, 100);
        pocs[0] = new JgclPointOnCurve2D(new JgclCircle2D(JgclPoint2D.of(0, 100), 100), 0);
	pocs[1] = new JgclPointOnCurve2D(new JgclCircle2D(JgclPoint2D.of(90, 100), 10), 0);
	points[1] = new JgclIntersectionPoint2D(coord, pocs[0], pocs[1], true);

	return points;
    }

    /**
     * JgclIntersectionPoint2D $B$N%*%V%8%'%/%H@8@.$N%F%9%HMQ4X?t(B
     * (Test 2.2.04 $B%(%i!<%1!<%9$K;HMQ(B)
     *
     * @return $BA4$F$N%F%9%H%1!<%9$GNc30$,JV$5$l$?>l9g$O(B true $B$r!"(B
     *         $B$$$:$l$+%F%9%H%1!<%9$G%*%V%8%'%/%H$,@8@.$5$l$?>l9g$O(B
     *         false $B$rJV$9!#(B
     */
    public boolean intersectionPoint2DCreateTestError() {
        JgclCartesianPoint2D coord;
	JgclLine2D[] line = new JgclLine2D[2];
	JgclPointOnCurve2D[] pocs = new JgclPointOnCurve2D[2];
        JgclIntersectionPoint2D[] points = new JgclIntersectionPoint2D[5];

	coord = JgclPoint2D.of(1, 2);
	line[0] = new JgclLine2D(JgclPoint2D.of(0, 2), JgclVector2D.of(1, 0));
	line[1] = new JgclLine2D(JgclPoint2D.of(1, 0), JgclVector2D.of(0, 1));
	pocs[0] = new JgclPointOnCurve2D(line[0], 1);
	pocs[1] = new JgclPointOnCurve2D(line[1], 2);

	JgclIntersectionPoint2D point;
	boolean flag = true;

	// coordinates $B$,8rE@$GL5$$(B
        coord = new JgclCartesianPoint2D(1 + 1, 2 + 1);
	try {
	    point = new JgclIntersectionPoint2D(coord, pocs[0], pocs[1], true);
	    flag &= false;
	} catch (JgclInvalidArgumentValue e) {
	    flag &= true;
	}

	// coordinates $B$,8rE@$H5wN%$N5vMF8m:9$N(B2$BG\N%$l$F$$$k(B
	double tol = coord.getToleranceForDistance();
        coord = new JgclCartesianPoint2D(1 + (tol * 2), 2);
	try {
	    point = new JgclIntersectionPoint2D(coord, pocs[0], pocs[1], true);
	    flag &= false;
	} catch (JgclInvalidArgumentValue e) {
	    flag &= true;
	}

	// coordinates $B$,(B null
	try {
	    point = new JgclIntersectionPoint2D(null, pocs[0], pocs[1], true);
	    flag &= false;
	} catch (java.lang.NullPointerException e) {
	    flag &= true;
	}

	// pointOnGeometry1 $B$,(B null
        coord = new JgclCartesianPoint2D(1, 2);
	try {
	    point = new JgclIntersectionPoint2D(coord, null, pocs[1], true);
	    flag &= false;
	} catch (java.lang.NullPointerException e) {
	    flag &= true;
	}

	// pointOnGeometry2 $B$,(B null
	try {
	    point = new JgclIntersectionPoint2D(coord, pocs[0], null, true);
	    flag &= false;
	} catch (java.lang.NullPointerException e) {
	    flag &= true;
	}

	return flag;
    }


    /*************************************************************************
     *
     * JgclPoint3D
     *
     *************************************************************************/

    /*
     * 2.3.57 rotateZ() $B$N%F%9%H(B($B2sE>$5$;$?E@(B)
     *
     * @param point $B%F%9%HMQ$NE@$N%$%s%9%?%s%9(B
     */
    private void test2_3_57(JgclPoint3D point) {
	JgclAxis2Placement3D axis =
	    new JgclAxis2Placement3D(JgclPoint3D.origin,
				     JgclVector3D.zUnitVector,
				     JgclVector3D.xUnitVector);
	JgclCartesianTransformationOperator3D trans =
	    new JgclCartesianTransformationOperator3D(axis, 1.0);

	System.out.print("// Test 2.2.57 : ");
 	resultPrint(point.rotateZ(trans, 0.0, 1.0).
		    identical(JgclPoint3D.of(-2, 1, 3)));
	System.out.println();
    }

    /*
     * 2.2.58 to2D() $B$N%F%9%H(B(2D$B2=(B)
     *
     * @param point $B%F%9%HMQ$NE@$N%$%s%9%?%s%9(B
     */
    private void test2_3_58(JgclPoint3D point) {
	System.out.print("// Test 2.2.58 : ");
	JgclPoint2D p1 = point.to2D();
	JgclPoint2D p2 = point.to2D();
	resultPrint(p1 instanceof JgclPoint2D && p2 instanceof JgclPoint2D &&
		    point.x() == p1.x() && point.x() == p2.x() &&
		    point.y() == p1.y() && point.y() == p2.y());
    }

    /*
     * 2.2.59 literal() $B$N%F%9%H(B(JgclCartesianPoint2D $B$X$N%*%V%8%'%/%HJQ49(B)
     *
     * @param point $B%F%9%HMQ$NE@$N%$%s%9%?%s%9(B
     */
    private void test2_3_59(JgclPoint3D point) {
	System.out.print("// Test 2.2.59 : ");
	resultPrint(point.literal() instanceof JgclCartesianPoint3D);
    }

    /*
     * Test 2.3.57 - 59
     *
     * @param point $B%F%9%HMQ$NE@$N%$%s%9%?%s%9(B
     */
    public void test2_3_57to59(JgclPoint3D point) {
	test2_3_57(point);
	test2_3_58(point);
	test2_3_59(point);
    }

    /*************************************************************************
     *
     * JgclPointOnPoint3D.coordinates()
     * JgclPointOnCurve3D.coordinates()
     * JgclPointOnSurface3D.coordinates()
     *
     *************************************************************************/

    /*
     * JgclPointOnPoint3D.coordinates()
     *
     * @param point $B%F%9%HMQ$NE@$N%$%s%9%?%s%9(B
     */
    public JgclPoint3D coordinatesPointOnPoint3D(JgclPointOnPoint3D point) {
	return point.coordinates();
    }

    /*
     * JgclPointOnCurve3D.coordinates()
     *
     * @param point $B%F%9%HMQ$NE@$N%$%s%9%?%s%9(B
     */
    public JgclPoint3D coordinatesPointOnCurve3D(JgclPointOnCurve3D point) {
	return point.coordinates();
    }

    /*
     * PointOnSurface3D.coordinates()
     *
     * @param point $B%F%9%HMQ$NE@$N%$%s%9%?%s%9(B
     */
    public JgclPoint3D coordinatesPointOnSurface3D(JgclPointOnSurface3D point) {
	return point.coordinates();
    }

    /*************************************************************************
     *
     * JgclIntersectionPoint3D
     *
     *************************************************************************/

    /**
     * JgclIntersectionPoint3D $B$N%*%V%8%'%/%H@8@.$N%F%9%HMQ4X?t(B
     * (Test 2.3.04($B@5>o%1!<%9(B), 2.3.65 $B$K;HMQ(B)
     * 
     *    point[0-1]  : Test 2.3.04 $BMQ%$%s%9%?%s%9(B
     *    point[2-10] : Test 2.3.65 $BMQ%$%s%9%?%s%9(B
     *
     * @return $B8rE@$NG[Ns(B
     */
    public static JgclPoint3D[] intersectionPoint3DCreateTestNormal() {
	JgclCartesianPoint3D coord;
	JgclLine3D[] line = new JgclLine3D[2];
        JgclPointOnCurve3D[] pocs = new JgclPointOnCurve3D[2];
        JgclIntersectionPoint3D[] points = new JgclIntersectionPoint3D[11];
        JgclIntersectionPoint3D point;

	coord = JgclPoint3D.of(1, 2, 3);
	line[0] = new JgclLine3D(JgclPoint3D.of(0, 2, 3),
				 JgclVector3D.of(1, 0, 0));
	line[1] = new JgclLine3D(JgclPoint3D.of(1, 0, 3),
				 JgclVector3D.of(0, 1, 0));
	pocs[0] = new JgclPointOnCurve3D(line[0], 1);
	pocs[1] = new JgclPointOnCurve3D(line[1], 2);

	// Test 2.3.04 $B7A>uMWAG(B vs $B7A>uMWAG!"(Bcoordinates$B$"$j(B (1)
	points[0] = new JgclIntersectionPoint3D(coord, pocs[0], pocs[1], true);
	System.out.println("//\t [case 1: geometry vs geometry, coordinates]");
	System.out.println("//\t points[0] = ");
	points[0].output(System.out);


	// Test 2.3.65 $B7A>uMWAG(B vs $B7A>uMWAG!"(Bcoordinates$B$J$7(B
	points[2] = new JgclIntersectionPoint3D(pocs[0], pocs[1], true);
	System.out.println("//\t [case 2: geometry vs geometry, no coordinates]");
	System.out.println("//\t points[2] = ");
	points[2].output(System.out);


	// Test 2.3.65 $B@~(B vs $B@~!"(Bcoordinates$B$"$j(B
	points[3] = new JgclIntersectionPoint3D(coord, line[0], 1, line[1], 2, true);
	System.out.println("//\t [case 3: line vs line, coordinates]");
	System.out.println("//\t points[3] = ");
	points[3].output(System.out);


	// Test 2.3.65 $B@~(B vs $B@~!"(Bcoordinates$B$J$7(B
	points[4] = new JgclIntersectionPoint3D(line[0], 1, line[1], 2, true);
	System.out.println("//\t [case 4: line vs line, no coordinates]");
	System.out.println("//\t points[4] = ");
	points[4].output(System.out);


	// Test 2.3.65 $B@~(B vs $BLL!"(Bcoordinates$B$"$j(B */
	JgclPlane3D plane = new JgclPlane3D(JgclPoint3D.origin, JgclVector3D.xUnitVector);
	coord = JgclPoint3D.of(0, 2, 3);
	points[5] = new JgclIntersectionPoint3D(coord, line[0], 0, plane, 3, -2, true);
	System.out.println("//\t [case 5: line vs surface, coordinates]");
	System.out.println("//\t points[5] = ");
	points[5].output(System.out);


	// Test 2.3.65 $B@~(B vs $BLL!"(Bcoordinates$B$J$7(B */
	points[6] = new JgclIntersectionPoint3D(line[0], 0, plane, 3, -2, true);
	System.out.println("//\t [case 6: line vs surface, no coordinates]");
	System.out.println("//\t points[6] = ");
	points[6].output(System.out);


	// Test 2.3.65 $BLL(B vs $B@~!"(Bcoordinates$B$"$j(B */
	points[7] = new JgclIntersectionPoint3D(coord, plane, 3, -2, line[0], 0, true);
	System.out.println("//\t [case 7: surface vs line, coordinates]");
	System.out.println("//\t points[7] = ");
	points[7].output(System.out);


	// Test 2.3.65 $BLL(B vs $B@~!"(Bcoordinates$B$J$7(B */
	points[8] = new JgclIntersectionPoint3D(plane, 3, -2, line[0], 0, true);
	System.out.println("//\t [case 8: surface vs line, no coordinates]");
	System.out.println("//\t points[8] = ");
	points[8].output(System.out);


	// Test 2.3.65 $BLL(B vs $BLL!"(Bcoordinates$B$"$j(B */
	JgclPlane3D plane2 = new JgclPlane3D(JgclPoint3D.origin,
					     JgclVector3D.yUnitVector);
	points[9] = new JgclIntersectionPoint3D(JgclPoint3D.origin,
						plane,  0, 0,
						plane2, 0, 0, true);
	System.out.println("//\t [case 9: surface vs surface, coordinates]");
	System.out.println("//\t points[9] = ");
	points[9].output(System.out);


	// Test 2.3.65 $BLL(B vs $BLL!"(Bcoordinates$B$J$7(B */
	points[10] = new JgclIntersectionPoint3D(plane,  0, 0,
						 plane2, 0, 0, true);
	System.out.println("//\t [case 10: surface vs surface, no coordinates]");
	System.out.println("//\t points[10] = ");
	points[10].output(System.out);


	// Test 2.2.04 $B7A>uMWAG(B vs $B7A>uMWAG!"(Bcoordinates$B$"$j(B (2)
	// ($BB>$N%F%9%HMQ%$%s%9%?%s%9(B)
	JgclCircle3D circle1 =
	    new JgclCircle3D(new JgclAxis2Placement3D(JgclPoint3D.of(0, 100, 100),
						      JgclVector3D.zUnitVector,
						      JgclVector3D.xUnitVector),
			     100);

	JgclCircle3D circle2 =
	    new JgclCircle3D(new JgclAxis2Placement3D(JgclPoint3D.of(90, 100, 100),
						      JgclVector3D.zUnitVector,
						      JgclVector3D.xUnitVector),
			     10);

        pocs[0] = new JgclPointOnCurve3D(circle1, 0);
	pocs[1] = new JgclPointOnCurve3D(circle2, 0);
	points[1] = new JgclIntersectionPoint3D(JgclPoint3D.of(100, 100, 100),
						pocs[0], pocs[1], true);

	return points;
    }

    /**
     * JgclIntersectionPoint3D $B$N%*%V%8%'%/%H@8@.$N%F%9%HMQ4X?t(B
     * (Test 2.3.04 $B%(%i!<%1!<%9(B $B$K;HMQ(B)
     *
     * @return $BA4$F$N%F%9%H%1!<%9$GNc30$,JV$5$l$?>l9g$O(B true $B$r!"(B
     *         $B$$$:$l$+%F%9%H%1!<%9$G%*%V%8%'%/%H$,@8@.$5$l$?>l9g$O(B
     *         false $B$rJV$9!#(B
     */
    public static boolean intersectionPoint3DCreateTestError() {
	JgclCartesianPoint3D coord;
	JgclLine3D[] line = new JgclLine3D[2];
        JgclPointOnCurve3D[] pocs = new JgclPointOnCurve3D[2];
        JgclIntersectionPoint3D point;

	coord = JgclPoint3D.of(1, 2, 3);
	line[0] = new JgclLine3D(JgclPoint3D.of(0, 2, 3),
				 JgclVector3D.of(1, 0, 0));
	line[1] = new JgclLine3D(JgclPoint3D.of(1, 0, 3),
				 JgclVector3D.of(0, 1, 0));
	pocs[0] = new JgclPointOnCurve3D(line[0], 1);
	pocs[1] = new JgclPointOnCurve3D(line[1], 2);
	boolean flag = true;

	// coordinates $B$,8rE@$GL5$$(B
        coord = new JgclCartesianPoint3D(1 + 1, 2 + 1, 3);
	try {
	    point = new JgclIntersectionPoint3D(coord, pocs[0], pocs[1], true);
	    flag &= false;
	} catch (JgclInvalidArgumentValue e) {
	    flag &= true;
	}

	// coordinates $B$,8rE@$H5wN%$N5vMF8m:9$N(B2$BG\N%$l$F$$$k(B
	double tol = coord.getToleranceForDistance();
        coord = new JgclCartesianPoint3D(1 + (tol * 2), 2, 3);
	try {
	    point = new JgclIntersectionPoint3D(coord, pocs[0], pocs[1], true);
	    flag &= false;
	} catch (JgclInvalidArgumentValue e) {
	    flag &= true;
	}

	// coordinates $B$,(B null
	try {
	    point = new JgclIntersectionPoint3D(null, pocs[0], pocs[1], true);
	    flag &= false;
	} catch (java.lang.NullPointerException e) {
	    flag &= true;
	}

	// pointOnGeometry1 $B$,(B null
        coord = new JgclCartesianPoint3D(1, 2, 3);
	try {
	    point = new JgclIntersectionPoint3D(coord, null, pocs[1], true);
	    flag &= false;
	} catch (java.lang.NullPointerException e) {
	    flag &= true;
	}

	// pointOnGeometry2 $B$,(B null
	try {
	    point = new JgclIntersectionPoint3D(coord, pocs[0], null, true);
	    flag &= false;
	} catch (java.lang.NullPointerException e) {
	    flag &= true;
	}

	return flag;
    }

    /*************************************************************************
     *
     * JgclParametricSurface3D
     *
     *************************************************************************/

    /**
     *  Test 5.1.53
     */
    public int type(JgclParametricSurface3D surface){
	return surface.type();
    }

    /*************************************************************************
     *
     * JgclCylindricalSurface3D
     *
     *************************************************************************/

    /**
     *  Test 5.1.57
     */
    public void cylinderTest() {
	JgclCylindricalSurface3D cylA =
	    new JgclCylindricalSurface3D(JgclPoint3D.origin,
					 JgclVector3D.zUnitVector, 1.0);

	JgclCylindricalSurface3D cylB =
	    new JgclCylindricalSurface3D(JgclPoint3D.origin,
					 JgclVector3D.xUnitVector, 2.0);
	// Test 5.1.57.1 equals() $B$N%F%9%H(B
	System.out.print("// Test 5.1.57.1 : ");
	resultPrint(cylA.equals(cylA) && !cylA.equals(cylB));

	// Test 5.1.57.2 getAxis() $B$N%F%9%H(B
	System.out.print("// Test 5.1.57.2 : ");
	resultPrint(JgclPoint3D.origin.isOn(cylA.getAxis()) &&
		    cylA.getAxis().dir().
		    identicalDirection(JgclVector3D.zUnitVector));
    }

    /*************************************************************************
     *
     * JgclConicalSurface3D
     *
     *************************************************************************/

    /**
     *  Test 5.1.58
     */
    public void coneTest() {
	JgclConicalSurface3D cone =
	    new JgclConicalSurface3D(JgclPoint3D.of(0.0, 0.0, 1.0),
				     JgclVector3D.zUnitVector,
				     1.0, 0.7853981633974483);

	// Test 5.1.58.1 apex() $B$N%F%9%H(B
	System.out.print("// Test 5.1.58.1 : ");
	resultPrint(cone.apex().identical(JgclPoint3D.origin));

	// Test 5.1.58.2 getAxis() $B$N%F%9%H(B
	System.out.print("// Test 5.1.58.2 : ");
	resultPrint(JgclPoint3D.of(0.0, 0.0, 1.0).isOn(cone.getAxis()) &&
		    cone.getAxis().dir().
		    identicalDirection(JgclVector3D.zUnitVector));
    }
}
