/*
 * Object ̉ϒꎟz\NX (java.util.Vector ̑)
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclObjectVector.java,v 1.6 2000/04/26 09:39:09 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * Object ̉ϒꎟz\NXB
 * <p>
 * java.util.Vector ̑ցB
 * </p>
 *
 * @version $Revision: 1.6 $, $Date: 2000/04/26 09:39:09 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclObjectVector {
    /**
     * ۂ Vector B
     *
     * @see	Vector
     */
    private Vector vec;

    /**
     * Ȃɂ^ɃIuWFNg\zB
     */
    public JgclObjectVector() {
	vec = new Vector();
    }

    /**
     * ̉ϒz̓eA^ꂽzɃRs[B
     * 
     * @param anArray	Rs[̔z
     */
    public final void copyInto(Object anArray[]) {
	vec.copyInto(anArray);
    }

    /**
     * ̉ϒz̒ (vf̐) ԂB
     * 
     * @return	 (vf̐)
     */
    public final int size() {
	return vec.size();
    }

    /**
     * ̉ϒzɗvf邩ǂԂB
     * 
     * @return	vf trueAȂ false
     */
    public final boolean isEmpty() {
	return vec.size() == 0;
    }

    /**
     * ̉ϒz̗vf Enumeration ԂB
     * 
     * @return	̉ϒz̗vf Enumeration
     */
    public final Enumeration elements() {
	return new Cursor();
    }

    /**
     * ̉ϒz̗vf Cursor ԂB
     * 
     * @return	̉ϒz̗vf Cursor
     */
    public final JgclCursor cursor() {
	return new Cursor();
    }

    /**
     * ̉ϒz񂪗^ꂽIuWFNg܂ނۂ𒲂ׂB
     * <p>
     * ̉ϒz index ȍ~̗vfɂāAŏɌ elem ̃CfbNXԂB
     * elem ݂Ȃ (- 1) ԂB
     * </p>
     * 
     * @param elem	ׂIuWFNg
     * @param index	JnCfbNX
     * @return		ŏɂ݂ elem ̃CfbNX
     */
    public final int indexOf(Object elem, int index) {
	return vec.indexOf(elem, index);
    }

    /**
     * ̉ϒz񂪗^ꂽIuWFNg܂ނۂ𒲂ׂB
     * <p>
     * ̉ϒz index ȑO̗vfɂāAŌɌ elem ̃CfbNXԂB
     * elem ݂Ȃ (- 1) ԂB
     * </p>
     * 
     * @param elem	ׂIuWFNg
     * @param index	JnCfbNX
     * @return		Ōɂ݂ elem ̃CfbNX
     */
    public final int lastIndexOf(Object elem, int index) {
	return vec.lastIndexOf(elem, index);
    }

    /**
     * ̉ϒz index Ԗڂ̗vfԂB
     * 
     * @param index	Ԃvf̃CfbNX
     * @return	index Ԗڂ̗vf
     */
    public final Object elementAt(int index) {
	return vec.elementAt(index);
    }

    /**
     * ^ꂽIuWFNgẢϒz index Ԗڂ̗vfƂĐݒ肷B
     * 
     * @param index	ݒ肷vf̃CfbNX
     * @param obj	vfɐݒ肷IuWFNg
     */
    public final void setElementAt(Object obj, int index) {
	vec.setElementAt(obj, index);
    }

    /**
     * ̉ϒz index Ԗڂ̗vf폜B
     * 
     * @param index	폜vf̃CfbNX
     */
    public final void removeElementAt(int index) {
	vec.removeElementAt(index);
    }

    /**
     * ̉ϒz index Ԗڂ̗vf̑OɐVvf}B
     * 
     * @param index	̑Oɗvf}vf̃CfbNX
     * @param obj	Vȗvfɐݒ肷IuWFNg
     */
    public final void insertElementAt(Object obj, int index) {
	vec.insertElementAt(obj, index);
    }

    /**
     * ̉ϒz̍ŌɐVvfǉB
     * 
     * @param obj	Vȗvfɐݒ肷IuWFNg
     */
    public final void addElement(Object obj) {
	vec.addElement(obj);
    }

    /**
     * ̉ϒz̑SĂ̗vf폜B
     */
    public final void removeAllElements() {
	vec.removeAllElements();
    }

    /**
     * ̉ϒz𕡐B
     */
    public Object clone() {
	try {
	    JgclObjectVector newvec = (JgclObjectVector) super.clone();
	    newvec.vec = (Vector)vec.clone();
	    return newvec;
	}
	catch (CloneNotSupportedException e) {
	    throw new InternalError();
	}
    }

    /**
     * ̉ϒz𕶎ɕϊB
     * 
     * @return	̉ϒz\
     */
    public final String toString() {
	return vec.toString();
    }

    /**
     * JgclCursor NXB
     */
    class Cursor implements JgclCursor {
	/**
	 * cursor ݂̌̈ʒuB
	 */
	int index;

	/**
	 * cursor 擪ɂăIuWFNg\zB
	 */
	Cursor() {
	    index = 0;
	}

	/**
	 * cursor ̗̎vfԂAindex i߂B
	 * <p>
	 * peekNextElement() + gotoNext() Ɠl̏B
	 * </p>
	 *
	 * @return ̗vf
	 */
	public Object nextElement() {
	    synchronized (vec) {
		return vec.elementAt(index++);
	    }
	}

	/**
	 * cursor ̗̎vf邩ǂԂB
	 *
	 * @return	vf trueAȂ false
	 */
	public boolean hasMoreElements() {
	    return index < vec.size();
	}

	/**
	 * cursor ̗̎vf邩ǂԂB
	 * <p>
	 * {@link #hasMoreElements() hasMoreElements()} ̕ʖB
	 * </p>
	 *
	 * @return	vf trueAȂ false
	 */
	public boolean hasNextElements() {
	    return index < vec.size();
	}

	/**
	 * cursor ̑Oɗvf邩ǂԂB
	 *
	 * @return	vf trueAȂ false
	 */
	public boolean hasPrevElements() {
	    return 0 < index;
	}

	/**
	 * cursor ̗̎vfԂB
	 *
	 * @return ̗vf
	 */
	public Object peekNextElement() {
	    return vec.elementAt(index);
	}

	/**
	 * cursor 擪ɈړB
	 */
	public void gotoHead() {
	    index = 0;
	}

	/**
	 * cursor I[ɈړB
	 */
	public void gotoTail() {
	    index = vec.size();
	}

	/**
	 * cursor  n ɈړB
	 *
	 * @param	n ړ鐔
	 */
	public void gotoNext(int n) {
	    synchronized (this) {
		if (index + n > vec.size()) {
		    throw new NoSuchElementException();
		}
		index += n;
	    }
	}

	/**
	 * cursor ɈړB
	 */
	public void gotoNext() {
	    gotoNext(1);
	}

	/**
	 * cursor  n OɈړB
	 *
	 * @param	n ړ鐔
	 */
	public void gotoPrev(int n) {
	    synchronized (this) {
		if (index - n < 0) {
		    throw new NoSuchElementException();
		}
		index -= n;
	    }
	}

	/**
	 * cursor OɈړB
	 */
	public void gotoPrev() {
	    gotoPrev(1);
	}

	/**
	 * cursor ̗̎vf폜B
	 */
	public void removeNextElement() {
	    synchronized (this) {
		if (index >= vec.size() || index < 0) {
		    throw new NoSuchElementException();
		}
		vec.removeElementAt(index);
	    }
	}

	/**
	 * cursor ̑O̗vf폜B
	 */
	public void removePrevElement() {
	    synchronized (this) {
		if (index > vec.size() || index <= 0) {
		    throw new NoSuchElementException();
		}
		vec.removeElementAt(--index);
	    }
	}

	/**
	 * cursor ̗̎vf obj ɐݒ肷B
	 *
	 * @param	obj ݒ肷vf
	 */
	public void setNextElement(Object obj) {
	    synchronized (this) {
		if (index >= vec.size() || index < 0) {
		    throw new NoSuchElementException();
		}
		vec.setElementAt(obj, index);
	    }
	}

	/**
	 * cursor ̎ɗvf obj }B
	 *
	 * @param	obj }vf
	 */
	public void insertAfter(Object obj) {
	    vec.insertElementAt(obj, index);
	}

	/**
	 * cursor ̑Oɗvf obj }B
	 *
	 * @param	obj }vf
	 */
	public void insertBefore(Object obj) {
	    vec.insertElementAt(obj, index++);
	}
    }
}

/* end of file */
