/*
 * wIȉZse static \bhNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclMath.java,v 1.16 2000/08/11 06:18:53 shikano Exp $
 */

package jp.go.ipa.jgcl;

/**
 * wIȉZse static \bhNXB
 *
 * @version $Revision: 1.16 $, $Date: 2000/08/11 06:18:53 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclMath extends java.lang.Object {
    /**
     * ̃NX̃CX^X͍Ȃ
     */
    private JgclMath() {
    }

    /**
     * 萔 (2 * ) B
     */
    static final double PI2 = Math.PI * 2.0;

    /**
     * ϐ̎֐̒ϕp̒萔B
     */
    private static final int maxNumberOfDividing = 608;

    /**
     * ϐ̎֐̒ϕ\bh
     * {@link #getDefiniteIntegral(JgclRealFunctionWithOneVariable, JgclParameterSection, double)
     * getDefiniteIntegral(JgclRealFunctionWithOneVariable, JgclParameterSection, double)}
     * ŗp萔B
     */
    private static final int powerNumber = 6;

    /**
     * ϐ̎֐̒ϕ\bh
     * {@link #getDefiniteIntegral(JgclRealFunctionWithOneVariable, JgclParameterSection, double)
     * getDefiniteIntegral(JgclRealFunctionWithOneVariable, JgclParameterSection, double)}
     * ŗp萔B
     */
    private static final double minimumTolerance = 1.0e-32;

    /**
     * ϐ̎֐̒ϕ\bh
     * {@link #getDefiniteIntegral(JgclRealFunctionWithOneVariable, JgclParameterSection, double)
     * getDefiniteIntegral(JgclRealFunctionWithOneVariable, JgclParameterSection, double)}
     * ŗp萔B
     */
    private static final double zeroDividePoint = 0.0;

    /**
     * ϐ̎֐̒ϕ\bh
     * {@link #getDefiniteIntegral(JgclRealFunctionWithOneVariable, JgclParameterSection, double)
     * getDefiniteIntegral(JgclRealFunctionWithOneVariable, JgclParameterSection, double)}
     * ŗp萔B
     */
    private static final double zeroWeight = Math.PI / 2.0;

    /**
     * ϐ̎֐̒ϕ\bh
     * {@link #getDefiniteIntegral(JgclRealFunctionWithOneVariable, JgclParameterSection, double)
     * getDefiniteIntegral(JgclRealFunctionWithOneVariable, JgclParameterSection, double)}
     * ŗp萔B
     */
    private static final double[] minusDividePoints = new double[maxNumberOfDividing];

    /**
     * ϐ̎֐̒ϕ\bh
     * {@link #getDefiniteIntegral(JgclRealFunctionWithOneVariable, JgclParameterSection, double)
     * getDefiniteIntegral(JgclRealFunctionWithOneVariable, JgclParameterSection, double)}
     * ŗp萔B
     */
    private static final double[] plusDividePoints = new double[maxNumberOfDividing];

    /**
     * ϐ̎֐̒ϕ\bh
     * {@link #getDefiniteIntegral(JgclRealFunctionWithOneVariable, JgclParameterSection, double)
     * getDefiniteIntegral(JgclRealFunctionWithOneVariable, JgclParameterSection, double)}
     * ŗp萔B
     */
    private static final double[] weights = new double[maxNumberOfDividing];

    /**
     * ϐ̎֐̒ϕ\bh
     * {@link #getDefiniteIntegral(JgclRealFunctionWithOneVariable, JgclParameterSection, double)
     * getDefiniteIntegral(JgclRealFunctionWithOneVariable, JgclParameterSection, double)}
     * ŗp萔B
     */
    private static boolean alreadyPrepared = false;

    /**
     * ϐ̎֐̒ϕ\bh
     * {@link #getDefiniteIntegral(JgclRealFunctionWithOneVariable, JgclParameterSection, double)
     * getDefiniteIntegral(JgclRealFunctionWithOneVariable, JgclParameterSection, double)}
     * ŗp萔ێ static tB[hɒlݒ肷B
     */
    private static void prepareDefiniteIntegralConstants() {
	if (alreadyPrepared == true)
	    return;

	alreadyPrepared = true;

	double almostOne = 0.9999999999999999;
	double halfPi = Math.PI / 2.0;
	double eeh = Math.exp(1.0 / Math.pow(2.0, (double)(powerNumber + 1)));

	double een = 1.0;
	double eenI;
	double esh;
	double ech;
	double exs;
	double exsI;
	double echsi;

	for (int i = 0; i < maxNumberOfDividing; i++) {
	    een *= eeh;
	    eenI = 1.0 / een;
	    esh = (een - eenI) / 2.0;
	    ech = (een + eenI) / 2.0;
	    exs = Math.exp(halfPi * esh);
	    exsI = 1.0 / exs;
	    echsi = 2.0 / (exs + exsI);

	    plusDividePoints[i] = ((exs - exsI) / 2.0) * echsi;
	    if (plusDividePoints[i] >= almostOne)
		plusDividePoints[i] = almostOne;
	    minusDividePoints[i] = - plusDividePoints[i];
	    weights[i] = halfPi * ech * Math.pow(echsi, 2.0);
	}
    }

    /**
     * ϐ̎֐̒ϕ߂B
     * <p>
     * ^ꂽϕ֐ func ̐ϕ parameterSection ɑ΂ϕlԂB
     * </p>
     * <p>
     * e덷l tolerance ɑ΂A
     * dw֐^lϕɂA
     * ̋e덷̌덷ϕ̋ߎlԂB
     * </p>
     * <p>
     * parameterSection ̑l͕ł\ȂA
     * parameterSection ̕\Ԃ func ̒`Ɏ܂ĂKvB
     * </p>
     * <p>
     * tolerance ́A̐Βl𗘗pB
     * </p>
     *
     * @param	func	ϐ̎֐
     * @param	parameterSection	ϕ͈̔
     * @param	tolerance	ϕʂɑ΂Ό덷̋el
     * @return	ϕl
     */
    public static double getDefiniteIntegral(JgclRealFunctionWithOneVariable func,
					     JgclParameterSection parameterSection,
					     double tolerance) {
	prepareDefiniteIntegralConstants();
	tolerance = (Math.abs(tolerance) > minimumTolerance) ? Math.abs(tolerance) : minimumTolerance;

	/*
	 * local variables
	 */
	double iterationTol = 0.2 * Math.sqrt(tolerance);	/* tolerance for iteration */
	double halfDiff = (parameterSection.upper() - parameterSection.lower()) / 2.0;
	double midParam = (parameterSection.upper() + parameterSection.lower()) / 2.0;
	double meshSize = 0.5;
	int startIndex = (int)Math.pow((double)2, (double)powerNumber);
	int indexInterval = startIndex;
	double minusCutoff;		/* cut off value of minus side */
	double plusCutoff;		/* cut off value of plus side */
	int minusCutoffNumber = 0;	/* number for cut off of minus side */
	int plusCutoffNumber = 0;	/* number for cut off of plus side */
	int commonCutoffNumber;		/* common number for cut off */
	int minusCutoffFlag = 0;	/* flag for cut off of minus side */
	int plusCutoffFlag = 0;		/* flag for cut off of plus side */
	double lastIntegral;		/* last integral */
	double currentIntegral;		/* current integral */
	int i, j;			/* loop counter */

	/*
	 * initial step : integrate with mesh size 0.5 and check decay of integrand
	 */
	currentIntegral = func.evaluate(zeroDividePoint * halfDiff + midParam) * zeroWeight;

	for (i = startIndex - 1; i < maxNumberOfDividing; i += indexInterval) {
	    if (minusCutoffFlag < 2) {
		minusCutoff = func.evaluate(minusDividePoints[i] * halfDiff + midParam) * weights[i];
		currentIntegral += minusCutoff;
		if (Math.abs(minusCutoff) <= tolerance) {
		    if (++minusCutoffFlag >= 2)
			minusCutoffNumber = (i + 1) - indexInterval;
		} else {
		    minusCutoffFlag = 0;
		}
	    }

	    if (plusCutoffFlag < 2) {
		plusCutoff = func.evaluate(plusDividePoints[i] * halfDiff + midParam) * weights[i];
		currentIntegral += plusCutoff;
		if (Math.abs(plusCutoff) <= tolerance) {
		    if (++plusCutoffFlag >= 2)
			plusCutoffNumber = (i + 1) - indexInterval;
		} else {
		    plusCutoffFlag = 0;
		}
	    }

	    if ((minusCutoffFlag == 2) &&
		(plusCutoffFlag  == 2))
		break;
	}

	if (minusCutoffNumber == 0)
	    minusCutoffNumber = maxNumberOfDividing;

	if (plusCutoffNumber == 0)
	    plusCutoffNumber = maxNumberOfDividing;

	/*
	 * general step
	 */
	lastIntegral = meshSize * halfDiff * currentIntegral;
	commonCutoffNumber
	    = (minusCutoffNumber < plusCutoffNumber) ? minusCutoffNumber : plusCutoffNumber;

	for (i = 0; i < powerNumber; i++) {
	    currentIntegral = 0.0;
	    indexInterval = startIndex;
	    startIndex /= 2;

	    for (j = startIndex - 1;
		 j < commonCutoffNumber;
		 j += indexInterval) {
		currentIntegral
		    += (func.evaluate(minusDividePoints[j] * halfDiff + midParam) +
			func.evaluate(plusDividePoints[j]  * halfDiff + midParam)) * weights[j];
	    }

	    if (minusCutoffNumber > commonCutoffNumber) {
		for (j = commonCutoffNumber + indexInterval - 1;
		     j < minusCutoffNumber;
		     j += indexInterval) {
		    currentIntegral
			+= func.evaluate(minusDividePoints[j] * halfDiff + midParam) * weights[j];
		}
	    }

	    if (plusCutoffNumber > commonCutoffNumber) {
		for (j = commonCutoffNumber + indexInterval - 1;
		     j < plusCutoffNumber;
		     j += indexInterval) {
		    currentIntegral
			+= func.evaluate(plusDividePoints[j] * halfDiff + midParam) * weights[j];
		}
	    }

	    currentIntegral = (lastIntegral + meshSize * halfDiff * currentIntegral) / 2.0;

	    /*
	     * converged!
	     */
	    if (Math.abs(currentIntegral - lastIntegral) < iterationTol) {
		return currentIntegral;
	    }

	    meshSize /= 2.0;
	    lastIntegral = currentIntegral;
	}

	/*
	 * not converged
	 */
	return currentIntegral;
    }

    /**
     * O̎̓̍őlԂB
     *
     * @param	a	
     * @param	b	
     * @param	c	
     * @return	O̎̓̍ől
     * @see	#midOf3(double, double, double)
     * @see	#minOf3(double, double, double)
     */
    public static double maxOf3(double a, double b, double c) {
	return Math.max(Math.max(a, b), c);
    }

    /**
     * O̎̓̂܂񒆂̒lԂB
     *
     * @param	a	
     * @param	b	
     * @param	c	
     * @return	O̎̓̂܂񒆂̒l
     * @see	#maxOf3(double, double, double)
     * @see	#minOf3(double, double, double)
     */
    public static double midOf3(double a, double b, double c) {
	if (b > a) {
	    if (c > b) return b;	/* c > b > a */
	    if (a > c) return a;	/* b > a > c */
	    return c;			/* b >= c >= a */
	} else {	/* a >= b */
	    if (c > a) return a;	/* c > a >= b */
	    if (b > c) return b;	/* a >= b > c */
	    return c;			/* a >= c >= b */
	}
    }

    /**
     * O̎̓̍ŏlԂB
     *
     * @param	a	
     * @param	b	
     * @param	c	
     * @return	O̎̓̍ŏl
     * @see	#maxOf3(double, double, double)
     * @see	#midOf3(double, double, double)
     */
    public static double minOf3(double a, double b, double c) {
	return Math.min(Math.min(a, b), c);
    }

    /**
     * l̐̕𑼂̎l̂ɍ킹B
     * <p>
     * a ̐̕ b ̂ɍ킹lԂB
     * </p>
     *
     * @param	a	
     * @param	b	
     * @return	b ̕ɍ킹 a
     */
    public static double copySign(double a, double b) {
	a = Math.abs(a);
	return (b < 0.0) ? (- a) : a;
    }

    /*
     * ̔񕉂̐̍ő (Greatest Common Divider) ԂB
     * <p>
     * a  0 ̏ꍇɂ b ԂB
     * </p>
     * <p>
     * b  0 ̏ꍇɂ a ԂB
     * </p>
     *
     * @param a	1 (łĂ͂ȂȂ)
     * @param b	2 (łĂ͂ȂȂ)
     * @return	ő
     * @see	#LCM(int, int)
     */
    public static int GCD(int a, int b) {
	int c;

	while (b != 0) {
	    c = a % b;
	    a = b;
	    b = c;
	}

	return a;
    }

    /*
     * ̔񕉂̐̍ŏ{ (Least Common Multiple) ԂB
     * <p>
     * a, b ̂ꂩA邢͗ 0 ̏ꍇɂ 0 ԂB
     * </p>
     *
     * @param a	1 (łĂ͂ȂȂ)
     * @param b	2 (łĂ͂ȂȂ)
     * @return	ő
     * @see	#GCD(int, int)
     */
    public static int LCM(int a, int b) {
	int c;

	if ((c = GCD(a, b)) == 0)
	    return 0;

	if (a > b) {
	    return (a / c) * b;
	} else {
	    return (b / c) * a;
	}
    }

    /**
     * oȗ] (hyperbolic cosine) ԂB
     * <p>
     * cosh(p) ԂB
     * </p>
     *
     * @param p	p[^l
     * @see	#sinh(double)
     */
    public static double cosh(double p) {
	return (Math.exp(p) + Math.exp(-p)) / 2.0;
    }

    /**
     * oȐ (hyperbolic sine) ԂB
     * <p>
     * sinh(p) ԂB
     * </p>
     *
     * @param p	p[^l
     * @see	#cosh(double)
     */
    public static double sinh(double p) {
	return (Math.exp(p) - Math.exp(-p)) / 2.0;
    }

    /**
     * toȐ (hyperbolic arctangent) ԂB
     * <p>
     * atanh(p) ԂB
     * </p>
     *
     * @param p	p[^l
     */
    public static double atanh(double p) {
	return Math.log(1.0 + 2.0*p / (1.0 - p)) / 2.0;
    }

    /**
     * toȐ (hyperbolic arcsine) ԂB
     * <p>
     * asinh(p) ԂB
     * </p>
     * <p>
     * asinh(p) = sign(p) * log(|p| + sqrt(p * p + 1))
     * </p>
     *
     * @param p	p[^l
     */
    public static double asinh(double p) {
	if (p > 0.0)
	    return Math.log(Math.abs(p) + Math.sqrt(p*p + 1));
	else
	    return -Math.log(Math.abs(p) + Math.sqrt(p*p + 1));
    }

    /**
     * `̘Aj[g@ɂZŉB
     * <p>
     * n ̖m (x0, ..., xm), (m = n - 1) ɑ΂
     * `̘A Fi(x0, ..., xm) = 0, (i = 0, ..., m) B
     * </p>
     * <p>
     * func  Fi(x0, ..., xm), (i = 0, ..., m) ̒lԂ
     * n ϐ (x0, ..., xm) ̊֐ŁA
     * n ̒l (F0, ..., Fm) ԂB
     * </p>
     * <p>
     * derivatives[i]  Fi(x0, ..., xm) ̕Δ dFi/dxj, (j = 0, ..., m) Ԃ
     * n ϐ (x0, ..., xm) ̊֐ŁA
     * n ̒l (dFi/dx0, ..., dFi/dxm) ԂB
     * </p>
     * <p>
     * convergence ́An ̉ł邩ۂ𔻒f
     * n ϐ (x0, ..., xm) ̊֐ŁA
     * n ̉ (x0, ..., xm) ŘAĂ trueA
     * łȂ false ԂB
     * </p>
     *
     * @param	func	n ̖m x ܂ޘA Fi(x) = 0 ̍Ӓl (F0, ..., Fm) Ԃ֐
     * @param	derivatives	Fi ̕Δl (dFi/dx0, ..., dFi/dxm) Ԃ֐̔z
     * @param	convergence	n ̉ (x0, ..., xm) ł邩ۂ𔻒f֐
     * @param	initialGuesses	n ̉ (x0, ..., xm) ̏l̔z
     * @return	A̎ (x0, ..., xm) ̔z
     * @see	#solveSimultaneousEquationsWithCorrection(JgclRealFunction, JgclRealFunction[], JgclBooleanFunctionWithRealVariables, JgclRealFunction, double[])
     */
    public static double[] solveSimultaneousEquations(JgclRealFunction func,
						      JgclRealFunction[] derivatives,
						      JgclBooleanFunctionWithRealVariables convergence,
						      double[] initialGuesses) {
	return solveSimultaneousEquationsWithCorrection(func, derivatives, convergence, null,
							initialGuesses);
    }

    /**
     * `̘Aj[g@ɂZŉ (Zrł̉̕␳@\t) B
     * <p>
     * n ̖m (x0, ..., xm), (m = n - 1) ɑ΂
     * `̘A Fi(x0, ..., xm) = 0, (i = 0, ..., m) B
     * </p>
     * <p>
     * func  Fi(x0, ..., xm), (i = 0, ..., m) ̒lԂ
     * n ϐ (x0, ..., xm) ̊֐ŁA
     * n ̒l (F0, ..., Fm) ԂB
     * </p>
     * <p>
     * derivatives[i]  Fi(x0, ..., xm) ̕Δ dFi/dxj, (j = 0, ..., m) Ԃ
     * n ϐ (x0, ..., xm) ̊֐ŁA
     * n ̒l (dFi/dx0, ..., dFi/dxm) ԂB
     * </p>
     * <p>
     * convergence ́An ̉ł邩ۂ𔻒f
     * n ϐ (x0, ..., xm) ̊֐ŁA
     * n ̉ (x0, ..., xm) ŘAĂ trueA
     * łȂ false ԂB
     * </p>
     * <p>
     * correct ́AZ̓r n ̉ (x0, ..., xm) ̒lIɏC֐ŁA
     * C n ̉ (x0, ..., xm) ԂB
     * correct ́AZ̃[vɂ convergence ̌ĂяȏOɌĂяoB
     * </p>
     *
     * @param	func	n ̖m x ܂ޘA Fi(x) = 0 ̍Ӓl (F0, ..., Fm) Ԃ֐
     * @param	derivatives	Fi ̕Δl (dFi/dx0, ..., dFi/dxm) Ԃ֐̔z
     * @param	convergence	n ̉ (x0, ..., xm) ł邩ۂ𔻒f֐
     * @param	correct		Z̓r n ̉ (x0, ..., xm) ̒lIɏC֐
     * @param	initialGuesses	n ̉ (x0, ..., xm) ̏l̔z
     * @return	A̎ (x0, ..., xm) ̔z
     * @see	#solveSimultaneousEquations(JgclRealFunction, JgclRealFunction[], JgclBooleanFunctionWithRealVariables, double[])
     */
    public static double[]
        solveSimultaneousEquationsWithCorrection(JgclRealFunction func,
						 JgclRealFunction[] derivatives,
						 JgclBooleanFunctionWithRealVariables convergence,
						 JgclRealFunction correct,
						 double[] initialGuesses) {
	int nX = initialGuesses.length;
	double[] X = (double[])(initialGuesses.clone());
	double[] F;
	double[][] dF = new double[nX][];
	double[] delta;

	int maxIteration = 50;

	if (convergence.evaluate(X) == true)
	    return X;

	for (int i = 0; i < maxIteration; i++) {
	    if ((F = func.evaluate(X)) == null)
		return null;
	    for (int j = 0; j < nX; j++)
		if ((dF[j] = derivatives[j].evaluate(X)) == null)
		    return null;

	    delta = (new JgclMatrix(dF)).solveSimultaneousLinearEquations(F);

	    if (delta == null)
		return null;

	    for (int j = 0; j < nX; j++)
		X[j] -= delta[j];

	    if (correct != null)
		X = correct.evaluate(X);

	    if (convergence.evaluate(X) == true)
		return X;
	}

	return null;
    }

    /**
     * pXJ̎Op`̊vZl (n = 1)
     * @see	#pascalTriangle(int)
     */
    private static double[] pascal01 = {1.};

    /**
     * pXJ̎Op`̊vZl (n = 2)
     * @see	#pascalTriangle(int)
     */
    private static double[] pascal02 = {1.,  1.};

    /**
     * pXJ̎Op`̊vZl (n = 3)
     * @see	#pascalTriangle(int)
     */
    private static double[] pascal03 = {1.,  2.,  1.};

    /**
     * pXJ̎Op`̊vZl (n = 4)
     * @see	#pascalTriangle(int)
     */
    private static double[] pascal04 = {1.,  3.,  3.,   1.};

    /**
     * pXJ̎Op`̊vZl (n = 5)
     * @see	#pascalTriangle(int)
     */
    private static double[] pascal05 = {1.,  4.,  6.,   4.,   1.};

    /**
     * pXJ̎Op`̊vZl (n = 6)
     * @see	#pascalTriangle(int)
     */
    private static double[] pascal06 = {1.,  5., 10.,  10.,   5.,   1.};

    /**
     * pXJ̎Op`̊vZl (n = 7)
     * @see	#pascalTriangle(int)
     */
    private static double[] pascal07 = {1.,  6., 15.,  20.,  15.,   6.,   1.};

    /**
     * pXJ̎Op`̊vZl (n = 8)
     * @see	#pascalTriangle(int)
     */
    private static double[] pascal08 = {1.,  7., 21.,  35.,  35.,  21.,   7.,   1.};

    /**
     * pXJ̎Op`̊vZl (n = 9)
     * @see	#pascalTriangle(int)
     */
    private static double[] pascal09 = {1.,  8., 28.,  56.,  70.,  56.,  28.,   8.,  1.};

    /**
     * pXJ̎Op`̊vZl (n = 10)
     * @see	#pascalTriangle(int)
     */
    private static double[] pascal10 = {1.,  9., 36.,  84., 126., 126.,  84.,  36.,  9.,  1.};

    /**
     * pXJ̎Op`̊vZl (n = 11)
     * @see	#pascalTriangle(int)
     */
    private static double[] pascal11 = {1., 10., 45., 120., 210., 252., 210., 120., 45., 10., 1.};

    /**
     * pXJ̎Op`̊vZl̔z (n = 11 ܂)
     * @see	#pascalTriangle(int)
     */
    private static double[][] predefPascal
        = {null,
	   pascal01,  pascal02,  pascal03,  pascal04,  pascal05,
	   pascal06,  pascal07,  pascal08,  pascal09,  pascal10,
	   pascal11};

    /**
     * pXJ̎Op`̊vZl̒ n ő̂
     * @see	#pascalTriangle(int)
     */
    private static double[] lastPredefPascal = pascal11;

    /**
     * R N ɑ΂pXJ̎Op`̌WԂB
     *
     * @param n	R N
     * @return	n ɑ΂pXJ̎Op`̌W̔z
     */
    public static double[] pascalTriangle(int n)
    {
	if (n <= 0)
        {
	    return predefPascal[0];
	}
	else if (n < predefPascal.length)
	{
	    return predefPascal[n];
	}
	else
	{
	    double[] pascal = new double[n];

	    for (int i = 0; i < lastPredefPascal.length; i++)
		pascal[i] = lastPredefPascal[i];

	    for (int i = lastPredefPascal.length; i < n; i++)
	    {
		pascal[i] = 1.0;
		for (int j = i - 1; j > 0; j--)
		    pascal[j] = pascal[j - 1] + pascal[j];
	    }

	    return pascal;
	}
    }

    /**
     * ^ꂽpx [0, 2 * PI] ̊Ԃ̒lɐKB
     * 
     * @param angle	px (WA)
     * @return	Kꂽpx (WA)
     */
    public static double normalizeAngle(double angle) {
	double eangle = angle;

	while (eangle < 0.0)
	  eangle += 2.0 * Math.PI;

	while (eangle > 2.0 * Math.PI)
	  eangle -= 2.0 * Math.PI;

	return(eangle);
    }

    /**************************************************************************
     *
     * Debug
     *
     **************************************************************************/
    /* Debug : getDefiniteIntegral */
    private static void debugGetDefiniteIntegral(String argv[]) {
	try {
	    double[] coef = new double[argv.length - 1];
	    for (int i = 0; i < (argv.length - 1); i++)
		coef[i] = Double.valueOf(argv[i]).doubleValue();
	    JgclRealPolynomial poly = new JgclRealPolynomial(coef);
	    JgclParameterSection param = new JgclParameterSection(0.0, 1.0);
	    double result
		= getDefiniteIntegral(poly, param,
				      Double.valueOf(argv[argv.length - 1]).doubleValue());
	    System.out.println("result : " + result);
	}
	catch (JgclInvalidArgumentValue e) {
	}
    }

    /**
     * fobOpCvOB
     */
    public static void main(String argv[]) {
	debugGetDefiniteIntegral(argv);
    }
}

/* end of file */
