/*
 * tgʂ𐶐邽߂̃NX(3D)
 * ؎ 7.2.2
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclLoftSurface3D.java,v 1.3 2000/04/26 09:39:05 hideit Exp $
 */

package jp.go.ipa.jgcl;

/**
 * tgʂ𐶐邽߂̃NX(3D)
 *
 * @version $Revision: 1.3 $, $Date: 2000/04/26 09:39:05 $
 * @author Information-technology Promotion Agency, Japan
 */

class JgclLoftSurface3D {
    /*
     * Ȑ
     */
    private final JgclBsplineCurve3D basisCurve;

    /*
     * |\xNg
     */
    private final JgclVector3D axisVector;

    /*
     * |钷
     */
    private final double length;

    /**
     * ȐA|A|^āAIuWFNg\z
     *
     * @param basisCurve	Ȑ
     * @param axisVector	|\xNg
     * @param length		|钷
     */
    JgclLoftSurface3D(JgclBsplineCurve3D basisCurve,
		      JgclVector3D axisVector,
		      double length) {
	this.basisCurve = basisCurve;
	this.axisVector = axisVector;
	this.length = length;
    }

    JgclBsplineSurface3D getSurface() {
	JgclVector3D moveVector = axisVector.unitized().multiply(length);

	int uNControlPoints = 2;
	int vNControlPoints = basisCurve.nControlPoints();
	JgclPoint3D[][] controlPoints = new JgclPoint3D[uNControlPoints][vNControlPoints];
	for (int j = 0; j < vNControlPoints; j++) {
	    controlPoints[0][j] = basisCurve.controlPointAt(j);
	    controlPoints[1][j] = controlPoints[0][j].add(moveVector);
	}

	double[][] weights = null;
	if (basisCurve.isRational()) {
	    weights = new double[uNControlPoints][vNControlPoints];
	    for (int j = 0; j < vNControlPoints; j++) {
		weights[0][j] = weights[1][j] = basisCurve.weightAt(j);
	    }
	}

	int uDegree = 1;
	double[] uKnots = new double[2];
	uKnots[0] = 0.0;
	uKnots[1] = length;
	int[] uKnotMulti = new int[2];
	uKnotMulti[0] = uKnotMulti[1] = 2;
	JgclBsplineKnot uKnotData = new JgclBsplineKnot(uDegree, JgclKnotType.UNSPECIFIED, false,
							uKnotMulti, uKnots, uNControlPoints);

	return new JgclBsplineSurface3D(uKnotData, basisCurve.knotData(), controlPoints, weights);
    }
}
