/*
 * QFe萔Œ`ꂽxNg\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclLiteralVector2D.java,v 1.18 2000/04/26 09:39:05 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.io.PrintWriter;

/**
 * QFe萔Œ`ꂽxNg\NXB
 *
 * @version $Revision: 1.18 $, $Date: 2000/04/26 09:39:05 $
 * @author Information-technology Promotion Agency, Japan
 * @see	JgclHomogeneousVector2D
 */

public class JgclLiteralVector2D extends JgclVector2D {

    /**
     * X B
     * @serial
     */
    private final double x;

    /**
     * Y B
     * @serial
     */
    private final double y;

    /**
     * (x, y) Œ`IuWFNg\zB
     *
     * @param x	X 
     * @param y	Y 
     */
    public JgclLiteralVector2D(double x, double y) {
	super();
	this.x = x;
	this.y = y;
    }

    /**
     * (c[0], c[1]) Œ`IuWFNg\zB
     *
     * @param c	̔z
     */
    public JgclLiteralVector2D(double[] c) {
	super();
	this.x = c[0];
	this.y = c[1];
    }

    /**
     * (x, y) Œ`IuWFNg\zB
     * 
     * @param x	X 
     * @param y	Y 
     * @param confirmedAsUnitized	悤ƂxNg
     *					PʃxNgł邱ƂĂȂ <code>true</code>A
     *					Ȃ <code>false</code>
     */
    JgclLiteralVector2D(double x, double y, boolean confirmedAsUnitized) {
	super(confirmedAsUnitized);
	this.x = x;
	this.y = y;
    }

    /**
     * (c[0], c[1]) Œ`IuWFNg\zB
     * 
     * @param c	̔z
     * @param confirmedAsUnitized	悤ƂxNg
     *					PʃxNgł邱ƂĂȂ <code>true</code>A
     *					Ȃ <code>false</code>
     */
    JgclLiteralVector2D(double[] c, boolean confirmedAsUnitized) {
	super(confirmedAsUnitized);
	this.x = c[0];
	this.y = c[1];
    }

    /**
     * X ԂB
     * 
     * @return	xNg X 
     */
    public double x() {
	return this.x;
    }

    /**
     * Y ԂB
     * 
     * @return	xNg Y 
     */
    public double y() {
	return this.y;
    }

    /**
     * ̃xNgA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclVector2D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator2D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	if (reverseTransform == false)
	    return transformationOperator.transform(this);
	else
	    return transformationOperator.reverseTransform(this);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab
                       + getClassName() + " "
                       + x() + " "
                       + y() + " End");
    }
}
