/*
 * Q : \NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclLine2D.java,v 1.61 2000/08/11 06:18:53 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;

/**
 * Q : \NXB
 * <p>
 * ́Â_ pnt ƕxNg dir Œ`B
 * </p>
 * <p>
 * t p[^Ƃ钼 P(t) ̃pgbN\́Aȉ̒ʂB
 * <pre>
 *	P(t) = pnt + t * dir
 * </pre>
 * </p>
 * <p>
 * uȐvłB
 * </p>
 * <p>
 * ͖̒Ȓ\B
 * LȒ\ꍇɂ
 * {@link JgclBoundedLine2D JgclBoundedLine2D}
 * 
 * {@link JgclTrimmedCurve2D JgclTrimmedCurve2D}
 * płB
 * </p>
 *
 * @version $Revision: 1.61 $, $Date: 2000/08/11 06:18:53 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclLine2D extends JgclParametricCurve2D {
    /**
     * ̂_B
     * <p>
     * p[^l 0 ɑΉ_B
     * </p>
     * @serial
     */
    private final JgclPoint2D pnt;
    
    /**
     * xNgB
     * <p>
     * p[^l 1 ɑΉ_ pnt + dir ɂȂB
     * </p>
     * @serial
     */
    private final JgclVector2D dir;

    /**
     * tB[hɐݒ肷l̂܂ܗ^ăIuWFNg\zB
     * <p>
     * pnt p[^l 0 ̓_ƂA
     * dir xNgƂ钼𐶐B
     * </p>
     * <p>
     * dir ̑傫A
     * ݐݒ肳Ă鉉Z̋̋e덷ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param pnt	̂_ (p[^l 0 ɑΉ)
     * @param dir	xNg
     * @see	JgclConditionOfOperation
     * @see	JgclInvalidArgumentValue
     */
    public JgclLine2D(JgclPoint2D pnt, JgclVector2D dir){
	super();
	
	if (dir.norm() < getToleranceForDistance2())
	    throw new JgclInvalidArgumentValue();
	this.pnt = pnt;
	this.dir = dir;
    }
    
    /**
     * ʉ߂_^ăIuWFNg\zB
     * <p>
     * pnt1 p[^l 0 ̓_ƂA
     * pnt2 p[^l 1 ̓_Ƃ
     * 𐶐B
     * </p>
     * <p>
     * pnt  dir ́Aȉ̂悤ɐݒ肳B
     * <pre>
     *		pnt = pnt1
     *		dir = pnt2 - pnt1
     * </pre>
     * </p>
     * <p>
     * pnt1  pnt2 A
     * ݐݒ肳Ă鉉Z̋̋e덷̉ŁA
     * ̓_ƌȂꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param pnt1	̂_ (p[^l 0 ɑΉ)
     * @param pnt2	̂_ (p[^l 1 ɑΉ)
     * @see	JgclConditionOfOperation
     * @see	JgclInvalidArgumentValue
     * @see	JgclPoint2D#identical(JgclPoint2D)
     */
    public JgclLine2D(JgclPoint2D pnt1, JgclPoint2D pnt2) {
	super();
	
	if (pnt1.identical(pnt2))
	    throw new JgclInvalidArgumentValue();
	this.pnt = pnt1;
	this.dir = pnt2.subtract(pnt1);
    }
    
    /**
     * ̒`Ă̂_ (p[^l 0 ɑΉ_) ԂB
     * 
     * @return		̂_ (p[^l 0 ɑΉ_)
     */
    public JgclPoint2D pnt() {
	return this.pnt;
    }

    /**
     * ̒`ĂxNgԂB
     * <p>
     * ̃xNǵA̒̐ڃxNgɓB
     * </p>
     * 
     * @return		xNg
     */
    public JgclVector2D dir() {
	return this.dir;
    }

    /**
     * ̋Ȑ́A^ꂽp[^Ԃɂԏł̒ (̂) ԂB
     * 
     * @param pint	߂p[^
     * @return		w肳ꂽp[^ԂɂȐ̒
     */
    public double length(JgclParameterSection pint) {
        return dir.length() * Math.abs(pint.increase());
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̍WlԂB
     * 
     * @param param	p[^l
     * @return		Wl
     */
    public JgclPoint2D coordinates(double param) {
	return pnt.add(dir.multiply(param));
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̐ڃxNgԂB
     * <p>
     * ̐ڃxNǵA dir ɓB
     * </p>
     * 
     * @param param	p[^l
     * @return		ڃxNg
     */
    public JgclVector2D tangentVector(double param) {
	return dir;
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̋ȗԂB
     * <p>
     * ̋ȗ́A 0 łB
     * </p>
     * 
     * @param param	p[^l
     * @return		ȗ
     */
    public JgclCurveCurvature2D curvature(double param) {
	return new JgclCurveCurvature2D(0.0, JgclVector2D.zeroVector);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̓֐ԂB
     * 
     * @param param	p[^l
     * @return		֐
     */
    public JgclCurveDerivative2D evaluation(double param) {
	return new JgclCurveDerivative2D(coordinates(param),
					 dir, 
					 JgclVector2D.zeroVector);
    }

    /**
     * ̋Ȑ̓ٓ_ԂB
     * <p>
     * ɂ͓ٓ_݂͑Ȃ̂ŁAɗvf 0 ̔zԂB
     * </p>
     * 
     * @return		ٓ_̔z
     */
    public JgclPointOnCurve2D[] singular() {
        return new JgclPointOnCurve2D[0];
    }

    /**
     * ̋Ȑ̕ϋȓ_ԂB
     * <p>
     * ɂ͕ϋȓ_݂͑Ȃ̂ŁAɗvf 0 ̔zԂB
     * </p>
     * 
     * @return		ϋȓ_̔z
     */
    public JgclPointOnCurve2D[] inflexion() {
        return new JgclPointOnCurve2D[0];
    }

    /**
     * ^ꂽ_炱̋Ȑւ̓e_߂B
     * <p>
     * 钼ւ̔Cӂ̓_̓e_͕̐K 1 ɂȂB
     * </p>
     * <p>
     * ̃\bh́A
     * {@link JgclParametricCurve2D JgclParametricCurve2D} NX
     * ۃ\bhƂĐ錾Ă̂ł邪A
     * ̃NXɂ͓e_߂郁\bhƂāA
     * {@link #project1From(JgclPoint2D) project1From(JgclPoint2D)}
     * B
     * project1From(JgclPoint2D) ́A
     * ue_̔zvł͂ȂA
     * ue_v̂܂ܕԂB
     * </p>
     * 
     * @param point	e̓_
     * @return		e_̔z
     * @see #project1From(JgclPoint2D)
     */
    public JgclPointOnCurve2D[] projectFrom(JgclPoint2D point) 
    {
	JgclPointOnCurve2D[] proj = new JgclPointOnCurve2D[1];
	proj[0] = project1From(point);
	return proj;
    }

    /**
     * ̋Ȑ̎w̋ԂA^ꂽ덷Œߎ|CԂB
     * <p>
     * ʂƂĕԂ|C\_
     * ̋Ȑx[XƂ JgclPointOnCurve2D 
     * 邱Ƃ҂łB
     * </p>
     * <p>
     * ȂA
     * ʂƂĕԂ|ĆA
     * ̒̎w肳ꂽԂ́uߎvł͂ȂAȁuČvłB
     * ̃\bh̓ł tol ̒l͎QƂȂB
     * </p>
     * 
     * @param pint	ߎp[^
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ𒼐ߎ|C
     * @see		JgclPointOnCurve2D
     */
    public JgclPolyline2D toPolyline(JgclParameterSection pint,
				     JgclToleranceForDistance tol)
    {
	JgclPoint2D[] points = new JgclPoint2D[2];

	points[0] = new JgclPointOnCurve2D(this, pint.start(), doCheckDebug);
	points[1] = new JgclPointOnCurve2D(this, pint.end(), doCheckDebug);

	if (points[0].identical(points[1]))
	    throw new JgclZeroLength();

	return new JgclPolyline2D(points);
    }

    /**
     * ̋Ȑ̎w̋ԂɍČL Bspline ȐԂB
     * <p>
     * ʂƂĕԂL Bspline Ȑ
     * PŐ_ 2A[d̃jtH[ȃmbgB
     * </p>
     * 
     * @param pint	L Bspline ȐōČp[^
     * @return		̋Ȑ̎w̋ԂČL Bspline Ȑ
     */
    public JgclBsplineCurve2D toBsplineCurve(JgclParameterSection pint) {
	JgclPoint2D[] controlPoints = {this.coordinates(pint.start()),
				       this.coordinates(pint.end())};
	double[] weights = {1.0, 1.0};

	return new JgclBsplineCurve2D(JgclBsplineKnot.quasiUniformKnotsOfLinearOneSegment,
				      controlPoints, weights);
    }

    /**
     * ̋ȐƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ŁA񒼐I[o[bvĂꍇɂ́A
     * słƂ JgclIndefiniteSolution 𔭐B
     * 񒼐I[o[bvĂƔf
     * {@link #intersect1Line(JgclLine2D) intersect1Line(JgclLine2D)}
     * ƓlłB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution mate ŁA񒼐̓I[o[bvĂAsł
     */
    public JgclIntersectionPoint2D[] intersect(JgclParametricCurve2D mate)
	 throws JgclIndefiniteSolution
    {
	return mate.intersect(this, true);
    }

    /**
     * ̒Ƒ̒Ƃ () _߂B
     * <p>
     * 񒼐słꍇɂ null ԂB
     * 񒼐̕xNĝȂpx (̓ - ) 
     * ݐݒ肳Ă鉉Źupx̋e덷ȓvł΁A
     * 񒼐͕sł̂ƔfB
     * </p>
     * <p>
     * A񒼐słꍇɁA
     * ꂩ pnt 瑊ւ̋
     * ݐݒ肳Ă鉉Źűe덷ȓvł΁A
     * 񒼐̓I[o[bvĂ̂ƂāA
     * JgclIndefiniteSolution ̗O𔭐B
     * </p>
     * 
     * @param mate	̒
     * @return		_
     * @exception	JgclIndefiniteSolution 񒼐̓I[o[bvĂAsł
     * @see	JgclConditionOfOperation
     * @see	JgclVector2D#parallelDirection(JgclVector2D)
     */
    public JgclIntersectionPoint2D intersect1Line(JgclLine2D mate)
	throws JgclIndefiniteSolution
    {
	JgclVector2D p = mate.pnt().subtract(pnt());
	double pa = p.zOfCrossProduct(dir());
	double pb = p.zOfCrossProduct(mate.dir());
	double dTol = getToleranceForDistance();

	if (dir().parallelDirection(mate.dir())) {
  	    if (Math.abs(pa / dir().length()) < dTol ||
  		Math.abs(pb / mate.dir().length()) < dTol) {
		// same line
		JgclPointOnCurve2D pnt1 = new JgclPointOnCurve2D(this, 0, doCheckDebug);
		JgclPointOnCurve2D pnt2 = mate.project1From(pnt1);
		JgclIntersectionPoint2D ip = 
		    new JgclIntersectionPoint2D(pnt1, pnt2, doCheckDebug);
		throw new JgclIndefiniteSolution(ip);
	    }
	    else
		return null;	// parallel
	}

	double o = dir().zOfCrossProduct(mate.dir());
	return new JgclIntersectionPoint2D(this, pb/o, mate, pa/o, doCheckDebug);
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * słƂ JgclIndefiniteSolution 𔭐
     * {@link #intersect1Line(JgclLine2D) intersect1Line(JgclLine2D)}
     * ƓlłB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link #intersect1Line(JgclLine2D) intersect1Line(JgclLine2D)}
     * ĂяoĂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution	sł
     */
    JgclIntersectionPoint2D[] intersect(JgclLine2D mate, boolean doExchange)
	 throws JgclIndefiniteSolution
    {
	JgclIntersectionPoint2D ints;
	if ((ints = intersect1Line(mate)) == null) {
	    return new JgclIntersectionPoint2D[0];
	}
	if (doExchange)
	    ints = ints.exchange();
	JgclIntersectionPoint2D[] sol = new JgclIntersectionPoint2D[1];
	sol[0] = ints;

	return sol;
    }

    /**
     * ̋ȐƑ̋Ȑ (~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ~̃NX́u~ vs. v̌_Z\bh
     * {@link JgclCircle2D#intersect(JgclLine2D, boolean)
     * JgclCircle2D.intersect(JgclLine2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclCircle2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (ȉ~) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȉ~̃NX́uȉ~ vs. v̌_Z\bh
     * {@link JgclEllipse2D#intersect(JgclLine2D, boolean)
     * JgclEllipse2D.intersect(JgclLine2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȉ~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclEllipse2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (oȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * oȐ̃NX́uoȐ vs. v̌_Z\bh
     * {@link JgclHyperbola2D#intersect(JgclLine2D, boolean)
     * JgclHyperbola2D.intersect(JgclLine2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (oȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclHyperbola2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ̃NX́u vs. v̌_Z\bh
     * {@link JgclParabola2D#intersect(JgclLine2D, boolean)
     * JgclParabola2D.intersect(JgclLine2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclParabola2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (|C) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * |C̃NX́u|C vs. v̌_Z\bh
     * {@link JgclPolyline2D#intersect(JgclLine2D, boolean)
     * JgclPolyline2D.intersect(JgclLine2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (|C)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclPolyline2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (xWGȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * xWGȐ̃NX́uxWGȐ vs. v̌_Z\bh
     * {@link JgclPureBezierCurve2D#intersect(JgclLine2D, boolean)
     * JgclPureBezierCurve2D.intersect(JgclLine2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (xWGȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclPureBezierCurve2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (aXvCȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * aXvCȐ̃NX́uaXvCȐ vs. v̌_Z\bh
     * {@link JgclBsplineCurve2D#intersect(JgclLine2D, boolean)
     * JgclBsplineCurve2D.intersect(JgclLine2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (aXvCȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclBsplineCurve2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (gȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * gȐ̃NX́ugȐ vs. v̌_Z\bh
     * {@link JgclTrimmedCurve2D#intersect(JgclLine2D, boolean)
     * JgclTrimmedCurve2D.intersect(JgclLine2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (gȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclTrimmedCurve2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (ȐZOg) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȐZOg̃NX́uȐZOg vs. v̌_Z\bh
     * {@link JgclCompositeCurveSegment2D#intersect(JgclLine2D, boolean)
     * JgclCompositeCurveSegment2D.intersect(JgclLine2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȐZOg)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclCompositeCurveSegment2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (Ȑ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * Ȑ̃NX́uȐ vs. v̌_Z\bh
     * {@link JgclCompositeCurve2D#intersect(JgclLine2D, boolean)
     * JgclCompositeCurve2D.intersect(JgclLine2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (Ȑ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclCompositeCurve2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋Ȑ̎w̋ԂItZbgȐA
     * ^ꂽ덷ŋߎ Bspline Ȑ߂B
     * <p>
     * ȂA
     * ʂƂĕԂ Bspline Ȑ́A
     * ̒̎w肳ꂽԂ̃ItZbǵuߎvł͂ȂA
     * ȁuČvłB
     * ̃\bh̓ł tol ̒l͎QƂȂB
     * </p>
     * 
     * @param pint	ItZbgp[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.LEFT/RIGHT)
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ̃ItZbgȐߎ Bspline Ȑ
     * @see	JgclWhichSide
     */
    public JgclBsplineCurve2D
	offsetByBsplineCurve(JgclParameterSection pint,
			     double magni,
			     int side,
			     JgclToleranceForDistance tol) {
	int uicp = 4;       // _
	int uik = 2;        // mbgz̗vf
	
	// parameter section
	double start_param = pint.start();
	double end_param = start_param + pint.increase();
	double param_interval = pint.increase()/(uicp -1);
	
	double[] knots = new double[2];
	int[] knot_multi = new int[2];
	
	knots[0] = 0.0;     knot_multi[0] = 4;
	knots[1] = Math.abs(pint.increase()); knot_multi[1] = 4;
	
	JgclVector2D offset_vector;
	
	// offset vector
	if(side == JgclWhichSide.LEFT)
	    offset_vector = 
		new JgclLiteralVector2D(-1*dir().y(),dir().x());
	else if(side == JgclWhichSide.RIGHT)
	    offset_vector =
		new JgclLiteralVector2D(dir().y(),-1*dir().x());
	else
	    throw new JgclInvalidArgumentValue(); 
	
	offset_vector = offset_vector.unitized();
	offset_vector = offset_vector.multiply(magni);
	
	if(pint.increase() < 0.0)
	    offset_vector = offset_vector.reverse();
	
	// offset
	int i;
	double crnt_param;
	JgclPoint2D[] crnt_pnt = new JgclPoint2D[uicp];
	
	crnt_pnt[0] = coordinates(start_param);
	crnt_pnt[0] = crnt_pnt[0].add(offset_vector);
	
	for(i=1,crnt_param = (start_param + param_interval);
	    i<(uicp -1);
	    i++,crnt_param += param_interval){
	    crnt_pnt[i] = coordinates(crnt_param);
	    crnt_pnt[i] = crnt_pnt[i].add(offset_vector);
	}
	
	crnt_pnt[i] = coordinates(end_param);
	crnt_pnt[i] = crnt_pnt[i].add(offset_vector);
	
	JgclBsplineCurve2D bsc = 
	    new JgclBsplineCurve2D(3, knot_multi, knots, crnt_pnt);
	
	return bsc;
    }

    /**
     * ̋Ȑ̎w̋ԂItZbgȐA
     * ^ꂽ덷ŋߎLȐ߂B
     * <p>
     * ʂƂĕԂLȐ́A
     * {@link JgclBoundedLine2D JgclBoundedLine2D}
     * ̃CX^XłB
     * </p>
     * <p>
     * ȂA
     * ʂƂĕԂLȐ́A
     * ̒̎w肳ꂽԂ̃ItZbǵuߎvł͂ȂA
     * ȁuČvłB
     * ̃\bh̓ł tol ̒l͎QƂȂB
     * </p>
     * 
     * @param pint	ItZbgp[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.LEFT/RIGHT)
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ̃ItZbgȐߎLȐ
     * @see	JgclWhichSide
     */
    public JgclBoundedCurve2D
        offsetByBoundedCurve(JgclParameterSection pint,
			     double magni,
                             int side,
                             JgclToleranceForDistance tol)
    {
	JgclVector2D lineDirection = this.tangentVector(0.0);
	JgclVector2D offsetVector;
	if (side == JgclWhichSide.RIGHT)
	    offsetVector = JgclVector2D.of(lineDirection.y(), - lineDirection.x());
	else
	    offsetVector = JgclVector2D.of(- lineDirection.y(), lineDirection.x());
	offsetVector = offsetVector.unitized().multiply(magni);
	if (pint.increase() < 0.0)
	    offsetVector = offsetVector.reverse();

	return new JgclBoundedLine2D(this.coordinates(pint.start()).add(offsetVector),
				     this.coordinates(pint.end()).add(offsetVector));
    }
    
    /**
     * ̋ȐƑ̋ȐƂ̋ʐڐ߂B
     * <p>
     * ʐڐ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * _ł͎ĂȂ߁A
     * JgclNotSupported	̗O𔭐B
     * </p>
     *
     * @param mate	̋Ȑ
     * @return		ʐڐ̔z
     * @exception	JgclNotSupported	܂̂ƂAȂ@\ł
     */
    public JgclCommonTangent2D[] commonTangent(JgclParametricCurve2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋ȐƂ̋ʖ@߂B
     * <p>
     * ʖ@݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * _ł͎ĂȂ߁A
     * JgclNotSupported	̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		ʖ@̔z
     * @exception	JgclNotSupported	܂̂ƂAȂ@\ł
     */
    public JgclCommonNormal2D[]	commonNormal(JgclParametricCurve2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ^ꂽ_炱̒ւ (݂) e_߂B
     * <p>
     * ͈ȉ̒ʂB
     * <br>
     * (point - this.pnt)  (this.dir ̒PʃxNg) ̓ς̒l
     * ̒ɑ΂铊e_̃p[^lƂA
     * ̃p[^l JgclPointOnCurve2D ̃CX^XԂB
     * </p>
     *
     * @param point     e̓_
     * @return          e_
     * @see	#projectFrom(JgclPoint2D) 
     */
    public JgclPointOnCurve2D project1From(JgclPoint2D point)
    {
        /*
         * ALGORITHM
         *
         *                            point
         *                              x
         *                             /|
         *                            / |
         *                           /  |
         *                          /   |
         *                   theta /    |
         *                        /\    |   Line.pnt + ( k * Line.dir )
         *                 ------x------x-------->     (k: real)
         *                  Line.pnt    prj
         *
         *     evpp = vector of ( Line.pnt --> point )
         *     euvec = unit direction vector of Line
         *
         *     prj = Line.pnt + ( |evpp|*cos( theta ) * euvec )
         *         = Line.pnt + ( (evpp, euvec) * euvec )
         *         = Line.pnt + ( (dir / sqrt(|Line.dir|), euvec) ) *
         *                        ( Line.dir / sqrt(|Line.dir| )
         *         = Line.pnt + ( (dir, euvec) / |Line.dir| ) * Line.dir
         *                      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ parameter
         */

        // ̎n_瓊e̓_܂ł̃xNg߂
        JgclVector2D evpp = point.subtract(pnt);

        // xNg̓ς瓊e_̃p[^߂
        double edot = dir.dotProduct(evpp);
        double param = edot / dir.norm();
        // e_߂
        return new JgclPointOnCurve2D(this, param, doCheckDebug);
    }

    /**
     * ^ꂽ_̒̂ǂ瑤ɂ邩ԂB
     * <p>
     * {@link JgclWhichSide#ON		JgclWhichSide.ON},
     * {@link JgclWhichSide#RIGHT	JgclWhichSide.RIGHT},
     * {@link JgclWhichSide#LEFT	JgclWhichSide.LEFT}
     * ̂ꂩ̒lԂB
     * </p>
     * <p>
     * point 炱̒ւ̋A
     * ݐݒ肳Ă鉉Z̋̋e덷ȉłꍇɂ
     * point ͂̒ɏĂ̂Ƃ JgclWhichSide.ON ԂB
     * </p>
     * <p>
     * ̃\bh́A̋ȐƂƂɂ܂Ƃ߂ׂłB
     * </p>
     *
     * @return	ǂ瑤ł邩
     * @see	JgclWhichSide
     */
    int pointIsWhichSide(JgclPoint2D point) {
	JgclVector2D eBAvec;	/* vector from line's start point to point */
	JgclVector2D uDir;	/* unitized vector of line */
	double ework;
	double d_tol = getToleranceForDistance();

	/*
	 * vector from line's start point to point.
	 * unitized vector of line.
	 */
	eBAvec = point.subtract(pnt);
	uDir = dir.unitized();

	/*
	 * 3rd compornent of cross product
	 */
	ework = eBAvec.zOfCrossProduct(uDir);

	if (ework > d_tol)
	    return(JgclWhichSide.RIGHT);
	else if (ework < (- d_tol))
	    return(JgclWhichSide.LEFT);
	else
	    return(JgclWhichSide.ON);
    }

    /**
     * ̋Ȑ̃p[^`ԂB
     * <p>
     * ŔIȃp[^`ԂB
     * </p>
     * 
     * @return	ŔIȃp[^`
     */
    JgclParameterDomain getParameterDomain() {
	return new JgclParameterDomain();
    }

    /**
     * ̋Ȑ􉽓IɕĂ邩ۂԂB
     * <p>
     * Ȃ̂ŁA false ԂB
     * </p>
     *
     * @return	͕邱Ƃ͂Ȃ̂ŁA <code>false</code>
     */
    boolean getClosedFlag() {
	return false;
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricCurve2D#LINE_2D JgclParametricCurve2D.LINE_2D}
     */
    int type() {
	return LINE_2D;
    }

    /**
     * ̋ȐA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricCurve2D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator2D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclPoint2D tPnt = this.pnt().transformBy(reverseTransform,
						  transformationOperator, transformedGeometries);
	JgclVector2D tDir = this.dir().transformBy(reverseTransform,
						   transformationOperator, transformedGeometries);
	return new JgclLine2D(tPnt, tDir);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tpnt");
        pnt.output(writer, indent + 2);
        writer.println(indent_tab + "\tdir");
        dir.output(writer, indent + 2);
        writer.println(indent_tab + "End");
    }
}
