/*
 * 2D̕Ɖ~Ȑ̌_߂NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclIntsParCnc2D.java,v 1.11 2000/04/26 09:39:02 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.util.Vector;

/**
 * 2D̕Ɖ~Ȑ̌_߂NX
 *
 * @version $Revision: 1.11 $, $Date: 2000/04/26 09:39:02 $
 * @author Information-technology Promotion Agency, Japan
 */

class JgclIntsParCnc2D extends JgclIntsCncCnc2D {

    JgclIntsParCnc2D() {
	super();
    }

    /**
     * ƑoȐ̌_߂邽߂̕Ă
     * 
     * @param pbl  : A
     * @param hyp oȐ : B
     * @return		̌W
     */
    double[] getCoefficent(JgclParabola2D par, JgclHyperbola2D hyp,
			JgclCartesianTransformationOperator2D trans)
    {
	/*
	 * NOTE:
	 *
	 * Point of inverse transformed of B (Hyperbola) is
	 *
	 *	x = cosP * E*coshL - sinP * F*sinhL + Cx    ---> (1)
	 *	y = sinP * E*coshL + cosP * F*sinhL + Cy
	 *	/  E = distance from center to vertex      \
	 *	|  F = b of asymptotic slope b/dB->x_radius|
	 *	|  P = ( slope of B ) - ( slope of A )     |
	 *	\  C = ( center of B ) - ( vertex of A )   /
	 *
	 * Point of A (Parabola) is
	 *
	 *	x = A * s**2                                ---> (2)
	 *	y = 2 * A * s
	 *	(  A = dA->focal_dist )
	 *
	 * (1) & (2) -->
	 *
	 *	  ( (I+H)**2 - J**2 )                       * sinhL**4
	 *	+ 2 * ( (I+H)*L - J*K )                     * sinhL**3
	 *	+ ( 2 * (I+H)*(M+H) + L**2 - J**2 - K**2 )  * sinhL**2
	 *	+ 2 * ( (M+H)*L - J*K )                     * sinhL
	 *	+ ( (M+H)**2 - K**2 )
	 *	= 0
	 *
	 *	/ H = E**2 * cosP**2                           \
	 *	| I = F**2 * sinP**2                           |
	 *	| J = 2 * E * F * cosP * sinP                  |
	 *	| K = 2 * E * ( Cy*sinP - 2*A*cosP )           |
	 *	| L = 2 * F * ( Cy*cosP + 2*A*sinP )           |
	 *	\ M = Cy**2 - 4*A*Cx**2                        /
	 *
	 * This is a 4th order polynomial for sinhL.
	 * We'll get roots of this, then intersection
	 */

	double dAslp;			/* A's slope angle */
	double dBslp;			/* B's slope angle */
	double eslope, erc, ers;	/* difference of slope angles */
	JgclVector2D Ac2Bc;		/* vector from A's center to B's vertex */
	JgclPoint2D eiBc;		/* transformed vertex of B */
	double dTol = par.getToleranceForDistance();

	// vector from B's center to A's center
	Ac2Bc = hyp.position().location().subtract(par.position().location());

	// inverse rotated point
	eiBc = trans.toLocal(Ac2Bc).toPoint2D();

	// make slope of A & B
	dAslp = Math.atan2(par.position().x().y(), par.position().x().x());
	dBslp = Math.atan2(hyp.position().x().y(), hyp.position().x().x());
	eslope = dBslp - dAslp;
	erc = Math.cos(eslope);
	ers = Math.sin(eslope);
	
	// make Coefficents of polynomial (real)
	double[] eprep =  new double[6];
	double[] ercoef = new double[5];

	double a  = par.focalDist();
	double e  = hyp.xRadius();
	double f  = hyp.yRadius();
	double cx = eiBc.x();
	double cy = eiBc.y();

	// make polynomial
	eprep[0] = (e * ers) * (e * ers);                   // H
	eprep[1] = (f * erc) * (f * erc);                   // I
	eprep[2] = 2.0 * e * f * erc * ers;                 // J
	eprep[3] = 2.0 * e * (cy * ers - 2.0 * a * erc);    // K
	eprep[4] = 2.0 * f * (cy * erc + 2.0 * a * ers);    // L
	eprep[5] = cy * cy - 4.0 * a * cx;                  // M

	ercoef[4] = eprep[1] + eprep[0];          // I+H
	ercoef[0] = eprep[5] + eprep[0];          // M+H
	ercoef[1] = eprep[2] * eprep[3];          // J+K
	ercoef[3] = 2.0 * (ercoef[4] * eprep[4] -
			   ercoef[1]);            // 2*((I+H)*L-(J+K))
	ercoef[1] = 2.0 * (ercoef[0] * eprep[4] -
			   ercoef[1]);            // 2*((M+H)*L-(J+K))
	ercoef[2] = 2.0 * ercoef[4] * ercoef[0] +
			  eprep[4]  * eprep[4] -
			  eprep[2]  * eprep[2] -
			  eprep[3]  * eprep[3];   // 2*(I+H)*(M+H)+L**2-J**2-K**2
	ercoef[4] = ercoef[4] * ercoef[4] -
		    eprep[2]  * eprep[2];         // (I+H)**2 - J**2
	ercoef[0] = ercoef[0] * ercoef[0] -
		    eprep[3]  * eprep[3];         // (M+H)**2 - K**2

	return ercoef;
    }

    /**
     * ̉ƑoȐ̌_߂
     * 
     * @param par     : A
     * @param hyp    oȐ : B
     * @param root ̉
     * @return		_
     */
    private JgclIntersectionPoint2D[]
	getIntersection(JgclParabola2D par, JgclHyperbola2D hyp,
			JgclComplex[] root,
			JgclCartesianTransformationOperator2D trans,
			boolean doExchange)
    {
	double dTol = par.getToleranceForDistance();
	Vector intervec = new Vector();

 	for (int i = 0; i < root.length; i++) {
	    double sinhB = root[i].real();
	    double coshB = Math.sqrt(1.0 + sinhB * sinhB);
	    double Bparam = Math.log(sinhB + coshB);
	    JgclPoint2D dDpnt = trans.toLocal(hyp.coordinates(Bparam));

	    double Aparam = dDpnt.y() / (2.0 * par.focalDist());

 	    // make intersection points
 	    JgclPointOnCurve2D aPnt = new JgclPointOnCurve2D(par, Aparam, JgclGeometry.doCheckDebug);
 	    JgclPointOnCurve2D bPnt = new JgclPointOnCurve2D(hyp, Bparam, JgclGeometry.doCheckDebug);

	    // identical check
 	    if (aPnt.identical(bPnt)) {
		JgclIntersectionPoint2D inter = new
		    JgclIntersectionPoint2D(aPnt, bPnt, JgclGeometry.doCheckDebug);
		// duplicate check
		if (inter != null && checkUnique(inter, intervec)) {
		    intervec.addElement(inter);
		}
 	    }
 	}

	JgclIntersectionPoint2D[] intersectPoints =
	    vectorToArray(intervec, doExchange);
 	return intersectPoints;
    }

    /**
     * ƑoȐ̌_߂
     * 
     * @param par  : A
     * @param hyp oȐ : B
     * @return		_
     */
    JgclIntersectionPoint2D[] intersection(JgclParabola2D par,
					   JgclHyperbola2D hyp,
					   boolean doExchange)
    {
	JgclCartesianTransformationOperator2D trans
	    = new JgclCartesianTransformationOperator2D(par.position(), 1.0);

	// get coefficent
	double[] coefficent = getCoefficent(par, hyp, trans);

	// get root of above polynomial
	JgclComplex[] root = getRoot(coefficent);
	if (root == null) {
	    return new JgclIntersectionPoint2D[0];
	}

	return getIntersection(par, hyp, root, trans, doExchange);
    }

    /**
     * m̌_߂邽߂̕Ă
     * 
     * @param parA   
     * @param parB   
     * @return		̌W
     */
    double[] getCoefficent(JgclParabola2D parA, JgclParabola2D parB,
			   JgclCartesianTransformationOperator2D trans)
    {
	/*
	 * NOTE:
	 *
	 * Point of inverse transformed of B (Parabola parB)is
	 *
	 *	x = cosP * B * t**2 - sinP * 2*B * t + Vx    ---> (1)
	 *	y = sinP * B * t**2 + cosP * 2*B * t + Vy
	 *
	 *	/  B = dB->focal_dist                     \
	 *	|  P = ( slope of B ) - ( slope of A )    |
	 *	\  V = ( vertex of B ) - ( vertex of A )  /
	 *
	 * Point of A (Parabola parA) is
	 *
	 *	x = A * s**2                                 ---> (2)
	 *	y = 2 * A * s
	 *	(A = dA->focal_dist)
	 *
	 * (1) & (2) -->
	 *
	 *	  ( B * sinP )**2                              * t**4
	 *	+ 4 * B**2 * sinP * cosP                       * t**3
	 *	+ 2 * B * ( Vy*sinP + 2*B*cosP**2 - 2*A*cosP ) * t**2
	 *	+ 4 * B * ( Vy*cosP + 2*A*sinP )               * t
	 *	+ Vy**2 -  4*A*Vx
	 *	= 0
	 *
	 * This is a 4th order polynomial for t.
	 * We'll get roots of this, then intersection
	 */

	double dAslp;			/* A's slope angle */
	double dBslp;			/* B's slope angle */
	double eslope, erc, ers;	/* difference of slope angles */
	JgclVector2D Ac2Bc;		/* vector from A's center to B's vertex */
	JgclPoint2D eiBc;		/* transformed vertex of B */
	double dTol = parA.getToleranceForDistance();

	// vector from B's center to A's center
	Ac2Bc = parB.position().location().subtract(parA.position().location());

	// inverse rotated point
	eiBc = trans.toLocal(Ac2Bc).toPoint2D();

	// make slope of A & B
	dAslp = Math.atan2(parA.position().x().y(), parA.position().x().x());
	dBslp = Math.atan2(parB.position().x().y(), parB.position().x().x());
	eslope = dBslp - dAslp;
	erc = Math.cos(eslope);
	ers = Math.sin(eslope);
	
	// make Coefficents of polynomial (real)
	double[] ercoef = new double[5];

	double a  = parA.focalDist();
	double b  = parB.focalDist();
	double vx = eiBc.x();
	double vy = eiBc.y();

	// make polynomial
	ercoef[4] = (b * ers) * (b * ers);
	ercoef[3] = 4.0 * b * b * ers * erc;
	ercoef[2] = 2.0 * b * (vy * ers + 2.0 * b * erc * erc - 2.0 * a * erc);
	ercoef[1] = 4.0 * b * (vy * erc + 2.0 * a * ers);
	ercoef[0] = vy * vy - 4.0 * a * vx;

	return ercoef;
    }

    /**
     * ̉m̌_߂
     * 
     * @param parA    : A
     * @param parB    : B
     * @param root ̉
     * @return		_
     */
    private JgclIntersectionPoint2D[]
	getIntersection(JgclParabola2D parA, JgclParabola2D parB,
			JgclComplex[] root,
			JgclCartesianTransformationOperator2D trans,
			boolean doExchange)
    {
	double dTol = parA.getToleranceForDistance();
	Vector intervec = new Vector();

 	for (int i = 0; i < root.length; i++) {
 	    double Bparam = root[i].real();

	    JgclPoint2D dDpnt = trans.toLocal(parB.coordinates(Bparam));
	    double Aparam = dDpnt.y() / (2.0 * parA.focalDist());

 	    // make intersection points
 	    JgclPointOnCurve2D aPnt = new JgclPointOnCurve2D(parA, Aparam, JgclGeometry.doCheckDebug);
 	    JgclPointOnCurve2D bPnt = new JgclPointOnCurve2D(parB, Bparam, JgclGeometry.doCheckDebug);

	    // identical check
 	    if (aPnt.identical(bPnt)) {
		JgclIntersectionPoint2D inter = new
		    JgclIntersectionPoint2D(aPnt, bPnt, JgclGeometry.doCheckDebug);
		// duplicate check
		if (inter != null && checkUnique(inter, intervec)) {
		    intervec.addElement(inter);
		}
 	    }
 	}

	JgclIntersectionPoint2D[] intersectPoints =
	    vectorToArray(intervec, doExchange);
 	return intersectPoints;
    }

    /**
     * m̌_߂
     * 
     * @param parA  A
     * @param parB  B
     * @return		_
     */
    JgclIntersectionPoint2D[] intersection(JgclParabola2D parA,
					   JgclParabola2D parB,
					   boolean doExchange)
    {
	JgclCartesianTransformationOperator2D trans
	    = new JgclCartesianTransformationOperator2D(parA.position(), 1.0);

	// get root of polynomial
	double[] coefficent = getCoefficent(parA, parB, trans);
	JgclComplex[] root = getRoot(coefficent);
	if (root == null) {
	    return new JgclIntersectionPoint2D[0];
	}

	return getIntersection(parA, parB, root, trans, doExchange);
    }
}
