/*
 * 3D ȐBXvCȖʂ̌_߂NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclIntsCrvBss3D.java,v 1.9 2000/08/11 06:18:51 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * 3D ȐBXvCȖʂ̌_߂NX
 *
 * @version $Revision: 1.9 $, $Date: 2000/08/11 06:18:51 $
 * @author Information-technology Promotion Agency, Japan
 */
final class JgclIntsCrvBss3D
{
    static final boolean debug = false;

    /**
     * ȐBXvCȖʂ̊𓾂
     *
     * @param	crvA	Ȑ A
     * @param	bssB	BXvCȖ B
     * @return		ȐƋȖʂ̊̃Xg
     * @see		JgclCurveCurveInterferenceList
     */
    private static JgclCurveSurfaceInterferenceList
    getInterference(JgclParametricCurve3D crvA,
		    JgclBsplineSurface3D bssB)
		    
    {
	// Ȗ B U/V̗LȃZOg̏
	JgclBsplineKnot.ValidSegmentInfo vldsBu = bssB.uValidSegments();
	JgclBsplineKnot.ValidSegmentInfo vldsBv = bssB.vValidSegments();
	// Ȑ B \xWGȐ
	JgclPureBezierSurface3D[][] bzssB = bssB.toPureBezierSurfaceArray();

	// ̃Xg
	JgclCurveSurfaceInterferenceList interferenceList
	    = new JgclCurveSurfaceInterferenceList(crvA, bssB);

	JgclIntersectionPoint3D[] ints;

	// Ȗ B ŮeZOgɑ΂
	for (int iBu = 0; iBu < bzssB.length; iBu++) {
	    // Ȗ B V̊eZOgɑ΂
	    for (int iBv = 0; iBv < bzssB[iBu].length; iBv++) {
		if (debug) {
		    crvA.output(System.out);
		    bzssB[iBu][iBv].output(System.out);
		}

		// xWGȖʃxł̊𓾂
		try {
		    ints = crvA.intersect(bzssB[iBu][iBv]);
		} catch (JgclIndefiniteSolution e) {
		    throw new JgclFatal();
		}

		// _Xgɒǉ
		for (int i = 0; i < ints.length; i++) {
		    interferenceList.addAsIntersection
			(ints[i].coordinates(),
			 ints[i].pointOnCurve1().parameter(),
			 vldsBu.l2Gp(iBu, ints[i].pointOnSurface2().uParameter()),
			 vldsBv.l2Gp(iBv, ints[i].pointOnSurface2().vParameter()));
		}
	    }
	}

	return interferenceList;
    }

    /**
     * ȐBXvCȖʂ̌_𓾂
     *
     * @param	crvA	Ȑ A
     * @param	bssB	BXvCȖ B
     * @return		ȐƋȖʂ̌_̔z
     * @see		JgclIntersectionPoint3D
     */
    static JgclIntersectionPoint3D[] intersection(JgclParametricCurve3D crvA,
						  JgclBsplineSurface3D bssB,
						  boolean doExchange) {
	return getInterference(crvA, bssB).toJgclIntersectionPoint3DArray(doExchange);
    }
}

// end of file
