/*
 * 3DxWGȐm̌_߂NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclIntsBzcBzc3D.java,v 1.16 2000/04/26 09:38:59 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * 3DxWGȐm̌_߂NX
 *
 * @version $Revision: 1.16 $, $Date: 2000/04/26 09:38:59 $
 * @author Information-technology Promotion Agency, Japan
 */

class JgclIntsBzcBzc3D {
    /**
     * ^ꂽxWGȐ A
     * @see JgclPureBezierCurve3D
     */
    private JgclPureBezierCurve3D dA;

    /**
     * ^ꂽxWGȐ B
     * @see JgclPureBezierCurve3D
     */
    private JgclPureBezierCurve3D dB;

    /**
     *	ȐA̕\񕪖
     * @see JgclBinaryTree
     */
    private JgclBinaryTree Atree;

    /*
     * ۑĂXg
     * @see JgclCurveCurveInterferenceList
     */
    private JgclCurveCurveInterferenceList sol_list;

    static final int IGNORE_X = 0;
    static final int IGNORE_Y = 1;
    static final int IGNORE_Z = 2;
    private int ignoredDimension;	// temporally used in refinePointInfo
    private JgclPoint3D sApnt;		// temporally used in refinePointInfo
    private JgclPoint3D sBpnt;		// temporally used in refinePointInfo
    private JgclVector3D sAtang;	// temporally used in refinePointInfo
    private JgclVector3D sBtang;	// temporally used in refinePointInfo

    /**
     * IuWFNg\z
     *
     * @param bzc1	xWGȐ A
     * @param bzc2	xWGȐ B
     * @see JgclPureBezierCurve3D
     */
    private JgclIntsBzcBzc3D(JgclPureBezierCurve3D bzc1, JgclPureBezierCurve3D bzc2) {
	super();

	dA = bzc1;
	dB = bzc2;

	double d_tol = dA.getToleranceForDistance();

	/*
	 * Initialize Binary Trees
	 */
	Atree = new JgclBinaryTree(new BezierInfo(dA, 0.0, 1.0, false));

	sol_list = new JgclCurveCurveInterferenceList(bzc1, bzc2);
    }

    private static final int UNKNOWN = 0;
    private static final int BEZIER = 1;
    private static final int LINE = 2;
    private static final int POINT = 3;

    /**
     * ꂽxWGȐZOg\NX
     */
    private class BezierInfo {
	/**
	 * ꂽxWGȐZOg̎
	 * @see JgclPureBezierCurve2D
	 */
	private JgclPureBezierCurve3D bzc;

	/**
	 * ̃xWGȐł̎n_̃p[^
	 */
	private double sp;

	/**
	 * ̃xWGȐł̏I_̃p[^
	 */
	private double ep;

	/**
	 * ݔ͈͂
	 * @see JgclEnclosingBox3D
	 */
	private JgclEnclosingBox3D box;

	/**
	 * (ꂽ)ZOg̃Xg
	 */
	private Vector rivals;

	/**
	 * `̓\
	 *	UNKNOWN:	
	 *	POINT:		_ł
	 *	LINE:		ł
	 *	BEZIER:		_łłȂxWGȐ
	 */
	private int crnt_type;

	/*
	 * `̓\vf
	 * crnt_typePOINT:	JgclPoint3D
	 * crnt_typeLINE:	JgclLine3D
	 * ̑:		null
	 */
	private JgclGeometry geom;

	/**
	 * IuWFNg\z
	 *
	 * @param bzc	ꂽxWGȐZOg̎
	 * @param sp	̃xWGȐł̎n_̃p[^
	 * @param ep	̃xWGȐł̏I_̃p[^
	 * @param hasRivals	肪邩?
	 * @see JgclPureBezierCurve3D
	 */
	private BezierInfo(JgclPureBezierCurve3D bzc, double sp, double ep, boolean hasRivals) {
	    super();
	    this.bzc = bzc;
	    this.sp = sp;
	    this.ep = ep;
	    this.box = bzc.approximateEnclosingBox();

	    if (hasRivals)
		this.rivals = new Vector();
	    else 
		this.rivals = null;
	    this.crnt_type = UNKNOWN;
	    this.geom = null;
	}

	/**
	 * geomJgclPoint3DƂ݂ȂāA̒lԂ
	 * @return	geomJgclPoint3Dɕϊl
	 */
	private JgclPoint3D pnt() {
	    return (JgclPoint3D)geom;
	}

	/**
	 * geomJgclLine3DƂ݂ȂāA̒lԂ
	 * @return	geomJgclLine3Dɕϊl
	 */
	private JgclLine3D line() {
	    return (JgclLine3D)geom;
	}

	/**
	 * `̓𒲂ׂB
	 * ܂ׂʂPOINTLINȄꍇ́A
	 * geomɂ̎̂ZbgB
	 * @return	`̓(POINT/LINE/BEZIER̂ꂩ)
	 */
	private int whatTypeIsBezier() {
	    if (crnt_type != UNKNOWN)
		return crnt_type;

	    int uicp = bzc.nControlPoints();

	    JgclVector3D s2e;
	    double leng_s2e;
	    JgclVector3D unit_s2e;
	    JgclVector3D s2c;
	    JgclVector3D crsv;
	    double leng;
	    int i;
	    double d_tol = bzc.getToleranceForDistance();

	    s2e = bzc.controlPointAt(uicp - 1).subtract(bzc.controlPointAt(0));
	    leng_s2e = s2e.length();

	    if (leng_s2e < d_tol) {
		for (i = 1; i < (uicp - 1); i++) {
		    s2c = bzc.controlPointAt(i).subtract(bzc.controlPointAt(0));
		    if (!(s2c.length() < d_tol))
			break;
		}

		if (i == (uicp - 1)) {
		    /*
		     * Point
		     */
		    JgclPoint3D pnt_geom
			= bzc.controlPointAt(uicp-1).linearInterpolate(bzc.controlPointAt(0), 0.5);

		    geom = pnt_geom;
		    return crnt_type = POINT;
		} else {
		    /*
		     * Bezier
		     */
		    geom = null;
		    return crnt_type = BEZIER;
		}
	    }

	    unit_s2e = s2e.divide(leng_s2e);

	    for (i = 1; i < (uicp - 1); i++) {
		s2c = bzc.controlPointAt(i).subtract(bzc.controlPointAt(0));
		crsv = unit_s2e.crossProduct(s2c);
		if (crsv.length() > d_tol) {
		    /*
		     * Bezier
		     */
		    geom = null;
		    return crnt_type = BEZIER;
		}

		leng = unit_s2e.dotProduct(s2c);
		if ((leng < (0.0 - d_tol)) || (leng > (leng_s2e + d_tol))) {
		    /*
		     * Bezier
		     */
		    geom = null;
		    return crnt_type = BEZIER;
		}
	    }

	    /*
	     * Line
	     */
	    JgclLine3D lin_geom = new JgclLine3D(bzc.controlPointAt(0), s2e);

	    geom = lin_geom;
	    return crnt_type = LINE;
	}

	/**
	 * g̃p[^̃xWGȐ̃p[^ɕϊB
	 * @param param	g̃p[^
	 * @return	̋ȐƂẴp[^
	 */
	private double toBezierParam(double param) {
	    return (1.0 - param) * sp + param * ep;
	}
    }

    /**
     * LINEABEZIER̂ƂɁA
     * 2ZOg\邩ǂׂ
     * @param dA	LINEȂZOg
     * @param dB	̃ZOg
     * @return		\邩ǂ
     * @see	BezierInfo
     */
    private boolean checkLineBezier(BezierInfo dA, BezierInfo dB) {
	if (dA.crnt_type == LINE) {
	    if ((dB.crnt_type == UNKNOWN) || (dB.crnt_type == BEZIER)) {
		JgclLine3D line;
		JgclEnclosingBox3D bx = dB.box;
		JgclCartesianTransformationOperator3D trns;
		JgclVector3D[] xyz = new JgclVector3D[3];
		JgclPoint3D[] box_pnts = new JgclPoint3D[8];
		double min_x, min_y, max_x, max_y;
		double d_tol = dA.bzc.getToleranceForDistance();
		int i;

		line = dA.line();
		xyz[2] = line.dir();
		xyz[0] = xyz[2].verticalVector();
		xyz[1] = xyz[2].crossProduct(xyz[0]);
		trns = new JgclCartesianTransformationOperator3D(xyz[0], xyz[1], xyz[2],
								 line.pnt(), 1.0);
		box_pnts[0] = new JgclCartesianPoint3D(bx.min().x(), bx.min().y(), bx.min().z());
		box_pnts[1] = new JgclCartesianPoint3D(bx.max().x(), bx.min().y(), bx.min().z());
		box_pnts[2] = new JgclCartesianPoint3D(bx.max().x(), bx.max().y(), bx.min().z());
		box_pnts[3] = new JgclCartesianPoint3D(bx.min().x(), bx.max().y(), bx.min().z());
		box_pnts[4] = new JgclCartesianPoint3D(bx.min().x(), bx.min().y(), bx.max().z());
		box_pnts[5] = new JgclCartesianPoint3D(bx.max().x(), bx.min().y(), bx.max().z());
		box_pnts[6] = new JgclCartesianPoint3D(bx.max().x(), bx.max().y(), bx.max().z());
		box_pnts[7] = new JgclCartesianPoint3D(bx.min().x(), bx.max().y(), bx.max().z());

		box_pnts[0] = trns.toLocal(box_pnts[0]);
		min_x = max_x = box_pnts[0].x();
		min_y = max_y = box_pnts[0].y();

		for (i = 1; i < 8; i++) {
		    box_pnts[i] = trns.toLocal(box_pnts[i]);
		    min_x = Math.min(box_pnts[i].x(), min_x);
		    min_y = Math.min(box_pnts[i].y(), min_y);
		    max_x = Math.max(box_pnts[i].x(), max_x);
		    max_y = Math.max(box_pnts[i].y(), max_y);
		}
		if (!((min_x < d_tol) &&
		      (min_y < d_tol) &&
		      (max_x > (- d_tol)) &&
		      (max_y > (- d_tol))))
		    return false;	/* no interfere */
	    }
	}
	return true;
    }

    /**
     * 2ZOg\邩ǂׂ
     * @param dA	ZOgA
     * @param dB	ZOgB
     * @return		\邩ǂ
     * @see	BezierInfo
     */
    private boolean checkInterfere(BezierInfo dA, BezierInfo dB) {
	/*
	 * if one curve is already linear and another is still Bezier,
	 * special consideration will be applied.
	 */
	if (!checkLineBezier(dA, dB))
	    return false;
	if (!checkLineBezier(dB, dA))
	    return false;

	/*
	 * check Box vs. Box interfere
	 */
	return dA.box.hasIntersection(dB.box);
    }

    /**
     * 𕪊B
     * ꂽZOg<code>new_rivals</code>Ɋi[B
     * 肪ɕĂƂ(qm[hƂ)͎qm[hi[B
     * 肪POINT/LINEłꍇ́Aɂ̂܂܊i[B
     * @param dANode	ΏۂƂȂ鑊\񕪖؂̃m[h
     * @param new_rivals	i[郊Xg
     * @return	ꂽ(m[hBezierʂBEZIERȂ)<code>true</code>A
     *		ȂȂ(BEZIERȊOȂ)<code>false</code>
     * @see JgclBinaryTree.Node
     */
    private boolean divideRivals(JgclBinaryTree.Node dANode, Vector new_rivals) {
	JgclBinaryTree.Node binL, binR;

	if (dANode.left() == null && dANode.right() == null) {
	    BezierInfo bi = (BezierInfo)dANode.data();

	    if (bi.whatTypeIsBezier() != BEZIER) {
		new_rivals.addElement(dANode);
		return false;
	    }

	    /*
	     * subdivide rival
	     */
	    double half_point = 0.5;
	    JgclPureBezierCurve3D[] bzcs = bi.bzc.divide(half_point);

	    double g_half_point = (bi.sp + bi.ep) / 2.0;

	    BezierInfo biL = new BezierInfo(bzcs[0], bi.sp, g_half_point, false);
	    binL = dANode.makeLeft(biL);

	    BezierInfo biR = new BezierInfo(bzcs[1], g_half_point, bi.ep, false);
	    binR = dANode.makeRight(biR);

	} else {

	    binL = dANode.left();
	    binR = dANode.right();
	}

	new_rivals.addElement(binL);
	new_rivals.addElement(binR);

	return true;
    }

    /**
     * _(̏l)\NX
     */
    private class PointInfo {
	/**
	 * Wl
	 * @see	JgclPoint3D
	 */
	private JgclPoint3D pnt;

	/**
	 * ȐÃp[^
	 */
	private double Apara;

	/**
	 * ȐB̃p[^
	 */
	private double Bpara;

	/**
	 * IuWFNg\z
	 *
	 * @param pnt	Wl
	 * @param Apara	ȐÃp[^
	 * @param Bpara	ȐB̃p[^
	 * @see JgclPoint3D
	 */
	private PointInfo(JgclPoint3D pnt, double Apara, double Bpara) {
	    this.pnt = pnt;
	    this.Apara = Apara;
	    this.Bpara = Bpara;
	}

	/**
	 * IuWFNg\z
	 *
	 * @param x	xWl
	 * @param y	yWl
	 * @param z	zWl
	 * @param Apara	ȐÃp[^
	 * @param Bpara	ȐB̃p[^
	 */
	private PointInfo(double x, double y, double z, double Apara, double Bpara) {
	    this.pnt = new JgclCartesianPoint3D(x, y, z);
	    this.Apara = Apara;
	    this.Bpara = Bpara;
	}
    }

    /**
     * POINTALINÊƂɌ_߂
     * _ɓeāAe_΂ԂB
     * @param pbi	POINTł镪ZOg
     * @param lbi	LINEł镪ZOg
     * @return	_(݂ȂƂnull)
     */
    private PointInfo
    intersectPntLine(BezierInfo pbi, BezierInfo lbi) {
	JgclPoint3D pnt = pbi.pnt();
	JgclLine3D line = lbi.line();
	JgclBoundedLine3D bln = new JgclBoundedLine3D(line.pnt(), line.dir());
	JgclPointOnCurve3D poc;

	if ((poc = bln.project1From(pnt)) == null)
	    return null;		// no solution

	double Apara = (pbi.sp + pbi.ep) / 2.0;
	double Bpara = lbi.toBezierParam(poc.parameter());
	return new PointInfo(poc.x(), poc.y(), poc.z(), Apara, Bpara);
    }

    private double[] setupParams(PointInfo pinfo) {
	double[] param = new double[2];
	param[0] = pinfo.Apara;
	param[1] = pinfo.Bpara;
	double Apara = dA.parameterDomain().force(param[0]);
	double Bpara = dB.parameterDomain().force(param[1]);

	JgclVector3D Atang = dA.tangentVector(Apara);
	if (Atang.identical(JgclVector3D.zeroVector)) {
	    if (Apara < 0.5)
		Apara += 0.01;
	    else
		Apara -= 0.01;
	    Atang = dA.tangentVector(Apara);
	}
	JgclVector3D Btang = dB.tangentVector(Bpara);
	if (Btang.identical(JgclVector3D.zeroVector)) {
	    if (Bpara < 0.5)
		Bpara += 0.01;
	    else
		Bpara -= 0.01;
	    Btang = dB.tangentVector(Bpara);
	}

	JgclVector3D ecrs = Atang.crossProduct(Btang);

	ignoredDimension = (Math.abs(ecrs.x()) > Math.abs(ecrs.y())) ? IGNORE_X : IGNORE_Y;
	if (ignoredDimension == IGNORE_X) {
	    if (Math.abs(ecrs.x()) < Math.abs(ecrs.z()))
		ignoredDimension = IGNORE_Z;
	} else {
	    if (Math.abs(ecrs.y()) < Math.abs(ecrs.z()))
		ignoredDimension = IGNORE_Z;
	}

	return param;
    }

    /**
     * _refinement: Åe̒l߂
     * @see	JgclMath#solveSimultaneousEquations(JgclRealFunction, JgclRealFunction[],
     *					    JgclBooleanFunctionWithRealVariables, double[])
     */
    private class nlFunc implements JgclRealFunction {
	private nlFunc() {
	    super();
	}

	public double[] evaluate(double[] parameter) {
	    double[] vctr = new double[2];
	    JgclVector3D evec;

	    /*
	     * sApnt & sBpnt are already computed by previous cnvFunc.evaluate()
	     */
	    evec = sApnt.subtract(sBpnt);

	    switch (ignoredDimension) {
	    case IGNORE_X:	vctr[0] = evec.y();	vctr[1] = evec.z();	break;
	    case IGNORE_Y:	vctr[0] = evec.z();	vctr[1] = evec.x();	break;
	    case IGNORE_Z:	vctr[0] = evec.x();	vctr[1] = evec.y();	break;
	    }

	    return vctr;
	}
    }

    /**
     * _refinement: Åe̕Δ̒l߂
     * @see	JgclMath#solveSimultaneousEquations(JgclRealFunction, JgclRealFunction[],
     *					    JgclBooleanFunctionWithRealVariables, double[])
     */
    private class dnlFunc implements JgclRealFunction {
	int idx;
	private dnlFunc(int idx) {
	    super();
	    this.idx = idx;
	}

	public double[] evaluate(double[] parameter) {
	    double[] mtrx = new double[2];
	    if (idx == 0) {	/* this must be called first */
		sAtang = dA.tangentVector(dA.parameterDomain().force(parameter[0]));
		sBtang = dB.tangentVector(dB.parameterDomain().force(parameter[1]));
		switch (ignoredDimension) {
		case IGNORE_X:	mtrx[0] = sAtang.y();	mtrx[1] = (- sBtang.y());	break;
		case IGNORE_Y:	mtrx[0] = sAtang.z();	mtrx[1] = (- sBtang.z());	break;
		case IGNORE_Z:	mtrx[0] = sAtang.x();	mtrx[1] = (- sBtang.x());	break;
		}
	    } else {
		switch (ignoredDimension) {
		case IGNORE_X:	mtrx[0] = sAtang.z();	mtrx[1] = (- sBtang.z());	break;
		case IGNORE_Y:	mtrx[0] = sAtang.x();	mtrx[1] = (- sBtang.x());	break;
		case IGNORE_Z:	mtrx[0] = sAtang.y();	mtrx[1] = (- sBtang.y());	break;
		}
	    }
	    return mtrx;
	}
    }

    /**
     * _refinement: Ảǂ𔻒肷
     * @see	JgclMath#solveSimultaneousEquations(JgclRealFunction, JgclRealFunction[],
     *					    JgclBooleanFunctionWithRealVariables, double[])
     */
    private class cnvFunc implements JgclBooleanFunctionWithRealVariables {
	private cnvFunc() {
	    super();
	}

	public boolean evaluate(double[] parameter) {
	    sApnt = dA.coordinates(dA.parameterDomain().force(parameter[0]));
	    sBpnt = dB.coordinates(dB.parameterDomain().force(parameter[1]));

	    return sApnt.identical(sBpnt);
	}
    }

    private void setbackParams(PointInfo pi, double param[]) {
	JgclPoint3D Apnt, Bpnt;

	pi.Apara = dA.parameterDomain().force(param[0]);
	pi.Bpara = dB.parameterDomain().force(param[1]);

	Apnt = dA.coordinates(pi.Apara);
	Bpnt = dB.coordinates(pi.Bpara);

	pi.pnt = Apnt.linearInterpolate(Bpnt, 0.5);
    }

    /**
     * _refinements
     * @param	refine_
     * @return	ǂ
     */
    private boolean refinePointInfo(PointInfo pinfo) {
	nlFunc nl_func = new nlFunc();
	JgclRealFunction[] dnl_func = new JgclRealFunction[2];
	dnl_func[0] = new dnlFunc(0);
	dnl_func[1] = new dnlFunc(1);
	cnvFunc cnv_func = new cnvFunc();
	double[] param = setupParams(pinfo);

	param = JgclMath.solveSimultaneousEquations(nl_func, dnl_func, cnv_func, param);
	if (param == null)
	    return false;

	setbackParams(pinfo, param);
	return true;
    }

    /**
     * POINTLINEƂ݂Ȃꂽ2̃ZOgm̌_𓾂B
     * @param dA	POINTLINEƂ݂ȂꂽZOgA
     * @param dB	POINTLINEƂ݂ȂꂽZOgB
     */
    private void intersectLines(BezierInfo dA, BezierInfo dB) {
	if (false) {	// for debug
	    JgclPoint3D pnt1 = dA.bzc.controlPointAt(0);
	    JgclPoint3D pnt2 = dA.bzc.controlPointAt(dA.bzc.nControlPoints()-1);
	    JgclPoint3D pntA = pnt1.linearInterpolate(pnt2, 0.5);
	    pnt1 = dB.bzc.controlPointAt(0);
	    pnt2 = dB.bzc.controlPointAt(dB.bzc.nControlPoints()-1);
	    JgclPoint3D pntB = pnt1.linearInterpolate(pnt2, 0.5);
	    JgclPoint3D pnt = pntA.linearInterpolate(pntB, 0.5);
	    double paramA = (dA.sp + dA.ep) * 0.5;
	    double paramB = (dB.sp + dB.ep) * 0.5;

	    sol_list.addAsIntersection(pnt, paramA, paramB);
	    return;
	}

	PointInfo ints_pnt;

	double x, y, z;
	double Apara, Bpara;
	int i;

	if (dA.crnt_type == POINT) {
	    if (dB.crnt_type == POINT) {
		x = (dA.pnt().x() + dB.pnt().x()) / 2.0;
		y = (dA.pnt().y() + dB.pnt().y()) / 2.0;
		z = (dA.pnt().z() + dB.pnt().z()) / 2.0;
		Apara = (dA.sp + dA.ep) / 2.0;
		Bpara = (dB.sp + dB.ep) / 2.0;

		ints_pnt = new PointInfo(x, y, z, Apara, Bpara);

	    } else {
		if ((ints_pnt = intersectPntLine(dA, dB)) == null)
		    return;
	    }

	} else if (dA.crnt_type == LINE) {
	    if (dB.crnt_type == LINE) {
		JgclBoundedLine3D Abln;
		JgclBoundedLine3D Bbln;
		JgclCurveCurveInterference3D intf;

		Abln = new JgclBoundedLine3D(dA.bzc.controlPointAt(0),
					     dA.bzc.controlPointAt(dA.bzc.nControlPoints() - 1));
		Bbln = new JgclBoundedLine3D(dB.bzc.controlPointAt(0),
					     dB.bzc.controlPointAt(dB.bzc.nControlPoints() - 1));

		if ((intf = Abln.interfere1(Bbln)) == null)
		    return;

		if (intf.isIntersectionPoint()) {
		    /*
		     * intersect
		     */
		    JgclIntersectionPoint3D ints = intf.toIntersectionPoint();

		    Apara = dA.toBezierParam(ints.pointOnCurve1().parameter());
		    Bpara = dB.toBezierParam(ints.pointOnCurve2().parameter());
			
		    ints_pnt = new PointInfo(ints.x(), ints.y(), ints.z(), Apara, Bpara);

		} else {
		    /*
		     * overlap
		     */
		    JgclOverlapCurve3D ovlp = intf.toOverlapCurve();
		    double x1, y1, x2, y2;

		    x1 = dA.toBezierParam(ovlp.start1());
		    y1 = dB.toBezierParam(ovlp.start2());
		    x2 = dA.toBezierParam(ovlp.end1());
		    y2 = dB.toBezierParam(ovlp.end2());

		    sol_list.addAsOverlap(x1, y1, x2 - x1, y2 - y1);

		    return;
		}

	    } else {
		if ((ints_pnt = intersectPntLine(dB, dA)) == null) {
		    return;
		}
	    }
	} else {	// not reached
	    return;
	}

	if (refinePointInfo(ints_pnt))
	    sol_list.addAsIntersection(ints_pnt.pnt, ints_pnt.Apara, ints_pnt.Bpara);

	return;
    }

    /**
     * Main Process
     * <p>
     * ΏۃZOgƂrivalsƂ̌𓾂B
     * </p><p>
     * ΏۃZOg_͐Ƃ݂ȂꂽA
     * rivals_͐Ƃ݂Ȃ܂ŕA
     * _𓾂B
     * </p><p>
     * ΏۃZOg܂_Ƃ݂ȂȂꍇ́A
     * ΏۃZOgтrivals𕪊A
     * O2ZOgɑ΂čċAIɎgĂяoB
     * </p>
     * @param crnt_bi	ΏۂƂȂ镪ZOg
     * @see	BezierInfo
     */
    private void getIntersections(BezierInfo crnt_bi) {
	JgclBinaryTree.Node dANode;
	int i;

	/*
	 * remove rivals which have no possibility of interference
	 */
	int n_rivals = crnt_bi.rivals.size();
	for (i = n_rivals - 1; i >= 0; i--) {
	    dANode = (JgclBinaryTree.Node)crnt_bi.rivals.elementAt(i);
	    if (!checkInterfere((BezierInfo)dANode.data(), crnt_bi))
		crnt_bi.rivals.removeElementAt(i);
	}
	if (crnt_bi.rivals.size() == 0)
	    return;

	/*
	 * if current bezier is regarded as line, get intersections
	 */
	if (crnt_bi.whatTypeIsBezier() != BEZIER) {
	    Vector new_rivals = new Vector();

	    boolean all_rivals_are_line = true;

	    n_rivals = crnt_bi.rivals.size();
	    for (i = 0; i < n_rivals; i++)
		if (divideRivals((JgclBinaryTree.Node)crnt_bi.rivals.elementAt(i), new_rivals))
		    all_rivals_are_line = false;

	    crnt_bi.rivals = new_rivals;

	    if (!all_rivals_are_line) {
		/*
		 * try again
		 */
		getIntersections(crnt_bi);
	    } else {
		/*
		 * get intersections
		 */
		n_rivals = crnt_bi.rivals.size();
		for (i = 0; i < n_rivals; i++) {
		    dANode = (JgclBinaryTree.Node)crnt_bi.rivals.elementAt(i);
		    intersectLines((BezierInfo)dANode.data(), crnt_bi);
		}
	    }
	    return;
	}

	/*
	 * generate children (divide current bezier)
	 */
	double half_point = 0.5;
	JgclPureBezierCurve3D[] bzcs = crnt_bi.bzc.divide(half_point);

	double g_half_point = (crnt_bi.sp + crnt_bi.ep) / 2.0;

	BezierInfo biL = new BezierInfo(bzcs[0], crnt_bi.sp, g_half_point, true);
	BezierInfo biR = new BezierInfo(bzcs[1], g_half_point, crnt_bi.ep, true);

	/*
	 * create children's rival list
	 */
	n_rivals = crnt_bi.rivals.size();
	for (i = 0; i < n_rivals; i++)
	    divideRivals((JgclBinaryTree.Node)crnt_bi.rivals.elementAt(i), biL.rivals);

	n_rivals = biL.rivals.size();
	for (i = 0; i < n_rivals; i++)
	    biR.rivals.addElement(biL.rivals.elementAt(i));

	/*
	 * recursive call
	 */
	getIntersections(biL);
	getIntersections(biR);
    }

    /**
     * 2xWGȐ̊߂ŏʃ\bh
     */
    private JgclCurveCurveInterferenceList getInterference() {
	BezierInfo dBRoot;

	dBRoot = new BezierInfo(dB, 0.0, 1.0, true);
	dBRoot.rivals.addElement(Atree.rootNode());

	/*
	 * Get Intersections
	 */
	getIntersections(dBRoot);

	sol_list.removeOverlapsContainedInOtherOverlap();
	sol_list.removeIntersectionsContainedInOverlap();

	return sol_list;
    }

    /**
     * 2xWGȐ̌_𓾂
     *
     * @param poly1	xWGȐ1
     * @param poly2	xWGȐ2
     * @return		_̔z
     * @see		JgclIntersectionPoint3D
     */
    static JgclIntersectionPoint3D[] intersection(JgclPureBezierCurve3D bzc1,
						  JgclPureBezierCurve3D bzc2,
						  boolean doExchange) {
	JgclIntsBzcBzc3D doObj = new JgclIntsBzcBzc3D(bzc1, bzc2);
	return doObj.getInterference().toJgclIntersectionPoint3DArray(doExchange);
    }

    /**
     * 2xWGȐ̊𓾂
     *
     * @param poly1	xWGȐ1
     * @param poly2	xWGȐ2
     * @return		2Ȑ̊̔z
     * @see		JgclCurveCurveInterference3D
     */
    static JgclCurveCurveInterference3D[] interference(JgclPureBezierCurve3D bzc1,
						       JgclPureBezierCurve3D bzc2,
						       boolean doExchange) {
	JgclIntsBzcBzc3D doObj = new JgclIntsBzcBzc3D(bzc1, bzc2);
	return doObj.getInterference().toJgclCurveCurveInterference3DArray(doExchange);
    }
}
