/*
 * 2DxWGȐm̌_߂NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclIntsBzcBzc2D.java,v 1.18 2000/08/11 06:18:50 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * 2DxWGȐm̌_߂NX
 *
 * @version $Revision: 1.18 $, $Date: 2000/08/11 06:18:50 $
 * @author Information-technology Promotion Agency, Japan
 */

class JgclIntsBzcBzc2D {
    private static final double pTol = 0.001;

    /**
     * ^ꂽxWGȐ A
     * @see JgclPureBezierCurve2D
     */
    private JgclPureBezierCurve2D dA;

    /**
     * ^ꂽxWGȐ B
     * @see JgclPureBezierCurve2D
     */
    private JgclPureBezierCurve2D dB;

    /**
     * ȐÃp[^e덷̋ߎl
     */
    private double aprx_ptolA;

    /**
     * ȐÃp[^e덷̋ߎl
     */
    private double aprx_ptolB;

    /**
     *	ȐA̕\񕪖
     * @see JgclBinaryTree
     */
    private JgclBinaryTree Atree;

    /*
     * ۑĂXg
     * @see JgclCurveCurveInterferenceList
     */
    private JgclCurveCurveInterferenceList sol_list;

    private JgclPoint2D sApnt;		// temporally used in refinePointInfo
    private JgclPoint2D sBpnt;		// temporally used in refinePointInfo
    private JgclVector2D sAtang;	// temporally used in refinePointInfo
    private JgclVector2D sBtang;	// temporally used in refinePointInfo

    private static double getPtol(double d_tol, double length) {
	double tol = d_tol / length * 10.0;
	if (tol < pTol)
	    tol = pTol;
	return tol;
    }

    /**
     * IuWFNg\z
     *
     * @param bzc1	xWGȐ A
     * @param bzc2	xWGȐ B
     * @see JgclPureBezierCurve2D
     */
    private JgclIntsBzcBzc2D(JgclPureBezierCurve2D bzc1, JgclPureBezierCurve2D bzc2) {
	super();

	dA = bzc1;
	dB = bzc2;

	double d_tol = dA.getToleranceForDistance();

	aprx_ptolA = getPtol(d_tol, dA.approximateLength());
	aprx_ptolB = getPtol(d_tol, dB.approximateLength());

	/*
	 * Initialize Binary Trees
	 */
	Atree = new JgclBinaryTree(new BezierInfo(dA, 0.0, 1.0, false));

	sol_list = new JgclCurveCurveInterferenceList(bzc1, bzc2);
    }

    private static final int UNKNOWN = 0;
    private static final int BEZIER = 1;
    private static final int LINE = 2;
    private static final int POINT = 3;

    /**
     * ꂽxWGȐZOg\NX
     */
    private class BezierInfo {
	/**
	 * ꂽxWGȐZOg̎
	 * @see JgclPureBezierCurve2D
	 */
	private JgclPureBezierCurve2D bzc;

	/**
	 * ̃xWGȐł̎n_̃p[^
	 */
	private double sp;

	/**
	 * ̃xWGȐł̏I_̃p[^
	 */
	private double ep;

	/**
	 * ݔ͈͂`
	 * @see JgclEnclosingBox2D
	 */
	private JgclEnclosingBox2D box;

	/**
	 * (ꂽ)ZOg̃Xg
	 */
	private Vector rivals;

	/**
	 * `̓\
	 *	UNKNOWN:	
	 *	POINT:		_ł
	 *	LINE:		ł
	 *	BEZIER:		_łłȂxWGȐ
	 */
	private int crnt_type;

	/*
	 * `̓\vf
	 * crnt_typePOINT:	JgclPoint2D
	 * crnt_typeLINE:	JgclLine2D
	 * ̑:		null
	 */
	private JgclGeometry geom;

	/**
	 * IuWFNg\z
	 *
	 * @param bzc	ꂽxWGȐZOg̎
	 * @param sp	̃xWGȐł̎n_̃p[^
	 * @param ep	̃xWGȐł̏I_̃p[^
	 * @param hasRivals	肪邩?
	 * @see JgclPureBezierCurve2D
	 */
	private BezierInfo(JgclPureBezierCurve2D bzc, double sp, double ep, boolean hasRivals) {
	    super();
	    this.bzc = bzc;
	    this.sp = sp;
	    this.ep = ep;
	    this.box = bzc.approximateEnclosingBox();

	    if (hasRivals)
		this.rivals = new Vector();
	    else 
		this.rivals = null;
	    this.crnt_type = UNKNOWN;
	    this.geom = null;
	}

	/**
	 * geomJgclPoint2DƂ݂ȂāA̒lԂ
	 * @return	geomJgclPoint2Dɕϊl
	 */
	private JgclPoint2D pnt() {
	    return (JgclPoint2D)geom;
	}

	/**
	 * geomJgclLine2DƂ݂ȂāA̒lԂ
	 * @return	geomJgclLine2Dɕϊl
	 */
	private JgclLine2D line() {
	    return (JgclLine2D)geom;
	}

	/**
	 * `̓𒲂ׂB
	 * ܂ׂʂPOINTLINȄꍇ́A
	 * geomɂ̎̂ZbgB
	 * @return	`̓(POINT/LINE/BEZIER̂ꂩ)
	 */
	private int whatTypeIsBezier() {
	    if (crnt_type != UNKNOWN)
		return crnt_type;

	    int uicp = bzc.nControlPoints();

	    JgclVector2D s2e;
	    double leng_s2e;
	    JgclVector2D unit_s2e;
	    JgclVector2D s2c;
	    double dist;
	    double leng;
	    int i;
	    double d_tol = bzc.getToleranceForDistance();

	    s2e = bzc.controlPointAt(uicp - 1).subtract(bzc.controlPointAt(0));
	    leng_s2e = s2e.length();

	    if (leng_s2e < d_tol) {
		for (i = 1; i < (uicp - 1); i++) {
		    s2c = bzc.controlPointAt(i).subtract(bzc.controlPointAt(0));
		    if (!(s2c.length() < d_tol))
			break;
		}

		if (i == (uicp - 1)) {
		    /*
		     * Point
		     */
		    JgclPoint2D pnt_geom
			= bzc.controlPointAt(uicp-1).linearInterpolate(bzc.controlPointAt(0), 0.5);

		    geom = pnt_geom;
		    return crnt_type = POINT;
		} else {
		    /*
		     * Bezier
		     */
		    geom = null;
		    return crnt_type = BEZIER;
		}
	    }

	    unit_s2e = s2e.divide(leng_s2e);

	    for (i = 1; i < (uicp - 1); i++) {
		s2c = bzc.controlPointAt(i).subtract(bzc.controlPointAt(0));
		dist = unit_s2e.zOfCrossProduct(s2c);
		if (Math.abs(dist) > d_tol) {
		    /*
		     * Bezier
		     */
		    geom = null;
		    return crnt_type = BEZIER;
		}

		leng = unit_s2e.dotProduct(s2c);
		if ((leng < (0.0 - d_tol)) || (leng > (leng_s2e + d_tol))) {
		    /*
		     * Bezier
		     */
		    geom = null;
		    return crnt_type = BEZIER;
		}
	    }

	    /*
	     * Line
	     */
	    JgclLine2D lin_geom = new JgclLine2D(bzc.controlPointAt(0), s2e);

	    geom = lin_geom;
	    return crnt_type = LINE;
	}

	/**
	 * g̃p[^̃xWGȐ̃p[^ɕϊB
	 * @param param	g̃p[^
	 * @return	̋ȐƂẴp[^
	 */
	private double toBezierParam(double param) {
	    return (1.0 - param) * sp + param * ep;
	}
    }

    /**
     * LINEABEZIER̂ƂɁA
     * 2ZOg\邩ǂׂ
     * @param dA	LINEȂZOg
     * @param dB	̃ZOg
     * @return		\邩ǂ
     * @see	BezierInfo
     */
    private boolean checkLineBezier(BezierInfo dA, BezierInfo dB) {
	if (dA.crnt_type == LINE) {
	    if ((dB.crnt_type == UNKNOWN) || (dB.crnt_type == BEZIER)) {
		JgclLine2D line;
		JgclLine2D unit_line;
		int i;
		int pside, cside;

		line = dA.line();
		unit_line = new JgclLine2D(line.pnt(), line.dir().unitized());
		int uicp = dB.bzc.nControlPoints();

		pside = unit_line.pointIsWhichSide(dB.bzc.controlPointAt(0));
		if (pside == JgclWhichSide.ON)
		    return true;
		for (i = 1; i < uicp; i++) {
		    cside = unit_line.pointIsWhichSide(dB.bzc.controlPointAt(i));
		    if (pside != cside)
			return true;
		}
		return false;	/* all control points of dB lie in the same side
				   for line (dA->geom), no interfere */
	    }
	}
	return true;
    }

    /**
     * 2ZOg\邩ǂׂ
     * @param dA	ZOgA
     * @param dB	ZOgB
     * @return		\邩ǂ
     * @see	BezierInfo
     */
    private boolean checkInterfere(BezierInfo dA, BezierInfo dB) {
	/*
	 * if one curve is already linear and another is still Bezier,
	 * special consideration will be applied.
	 */
	if (!checkLineBezier(dA, dB))
	    return false;
	if (!checkLineBezier(dB, dA))
	    return false;

	/*
	 * check Box vs. Box interfere
	 */
	return dA.box.hasIntersection(dB.box);
    }

    /**
     * 𕪊B
     * ꂽZOg<code>new_rivals</code>Ɋi[B
     * 肪ɕĂƂ(qm[hƂ)͎qm[hi[B
     * 肪POINT/LINEłꍇ́Aɂ̂܂܊i[B
     * @param dANode	ΏۂƂȂ鑊\񕪖؂̃m[h
     * @param new_rivals	i[郊Xg
     * @return	ꂽ(m[hBezierʂBEZIERȂ)<code>true</code>A
     *		ȂȂ(BEZIERȊOȂ)<code>false</code>
     * @see JgclBinaryTree.Node
     */
    private boolean divideRivals(JgclBinaryTree.Node dANode, Vector new_rivals) {
	JgclBinaryTree.Node binL, binR;

	if (dANode.left() == null && dANode.right() == null) {
	    BezierInfo bi = (BezierInfo)dANode.data();

	    if (bi.whatTypeIsBezier() != BEZIER) {
		new_rivals.addElement(dANode);
		return false;
	    }

	    /*
	     * subdivide rival
	     */
	    double half_point = 0.5;
	    JgclPureBezierCurve2D[] bzcs = bi.bzc.divide(half_point);

	    double g_half_point = (bi.sp + bi.ep) / 2.0;

	    BezierInfo biL = new BezierInfo(bzcs[0], bi.sp, g_half_point, false);
	    binL = dANode.makeLeft(biL);

	    BezierInfo biR = new BezierInfo(bzcs[1], g_half_point, bi.ep, false);
	    binR = dANode.makeRight(biR);

	} else {

	    binL = dANode.left();
	    binR = dANode.right();
	}

	new_rivals.addElement(binL);
	new_rivals.addElement(binR);

	return true;
    }

    /**
     * _(̏l)\NX
     */
    private class PointInfo {
	/**
	 * Wl
	 * @see	JgclPoint2D
	 */
	private JgclPoint2D pnt;

	/**
	 * ȐÃp[^
	 */
	private double Apara;

	/**
	 * ȐB̃p[^
	 */
	private double Bpara;

	/**
	 * IuWFNg\z
	 *
	 * @param pnt	Wl
	 * @param Apara	ȐÃp[^
	 * @param Bpara	ȐB̃p[^
	 * @see JgclPoint2D
	 */
	private PointInfo(JgclPoint2D pnt, double Apara, double Bpara) {
	    this.pnt = pnt;
	    this.Apara = Apara;
	    this.Bpara = Bpara;
	}

	/**
	 * IuWFNg\z
	 *
	 * @param x	xWl
	 * @param y	yWl
	 * @param z	zWl
	 * @param Apara	ȐÃp[^
	 * @param Bpara	ȐB̃p[^
	 */
	private PointInfo(double x, double y, double Apara, double Bpara) {
	    this.pnt = new JgclCartesianPoint2D(x, y);
	    this.Apara = Apara;
	    this.Bpara = Bpara;
	}
    }

    /**
     * POINTALINÊƂɌ_߂
     * _ɓeāAe_΂ԂB
     * @param pbi	POINTł镪ZOg
     * @param lbi	LINEł镪ZOg
     * @return	_(݂ȂƂnull)
     */
    private PointInfo
    intersectPntLine(BezierInfo pbi, BezierInfo lbi) {
	JgclPoint2D pnt = pbi.pnt();
	JgclLine2D line = lbi.line();
	JgclBoundedLine2D bln = new JgclBoundedLine2D(line.pnt(), line.dir());
	JgclPointOnCurve2D poc;

	if ((poc = bln.project1From(pnt)) == null)
	    return null;		// no solution

	double Apara = (pbi.sp + pbi.ep) / 2.0;
	double Bpara = lbi.toBezierParam(poc.parameter());
	return new PointInfo(poc.x(), poc.y(), Apara, Bpara);
    }

    /**
     * _refinement: Åe̒l߂
     * @see	JgclMath#solveSimultaneousEquations(JgclRealFunction, JgclRealFunction[],
     *					    JgclBooleanFunctionWithRealVariables, double[])
     */
    private class nlFunc implements JgclRealFunction {
	private nlFunc() {
	    super();
	}

	public double[] evaluate(double[] parameter) {
	    double[] vctr = new double[2];
	    JgclVector2D evec;

	    /*
	     * sApnt & sBpnt are already computed by previous cnvFunc.evaluate()
	     */
	    evec = sApnt.subtract(sBpnt);

	    vctr[0] = evec.x();
	    vctr[1] = evec.y();

	    return vctr;
	}
    }

    /**
     * _refinement: Åe̕Δ̒l߂
     * @see	JgclMath#solveSimultaneousEquations(JgclRealFunction, JgclRealFunction[],
     *					    JgclBooleanFunctionWithRealVariables, double[])
     */
    private class dnlFunc implements JgclRealFunction {
	int idx;
	private dnlFunc(int idx) {
	    super();
	    this.idx = idx;
	}

	public double[] evaluate(double[] parameter) {
	    double[] mtrx = new double[2];
	    if (idx == 0) {	/* this must be called first */
		sAtang = dA.tangentVector(dA.parameterDomain().force(parameter[0]));
		sBtang = dB.tangentVector(dB.parameterDomain().force(parameter[1]));
		mtrx[0] = sAtang.x();
		mtrx[1] = (- sBtang.x());
	    } else {
		mtrx[0] = sAtang.y();
		mtrx[1] = (- sBtang.y());
	    }
	    return mtrx;
	}
    }

    /**
     * _refinement: Ảǂ𔻒肷
     * @see	JgclMath#solveSimultaneousEquations(JgclRealFunction, JgclRealFunction[],
     *					    JgclBooleanFunctionWithRealVariables, double[])
     */
    private class cnvFunc implements JgclBooleanFunctionWithRealVariables {
	private cnvFunc() {
	    super();
	}

	public boolean evaluate(double[] parameter) {
	    sApnt = dA.coordinates(dA.parameterDomain().force(parameter[0]));
	    sBpnt = dB.coordinates(dB.parameterDomain().force(parameter[1]));

	    return sApnt.identical(sBpnt);
	}
    }

    private void setbackParams(PointInfo pi, double param[]) {
	JgclPoint2D Apnt, Bpnt;

	pi.Apara = dA.parameterDomain().force(param[0]);
	pi.Bpara = dB.parameterDomain().force(param[1]);

	Apnt = dA.coordinates(pi.Apara);
	Bpnt = dB.coordinates(pi.Bpara);

	pi.pnt = Apnt.linearInterpolate(Bpnt, 0.5);
    }

    /**
     * _refinements
     * @param	refine_
     * @return	ǂ
     */
    private boolean refinePointInfo(PointInfo pinfo) {
	nlFunc nl_func = new nlFunc();
	JgclRealFunction[] dnl_func = new JgclRealFunction[2];
	dnl_func[0] = new dnlFunc(0);
	dnl_func[1] = new dnlFunc(1);
	cnvFunc cnv_func = new cnvFunc();
	double[] param = new double[2];

	param[0] = pinfo.Apara;
	param[1] = pinfo.Bpara;

	param = JgclMath.solveSimultaneousEquations(nl_func, dnl_func, cnv_func, param);
	if (param == null)
	    return false;

	setbackParams(pinfo, param);
	return true;
    }

    /**
     * POINTLINEƂ݂Ȃꂽ2̃ZOgm̌_𓾂B
     * @param dA	POINTLINEƂ݂ȂꂽZOgA
     * @param dB	POINTLINEƂ݂ȂꂽZOgB
     */
    private void intersectLines(BezierInfo dA, BezierInfo dB) {
	if (false) {	// for debug
	    JgclPoint2D pnt1 = dA.bzc.controlPointAt(0);
	    JgclPoint2D pnt2 = dA.bzc.controlPointAt(dA.bzc.nControlPoints()-1);
	    JgclPoint2D pntA = pnt1.linearInterpolate(pnt2, 0.5);
	    pnt1 = dB.bzc.controlPointAt(0);
	    pnt2 = dB.bzc.controlPointAt(dB.bzc.nControlPoints()-1);
	    JgclPoint2D pntB = pnt1.linearInterpolate(pnt2, 0.5);
	    JgclPoint2D pnt = pntA.linearInterpolate(pntB, 0.5);
	    double paramA = (dA.sp + dA.ep) * 0.5;
	    double paramB = (dB.sp + dB.ep) * 0.5;

	    sol_list.addAsIntersection(pnt, paramA, paramB, aprx_ptolA, aprx_ptolB);
	    return;
	}

	PointInfo ints_pnt;

	double x, y, z;
	double Apara, Bpara;
	int i;

	if (dA.crnt_type == POINT) {
	    if (dB.crnt_type == POINT) {
		x = (dA.pnt().x() + dB.pnt().x()) / 2.0;
		y = (dA.pnt().y() + dB.pnt().y()) / 2.0;
		Apara = (dA.sp + dA.ep) / 2.0;
		Bpara = (dB.sp + dB.ep) / 2.0;

		ints_pnt = new PointInfo(x, y, Apara, Bpara);

	    } else {
		if ((ints_pnt = intersectPntLine(dA, dB)) == null)
		    return;
	    }

	} else if (dA.crnt_type == LINE) {
	    if (dB.crnt_type == LINE) {
		JgclBoundedLine2D Abln;
		JgclBoundedLine2D Bbln;
		JgclCurveCurveInterference2D intf;

		Abln = new JgclBoundedLine2D(dA.bzc.controlPointAt(0),
					     dA.bzc.controlPointAt(dA.bzc.nControlPoints() - 1));
		Bbln = new JgclBoundedLine2D(dB.bzc.controlPointAt(0),
					     dB.bzc.controlPointAt(dB.bzc.nControlPoints() - 1));

		if ((intf = Abln.interfere1(Bbln)) == null)
		    return;

		if (intf.isIntersectionPoint()) {
		    /*
		     * intersect
		     */
		    JgclIntersectionPoint2D ints = intf.toIntersectionPoint();

		    Apara = dA.toBezierParam(ints.pointOnCurve1().parameter());
		    Bpara = dB.toBezierParam(ints.pointOnCurve2().parameter());
			
		    ints_pnt = new PointInfo(ints.x(), ints.y(), Apara, Bpara);

		} else {
		    /*
		     * overlap
		     */
		    JgclOverlapCurve2D ovlp = intf.toOverlapCurve();
		    double x1, y1, x2, y2;

		    x1 = dA.toBezierParam(ovlp.start1());
		    y1 = dB.toBezierParam(ovlp.start2());
		    x2 = dA.toBezierParam(ovlp.end1());
		    y2 = dB.toBezierParam(ovlp.end2());

		    sol_list.addAsOverlap(x1, y1, x2 - x1, y2 - y1,
					  aprx_ptolA, aprx_ptolB, aprx_ptolA, aprx_ptolB);

		    return;
		}

	    } else {
		if ((ints_pnt = intersectPntLine(dB, dA)) == null) {
		    return;
		}
	    }
	} else {	// not reached
	    return;
	}

	if (refinePointInfo(ints_pnt))
	    sol_list.addAsIntersection(ints_pnt.pnt, ints_pnt.Apara, ints_pnt.Bpara,
				       aprx_ptolA, aprx_ptolB);

	return;
    }

    /**
     * Main Process
     * <p>
     * ΏۃZOgƂrivalsƂ̌𓾂B
     * </p><p>
     * ΏۃZOg_͐Ƃ݂ȂꂽA
     * rivals_͐Ƃ݂Ȃ܂ŕA
     * _𓾂B
     * </p><p>
     * ΏۃZOg܂_Ƃ݂ȂȂꍇ́A
     * ΏۃZOgтrivals𕪊A
     * O2ZOgɑ΂čċAIɎgĂяoB
     * </p>
     * @param crnt_bi	ΏۂƂȂ镪ZOg
     * @see	BezierInfo
     */
    private void getIntersections(BezierInfo crnt_bi) {
	JgclBinaryTree.Node dANode;
	int i;

	/*
	 * remove rivals which have no possibility of interference
	 */
	int n_rivals = crnt_bi.rivals.size();
	for (i = n_rivals - 1; i >= 0; i--) {
	    dANode = (JgclBinaryTree.Node)crnt_bi.rivals.elementAt(i);
	    if (!checkInterfere((BezierInfo)dANode.data(), crnt_bi))
		crnt_bi.rivals.removeElementAt(i);
	}
	if (crnt_bi.rivals.size() == 0)
	    return;

	/*
	 * if current bezier is regarded as line, get intersections
	 */
	if (crnt_bi.whatTypeIsBezier() != BEZIER) {
	    Vector new_rivals = new Vector();

	    boolean all_rivals_are_line = true;

	    n_rivals = crnt_bi.rivals.size();
	    for (i = 0; i < n_rivals; i++)
		if (divideRivals((JgclBinaryTree.Node)crnt_bi.rivals.elementAt(i), new_rivals))
		    all_rivals_are_line = false;

	    crnt_bi.rivals = new_rivals;

	    if (!all_rivals_are_line) {
		/*
		 * try again
		 */
		getIntersections(crnt_bi);
	    } else {
		/*
		 * get intersections
		 */
		n_rivals = crnt_bi.rivals.size();
		for (i = 0; i < n_rivals; i++) {
		    dANode = (JgclBinaryTree.Node)crnt_bi.rivals.elementAt(i);
		    intersectLines((BezierInfo)dANode.data(), crnt_bi);
		}
	    }
	    return;
	}

	/*
	 * generate children (divide current bezier)
	 */
	double half_point = 0.5;
	JgclPureBezierCurve2D[] bzcs = crnt_bi.bzc.divide(half_point);

	double g_half_point = (crnt_bi.sp + crnt_bi.ep) / 2.0;

	BezierInfo biL = new BezierInfo(bzcs[0], crnt_bi.sp, g_half_point, true);
	BezierInfo biR = new BezierInfo(bzcs[1], g_half_point, crnt_bi.ep, true);

	/*
	 * create children's rival list
	 */
	n_rivals = crnt_bi.rivals.size();
	for (i = 0; i < n_rivals; i++)
	    divideRivals((JgclBinaryTree.Node)crnt_bi.rivals.elementAt(i), biL.rivals);

	n_rivals = biL.rivals.size();
	for (i = 0; i < n_rivals; i++)
	    biR.rivals.addElement(biL.rivals.elementAt(i));

	/*
	 * recursive call
	 */
	getIntersections(biL);
	getIntersections(biR);
    }

    /**
     * 2xWGȐ̊߂ŏʃ\bh
     */
    private JgclCurveCurveInterferenceList getInterference() {
	BezierInfo dBRoot;

	dBRoot = new BezierInfo(dB, 0.0, 1.0, true);
	dBRoot.rivals.addElement(Atree.rootNode());

	/*
	 * Get Intersections
	 */
	getIntersections(dBRoot);

	sol_list.removeOverlapsContainedInOtherOverlap();
	sol_list.removeIntersectionsContainedInOverlap();

	return sol_list;
    }

    /**
     * 2xWGȐ̌_𓾂
     *
     * @param poly1	xWGȐ1
     * @param poly2	xWGȐ2
     * @return		_̔z
     * @see		JgclIntersectionPoint2D
     */
    static JgclIntersectionPoint2D[] intersection(JgclPureBezierCurve2D bzc1,
						  JgclPureBezierCurve2D bzc2,
						  boolean doExchange) {
	JgclIntsBzcBzc2D doObj = new JgclIntsBzcBzc2D(bzc1, bzc2);
	return doObj.getInterference().toJgclIntersectionPoint2DArray(doExchange);
    }

    /**
     * 2xWGȐ̊𓾂
     *
     * @param poly1	xWGȐ1
     * @param poly2	xWGȐ2
     * @return		2Ȑ̊̔z
     * @see		JgclCurveCurveInterference2D
     */
    static JgclCurveCurveInterference2D[] interference(JgclPureBezierCurve2D bzc1,
						       JgclPureBezierCurve2D bzc2,
						       boolean doExchange) {
	JgclIntsBzcBzc2D doObj = new JgclIntsBzcBzc2D(bzc1, bzc2);
	return doObj.getInterference().toJgclCurveCurveInterference2DArray(doExchange);
    }
}
