/*
 * _Ԃ B-spline Ȗʂŕ(Interpolation)邽߂̃NX(3D)
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclInterpolationSurface3D.java,v 1.4 2000/04/26 09:38:58 hideit Exp $
 */

package jp.go.ipa.jgcl;

/**
 * _Ԃ B-spline Ȗʂŕ(Interpolation)邽߂̃NX(3D)
 *
 * @version $Revision: 1.4 $, $Date: 2000/04/26 09:38:58 $
 * @author Information-technology Promotion Agency, Japan
 */

class JgclInterpolationSurface3D {
    /**
     * U̕ԂɕKvȏ
     * @see JgclInterpolation
     */
    private JgclInterpolation uInfo;

    /**
     * V̕ԂɕKvȏ
     * @see JgclInterpolation
     */
    private JgclInterpolation vInfo;

    /**
     * Ԃ_
     * @see JgclPoint3D
     */
    private JgclPoint3D[][] points;

    /**
     * U̗[ł̌X(UĂꍇ͎QƂȂ)
     * @see JgclVector3D
     */
    private JgclVector3D[][] uEndvecs;

    /**
     * V̗[ł̌X(VĂꍇ͎QƂȂ)
     * @see JgclVector3D
     */
    private JgclVector3D[][] vEndvecs;

    /**
     * _Ap[^^ăIuWFNg\z
     *
     * @param points	_
     * @param uParams	U p[^
     * @param vParams	V p[^
     * @param uIsClosed	UĂ邩ǂ
     * @param vIsClosed	VĂ邩ǂ
     */
    JgclInterpolationSurface3D(JgclPoint3D[][] points,
			       double[] uParams, double[] vParams,
			       boolean uIsClosed, boolean vIsClosed) {
	this.uInfo = new JgclInterpolation(uParams, uIsClosed);
	this.vInfo = new JgclInterpolation(vParams, vIsClosed);
	this.points = points;
	JgclVector3D[] tmpVecs;
	if (!uIsClosed) {
	    /*
	     * xbZ̏I[p
	     */
	    uEndvecs = new JgclVector3D[2][vInfo.uip];
	    JgclPoint3D[] auxPoints = new JgclPoint3D[uInfo.uip];
	    for (int i = 0; i < vInfo.uip; i++) {
		for (int j = 0; j < uInfo.uip; j++)
		    auxPoints[j] = points[j][i];
		tmpVecs = JgclInterpolation3D.besselPoints(auxPoints, uParams);
		for (int j = 0; j < 2; j++)
		    uEndvecs[j][i] = tmpVecs[j];
	    }
	}
	if (!vIsClosed) {
	    /*
	     * xbZ̏I[p
	     */
	    vEndvecs = new JgclVector3D[2][uInfo.uip];
	    for (int i = 0; i < uInfo.uip; i++) {
		tmpVecs = JgclInterpolation3D.besselPoints(points[i], vParams);
		for (int j = 0; j < 2; j++)
		    vEndvecs[j][i] = tmpVecs[j];
	    }
	}
    }

    /**
     * _Ap[^A[̌X^ăIuWFNg\z
     *
     * @param points	_
     * @param uParams	U p[^
     * @param vParams	V p[^
     * @param uEndvecs	U̗[̌X(UĂꍇ͎QƂȂ)
     * @param vEndvecs	V̗[̌X(VĂꍇ͎QƂȂ)
     * @param uIsClosed	UĂ邩ǂ
     * @param vIsClosed	VĂ邩ǂ
     */
    JgclInterpolationSurface3D(JgclPoint3D[][] points,
			       double[] uParams, double[] vParams,
			       JgclVector3D[][] uEndvecs, JgclVector3D[][] vEndvecs,
			       boolean uIsClosed, boolean vIsClosed) {
	this.uInfo = new JgclInterpolation(uParams, uIsClosed);
	this.vInfo = new JgclInterpolation(vParams, vIsClosed);
	this.points = points;
	if (!uIsClosed)
	    this.uEndvecs = uEndvecs;
	if (!vIsClosed)
	    this.vEndvecs = vEndvecs;
    }

    /**
     * ŨmbgԂ
     * @return	Ũmbg
     * @see JgclBsplineKnot
     */
    JgclBsplineKnot uKnotData() {
	return uInfo.knotData();
    }

    /**
     * ṼmbgԂ
     * @return	Ṽmbg
     * @see JgclBsplineKnot
     */
    JgclBsplineKnot vKnotData() {
	return vInfo.knotData();
     }

    /**
     * _߂
     *
     * gh3intpCBssC2 (in gh3intpCBsp.c)
     *
     * @return	_
     */
    JgclPoint3D[][] controlPoints() {
	JgclInterpolation3D intp;
	int u_uicp = uInfo.nControlPoints();
	int v_uicp = vInfo.nControlPoints();
	JgclPoint3D[][] controlPoints = new JgclPoint3D[u_uicp][v_uicp];
	JgclPoint3D[][] auxPoints = new JgclPoint3D[v_uicp][uInfo.uip];
	JgclVector3D[][] auxUEndVecs = null;
	JgclPoint3D[] work;
	JgclVector3D[] tmpVecs = new JgclVector3D[2];
	int i, j;

	/*
	 * V̊eԂ
	 */
	for (j = 0; j < uInfo.uip; j++) {
	    if (!vInfo.isClosed)
		for (i = 0; i < 2; i++)
		    tmpVecs[i] = vEndvecs[i][j];

	    work = JgclInterpolation3D.controlPoints(vInfo, points[j], tmpVecs);
	    for (i = 0; i < v_uicp; i++)
		auxPoints[i][j] = work[i];
	}
	if (!uInfo.isClosed) {
	    /*
	     * [̌XԂ(U̕Ԃɗp)
	     */
	    auxUEndVecs = new JgclVector3D[2][];
	    for (j = 0; j < 2; j++) {
		work = JgclInterpolation3D.controlPoints(vInfo, JgclVector3D.toPoint3D(uEndvecs[j]), null);
		auxUEndVecs[j] = JgclPoint3D.toVector3D(work);
	    }
	}

	/*
	 * VɕԂꂽ_ɁAŮeԂ
	 */
	for (j = 0; j < v_uicp; j++) {
	    if (!uInfo.isClosed)
		for (i = 0; i < 2; i++)
		    tmpVecs[i] = auxUEndVecs[i][j];

	    work = JgclInterpolation3D.controlPoints(uInfo, auxPoints[j], tmpVecs);
	    for (i = 0; i < u_uicp; i++)
		controlPoints[i][j] = work[i];
	}

	return controlPoints;
    }

    /**
     * d݂߂
     *
     * @return	d(`Ȃ̂null)
     */
    double[][] weights() {
	return null;
    }
}
