/*
 * ԑSʂɋʂȏێNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclInterpolation.java,v 1.9 2000/05/25 13:11:57 shikano Exp $
 */

package jp.go.ipa.jgcl;

/**
 * ԑSʂɋʂȏێNX
 *
 * @version $Revision: 1.9 $, $Date: 2000/05/25 13:11:57 $
 * @author Information-technology Promotion Agency, Japan
 */

final class JgclInterpolation {
    /**
     * Ԃ_ɑΉp[^
     */
    final double[] params;

    /**
     * Ԃ_̐
     */
    final int uip;

    /**
     * p[^Ԋu
     *
     * Jꍇ-1IWAꍇ-2IWƂȂ邽߁A
     * ڃANZXȂ(pInt()\bhg)
     */
    private double[] pInt = null;

    /**
     * s
     * @see	JgclMatrix
     */
    final JgclMatrix matrix;

    /**
     * _񂪕Ă邩ǂ̃tO
     */
    final boolean isClosed;

    /**
     * p[^^ăIuWFNg\z
     * (_͊JĂ̂Ƃ)
     *
     * @param params   p[^
     */
    JgclInterpolation(double[] params) {
	if (params.length < 2)
	    throw new JgclInvalidArgumentValue();

	this.params = params;
	this.isClosed = false;
	this.uip = params.length;
	this.pInt = getInterval();
	this.matrix = setupLinearSystem();
	computeLeftSideLinearSystem();
    }

    /**
     * p[^Ɠ_񂪕Ă邩ǂ̏^ăIuWFNg\z
     *
     * @param params   p[^
     * @param isClosed _񂪕Ă邩ǂ̃tO
     */
    JgclInterpolation(double[] params, boolean isClosed) {
	if (params.length < 2)
	    throw new JgclInvalidArgumentValue();

	this.params = params;
	this.isClosed = isClosed;
	if (this.isClosed) {
	    this.uip = params.length - 1;
	} else {
	    this.uip = params.length;
	}
	this.pInt = getInterval();
	if (!isClosed) {
	    this.matrix = setupLinearSystem();
	    computeLeftSideLinearSystem();
	} else {
	    this.matrix = setupLinearSystemClosed();
	}
    }
    
    /**
     * p[^Ԋu߂
     * @param i	CfbNX
     * @return	p[^Ԋu̒l
     */
    double pInt(int i) {
	if (!isClosed)
	    return pInt[i + 1];
	else
	    return pInt[i + 2];
    }

    /**
     * p[^Ԋu̒lݒ肷
     * @param i		CfbNX
     * @param value	ݒ肷l
     */
    private void pInt(int i, double value) {
	if (!isClosed)
	    pInt[i + 1] = value;
	else
	    pInt[i + 2] = value;
    }

    /**
     * Ԃ_̃p[^Ԋu߂
     *
     * @return p[^̊Ԋu
     */
    private double[] getInterval() {
	if (!isClosed) {
	    pInt = new double[uip + 1];
	    pInt(-1, 0.0);
	    for (int i = 0; i < uip - 1; i++) {
		pInt(i, params[i + 1] - params[i]);
	    }
	    pInt(uip - 1, 0.0);
	}
	else {
	    pInt = new double[uip + 3];
	    int i;
	    for (i = 0; i < uip; i++) {
		pInt(i, params[i + 1] - params[i]);
	    }
	    pInt(i, pInt(0));
	    pInt(-2, pInt(uip - 2));
	    pInt(-1, pInt(uip - 1));
	}
	return pInt;
    }

    /**
     * s(J_̏ꍇ)
     *
     * @return    s
     * @see	JgclMatrix
     */
    private JgclMatrix setupLinearSystem() {
	JgclMatrix matrix = new JgclMatrix(uip, 3);

  	// 0th row
	double[] firstRow = {0.0, 1.0, 0.0};
	matrix.setElementsAt(0, firstRow);

  	// 1st, (uip - 2)th row
  	double denomJ = pInt(-1) + pInt(0) + pInt(1);
  	for (int j = 1; j < uip - 1; j++) {
  	    double denomJ1 = pInt(j-1) + pInt(j) + pInt(j + 1);
	    double[] value = {
		(pInt(j) * pInt(j)) / denomJ,					// alpha
		((pInt(j)     * (pInt(j - 2) + pInt(j - 1))) / denomJ) +	// beta
		((pInt(j - 1) * (pInt(j)     + pInt(j + 1))) / denomJ1),
		(pInt(j - 1) * pInt(j - 1)) / denomJ1				// gamma
	    };
	    matrix.setElementsAt(j, value);
  	    denomJ = denomJ1;
  	}

  	// (uip - 1)th row
	double[] lastRow = {0.0, 1.0, 0.0}; 
	matrix.setElementsAt(uip - 1, lastRow);

  	return matrix;
    }

    /**
     * s(_̏ꍇ)
     *
     * @return    s
     * @see	JgclMatrix
     */
    private JgclMatrix setupLinearSystemClosed() {
	JgclMatrix matrix = new JgclMatrix(uip, uip);

	for (int j = 0; j < uip; j++) {
	    for (int k = 0; k < uip; k++) {
		matrix.setElementAt(j, k, 0.0);
	    }
	}

	double denomJ = pInt(-2) + pInt(-1) + pInt(0);
	for (int j = 0; j < uip; j++) {
	    double denomJ1 = pInt(j - 1) + pInt(j) + pInt(j + 1);
	    int alpha = (j == 0) ? (uip - 1) : j - 1;
	    int beta = j;
	    int gamma = (j == (uip - 1)) ? 0 : j + 1;
	    matrix.setElementAt(j, alpha, 
				(pInt(j) * pInt(j)) / denomJ);
	    matrix.setElementAt(j, beta,
				((pInt(j)     * (pInt(j - 2) + pInt(j - 1))) / denomJ) +
				((pInt(j - 1) * (pInt(j)     + pInt(j + 1))) / denomJ1));
	    matrix.setElementAt(j, gamma, (pInt(j - 1) * pInt(j - 1)) / denomJ1);
	    denomJ = denomJ1;
	}

	matrix.makeLUDecomposition();
	return matrix;
    }

    /**
     * svZ
     */
    private void computeLeftSideLinearSystem() {
	for (int i = 1; i < uip; i++) {
	    double val0 = matrix.getElementAt(i, 0);
	    double val1 = matrix.getElementAt(i - 1, 1);
	    double val2 = matrix.getElementAt(i - 1, 2);
	    double value = matrix.getElementAt(i, 1);
	    //double value0 = val0 / val1 * val2;
	    //value -= value0;
	    double value0 = val0 / val1;
	    value -= value0 * val2;
	    matrix.setElementAt(i, 0, value0);
	    matrix.setElementAt(i, 1, value);
	}
	for (int i = uip - 2; i >= 0; i--) {
	    double value0 = matrix.getElementAt(i, 2);
	    double value1 = matrix.getElementAt(i + 1, 1);
	    double value = value0 / value1;
	    matrix.setElementAt(i, 2, value);
	}
    }

    /**
     * ԂȐ̃mbg߂(J_)
     *
     * @return       mbg
     * @see	JgclBsplineKnot
     */
    private JgclBsplineKnot knotDataOpened() {
	int uik = uip;
	double[] knots = new double[uik];
	int[] knotMultiplicities = new int[uik];

	knots[0] = params[0];
	knotMultiplicities[0] = 4;
	int i;
	for (i = 1; i < uik - 1; i++) {
	    knots[i] = params[i];
	    knotMultiplicities[i] = 1;
	}
	knots[i] = params[i];
	knotMultiplicities[i] = 4;

	return new JgclBsplineKnot(3, JgclKnotType.UNSPECIFIED, isClosed,
				   uik, knotMultiplicities, knots, uip + 2);
    }

    /**
     * ԂȐ̃mbg߂(_)
     *
     * @return       mbg
     * @see	JgclBsplineKnot
     */
    private JgclBsplineKnot knotDataClosed() {
	int degree = 3;
	int uik = (2 * degree) +uip + 1;
	double[] knots = new double[uik];
	int[] knotMultiplicities = new int[uik];

	knots[degree] = params[0];
	knotMultiplicities[degree] = 1;

	int i, j; 
	for (i = degree - 1, j = uip - 1; i >= 0; i--, j--) {
	    knots[i] = knots[i + 1] - pInt(j);
	    knotMultiplicities[i] = 1;
	}

	for (i = degree + 1, j = 1; j < uip + 1; i++, j++) {
	    knots[i] = params[j];
	    knotMultiplicities[i] = 1;
	}

	for (j = 0; j < degree; i++, j++) {
	    knots[i] = knots[i - 1] + pInt(j);
	    knotMultiplicities[i] = 1;
	}

	return new JgclBsplineKnot(3, JgclKnotType.UNSPECIFIED, isClosed, uik,
				   knotMultiplicities, knots, uip);
    }

    /**
     * ԂȐ̃mbg߂
     *
     * @return       mbg
     * @see	JgclBsplineKnot
     */
    JgclBsplineKnot knotData() {
	if (!isClosed) {
	    return knotDataOpened();
	}
	else {
	    return knotDataClosed();
	}
    }

    /**
     * ԂȐ̐_̐Ԃ
     * @return	_̐
     */
    int nControlPoints() {
	if (isClosed)
	    return uip;
	else
	    return uip + 2;
    }
}

// end of file
