/*
 * Q : oȐ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclHyperbola2D.java,v 1.64 2000/08/11 06:18:50 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;

/**
 * Q : oȐ\NXB
 * <p>
 * oȐ́A̒S̈ʒuƋǏ X/Y ̕ǏWn
 * (zuA{@link JgclAxis2Placement2D JgclAxis2Placement2D}) position 
 * S璸_܂ł̋ semiAxisA
 * semiAxis ƍ킹đQߐ̌Xw肷鋗 semiImagAxis
 * Œ`B
 * </p>
 * <p>
 * t p[^ƂoȐ P(t) ̃pgbN\́Aȉ̒ʂB
 * <pre>
 *	P(t) = position.location()
 *	     + semiAxis * cosh(t) * position.x()
 *	     + semiImagAxis * sinh(t) * position.y()
 * </pre>
 * </p>
 *
 * @version $Revision: 1.64 $, $Date: 2000/08/11 06:18:50 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclHyperbola2D extends JgclConic2D {

    /**
     * S璸_܂ł̋B
     * @serial
     */
    private double semiAxis;

    /**
     * semiAxis ƍ킹đQߐ̌Xw肷鋗B
     * @serial
     */
    private double semiImagAxis;

    /**
     * S璸_܂ł̋ƁAƍ킹đQߐ̌Xw肷鋗A
     * ێtB[hɐݒ肷B
     * <p>
     * semiAxis, semiImagAxis ̒l͐łȂ΂ȂȂB
     * </p>
     * <p>
     * semiAxis, semiImagAxis ̂ꂩ̒l
     * ݐݒ肳Ă鉉Z̋̋e덷菬ꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     *
     * @param semiAxis	S璸_܂ł̋
     * @param semiImagAxis	semiAxis ƍ킹đQߐ̌Xw肷鋗
     * @see	JgclInvalidArgumentValue
     */
    private void setSemiAxis(double semiAxis, double semiImagAxis)
    {
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	double dTol = condition.getToleranceForDistance();

	if (semiAxis < dTol) {
	    throw new JgclInvalidArgumentValue();
	}
	this.semiAxis = semiAxis;

	if (semiImagAxis < dTol) {
	    throw new JgclInvalidArgumentValue();
	}
	this.semiImagAxis = semiImagAxis;
    }

    /**
     * ǏWnƒS璸_܂ł̋ёQߐ̌Xw肷鋗
     * ^ăIuWFNg\zB
     * <p>
     * position  null ̏ꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * <p>
     * semiAxis, semiImagAxis ̂ꂩ̒l
     * ݐݒ肳Ă鉉Z̋̋e덷菬ꍇɂ
     * JgclInvalidArgumentValue	̗O𔭐B
     * </p>
     * 
     * @param position	SƋǏ X/Y ̕ǏWn
     * @param semiAxis	S璸_܂ł̋
     * @param semiImagAxis	semiAxis ƍ킹đQߐ̌Xw肷鋗
     * @see	JgclInvalidArgumentValue
     */
    public JgclHyperbola2D(JgclAxis2Placement2D position,
			   double semiAxis, double semiImagAxis)
    {
	super(position);
	setSemiAxis(semiAxis, semiImagAxis);
    }

    /**
     * ̑oȐ̒S璸_܂ł̋ (semiAxis) ԂB
     * 
     * @return		S璸_܂ł̋
     */
    public double semiAxis() {
	return this.semiAxis;
    }

    /**
     * {@link #semiAxis() semiAxis()} ̕ʖ\bhB
     * 
     * @return		S璸_܂ł̋
     */
    public double xRadius() {
	return this.semiAxis;
    }

    /**
     * ̑oȐ semiImagAxis ̒lԂB
     * 
     * @return		semiImagAxis ̒l
     */
    public double semiImagAxis() {
	return this.semiImagAxis;
    }

    /**
     * {@link #semiImagAxis() semiImagAxis()} ̕ʖ\bhB
     * 
     * @return		semiImagAxis ̒l
     */
    public double yRadius() {
	return this.semiImagAxis;
    }

    /**
     * ^ꂽp[^Ԃɂ邱̋Ȑ̎ԏł̒ (̂) ԂB
     * <p>
     * pint ̑l͕ł܂ȂB
     * </p>
     * 
     * @param pint	Ȑ̒߂p[^
     * @return	w肳ꂽp[^ԂɂȐ̒
     */
    public double length(JgclParameterSection pint) {
        final double m2hbl_majrd2 = semiAxis() * semiAxis();
        final double m2hbl_minrd2 = semiImagAxis() * semiImagAxis();
        double dTol = getToleranceForDistance() / 2.0;
        
        return JgclMath.getDefiniteIntegral
            (new JgclRealFunctionWithOneVariable(){
                    public double evaluate(double parameter){
                        double ecosh = JgclMath.cosh(parameter);
                        double esinh = JgclMath.sinh(parameter);

                        return Math.sqrt(m2hbl_majrd2 * esinh * esinh +
                                         m2hbl_minrd2 * ecosh * ecosh);
                    }
                },
             pint, dTol);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̍WlԂB
     * 
     * @param param	p[^l
     * @return		Wl
     */
    public JgclPoint2D coordinates(double param) {
	JgclAxis2Placement2D ax = position();
	JgclVector2D x = ax.x().multiply(JgclMath.cosh(param) * semiAxis);
	JgclVector2D y = ax.y().multiply(JgclMath.sinh(param) * semiImagAxis);

	return ax.location().add(x.add(y));
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̐ڃxNgԂB
     * 
     * @param param	p[^l
     * @return		ڃxNg
     */
    public JgclVector2D tangentVector(double param) {
	JgclAxis2Placement2D ax = position();
	JgclVector2D x1 = ax.x().multiply(JgclMath.sinh(param) * semiAxis);
	JgclVector2D y1 = ax.y().multiply(JgclMath.cosh(param) * semiImagAxis);

	return x1.add(y1);
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̋ȗԂB
     * 
     * @param param	p[^l
     * @return		ȗ
     */
    public JgclCurveCurvature2D curvature(double param) {
	JgclAxis2Placement2D ax = position();
	double x1len = JgclMath.sinh(param) * semiAxis;
	double y1len = JgclMath.cosh(param) * semiImagAxis;
	double x2len = JgclMath.cosh(param) * semiAxis;
	double y2len = JgclMath.sinh(param) * semiImagAxis;
	double tlen = Math.sqrt(x1len * x1len + y1len * y1len);
	double crv = Math.abs(x1len * y2len - y1len * x2len)
	    / (tlen * tlen * tlen);
	JgclVector2D ex1 = ax.x().multiply(x1len);
	JgclVector2D ey1 = ax.y().multiply(y1len);

	JgclVector2D tangent = ex1.add(ey1);
	// rotate tangent PI/2
	JgclVector2D nrmDir =
	    new JgclLiteralVector2D(tangent.y(), -tangent.x());
	return new JgclCurveCurvature2D(crv, nrmDir.unitized());
    }

    /**
     * ̋Ȑ́A^ꂽp[^lł̓֐ԂB
     * 
     * @param param	p[^l
     * @return		֐
     */
    public JgclCurveDerivative2D evaluation(double param) {
	JgclAxis2Placement2D ax = position();
	JgclVector2D ex = ax.x().multiply(JgclMath.cosh(param) * semiAxis);
	JgclVector2D ey = ax.y().multiply(JgclMath.sinh(param) * semiImagAxis);
	JgclVector2D ex1 = ax.x().multiply(JgclMath.sinh(param) * semiAxis);
	JgclVector2D ey1 = ax.y().multiply(JgclMath.cosh(param) * semiImagAxis);

	JgclVector2D d1 = ex1.add(ey1);
	JgclVector2D d2 = ex.add(ey); // ex2 == ex, ey2 == ey
	JgclPoint2D d0 = ax.location().add(d2);

	return new JgclCurveDerivative2D(d0, d1, d2);
    }

    /**
     * ^ꂽ_炱̋Ȑւ̓e_߂B
     * <p>
     * []
     * <br>
     * l̑㐔̍߂邱ƂɋAāA㐔IɉĂB
     * </p>
     * 
     * @param point	e̓_
     * @return		e_
     */
    public JgclPointOnCurve2D[] projectFrom(JgclPoint2D point) 
    {
	double dTol2 = getToleranceForDistance2();

	/*
	 * NOTE:
	 *
	 * equation of normal line
	 *
	 * (A**2 * Px)/(A * coshT) + (B**2 * Py)/(B * sinhT) = A**2 + B**2
	 *		(A = dB->x_radius, B = dB->y_radius),
	 *
	 * so a polynomial of sinhT is
	 *
	 * F**2 * Z4  -2EF * Z3  +(F**2+E**2-D**2) * Z2  -2EF * Z1  +E**2 = 0
	 *		(Z = sinhT, D = A*Px, E = B*Py, F = A**2 + B**2).
	 */

	JgclCartesianTransformationOperator2D trans;

	try {
	    trans = new JgclCartesianTransformationOperator2D(position(), 1.0);
	}
	catch (JgclInvalidArgumentValue e) {
	    throw new JgclFatal();
	}
	// vector from B's center to A
	JgclVector2D Bc2A = point.subtract(position().location());

	// inverse rotated point
	JgclVector2D eAir = trans.reverseTransform(Bc2A);

	JgclComplex[] root;

	// critical check
	if ((eAir.x() - semiAxis) * (eAir.x() - semiAxis) < dTol2 &&
	    (eAir.y() * eAir.y()) < dTol2) {

	    root = new JgclComplex[1];
	    root[0] = new JgclComplex(0.0);
	}
	else {

	    // make polynomial
	    double eDDD = semiAxis * eAir.x();
	    double eEEE = semiImagAxis * eAir.y();
	    double eFFF = semiAxis * semiAxis + semiImagAxis * semiImagAxis;

	    // coefficients of polynomial (real)
	    double[] ercoef = new double[5];

	    ercoef[4] = eFFF * eFFF;
	    ercoef[0] = eEEE * eEEE;
	    ercoef[3] = (- 2.0 * eEEE * eFFF);
	    ercoef[1] = ercoef[3];
	    ercoef[2] = ercoef[4] + ercoef[0] - eDDD * eDDD;

	    JgclComplexPolynomial pol;
	    try {
		pol = new JgclComplexPolynomial(ercoef);
	    }
	    catch (JgclInvalidArgumentValue e) {
		throw new JgclFatal();
	    }

	    try {
		root = pol.getRootsByDKA();
	    }
	    catch (JgclComplexPolynomial.DKANotConverge e) {
		root = e.getValues();
	    }
	    catch (JgclComplexPolynomial.ImpossibleEquation e) {
		throw new JgclFatal();
	    }
	    catch (JgclComplexPolynomial.IndefiniteEquation e) {
		throw new JgclFatal();
	    }
	}

	JgclPointOnGeometryList projList = new JgclPointOnGeometryList();

	for (int i = 0; i < root.length; i++) {
	    JgclPointOnCurve2D proj;

	    double eSINH = root[i].real();

	    proj = checkProjection(JgclMath.asinh(eSINH), point, dTol2);
	    if (proj != null)
		projList.addPoint(proj);
	}
	return projList.toJgclPointOnCurve2DArray();
    }

    /**
     * ^ꂽp[^ԂɂāA
     * Ԃ̗[Ԍłꂽ_̃p[^l߂B
     * <p>
     * ̃\bh
     * {@link JgclConic2D#toPolyline(JgclParameterSection, JgclToleranceForDistance) 
     * JgclConic2D.toPolyline(JgclParameterSection, JgclToleranceForDistance)}
     * ̓ŌĂяoB
     * </p>
     * 
     * @param left	[ (ԉ) ̃p[^l
     * @param right	E[ (ԏ) ̃p[^l
     * @return		łꂽ_̃p[^l
     */
    double getPeak(double left, double right) {
	return JgclMath.atanh((JgclMath.cosh(right) - JgclMath.cosh(left))/
			      (JgclMath.sinh(right) - JgclMath.sinh(left)));
    }

    /**
     * ̋Ȑ̎w̋ԂČLxWGȐ̗ԂB
     * <p>
     * oȐ̏ꍇALxWGȐ̗vf͏ 1 ł
     * </p>
     *
     * @param pint	Čp[^
     * @return		̋Ȑ̎w̋ԂČLxWGȐ̔z
     */
    public JgclPureBezierCurve2D[] toPolyBezierCurves(JgclParameterSection pint) {
	JgclPoint2D[] controlPoints = this.getControlPointsOfBezierCurve(pint);
	double[] weights = {1.0, 1.0, 1.0};

	/*
	 * the middle weight will be greater than 1.0
	 */

	/*
	 * Given:
	 *	Rx, Ry	: hyperbola's {x, y}_radius
	 *	Tx, Ty	: unit vector of shoulder point
	 *		  (rotated into hyperbola's local coordinates system)
	 *
	 * Find:
	 *	theta	: the parameter of shoulder point
	 *
	 *	tanh(theta) = (Ry * Tx) / (Rx * Ty)
	 */
	JgclVector2D mvec = controlPoints[2].subtract(controlPoints[0]);
	JgclCartesianTransformationOperator2D localTransformationOperator =
	    this.position().toCartesianTransformationOperator(1.0);
	JgclVector2D tmvec = localTransformationOperator.toLocal(mvec).unitized();

	double shoulderParam = JgclMath.atanh((this.yRadius() * tmvec.x()) /
					      (this.xRadius() * tmvec.y()));

	/*
	 *	v = (sp - m) / (p1 - m)
	 *	w1 = v / (1 - v)
	 *
	 * where
	 *	sp	: shoulder point
	 *	p1	: middle control point
	 *	m	: middle point between end points
	 *
	 *	w1	: middle weight
	 */
	JgclPoint2D shoulderPoint = this.coordinates(shoulderParam);
	JgclPoint2D middlePoint = controlPoints[0].midPoint(controlPoints[2]);
	double vvv = Math.sqrt(shoulderPoint.subtract(middlePoint).norm() /
			       controlPoints[1].subtract(middlePoint).norm());

	weights[1] = vvv / (1.0 - vvv);

	JgclPureBezierCurve2D[] bzcs = {
	    new JgclPureBezierCurve2D(controlPoints, weights)};

	return bzcs;
    }

    /**
     * ̋Ȑ̎w̋ԂČLaXvCȐԂB
     * 
     * @param pint	Čp[^
     * @return		̋Ȑ̎w̋ԂČLaXvCȐ
     */
    public JgclBsplineCurve2D toBsplineCurve(JgclParameterSection pint) {
	JgclPureBezierCurve2D[] bzcs = this.toPolyBezierCurves(pint);
	return bzcs[0].toBsplineCurve();
    }

    /**
     * ̋ȐƑ̋ȐƂ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * oȐ̂ƂɁA
     * ݐݒ肳Ă鉉Z̉ŁA
     * oȐ̒SԂ̋̋e덷菬A
     * oȐ̋Ǐ X ̂Ȃpxpx̋e덷菬A
     * oȐ semiAxis, semiImagAxis ꂼ̍̋e덷ȓłꍇɂ́A
     * oȐ̓I[o[bvĂ̂ƂāA
     * JgclIndefiniteSolution ̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution mate oȐŁAoȐ̓I[o[bvĂAsł
     */
    public JgclIntersectionPoint2D[] intersect(JgclParametricCurve2D mate)
	 throws JgclIndefiniteSolution
    {
	return mate.intersect(this, true);
    }

    /**
     * ̑oȐ (\ꂽ) RȐ̌_\㐔𐶐B
     * 
     * @param poly	xWGȐ邢͂aXvCȐ̂ZOg̑\̔z
     * @return		̑oȐ poly ̌_\㐔̍
     */
    JgclRealPolynomial makePoly(JgclRealPolynomial[] poly) {
	JgclRealPolynomial xPoly = poly[0].multiply(poly[0]);
	JgclRealPolynomial yPoly = poly[1].multiply(poly[1]);
	double dAlrd2 = xRadius() * xRadius();
	double dAsrd2 = yRadius() * yRadius();
	boolean isPoly = poly.length < 3;
	int degree = xPoly.degree();
	double[] coef = new double[degree + 1];

	if (isPoly) {
	    for (int j = 0; j <= degree; j++)
		coef[j] = (xPoly.coefficientAt(j) / dAlrd2) -
		    (yPoly.coefficientAt(j) / dAsrd2);
	    coef[0] -= 1.0;
	}
	else {
	    JgclRealPolynomial wPoly = poly[2].multiply(poly[2]);
	    for (int j = 0; j <= degree; j++)
		coef[j] = (dAsrd2 * xPoly.coefficientAt(j)) - (dAlrd2 * yPoly.coefficientAt(j))
		    - (dAlrd2 * dAsrd2 * wPoly.coefficientAt(j));
	}
	return new JgclRealPolynomial(coef);
    }

    /**
     * ^ꂽ_̋Ȑɂ邩ۂ`FbNB
     * 
     * @param point	ΏۂƂȂ_
     * @return		^ꂽ_̋Ȑɂ trueAłȂ false
     */
    boolean checkSolution(JgclPoint2D point) {
	double param = getParameter(point);
	double px = xRadius() * JgclMath.cosh(param);
	double py = yRadius() * JgclMath.sinh(param);

	return point.identical(new JgclCartesianPoint2D(px, py));
    }

    /**
     * ^ꂽ_̋Ȑɂ̂ƂāA
     * ̓_̋Ȑł̃p[^l߂B
     * 
     * @param point	ΏۂƂȂ_
     * @return		p[^l
     */
    double getParameter(JgclPoint2D point) {
	double sinh = point.y() / yRadius();

	return JgclMath.asinh(sinh);
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsLinCnc2D#intersection(JgclLine2D, JgclHyperbola2D, boolean)
     * JgclIntsLinCnc2D.intersection}(mate, this, !doExchange)
     * ōsȂĂB
     * </p>
     *
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclLine2D mate, boolean doExchange) {
	JgclIntsLinCnc2D doObj = new JgclIntsLinCnc2D(mate, this);
	return doObj.intersection(mate, this, !doExchange);
     }

    /**
     * ̋ȐƑ̋Ȑ (~) ̌_߂
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ~̃NX́u~ vs. oȐv̌_Z\bh
     * {@link JgclCircle2D#intersect(JgclHyperbola2D, boolean)
     * JgclCircle2D.intersect(JgclHyperbola2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclCircle2D  mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (ȉ~) ̌_߂
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȉ~̃NX́uȉ~ vs. oȐv̌_Z\bh
     * {@link JgclEllipse2D#intersect(JgclHyperbola2D, boolean)
     * JgclEllipse2D.intersect(JgclParabola2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȉ~)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclEllipse2D  mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ () ̌_߂
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ̃NX́u vs. oȐv̌_Z\bh
     * {@link JgclParabola2D#intersect(JgclHyperbola2D, boolean)
     * JgclParabola2D.intersect(JgclHyperbola2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclParabola2D  mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
     }

    /**
     * ̋ȐƑ̋Ȑ (oȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ݐݒ肳Ă鉉Z̉ŁA
     * oȐ̒SԂ̋̋e덷菬A
     * oȐ̋Ǐ X ̂Ȃpxpx̋e덷菬A
     * oȐ semiAxis, semiImagAxis ꂼ̍̋e덷ȓłꍇɂ́A
     * oȐ̓I[o[bvĂ̂ƂāA
     * JgclIndefiniteSolution ̗O𔭐B
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * {@link JgclIntsHypCnc2D#intersection(JgclHyperbola2D, JgclHyperbola2D, boolean)
     * JgclIntsHypCnc2D.intersection}(this, mate, doExchange)
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (oȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     * @exception	JgclIndefiniteSolution oȐ̓I[o[bvĂAsł
     */
    JgclIntersectionPoint2D[] intersect(JgclHyperbola2D  mate, boolean doExchange)
	 throws JgclIndefiniteSolution
    {
        if ((this.position().location().identical(mate.position().location())) &&
	    (this.position().x().identicalDirection(mate.position().x()))) {
	    double d_tol = getToleranceForDistance();
	    if (Math.abs(this.xRadius() - mate.xRadius()) <= d_tol &&
		Math.abs(this.yRadius() - mate.yRadius()) <= d_tol) {
		JgclIntersectionPoint2D one_sol;
		if (!doExchange)
		    one_sol = new JgclIntersectionPoint2D(this, 0.0, mate, 0.0, doCheckDebug);
		else
		    one_sol = new JgclIntersectionPoint2D(mate, 0.0, this, 0.0, doCheckDebug);
		throw new JgclIndefiniteSolution(one_sol);
	    }
	}
	JgclIntsHypCnc2D doObj = new JgclIntsHypCnc2D();
	return doObj.intersection(this, mate, doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (|C) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * |C̃NX́u|C vs. oȐv̌_Z\bh
     * {@link JgclPolyline2D#intersect(JgclHyperbola2D, boolean)
     * JgclPolyline2D.intersect(JgclHyperbola2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (|C)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclPolyline2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (gȐ) Ƃ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * gȐ̃NX́ugȐ vs. oȐv̌_Z\bh
     * {@link JgclTrimmedCurve2D#intersect(JgclHyperbola2D, boolean)
     * JgclTrimmedCurve2D.intersect(JgclHyperbola2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (gȐ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclTrimmedCurve2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (ȐZOg) Ƃ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * ȐZOg̃NX́uȐZOg vs. oȐv̌_Z\bh
     * {@link JgclCompositeCurveSegment2D#intersect(JgclHyperbola2D, boolean)
     * JgclCompositeCurveSegment2D.intersect(JgclHyperbola2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (ȐZOg)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclCompositeCurveSegment2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋ȐƑ̋Ȑ (Ȑ) Ƃ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ۂ̉ŹA
     * Ȑ̃NX́uȐ vs. oȐv̌_Z\bh
     * {@link JgclCompositeCurve2D#intersect(JgclHyperbola2D, boolean)
     * JgclCompositeCurve2D.intersect(JgclHyperbola2D, boolean)}
     * ōsȂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (Ȑ)
     * @param doExchange	_ pointOnCurve1/2 邩ǂ
     * @return		_̔z
     */
    JgclIntersectionPoint2D[] intersect(JgclCompositeCurve2D mate, boolean doExchange) {
	return mate.intersect(this, !doExchange);
    }

    /**
     * ̋Ȑ̎w̋ԂItZbgȐA
     * ^ꂽ덷ŋߎ Bspline Ȑ߂B
     * 
     * @param pint	ItZbgp[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.LEFT/RIGHT)
     * @param tol	̋e덷
     * @return		̋Ȑ̎w̋Ԃ̃ItZbgȐߎ Bspline Ȑ
     * @see	JgclWhichSide
     */
    public JgclBsplineCurve2D
	offsetByBsplineCurve(JgclParameterSection pint,
			     double magni,
                             int side,
                             JgclToleranceForDistance tol) {
	JgclOfst2D doObj = new JgclOfst2D(this,pint,magni,side,tol);
	return doObj.offset();
    }

    /**
     * ̋ȐƑ̋ȐƂ̋ʐڐ߂B
     * <p>
     * ʐڐ݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * _ł͎ĂȂ߁A
     * JgclNotSupported	̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		ʐڐ̔z
     * @exception	JgclNotSupported	܂̂ƂAȂ@\ł
     */
    public JgclCommonTangent2D[] commonTangent(JgclParametricCurve2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋ȐƑ̋ȐƂ̋ʖ@߂B
     * <p>
     * ʖ@݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * _ł͎ĂȂ߁A
     * JgclNotSupported	̗O𔭐B
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		ʖ@̔z
     * @exception	JgclNotSupported	܂̂ƂAȂ@\ł
     */
    public JgclCommonNormal2D[]	commonNormal(JgclParametricCurve2D mate) {
	throw new JgclNotSupported();
    }

    /**
     * ̋Ȑ̃p[^`ԂB
     * <p>
     * ŔIȃp[^`ԂB
     * </p>
     * 
     * @return	ŔIȃp[^`
     */
    JgclParameterDomain getParameterDomain() {
	return new JgclParameterDomain();
    }

    /**
     * ̋Ȑ􉽓IɕĂ邩ۂԂB
     * <p>
     * oȐȂ̂ŁA false ԂB
     * </p>
     *
     * @return	oȐ͕邱Ƃ͂Ȃ̂ŁA <code>false</code>
     */
    boolean getClosedFlag() {
	return false;
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricCurve2D#HYPERBOLA_2D JgclParametricCurve2D.HYPERBOLA_2D}
     */
    int type() {
	return HYPERBOLA_2D;
    }

    /**
     * ̋ȐA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricCurve2D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator2D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclAxis2Placement2D tPosition =
	    this.position().transformBy(reverseTransform,
					transformationOperator,
					transformedGeometries);
	double tSemiAxis;
	double tSemiImagAxis;
	if (reverseTransform != true) {
	    tSemiAxis = transformationOperator.transform(this.semiAxis());
	    tSemiImagAxis = transformationOperator.transform(this.semiImagAxis());
	} else {
	    tSemiAxis = transformationOperator.reverseTransform(this.semiAxis());
	    tSemiImagAxis = transformationOperator.reverseTransform(this.semiImagAxis());
	}
	return new JgclHyperbola2D(tPosition, tSemiAxis, tSemiImagAxis);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tposition");
        position().output(writer, indent + 2);
        writer.println(indent_tab + "\tsemiAxis " + semiAxis);
        writer.println(indent_tab + "\tsemiImagAxis " + semiImagAxis);
        writer.println(indent_tab + "End");
    }
}
