/*
 * RFeWl萔Œ`ꂽ3̓W_\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclHomogeneousPoint3D.java,v 1.20 2000/04/26 09:38:57 hideit Exp $
 *
 */

package jp.go.ipa.jgcl;

import java.io.PrintWriter;

/**
 * RFeWl萔Œ`ꂽ3̓W_\NXB
 *
 * @version $Revision: 1.20 $, $Date: 2000/04/26 09:38:57 $
 * @author Information-technology Promotion Agency, Japan
 * @see	JgclCartesianPoint3D
 */

public class JgclHomogeneousPoint3D extends JgclPoint3D {
    /** 
     * WX WlB
     * @serial
     */
    private double wx;

    /** 
     * WY WlB
     * @serial
     */
    private double wy;

    /** 
     * WZ WlB
     * @serial
     */
    private double wz;

    /** 
     * W WlB
     * @serial
     */
    private double w;

    /**
     * WX, WY, WZ, W ݒ肷B
     * 
     * @param wx	WX Wl
     * @param wy	WY Wl
     * @param wz	WZ Wl
     * @param w	W Wl
     */
    private void setArgs(double wx, double wy, double wz, double w) {
	this.wx = wx;
	this.wy = wy;
	this.wz = wz;
	this.w = w;
    }

    /**
     * (WX/W, WY/W, WZ/W) Œ`IuWFNg\zB
     * 
     * @param wx	WX Wl
     * @param wy	WY Wl
     * @param wz	WZ Wl
     * @param w	W Wl
     */
    public JgclHomogeneousPoint3D(double wx, double wy, double wz, double w) {
        super();

	setArgs(wx, wy, wz, w);
    }

    /**
     * (c[0]/c[3], c[1]/c[3], c[2]/c[3]) Œ`IuWFNg\zB
     * 
     * @param c	Wl̔z
     */
    public JgclHomogeneousPoint3D(double[] c) {
	super();

	setArgs(c[0], c[1], c[2], c[3]);
    }

    /**
     * X Wl (WX/W) ԂB
     *
     * @return X Wl
     */
    public double x() {
        return wx / w;
    }

    /**
     * Y Wl (WY/W) ԂB
     *
     * @return Y Wl
     */
    public double y() {
        return wy / w;
    }

    /**
     * Z Wl (WZ/W) ԂB
     *
     * @return Z Wl
     */
    public double z() {
        return wz / w;
    }

    /**
     * WX WlԂB
     *
     * @return WX Wl
     */
    public double wx() {
        return wx;
    }

    /**
     * WY WlԂB
     *
     * @return WY Wl
     */
    public double wy() {
        return wy;
    }

    /**
     * WZ WlԂB
     *
     * @return WZ Wl
     */
    public double wz() {
        return wz;
    }

    /**
     * W WlԂB
     *
     * @return W Wl
     */
    public double w() {
        return w;
    }

    /**
     * ̓_A^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclPoint3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclPoint3D crd;
	if (reverseTransform == false)
	    crd = transformationOperator.transform(this);
	else
	    crd = transformationOperator.reverseTransform(this);
	return new JgclHomogeneousPoint3D((this.w * crd.x()),
					  (this.w * crd.y()),
					  (this.w * crd.z()),
					  this.w);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab
                       + getClassName() + " "
                       + wx() + " " 
                       + wy() + " " 
                       + wz() + " " 
                       + w()  + " End");
                       
    }
}
