/*
 * ISO 10303-42 4.6 geometry_schema function definitions ̈ꕔNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclGeometrySchemaFunction.java,v 1.11 2000/04/26 09:38:56 hideit Exp $
 */

package jp.go.ipa.jgcl;

/**
 * ISO 10303-42 4.6 geometry_schema function definitions ̈ꕔNXB
 * <p>
 * ISO 10303-42:1994(E)  95 y[WQƂ̂ƁB
 * </p>
 *
 * @version $Revision: 1.11 $, $Date: 2000/04/26 09:38:56 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclGeometrySchemaFunction {
    /**
     * ̃NX̃CX^X͍ȂB
     */
    private JgclGeometrySchemaFunction() {
    }

    /**
     * Q : refDirection w肳ȂƂ̃ftHgl
     */
    public static final JgclVector2D defaultRefDirection2D = JgclVector2D.xUnitVector;

    /**
     * R : axis w肳ȂƂ̃ftHgl
     */
    public static final JgclVector3D defaultAxis3D = JgclVector3D.zUnitVector;

    /**
     * R : refDirection w肳ȂƂ̃ftHgl
     */
    public static final JgclVector3D defaultRefDirection3D = JgclVector3D.xUnitVector;

    /**
     * ISO 10303-42 4.6.6  (1) : ^ꂽ̃xNg琳KꂽQ߂B
     * <p>
     * axis1, axis2 ɒ̒PʃxNg U1, U2 ߂B
     * ʂƂēz̗vf 2 ŁA
     * ŏ̗vfꎲ\PʃxNg U1A
     * Ԗڂ̗vfꎲɒ񎲂\PʃxNg U2 \B
     * </p>
     * <p>
     * axis1  null łȂ΁A
     * axis1 PʉxNg U1 ƂA
     * U1 𔽎v 90]xNg U2 ƂB
     * ̂Ƃ axis2  null łȂA
     * axis2  U2 ̓ς̒lł΁AU2  180]B
     * </p>
     * <p>
     * axis1  null łA axis2  null łȂ΁A
     * axis2 PʉxNg U2 ƂA
     * U2 v 90]xNg U1 ƂB
     * </p>
     * <p>
     * axis1, axis2 Ƃ null ł΁A
     * O[o X ̒PʃxNg U1A
     * O[o Y ̒PʃxNg U2 ƂB
     * </p>
     * <p>
     * ȂALŖ炩Ȃ悤ɁA
     * ̃\bhԂ́AnƂȂꍇB
     * </p>
     *
     * @param axis1	ꎲ̕K肷QxNg
     * @param axis2	񎲂̕K肷QxNg
     * @return	Q̒̔z
     * @see	#orthogonalComplement(JgclVector2D)
     */
    public static JgclVector2D[] baseAxis(JgclVector2D axis1, JgclVector2D axis2) {
	JgclVector2D[] u = new JgclVector2D[2];

	if (axis1 != null) {
	    u[0] = axis1.unitized();
	    u[1] = orthogonalComplement(u[0]);
	    if (axis2 != null) {
		if (axis2.dotProduct(u[1]) < 0.0) {
		    u[1] = u[1].reverse();
		}
	    }
	} else {
	    if (axis2 != null) {
		u[1] = axis2.unitized();
		u[0] = orthogonalComplement(u[1]).reverse();
	    } else {
		u[0] = JgclVector2D.xUnitVector;
		u[1] = JgclVector2D.yUnitVector;
	    }
	}
	return u;
    }

    /**
     * ISO 10303-42 4.6.6  (2) : ^ꂽO̃xNg琳KꂽR߂B
     * <p>
     * axis1, axis2, axis3 Ɍ݂ɒO̒PʃxNg U1, U2, U3 ߂B
     * ʂƂēz̗vf 3 ŁA
     * ŏ̗vfꎲ\PʃxNg U1A
     * Ԗڂ̗vf񎲂\PʃxNg U2A
     * Ō̗vfO\PʃxNg U3 \B
     * </p>
     * <p>
     * ܂ axis3  null łȂ΁A
     * axis3 PʉxNg U3 ƂB
     * axis3  null ł΁A
     * O[o Z ̒PʃxNg U3 ƂB
     * </p>
     * <p>
     *  U1 ȉ̏Ō肷B
     * <pre>
     * 	U1 = {@link #firstProjAxis(JgclVector3D, JgclVector3D) firstProjAxis}(U3, axis1)
     * </pre>
     * </p>
     * <p>
     * Ō U2 ȉ̏Ō肷B
     * <pre>
     * 	U2 = {@link #secondProjAxis(JgclVector3D, JgclVector3D, JgclVector3D) secondProjAxis}(U3, U1, axis2)
     * </pre>
     * </p>
     * <p>
     * ȂÃ\bhł́A
     * firstProjAxis(JgclVector3D, JgclVector3D)
     * 
     * secondProjAxis(JgclVector3D, JgclVector3D, JgclVector3D)
     * ŔO catch ĂȂB
     * </p>
     * <p>
     * ȂALŖ炩Ȃ悤ɁA
     * ̃\bhԂ́AnƂȂꍇB
     * </p>
     *
     * @param axis1	ꎲ̕K肷RxNg
     * @param axis2	񎲂̕K肷RxNg
     * @param axis3	O̕K肷RxNg
     * @return	R̒̔z
     * @see	#firstProjAxis(JgclVector3D, JgclVector3D)
     * @see	#secondProjAxis(JgclVector3D, JgclVector3D, JgclVector3D)
     */
    public static JgclVector3D[] baseAxis(JgclVector3D axis1, JgclVector3D axis2,
					  JgclVector3D axis3) {
	JgclVector3D[] u = new JgclVector3D[3];

	if (axis3 != null) {
	    u[2] = axis3.unitized();
	} else {
	    u[2] = JgclVector3D.zUnitVector;
	}
	u[0] = firstProjAxis(u[2], axis1);
	u[1] = secondProjAxis(u[2], u[0], axis2);

	return u;
    }

    /**
     * ISO 10303-42 4.6.7  : ^ꂽxNgAǏWn X/Y \PʃxNg߂B
     * <p>
     * ʂƂēz̗vf 2 ŁA
     * ŏ̗vfǏWn X \PʃxNgA
     * Ԗڂ̗vfǏWn Y \PʃxNgB
     * </p>
     * <p>
     * refDirection  null łȂ΁A
     * refDirection PʉxNgǏWn X ƂB
     * refDirection  null ł΁A
     * O[o X ̒PʃxNgǏWn X ƂB
     * </p>
     * <p>
     * ǏWn Y PʃxNǵA
     * ɋǏWn X PʃxNg
     * v 90]̂łB
     * </p>
     *
     * @param refDirection	ǏWn X \QxNg
     * @return	ǏWn X/Y \PʃxNg̔z
     */
    public static JgclVector2D[] build2Axes(JgclVector2D refDirection) {
	JgclVector2D[] axes = new JgclVector2D[2];

	if (refDirection == null) {
	    axes[0] = JgclGeometrySchemaFunction.defaultRefDirection2D;
	} else {
	    axes[0] = refDirection.unitized();
	}
	axes[1] = orthogonalComplement(axes[0]);
	return axes;
    }

    /**
     * ISO 10303-42 4.6.8  : ^ꂽxNgAǏWn X/Y/Z \PʃxNg߂B
     * <p>
     * ʂƂēz̗vf 3 ŁA
     * ŏ̗vfǏWn X \PʃxNg U1A
     * Ԗڂ̗vfǏWn Y \PʃxNg U2A
     * Ō̗vfǏWn Z \PʃxNg U3 B
     * </p>
     * <p>
     * ܂Aaxis  null łȂ΁A
     * axis PʉxNg U3 ƂB
     * axis  null ł΁A
     * O[o Z ̒PʃxNg U3 ƂB
     * </p>
     * <p>
     * ɁAU1 ȉ̏Ō肷B
     * <pre>
     * 	U1 = {@link #firstProjAxis(JgclVector3D, JgclVector3D) firstProjAxis}(U3, refDirection)
     * </pre>
     * </p>
     * <p>
     * Ō U3  U1 ̊OςPʉxNg U2 ƂB
     * </p>
     * <p>
     * ȂÃ\bhł́A
     * firstProjAxis(JgclVector3D, JgclVector3D)
     * ŔO catch ĂȂB
     * </p>
     *
     * @param axis		Z K肷RxNg
     * @param refDirection	X K肷QxNg
     * @return	X/Y/Z \PʃxNg̔z
     * @see	#firstProjAxis(JgclVector3D, JgclVector3D)
     */
    public static JgclVector3D[] buildAxes(JgclVector3D axis, JgclVector3D refDirection) {
	JgclVector3D[] axes = new JgclVector3D[3];

	if (axis == null) {
	    axes[2] = JgclGeometrySchemaFunction.defaultAxis3D;
	} else {
	    axes[2] = axis.unitized();
	}
	if (refDirection == null) {
	    axes[0] = firstProjAxis(axes[2], JgclGeometrySchemaFunction.defaultRefDirection3D);
	} else {
	    axes[0] = firstProjAxis(axes[2], refDirection);
	}
	axes[1] = axes[2].crossProduct(axes[0]).unitized();
	return axes;
    }

    /**
     * ISO 10303-42 4.6.9  : ^ꂽxNg (v)  90]xNg߂B
     *
     * @param vec	xNg
     * @return		 (v)  90]xNg
     */
    public static JgclVector2D orthogonalComplement(JgclVector2D vec) {
	return new JgclLiteralVector2D(-vec.y(), vec.x());
    }

    /**
     * ISO 10303-42 4.6.10  : ^ꂽxNg镽ʂɓexNg߂B
     * <p>
     * arg AzAxis @Ƃ镽ʂɓePʉxNgԂB
     * </p>
     * <p>
     * zAxis  null ̏ꍇɂ
     * JgclFatal ̗O𔭐B
     * </p>
     * <p>
     * zAxis PʉxNg arg ̊OσxNg̑傫A
     * ݐݒ肳Ă鉉Z̋̋e덷ꍇɂ
     * JgclFatal ̗O𔭐B
     * </p>
     * <p>
     * arg  null ł΁A
     * ̃\bh̓ zAxis Ɠł͂ȂxNgIA
     *  arg ƂĉZi߂B
     * </p>
     *
     * @param zAxis	ʂ̖@xNg
     * @param arg	exNg
     * @return		ẽxNg
     */
    public static JgclVector3D firstProjAxis(JgclVector3D zAxis, JgclVector3D arg) {
	JgclVector3D z;
	JgclVector3D v;

	if (zAxis == null) {
	    throw new JgclFatal();
	}
	z = zAxis.unitized();
	if (arg == null) {
	    v = JgclVector3D.xUnitVector;
	    if (z.identicalDirection(v)) {
		v = JgclVector3D.yUnitVector;
	    }
	} else {
	    JgclConditionOfOperation condition = JgclConditionOfOperation.getCondition();
	    if (arg.crossProduct(z).norm() <= condition.getToleranceForDistance2()) {
		throw new JgclFatal();
	    }
	    v = arg.unitized();
	}
	return v.subtract(z.multiply(v.dotProduct(z))).unitized();
    }

    /**
     * ISO 10303-42 4.6.11  : ^ꂽxNg̕ʂɓexNg߂B
     * <p>
     * arg A
     * zAxis @Ƃ镽ʂɓeɁA
     * xAxis @Ƃ镽ʂɓePʉxNgԂB
     * </p>
     * <p>
     * zAxis, xAxis ̂ꂩ null ̏ꍇɂ
     * JgclFatal ̗O𔭐B
     * </p>
     * <p>
     * arg  null ł΁A
     * O[o Y ̒PʃxNg arg ƂĉZi߂B
     * </p>
     *
     * @param zAxis	̕ʂ̖@xNg
     * @param xAxis	̕ʂ̖@xNg
     * @param arg	exNg
     * @return		ẽxNg
     */
    public static JgclVector3D secondProjAxis(JgclVector3D zAxis, JgclVector3D xAxis,
					      JgclVector3D arg) {
	JgclConditionOfOperation condition =
	    JgclConditionOfOperation.getCondition();
	JgclVector3D z, x, v;

	if (zAxis == null || xAxis == null) {
	    throw new JgclFatal();
	}

	z = zAxis.unitized();
	x = xAxis.unitized();

	if (arg == null) {
	    v = JgclVector3D.yUnitVector;
	} else {
	    v = arg.unitized();
	}
	v = v.subtract(z.multiply(v.dotProduct(z))).unitized();
	return v.subtract(x.multiply(v.dotProduct(x))).unitized();
    }
}
