/*
 * 2̐_RȖʂ\ۃNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclFreeformSurfaceWithGivenControlPointsArray2D.java,v 1.3 2000/04/26 09:38:56 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * 2̐_RȖʂ\ۃNX
 *
 * @version $Revision: 1.3 $, $Date: 2000/04/26 09:38:56 $
 * @author Information-technology Promotion Agency, Japan
 */
abstract class JgclFreeformSurfaceWithGivenControlPointsArray2D extends JgclParametricSurface2D {
    /**
     * _Əd݂\3z
     * <p>
     * Ō̎ 3 łΗLŁA
     * [][][0], [][][1] ͓̐Wlŗ^̂Ƃ
     * </p>
     * @serial
     */
    protected double[][][] controlPointsArray;

    /**
     * Lۂ
     * @serial
     */
    boolean isRational;

    /**
     * _(Əd)3zƂė^đ/LȖʂ\z
     * <p>
     * ^z̓xWGȖʂ̐_̔zƂĐĂ̂Ƃ
     * </p>
     *
     * @param cpArray	_Ad݂\z
     */
    protected JgclFreeformSurfaceWithGivenControlPointsArray2D(double[][][] cpArray) {
	super();
	controlPointsArray = cpArray;
	isRational = (controlPointsArray[0][0].length == 3) ? true : false;
    }

    /**
     * _̐i[ double ̎Oz̗̈l
     *
     * @param isPoly	`ǂ?
     * @param uSize	z̑ꎟ̗vf
     * @param vSize	z̑񎟌̗vf
     * @return		_̐i[z
     */
    static protected double[][][] allocateDoubleArray(boolean isPoly,
						      int uSize,
						      int vSize) {
	return new double[uSize][vSize][(isPoly) ? 2 : 3];
    }

    /*
     * _double3zɃZbg
     *
     * @param isPoly	`ǂ?
     * @return		_\z
     */
    protected double[][][] toDoubleArray() {
	return controlPointsArray;
    }

    /**
     * (i, j)Ԃ߂̐_ X Ԃ
     * 
     * @param i		ŨCfbNX(iԂ)
     * @param j		ṼCfbNX(jԂ)
     * @return		_ X 
     */
    public double xAt(int i, int j) {
	if (isRational != true)
	    return controlPointsArray[i][j][0];
	else
	    return controlPointsArray[i][j][0] / controlPointsArray[i][j][2];
    }

    /**
     * (i, j)Ԃ߂̐_ Y Ԃ
     * 
     * @param i		ŨCfbNX(iԂ)
     * @param j		ṼCfbNX(jԂ)
     * @return		_ Y 
     * @return		_
     */
    public double yAt(int i, int j) {
	if (isRational != true)
	    return controlPointsArray[i][j][1];
	else
	    return controlPointsArray[i][j][1] / controlPointsArray[i][j][2];
    }

    /**
     * (i, j)Ԃ߂̏d݂Ԃ
     * Ȑ̏ꍇ́AJgclInvalidArgumentValue𓊂(?)
     * 
     * @param i		ŨCfbNX(iԂ)
     * @param j		ṼCfbNX(jԂ)
     * @return		d
     */
    public double weightAt(int i, int j) {
	if (isRational != true)
	    throw new JgclInvalidArgumentValue();
	else
	    return controlPointsArray[i][j][2];
    }

    /**
     * U̐_̐Ԃ
     * 
     * @return		U̐_̐
     */
    public int uNControlPoints() {
	return controlPointsArray.length;
    }

    /**
     * V̐_̐Ԃ
     * 
     * @return		V̐_̐
     */
    public int vNControlPoints() {
	return controlPointsArray[0].length;
    }

    /**
     * _̐Ԃ
     * 
     * @return		_̐
     */
    public int nControlPoints() {
	return uNControlPoints() * vNControlPoints();
    }

    /**
     * L`ۂԂ
     *
     * @return		L`Ȃtrue
     */
    public boolean isRational() {
	return isRational;
    }

    /**
     * `ۂԂ
     *
     * @return		`Ȃtrue
     */
    public boolean isPolynomial() {
	return !isRational;
    }

    /**
     * LȖʏ̓_ČvZ
     *
     * @param d0	Ȑ̓_
     */
    protected void convRational0Deriv(double[] d0) {
	for (int i = 0; i < 2; i++)
	    d0[i] /= d0[2];
    }

    /**
     * LȖʂ̈ꎟΓ֐ČvZ
     *
     * @param d0D	Ȗʏ̓_
     * @param du	ÜꎟΓ֐
     * @param dv	V̈ꎟΓ֐
     */
    protected void convRational1Deriv(double[] d0, double[] du, double[] dv) {
	convRational0Deriv(d0);
	for (int i = 0; i < 2; i++) {
	    du[i] = (du[i] - (du[2] * d0[i])) / d0[2];
	    dv[i] = (dv[i] - (dv[2] * d0[i])) / d0[2];
	}
    }

    /**
     * LȖʂ̓񎟕Γ֐AꎟΓ֐ČvZ
     *
     * @param d0D	Ȗʏ̓_
     * @param du	ÜꎟΓ֐
     * @param dv	V̈ꎟΓ֐
     * @param duv	U̓񎟕Γ֐
     * @param duv	UV̈ꎟΓ֐
     * @param dvv	V̓񎟕Γ֐
     */
    protected void convRational2Deriv(double[] d0, double[] du, double[] dv,
				      double[] duu, double[] duv, double[] dvv) {
	convRational1Deriv(d0, du, dv);
	for (int i = 0; i < 2; i++) {
	    duu[i] = (duu[i] - (duu[2] * d0[i]) - (2.0 * du[2] * du[i])) / d0[2];
	    duv[i] = (duv[i] - (duv[2] * d0[i]) - (du[2] * dv[i]) - (dv[2] * du[i])) / d0[2];
	    dvv[i] = (dvv[i] - (dvv[2] * d0[i]) - (2.0 * dv[2] * dv[i])) / d0[2];
	}
    }


    /**
     * 悻̑ݔ͈͂`߂
     *
     * @return		悻̑ݔ͈͂`
     * @see		JgclEnclosingBox2D
     */
    JgclEnclosingBox2D approximateEnclosingBox() {
	double min_crd_x;
	double min_crd_y;
	double max_crd_x;
	double max_crd_y;
	int uN = uNControlPoints();
	int vN = vNControlPoints();
	double x, y;
	int i, j;

	max_crd_x = min_crd_x = xAt(0, 0);
	max_crd_y = min_crd_y = yAt(0, 0);

	for (i = 1; i < uN; i++) {
	    x = xAt(i, 0);
	    y = yAt(i, 0);
	    /**/ if (x < min_crd_x) min_crd_x = x;
	    else if (x > max_crd_x) max_crd_x = x;
	    /**/ if (y < min_crd_y) min_crd_y = y;
	    else if (y > max_crd_y) max_crd_y = y;
	}
	for (j = 1; j < vN; j++) {
	    for (i = 0; i < uN; i++) {
		x = xAt(i, j);
		y = yAt(i, j);
		/**/ if (x < min_crd_x) min_crd_x = x;
		else if (x > max_crd_x) max_crd_x = x;
		/**/ if (y < min_crd_y) min_crd_y = y;
		else if (y > max_crd_y) max_crd_y = y;
	    }
	}
	return new JgclEnclosingBox2D(min_crd_x, min_crd_y,
				      max_crd_x, max_crd_y);
    }

    /**
     * R`󂩔ۂԂ
     */
    public boolean isFreeform() {
	return true;
    }
}
