/*
 * R : _RȖʂ\ۃNX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclFreeformSurfaceWithControlPoints3D.java,v 1.23 2000/08/11 06:18:49 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * R : _RȖʂ\ۃNXB
 * <p>
 * ̃NX̃CX^X́A
 * _ (JgclPoint3D) ̂Qz controlPoints
 * 
 * d (double) ̂Qz weights
 * B
 * </p>
 * <p>
 * points  mesh ́AU ̃CfbNXAV ̃CfbNXB
 * ܂AU  i ԖځAV  j Ԗڂ̐_̏
 * points[i][j], weights[i][j] Ɋi[B
 * </p>
 * <p>
 * weights  null ̏ꍇɂ͔LȖ (Ȗ) \B
 * </p>
 * <p>
 * weights ɔz񂪐ݒ肳Ăꍇɂ͗LȖʂ\B
 * weights[i][j]  controlPoints[i][j] ɑΉB
 * ȂA܂̂Ƃ weights[i][j] ̒l͐łȂ΂ȂȂB
 * </p>
 *
 * @version $Revision: 1.23 $, $Date: 2000/08/11 06:18:49 $
 * @author Information-technology Promotion Agency, Japan
 */

public abstract class JgclFreeformSurfaceWithControlPoints3D extends JgclBoundedSurface3D {
    /**
     * _̂QzB
     * @serial
     */
    protected JgclPoint3D[][] controlPoints;

    /**
     * d݂̂QzB
     * <p>
     * Ȗʂł null ƂB
     * </p>
     * @serial
     */
    protected double[][] weights;

    /**
     * _Əd݂\RzB
     * <p>
     * KvɉăLbVB
     * </p>
     * <p>
     * controlPointsArray[i][j] ̒ 3 ̏ꍇA
     * controlPointsArray[i][j][0]  (i, j) Ԗڂ̐_ X A
     * controlPointsArray[i][j][1]  (i, j) Ԗڂ̐_ Y 
     * controlPointsArray[i][j][2]  (i, j) Ԗڂ̐_ Z 
     * \B
     * </p>
     * <p>
     * controlPointsArray[i][j] ̒ 4 ̏ꍇA
     * controlPointsArray[i][j][0]  ((i, j) Ԗڂ̐_ X  * (i, j) Ԗڂ̏d)A
     * controlPointsArray[i][j][1]  ((i, j) Ԗڂ̐_ Y  * (i, j) Ԗڂ̏d)A
     * controlPointsArray[i][j][2]  ((i, j) Ԗڂ̐_ Z  * (i, j) Ԗڂ̏d)A
     * controlPointsArray[i][j][3]  (i, j) Ԗڂ̏d
     * \B
     * </p>
     * @serial
     */
    private double[][][] controlPointsArray = null;

    /**
     * ^ɃIuWFNg\zB
     * <p>
     * etB[hɂ͒lݒ肵ȂB
     * </p>
     */
    protected JgclFreeformSurfaceWithControlPoints3D() {
	super();
    }

    /**
     * _^đȖʂƂăIuWFNg\zB
     * <p>
     * ȉ̂ꂩ̏ꍇɂ́AJgclInvalidArgumentValue ̗O𔭐B
     * <ul>
     * <li>	controlPoints  null ł
     * <li>	controlPoints ̒ 2 菬
     * <li>	controlPoints[i] ̒ 2 菬
     * <li>	controlPoints[k]  controlPoints[l] ̒قȂ
     * <li>	controlPoints ̂vf̒l null ł
     * </ul>
     * </p>
     *
     * @param controlPoints	_̂Qz
     * @see	JgclInvalidArgumentValue
     */
    protected JgclFreeformSurfaceWithControlPoints3D(JgclPoint3D[][] controlPoints) {
	super();
	int[] npnts = setControlPoints(controlPoints);
	weights = null;
    }

    /**
     * _Ədݗ^ėLȖʂƂăIuWFNg\zB
     * <p>
     * ȉ̂ꂩ̏ꍇɂ́AJgclInvalidArgumentValue ̗O𔭐B
     * <ul>
     * <li>	controlPoints  null ł
     * <li>	controlPoints ̒ 2 菬
     * <li>	controlPoints[i] ̒ 2 菬
     * <li>	controlPoints[k]  controlPoints[l] ̒قȂ
     * <li>	controlPoints ̂vf̒l null ł
     * <li>	weights  null ł
     * <li>	weights ̒ controlPoints ̒ƈقȂ
     * <li>	weights[i] ̒ controlPoints[i] ̒ƈقȂ
     * <li>	weights ̂vf̒lłȂ
     * <li>	weights ̂vf̒l w ɂāA
     *		(w / (weights ̍ől))  JgclMachineEpsilon.DOUBLE 菬ȂB
     * </ul>
     * </p>
     * @param controlPoints	_̂Qz
     * @param weights		d݂̂Qz
     * @see	JgclInvalidArgumentValue
     */
    protected JgclFreeformSurfaceWithControlPoints3D(JgclPoint3D[][] controlPoints,
						     double[][] weights) {
	super();
	int[] npnts = setControlPoints(controlPoints);
	setWeights(npnts, weights);
    }

    /**
     * _(Əd)3zƂė^đ/LȖʂ\z
     *
     * @param cpArray	_Ad݂\z
     */
    protected JgclFreeformSurfaceWithControlPoints3D(double[][][] cpArray) {
	this(cpArray, true);
    }

    /**
     * _ (Əd) Ozŗ^
     * Ȗ (邢͗LȖ) ƂăIuWFNg\zB
     * <p>
     * cpArray ̒ U ̐_̐A
     * cpArray[0] ̒ V ̐_̐ƂB
     * ܂AcpArray[0][0] ̒ 3 łΑȖʁA4 łΗLȖʂƂB
     * </p>
     * <p>
     * cpArray[i][j] ̒ 3 ̏ꍇA
     * cpArray[i][j][0]  (i, j) Ԗڂ̐_ X A
     * cpArray[i][j][1]  (i, j) Ԗڂ̐_ Y A
     * cpArray[i][j][2]  (i, j) Ԗڂ̐_ Z 
     * ̂ƂB
     * </p>
     * <p>
     * cpArray[i][j] ̒ 4 ̏ꍇA
     * cpArray[i][j][0]  ((i, j) Ԗڂ̐_ X  * (i, j) Ԗڂ̏d)A
     * cpArray[i][j][1]  ((i, j) Ԗڂ̐_ Y  * (i, j) Ԗڂ̏d)A
     * cpArray[i][j][2]  ((i, j) Ԗڂ̐_ Z  * (i, j) Ԗڂ̏d)A
     * cpArray[i][j][3]  (i, j) Ԗڂ̏d
     * ̂ƂB
     * </p>
     * <p>
     * doCheck  true ̏ꍇAȉ̃`FbNsȂB
     * </p>
     * <blockquote>
     * <p>
     * ȉ̂ꂩ̏ꍇɂ́AJgclInvalidArgumentValue ̗O𔭐B
     * <ul>
     * <li>	U ̐_̐ 2 菬
     * <li>	V ̐_̐ 2 菬
     * <li>	d݂̒lłȂ
     * <li>	d݂̒l w ɂāA
     *		(w / (dݗ̍ől))  JgclMachineEpsilon.DOUBLE 菬ȂB
     * </ul>
     * </p>
     * </blockquote>
     *
     * @param cpArray	_ (яd) ̔z
     * @param doCheck	̃`FbNsȂǂ
     * @see	JgclInvalidArgumentValue
     */
    protected JgclFreeformSurfaceWithControlPoints3D(double[][][] cpArray,
						     boolean doCheck) {
	super();

	int uNpnts = cpArray.length;
	int vNpnts = cpArray[0].length;
	int[] npnts = null;
	int dimension = cpArray[0][0].length;
	JgclPoint3D[][] cp = new JgclPoint3D[uNpnts][vNpnts];
	double[][] wt = null;
	boolean isPoly = (dimension == 3);
	int i, j, k;

	if (!isPoly) {	// L
	    double[] tmp = new double[4];
	    wt = new double[uNpnts][vNpnts];
	    for (i = 0; i < uNpnts; i++) {
		for (j = 0; j < vNpnts; j++) {
		    for (k = 0; k < 4; k++)
			tmp[k] = cpArray[i][j][k];
		    convRational0Deriv(tmp);
		    cp[i][j] = new JgclCartesianPoint3D(tmp[0], tmp[1], tmp[2]);
		    wt[i][j] = tmp[3];
		}
	    }
	} else {
	    for (i = 0; i < uNpnts; i++) {
		for (j = 0; j < vNpnts; j++) {
		    cp[i][j] = new JgclCartesianPoint3D(cpArray[i][j][0],
							cpArray[i][j][1],
							cpArray[i][j][2]);
		}
	    }
	}
	if (doCheck) {
	    npnts = setControlPoints(cp);
	} else {
	    this.controlPoints = cp;
	}
	if (isPoly) {
	    this.weights = null;
	} else {
	    if (doCheck) {
		setWeights(npnts, wt);
	    } else {
		this.weights = wt;
	    }
	}
    }

    /**
     * _Ədݗ^
     * Ȗʂ邢͗LȖʂƂăIuWFNg\zB
     * <p>
     * doCheck  false ̏ꍇA
     * ^ꂽ controlPoints  weights ̒l
     * ΉtB[hɂ̂܂ܐݒ肷B
     *  weights  null ł΁AȖʂ͔L () `ɂȂB
     * ȂAcontrolPoints  null ^ƁA\łȂʂB
     * </p>
     * <p>
     * doCheck  true ̏ꍇA
     * weights lĂ
     * {@link #JgclFreeformSurfaceWithControlPoints3D(JgclPoint3D[][], double[][])
     * JgclFreeformSurfaceWithControlPoints3D(JgclPoint3D[][], double[][])}A
     * weights  null ł
     * {@link #JgclFreeformSurfaceWithControlPoints3D(JgclPoint3D[][])
     * JgclFreeformSurfaceWithControlPoints3D(JgclPoint3D[][])}
     * Ɠl̏sȂB
     * </p>
     *
     * @param controlPoitns	_̔z
     * @param weights	d݂̔z
     * @param doCheck	̃`FbNsȂǂ
     */
    protected JgclFreeformSurfaceWithControlPoints3D(JgclPoint3D[][] controlPoints,
						     double[][] weights,
						     boolean doCheck) {
	super();
	if (doCheck) {
	    int[] npnts = setControlPoints(controlPoints);
	    if (weights == null)
		weights = null;
	    else
		setWeights(npnts, weights);
	} else {
	    this.controlPoints = controlPoints;
	    this.weights = weights;
	}
    }

    /**
     * ̋Ȗʂ̐_̂QzԂB
     * 
     * @return	_̂Qz
     */
    public JgclPoint3D[][] controlPoints() {
	JgclPoint3D[][] copied = new JgclPoint3D[controlPoints.length][controlPoints[0].length];

	for (int i = 0; i < controlPoints.length; i++)
	    for (int j = 0; j < controlPoints[0].length; j++)
		copied[i][j] = controlPoints[i][j];
	return copied;
    }

    /**
     * ̋Ȗʂ (i, j) Ԗڂ̐_ԂB
     * 
     * @param i		U ̃CfbNX (i Ԗ)
     * @param j		V ̃CfbNX (j Ԗ)
     * @return	_
     */
    public JgclPoint3D controlPointAt(int i, int j) {
	return controlPoints[i][j];
    }

    /**
     * ̋Ȗʂ̏d݂̂QzԂB
     * <p>
     * ȖʂȖʂ̏ꍇ null ԂB
     * </p>
     * 
     * @return	d݂̂Qz
     */
    public double[][] weights() {
	if (weights == null)
	    return null;
	return (double[][])weights.clone();
    }

    /**
     * ̋Ȗʂ (i, j) Ԗڂ̏d݂ԂB
     * <p>
     * ȖʂȖʂ̏ꍇɂ
     * JgclInvalidArgumentValue ̗O𓊂B
     * </p>
     * 
     * @param i		U ̃CfbNX (i Ԗ)
     * @param j		V ̃CfbNX (j Ԗ)
     * @return	d
     * @see	JgclInvalidArgumentValue
     */
    public double weightAt(int i, int j) {
	if (weights == null)
	    throw new JgclInvalidArgumentValue();
	return weights[i][j];
    }

    /**
     * ̋Ȗʂ U ̐_̐ԂB
     * 
     * @return	U ̐_̐
     * @see	#vNControlPoints()
     * @see	#nControlPoints()
     */
    public int uNControlPoints() {
	return controlPoints.length;
    }

    /**
     * ̋Ȗʂ V ̐_̐ԂB
     * 
     * @return	V ̐_̐
     * @see	#uNControlPoints()
     * @see	#nControlPoints()
     */
    public int vNControlPoints() {
	return controlPoints[0].length;
    }

    /**
     * ̋Ȗʂ̐_̑ԂB
     * <p>
     * (U ̐_̐ * V ̐_̐) ԂB
     * </p>
     * 
     * @return	_̑
     * @see	#uNControlPoints()
     * @see	#vNControlPoints()
     */
    public int nControlPoints() {
	return uNControlPoints() * vNControlPoints();
    }

    /**
     * ̋ȖʂL`ۂԂB
     *
     * @return	L`Ȃ trueAłȂ false
     */
    public boolean isRational() {
	return weights != null;
    }

    /**
     * ̋Ȗʂ`ۂԂB
     *
     * @return	`Ȃ trueAłȂ false
     */
    public boolean isPolynomial() {
	return weights == null;
    }

    /**
     * ̋Ȗʂʌ`Ƃ݂Ȃ邩ǂԂۃ\bhB
     *
     * @param tol	ʂƂ݂Ȃ̋e덷
     * @return		ʂƂ݂ȂȂ trueAłȂ false
     */
    abstract boolean isPlaner(JgclToleranceForDistance tol);

    /**
     * ̋Ȗʂ^ꂽxɂĕʂƌȂȂꍇɁA
     * U/V Ƀp[^_œ񕪊钊ۃ\bhB
     * <p>
     * ʂƂēz S ̗vf̐ 4 łB
     * evf́A̋Ȗʂ𕪊Ȗʂ̂ꂼ\B
     * <p>
     * ^ꂽ tol ɂāAȖʂ𕪊KvȂꍇɂ
     * S[i] (i = 0, ..., 3) ɂׂ͂ null B
     * </p>
     * <p>
     * Ȗʂ U/V Ƃɓ񕪊ꍇɂ́A
     * S ̊evf͈ȉ̋Ȗʂ\B
     * <pre>
     *		S[0] : U AV ɂȖ
     *		S[1] : U 㑤AV ɂȖ
     *		S[2] : U AV 㑤ɂȖ
     *		S[3] : U 㑤AV 㑤ɂȖ
     * </pre>
     * </p>
     * <p>
     * Ȗʂ U ɂ̂ݓ񕪊 (V ɂ͕KvȂ) ꍇɂ́A
     * S ̊evf͈ȉ̋Ȗʂ\B
     * <pre>
     *		S[0] : U ɂȖ
     *		S[1] : U 㑤ɂȖ
     *		S[2] : null
     *		S[3] : null
     * </pre>
     * </p>
     * <p>
     * Ȗʂ V ɂ̂ݓ񕪊 (U ɂ͕KvȂ) ꍇɂ́A
     * S ̊evf͈ȉ̋Ȗʂ\B
     * <pre>
     *		S[0] : V ɂȖ
     *		S[1] : null
     *		S[2] : V 㑤ɂȖ
     *		S[3] : null
     * </pre>
     * </p>
     *
     * @param tol	ʂƂ݂Ȃ̋e덷
     * @return		ꂽȖʂ̔z
     */
    abstract JgclFreeformSurfaceWithControlPoints3D[] divideForMesh(JgclToleranceForDistance tol);

    /**
     * ZOgɂǏIȃp[^l\NXB
     * <p>
     * ǏIȃp[^l͕ (a/b) ŕ\B
     * ̎̕蓾l͈̔͂ [0, 1] łB
     * </p>
     */
    class MeshParam {
	/**
	 * ZOg
	 * u(p[^I) kނĂȂLȃZOgvɂCfbNXB
	 */
	int sgidx;

	/**
	 * p[^l̕q : a/b  a B
	 */
	int numer;

	/**
	 * p[^l̕ : a/b  b B
	 */
	int denom;

	/**
	 * etB[hɐݒ肷l^ăIuWFNg\zB
	 *
	 * @param sgidx	ZOǵuLȃZOgvɂCfbNX
	 * @param numer	p[^l̕q
	 * @param denom	p[^l̕
	 */
	MeshParam(int sgidx, int numer, int denom) {
	    super();
	    this.sgidx = sgidx;
	    this.numer = numer;
	    this.denom = denom;
	}

	/**
	 * ̃p[^lƗ^ꂽp[^l̒l\ۂԂB
	 *
	 * @return	̒l\ trueAłȂ false
	 */
	private boolean isSame(MeshParam mate) {
	    if (this.sgidx != mate.sgidx) {
		/*
		 * different segment
		 *
		 * (end param) vs. (start param of next non-reduced segment) ?
		 */
		if ((this.sgidx == (mate.sgidx - 1)) &&
		    (this.numer == this.denom) && (mate.numer == 0))
		    return true;

		if ((mate.sgidx == (this.sgidx - 1)) &&
		    (mate.numer == mate.denom) && (this.numer == 0))
		    return true;

	    } else {
		/*
		 * same segment
		 *
		 * same parameter?
		 */
		if (this.denom == mate.denom) {
		    if (this.numer == mate.numer)
			return true;

		} else {
		    int cmn_denom = JgclMath.LCM(this.denom, mate.denom);
		    int a_numer   = this.numer * (cmn_denom / this.denom);
		    int b_numer   = mate.numer * (cmn_denom / mate.denom);

		    if (a_numer == b_numer)
			return true;
		}
	    }

	    return false;
	}
    }

    /**
     * p[^Iɋ`ȋԂ\NXB
     */
    class SegInfo {
	/**
	 * U ̃p[^Ԃ̊JnlB
	 */
	MeshParam u_sp;

	/**
	 * U ̃p[^Ԃ̏IlB
	 */
	MeshParam u_ep;

	/**
	 * V ̃p[^Ԃ̊JnlB
	 */
	MeshParam v_sp;

	/**
	 * V ̃p[^Ԃ̏IlB
	 */
	MeshParam v_ep;

	/**
	 * etB[hɐݒ肷l^ăIuWFNg\zB
	 *
	 * @param u_sp	U ̃p[^Ԃ̊Jnl
	 * @param u_ep	U ̃p[^Ԃ̏Il
	 * @param v_sp	V ̃p[^Ԃ̊Jnl
	 * @param v_ep	V ̃p[^Ԃ̏Il
	 */
	SegInfo(MeshParam u_sp, MeshParam u_ep, MeshParam v_sp, MeshParam v_ep) {
	    super();
	    this.u_sp = u_sp;
	    this.u_ep = u_ep;
	    this.v_sp = v_sp;
	    this.v_ep = v_ep;
	}
    }

    /**
     * p[^l̃Xg\NXB
     * <p>
     * Xg̊evf
     * {@link JgclFreeformSurfaceWithControlPoints3D.MeshParam
     * JgclFreeformSurfaceWithControlPoints3D.MeshParam}
     * ̃CX^Xł̂ƂB
     * </p>
     */
    class GpList {
	/**
	 * p[^l܂ރXgB
	 */
	Vector list;

	/**
	 * ̃XgƂăIuWFNg\zB
	 */
	GpList() {
	    super();
	    this.list = new Vector();
	}

	/**
	 * ̃Xg܂ރp[^l̐ԂB
	 *
	 * @return	Xg̃p[^l̐
	 */
	int size() {
	    return list.size();
	}

	/**
	 * ̃Xg̎ẅʒuɊi[Ăp[^lԂB
	 *
	 * @param index	p[^l̃Xgł̈ʒuCfbNX
	 * @return	ẅʒuɊi[Ăp[^l
	 */
	MeshParam elementAt(int index) {
	    return (MeshParam)list.elementAt(index);
	}

	/**
	 * ^ꂽp[^l̃XgɒǉB
	 * <p>
	 * gp Ɠp[^l\IuWFNgɂ̃Xgɑ݂ꍇɂ́A
	 * ȂB
	 * </p>
	 *
	 * @param gp	Xgɒǉp[^l
	 */
	void addGp(MeshParam gp) {
	    int n_list = size();

	    for (int i = 0; i < n_list; i++)
		if (gp.isSame(elementAt(i)))
		    return;

	    list.addElement(gp);
	    return;
	}
    }

    /**
     * ̋Ȗʂ̎w̋`ԂA
     * ^ꂽxŕʋߎiq_̃p[^l߂B
     *
     * @param si	ʋߎ`
     * @param tol	ʂƌȂ̋e덷
     * @param u_gp_list	iq_ U ̃p[^l̃Xg (o͗p)
     * @param v_gp_list	iq_ V ̃p[^l̃Xg (o͗p)
     * @see	#isPlaner(JgclToleranceForDistance)
     * @see	#divideForMesh(JgclToleranceForDistance)
     * @see	#makeMidGp(JgclFreeformSurfaceWithControlPoints3D.MeshParam, JgclFreeformSurfaceWithControlPoints3D.MeshParam)
     * @see	JgclFreeformSurfaceWithControlPoints3D.GpList#addGp(JgclFreeformSurfaceWithControlPoints3D.MeshParam)
     * @see	#makeParamAndMesh(JgclFreeformSurfaceWithControlPoints3D.GpList, JgclFreeformSurfaceWithControlPoints3D.GpList, double[], double[])
     */
    void getSrfMesh(SegInfo si, JgclToleranceForDistance tol,
		    GpList u_gp_list, GpList v_gp_list) {
	JgclFreeformSurfaceWithControlPoints3D[] divsrf;
	JgclFreeformSurfaceWithControlPoints3D lb_srf, rb_srf, lu_srf, ru_srf;
	SegInfo si_lb, si_rb;
	SegInfo si_lu, si_ru;
	MeshParam u_mp, v_mp;
	int ret_val;

	/*
	 * if the surface is planar, add 4 corners into gp_list and return.
	 */
	if (isPlaner(tol)) {
	    u_gp_list.addGp(si.u_sp);
	    u_gp_list.addGp(si.u_ep);
	    v_gp_list.addGp(si.v_sp);
	    v_gp_list.addGp(si.v_ep);
	    return;
	}

	/*
	 * divide it into 4, and call myself for each.
	 */
	divsrf = divideForMesh(tol);
	lb_srf = divsrf[0];
	rb_srf = divsrf[1];
	lu_srf = divsrf[2];
	ru_srf = divsrf[3];

	if ((lb_srf == null) && (rb_srf == null) &&
	    (lu_srf == null) && (ru_srf == null)) {
	    /*
	     * both of U/V are not divided
	     */
	    u_gp_list.addGp(si.u_sp);
	    u_gp_list.addGp(si.u_ep);
	    v_gp_list.addGp(si.v_sp);
	    v_gp_list.addGp(si.v_ep);
	    return;
	}

	u_mp = makeMidGp(si.u_sp, si.u_ep);
	v_mp = makeMidGp(si.v_sp, si.v_ep);

	if ((lb_srf != null) && (rb_srf != null) &&
	    (lu_srf != null) && (ru_srf != null)) {
	    /*
	     * both of U/V are divided
	     */
	    si_lb = new SegInfo(si.u_sp, u_mp, si.v_sp, v_mp);
	    si_rb = new SegInfo(u_mp, si.u_ep, si.v_sp, v_mp);
	    si_lu = new SegInfo(si.u_sp, u_mp, v_mp, si.v_ep);
	    si_ru = new SegInfo(u_mp, si.u_ep, v_mp, si.v_ep);

	    lb_srf.getSrfMesh(si_lb, tol, u_gp_list, v_gp_list);
	    rb_srf.getSrfMesh(si_rb, tol, u_gp_list, v_gp_list);
	    lu_srf.getSrfMesh(si_lu, tol, u_gp_list, v_gp_list);
	    ru_srf.getSrfMesh(si_ru, tol, u_gp_list, v_gp_list);

	} else if ((lb_srf != null) && (rb_srf == null) &&
		   (lu_srf != null) && (ru_srf == null)) {
	    /*
	     * U is not divided
	     */
	    si_lb = new SegInfo(si.u_sp, si.u_ep, si.v_sp, v_mp);
	    si_lu = new SegInfo(si.u_sp, si.u_ep, v_mp, si.v_ep);

	    lb_srf.getSrfMesh(si_lb, tol, u_gp_list, v_gp_list);
	    lu_srf.getSrfMesh(si_lu, tol, u_gp_list, v_gp_list);

	} else if ((lb_srf != null) && (rb_srf != null) &&
		   (lu_srf == null) && (ru_srf == null)) {
	    /*
	     * V is not divided
	     */
	    si_lb = new SegInfo(si.u_sp, u_mp, si.v_sp, si.v_ep);
	    si_rb = new SegInfo(u_mp, si.u_ep, si.v_sp, si.v_ep);

	    lb_srf.getSrfMesh(si_lb, tol, u_gp_list, v_gp_list);
	    rb_srf.getSrfMesh(si_rb, tol, u_gp_list, v_gp_list);
	}

	return;
    }

    /**
     * ^ꂽ̃p[^l̒_ԂB
     *
     * @param sp	p[^l
     * @param ep	p[^l
     * @return	̃p[^l̒_
     */
    private MeshParam makeMidGp(MeshParam sp, MeshParam ep) {
	MeshParam mp;
	int sgidx, denom, numer;

	sgidx = sp.sgidx; /* == ep->sgidx */

	denom = JgclMath.LCM(sp.denom, ep.denom);
	if ((denom == sp.denom) || (denom == ep.denom))
	    denom *= 2;

	numer = ((sp.numer * (denom / sp.denom)) +
		     (ep.numer * (denom / ep.denom))) / 2;

	return new MeshParam(sgidx, numer, denom);
    }

    /**
     * ^ꂽ_񂪎w̐x̉Œł邩ۂԂB
     * <p>
     * _񂪋łꍇAinfo ̗vfɂ͈ȉӖlB
     * <pre>
     *		info[0] : ̕xNg X 
     *		info[1] : ̕xNg Y 
     *		info[2] : ̕xNg Z 
     *		info[3] : łꂽ_Ԃ̋
     * </pre>
     * ȂAׂĂ̓_ sqrt(tol2) ȓ͈̔͂ɂꍇɂ
     * info[i] (i = 0, 1, 2) ɂ 0 B
     * </p>
     *
     * @param tol2	̋e덷̎l
     * @param pnts	_
     * @param info	vf 4 ̔z (o͗p)
     * @return	ł trueAłȂ false
     * @see	#vIsColinear(JgclPoint3D[][], double)
     * @see	#uIsColinear(JgclPoint3D[][], double)
     */
    private static boolean pointsAreColinear(double tol2,
					     JgclPoint3D[] pnts,
					     double[] info) {
	int npnts = pnts.length;
	int npnts_1 = npnts - 1;
	JgclPoint3D l_pnt;
	JgclVector3D uax;

	JgclVector3D evec, ecrs;
	double length;
	int i;

	if (npnts <= 1) {
	    for (i = 0; i < 4; i++) info[i] = 0.0;
	    return true;
	}

	l_pnt = pnts[0].longestPoint(pnts);
	uax = l_pnt.subtract(pnts[0]);
	if ((length = uax.norm()) < tol2) {
	    /*
	     * points are concurrent
	     */
	    for (i = 0; i < 3; i++) info[i] = 0.0;
	    info[3] = Math.sqrt(length);
	    return true;
	}

	/*
	 *	     + pnts[j]
	 *	    /^
	 *	   / |
	 *      /  | |cross_product((pnts[j] - pnts[0]), uax)|
	 *	 /   v
	 *   -+--------> uax
	 *   pnts[0]
	 */
	length = Math.sqrt(length);
	uax = uax.divide(length);

	for (i = 1; i < npnts; i++) {
	    evec = pnts[i].subtract(pnts[0]);
	    ecrs = evec.crossProduct(uax);
	    if (ecrs.norm() > tol2)
		return false;
	}

	info[0] = uax.x();
	info[1] = uax.y();
	info[2] = uax.z();
	info[3] = length;
	return true;
    }

    /**
     * ^ꂽiq_Q̊es̓_Aw̐x̉
     * ̕ɒɕł邩ۂԂB
     *
     * @param pnts	iq̈ʑ_Q
     * @param tolerance	̋e덷
     * @return	es̓_ɒł trueAłȂ false
     * @see	#pointsAreColinear(double, JgclPoint3D[], double[])
     * @see	#uIsColinear(JgclPoint3D[][], double)
     */
    static boolean vIsColinear(JgclPoint3D[][] pnts,
			       double tolerance) {
	double tol2 = tolerance * tolerance;
	int u_uicp = pnts.length;
	int v_uicp = pnts[0].length;
	double[] info = new double[4];
	JgclVector3D[] dir = new JgclVector3D[2];
	double[] leng = new double[2];
	JgclVector3D[] tgt_vec = new JgclVector3D[2];
	JgclVector3D crs_prod;
	boolean result;
	int u;

	result = true;

	for (u = 0; u < u_uicp; u++) {
	    if (!pointsAreColinear(tol2, pnts[u], info)) {
		result = false;
		break;
	    }
	    dir[1] = new JgclLiteralVector3D(info[0], info[1], info[2]);
	    leng[1] = info[3];
	    if (u == 0) {
		dir[0] = dir[1];
		leng[0] = leng[1];
		tgt_vec[0] = dir[0].multiply(leng[0]);
		continue;
	    }

	    tgt_vec[1] = dir[1].multiply(leng[1]);

	    crs_prod = dir[0].crossProduct(tgt_vec[1]);
	    if (crs_prod.norm() > tol2) {
		result = false;
		break;
	    }

	    crs_prod = dir[1].crossProduct(tgt_vec[0]);
	    if (crs_prod.norm() > tol2) {
		result = false;
		break;
	    }
	}

	return result;
    }

    /**
     * ^ꂽiq_Q̊e̓_Aw̐x̉ŁA
     * ̕ɒɕł邩ۂԂB
     *
     * @param pnts	iq̈ʑ_Q
     * @param tolerance	̋e덷
     * @return	e̓_ɒł trueAłȂ false
     * @see	#pointsAreColinear(double, JgclPoint3D[], double[])
     * @see	#vIsColinear(JgclPoint3D[][], double)
     */
    static boolean uIsColinear(JgclPoint3D[][] pnts,
			       double tolerance) {
	double tol2 = tolerance * tolerance;
	int u_uicp = pnts.length;
	int v_uicp = pnts[0].length;
	JgclPoint3D[] my_pnts = new JgclPoint3D[u_uicp];
	double[] info = new double[4];
	JgclVector3D[] dir = new JgclVector3D[2];
	double[] leng = new double[2];
	JgclVector3D[] tgt_vec = new JgclVector3D[2];
	JgclVector3D crs_prod;
	boolean result;
	int u, v;

	result = true;

	for (v = 0; v < v_uicp; v++) {
	    for (u = 0; u < u_uicp; u++)
		my_pnts[u] = pnts[u][v];
	    if (!pointsAreColinear(tol2, my_pnts, info)) {
		result = false;
		break;
	    }
	    dir[1] = new JgclLiteralVector3D(info[0], info[1], info[2]);
	    leng[1] = info[3];
	    if (v == 0) {
		dir[0] = dir[1];
		leng[0] = leng[1];
		tgt_vec[0] = dir[0].multiply(leng[0]);
		continue;
	    }

	    tgt_vec[1] = dir[1].multiply(leng[1]);

	    crs_prod = dir[0].crossProduct(tgt_vec[1]);
	    if (crs_prod.norm() > tol2) {
		result = false;
		break;
	    }

	    crs_prod = dir[1].crossProduct(tgt_vec[0]);
	    if (crs_prod.norm() > tol2) {
		result = false;
		break;
	    }
	}

	return result;
    }

    /**
     * ̋ȖʂɂāA^ꂽp[^lXg̊ep[^lɑΉ_܂
     * bV𐶐B
     * <p>
     * 郁bV̊e_́A
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D
     * ł邱Ƃ҂łB
     * </p>
     *
     * @param u_gp_list	iq_ U ̃p[^l̃Xg
     * @param v_gp_list	iq_ V ̃p[^l̃Xg
     * @param u_kp	U ̃p[^IɏkނĂȂLȃZOg̃mbg_̔z
     * @param v_kp	V ̃p[^IɏkނĂȂLȃZOg̃mbg_̔z
     * @see	JgclPointOnSurface3D
     * @see	#convGpList2Params(JgclFreeformSurfaceWithControlPoints3D.GpList, double[])
     * @see	#getSrfMesh(JgclFreeformSurfaceWithControlPoints3D.SegInfo, JgclToleranceForDistance, JgclFreeformSurfaceWithControlPoints3D.GpList, JgclFreeformSurfaceWithControlPoints3D.GpList)
     */
    JgclMesh3D makeParamAndMesh(GpList u_gp_list,
				GpList v_gp_list,
				double[] u_kp,
				double[] v_kp) {
	JgclPointOnSurface3D[][] mesh;
	int u_npnts, v_npnts;
	double[] u_params, v_params;
	int i, j;		/* loop counter */

	/*
	 * convert 'MeshParam' into surface's parameter & sort them
	 */
	u_params = convGpList2Params(u_gp_list, u_kp);
	v_params = convGpList2Params(v_gp_list, v_kp);

	/*
	 * get 3D coordinates for each of mesh points
	 */
	u_npnts = u_params.length;
	v_npnts = v_params.length;
	mesh = new JgclPointOnSurface3D[u_npnts][v_npnts];

	for (i = 0; i < u_npnts; i++)
	    for (j = 0; j < v_npnts; j++) {
		try {
		    mesh[i][j] = new JgclPointOnSurface3D(this, u_params[i], v_params[j], doCheckDebug);
		} catch (JgclInvalidArgumentValue e) {
		    throw new JgclFatal();
		}
	    }

	return new JgclMesh3D(mesh, false);
    }

    /**
     * {@link JgclFreeformSurfaceWithControlPoints3D.MeshParam
     * JgclFreeformSurfaceWithControlPoints3D.MeshParam}
     * ̖\[g̃Xguʏ̃p[^lṽ\[gς̔zɕϊB
     *
     * @param gp_list	MeshParam ̃Xg
     * @param kp	p[^IɏkނĂȂLȃZOg̃mbg_̔z
     */
    private static double[] convGpList2Params(GpList gp_list,
					      double[] kp) {
	int n_params;
	double[] params;
	MeshParam gp;
	double lp;

	n_params = gp_list.size();
	params = new double[n_params];

	for (int i = 0; i < n_params; i++) {
	    gp = gp_list.elementAt(i);
	    lp = (double)gp.numer / (double)gp.denom;
	    params[i] = (kp[gp.sgidx] * (1.0 - lp)) + (kp[gp.sgidx + 1] * lp);
	}

	JgclUtil.sortDoubleArray(params, 0, (n_params - 1));

	return params;
    }

    /*
     * ̃CX^X̃tB[hɐ_ݒ肷B
     * <p>
     * ʂƂēz̗vf 2 łB
     * ŏ̗vfɂ U ̐_̐A
     * Ԗڂ̗vfɂ V ̐_̐
     * B
     * </p>
     * <p>
     * ȉ̂ꂩ̏ꍇɂ́AJgclInvalidArgumentValue ̗O𔭐B
     * <ul>
     * <li>	controlPoints  null ł
     * <li>	controlPoints ̒ 2 菬
     * <li>	controlPoints[i] ̒ 2 菬
     * <li>	controlPoints[k]  controlPoints[l] ̒قȂ
     * <li>	controlPoints ̂vf̒l null ł
     * </ul>
     * </p>
     *
     * @param controlPoints	ݒ肷鐧_
     * @return	_̐
     * @see	JgclInvalidArgumentValue
     */
    private int[] setControlPoints(JgclPoint3D[][] controlPoints) {
	int[] npnts = new int[2];

	if (controlPoints == null) {
	    throw new JgclInvalidArgumentValue();
	}
	if ((npnts[0] = controlPoints.length) < 2) {
	    throw new JgclInvalidArgumentValue();
	}
	for (int i = 0; i < npnts[0]; i++) {
	    if (i == 0) {
		if ((npnts[1] = controlPoints[0].length) < 2) {
		    throw new JgclInvalidArgumentValue();
		}
		this.controlPoints = new JgclPoint3D[npnts[0]][npnts[1]];
	    } else {
		if (controlPoints[i].length != npnts[1]) {
		    throw new JgclInvalidArgumentValue();
		}
	    }
	    for (int j = 0; j < npnts[1]; j++) {
		if (controlPoints[i][j] == null) {
		    throw new JgclInvalidArgumentValue();
		}
		this.controlPoints[i][j] = controlPoints[i][j];
	    }
	}
	return npnts;
    }

    /*
     * ̃CX^X̃tB[hɏdݗݒ肷B
     * <p>
     * ȉ̂ꂩ̏ꍇɂ́AJgclInvalidArgumentValue ̗O𔭐B
     * <ul>
     * <li>	weights  null ł
     * <li>	weights ̒ npnts ƈvĂȂ
     * <li>	weights ̂vf̒lłȂ
     * <li>	weights ̂vf̒l w ɂāA
     *		(w / (weights ̍ől))  JgclMachineEpsilon.DOUBLE 菬ȂB
     * </ul>
     * </p>
     *
     * @param npnts	_̐
     * @param weights	ݒ肷dݗ
     * @see	JgclUtil#isDividable(double, double)
     * @see	JgclMachineEpsilon#DOUBLE
     * @see	JgclInvalidArgumentValue
     */
    private void setWeights(int[] npnts,
			    double[][] weights) {
	if (weights == null) {
	    throw new JgclInvalidArgumentValue();
	}
	if (weights.length != npnts[0]) {
	    throw new JgclInvalidArgumentValue();
	}

	double max_weight = 0.0;
	for (int i = 0; i < npnts[0]; i++)
	    for (int j = 0; j < npnts[1]; j++)
		if (weights[i][j] > max_weight)
		    max_weight = weights[i][j];
	if (max_weight <= 0.0)
	    throw new JgclInvalidArgumentValue();

	this.weights = new double[npnts[0]][npnts[1]];
	for (int i = 0; i < npnts[0]; i++) {
	    if (weights[i].length != npnts[1]) {
		throw new JgclInvalidArgumentValue();
	    }
	    for (int j = 0; j < npnts[1]; j++) {
		if (weights[i][j] <= 0.0 || !JgclUtil.isDividable(max_weight, weights[i][j])) {
		    throw new JgclInvalidArgumentValue();
		}
		this.weights[i][j] = weights[i][j];
	    }
	}
    }

    /**
     * ^ꂽ̐_̐i[u̎Ozv̗̈lB
     *
     * @param isPoly	`ۂ
     * @param uSize	z̑ꎟ̗vf (U ̐_̐)
     * @param vSize	z̑񎟌̗vf (V ̐_̐)
     * @return		_̐i[z
     */
    static protected double[][][] allocateDoubleArray(boolean isPoly,
						      int uSize,
						      int vSize) {
	return new double[uSize][vSize][(isPoly) ? 3 : 4];
    }

    /**
     * ̋Ȗʂ̐_ (яd) ̐A^ꂽOz̗vfɑB
     * <p>
     * isPoly  true ̏ꍇA
     * doubleArray[i][j][0]  (i, j) Ԗڂ̐_ X A
     * doubleArray[i][j][1]  (i, j) Ԗڂ̐_ Y 
     * doubleArray[i][j][2]  (i, j) Ԗڂ̐_ Z 
     * \B
     * </p>
     * <p>
     * isPoly  false ̏ꍇA
     * doubleArray[i][j][0]  ((i, j) Ԗڂ̐_ X  * (i, j) Ԗڂ̏d)A
     * doubleArray[i][j][1]  ((i, j) Ԗڂ̐_ Y  * (i, j) Ԗڂ̏d)A
     * doubleArray[i][j][2]  ((i, j) Ԗڂ̐_ Z  * (i, j) Ԗڂ̏d)A
     * doubleArray[i][j][3]  (i, j) Ԗڂ̏d
     * \B
     * </p>
     *
     * @param isPoly	`ۂ
     * @param uUicp	z̑ꎟ̗vf (zɒl U ̐_̐)
     * @param vUicp	z̑񎟌̗vf (zɒl V ̐_̐)
     * @param doubleArray	_̐i[Oz
     */
    protected void setCoordinatesToDoubleArray(boolean isPoly,
					       int uUicp,
					       int vUicp,
					       double[][][] doubleArray) {
	if (isPoly) {
	    for (int i = 0; i < uUicp; i++) {
		for (int j = 0; j < vUicp; j++) {
		    doubleArray[i][j][0] = controlPoints[i][j].x();
		    doubleArray[i][j][1] = controlPoints[i][j].y();
		    doubleArray[i][j][2] = controlPoints[i][j].z();
		}
	    }
	} else {
	    for (int i = 0; i < uUicp; i++) {
		for (int j = 0; j < vUicp; j++) {
		    doubleArray[i][j][0] = controlPoints[i][j].x() * weights[i][j];
		    doubleArray[i][j][1] = controlPoints[i][j].y() * weights[i][j];
		    doubleArray[i][j][2] = controlPoints[i][j].z() * weights[i][j];
		    doubleArray[i][j][3] = weights[i][j];
		}
	    }
	}

    }

    /*
     * ̋Ȗʂ̐_ (яd) ̐܂ށu̎OzvԂB
     * <p>
     * isPoly  true ̏ꍇA
     * ̃\bhԂOz C ̗vf
     * C[i][j][0]  (i, j) Ԗڂ̐_ X A
     * C[i][j][1]  (i, j) Ԗڂ̐_ Y 
     * C[i][j][2]  (i, j) Ԗڂ̐_ Z 
     * \B
     * </p>
     * <p>
     * isPoly  false ̏ꍇA
     * ̃\bhԂOz C ̗vf
     * C[i][j][0]  ((i, j) Ԗڂ̐_ X  * (i, j) Ԗڂ̏d)A
     * C[i][j][1]  ((i, j) Ԗڂ̐_ Y  * (i, j) Ԗڂ̏d)A
     * C[i][j][2]  ((i, j) Ԗڂ̐_ Z  * (i, j) Ԗڂ̏d)A
     * C[i][j][3]  (i, j) Ԗڂ̏d
     * \B
     * </p>
     *
     * @param isPoly	`ۂ
     * @return	_ (яd) ̐܂ޔz
     */
    protected double[][][] toDoubleArray(boolean isPoly) {

	if (controlPointsArray != null) {
	    return controlPointsArray;
	}

	int uUicp = uNControlPoints();
	int vUicp = vNControlPoints();

	controlPointsArray =
	    JgclFreeformSurfaceWithControlPoints3D.allocateDoubleArray(isPoly, uUicp, vUicp);

	setCoordinatesToDoubleArray(isPoly, uUicp, vUicp, controlPointsArray);

	return controlPointsArray;
    }

    /**
     * Wŗ^ꂽ (Ȗʏ) _ X/Y/Z/W ɕϊB
     * <p>
     * (wx, wy, wz, w) ŗ^ꂽ (Ȗʏ) _ (x, y, z, w) ɕϊB
     * </p>
     *
     * @param d0	Ȗʏ̓_
     */
    protected void convRational0Deriv(double[] d0) {
	for (int i = 0; i < 3; i++)
	    d0[i] /= d0[3];
    }

    /**
     * Wŗ^ꂽȖʏ̓_ƈꎟΓ֐ X/Y/Z/W ɕϊB
     * <p>
     * (wx, wy, wz, w) ŗ^ꂽȖʏ̓_ƈꎟΓ֐ (x, y, z, w) ɕϊB
     * </p>
     *
     * @param d0	Ȗʏ̓_
     * @param du	U ̈ꎟΓ֐
     * @param dv	V ̈ꎟΓ֐
     */
    protected void convRational1Deriv(double[] d0, double[] du, double[] dv) {
	convRational0Deriv(d0);
	for (int i = 0; i < 3; i++) {
	    du[i] = (du[i] - (du[3] * d0[i])) / d0[3];
	    dv[i] = (dv[i] - (dv[3] * d0[i])) / d0[3];
	}
    }

    /**
     * Wŗ^ꂽȖʏ̓_/ꎟΓ֐/񎟕Γ֐ X/Y/Z/W ɕϊB
     * <p>
     * (wx, wy, wz, w) ŗ^ꂽȖʏ̓_/ꎟΓ֐/񎟕Γ֐ (x, y, z, w) ɕϊB
     * </p>
     *
     * @param d0	Ȗʏ̓_
     * @param du	U ̈ꎟΓ֐
     * @param dv	V ̈ꎟΓ֐
     * @param duv	U ̓񎟕Γ֐
     * @param duv	UV ̈ꎟΓ֐
     * @param dvv	V ̓񎟕Γ֐
     */
    protected void convRational2Deriv(double[] d0, double[] du, double[] dv,
				      double[] duu, double[] duv, double[] dvv) {
	convRational1Deriv(d0, du, dv);
	for (int i = 0; i < 3; i++) {
	    duu[i] = (duu[i] - (duu[3] * d0[i]) - (2.0 * du[3] * du[i])) / d0[3];
	    duv[i] = (duv[i] - (duv[3] * d0[i]) - (du[3] * dv[i]) - (dv[3] * du[i])) / d0[3];
	    dvv[i] = (dvv[i] - (dvv[3] * d0[i]) - (2.0 * dv[3] * dv[i])) / d0[3];
	}
    }

    /**
     * ̋Ȗʂ̎ԏł̂悻̑ݔ͈͂̂ԂB
     * <p>
     * _܂ޒ̂ԂB
     * </p>
     *
     * @return	Ȗʂ̂悻̑ݔ͈͂
     */
    JgclEnclosingBox3D approximateEnclosingBox() {
	double min_crd_x;
	double min_crd_y;
	double min_crd_z;
	double max_crd_x;
	double max_crd_y;
	double max_crd_z;
	int uN = uNControlPoints();
	int vN = vNControlPoints();
	JgclPoint3D point;
	double x, y, z;
	int i, j;

	point = controlPointAt(0, 0);
	max_crd_x = min_crd_x = point.x();
	max_crd_y = min_crd_y = point.y();
	max_crd_z = min_crd_z = point.z();

	for (i = 1; i < uN; i++) {
	    point = controlPointAt(i, 0);
	    x = point.x();
	    y = point.y();
	    z = point.z();
	    /**/ if (x < min_crd_x) min_crd_x = x;
	    else if (x > max_crd_x) max_crd_x = x;
	    /**/ if (y < min_crd_y) min_crd_y = y;
	    else if (y > max_crd_y) max_crd_y = y;
	    /**/ if (z < min_crd_z) min_crd_z = z;
	    else if (z > max_crd_z) max_crd_z = z;
	}
	for (j = 1; j < vN; j++) {
	    for (i = 0; i < uN; i++) {
		point = controlPointAt(i, j);
		x = point.x();
		y = point.y();
		z = point.z();
		/**/ if (x < min_crd_x) min_crd_x = x;
		else if (x > max_crd_x) max_crd_x = x;
		/**/ if (y < min_crd_y) min_crd_y = y;
		else if (y > max_crd_y) max_crd_y = y;
		/**/ if (z < min_crd_z) min_crd_z = z;
		else if (z > max_crd_z) max_crd_z = z;
	    }
	}
	return new JgclEnclosingBox3D(min_crd_x, min_crd_y, min_crd_z,
				      max_crd_x, max_crd_y, max_crd_z);
    }

    /**
     * ̋Ȗʂ U ̐䑽p`̍ő̒ԂB
     *
     * @return	U ̐䑽p`̍ő̒
     */
    double getMaxLengthOfUControlPolygons(boolean closed) {
	double result;
	double scale;
	int i, j, k;

	result = 0.0;
	for (j = 0; j < vNControlPoints(); j++) {
	    scale = 0.0;
	    for (k = 0, i = 1; i < uNControlPoints(); k++, i++)
		scale += controlPointAt(k, j).distance(controlPointAt(i, j));
	    if (closed == true)
		scale += controlPointAt(k, j).distance(controlPointAt(0, j));

	    if (result < scale)
		result = scale;
	}

	return result;
    }

    /**
     * ̋Ȗʂ V ̐䑽p`̍ő̒ԂB
     *
     * @return	V ̐䑽p`̍ő̒
     */
    double getMaxLengthOfVControlPolygons(boolean closed) {
	double result;
	double scale;
	int i, j, k;

	result = 0.0;
	for (i = 0; i < uNControlPoints(); i++) {
	    scale = 0.0;
	    for (k = 0, j = 1; j < vNControlPoints(); k++, j++)
		scale += controlPointAt(i, k).distance(controlPointAt(i, j));
	    if (closed == true)
		scale += controlPointAt(i, k).distance(controlPointAt(i, 0));

	    if (result < scale)
		result = scale;
	}

	return result;
    }

    /**
     * ̊􉽗vfR`󂩔ۂԂB
     *
     * @return	 true
     */
    public boolean isFreeform() {
	return true;
    }

    /**
     * ̋Ȗʂ̐_̐ɓψȏdݗԂB
     * <p>
     * ʂƂēz̊evf̒l 1 łB
     * </p>
     *
     * @return	d݂̔z
     */
    public double[][] makeUniformWeights() {
	double[][] uniformWeights = new double[this.uNControlPoints()][this.vNControlPoints()];
	for (int ui = 0; ui < this.uNControlPoints(); ui++)
	    for (int vi = 0; vi < this.vNControlPoints(); vi++)
		uniformWeights[ui][vi] = 1.0;
	return uniformWeights;
    }
}
