/*
 * R : tBbgȖʏ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclFilletObject3D.java,v 1.12 2000/04/26 09:38:55 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * R : tBbgȖʏ\NXB
 * <p>
 * ̃NX́A􉽗vfɐڂ~ʂ̋O (tBbgƂ) \B
 * </p>
 * <p>
 * ̃NX̃CX^X
 * <ul>
 * <li> tBbg̒fʂ̗ sections ({@link JgclFilletSection3D JgclFilletSection3D}[])
 * </ul>
 * ێB
 * </p>
 *
 * @version $Revision: 1.12 $, $Date: 2000/04/26 09:38:55 $
 * @author Information-technology Promotion Agency, Japan
 */

public class JgclFilletObject3D extends JgclNonParametricSurface3D {

    /**
     * tBbgfʂ̔zB
     * @serial
     */
    private JgclFilletSection3D[] sections;

    /**
     * tBbgfʂ̔z^ăIuWFNg\zB
     * <p>
     * sections ̗vf 2 菬ꍇɂ
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     * 
     * @param sections tBbgfʂ̔z
     * @see	JgclInvalidArgumentValue
     */
    JgclFilletObject3D(JgclFilletSection3D[] sections) {
	int nSections;

	if ((nSections = sections.length) < 2)
	    throw new JgclInvalidArgumentValue();

	this.sections = new JgclFilletSection3D[nSections];
	for (int i = 0; i < nSections; i++)
	    this.sections[i] = sections[i];
    }
					
    /**
     * ̃tBbg̒fʂ̗ԂB
     * 
     * @return	tBbgfʂ̗
     */
    public JgclFilletSection3D[] sections() {
	JgclFilletSection3D[] copied = new JgclFilletSection3D[nSections()];
	for (int i = 0; i < nSections(); i++)
	    copied[i] = sectionAt(i);
	return copied;
    }

    /**
     * ̃tBbg̒fʂ̐ԂB
     *
     * @return	̃tBbg̒fʂ̐
     */
    public int nSections() {
	return sections.length;
    }

    /**
     * ̃tBbg n Ԃ߂̒fʂԂB
     *
     * @param n	CfbNX
     * @return	n Ԃ߂̒f
     */
    public JgclFilletSection3D sectionAt(int n) {
	return sections[n];
    }

    /**
     * ̃tBbg̊efʂ pointOnGeometry1  pointOnGeometry2 ̂ԂB
     *
     * @return	efʂ pointOnGeometry1  pointOnGeometry2 tBbg
     * @see	JgclFilletSection3D#exchange()
     */
    JgclFilletObject3D exchange() {
	JgclFilletSection3D[] copied = sections();
	for (int i = 0; i < nSections(); i++)
	    copied[i] = copied[i].exchange();
	return new JgclFilletObject3D(copied);
    }

    /**
     * ̃tBbg̒S̋OՂ\ȐԂB
     *
     * @return	S̋OՂ\|C
     */
    public JgclPolyline3D curveOfCenter() {
	JgclPoint3D[] pnts3D = new JgclPoint3D[nSections()];

	for (int i = 0; i < nSections(); i++)
	    pnts3D[i] = sectionAt(i).center();

	return new JgclPolyline3D(pnts3D);
    }

    /**
     * ̃tBbg̊efʂ pointOnGeometry1 ̊􉽗vfȖʂł̂ƂāA
     * ̋Ȗʏ̓_̋OՂ\QȐԂB
     *
     * @return	Ȗʏ̓_̋OՂ\Q̃|C
     */
    public JgclPolyline2D curveOnSurface1() {
	JgclPoint2D[] pnts2D = new JgclPoint2D[nSections()];

	for (int i = 0; i < nSections(); i++) {
	    JgclPointOnSurface3D pnt3D = sectionAt(i).pointOnSurface1();
	    pnts2D[i] = JgclPoint2D.of(pnt3D.uParameter(), pnt3D.vParameter());
	}

	return new JgclPolyline2D(pnts2D);
    }

    /**
     * ̃tBbg̊efʂ pointOnGeometry2 ̊􉽗vfȖʂł̂ƂāA
     * ̋Ȗʏ̓_̋OՂ\QȐԂB
     *
     * @return	Ȗʏ̓_̋OՂ\Q̃|C
     */
    public JgclPolyline2D curveOnSurface2() {
	JgclPoint2D[] pnts2D = new JgclPoint2D[nSections()];

	for (int i = 0; i < nSections(); i++) {
	    JgclPointOnSurface3D pnt3D = sectionAt(i).pointOnSurface2();
	    pnts2D[i] = JgclPoint2D.of(pnt3D.uParameter(), pnt3D.vParameter());
	}

	return new JgclPolyline2D(pnts2D);
    }

    /**
     * ̊􉽗vfR`󂩔ۂԂB
     *
     * @return	 true
     */
    public boolean isFreeform() {
	return true;
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     * @see		JgclGeometry
     */
    protected void output(PrintWriter writer, int indent) {
        String indent_tab = makeIndent(indent);

        writer.println(indent_tab + getClassName());
        writer.println(indent_tab + "\tsections");
	for (int i = 0; i < nSections(); i++) {
	    sectionAt(i).output(writer, indent + 2);
        }
        writer.println(indent_tab + "End");
    }
}

