/*
 * Q Dulaunay }\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclDulaunayDiagram2D.java,v 1.8 2000/04/26 09:38:53 hideit Exp $
 */

package jp.go.ipa.jgcl;

import java.util.*;

/**
 * Q Dulaunay }\NXB
 * <br><br>
 * ̃NX̃CX^X́A
 * Dulaunay }̈ʑێ
 * {@link JgclEmbeddedGraph JgclEmbeddedGraph}
 * ̃CX^X graph B
 * <br><br>
 * graph ̊e_ {@link JgclEmbeddedGraph.Vertex JgclEmbeddedGraph.Vertex}  userData ɂ́A
 * {@link JgclDulaunayDiagram2D.DVertex JgclDulaunayDiagram2D.DVertex} ̃CX^X֘AtB
 * <br><br>
 * lɁA
 * graph ̊e {@link JgclEmbeddedGraph.Face JgclEmbeddedGraph.Face}  userData ɂ́A
 * {@link JgclDulaunayDiagram2D.DFace JgclDulaunayDiagram2D.DFace} ̃CX^X֘AtB
 *
 * @version $Revision: 1.8 $, $Date: 2000/04/26 09:38:53 $
 * @author Information-technology Promotion Agency, Japan
 */
public class JgclDulaunayDiagram2D extends java.lang.Object {
    /**
     * _\NXB
     */
    public class DVertex {
	/*
	 * _̔ԍB
	 */
	private int index;

	/**
	 * _̍WlB
	 */
	private JgclPoint2D coordinates;

	/**
	 * _\_B
	 */
	private JgclEmbeddedGraph.Vertex vrtx;

	/**
	 * [U̗^Cӂ̃f[^B
	 */
	private java.lang.Object userData;

	/**
	 * _̏^ăIuWFNg\zB
	 *
	 * @param index	_̔ԍ
	 * @param coordinates	_̍Wl
	 */
	DVertex(int index,
		JgclPoint2D coordinates) {
	    this.index = index;
	    this.coordinates = coordinates;
	    this.vrtx = null;
	    this.userData = null;
	}

	/**
	 * ̕_̔ԍԂB
	 *
	 * @return	_̔ԍ
	 */
	public int getIndex() {
	    return this.index;
	}

	/**
	 * ̕_̍WlԂB
	 *
	 * @return	_̍Wl
	 */
	public JgclPoint2D getCoordinates() {
	    return this.coordinates;
	}

	/**
	 * ̕_\uOt̒_vݒ肷B
	 *
	 * @param vrtx	Ot̒_
	 */
	void setVertex(JgclEmbeddedGraph.Vertex vrtx) {
	    this.vrtx = vrtx;
	}

	/**
	 * ̕_\ĂuOt̒_vԂB
	 *
	 * @return	Ot̒_
	 */
	public JgclEmbeddedGraph.Vertex getVertex() {
	    return this.vrtx;
	}

	/**
	 * ^ꂽIuWFNgA̕_Ɋ֌Wf[^ƂĐݒ肷B
	 *
	 * @param userData	Cӂ̃IuWFNg
	 */
	public void setUserData(java.lang.Object userData) {
	    this.userData = userData;
	}

	/**
	 * ̕_Ɋ֌Wf[^ƂĐݒ肳ĂIuWFNgԂB
	 *
	 * @return	Cӂ̃IuWFNg
	 */
	public java.lang.Object getUserData() {
	    return this.userData;
	}

	/**
	 * ̕_̎͂̎Op` Enumeration (CCWA) ԂB
	 * <p>
	 * ʂƂē Enumeration ܂ޗvf
	 * {@link JgclDulaunayDiagram2D.DFace JgclDulaunayDiagram2D.DFace}
	 * ̃CX^XłB
	 * </p>
	 *
	 * @return	͂̎Op` Enumeration
	 */
	public Enumeration getDFaceCycleInCCW() {
	    return new Enumeration() {
		Enumeration e = vrtx.getFaceCycleInCCW().elements();

		public boolean hasMoreElements() {
		    return e.hasMoreElements();
		}

		public java.lang.Object nextElement() {
		    return ((JgclEmbeddedGraph.Face)e.nextElement()).getUserData();
		}
	    };
	}

    }

    /**
     * Op`\NXB
     */
    public class DFace {
	/**
	 * Dulaunay }̓̎Op`ł邩ǂB
	 */
	private boolean inner;

	/**
	 * [U̗^Cӂ̃f[^B
	 */
	private java.lang.Object userData;

	/**
	 * IuWFNg\zB
	 *
	 * @param inner	Dulaunay }̖̓ʂł邩ǂ
	 */
	DFace(boolean inner) {
	    this.inner = inner;
	    this.userData = null;
	}

	/**
	 * Dulaunay }̖̓ʂł邩ǂݒ肷B
	 *
	 * @param inner	Dulaunay }̖̓ʂł邩ǂ
	 */
	public void setInner(boolean inner) {
	    this.inner = inner;
	}

	/**
	 * Dulaunay }̖̓ʂł邩ǂԂB
	 *
	 * @return	_̍Wl
	 */
	public boolean isInner() {
	    return this.inner;
	}

	/**
	 * ^ꂽIuWFNgA̎Op`Ɋ֌Wf[^ƂĐݒ肷B
	 *
	 * @param userData	Cӂ̃IuWFNg
	 */
	public void setUserData(java.lang.Object userData) {
	    this.userData = userData;
	}

	/**
	 * ̎Op`Ɋ֌Wf[^ƂĐݒ肳ĂIuWFNgԂB
	 *
	 * @return	Cӂ̃IuWFNg
	 */
	public java.lang.Object getUserData() {
	    return this.userData;
	}
    }

    /**
     * Dulaunay }̈ʑێOtB
     */
    private JgclEmbeddedGraph graph;

    /**
     * _̔zB
     * <p>
     * vertices[i]  i Ԗڂ̕_ɑΉB
     * </p>
     */
    private DVertex[] vertices;

    /**
     * d_̃XgB
     */
    private Vector coincidingVertices;

    /**
     * ^ꂽ Voronoi }oΕϊ Dulaunay }ƂăIuWFNg\zB
     * <p>
     * seed ɂ́A\z΂̋̃Ot^B
     * </p>
     *
     * @param seed	ꂽ Dulaunay }̈ʑێ邽߂̃Ot
     * @param voronoiDiagram	Voronoi }
     */
    public JgclDulaunayDiagram2D(JgclEmbeddedGraph seed,
				 JgclVoronoiDiagram2D voronoiDiagram) {
	super();

	JgclEmbeddedGraph voronoiGraph = voronoiDiagram.getGraph();
	int nFaces = voronoiGraph.getNumberOfFaces();
	int nCcfs  = voronoiDiagram.getNumberOfPairsOfCoincidingRegions();

	/*
	 * CX^X̃tB[hɒlݒ肷
	 */
	this.graph = voronoiGraph.dualCopy(seed);

	this.vertices = new DVertex[nFaces + nCcfs];
	this.coincidingVertices = new Vector();

	/*
	 * VȃOt̒_ɕ_̏
	 */
	for (Enumeration e = this.graph.vertexElements();
	     e.hasMoreElements();) {
	    JgclEmbeddedGraph.Vertex vrtx =
		(JgclEmbeddedGraph.Vertex)e.nextElement();
	    JgclVoronoiDiagram2D.VRegion rgn =
		(JgclVoronoiDiagram2D.VRegion)vrtx.getUserData();

	    if (rgn != null) {
		int index = rgn.getIndex();
		DVertex dvrtx = this.vertices[index] =
		    new DVertex(index, rgn.getCoordinates());
		dvrtx.setVertex(vrtx);
		dvrtx.setUserData(rgn.getUserData());
		vrtx.setUserData(dvrtx);
	    } else {
		vrtx.setUserData(null);
	    }
	}

	/*
	 * VȃOt̖ʂɎOp`̏
	 */
	for (Enumeration e = this.graph.faceElements();
	     e.hasMoreElements();) {
	    JgclEmbeddedGraph.Face face =
		(JgclEmbeddedGraph.Face)e.nextElement();
	    JgclVoronoiDiagram2D.VPoint pnt =
		(JgclVoronoiDiagram2D.VPoint)face.getUserData();

	    DFace dface = new DFace(true);
	    dface.setUserData(pnt.getUserData());
	    face.setUserData(dface);
	}

	/*
	 * VȃOtsvȃGbW폜
	 */
	Vector uselessEdges = new Vector();

	for (Enumeration e = this.graph.edgeElements();
	     e.hasMoreElements();) {
	    JgclEmbeddedGraph.Edge edge =
		(JgclEmbeddedGraph.Edge)e.nextElement();
	    JgclEmbeddedGraph.Vertex[] vrtcs = edge.getVertices();
	    if ((vrtcs[0].getUserData() == null) ||
		(vrtcs[1].getUserData() == null))
		uselessEdges.addElement(edge);
	}

	int n_edges = uselessEdges.size();
	for (int i = 0; i < n_edges; i++) {
	    JgclEmbeddedGraph.Edge edge =
		(JgclEmbeddedGraph.Edge)uselessEdges.elementAt(i);
	    JgclEmbeddedGraph.Face rightFace = edge.getRightFace();
	    if (i != (n_edges - 1)) {
		this.graph.killEdgeFace(edge, rightFace);
	    } else {
		this.graph.killEdgeVertex(edge);
		DFace dface = (DFace)rightFace.getUserData();
		dface.setInner(false);
	    }
	}

	/*
	 * d钸_̏
	 */
	for (Enumeration e = voronoiDiagram.coincidingRegionElements();
	     e.hasMoreElements();) {
	    JgclVoronoiDiagram2D.VRegion rgn = 
		(JgclVoronoiDiagram2D.VRegion)e.nextElement();
	    JgclVoronoiDiagram2D.VRegion mate =
		(JgclVoronoiDiagram2D.VRegion)rgn.getFace().getUserData();

	    int index = rgn.getIndex();
	    DVertex dvrtx = this.vertices[index] =
		new DVertex(index, rgn.getCoordinates());
	    dvrtx.setVertex(this.vertices[mate.getIndex()].getVertex());
	    dvrtx.setUserData(rgn.getUserData());
	    this.coincidingVertices.addElement(dvrtx);
	}
    }

    // I N S T A N C E   M E T H O D S

    /**
     * Dulaunay }̈ʑێOtԂB
     *
     * @return	Dulaunay }̈ʑێOt
     */
    public JgclEmbeddedGraph getGraph() {
	return graph;
    }

    /**
     * d_̑g̐ԂB
     *
     * @return	d_̑g̐
     */
    public int getNumberOfPairsOfCoincidingVertices() {
	return coincidingVertices.size();
    }

    /**
     * d_ Enumeration ԂB
     *
     * @return d_ (JgclDulaunayDiagram2D.DVertex)  Enumeration
     */
    public Enumeration getCoincidingVertexElements() {
	return coincidingVertices.elements();
    }

    /**
     * (d) _ Enumeration ԂB
     *
     * @return _ (JgclDulaunayDiagram2D.DVertex)  Enumeration
     */
    public Enumeration vertexElements() {
	return new Enumeration() {
	    Enumeration e = graph.vertexElements();

	    public boolean hasMoreElements() {
		return e.hasMoreElements();
	    }

	    public java.lang.Object nextElement() {
		return ((JgclEmbeddedGraph.Vertex)e.nextElement()).getUserData();
	    }
	};
    }

    /**
     * Op` Enumeration ԂB
     *
     * @return Op` (JgclDulaunayDiagram2D.DFace)  Enumeration
     */
    public Enumeration faceElements() {
	return new Enumeration() {
	    Enumeration e = graph.faceElements();
	    Object nextNonOuterFace = null;

	    public boolean hasMoreElements() {
		if (nextNonOuterFace != null)
		    return true;

		if (e.hasMoreElements() == false)
		    return false;

		Object obj = e.nextElement();
		DFace dface = (DFace)(((JgclEmbeddedGraph.Face)obj).getUserData());
		if (dface.isInner() == true) {
		    nextNonOuterFace = obj;
		    return true;
		} else {
		    nextNonOuterFace = null;
		    return e.hasMoreElements();
		}
	    }

	    public java.lang.Object nextElement() {
		Object obj;

		if (nextNonOuterFace != null) {
		    obj = nextNonOuterFace;
		    nextNonOuterFace = null;
		    return ((JgclEmbeddedGraph.Face)obj).getUserData();
		}

		obj = e.nextElement();
		DFace dface = (DFace)(((JgclEmbeddedGraph.Face)obj).getUserData());
		if (dface.isInner() == true) {
		    return ((JgclEmbeddedGraph.Face)obj).getUserData();
		} else {
		    return ((JgclEmbeddedGraph.Face)e.nextElement()).getUserData();
		}
	    }
	};
    }

    /**
     * 􉽏폜B
     * <p>
     * _̍Wl^dȂǂ̊􉽏폜A
     *  Dulaunay }̈ʑ񂾂^ߍ݃OtƂĎcB
     * ̃\bhĂяóÃCX^XɃANZX邱Ƃ͂łȂB
     * </p>
     *
     * @return	cʑ
     */
    public JgclEmbeddedGraph stripGeometries() {

	// Ot̒__̏폜
	for (Enumeration e = this.graph.vertexElements();
	     e.hasMoreElements();) {
	    JgclEmbeddedGraph.Vertex vrtx =
		(JgclEmbeddedGraph.Vertex)e.nextElement();
	    DVertex dvrtx = (DVertex)vrtx.getUserData();
	    if (dvrtx != null)
		vrtx.setUserData(dvrtx.getUserData());
	}

	// Ot̖ʂOp`̏폜
	for (Enumeration e = this.graph.faceElements();
	     e.hasMoreElements();) {
	    JgclEmbeddedGraph.Face face =
		(JgclEmbeddedGraph.Face)e.nextElement();
	    DFace dface = (DFace)face.getUserData();
	    if (dface != null)
		face.setUserData(dface.getUserData());
	}

	// _̔z폜
	this.vertices = null;

	// d_̃Xg폜
	this.coincidingVertices = null;

	return this.graph;
    }

    // Main Programs for Debugging
    /**
     * fobOpCvO
     */
    public static void main(String[] args) {
	Vector points = new Vector();

	points.addElement(new JgclCartesianPoint2D(0.0, 0.0));
	points.addElement(new JgclCartesianPoint2D(1.0, 0.0));
	points.addElement(new JgclCartesianPoint2D(1.0, 1.0));
	points.addElement(new JgclCartesianPoint2D(0.0, 1.0));

	JgclVoronoiDiagram2D voronoi =
	    new JgclVoronoiDiagram2D(new JgclEmbeddedGraph(), points.elements());
	JgclDulaunayDiagram2D dulaunay =
	    new JgclDulaunayDiagram2D(new JgclEmbeddedGraph(), voronoi);

	System.out.println("# Vertices");
	for (Enumeration e = dulaunay.vertexElements(); e.hasMoreElements();) {
	    DVertex dvrtx = (DVertex)e.nextElement();
	    int         idx = dvrtx.getIndex();
	    JgclPoint2D crd = dvrtx.getCoordinates();
	    System.out.println("# [" + idx + "] " + crd.x() + ", " + crd.y());

	    for (Enumeration e1 = dvrtx.getDFaceCycleInCCW();
		 e1.hasMoreElements();) {
		DFace dface = (DFace)e1.nextElement();
		if (dface.isInner() == true)
		    System.out.println("#\tface");
		else
		    System.out.println("#\tnull");
	    }

	}

	System.out.println("# Faces");
	int j = 0;
	for (Enumeration e = dulaunay.faceElements(); e.hasMoreElements();) {
	    DFace dface = (DFace)e.nextElement();
	    System.out.println("# [" + j + "] ");
	    j++;
	}

	JgclEmbeddedGraph graph = dulaunay.getGraph();
	int i = 0;

	for (Enumeration e = graph.edgeElements(); e.hasMoreElements();) {
	    JgclEmbeddedGraph.Edge edge = (JgclEmbeddedGraph.Edge)e.nextElement();
	    JgclEmbeddedGraph.Vertex[] vrtcs = edge.getVertices();

	    JgclDulaunayDiagram2D.DVertex vpnt0 =
		(JgclDulaunayDiagram2D.DVertex)vrtcs[0].getUserData();
	    JgclDulaunayDiagram2D.DVertex vpnt1 =
		(JgclDulaunayDiagram2D.DVertex)vrtcs[1].getUserData();

	    JgclPoint2D pnt0 = vpnt0.getCoordinates();
	    JgclPoint2D pnt1 = vpnt1.getCoordinates();

	    System.out.println("JgclLine2D	lin" + i);
	    System.out.println("\tpnt\t" + pnt0.x() + " " + pnt0.y());
	    System.out.println("\tpnt\t" + pnt1.x() + " " + pnt1.y());
	    System.out.println("End");
	    i++;
	}
    }
}

// end of file
