/*
 * R : ȐEȖʂ\NX
 *
 * Copyright 2000 by Information-technology Promotion Agency, Japan
 * Copyright 2000 by Precision Modeling Laboratory, Inc., Tokyo, Japan
 * Copyright 2000 by Software Research Associates, Inc., Tokyo, Japan
 *
 * $Id: JgclCurveBoundedSurface3D.java,v 1.43 2000/08/11 06:18:47 shikano Exp $
 */

package jp.go.ipa.jgcl;

import java.io.PrintWriter;
import java.util.*;

/**
 * R : ȐEȖʂ\NXB
 * <p>
 * ȐEȖʂ́AȖʂ̏̔Cӂ̕Ȑň͂܂ꂽꕔLƂLȖʂłB
 * ꕔLƂ邱Ƃg~OA
 * LƂ镔ȐEƂB
 * </p>
 * <p>
 * ̃NX̃CX^X́A
 * <ul>
 * <li> g~ȎΏۂƂȂȖ basisSurface
 * <li> ŐE (O) Ȑ outerBoundary
 * <li> ̋E (A) Ȑ̃Xg innerBoundaries
 * </ul>
 * ێB
 * </p>
 * <p>
 * <a name="CONSTRAINTS">[Ԃ̍S]</a>
 * </p>
 * <p>
 * Ȗʂ͊J`ł邩A
 * Ȗʂ`̏ꍇɂ
 * Êꂼ͂̃vC}ȗLԂ̓Ɏ܂Ă̂ƂB
 * </p>
 * <p>
 * Ȗʂ́AȐEȖʂł͂Ȃ̂ƂB
 * </p>
 * <p>
 * ȐEȖʂł́A Oтꂼ̓̐isɌčLƂB
 * </p>
 * <p>
 * eÉAR̕`̕Ȑ {@link JgclCompositeCurve3D JgclCompositeCurve3D} 
 * CX^XƂė^̂ƂB
 * ɁAȐ\
 * eZOg {@link JgclCompositeCurveSegment3D JgclCompositeCurveSegment3D}
 * ̕Ȑ́uʏ {@link JgclSurfaceCurve3D JgclSurfaceCurve3D} ȐƂv
 * gȐ {@link JgclTrimmedCurve3D JgclTrimmedCurve3D} ł̂ƂB
 * </p>
 * <p>
 * eÉA݂ɌAȌ肵Ȃ̂ƂB
 * </p>
 * <p>
 * basisSurface  outerBoundary  null łĂ͂ȂȂB
 * innerBoundaries ̗vf̐ 0 ł\ȂB
 * </p>
 *
 * @version $Revision: 1.43 $, $Date: 2000/08/11 06:18:47 $
 * @author Information-technology Promotion Agency, Japan
 */
public class JgclCurveBoundedSurface3D extends JgclBoundedSurface3D {
    /**
     * ȖʁB
     * @serial
     */
    private JgclParametricSurface3D basisSurface;

    /**
     * OB
     * @serial
     */
    private JgclCompositeCurve3D outerBoundary;

    /**
     * ̃XgB
     * <p>
     * evf JgclCompositeCurve3D ł̂ƂB
     * </p>
     * @serial
     */
    private Vector innerBoundaries;

    /**
     * O̕Ȗʂ̃p[^Ԃł̂Q\
     * <p>
     * outerBoundary 萶B
     * </p>
     * @serial
     */
    private JgclCompositeCurve2D outerBoundary2D;

    /**
     * ̕Ȗʂ̃p[^Ԃł̂Q\̃Xg
     * <p>
     * innerBoundaries 萶B
     * </p>
     * @serial
     */
    private Vector innerBoundaries2D;

    /**
     * ÊQԂł̑ݔ͈́B
     * @serial
     */
    private JgclEnclosingBox2D enclosingBox2D;

    /**
     * ̋ȐEȖʂ̕ȖʂԂB
     *
     * @return	Ȗ
     */
    public JgclParametricSurface3D basisSurface() {
	return this.basisSurface;
    }

    /**
     * ̋ȐEȖʂ̊ŐE (O) ԂB
     *
     * @return	ŐE (O)
     */
    public JgclCompositeCurve3D outerBoundary() {
	return this.outerBoundary;
    }

    /**
     * ̋ȐEȖʂ̓̋E () ̐ԂB
     *
     * @return	̋E () ̐
     */
    public int numberOfInnerBoundaries() {
	return this.innerBoundaries.size();
    }

    /**
     * ̋ȐEȖʂ i Ԗڂ̓̋E () ԂB
     *
     * @return	i Ԗڂ̓̋E ()
     */
    public JgclCompositeCurve3D innerBoundary(int i) {
	return (JgclCompositeCurve3D)this.innerBoundaries.elementAt(i);
    }

    /**
     * ̋ȐEȖʂ̊ÔQ\ԂB
     *
     * @return	ÔQ\
     */
    public JgclCompositeCurve2D outerBoundary2D() {
	return this.outerBoundary2D;
    }

    /**
     * ̋ȐEȖʂ i Ԗڂ̓̋E () ̂Q\ԂB
     *
     * @return	i Ԗڂ̓̋E () ̂Q\
     */
    public JgclCompositeCurve2D innerBoundary2D(int i) {
	return (JgclCompositeCurve2D)this.innerBoundaries2D.elementAt(i);
    }

    /**
     * ̋ȐEȖʂ̋ÊQԂł̑ݔ͈͂ԂB
     *
     * @return	ÊQԂł̑ݔ͈
     */
    public JgclEnclosingBox2D enclosingBox2D() {
	return this.enclosingBox2D;
    }

    /**
     * ^ꂽȐA̋ȐEȖʂ̋EƂđÓǂ𒲂ׂB
     *
     * @param compositeCurve	Ȑ
     * @return	^ꂽȐEƂđÓł nullAłȂΖ_wE镶
     */
    private static String
    compositeCurveIsValidForBoundary(JgclCompositeCurve3D compositeCurve,
				     JgclParametricSurface3D basisSurface) {
	/*
	 * OьX̓̍\
	 *
	 * CompositeCurve3D		// ĂȂ΂ȂȂ
	 *     -> CompositeCurveSegment3D[]
	 *       -> TrimmedCurve3D	// SurfaceCurve3D  BoundedCurve3D Ȃ
	 *	   -> SurfaceCurve3D
	 *	     -> ParametricCurve3D
	 *	     -> ParametricCurve2D
	 */
	if (compositeCurve.isClosed() != true)
	    return "A composite curve is not closed";

	for (int i = 0; i < compositeCurve.nSegments(); i++) {
	    JgclCompositeCurveSegment3D segment = compositeCurve.segmentAt(i);

	    // parent should be JgclTrimmedCurve3D
	    JgclTrimmedCurve3D parent;
	    try {
		parent = (JgclTrimmedCurve3D)segment.parentCurve();
	    } catch (ClassCastException exp) {
		return "The parent of a segment is not JgclTrimmedCurve3D";
	    }

	    // basis should be JgclSurfaceCurve3D
	    JgclSurfaceCurve3D basis;
	    try {
		basis = (JgclSurfaceCurve3D)parent.basisCurve();
	    } catch (ClassCastException exp) {
		return "The basis of the parent of a segment is not JgclSurfaceCurve3D";
	    }

	    if (basis.basisSurface() != basisSurface)
		return "The basis surface of a segment is not same as given surface";
	}

	return null;
    }

    /**
     * R̕ȐƂė^ꂽE̊eZOgɊ܂܂Q񂩂
     * Q̕Ȑ𐶐B
     *
     * @param boundary3D	E
     * @return	E\Q̕Ȑ
     */
    private static JgclCompositeCurve2D make2DCurve(JgclCompositeCurve3D boundary3D) {
	int nSegments = boundary3D.nSegments();
	JgclBoundedCurve2D[] segments2D = new JgclBoundedCurve2D[nSegments];
	boolean[] senses2D = new boolean[nSegments];

	for (int i = 0; i < nSegments; i++) {
	    JgclCompositeCurveSegment3D segment = boundary3D.segmentAt(i);
	    JgclTrimmedCurve3D parent = (JgclTrimmedCurve3D)segment.parentCurve();
	    JgclSurfaceCurve3D basis = (JgclSurfaceCurve3D)parent.basisCurve();

	    segments2D[i] = new JgclTrimmedCurve2D(basis.curve2d(), 
						   parent.tParam1(),
						   parent.tParam2(),
						   parent.senseAgreement());
	    senses2D[i] = segment.sameSense();
	}

	return new JgclCompositeCurve2D(segments2D, senses2D);
    }

    /**
     * ̋ȐEȖʂ̋E̕Ȗʂ̃p[^Ԃɂ鑶ݔ͈͂߂B
     * <p>
     * ߂ݔ͈͂́ÃCX^X
     * {@ #enclosingBox2D enclosingBox2D} tB[h
     * ɐݒ肷B
     * </p>
     */
    private void makeEnclosingBox2D() {
	JgclEnclosingBox2D box;
	JgclPoint2D[] points =
	    new JgclPoint2D[(this.innerBoundaries2D.size() + 1) * 2];

	JgclToleranceForDistance tolD =
	    this.getToleranceForDistanceAsObject();

	box = this.outerBoundary2D.toPolyline(tolD).enclosingBox();
	points[0] = box.min();
	points[1] = box.max();

	for (int i = 0; i < this.innerBoundaries2D.size(); i++) {
	    JgclCompositeCurve2D inner =
		(JgclCompositeCurve2D)this.innerBoundaries2D.elementAt(i);
	    box = inner.toPolyline(tolD).enclosingBox();
	    points[(i + 1) * 2]     = box.min();
	    points[(i + 1) * 2 + 1] = box.max();
	}

	this.enclosingBox2D = new JgclEnclosingBox2D(points);
    }

    /**
     * ȖʁAOƓ̃Xg^ăIuWFNg\zB
     * <p>
     * ̒l <a href="#CONSTRAINTS">[Ԃ̍S]</a> 𖞂Ȃꍇɂ́A
     * JgclInvalidArgumentValue ̗O𔭐B
     * </p>
     *
     * @param basisSurface	Ȗ
     * @param outerBoundary	O
     * @param innerBoundaries	̃Xg
     * @see	JgclInvalidArgumentValue
     */
    public JgclCurveBoundedSurface3D(JgclParametricSurface3D basisSurface,
				     JgclCompositeCurve3D outerBoundary,
				     Vector innerBoundaries) {
	// Ȗʂ̒`
	if (basisSurface.type() == CURVE_BOUNDED_SURFACE_3D)
	    throw new JgclInvalidArgumentValue("The basis surface is JgclCurveBoundedSurface3D");
	this.basisSurface = basisSurface;

	// O̒`
	String message;

	if ((message = compositeCurveIsValidForBoundary(outerBoundary,
							basisSurface)) != null)
	    throw new JgclInvalidArgumentValue(message);
	this.outerBoundary = outerBoundary;
	this.outerBoundary2D = make2DCurve(outerBoundary);

	// ̒`
	this.innerBoundaries = new Vector();
	this.innerBoundaries2D = new Vector();

	if (innerBoundaries != null) {
	    for (Enumeration e = innerBoundaries.elements();
		 e.hasMoreElements();) {
		try {
		    JgclCompositeCurve3D inner =
			(JgclCompositeCurve3D)e.nextElement();
		    if ((message = compositeCurveIsValidForBoundary(inner,
								    basisSurface)) != null)
			throw new JgclInvalidArgumentValue(message);
		    this.innerBoundaries.addElement(inner);
		    this.innerBoundaries2D.addElement(make2DCurve(inner));
		} catch (ClassCastException exp) {
		    throw new JgclInvalidArgumentValue("An inner boundary is not JgclCompositeCurve3D");
		}
	    }
	}

	// Ȇݔ͈͂߂
	makeEnclosingBox2D();
    }

    /**
     * ̋Ȗʂ U ̃p[^`ԂB
     * <p>
     * ȐEȖʂ̃p[^`͈ʂɋ`ł͂Ȃ̂ŁA
     * Ȗʂ`̃p[^`ƂOƂ̃\bh͗_IɈӖȂB
     * āA܂̂ƂA
     * JgclImproperOperation ̗O𔭐B
     * </p>
     * 
     * @return	U ̃p[^`
     * @see	JgclImproperOperation
     */
    JgclParameterDomain getUParameterDomain()
    {
	throw new JgclImproperOperation();	// getUParameterDomain
    }

    /**
     * ̋Ȗʂ V ̃p[^`ԂB
     * <p>
     * ȐEȖʂ̃p[^`͈ʂɋ`ł͂Ȃ̂ŁA
     * Ȗʂ`̃p[^`ƂOƂ̃\bh͗_IɈӖȂB
     * āA܂̂ƂA
     * JgclImproperOperation ̗O𔭐B
     * </p>
     * 
     * @return	V ̃p[^`
     * @see	JgclImproperOperation
     */
    JgclParameterDomain getVParameterDomain()
    {
	throw new JgclImproperOperation();	// getVParameterDomain
    }

    /**
     * vfʂԂB
     *
     * @return	{@link JgclParametricSurface3D#CURVE_BOUNDED_SURFACE_3D JgclParametricSurface3D.CURVE_BOUNDED_SURFACE_3D}
     */
    int type()
    {
	return CURVE_BOUNDED_SURFACE_3D;
    }

    /**
     * ̊􉽗vfR`󂩔ۂԂB
     *
     * @return	ȖʂR`ł trueAłȂ false
     */
    public boolean isFreeform() {
	return this.basisSurface.isFreeform();
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̍WlԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param uParam	U ̃p[^l
     * @param vParam	V ̃p[^l
     * @return		Wl
     * @see	JgclParameterOutOfRange
     */
    public JgclPoint3D coordinates(double uParam,
				   double vParam)
    {
	if (this.contains(uParam, vParam) != true)
	    throw new JgclParameterOutOfRange();

	return this.basisSurface.coordinates(uParam, vParam);
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̐ڃxNgԂB
     * <p>
     * ł̐ڃxNgƂ́Ap[^ U/V ̊eXɂĂ̈ꎟΓ֐łB
     * </p>
     * <p>
     * ʂƂĕԂz̗vf 2 łB
     * z̍ŏ̗vfɂ U p[^ɂĂ̐ڃxNgA
     * Ԗڂ̗vfɂ V p[^ɂĂ̐ڃxNg܂ށB
     * </p>
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param	uParam	U ̃p[^l
     * @param	vParam	V ̃p[^l
     * @return		ڃxNg
     * @see	JgclParameterOutOfRange
     */
    public JgclVector3D[] tangentVector(double uParam,
					double vParam)
    {
	if (this.contains(uParam, vParam) != true)
	    throw new JgclParameterOutOfRange();

	return this.basisSurface.tangentVector(uParam, vParam);
    }

    /**
     * ̋Ȗʂ́A^ꂽp[^lł̕Γ֐ԂB
     * <p>
     * ^ꂽp[^l`OĂꍇɂ́A
     * JgclParameterOutOfRange ̗O𔭐B
     * </p>
     * 
     * @param uParam	U ̃p[^l
     * @param vParam	V ̃p[^l
     * @return		Γ֐
     * @see	JgclParameterOutOfRange
     */
    public JgclSurfaceDerivative3D evaluation(double uParam,
					      double vParam)
    {
	if (this.contains(uParam, vParam) != true)
	    throw new JgclParameterOutOfRange();

	return this.basisSurface.evaluation(uParam, vParam);
    }

    /**
     * ^ꂽ_炱̋Ȗʂւ̓e_߂B
     * <p>
     * e_݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ^ꂽ_炱̋Ȗʂ̕Ȗʂւ̓e_߁A
     * ̓ł̋Ȗʂ̗L̈OĂȂ̂̋Ȗʂւ̓e_ƂĂB
     * </p>
     * 
     * @param point	e̓_
     * @return		e_̔z
     * @exception JgclIndefiniteSolution	sł
     */
    public JgclPointOnSurface3D[] projectFrom(JgclPoint3D point)
	 throws JgclIndefiniteSolution
    {
	JgclPointOnSurface3D[] pointsOnBasisSurface =
	    this.basisSurface.projectFrom(point);

	if (pointsOnBasisSurface == null)
	    return new JgclPointOnSurface3D[0];

	if (pointsOnBasisSurface.length == 0)
	    return pointsOnBasisSurface;

	Vector innerPoints = new Vector();
	JgclPointOnSurface3D pos;

	for (int i = 0; i < pointsOnBasisSurface.length; i++) {
	    double uParam =
		basisSurface.uParameterDomain().wrap(pointsOnBasisSurface[i].uParameter());
	    double vParam =
		basisSurface.vParameterDomain().wrap(pointsOnBasisSurface[i].vParameter());
	    JgclPoint2D point2D = JgclPoint2D.of(uParam, vParam);
	    if (this.contains(point2D) == true) {
		pos = new JgclPointOnSurface3D(this, uParam, vParam, doCheckDebug);
		innerPoints.addElement(pos);
	    }
	}

	JgclPointOnSurface3D[] results =
	    new JgclPointOnSurface3D[innerPoints.size()];
	innerPoints.copyInto(results);
	return results;
    }

    /**
     *  (`̃p[^`) LȖʑŜA^ꂽ덷ŕʋߎ
     * iq_QԂB
     * <p>
     * ʂƂĕԂiq_Q\_́A
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D 
     * 邱Ƃ҂łB
     * </p>
     * <p>
     * ȐEȖʂ̃p[^`͈ʂɋ`ł͂Ȃ̂ŁA
     * Ȗʂ`̃p[^`ƂOƂ̃\bh͗_IɈӖȂB
     * āA܂̂ƂA
     * JgclImproperOperation ̗O𔭐B
     * </p>
     * 
     * @param tol	̋e덷
     * @return		̗LȖʑŜ𕽖ʋߎiq_Q
     * @see		JgclPointOnSurface3D
     * @see	JgclImproperOperation
     */
    public JgclMesh3D toMesh(JgclToleranceForDistance tol)
    {
	throw new JgclImproperOperation();	// toMesh
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂA^ꂽ덷ŕʋߎ
     * iq_QԂB
     * <p>
     * ʂƂĕԂiq_Q\_́A
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D 
     * 邱Ƃ҂łB
     * </p>
     * <p>
     * ȐEȖʂ̃p[^`͈ʂɋ`ł͂Ȃ̂ŁA
     * Ȗʂ`̃p[^`ƂOƂ̃\bh͗_IɈӖȂB
     * āA܂̂ƂA
     * JgclImproperOperation ̗O𔭐B
     * </p>
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @param tol	̋e덷
     * @return		̋Ȗʂ̎w̋Ԃ𕽖ʋߎiq_Q
     * @see	JgclPointOnSurface3D
     * @see	JgclImproperOperation
     */
    public JgclMesh3D toMesh(JgclParameterSection uPint,
			     JgclParameterSection vPint,
			     JgclToleranceForDistance tol)
    {
	throw new JgclImproperOperation();	// toMesh
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂɍČ
     * L Bspline ȖʂԂB
     * <p>
     * ȐEȖʂ̃p[^`͈ʂɋ`ł͂Ȃ̂ŁA
     * Ȗʂ`̃p[^`ƂOƂ̃\bh͗_IɈӖȂB
     * āA܂̂ƂA
     * JgclImproperOperation ̗O𔭐B
     * </p>
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @return		̋Ȗʂ̎w̋ԂČL Bspline Ȗ
     * @see	JgclImproperOperation
     */
    public JgclBsplineSurface3D toBsplineSurface(JgclParameterSection uPint,
						 JgclParameterSection vPint)
    {
	throw new JgclImproperOperation();	// toBsplineSurface
    }

    /**
     * ̋ȖʂƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̋Ȗʂ̕ȖʂƑ̋ȐƂ̌_߁A
     * ̓ł̋Ȗʂ̗L̈OĂȂ̂̋ȖʂƑ̋Ȑ̌_ƂĂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @return		_̔z
     * @exception JgclIndefiniteSolution	sł
     */
    public JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate)
	throws JgclIndefiniteSolution
    {
	JgclIntersectionPoint3D[] results = this.basisSurface.intersect(mate);

	return this.selectInternalIntersections(results, false);
    }

    /**
     * ̋ȖʂƑ̋Ȑ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̋Ȗʂ̕ȖʂƑ̋ȐƂ̌_߁A
     * ̓ł̋Ȗʂ̗L̈OĂȂ̂̋ȖʂƑ̋Ȑ̌_ƂĂB
     * </p>
     * 
     * @param mate	̋Ȑ
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception JgclIndefiniteSolution	sł
     */
    JgclIntersectionPoint3D[] intersect(JgclParametricCurve3D mate, boolean doExchange)
	throws JgclIndefiniteSolution
    {
	JgclIntersectionPoint3D[] results = this.basisSurface.intersect(mate);

	return this.selectInternalIntersections(results, doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȑ () ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̋Ȗʂ̕ȖʂƑ̋ȐƂ̌_߁A
     * ̓ł̋Ȗʂ̗L̈OĂȂ̂̋ȖʂƑ̋Ȑ̌_ƂĂB
     * </p>
     * 
     * @param mate	̋Ȑ ()
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception JgclIndefiniteSolution	sł
     */
    JgclIntersectionPoint3D[] intersect(JgclLine3D mate, boolean doExchange)
	throws JgclIndefiniteSolution
    {
	JgclIntersectionPoint3D[] results = this.basisSurface.intersect(mate, doExchange);
	return this.selectInternalIntersections(results, doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȑ (~Ȑ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̋Ȗʂ̕ȖʂƑ̋ȐƂ̌_߁A
     * ̓ł̋Ȗʂ̗L̈OĂȂ̂̋ȖʂƑ̋Ȑ̌_ƂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (~Ȑ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception JgclIndefiniteSolution	sł
     */
    JgclIntersectionPoint3D[] intersect(JgclConic3D mate,
					boolean doExchange)
	 throws JgclIndefiniteSolution
    {
	JgclIntersectionPoint3D[] results = this.basisSurface.intersect(mate, doExchange);
	return this.selectInternalIntersections(results, doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȑ (xWGȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̋Ȗʂ̕ȖʂƑ̋ȐƂ̌_߁A
     * ̓ł̋Ȗʂ̗L̈OĂȂ̂̋ȖʂƑ̋Ȑ̌_ƂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (xWGȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception JgclIndefiniteSolution	sł
     */
    JgclIntersectionPoint3D[] intersect(JgclPureBezierCurve3D mate, boolean doExchange)
	throws JgclIndefiniteSolution
    {
	JgclIntersectionPoint3D[] results = this.basisSurface.intersect(mate, doExchange);
	return this.selectInternalIntersections(results, doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȑ (aXvCȐ) ̌_߂B
     * <p>
     * _݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̋Ȗʂ̕ȖʂƑ̋ȐƂ̌_߁A
     * ̓ł̋Ȗʂ̗L̈OĂȂ̂̋ȖʂƑ̋Ȑ̌_ƂĂB
     * </p>
     * 
     * @param mate	̋Ȑ (aXvCȐ)
     * @param doExchange	_ pointOnGeometry1/2 邩ǂ
     * @return		_̔z
     * @exception JgclIndefiniteSolution	sł
     */
    JgclIntersectionPoint3D[] intersect(JgclBsplineCurve3D mate, boolean doExchange)
	throws JgclIndefiniteSolution
    {
	JgclIntersectionPoint3D[] results = this.basisSurface.intersect(mate, doExchange);
	return this.selectInternalIntersections(results, doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗʂ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ȖʂӏɂẮA (JgclIntersectionCurve3D) ԂB
     * </p>
     * <p>
     * ȖʂڂӏɂẮA_ (JgclIntersectionPoint3D) Ԃ邱ƂB
     * </p>
     * 
     * @param mate	̋Ȗ
     * @return		 (܂͌_) ̔z
     * @see		JgclIntersectionCurve3D
     * @see		JgclIntersectionPoint3D
     * @exception JgclIndefiniteSolution	sł
     */
    public JgclSurfaceSurfaceInterference3D[] intersect(JgclParametricSurface3D mate)
	 throws JgclIndefiniteSolution
    {
	JgclSurfaceSurfaceInterference3D[] results;
	int basisType = this.basisSurface.type();
	if ((basisType == JgclParametricSurface3D.SURFACE_OF_LINEAR_EXTRUSION_3D) ||
	    (basisType == JgclParametricSurface3D.SURFACE_OF_REVOLUTION_3D)) {
	    JgclPoint2D[] minMax = this.enclosingBox2D.toArray();
	    JgclParameterSection uPint =
		new JgclParameterSection(minMax[0].x(), (minMax[1].x() - minMax[0].x()));
	    JgclParameterSection vPint =
		new JgclParameterSection(minMax[0].y(), (minMax[1].y() - minMax[0].y()));
	    results = ((JgclSweptSurface3D)this.basisSurface).intersect(uPint, vPint, mate);
	} else {
	    results = this.basisSurface.intersect(mate);
	}

	return this.trimIntersectionsWithBoundaries(mate, results, false);
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂItZbgȖʂ
     * ^ꂽ덷ŋߎ Bspline Ȗʂ߂B
     * <p>
     * ȐEȖʂ̃p[^`͈ʂɋ`ł͂Ȃ̂ŁA
     * Ȗʂ`̃p[^`ƂOƂ̃\bh͗_IɈӖȂB
     * āA܂̂ƂA
     * JgclImproperOperation ̗O𔭐B
     * </p>
     * 
     * @param uPint	U ̃p[^
     * @param vPint	V ̃p[^
     * @param magni	ItZbg
     * @param side      ItZbǧ (JgclWhichSide.FRONT/BACK)
     * @param tol     	̋e덷
     * @return		̋Ȗʂ̎w̋`Ԃ̃ItZbgȖʂߎ Bspline Ȗ
     * @see	JgclWhichSide
     * @see	JgclImproperOperation
     */
    public JgclBsplineSurface3D offsetByBsplineSurface(JgclParameterSection uPint,
						       JgclParameterSection vPint,
						       double magni,
						       int side,
						       JgclToleranceForDistance tol)
    {
	throw new JgclImproperOperation();	// offsetByBsplineSurface
    }

    /**
     * tBbgw̃p[^ԂŃg~OB
     *
     * @param mate	̋Ȗ
     * @param radius	tBbg̔a
     * @param fllt3	tBbg̒S̋O
     * @param flltT	tBbĝ̋Ȗʂ̕ȖʂƂ̐ڐG_̋O
     * @param flltM	tBbg̑̋ȖʂƂ̐ڐG_̋O
     * @param isOpenT	g~OtBbg this ̕\JĂ邩ۂ
     * @param sectionOfFlltT	flltT ̃p[^`̋
     * @param crossBoundary	g~OԂ (RIɕ) tBbgׂ̎ۂ
     * @param spT	g~O̊Jnp[^l (this ̕\̃p[^l)
     * @param ipT	g~Ȏp[^l (this ̕\̃p[^l)
     * @return	g~ÕtBbg
     * @see	#wrapParameterIntoOpenSection(double, JgclParameterSection)
     */
    private JgclFilletObject3D
    trimFillet(JgclBoundedSurface3D mate,
	       double radius, 
	       JgclPolyline3D fllt3,
	       JgclPolyline2D flltT,
	       JgclPolyline2D flltM,
	       boolean isOpenT,
	       JgclParameterSection sectionOfFlltT,
	       boolean crossBoundary,
	       double spT,
	       double ipT) {
	double epT = spT + ipT;

	if ((crossBoundary == true) && (isOpenT == true)) {
	    spT = wrapParameterIntoOpenSection(spT, sectionOfFlltT);
	    epT = wrapParameterIntoOpenSection(epT, sectionOfFlltT);
	}

	JgclParameterSection pint = new JgclParameterSection(spT, (epT - spT));
	JgclToleranceForDistance tolD = this.getToleranceForDistanceAsObject();

	JgclPolyline3D curve3 = fllt3.toPolyline(pint, tolD);
	JgclPolyline2D curveT = flltT.toPolyline(pint, tolD);
	JgclPolyline2D curveM = flltM.toPolyline(pint, tolD);

	JgclFilletSection3D[] sections = new JgclFilletSection3D[curve3.nPoints()];

	for (int i = 0; i < curve3.nPoints(); i++) {
	    JgclPointOnGeometry3D pogT = new JgclPointOnSurface3D(this, curveT.pointAt(i), doCheckDebug);
	    JgclPointOnGeometry3D pogM = new JgclPointOnSurface3D(mate, curveM.pointAt(i), doCheckDebug);
	    sections[i] = new JgclFilletSection3D(radius, curve3.pointAt(i), pogT, pogM);
	}

	return new JgclFilletObject3D(sections);
    }

    /**
     * ̋Ȗʂ̕ȖʂƑ̋Ȗʂ̃tBbgA
     * ̋Ȗʂ̋EŃg~OB
     * <p>
     * ^ꂽtBbgɂāA̋Ȗʂ̋E̓ɂ镔tBbgƂĕԂB
     * </p>
     *
     * @param mate	̋Ȗ
     * @param fillets	ȖʂƂ̃tBbgZœꂽtBbg
     * @return	̋Ȗʂ̋EŃg~OtBbg̔z
     * @see	#getIntersectionsWithBoundary(JgclCompositeCurve2D, JgclParametricCurve2D)
     * @see	JgclCurveBoundedSurface3D.IntersectionWithBoundaryInfo
     * @see	#containsWithWrapping(JgclPoint2D)
     * @see	#trimFillet(JgclBoundedSurface3D, double, JgclPolyline3D, JgclPolyline2D, JgclPolyline2D, boolean, JgclParameterSection, boolean, double, double)
     */
    JgclFilletObject3D[]
    trimFilletsWithBoundaries(JgclBoundedSurface3D mate,
			      double radius,
			      JgclFilletObject3D[] fillets)
    {
	Vector results = new Vector();

	// final ł̂́AiwbiBothEnds  comparator QƂ邽
	final IntersectionWithBoundaryInfo[] iwbiBothEnds =
	    new IntersectionWithBoundaryInfo[2];

	// EƂ̌_́u傫ṽp[^lŔfIuWFNg
	JgclListSorter.ObjectComparator comparator =
	    new JgclListSorter.ObjectComparator() {
	    public boolean latterIsGreaterThanFormer(java.lang.Object former,
						     java.lang.Object latter) {
		IntersectionWithBoundaryInfo f = (IntersectionWithBoundaryInfo)former;
		IntersectionWithBoundaryInfo l = (IntersectionWithBoundaryInfo)latter;
		if (f == l)
		    return false;

		if ((f == iwbiBothEnds[0]) || (l == iwbiBothEnds[1]))
		    return true;

		if ((l == iwbiBothEnds[0]) || (f == iwbiBothEnds[1]))
		    return false;

		return (f.curveParameter < l.curveParameter) ? true : false;
	    }
	};

	/*
	 * tBbĝꂼɂ
	 */
	for (int i = 0; i < fillets.length; i++) {
	    JgclFilletObject3D theFillet = fillets[i];

	    /*
	     * Ȗʏ̃p[^Ȑ𓾂
	     */
	    JgclPolyline3D fllt3 = theFillet.curveOfCenter();
	    JgclPolyline2D flltT = theFillet.curveOnSurface1();
	    JgclPolyline2D flltM = theFillet.curveOnSurface2();

	    boolean isOpen3 = true;	// !!!
	    boolean isOpenT = true;	// !!!
	    boolean isOpenM = true;	// !!!

	    JgclParameterDomain domainOfFlltT = flltT.parameterDomain();
	    JgclParameterSection sectionOfFlltT = domainOfFlltT.section();

	    /*
	     * EƂ̌_𓾂
	     */
	    Vector listOfIntersectionsWithBoundaries = new Vector();

	    for (int j = - 1; j < this.innerBoundaries2D.size(); j++) {
		JgclCompositeCurve2D aBoundary;

		if (j == - 1)
		    aBoundary = this.outerBoundary2D;
		else
		    aBoundary =
			(JgclCompositeCurve2D)this.innerBoundaries2D.elementAt(j);

		JgclIntersectionPoint2D[] intsWithBoundary =
		    getIntersectionsWithBoundary(aBoundary, flltT);

		for (int k = 0; k < intsWithBoundary.length; k++) {
		    IntersectionWithBoundaryInfo iwbi =
			new IntersectionWithBoundaryInfo(j,
			 intsWithBoundary[k].pointOnCurve1().parameter(),
			 intsWithBoundary[k].pointOnCurve2().parameter());
		    listOfIntersectionsWithBoundaries.addElement(iwbi);
		}
	    }

	    /*
	     * _̐𐮂
	     */
	    iwbiBothEnds[0] = null;
	    iwbiBothEnds[1] = null;
	    boolean addEndPoints = false;

	    if (isOpen3 == true) {
		/*
		 * JĂȂ΁A̗[EƂ̌_ɉ
		 */
		if (flltT.isFinite() == true) {
		    iwbiBothEnds[0] =
			new IntersectionWithBoundaryInfo(-100, 0.0,
			sectionOfFlltT.start());
		    iwbiBothEnds[1] =
			new IntersectionWithBoundaryInfo(-100, 0.0,
			sectionOfFlltT.end());

		    listOfIntersectionsWithBoundaries.addElement(iwbiBothEnds[0]);
		    listOfIntersectionsWithBoundaries.addElement(iwbiBothEnds[1]);
		    addEndPoints = true;
		}
	    } else if (listOfIntersectionsWithBoundaries.size() == 1) {
		/*
		 * ĂāAEƂ̌_Ȃ΁A
		 * ̌_Ⴄ_Ƃĉ
		 */
		IntersectionWithBoundaryInfo iwbi =
		    (IntersectionWithBoundaryInfo)listOfIntersectionsWithBoundaries.elementAt(0);
		IntersectionWithBoundaryInfo iwbi2 =
		    new IntersectionWithBoundaryInfo(iwbi.boundaryIndex,
						     iwbi.boundaryParameter,
						     iwbi.curveParameter);
		listOfIntersectionsWithBoundaries.addElement(iwbi2);
	    }

	    /*
	     * EƂ̌_ȂꍇA
	     * ̂_ (Jn_) E̓ɂ΁A
	     * ̌̂܂܁uo͂̃Xgvɉ
	     */
	    if (listOfIntersectionsWithBoundaries.size() == 0) {
		double aParameter = (flltT.isFinite() == true) ?
		    sectionOfFlltT.start() : 0.0;
		if (this.containsWithWrapping(flltT.coordinates(aParameter)) == true) {
		    results.addElement(theFillet);
		}
		continue;
	    }

	    /*
	     * ȉAEƂ̌_ꍇ
	     */

	    /*
	     * EƂ̌_̃p[^lŃ\[g
	     */
	    JgclListSorter.doSorting(listOfIntersectionsWithBoundaries, comparator);

	    int nIntervals = listOfIntersectionsWithBoundaries.size() - 1;

	    /*
	     * ׂ荇uEƂ̌_v̒_E̓ɂ΁A
	     * ̋ԂĉƂ
	     */
	    Vector listOfTrimmingIntervals = new Vector();
	    TrimmingInterval trimmingInterval = null;

	    int sIdx;
	    int eIdx;
	    IntersectionWithBoundaryInfo sIwb;
	    IntersectionWithBoundaryInfo eIwb;

	    double sp;
	    double ip;
	    double mp;

	    boolean crossBoundary;

	    sIdx = 0;
	    sIwb = (IntersectionWithBoundaryInfo)
		listOfIntersectionsWithBoundaries.elementAt(0);

	    for (int j = 1; j <= nIntervals; j++) {
		sp = sIwb.curveParameter;
		if ((isOpen3 == true) || (j < nIntervals)) {
		    eIdx = j;
		    eIwb = (IntersectionWithBoundaryInfo)
			listOfIntersectionsWithBoundaries.elementAt(j);
		    crossBoundary = false;
		    ip = eIwb.curveParameter - sIwb.curveParameter;

		    if (((sIwb == iwbiBothEnds[0]) ||
			 (eIwb == iwbiBothEnds[1])) &&
			(Math.abs(ip) < getToleranceForParameter())) {
			sIdx = eIdx;
			sIwb = eIwb;
			continue;
		    }
		} else {
		    eIdx = 0;
		    eIwb = (IntersectionWithBoundaryInfo)
			listOfIntersectionsWithBoundaries.elementAt(0);
		    crossBoundary = true;
		    ip = eIwb.curveParameter - sIwb.curveParameter +
			sectionOfFlltT.increase();

		    if (Math.abs(ip) < getToleranceForParameter()) {
			// no cross boundary
			sIdx = eIdx;
			sIwb = eIwb;
			continue;
		    }
		}

		mp = sp + (ip / 2.0);

		if (addEndPoints == true) {
		    if (j == 1) {
			mp = sp;
		    } else if (j == nIntervals) {
			mp = sp + ip;
		    }
		}

		if ((crossBoundary == true) && (isOpenT == true)) {
		    if (mp < sectionOfFlltT.lower())
			mp += sectionOfFlltT.absIncrease();
		    if (mp > sectionOfFlltT.upper())
			mp -= sectionOfFlltT.absIncrease();
		}

		if (this.containsWithWrapping(flltT.coordinates(mp)) == true) {
		    if ((trimmingInterval != null) &&
			(trimmingInterval.eIdx == sIdx)) {
			trimmingInterval.eIdx = eIdx;
		    } else {
			trimmingInterval = new TrimmingInterval(sIdx, eIdx);
			listOfTrimmingIntervals.addElement(trimmingInterval);
		    }
		}

		sIdx = eIdx;
		sIwb = eIwb;
	    }

	    if ((nIntervals = listOfTrimmingIntervals.size()) > 1) {
		TrimmingInterval head =
		    (TrimmingInterval)listOfTrimmingIntervals.firstElement();
		TrimmingInterval tail =
		    (TrimmingInterval)listOfTrimmingIntervals.lastElement();
		if (head.sIdx == tail.eIdx) {
		    head.sIdx = tail.sIdx;
		    nIntervals--;
		}
	    }

	    /*
	     * ucƔfԁvŃg~O
	     */
	    for (int j = 0; j < nIntervals; j++) {
		trimmingInterval = (TrimmingInterval)listOfTrimmingIntervals.elementAt(j);
		sIwb = (IntersectionWithBoundaryInfo)
		    listOfIntersectionsWithBoundaries.elementAt(trimmingInterval.sIdx);
		eIwb = (IntersectionWithBoundaryInfo)
		    listOfIntersectionsWithBoundaries.elementAt(trimmingInterval.eIdx);

		sp = sIwb.curveParameter;
		if (trimmingInterval.sIdx < trimmingInterval.eIdx) {
		    crossBoundary = false;
		    ip = eIwb.curveParameter - sIwb.curveParameter;
		} else {
		    crossBoundary = true;
		    ip = eIwb.curveParameter - sIwb.curveParameter +
			sectionOfFlltT.increase();
		}

		if (ip < getToleranceForParameter())
		    continue;

		JgclFilletObject3D theTrimmedFillet =
		    trimFillet(mate, radius,
			       fllt3, flltT, flltM, isOpenT, sectionOfFlltT,
			       crossBoundary, sp, ip);

		/*
		 * g~Oʂ̒[_A̋Ȗʂ̋EɂȂ΁A
		 * ̒[_ZŃt@C
		 */
		// KOKO
		;

		/*
		 * g~OԂuo͂̃Xgvɉ
		 */
		results.addElement(theTrimmedFillet);
	    }

	}

	/*
	 * uo͂tBbg̃XgvԂ
	 */
	fillets = new JgclFilletObject3D[results.size()];
	results.copyInto(fillets);
	return fillets;
    }

    /**
     * ̗LȖʂƑ̗LȖʂ̃tBbg߂B
     * <p>
     * tBbg݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * 
     * @param side1	̋Ȗʂ̂ǂ瑤ɃtBbg߂邩tO
     *			(JgclWhichSide.FRONTȂΕ\ARIGHTȂΗABOTHȂΗ)
     * @param mate	̋Ȗ
     * @param side2	̋Ȗʂ̂ǂ瑤ɃtBbg߂邩tO
     *			(JgclWhichSide.FRONTȂΕ\ARIGHTȂΗABOTHȂΗ)
     * @param radius	tBbga
     * @return		tBbg̔z
     * @exception JgclIndefiniteSolution	s (ł͔Ȃ)
     * @see	JgclWhichSide
     */
    public JgclFilletObject3D[] fillet(int side1, JgclBoundedSurface3D mate, int side2, double radius)
	throws JgclIndefiniteSolution
    {
	JgclParameterSection uPint =
	    new JgclParameterSection(enclosingBox2D.min().x(),
				     (enclosingBox2D.max().x() - enclosingBox2D.min().x()));
	JgclParameterSection vPint =
	    new JgclParameterSection(enclosingBox2D.min().y(),
				     (enclosingBox2D.max().y() - enclosingBox2D.min().y()));

	JgclRectangularTrimmedSurface3D thisTrimmedBasis =
	    new JgclRectangularTrimmedSurface3D(this.basisSurface, uPint, vPint);

	JgclFilletObject3D[] results = mate.fillet(side2, thisTrimmedBasis, side1, radius);
	for (int i = 0; i < results.length; i++) {
	    JgclFilletSection3D[] sections = results[i].sections();
	    for (int j = 0; j < sections.length; j++) {
		JgclPointOnSurface3D posT = sections[j].pointOnSurface2();
		JgclPointOnSurface3D pos =
		    new JgclPointOnSurface3D(this,
					     thisTrimmedBasis.toBasisUParameter(posT.uParameter()),
					     thisTrimmedBasis.toBasisVParameter(posT.vParameter()),
					     doCheckDebug);
		sections[j] = new JgclFilletSection3D(radius, sections[j].center(), pos,
						      sections[j].pointOnSurface1());
	    }
	    results[i] = new JgclFilletObject3D(sections);
	}

	return this.trimFilletsWithBoundaries(mate, radius, results);
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂƁA
     * ̋Ȗʂ̎w (p[^I) `ԂɂtBbg߂B
     * <p>
     * tBbg݂Ȃꍇɂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * ȐEȖʂ̃p[^`͈ʂɋ`ł͂Ȃ̂ŁA
     * Ȗʂ`̃p[^`ƂOƂ̃\bh͗_IɈӖȂB
     * āA܂̂ƂA
     * JgclImproperOperation ̗O𔭐B
     * </p>
     * 
     * @param uSect1	̋Ȗʂ U ̃p[^
     * @param vSect1	̋Ȗʂ V ̃p[^
     * @param side1	̋Ȗʂ̂ǂ瑤ɃtBbg߂邩tO
     *			(JgclWhichSide.FRONTȂΕ\ARIGHTȂΗABOTHȂΗ)
     * @param mate	̋Ȗ
     * @param uSect2	̋Ȗʂ U ̃p[^
     * @param vSect2	̋Ȗʂ V ̃p[^
     * @param side2	̋Ȗʂ̂ǂ瑤ɃtBbg߂邩tO
     *			(JgclWhichSide.FRONTȂΕ\ARIGHTȂΗABOTHȂΗ)
     * @param radius	tBbga
     * @return		tBbg̔z
     * @exception JgclIndefiniteSolution	s (ł͔Ȃ)
     * @see	JgclWhichSide
     * @see	JgclImproperOperation
     */
    public JgclFilletObject3D[] fillet(JgclParameterSection uSect1, JgclParameterSection vSect1, int side1,
				       JgclParametricSurface3D mate,
				       JgclParameterSection uSect2, JgclParameterSection vSect2, int side2,
				       double radius)
	throws JgclIndefiniteSolution
    {
	throw new JgclImproperOperation();		// fillet
    }

    /*
     * ̋Ȗʂ U p[^̈ʒuɂ铙p[^ȐԂۃ\bhB
     * <p>
     * ȐEȖʂ̃p[^`͈ʂɋ`ł͂Ȃ̂ŁA
     * Ȗʂ`̃p[^`ƂOƂ̃\bh͗_IɈӖȂB
     * āA܂̂ƂA
     * JgclImproperOperation ̗O𔭐B
     * </p>
     *
     * @param uParam	U ̃p[^l
     * @return	w U p[^lł̓p[^Ȑ
     * @see	JgclImproperOperation
     */
    public JgclParametricCurve3D uIsoParametricCurve(double parameter) {
	throw new JgclImproperOperation();	// uIsoParametricCurve
    }

    /*
     * ̋Ȗʂ V p[^̈ʒuɂ铙p[^ȐԂۃ\bhB
     * <p>
     * ȐEȖʂ̃p[^`͈ʂɋ`ł͂Ȃ̂ŁA
     * Ȗʂ`̃p[^`ƂOƂ̃\bh͗_IɈӖȂB
     * āA܂̂ƂA
     * JgclImproperOperation ̗O𔭐B
     * </p>
     *
     * @param vParam	V ̃p[^l
     * @return	w V p[^lł̓p[^Ȑ
     * @see	JgclImproperOperation
     */
    public JgclParametricCurve3D vIsoParametricCurve(double parameter) {
	throw new JgclImproperOperation();	// vIsoParametricCurve
    }

    /**
     * ̋ȖʂA^ꂽ􉽓IϊZqŕϊB
     * <p>
     * transformedGeometries ́A
     * ϊO̊􉽗vfL[ƂA
     * ϊ̊􉽗vflƂnbVe[ułB
     * </p>
     * <p>
     * this  transformedGeometries ɃL[Ƃđ݂Ȃꍇɂ́A
     * this  transformationOperator ŕϊ̂ԂB
     * ̍ۂɃ\bhł this L[A
     * ϊʂlƂ transformedGeometries ɒǉB
     * </p>
     * <p>
     * this  transformedGeometries ɊɃL[Ƃđ݂ꍇɂ́A
     * ۂ̕ϊ͍sȂ킸ÃL[ɑΉlԂB
     * ͍̏ċAIɍsȂB
     * </p>
     * <p>
     * transformedGeometries  null ł\ȂB
     * transformedGeometries  null ̏ꍇɂ́A
     *  this  transformationOperator ŕϊ̂ԂB
     * </p>
     *
     * @param reverseTransform		tϊ̂ł trueAłȂ false
     * @param transformationOperator	􉽓IϊZq
     * @param transformedGeometries	ɓl̕ϊ{􉽗vf܂ރnbVe[u
     * @return	ϊ̊􉽗vf
     */
    protected synchronized JgclParametricSurface3D
    doTransformBy(boolean reverseTransform,
		  JgclCartesianTransformationOperator3D transformationOperator,
		  java.util.Hashtable transformedGeometries)
    {
	JgclParametricSurface3D tBasisSurface =
	    this.basisSurface.transformBy(reverseTransform,
					  transformationOperator,
					  transformedGeometries);
	JgclCompositeCurve3D tOuterBoundary = (JgclCompositeCurve3D)
	    this.outerBoundary.transformBy(reverseTransform,
					   transformationOperator,
					   transformedGeometries);
	Vector tInnerBoundaries = new Vector();
	for (Enumeration e = this.innerBoundaries.elements(); e.hasMoreElements();) {
	    JgclCompositeCurve3D inner = (JgclCompositeCurve3D)e.nextElement();
	    tInnerBoundaries.addElement(inner.transformBy(reverseTransform,
							  transformationOperator,
							  transformedGeometries));
	}

	return new JgclCurveBoundedSurface3D(tBasisSurface,
					     tOuterBoundary,
					     tInnerBoundaries);
    }

    /**
     * o̓Xg[Ɍ`o͂B
     *
     * @param writer    PrintWriter
     * @param indent	Cfg̐[
     */
    protected void output(PrintWriter writer,
			  int indent)
    {
        String indent_tab = this.makeIndent(indent);

        writer.println(indent_tab + getClassName());

	// basisSurface
        writer.println(indent_tab + "\tbasisSurface");
	this.basisSurface.output(writer, indent + 1);

        // outerBoundary
        writer.println(indent_tab + "\touterBoundary");
	this.outerBoundary.output(writer, indent + 1);

	// innerBoundaries
	if (this.innerBoundaries.size() > 0) {
	    writer.println(indent_tab + "\tinnerBoundaries");
	    for (Enumeration e = this.innerBoundaries.elements();
		 e.hasMoreElements();) {
		JgclCompositeCurve3D inner =
		    (JgclCompositeCurve3D)e.nextElement();
		inner.output(writer, indent + 1);
	    }
	}

        writer.println(indent_tab + "End");
    }

    /**
     * ^ꂽuȖʂɑ΂v_A̋Ȗʂ̋E̓ɂ邩ۂԂB
     *
     * @param ints	Ȗʂɑ΂_
     * @param doExchange	_ pointOnGeometry1/2 邩
     * @return	_Eɓɂ trueAłȂ false
     * @see	#containsWithWrapping(double, double)
     * @see	#selectInternalIntersections(JgclIntersectionPoint3D[], boolean)
     */
    private boolean
    intersectionIsInternal(JgclIntersectionPoint3D ints,
			   boolean doExchange)
    {
	JgclPointOnSurface3D pointOnSurface;
	if (doExchange == false) {
	    pointOnSurface = (JgclPointOnSurface3D)ints.pointOnGeometry1();
	} else {
	    pointOnSurface = (JgclPointOnSurface3D)ints.pointOnGeometry2();
	}
	return this.containsWithWrapping(pointOnSurface.uParameter(),
					 pointOnSurface.vParameter());
    }

    /**
     * ^ꂽuȖʂɑ΂v_A̋Ȗʂɑ΂_ɕϊB
     *
     * @param ints	Ȗʂɑ΂_
     * @param doExchange	_ pointOnGeometry1/2 邩
     * @return	Ώۂ̋ȖʂɕύX_
     * @see	#intersectionIsInternal(JgclIntersectionPoint3D, boolean)
     * @see	#changeTargetOfIntersection(JgclIntersectionCurve3D, boolean)
     * @see	#selectInternalIntersections(JgclIntersectionPoint3D[], boolean)
     */
    private JgclIntersectionPoint3D
    changeTargetOfIntersection(JgclIntersectionPoint3D ints,
			       boolean doExchange)
    {
	JgclPointOnGeometry3D pog1 = ints.pointOnGeometry1();
	JgclPointOnGeometry3D pog2 = ints.pointOnGeometry2();
	JgclPointOnSurface3D pos;
	double uParam;
 	double vParam;
	if (doExchange == false) {
	    pos = (JgclPointOnSurface3D)pog1;
 	    uParam = basisSurface.uParameterDomain().wrap(pos.uParameter());
 	    vParam = basisSurface.vParameterDomain().wrap(pos.vParameter());
	    pog1 = new JgclPointOnSurface3D(this,
					    uParam,
					    vParam,
					    doCheckDebug);
	} else {
	    pos = (JgclPointOnSurface3D)pog2;
 	    uParam = basisSurface.uParameterDomain().wrap(pos.uParameter());
 	    vParam = basisSurface.vParameterDomain().wrap(pos.vParameter());
	    pog2 = new JgclPointOnSurface3D(this,
					    uParam,
					    vParam,
					    doCheckDebug);
	}
	return new JgclIntersectionPoint3D(ints.coordinates(),
					   pog1, pog2, doCheckDebug);

    }

    /**
     * ^ꂽuȖʂɑ΂vA̋Ȗʂɑ΂ɕϊB
     *
     * @param ints	Ȗʂɑ΂
     * @param doExchange	 basisSurface1/2 邩
     * @return	Ώۂ̋ȖʂɕύX
     * @see	#changeTargetOfIntersection(JgclIntersectionPoint3D, boolean)
     */
    private JgclIntersectionCurve3D
    changeTargetOfIntersection(JgclIntersectionCurve3D ints,
			       boolean doExchange)
    {
	JgclParametricSurface3D basisSurface1;
	JgclParametricSurface3D basisSurface2;
	if (doExchange == false) {
	    basisSurface1 = this;
	    basisSurface2 = ints.basisSurface2();
	} else {
	    basisSurface1 = ints.basisSurface1();
	    basisSurface2 = this;
	}
	return new JgclIntersectionCurve3D(ints.curve3d(),
					   basisSurface1, ints.curve2d1(),
					   basisSurface2, ints.curve2d2(),
					   ints.masterRepresentation());
    }

    /**
     * ^ꂽuȖʂɑ΂v_̓ŁA̋Ȗʂ̋E̓ɂ_ԂB
     * <p>
     * ʂƂē_́A
     * ̑Ώۂƃp[^l̋Ȗʂɑ΂̂ɕϊĂB
     * </p>
     *
     * @param intersections	ȖʂƂ̌_Zœꂽ_̔z
     * @param doExchange	_ pointOnGeometry1/2 邩
     * @return	̋Ȗʂ̋E̓ɂ_̔z
     * @see	#intersectionIsInternal(JgclIntersectionPoint3D, boolean)
     * @see	#changeTargetOfIntersection(JgclIntersectionPoint3D, boolean)
     */
    JgclIntersectionPoint3D[]
    selectInternalIntersections(JgclIntersectionPoint3D[] intersections,
				boolean doExchange)
    {
	Vector innerPoints = new Vector();
	JgclIntersectionPoint3D ints;

	for (int i = 0; i < intersections.length; i++) {
	    if (this.intersectionIsInternal(intersections[i], doExchange) == true) {
		ints = this.changeTargetOfIntersection(intersections[i], doExchange);
		innerPoints.addElement(ints);
	    }
	}

	JgclIntersectionPoint3D[] results =
	    new JgclIntersectionPoint3D[innerPoints.size()];
	innerPoints.copyInto(results);
	return results;
    }

    /**
     * Ȗʏ̋ȐƂ̋Ȗʂ̋EƂ̌_\NXB
     */
    private class IntersectionWithBoundaryInfo {
	/**
	 * E̔ԍB
	 * <p>
	 * (- 1) ł΁AO\B
	 * </p>
	 */
	int boundaryIndex;

	/**
	 * Ẽp[^l
	 */
	double boundaryParameter;

	/**
	 * Ȗʏ̋Ȑ̃p[^l
	 */
	double curveParameter;

	/**
	 * ^ɃIuWFNg\zB
	 */
	IntersectionWithBoundaryInfo() {
	}

	/**
	 * etB[hɐݒ肷l^ăIuWFNg\zB
	 *
	 * @param boundaryIndex	E̔ԍ
	 * @param boundaryParameter	Ẽp[^l
	 * @param curveParameter	Ȗʏ̋Ȑ̃p[^l
	 */
	IntersectionWithBoundaryInfo(int boundaryIndex,
				     double boundaryParameter,
				     double curveParameter) {
	    this.boundaryIndex = boundaryIndex;
	    this.boundaryParameter = boundaryParameter;
	    this.curveParameter = curveParameter;
	}
    }

    /**
     * Ȗʏ̋ȐEƂ̌_Ńg~OԂ\NXB
     */
    private class TrimmingInterval {
	/**
	 * Jn_̃Xgł̈ʒuB
	 */
	int sIdx;

	/**
	 * I_̃Xgł̈ʒuB
	 */
	int eIdx;

	/**
	 * Jn_^I_̃Xgł̈ʒu^ăIuWFNg\zB
	 *
	 * @param sIdx	Jn_̃Xgł̈ʒu
	 * @param eIdx	I_̃Xgł̈ʒu
	 */
	TrimmingInterval(int sIdx,
			 int eIdx) {
	    this.sIdx = sIdx;
	    this.eIdx = eIdx;
	}
    }

    /**
     * ^ꂽ􉽓IɕĂ΁AʑIɂ`ɂB
     *
     * @param theIntersection 
     * @return	ʑIȊJԂ􉽓IȊJԂɍ킹
     */
    private JgclIntersectionCurve3D
    makeIntersectionClose(JgclIntersectionCurve3D theIntersection) {
	boolean changed = false;

	/*
	 * curve3d
	 */
	JgclParametricCurve3D curve3d = theIntersection.curve3d();
	if ((curve3d.isClosed() == true) &&
	    (curve3d.isPeriodic() != true) &&
	    (curve3d.type() == JgclParametricCurve3D.POLYLINE_3D)) {
	    JgclPolyline3D polyline3d = (JgclPolyline3D)curve3d;
	    int nPoints = polyline3d.nPoints() - 1;
	    JgclPoint3D[] points = new JgclPoint3D[nPoints];
	    for (int i = 0; i < nPoints; i++)
		points[i] = polyline3d.pointAt(i);
	    curve3d = new JgclPolyline3D(points, true);
	    changed = true;
	}

	/*
	 * curve2d1
	 */
	JgclParametricCurve2D curve2d1 = theIntersection.curve2d1();
	if ((curve2d1.isClosed() == true) &&
	    (curve2d1.isPeriodic() != true) &&
	    ((curve2d1 instanceof JgclPolyline2D) == true)) {
	    JgclPolyline2D polyline2d = (JgclPolyline2D)curve2d1;
	    int nPoints = polyline2d.nPoints() - 1;
	    JgclPoint2D[] points = new JgclPoint2D[nPoints];
	    for (int i = 0; i < nPoints; i++)
		points[i] = polyline2d.pointAt(i);
	    curve2d1 = new JgclPolyline2D(points, true);
	    changed = true;
	}

	/*
	 * curve2d2
	 */
	JgclParametricCurve2D curve2d2 = theIntersection.curve2d2();
	if ((curve2d2.isClosed() == true) &&
	    (curve2d2.isPeriodic() != true) &&
	    ((curve2d2 instanceof JgclPolyline2D) == true)) {
	    JgclPolyline2D polyline2d = (JgclPolyline2D)curve2d2;
	    int nPoints = polyline2d.nPoints() - 1;
	    JgclPoint2D[] points = new JgclPoint2D[nPoints];
	    for (int i = 0; i < nPoints; i++)
		points[i] = polyline2d.pointAt(i);
	    curve2d2 = new JgclPolyline2D(points, true);
	    changed = true;
	}

	if (changed != true)
	    return theIntersection;

	return new JgclIntersectionCurve3D(curve3d,
					   theIntersection.basisSurface1(), curve2d1,
					   theIntersection.basisSurface2(), curve2d2,
					   theIntersection.masterRepresentation());
    }

    /**
     * _̂Ȑł̃p[^l߂B
     * <p>
     * point3d  curve3d ɏĂ̂ƂāA
     * point3d  curve3d ł̃p[^lԂB
     * </p>
     * <p>
     * p[^l܂߂Ȃꍇɂ
     * JgclFatal ̗O𔭐B
     * </p>
     *
     * @param curve3d	Ȑ
     * @param point3d	_
     * @return	p[^l
     * @see	JgclFatal
     * @see	JgclParametricCurve3D#hasPolyline()
     * @see	JgclBoundedCurve3D#toPolyline(JgclToleranceForDistance)
     * @see	JgclParametricCurve3D#nearestProjectFrom(JgclPoint3D)
     */
    private double getParameterWithCurve3D(JgclParametricCurve3D curve3d,
					   JgclPoint3D point3d)
    {
	JgclPointOnCurve3D nearProj3d;
	double nearDist;
	JgclPointOnCurve3D nearestProj3d = null;
	double nearestDist = Double.NaN;

	JgclPointOnCurve3D lowerPoint = null;
	JgclPointOnCurve3D upperPoint = null;
	if (curve3d.isFinite() && curve3d.isOpen()) {
	    lowerPoint = new JgclPointOnCurve3D(curve3d, curve3d.parameterDomain().section().lower());
	    upperPoint = new JgclPointOnCurve3D(curve3d, curve3d.parameterDomain().section().upper());
	}

	JgclPolyline3D polyline3d = null;
	if (curve3d.hasPolyline() == true) {
	    // curve3d ͗LłɌ܂Ă
	    JgclBoundedCurve3D bounded3d = (JgclBoundedCurve3D)curve3d;
	    polyline3d = bounded3d.toPolyline(getToleranceForDistanceAsObject());
	}

	nearProj3d = curve3d.nearestProjectFrom(point3d);
	if (nearProj3d != null) {
	    nearDist = nearProj3d.distance(point3d);
	    if ((nearestProj3d == null) || (nearDist < nearestDist)) {
		nearestProj3d = nearProj3d;
		nearestDist = nearDist;
	    }
	}

	if (lowerPoint != null) {
	    nearDist = lowerPoint.distance(point3d);
	    if ((nearestProj3d == null) || (nearDist < nearestDist)) {
		nearestProj3d = lowerPoint;
		nearestDist = nearDist;
	    }
	}
	if (upperPoint != null) {
	    nearDist = upperPoint.distance(point3d);
	    if ((nearestProj3d == null) || (nearDist < nearestDist)) {
		nearestProj3d = upperPoint;
		nearestDist = nearDist;
	    }
	}
	if (polyline3d != null) {
	    for (int i = 0; i < polyline3d.nPoints(); i++) {
		nearDist = polyline3d.pointAt(i).distance(point3d);
		if ((nearestProj3d == null) || (nearDist < nearestDist)) {
		    nearestProj3d = (JgclPointOnCurve3D)polyline3d.pointAt(i);
		    nearestDist = nearDist;
		}
	    }
	}

	if (nearestProj3d == null)	// ǂႢ̂
	    throw new JgclFatal("No projection.");

	return nearestProj3d.parameter();
    }

    /**
     * _́uȖʏ̂Ȑvł̃p[^l߂B
     * <p>
     * curve2d  surface3d ̋Ȑ C ̃p[^Ԃł̂Q\ł̂ƂB
     * </p>
     * <p>
     * point3d  C ɏĂ̂ƂāA
     * point3d  C ł̃p[^lԂB
     * </p>
     * <p>
     * p[^l܂߂Ȃꍇɂ
     * JgclFatal ̗O𔭐B
     * </p>
     *
     * @param surface3d	Ȗ
     * @param curve2d	Ȑ
     * @param point3d	_
     * @return	p[^l
     * @see	JgclFatal
     * @see	JgclParametricSurface3D#nearestProjectFrom(JgclPoint3D)
     * @see	JgclParametricCurve2D#hasPolyline()
     * @see	JgclBoundedCurve2D#toPolyline(JgclToleranceForDistance)
     * @see	JgclParametricCurve2D#nearestProjectFrom(JgclPoint2D)
     */
    private double getParameterWithCurveOnSurface3D(JgclParametricSurface3D surface3d,
						    JgclParametricCurve2D curve2d,
						    JgclPoint3D point3d)
    {
	JgclPointOnSurface3D nearestProj3d = surface3d.nearestProjectFrom(point3d);
	if (nearestProj3d == null)	// ǂႢ̂
	    throw new JgclFatal("No projection in 3d.");
	double[] param3d = nearestProj3d.parameters();

	JgclPointOnCurve2D lowerPoint = null;
	JgclPointOnCurve2D upperPoint = null;
	if (curve2d.isFinite() && curve2d.isOpen()) {
	    lowerPoint = new JgclPointOnCurve2D(curve2d, curve2d.parameterDomain().section().lower());
	    upperPoint = new JgclPointOnCurve2D(curve2d, curve2d.parameterDomain().section().upper());
	}

	JgclPolyline2D polyline2d = null;
	if (curve2d.hasPolyline() == true) {
	    // curve2d ͗LłɌ܂Ă
	    JgclBoundedCurve2D bounded2d = (JgclBoundedCurve2D)curve2d;
	    polyline2d = bounded2d.toPolyline(getToleranceForDistanceAsObject());
	}

	int nU = 1;
	double dU = Double.NaN;
	int nV = 1;
	double dV = Double.NaN;

	if (surface3d.type() != JgclParametricSurface3D.CURVE_BOUNDED_SURFACE_3D) {
	    if (surface3d.isUPeriodic() == true) {
		nU = 3;
		dU = surface3d.uParameterDomain().section().increase();
	    }

	    if (surface3d.isVPeriodic() == true) {
		nV = 3;
		dV = surface3d.vParameterDomain().section().increase();
	    }
	}

	double pU;
	double pV;
	JgclPoint2D point2d;
	JgclPointOnCurve2D nearProj2d;
	double nearDist;
	JgclPointOnCurve2D nearestProj2d = null;
	double nearestDist = Double.NaN;

	for (int iU = 0; iU < nU; iU++) {
	    switch (iU) {
	    case 1:	pU = param3d[0] - dU;	break;
	    case 2:	pU = param3d[0] + dU;	break;
	    default:	pU = param3d[0];	break;
	    }

	    for (int iV = 0; iV < nV; iV++) {
		switch (iV) {
		case 1:		pV = param3d[1] - dV;	break;
		case 2:		pV = param3d[1] + dV;	break;
		default:	pV = param3d[1];	break;
		}

		point2d = JgclPoint2D.of(pU, pV);
		nearProj2d = curve2d.nearestProjectFrom(point2d);
		if (nearProj2d != null) {
		    nearDist = nearProj2d.distance(point2d);
		    if ((nearestProj2d == null) || (nearDist < nearestDist)) {
			nearestProj2d = nearProj2d;
			nearestDist = nearDist;
		    }
		}

		if (lowerPoint != null) {
		    nearDist = lowerPoint.distance(point2d);
		    if ((nearestProj2d == null) || (nearDist < nearestDist)) {
			nearestProj2d = lowerPoint;
			nearestDist = nearDist;
		    }
		}

		if (upperPoint != null) {
		    nearDist = upperPoint.distance(point2d);
		    if ((nearestProj2d == null) || (nearDist < nearestDist)) {
			nearestProj2d = upperPoint;
			nearestDist = nearDist;
		    }
		}

		if (polyline2d != null) {
		    for (int i = 0; i < polyline2d.nPoints(); i++) {
			nearDist = polyline2d.pointAt(i).distance(point2d);
			if ((nearestProj2d == null) || (nearDist < nearestDist)) {
			    nearestProj2d = (JgclPointOnCurve2D)polyline2d.pointAt(i);
			    nearestDist = nearDist;
			}
		    }
		}
	    }
	}

	if (nearestProj2d == null)	// ǂႢ̂
	    throw new JgclFatal("No projection in 2d.");

	return nearestProj2d.parameter();
    }

    /**
     * ̋Ȗʂ̋EƁuȖʂɑ΂v̌_߂B
     *
     * @param boundaryCurve	̋Ȗʂ̋E
     * @param intsT	Ȗʂɑ΂̂Q\
     * @return	boundaryCurve  intsT ̌_̔z
     * @see	#trimIntersectionsWithBoundaries(JgclParametricSurface3D, JgclSurfaceSurfaceInterference3D[], boolean)
     */
    private JgclIntersectionPoint2D[]
    getIntersectionsWithBoundary(JgclCompositeCurve2D boundaryCurve,
				  JgclParametricCurve2D intsT)
    {
	int nU = 1;
	double dU = Double.NaN;

	int nV = 1;
	double dV = Double.NaN;

	if (basisSurface.type() != JgclParametricSurface3D.CURVE_BOUNDED_SURFACE_3D) {
	    if (basisSurface.isUPeriodic() == true) {
		nU = 3;
		dU = basisSurface.uParameterDomain().section().increase();
	    }

	    if (basisSurface.isVPeriodic() == true) {
		nV = 3;
		dV = basisSurface.vParameterDomain().section().increase();
	    }
	}

	double pU;
	double pV;
	JgclCompositeCurve2D tBoundaryCurve;
	JgclIntersectionPoint2D[] intsWithBoundary;
	Vector intsWithBoundaryList = new Vector();
	int nInts = 0;

	for (int iU = 0; iU < nU; iU++) {
	    switch (iU) {
	    case 1:	pU = - dU;	break;
	    case 2:	pU = dU;	break;
	    default:	pU = 0.0;	break;
	    }

	    for (int iV = 0; iV < nV; iV++) {
		switch (iV) {
		case 1:		pV = - dV;	break;
		case 2:		pV = dV;	break;
		default:	pV = 0.0;	break;
		}

		if ((iU == 0) && (iV == 0)) {
		    tBoundaryCurve = boundaryCurve;
		} else {
		    JgclCartesianTransformationOperator2D transformer =
			new JgclCartesianTransformationOperator2D(null, null,
								  JgclPoint2D.of(pU, pV),
								  1.0);
		    tBoundaryCurve = (JgclCompositeCurve2D)boundaryCurve.transformBy(transformer, null);
		}
		intsWithBoundary = tBoundaryCurve.intersect(intsT);

		if (intsWithBoundary.length > 0) {
		    intsWithBoundaryList.addElement(intsWithBoundary);
		    nInts += intsWithBoundary.length;
		}
	    }
	}

	JgclIntersectionPoint2D[] result = new JgclIntersectionPoint2D[nInts];
	int iResult = 0;
	for (Enumeration e = intsWithBoundaryList.elements(); e.hasMoreElements();) {
	    intsWithBoundary = (JgclIntersectionPoint2D[])e.nextElement();
	    for (int i = 0; i < intsWithBoundary.length; i++)
		result[iResult++] = intsWithBoundary[i];
	}

	return result;
    }


    /**
     * ^ꂽp[^lAJ`̒ɓ悤Ɋۂ߂B
     *
     * @param param	p[^l
     * @param section	(J`) p[^
     */
    private double wrapParameterIntoOpenSection(double param,
						JgclParameterSection section) {
	while (param < section.lower())
	    param += section.absIncrease();
	while (param > section.upper())
	    param -= section.absIncrease();

	return param;
    }

    /**
     * ^ꂽȐg~ÔɁAKɓq悤ɂăg~OB
     * <p>
     * curve ͊JȐŁA(sp &gt; ep) ł邱Ƃz肵ĂB
     * </p>
     *
     * @param curve	(J) Ȑ
     * @param sp	g~OĎcԂ̊Jnp[^l
     * @param ep	g~OĎcԂ̏Ip[^l
     * @see	#wrapParameterIntoOpenSection(double, JgclParameterSection)
     */
    private JgclParametricCurve2D connectHeadToTail(JgclParametricCurve2D curve,
						    double sp,
						    double ep) {
	JgclParameterSection section = curve.parameterDomain().section();

	double sp1 = wrapParameterIntoOpenSection(sp, section);
	double ep1 = section.upper();
	double sp2 = section.lower();
	double ep2 = wrapParameterIntoOpenSection(ep, section);

	JgclPoint2D lowerCoord = curve.coordinates(section.lower());
	JgclPoint2D upperCoord = curve.coordinates(section.upper());
	JgclVector2D period = upperCoord.subtract(lowerCoord);
	JgclCartesianTransformationOperator2D transformer =
	    new JgclCartesianTransformationOperator2D(null, null,
						      period.toPoint2D(),
						      1.0);

	JgclParametricCurve2D curve1 = curve;
	JgclParametricCurve2D curve2 = curve.transformBy(transformer, null);

	JgclTrimmedCurve2D tCurve1 = new JgclTrimmedCurve2D(curve1, sp1, ep1, true);
	JgclTrimmedCurve2D tCurve2 = new JgclTrimmedCurve2D(curve2, sp2, ep2, true);
	JgclCompositeCurveSegment2D[] segments =
	    new JgclCompositeCurveSegment2D[2];
	segments[0] = new JgclCompositeCurveSegment2D(JgclTransitionCode.CONTINUOUS,
						      true, tCurve1);
	segments[1] = new JgclCompositeCurveSegment2D(JgclTransitionCode.DISCONTINUOUS,
						      true, tCurve2);
	return new JgclCompositeCurve2D(segments, false);
    }

    /**
     * |Cō\ꂽw̃p[^ԂŃg~OB
     *
     * @param doExchange  basisSurface1/2 邩ǂ
     * @param theIntersection	g~O
     * @param isOpenT	g~O this ̕\JĂ邩ۂ
     * @param isOpenM	g~O mate ̕\JĂ邩ۂ
     * @param crossBoundary	g~OԂ (RIɕ) ׂ̎ۂ
     * @param spT	g~O̊Jnp[^l (this ̕\̃p[^l)
     * @param ipT	g~Ȏp[^l (this ̕\̃p[^l)
     * @return	g~Ǒ
     * @see	#trimIntersection(boolean, JgclIntersectionCurve3D, JgclParametricCurve2D, JgclParameterSection, boolean, boolean, boolean, double, double)
     * @see	#wrapParameterIntoOpenSection(double, JgclParameterSection)
     * @see	#connectHeadToTail(JgclParametricCurve2D, double, double)
     */
    private JgclIntersectionCurve3D
    trimIntersection2(boolean doExchange,
		      JgclIntersectionCurve3D theIntersection,
		      boolean isOpenT,
		      boolean isOpenM,
		      boolean crossBoundary,
		      double spT,
		      double ipT) {
	double epT = spT + ipT;

	JgclParameterSection section;
	double sp;
	double ep;
	boolean isOpen;

	/*
	 * curve3d
	 */
	JgclParametricCurve3D curve3d = theIntersection.curve3d();
	sp = spT;
	ep = epT;
	curve3d = new JgclTrimmedCurve3D(curve3d, sp, ep, true);

	/*
	 * curve2d1
	 */
	JgclParametricCurve2D curve2d1 = theIntersection.curve2d1();
	sp = spT;
	ep = epT;
	isOpen = (doExchange == false) ? isOpenT : isOpenM;
	if ((crossBoundary == true) && (isOpen == true)) {
	    section = curve2d1.parameterDomain().section();
	    sp = wrapParameterIntoOpenSection(sp, section);
	    ep = wrapParameterIntoOpenSection(ep, section);
	}
	if ((sp < ep) || (isOpen == false)) {
	    curve2d1 = new JgclTrimmedCurve2D(curve2d1, sp, ep, true);
	} else {
	    curve2d1 = connectHeadToTail(curve2d1, sp, ep);
	}

	/*
	 * curve2d2
	 */
	JgclParametricCurve2D curve2d2 = theIntersection.curve2d2();
	sp = spT;
	ep = epT;
	isOpen = (doExchange == false) ? isOpenM : isOpenT;
	if ((crossBoundary == true) && (isOpen == true)) {
	    section = curve2d2.parameterDomain().section();
	    sp = wrapParameterIntoOpenSection(sp, section);
	    ep = wrapParameterIntoOpenSection(ep, section);
	}
	if ((sp < ep) || (isOpen == false)) {
	    curve2d2 = new JgclTrimmedCurve2D(curve2d2, sp, ep, true);
	} else {
	    curve2d2 = connectHeadToTail(curve2d2, sp, ep);
	}

	return new JgclIntersectionCurve3D(curve3d,
					   theIntersection.basisSurface1(), curve2d1,
					   theIntersection.basisSurface2(), curve2d2,
					   theIntersection.masterRepresentation());
    }

    /**
     * w̃p[^ԂŃg~OB
     *
     * @param doExchange basisSurface1,2邩ǂ
     * @param theIntersection	g~O
     * @param intsT	g~O this ̕\
     * @param sectionOfIntsT	intsT ̃p[^`̋
     * @param isOpenT	g~OtBbg this ̕\JĂ邩ۂ
     * @param isOpenM	g~OtBbg mate ̕\JĂ邩ۂ
     * @param crossBoundary	g~OԂ (RIɕ) ׂ̎ۂ
     * @param spT	g~O̊Jnp[^l (this ̕\̃p[^l)
     * @param ipT	g~Ȏp[^l (this ̕\̃p[^l)
     * @return	g~Ǒ
     * @see	JgclParametricCurve3D#isComposedOfOnlyPolylines()
     * @see	JgclParametricCurve2D#isComposedOfOnlyPolylines()
     * @see	#trimIntersection2(boolean, JgclIntersectionCurve3D, boolean, boolean, boolean, double, double)
     * @see	#wrapParameterIntoOpenSection(double, JgclParameterSection)
     * @see	#getParameterWithCurve3D(JgclParametricCurve3D, JgclPoint3D)
     * @see	#getParameterWithCurveOnSurface3D(JgclParametricSurface3D, JgclParametricCurve2D, JgclPoint3D)
     * @see	#connectHeadToTail(JgclParametricCurve2D, double, double)
     */
    private JgclIntersectionCurve3D
    trimIntersection(boolean doExchange,
		     JgclIntersectionCurve3D theIntersection,
		     JgclParametricCurve2D intsT,
		     JgclParameterSection sectionOfIntsT,
		     boolean isOpenT,
		     boolean isOpenM,
		     boolean crossBoundary,
		     double spT,
		     double ipT) {
	if ((theIntersection.curve3d().isComposedOfOnlyPolylines() == true) &&
	    (theIntersection.curve2d1().isComposedOfOnlyPolylines() == true) &&
	    (theIntersection.curve2d2().isComposedOfOnlyPolylines() == true)) {
	    JgclParameterSection section3d =
		theIntersection.curve3d().parameterDomain().section();
	    JgclParameterSection section2d1 =
		theIntersection.curve2d1().parameterDomain().section();
	    JgclParameterSection section2d2 =
		theIntersection.curve2d2().parameterDomain().section();

	    if ((section3d.identical(section2d1) == true) &&
		(section3d.identical(section2d2) == true))
		return trimIntersection2(doExchange,
					 theIntersection,
					 isOpenT, isOpenM,
					 crossBoundary, spT, ipT);
	}

	double epT = spT + ipT;

	if ((crossBoundary == true) && (isOpenT == true)) {
	    spT = wrapParameterIntoOpenSection(spT, sectionOfIntsT);
	    epT = wrapParameterIntoOpenSection(epT, sectionOfIntsT);
	}

	JgclPoint2D spnt2d = intsT.coordinates(spT);
	JgclPoint2D epnt2d = intsT.coordinates(epT);
	JgclPoint3D spnt3d = this.basisSurface.coordinates(spnt2d.x(), spnt2d.y());
	JgclPoint3D epnt3d = this.basisSurface.coordinates(epnt2d.x(), epnt2d.y());

	double sp;
	double ep;
	boolean isOpen;

	/*
	 * curve3d
	 */
	JgclParametricCurve3D curve3d = theIntersection.curve3d();
	sp = getParameterWithCurve3D(curve3d, spnt3d);
	ep = getParameterWithCurve3D(curve3d, epnt3d);
	curve3d = new JgclTrimmedCurve3D(curve3d, sp, ep, true);

	/*
	 * curve2d1
	 */
	JgclParametricCurve2D curve2d1 = theIntersection.curve2d1();
	if (doExchange == false) {
	    sp = spT;
	    ep = epT;
	    isOpen = isOpenT;
	} else {
	    sp = getParameterWithCurveOnSurface3D(theIntersection.basisSurface1(),
						  curve2d1, spnt3d);
	    ep = getParameterWithCurveOnSurface3D(theIntersection.basisSurface1(),
						  curve2d1, epnt3d);
	    isOpen = isOpenM;
	}
	if ((sp < ep) || (isOpen == false)) {
	    curve2d1 = new JgclTrimmedCurve2D(curve2d1, sp, ep, true);
	} else {
	    curve2d1 = connectHeadToTail(curve2d1, sp, ep);
	}

	/*
	 * curve2d2
	 */
	JgclParametricCurve2D curve2d2 = theIntersection.curve2d2();
	if (doExchange == false) {
	    sp = getParameterWithCurveOnSurface3D(theIntersection.basisSurface2(),
						  curve2d2, spnt3d);
	    ep = getParameterWithCurveOnSurface3D(theIntersection.basisSurface2(),
						  curve2d2, epnt3d);
	    isOpen = isOpenM;
	} else {
	    sp = spT;
	    ep = epT;
	    isOpen = isOpenT;
	}
	if ((sp < ep) || (isOpen == false)) {
	    curve2d2 = new JgclTrimmedCurve2D(curve2d2, sp, ep, true);
	} else {
	    curve2d2 = connectHeadToTail(curve2d2, sp, ep);
	}

	return new JgclIntersectionCurve3D(curve3d,
					   theIntersection.basisSurface1(), curve2d1,
					   theIntersection.basisSurface2(), curve2d2,
					   theIntersection.masterRepresentation());
    }

    /**
     * ̋Ȗʂ̕Ȗʂ̃p[^ԏ̋Ȑ
     * Ȗʂ̃vC}ȗLԓɈړB
     *
     * @param curve	Ȗʂ̃p[^ԏ̋Ȑ
     * @return	Ȗʂ̃vC}ȗLԓɂȐ
     */
    private JgclParametricCurve2D
    moveIntoPrimarySections(JgclParametricCurve2D curve)
    {
	double lower = curve.parameterDomain().section().lower();
	double upper = curve.parameterDomain().section().upper();
	double middle = (lower + upper) / 2.0;
	JgclPoint2D lowerPoint = curve.coordinates(lower);
	JgclPoint2D upperPoint = curve.coordinates(upper);
	JgclPoint2D middlePoint = curve.coordinates(middle);

	int nU = 1;
	double dU = Double.NaN;

	int nV = 1;
	double dV = Double.NaN;

	if (basisSurface.type() != JgclParametricSurface3D.CURVE_BOUNDED_SURFACE_3D) {
	    if (basisSurface.isUPeriodic() == true) {
		nU = 3;
		dU = basisSurface.uParameterDomain().section().increase();
	    }

	    if (basisSurface.isVPeriodic() == true) {
		nV = 3;
		dV = basisSurface.vParameterDomain().section().increase();
	    }
	}

	double pU;
	double pV;
	JgclCartesianTransformationOperator2D transformer;
	JgclPoint2D tLowerPoint;
	JgclPoint2D tUpperPoint;
	JgclPoint2D tMiddlePoint;

	for (int iU = 0; iU < nU; iU++) {
	    switch (iU) {
	    case 1:	pU = - dU;	break;
	    case 2:	pU = dU;	break;
	    default:	pU = 0.0;	break;
	    }

	    for (int iV = 0; iV < nV; iV++) {
		switch (iV) {
		case 1:		pV = - dV;	break;
		case 2:		pV = dV;	break;
		default:	pV = 0.0;	break;
		}

		if ((iU == 0) && (iV == 0)) {
		    transformer = null;
		    tLowerPoint = lowerPoint;
		    tUpperPoint = upperPoint;
		    tMiddlePoint = middlePoint;
		} else {
		    transformer =
			new JgclCartesianTransformationOperator2D(null, null,
								  JgclPoint2D.of(pU, pV),
								  1.0);
		    tLowerPoint = lowerPoint.transformBy(transformer, null);
		    tUpperPoint = upperPoint.transformBy(transformer, null);
		    tMiddlePoint = middlePoint.transformBy(transformer, null);
		}

		if ((contains(tLowerPoint) == true) &&
		    (contains(tUpperPoint) == true) &&
		    (contains(tMiddlePoint) == true)) {
		    if (transformer == null)
			return curve;
		    else
			return curve.transformBy(transformer, null);
		}
	    }
	}

	return null;
    }

    /**
     * ̋Ȗʂ̕Ȗʂɑ΂p[^l
     * ̋Ȗʂɑ΂p[^lɕϊB
     *
     * @param ints	̋Ȗʂ̕Ȗʂɑ΂p[^l
     * @param doExchange	 pointOnSurface1/2 邩
     * @return	̋Ȗʂɑ΂p[^l
     * @see	#moveIntoPrimarySections(JgclParametricCurve2D)
     */
    private JgclIntersectionCurve3D
    changeParameterSpaceOfIntersection(JgclIntersectionCurve3D ints,
				       boolean doExchange)
    {
	JgclParametricCurve2D curve2d1 = ints.curve2d1();
	JgclParametricCurve2D curve2d2 = ints.curve2d2();
	if (doExchange == false) {
	    curve2d1 = moveIntoPrimarySections(curve2d1);
	} else {
	    curve2d2 = moveIntoPrimarySections(curve2d2);
	}
	return new JgclIntersectionCurve3D(ints.curve3d(),
					   ints.basisSurface1(), curve2d1,
					   ints.basisSurface2(), curve2d2,
					   ints.masterRepresentation());
    }

    /**
     * ̋Ȗʂ̕ȖʂƑ̋Ȗʂ̌A
     * ̋Ȗʂ̋EŃg~OB
     * <p>
     * ^ꂽɂāA̋Ȗʂ̋E̓ɂ镔ƂĕԂB
     * </p>
     *
     * @param mate	̋Ȗ
     * @param intersections	ȖʂƂ̌Zœꂽ̔z
     * @param doExchange	 pointOnSurface1/2 邩
     * @return	̋Ȗʂ̋EŃg~O̔z
     * @see	#changeTargetOfIntersection(JgclIntersectionPoint3D, boolean)
     * @see	#changeTargetOfIntersection(JgclIntersectionCurve3D, boolean)
     * @see	#intersectionIsInternal(JgclIntersectionPoint3D, boolean)
     * @see	#makeIntersectionClose(JgclIntersectionCurve3D)
     * @see	#getIntersectionsWithBoundary(JgclCompositeCurve2D, JgclParametricCurve2D)
     * @see	JgclCurveBoundedSurface3D.IntersectionWithBoundaryInfo
     * @see	#containsWithWrapping(JgclPoint2D)
     * @see	#trimIntersection(boolean, JgclIntersectionCurve3D, JgclParametricCurve2D, JgclParameterSection, boolean, boolean, boolean, double, double)
     * @see	#changeParameterSpaceOfIntersection(JgclIntersectionCurve3D, boolean)
     */
    JgclSurfaceSurfaceInterference3D[]
    trimIntersectionsWithBoundaries(JgclParametricSurface3D mate,
				    JgclSurfaceSurfaceInterference3D[] intersections,
				    boolean doExchange)
    {
	// ̑ΏۂȖʂ玩gɕύX
	for (int i = 0; i < intersections.length; i++) {
	    if (intersections[i].isIntersectionPoint() == true) {
		// _
		JgclIntersectionPoint3D ints =
		    intersections[i].toIntersectionPoint();
		intersections[i] = changeTargetOfIntersection(ints, doExchange);
	    } else {
		// 
		JgclIntersectionCurve3D ints =
		    intersections[i].toIntersectionCurve();
		intersections[i] = changeTargetOfIntersection(ints, doExchange);
	    }
	}

	Vector results = new Vector();

	// final ł̂́AiwbiBothEnds  comparator QƂ邽
	final IntersectionWithBoundaryInfo[] iwbiBothEnds =
	    new IntersectionWithBoundaryInfo[2];

	// EƂ̌_́u傫ṽp[^lŔfIuWFNg
	JgclListSorter.ObjectComparator comparator =
	    new JgclListSorter.ObjectComparator() {
	    public boolean latterIsGreaterThanFormer(java.lang.Object former,
						     java.lang.Object latter) {
		IntersectionWithBoundaryInfo f = (IntersectionWithBoundaryInfo)former;
		IntersectionWithBoundaryInfo l = (IntersectionWithBoundaryInfo)latter;
		if (f == l)
		    return false;

		if ((f == iwbiBothEnds[0]) || (l == iwbiBothEnds[1]))
		    return true;

		if ((l == iwbiBothEnds[0]) || (f == iwbiBothEnds[1]))
		    return false;

		return (f.curveParameter < l.curveParameter) ? true : false;
	    }
	};

	/*
	 * ̂ꂼɂ
	 */
	for (int i = 0; i < intersections.length; i++) {
	    /*
	     * _̏ꍇAꂪE̓ɂȂ results ɉ
	     */
	    if (intersections[i].isIntersectionPoint() == true) {
		JgclIntersectionPoint3D ints =
		    intersections[i].toIntersectionPoint();
		if (this.intersectionIsInternal(ints, doExchange) == true)
		    results.addElement(ints);
		continue;
	    }

	    /*
	     * ȉȀꍇ
	     */
	    JgclIntersectionCurve3D theIntersection =
		intersections[i].toIntersectionCurve();
	    theIntersection = makeIntersectionClose(theIntersection);

	    /*
	     * Ȗʏ̃p[^Ȑ𓾂
	     */
	    JgclParametricCurve2D intsT;
	    JgclParametricCurve2D intsM;

	    if (doExchange == false) {
		intsT = theIntersection.curve2d1();
		intsM = theIntersection.curve2d2();
	    } else {
		intsT = theIntersection.curve2d2();
		intsM = theIntersection.curve2d1();
	    }

	    boolean isOpen3 = theIntersection.curve3d().isOpen();
	    boolean isOpenT = intsT.isOpen();
	    boolean isOpenM = intsM.isOpen();

	    JgclParameterDomain domainOfIntsT = intsT.parameterDomain();
	    JgclParameterSection sectionOfIntsT = domainOfIntsT.section();

	    /*
	     * EƂ̌_𓾂
	     */
	    Vector listOfIntersectionsWithBoundaries = new Vector();

	    for (int j = - 1; j < this.innerBoundaries2D.size(); j++) {
		JgclCompositeCurve2D aBoundary;

		if (j == - 1)
		    aBoundary = this.outerBoundary2D;
		else
		    aBoundary =
			(JgclCompositeCurve2D)this.innerBoundaries2D.elementAt(j);

		JgclIntersectionPoint2D[] intsWithBoundary =
		    getIntersectionsWithBoundary(aBoundary, intsT);

		for (int k = 0; k < intsWithBoundary.length; k++) {
		    IntersectionWithBoundaryInfo iwbi =
			new IntersectionWithBoundaryInfo(j,
			 intsWithBoundary[k].pointOnCurve1().parameter(),
			 intsWithBoundary[k].pointOnCurve2().parameter());
		    listOfIntersectionsWithBoundaries.addElement(iwbi);
		}
	    }

	    /*
	     * _̐𐮂
	     */
	    iwbiBothEnds[0] = null;
	    iwbiBothEnds[1] = null;
	    boolean addEndPoints = false;

	    if (isOpen3 == true) {
		/*
		 * JĂȂ΁A̗[EƂ̌_ɉ
		 */
		if (intsT.isFinite() == true) {
		    iwbiBothEnds[0] =
			new IntersectionWithBoundaryInfo(-100, 0.0,
			sectionOfIntsT.start());
		    iwbiBothEnds[1] =
			new IntersectionWithBoundaryInfo(-100, 0.0,
			sectionOfIntsT.end());

		    listOfIntersectionsWithBoundaries.addElement(iwbiBothEnds[0]);
		    listOfIntersectionsWithBoundaries.addElement(iwbiBothEnds[1]);
		    addEndPoints = true;
		}
	    } else if (listOfIntersectionsWithBoundaries.size() == 1) {
		/*
		 * ĂāAEƂ̌_Ȃ΁A
		 * ̌_Ⴄ_Ƃĉ
		 */
		IntersectionWithBoundaryInfo iwbi =
		    (IntersectionWithBoundaryInfo)listOfIntersectionsWithBoundaries.elementAt(0);
		IntersectionWithBoundaryInfo iwbi2 =
		    new IntersectionWithBoundaryInfo(iwbi.boundaryIndex,
						     iwbi.boundaryParameter,
						     iwbi.curveParameter);
		listOfIntersectionsWithBoundaries.addElement(iwbi2);
	    }

	    /*
	     * EƂ̌_ȂꍇA
	     * ̂_ (Jn_) E̓ɂ΁A
	     * ̌̂܂܁uo͂̃Xgvɉ
	     */
	    if (listOfIntersectionsWithBoundaries.size() == 0) {
		double aParameter = (intsT.isFinite() == true) ?
		    sectionOfIntsT.start() : 0.0;
		if (this.containsWithWrapping(intsT.coordinates(aParameter)) == true) {
		    results.addElement(changeParameterSpaceOfIntersection(theIntersection, doExchange));
		}
		continue;
	    }

	    /*
	     * ȉAEƂ̌_ꍇ
	     */

	    /*
	     * EƂ̌_̃p[^lŃ\[g
	     */
	    JgclListSorter.doSorting(listOfIntersectionsWithBoundaries, comparator);

	    int nIntervals;
	    if (isOpen3 == true) {
		nIntervals = listOfIntersectionsWithBoundaries.size() - 1;
	    } else {
		nIntervals = listOfIntersectionsWithBoundaries.size();
	    }

	    /*
	     * ׂ荇uEƂ̌_v̒_E̓ɂ΁A
	     * ̋ԂĉƂ
	     */
	    Vector listOfTrimmingIntervals = new Vector();
	    TrimmingInterval trimmingInterval = null;

	    int sIdx;
	    int eIdx;
	    IntersectionWithBoundaryInfo sIwb;
	    IntersectionWithBoundaryInfo eIwb;

	    double sp;
	    double ip;
	    double mp;

	    boolean crossBoundary;

	    sIdx = 0;
	    sIwb = (IntersectionWithBoundaryInfo)
		listOfIntersectionsWithBoundaries.elementAt(0);

	    for (int j = 1; j <= nIntervals; j++) {
		sp = sIwb.curveParameter;
		if ((isOpen3 == true) || (j < nIntervals)) {
		    eIdx = j;
		    eIwb = (IntersectionWithBoundaryInfo)
			listOfIntersectionsWithBoundaries.elementAt(j);
		    crossBoundary = false;
		    ip = eIwb.curveParameter - sIwb.curveParameter;

		    if (((sIwb == iwbiBothEnds[0]) ||
			 (eIwb == iwbiBothEnds[1])) &&
			(Math.abs(ip) < getToleranceForParameter())) {
			sIdx = eIdx;
			sIwb = eIwb;
			continue;
		    }
		} else {
		    eIdx = 0;
		    eIwb = (IntersectionWithBoundaryInfo)
			listOfIntersectionsWithBoundaries.elementAt(0);
		    crossBoundary = true;
		    ip = eIwb.curveParameter - sIwb.curveParameter +
			sectionOfIntsT.increase();

		    if (Math.abs(ip) < getToleranceForParameter()) {
			// no cross boundary
			sIdx = eIdx;
			sIwb = eIwb;
			continue;
		    }
		}

		mp = sp + (ip / 2.0);

		if (addEndPoints == true) {
		    if (j == 1) {
			mp = sp;
		    } else if (j == nIntervals) {
			mp = sp + ip;
		    }
		}

		if ((crossBoundary == true) && (isOpenT == true)) {
		    if (mp < sectionOfIntsT.lower())
			mp += sectionOfIntsT.absIncrease();
		    if (mp > sectionOfIntsT.upper())
			mp -= sectionOfIntsT.absIncrease();
		}

		if (this.containsWithWrapping(intsT.coordinates(mp)) == true) {
		    if ((trimmingInterval != null) &&
			(trimmingInterval.eIdx == sIdx)) {
			trimmingInterval.eIdx = eIdx;
		    } else {
			trimmingInterval = new TrimmingInterval(sIdx, eIdx);
			listOfTrimmingIntervals.addElement(trimmingInterval);
		    }
		}

		sIdx = eIdx;
		sIwb = eIwb;
	    }

	    if ((nIntervals = listOfTrimmingIntervals.size()) > 1) {
		TrimmingInterval head =
		    (TrimmingInterval)listOfTrimmingIntervals.firstElement();
		TrimmingInterval tail =
		    (TrimmingInterval)listOfTrimmingIntervals.lastElement();
		if (head.sIdx == tail.eIdx) {
		    head.sIdx = tail.sIdx;
		    nIntervals--;
		}
	    }

	    /*
	     * ucƔfԁvŃg~O
	     */
	    for (int j = 0; j < nIntervals; j++) {
		trimmingInterval = (TrimmingInterval)listOfTrimmingIntervals.elementAt(j);
		sIwb = (IntersectionWithBoundaryInfo)
		    listOfIntersectionsWithBoundaries.elementAt(trimmingInterval.sIdx);
		eIwb = (IntersectionWithBoundaryInfo)
		    listOfIntersectionsWithBoundaries.elementAt(trimmingInterval.eIdx);

		sp = sIwb.curveParameter;
		if (trimmingInterval.sIdx < trimmingInterval.eIdx) {
		    crossBoundary = false;
		    ip = eIwb.curveParameter - sIwb.curveParameter;
		} else {
		    crossBoundary = true;
		    ip = eIwb.curveParameter - sIwb.curveParameter +
			sectionOfIntsT.increase();
		}

		if (ip < getToleranceForParameter())
		    continue;

		JgclIntersectionCurve3D theTrimmedIntersection =
		    trimIntersection(doExchange,
				     theIntersection, intsT, sectionOfIntsT,
				     isOpenT, isOpenM,
				     crossBoundary, sp, ip);

		/*
		 * g~Oʂ̒[_A̋Ȗʂ̋EɂȂ΁A
		 * ̒[_ZŃt@C
		 */
		// KOKO
		;

		/*
		 * g~OԂuo͂̃Xgvɉ
		 */
		results.addElement(changeParameterSpaceOfIntersection(theTrimmedIntersection,
								      doExchange));
	    }
	}

	/*
	 * uo͂̃XgvԂ
	 */
	intersections = new JgclSurfaceSurfaceInterference3D[results.size()];
	results.copyInto(intersections);
	return intersections;
    }

    /**
     * ̋ȖʂƑ̋Ȗ () ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̋Ȗʂ̕ȖʂƑ̋ȖʂƂ̊Ԃŋ߂
     * ̋Ȗʂ̗L̈Ńg~Ô̋ȖʂƑ̋Ȗʂ̌ƂĂB
     * </p>
     * 
     * @param mate	̋Ȗ ()
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     * @exception JgclIndefiniteSolution	sł
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclPlane3D mate,
						 boolean doExchange)
	 throws JgclIndefiniteSolution
    {
	JgclSurfaceSurfaceInterference3D[] results = this.basisSurface.intersect(mate, doExchange);
	return this.trimIntersectionsWithBoundaries(mate, results, doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ () ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̋Ȗʂ̕ȖʂƑ̋ȖʂƂ̊Ԃŋ߂
     * ̋Ȗʂ̗L̈Ńg~Ô̋ȖʂƑ̋Ȗʂ̌ƂĂB
     * </p>
     * 
     * @param mate	̋Ȗ ()
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     * @exception JgclIndefiniteSolution	sł
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclSphericalSurface3D mate,
						 boolean doExchange)
	 throws JgclIndefiniteSolution
    {
	JgclSurfaceSurfaceInterference3D[] results = this.basisSurface.intersect(mate, doExchange);
	return this.trimIntersectionsWithBoundaries(mate, results, doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (~) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̋Ȗʂ̕ȖʂƑ̋ȖʂƂ̊Ԃŋ߂
     * ̋Ȗʂ̗L̈Ńg~Ô̋ȖʂƑ̋Ȗʂ̌ƂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (~)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     * @exception JgclIndefiniteSolution	sł
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclCylindricalSurface3D mate,
						 boolean doExchange)
	 throws JgclIndefiniteSolution
    {
	JgclSurfaceSurfaceInterference3D[] results = this.basisSurface.intersect(mate, doExchange);
	return this.trimIntersectionsWithBoundaries(mate, results, doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (~) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̋Ȗʂ̕ȖʂƑ̋ȖʂƂ̊Ԃŋ߂
     * ̋Ȗʂ̗L̈Ńg~Ô̋ȖʂƑ̋Ȗʂ̌ƂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (~)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     * @exception JgclIndefiniteSolution	sł
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclConicalSurface3D mate,
						 boolean doExchange)
	 throws JgclIndefiniteSolution
    {
	JgclSurfaceSurfaceInterference3D[] results = this.basisSurface.intersect(mate, doExchange);
	return this.trimIntersectionsWithBoundaries(mate, results, doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (xWGȖ) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̋Ȗʂ̕ȖʂƑ̋ȖʂƂ̊Ԃŋ߂
     * ̋Ȗʂ̗L̈Ńg~Ô̋ȖʂƑ̋Ȗʂ̌ƂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (xWGȖ)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclPureBezierSurface3D mate,
						 boolean doExchange)
    {
	JgclSurfaceSurfaceInterference3D[] results = this.basisSurface.intersect(mate, doExchange);
	return this.trimIntersectionsWithBoundaries(mate, results, doExchange);
    }

    /**
     * ̋ȖʂƑ̋Ȗ (aXvCȖ) ̌߂B
     * <p>
     * ݂ȂƂ͒ 0 ̔zԂB
     * </p>
     * <p>
     * []
     * <br>
     * ̋Ȗʂ̕ȖʂƑ̋ȖʂƂ̊Ԃŋ߂
     * ̋Ȗʂ̗L̈Ńg~Ô̋ȖʂƑ̋Ȗʂ̌ƂĂB
     * </p>
     * 
     * @param mate	̋Ȗ (aXvCȖ)
     * @param doExchange	 basisSurface1/2 邩ǂ
     * @return		̔z
     */
    JgclSurfaceSurfaceInterference3D[] intersect(JgclBsplineSurface3D mate,
						 boolean doExchange)
    {
	JgclSurfaceSurfaceInterference3D[] results = this.basisSurface.intersect(mate, doExchange);
	return this.trimIntersectionsWithBoundaries(mate, results, doExchange);
    }

    /**
     * ̋Ȗʂ̎w (p[^I) `ԂA
     * ^ꂽ덷ŕʋߎ_QԂB
     * <p>
     * ʂƂē_Q͈ʂɁAʑIɂ􉽓IɂAiqł͂ȂB
     * </p>
     * <p>
     * scalingFactor ́A͗pł͂ȂAo͗p̈łB
     * scalingFactor ɂ́Avf 2 ̔z^B
     * scalingFactor[0] ɂ U ̏kڔ{A
     * scalingFactor[1] ɂ V ̏kڔ{ԂB
     * ̒l͉炩̐Βlł͂ȂA
     * p[^̐iޑx T ɑ΂āA
     * U/V ɂĎԏŋȖʏ̓_iޑx Pu/Pv \ΒlłB
     * ܂Ap[^ T iނƁA
     * ԏł̋Ȗʏ̓_ U ł Pu (scalingFactor[0])A
     * V ł Pv (scalingFactor[1]) iނƂ\ĂB
     * T ̑傫͖Ȃ̂ŁA̒lQƂۂɂ́A
     * scalingFactor[0]  scalingFactor[1] ̔䂾pׂłB
     * ȂA̒l͂܂łڈłAȑx̂ł͂ȂB
     * </p>
     * <p>
     * ʂƂĕԂ Vector Ɋ܂܂evf
     * ̋Ȗʂx[XƂ JgclPointOnSurface3D
     * ł邱Ƃ҂łB
     * </p>
     * <p>
     * ܂̂ƂA̋@\͎ĂȂ߁A
     * JgclNotSupported ̗O𔭐B
     * </p>
     *
     * @param uParameterSection	U ̃p[^
     * @param vParameterSection	V ̃p[^
     * @param tolerance	̋e덷
     * @param scalingFactor	_QOp`ۂɗLpƎv U/V ̏kڔ{
     * @return	_Q܂ Vector
     * @see	JgclPointOnSurface3D
     * @see	JgclNotSupported
     */
    public Vector toNonStructuredPoints(JgclParameterSection uParameterSection,
					JgclParameterSection vParameterSection,
					double tolerance,
					double[] scalingFactor) {
	throw new JgclNotSupported();	// toNonStructuredPoints
    }

    /**
     * ^ꂽp[^lA̋Ȗʂ̋E̓ɂ邩ۂԂB
     * <p>
     * ^ꂽp[^lEɂꍇɂ́uvƔfB
     * </p>
     *
     * @param uParam	U ̃p[^l
     * @param vParam	V ̃p[^l
     * @return	p[^lE̓ł trueAłȂ false
     */
    public boolean contains(double uParam,
			    double vParam) {
	return this.contains(JgclPoint2D.of(uParam, vParam));
    }

    /**
     * ^ꂽp[^lA̋Ȗʂ̋E̓ɂ邩ۂԂB
     * <p>
     * point2D Eɂꍇɂ́uvƔfB
     * </p>
     *
     * @param point2D	(u, v) p[^l
     * @return	point2D E̓ł trueAłȂ false
     */
    public boolean contains(JgclPoint2D point2D) {
	try {
	    if (point2D.isIn(this.outerBoundary2D) != true) {
		return false;
	    }

	    for (Enumeration e = innerBoundaries2D.elements(); e.hasMoreElements();) {
		if (point2D.isInsideOf((JgclParametricCurve2D)e.nextElement()) == true) {
		    return false;
		}
	    }
	} catch (JgclOpenCurve exp) {
	    ; // N蓾Ȃ͂
	}

	return true;
    }

    /**
     * ^ꂽp[^lA̋Ȗʂ̋E̓ɂ邩ۂԂB
     * <p>
     * ^ꂽp[^lȖʂ̃p[^` wrap ɁA
     * {@link #contains(double, double) contains(double, double)}
     * ĂяoB
     * </p>
     *
     * @param uParam	U ̃p[^l
     * @param vParam	V ̃p[^l
     * @return	p[^lE̓ł trueAłȂ false
     */
    private boolean containsWithWrapping(double uParam,
					 double vParam) {
	return this.contains(basisSurface.uParameterDomain().wrap(uParam),
			     basisSurface.vParameterDomain().wrap(vParam));
    }

    /**
     * ^ꂽp[^lA̋Ȗʂ̋E̓ɂ邩ۂԂB
     * <p>
     * ^ꂽp[^lȖʂ̃p[^` wrap ɁA
     * {@link #contains(double, double) contains(double, double)}
     * ĂяoB
     * </p>
     *
     * @param point2D	(u, v) p[^l
     * @return	point2D E̓ł trueAłȂ false
     */
    private boolean containsWithWrapping(JgclPoint2D point2D) {
	return this.contains(basisSurface.uParameterDomain().wrap(point2D.x()),
			     basisSurface.vParameterDomain().wrap(point2D.y()));
    }

    /**
     * Ȅ񂪂ʏ_\NXB
     * @see	#toSetOfTriangles(double, double)
     */
    private class SurfacePointWithBoundaryInfo extends JgclPointOnSurface3D {
	/**
	 * E̔ԍB
	 * <p>
	 * (- 1) ł΁AO\B
	 * </p>
	 * @serial
	 */
	int boundaryNumber;

	/**
	 * Eł̂̓_̔ԍB
	 * @serial
	 */
	int pointNumber;

	/**
	 * etB[hɐݒ肷l^ăIuWFNg\zB
	 *
	 * @param basisSurface	_̏ĂȖ
	 * @param uParam	Ȗʏł̓_ U ̃p[^l
	 * @param vParam	Ȗʏł̓_ V ̃p[^l
	 * @param boundaryNumber	E̔ԍ
	 * @param pointNumber	Eł̂̓_̔ԍ
	 */
	SurfacePointWithBoundaryInfo(JgclParametricSurface3D basisSurface,
				     double uParam,
				     double vParam,
				     int boundaryNumber,
				     int pointNumber) {
	    super(basisSurface, uParam, vParam);
	    this.boundaryNumber = boundaryNumber;
	    this.pointNumber = pointNumber;
	}

	/**
	 * ƗדmۂAԂB
	 *
	 * @param	mate	
	 * @return	mate ׂȂ trueAłȂ false
	 */
	boolean isNeighborOf(SurfacePointWithBoundaryInfo mate,
			     JgclPolyline2D outerPolyline2D,
			     Vector innerPolylines2D) {
	    if (this.boundaryNumber != mate.boundaryNumber)
		return false;

	    if ((this.pointNumber == (mate.pointNumber - 1)) ||
		(this.pointNumber == (mate.pointNumber + 1)))
		return true;

	    if ((this.pointNumber != 0) &&
		(mate.pointNumber != 0))
		return false;

	    JgclPolyline2D boundary =
		(this.boundaryNumber == - 1)
		? outerPolyline2D
		: (JgclPolyline2D)innerPolylines2D.elementAt(this.boundaryNumber);

	    if (this.pointNumber == 0) {
		if (mate.pointNumber == (boundary.nPoints() - 2))
		    return true;
	    } else {
		if (this.pointNumber == (boundary.nPoints() - 2))
		    return true;
	    }

	    return false;
	}
    }

    /**
     * Ȗʏ̓񒸓_ԂQ̐B
     *
     * @param v1	_ 1
     * @param v2	_ 2
     * @return	񒸓_Ԑ
     * @see	#findWrongEdge(JgclSetOfTriangles3D.Vertex, JgclSetOfTriangles3D.Vertex, JgclSetOfTriangles3D.Face[])
     * @see	#findWrongEdge2(JgclSetOfTriangles3D.Vertex, JgclSetOfTriangles3D.Vertex, JgclSetOfTriangles3D.Edge, JgclSetOfTriangles3D.Face[])
     */
    private JgclBoundedLine2D makeBoundedLine(JgclSetOfTriangles3D.Vertex v1,
					      JgclSetOfTriangles3D.Vertex v2) {
	SurfacePointWithBoundaryInfo c1 =
	    (SurfacePointWithBoundaryInfo)v1.getCoordinates();
	SurfacePointWithBoundaryInfo c2 =
	    (SurfacePointWithBoundaryInfo)v2.getCoordinates();

	return new JgclBoundedLine2D(JgclPoint2D.of(c1.parameters()),
				     JgclPoint2D.of(c2.parameters()));
    }

    /**
     * ɍsȂĂȂƂO̓NXB
     * @see	#findWrongEdge(JgclSetOfTriangles3D.Vertex, JgclSetOfTriangles3D.Vertex, JgclSetOfTriangles3D.Face[])
     * @see	#findWrongEdge2(JgclSetOfTriangles3D.Vertex, JgclSetOfTriangles3D.Vertex, JgclSetOfTriangles3D.Edge, JgclSetOfTriangles3D.Face[])
     * @see	#flipDiagonalsIn(JgclSetOfTriangles3D, JgclPolyline2D, Vector)
     */
    private class SomeThingWrong extends JgclException {
	/**
	 * ^ɃIuWFNg\zB
	 */
	public SomeThingWrong() {
	    super();
	}
    }

    /**
     * 񒸓_̊Ԃ́u܂ӁvB
     * <p>
     * ܂ӂȂ΁Anull ԂB
     * </p>
     *
     * @param v1	_ 1
     * @param v2	_ 2
     * @param v1Face	_ 1 Ɓu܂Ӂv̊Ԃɂ (o͗pAvf 1)
     * @return	񒸓_̊Ԃ́u܂Ӂv
     * @exception	SomeThingWrong	
     * @see	#flipDiagonalsIn(JgclSetOfTriangles3D, JgclPolyline2D, Vector)
     */
    private JgclSetOfTriangles3D.Edge findWrongEdge(JgclSetOfTriangles3D.Vertex v1,
						    JgclSetOfTriangles3D.Vertex v2,
						    JgclSetOfTriangles3D.Face[] v1Face)
	 throws SomeThingWrong
    {
	JgclSetOfTriangles3D.Edge wrongEdge = null;

	JgclSetOfTriangles3D.Face[] faces1 = v1.getFacesInCCW();
	JgclSetOfTriangles3D.Face[] faces2 = v2.getFacesInCCW();

	/*
	 * v1  v2 ʂ̖ʂȂ΁Au܂Ӂv͂Ȃ
	 */
	for (int i1 = 0; i1 < faces1.length; i1++) {
	    if (faces1[i1] == null) continue;

	    for (int i2 = 0; i2 < faces2.length; i2++) {
		if (faces2[i2] == null) continue;

		if (faces1[i1].isIdentWith(faces2[i2]) == true)
		    return null;
	    }
	}

	/*
	 * v1 ̖ʂ v2 ̖ʂʂ̕ӂȂ΁A̕ӂu܂Ӂvł
	 */
	JgclBoundedLine2D Abln = makeBoundedLine(v1, v2);
	JgclSetOfTriangles3D.Edge[] edges1;
	JgclSetOfTriangles3D.Edge[] edges2;
	JgclSetOfTriangles3D.Vertex[] mates;

	for (int i1 = 0; i1 < faces1.length; i1++) {
	    if (faces1[i1] == null) continue;

	    edges1 = faces1[i1].getEdgesInCCW();

	    for (int i2 = 0; i2 < faces2.length; i2++) {
		if (faces2[i2] == null) continue;

		edges2 = faces2[i2].getEdgesInCCW();

		for (int j1 = 0; j1 < 3; j1++) {
		    for (int j2 = 0; j2 < 3; j2++) {
			if (edges1[j1].isIdentWith(edges2[j2]) != true)
			    continue;

			// edges1[j1]  edges2[j2] ͓

			mates = edges1[j1].getVerticesOfStartEnd();

			if ((v1.isIdentWith(mates[0]) == true) ||
			    (v1.isIdentWith(mates[1]) == true) ||
			    (v2.isIdentWith(mates[0]) == true) ||
			    (v2.isIdentWith(mates[1]) == true))
			    continue;

			try {
			    if (Abln.intersect1(makeBoundedLine(mates[0], mates[1])) != null) {
				if (v1Face != null)
				    v1Face[0] = faces1[i1];
				return edges1[j1];
			    }
			} catch (JgclIndefiniteSolution e) {
			    ;
			}
		    }
		}
	    }
	}

	/*
	 * v1 ̖ʂ̕ӂŁAv1  v2 ւ̒ƌ̂΁A
	 * ̕ӂu܂Ӂvł
	 */
	for (int i1 = 0; i1 < faces1.length; i1++) {
	    if (faces1[i1] == null) continue;

	    edges1 = faces1[i1].getEdgesInCCW();

	    for (int j1 = 0; j1 < 3; j1++) {
		mates = edges1[j1].getVerticesOfStartEnd();

		if ((v1.isIdentWith(mates[0]) == true) ||
		    (v1.isIdentWith(mates[1]) == true))
		    continue;

		try {
		    if (Abln.intersect1(makeBoundedLine(mates[0], mates[1])) != null) {
			if (v1Face != null)
			    v1Face[0] = faces1[i1];
			return edges1[j1];
		    }
		} catch (JgclIndefiniteSolution e) {
		    ;
		}
	    }
	}

	throw new SomeThingWrong();
    }

    /**
     * 񒸓_̊Ԃ́û܂ӁvB
     *
     * @param v1	_ 1
     * @param v2	_ 2
     * @param wrongEdge	܂
     * @param nearFace	_ 1 Ɓu܂Ӂv̊Ԃɂ (o͗pAvf 1)
     * @return	񒸓_̊Ԃ́û܂Ӂv
     * @exception	SomeThingWrong	
     * @see	#flipDiagonalsIn(JgclSetOfTriangles3D, JgclPolyline2D, Vector)
     */
    private JgclSetOfTriangles3D.Edge findWrongEdge2(JgclSetOfTriangles3D.Vertex v1,
						     JgclSetOfTriangles3D.Vertex v2,
						     JgclSetOfTriangles3D.Edge wrongEdge,
						     JgclSetOfTriangles3D.Face[] nearFace)
	 throws SomeThingWrong
    {
	/*
	 *              |\                        v1 : I : vertex 1
	 *   v1         | \                       v2 : I : vertex 2
	 *   +          |  \          v2          e1 : I : previous wrong_edge
	 *         f1   |   \         +           e2 : O : new wrong_edge
	 *              |    \                    f1 : I : previous near_face
	 *              | f2  \                   f2 : O : new near_face
	 *              |      \
	 *             e1       e2
	 */

	JgclSetOfTriangles3D.Face[] wrongEdgeFaces = wrongEdge.getFacesOfLeftRight();
	JgclSetOfTriangles3D.Face farFace = 
	    (nearFace[0].isIdentWith(wrongEdgeFaces[0]) == true)
	    ? wrongEdgeFaces[1] : wrongEdgeFaces[0];

	if (farFace == null)
	    throw new SomeThingWrong();

	JgclBoundedLine2D Abln = makeBoundedLine(v1, v2);

	JgclSetOfTriangles3D.Edge[] farFaceEdges = farFace.getEdgesInCCW();

	for (int i = 0; i < 3; i++) {
	    if (wrongEdge.isIdentWith(farFaceEdges[i]) == true)
		continue;

	    JgclSetOfTriangles3D.Vertex[] mates =
		farFaceEdges[i].getVerticesOfStartEnd();

	    if ((v2.isIdentWith(mates[0]) == true) ||
		(v2.isIdentWith(mates[1]) == true))
		throw new SomeThingWrong();

	    try {
		if (Abln.intersect1(makeBoundedLine(mates[0], mates[1])) != null) {
		    nearFace[0] = farFace;
		    return farFaceEdges[i];
		}
	    } catch (JgclIndefiniteSolution e) {
		;
	    }
	}

	throw new SomeThingWrong();
    }

    /**
     * ӂւ邩ۂAԂB
     *
     * @param edge	
     * @return	ւ trueAłȂ false
     * @see	#flipDiagonalsIn(JgclSetOfTriangles3D, JgclPolyline2D, Vector)
     */
    private boolean edgeCanBeFlipped(JgclSetOfTriangles3D.Edge edge) {
	JgclSetOfTriangles3D.Vertex[] vrtcs = edge.getVerticesOfStartEnd();
	JgclSetOfTriangles3D.Face[] faces = edge.getFacesOfLeftRight();
	SurfacePointWithBoundaryInfo c;
	JgclPoint2D[] crds = new JgclPoint2D[3];

	for (int i = 0; i < 2; i++) {
	    if (faces[i] == null)	// outer face
		return false;

	    JgclSetOfTriangles3D.Vertex[] faceVrtx = faces[i].getVerticesInCCW();

	    for (int j = 0; j < 3; j++) {
		if ((faceVrtx[j].isIdentWith(vrtcs[0]) != true) &&
		    (faceVrtx[j].isIdentWith(vrtcs[1]) != true)) {
		    c = (SurfacePointWithBoundaryInfo)faceVrtx[j].getCoordinates();
		    crds[i] = JgclPoint2D.of(c.parameters());
		    break;
		}
	    }
	}

	for (int i = 0; i < 2; i++) {
	    c = (SurfacePointWithBoundaryInfo)vrtcs[i].getCoordinates();
	    crds[2] = JgclPoint2D.of(c.parameters());
	    if (JgclPoint2D.collinear(crds, 0, 2) != null)
		return false;
	}

	return true;
    }

    /**
     * 𑱂ĂԂ̖ʂۂAԂB
     *
     * @param wrongEdge	܂
     * @param vertexPairList wu܂Ӂv̗[̒_x̃Xg
     * @return	Ԃ̖ʂȂ trueAłȂ false
     * @see	#flipDiagonalsIn(JgclSetOfTriangles3D, JgclPolyline2D, Vector)
     */
    private boolean wasteOfTime(JgclSetOfTriangles3D.Edge wrongEdge,
				Vector vertexPairList) {
	JgclSetOfTriangles3D.Vertex[] crntVertexPair = wrongEdge.getVerticesOfStartEnd();

	int nWastes = 0;
	for (Enumeration e = vertexPairList.elements(); e.hasMoreElements();) {
	    JgclSetOfTriangles3D.Vertex[] vertexPair =
		(JgclSetOfTriangles3D.Vertex[])e.nextElement();
	    if (((vertexPair[0].isIdentWith(crntVertexPair[0]) == true) &&
		 (vertexPair[1].isIdentWith(crntVertexPair[1]) == true)) ||
		((vertexPair[0].isIdentWith(crntVertexPair[1]) == true) &&
		 (vertexPair[1].isIdentWith(crntVertexPair[0]) == true)))
		nWastes++;
	}
	if (nWastes >= 20)
	    return true;	// the boundary must self-intersect

	vertexPairList.addElement(crntVertexPair);
	return false;
    }

    /**
     * ĚqCB
     *
     * @param triangles	Op`̏W
     * @return	܂Cł trueACłȂ false
     * @see	#toSetOfTriangles(double, double)
     */
    private boolean flipDiagonalsIn(JgclSetOfTriangles3D triangles,
				    JgclPolyline2D outerPolyline2D,
				    Vector innerPolylines2D) {
	boolean success = true;
	Vector wrongConnectedVertexList = new Vector();

	/*
	 * ܂qĂȂ_
	 */
	for (Enumeration e = triangles.vertexElements(); e.hasMoreElements();) {
	    JgclSetOfTriangles3D.Vertex vrtx =
		(JgclSetOfTriangles3D.Vertex)e.nextElement();
	    SurfacePointWithBoundaryInfo vrtxCoord =
		(SurfacePointWithBoundaryInfo)vrtx.getCoordinates();

	    if (vrtxCoord.boundaryNumber == (- 2))	// E̓̓_
		continue;

	    int connectedNumber = 0;
	    JgclSetOfTriangles3D.Edge[] edges = vrtx.getEdgesInCCW();
	    for (int i = 0; i < edges.length; i++) {
		JgclSetOfTriangles3D.Vertex[] vrtcs = edges[i].getVerticesOfStartEnd();
		JgclSetOfTriangles3D.Vertex mate
		    = (vrtx.isIdentWith(vrtcs[0]) != true) ? vrtcs[0] : vrtcs[1];
		SurfacePointWithBoundaryInfo mateCoord = 
		    (SurfacePointWithBoundaryInfo)mate.getCoordinates();

		if (vrtxCoord.isNeighborOf(mateCoord, outerPolyline2D, innerPolylines2D) == true)
		    if (++connectedNumber == 2)
			break;
	    }

	    for (int i = connectedNumber; i < 2; i++) {
		wrongConnectedVertexList.addElement(vrtx);
		// Debug
		// System.err.println("vrtx " + vrtxCoord.boundaryNumber +
		// 		   ", " + vrtxCoord.pointNumber);
	    }
	}

	// Debug
	// System.err.println(wrongConnectedVertexList.size());

	/*
	 * ܂qC
	 */
	while (wrongConnectedVertexList.isEmpty() != true) {
	    JgclSetOfTriangles3D.Vertex v1 =
		(JgclSetOfTriangles3D.Vertex)wrongConnectedVertexList.elementAt(0);
	    SurfacePointWithBoundaryInfo c1 =
		(SurfacePointWithBoundaryInfo)v1.getCoordinates();

	    JgclSetOfTriangles3D.Vertex v2 = null;
	    SurfacePointWithBoundaryInfo c2;
	    int i;

	    for (i = 1; i < wrongConnectedVertexList.size(); i++) {
		v2 = (JgclSetOfTriangles3D.Vertex)wrongConnectedVertexList.elementAt(i);
		c2 = (SurfacePointWithBoundaryInfo)v2.getCoordinates();
		if (c1.isNeighborOf(c2, outerPolyline2D, innerPolylines2D) == true) {
		    try {
			if (findWrongEdge(v1, v2, null) != null)
			    break;
		    } catch (SomeThingWrong e) {
			success = false;
		    }
		}
	    }

	    if (i < wrongConnectedVertexList.size()) {
		/*
		 * v1  v2 ɌāA܂qC
		 */
		JgclSetOfTriangles3D.Vertex vA = v1;
		JgclSetOfTriangles3D.Vertex vB = v2;
		boolean reverse = false;
		int nFails = 0;
		Vector vertexPairList = new Vector();
		JgclSetOfTriangles3D.Face[] nearFace = new JgclSetOfTriangles3D.Face[1];

		while (true) {
		    JgclSetOfTriangles3D.Edge wrongEdge;
		    try {
			wrongEdge = findWrongEdge(vA, vB, nearFace);
		    } catch (SomeThingWrong e) {
			wrongEdge = null;
		    }
		    if (wrongEdge == null)
			break;

		    if (wasteOfTime(wrongEdge, vertexPairList)  == true)
			break;

		    if ((edgeCanBeFlipped(wrongEdge) == true) &&
			(wrongEdge.flipDiagonal() != null)) {
			nFails = 0;
		    } else {
			while (true) {
			    try {
				wrongEdge = findWrongEdge2(vA, vB, wrongEdge, nearFace);
			    } catch (SomeThingWrong e) {
				wrongEdge = null;
			    }
			    if (wrongEdge == null)
				break;

			    if ((edgeCanBeFlipped(wrongEdge) == true) &&
				(wrongEdge.flipDiagonal() != null)) {
				nFails = 0;
				break;
			    }
			}

			if (wrongEdge == null) {
			    if (++nFails == 2)
				break;
			}

			if (reverse == false) {
			    vA = v2;
			    vB = v1;
			    reverse = true;
			} else {
			    vA = v1;
			    vB = v2;
			    reverse = false;
			}
		    }
		}

		wrongConnectedVertexList.removeElementAt(i);
	    }

	    wrongConnectedVertexList.removeElementAt(0);
	}

	return success;
    }

    /**
     * ̋ȖʑŜA^ꂽxŕʋߎOp`̏WԂB
     *
     * @param tol4S	Ȗʕ̐x
     * @param tol4B	E̐x (Qp[^ԏł̒l)
     * @return		Op`̏W
     */
    public JgclSetOfTriangles3D toSetOfTriangles(double tol4S,
						 double tol4B) {
	// _Q : JgclPointOnSurface3D ̏W

	// Ȗʂ̋E܂ޗ̈_Qɕϊ
	JgclParameterSection uPint =
	    new JgclParameterSection(enclosingBox2D.min().x(),
				     (enclosingBox2D.max().x() - enclosingBox2D.min().x()));
	JgclParameterSection vPint =
	    new JgclParameterSection(enclosingBox2D.min().y(),
				     (enclosingBox2D.max().y() - enclosingBox2D.min().y()));

	double[] scalingFactor = new double[2];
	Vector pointsOnBasisSurface =
	    this.basisSurface.toNonStructuredPoints(uPint, vPint, tol4S, scalingFactor);

	/*
	// Debug start
	for (Enumeration e = pointsOnBasisSurface.elements();
	     e.hasMoreElements();) {
	    JgclPointOnSurface3D ppp = (JgclPointOnSurface3D)e.nextElement();
	    System.out.println(ppp.uParameter() + ", " + ppp.vParameter());
	}
	System.out.println("---");
	// Debug end
	*/

	// O_Qɕϊ
	JgclToleranceForDistance tol4Boundary = new JgclToleranceForDistance(tol4B);
	JgclPolyline2D outerPolyline2D = this.outerBoundary2D.toPolyline(tol4Boundary);

	// _Qɕϊ
	Vector innerPolyline2D = new Vector();
	for (Enumeration e = this.innerBoundaries2D.elements();
	     e.hasMoreElements();) {
	    JgclCompositeCurve2D inner = (JgclCompositeCurve2D)e.nextElement();
	    innerPolyline2D.addElement(inner.toPolyline(tol4Boundary));
	}

	// E̊O̓_폜
	Vector innerPointsOnBasisSurface = new Vector();
	int jjj = 0;
	for (Enumeration e = pointsOnBasisSurface.elements();
	     e.hasMoreElements();) {
	    JgclPointOnSurface3D point = (JgclPointOnSurface3D)e.nextElement();
	    JgclPoint2D point2D = JgclPoint2D.of(point.parameters());

	    if (this.contains(point2D) == true) {
		SurfacePointWithBoundaryInfo innerPoint = 
		    new SurfacePointWithBoundaryInfo(this.basisSurface,
						     point.uParameter(),
						     point.vParameter(), -2, -1);
		innerPointsOnBasisSurface.addElement(innerPoint);
	    }
	}

	/*
	// Debug start
	for (Enumeration e = innerPointsOnBasisSurface.elements();
	     e.hasMoreElements();) {
	    JgclPointOnSurface3D ppp = (JgclPointOnSurface3D)e.nextElement();
	    System.out.println(ppp.uParameter() + ", " + ppp.vParameter());
	}
	System.out.println("---");
	// Debug end
	*/

	// _Q}[W
	pointsOnBasisSurface = innerPointsOnBasisSurface;
	for (int i = 0; i < (outerPolyline2D.nPoints() - 1); i++) {
	    JgclPoint2D point2D = outerPolyline2D.pointAt(i);
	    JgclPointOnSurface3D point3D =
		new SurfacePointWithBoundaryInfo(this.basisSurface,
						 point2D.x(), point2D.y(),
						 -1, i);
	    pointsOnBasisSurface.addElement(point3D);
	}

	for (int j = 0; j < innerPolyline2D.size(); j++) {
	    JgclPolyline2D inner = (JgclPolyline2D)innerPolyline2D.elementAt(j);
	    for (int i = 0; i < (inner.nPoints() - 1); i++) {
		JgclPoint2D point2D = inner.pointAt(i);
		JgclPointOnSurface3D point3D =
		    new SurfacePointWithBoundaryInfo(this.basisSurface,
						     point2D.x(), point2D.y(),
						     j, i);
		pointsOnBasisSurface.addElement(point3D);
	    }
	}

	/*
	// Debug start
	for (Enumeration e = pointsOnBasisSurface.elements();
	     e.hasMoreElements();) {
	    JgclPointOnSurface3D ppp = (JgclPointOnSurface3D)e.nextElement();
	    System.out.println(ppp.uParameter() + ", " + ppp.vParameter());
	}
	System.out.println("---");
	// Debug end
	*/

	double uScale;
	double vScale;
	if (scalingFactor[0] < scalingFactor[1]) {
	    uScale = scalingFactor[0] / scalingFactor[1];
	    vScale = 1.0;
	} else {
	    uScale = 1.0;
	    vScale = scalingFactor[1] / scalingFactor[0];
	}

	JgclSetOfTriangles3D triangles = null;
	int maxTrys = 5;
	int nTrys = 1;
	double radiusScale = JgclVoronoiDiagram2D.radiusScaleDefault;

	while (true) {
	    // _QOp`̏W𐶐
	    triangles =
		new JgclSetOfTriangles3D(pointsOnBasisSurface.elements(),
					 uScale, vScale, radiusScale);

	    // ĚqCāAOK Ȃ break
	    if ((flipDiagonalsIn(triangles,
				 outerPolyline2D,
				 innerPolyline2D) == true) ||
		(nTrys >= maxTrys))
		break;

	    nTrys++;
	    radiusScale *= 10.0;
	}

	// svȎOp`폜
	SurfacePointWithBoundaryInfo[] vpnts = new SurfacePointWithBoundaryInfo[3];
	JgclPoint2D[] vcrds2 = new JgclPoint2D[3];
	int[] order = new int[3];

	for (Enumeration e = triangles.faceElements(); e.hasMoreElements();) {
	    JgclSetOfTriangles3D.Face face =
		(JgclSetOfTriangles3D.Face)e.nextElement();
	    JgclSetOfTriangles3D.Vertex[] vrtcs = face.getVerticesInCCW();

	    vpnts[0] = (SurfacePointWithBoundaryInfo)vrtcs[0].getCoordinates();

	    int boundaryNumber = vpnts[0].boundaryNumber;
	    if (boundaryNumber < -1)	// E̓ɂ_
		continue;

	    vpnts[1] = (SurfacePointWithBoundaryInfo)vrtcs[1].getCoordinates();
	    if (vpnts[1].boundaryNumber != boundaryNumber)	// EႤ
		continue;

	    vpnts[2] = (SurfacePointWithBoundaryInfo)vrtcs[2].getCoordinates();
	    if (vpnts[2].boundaryNumber != boundaryNumber)	// EႤ
		continue;

	    for (int i = 0; i < 3; i++)
		vcrds2[i] = JgclPoint2D.of(vpnts[i].parameters());

	    if (vpnts[0].pointNumber < vpnts[1].pointNumber) {
		order[0] = 0;
		order[1] = 1;
	    } else {
		order[0] = 1;
		order[1] = 0;
	    }

	    if (vpnts[order[1]].pointNumber < vpnts[2].pointNumber) {
		order[2] = 2;
	    } else {
		order[2] = order[1];
		if (vpnts[order[0]].pointNumber < vpnts[2].pointNumber) {
		    order[1] = 2;
		} else {
		    order[1] = order[0];
		    order[0] = 2;
		}
	    }

	    JgclVector2D edge0 = vcrds2[order[1]].subtract(vcrds2[order[0]]);
	    JgclVector2D edge1 = vcrds2[order[2]].subtract(vcrds2[order[1]]);
	    if (edge0.zOfCrossProduct(edge1) > 0.0)	// E̓
		continue;

	    // face ͋E̊Oɂ
	    face.setKilled(true);
	}

	return triangles;
    }

    // Main Programs for Debugging
    /**
     * fobOpCvOB
     */
    public static void main(String[] args) {
	JgclPoint3D[][] controlPoints = new JgclPoint3D[4][4];

	controlPoints[0][0] = JgclPoint3D.of(3.00,	5.00,	8.00);
	controlPoints[1][0] = JgclPoint3D.of(7.82963,	6.2941, 13.00);
	controlPoints[2][0] = JgclPoint3D.of(12.6593, 7.58819, 3.00);
	controlPoints[3][0] = JgclPoint3D.of(17.4889, 8.88229, 8.00);

	controlPoints[0][1] = JgclPoint3D.of(1.7059, 9.82963, 18.00);
	controlPoints[1][1] = JgclPoint3D.of(6.53553, 11.1237, 23.00);
	controlPoints[2][1] = JgclPoint3D.of(11.3652, 12.4178, 13.00);
	controlPoints[3][1] = JgclPoint3D.of(16.1948, 13.7119, 18.00);

	controlPoints[0][2] = JgclPoint3D.of(0.41181, 14.6593, 18.00);
	controlPoints[1][2] = JgclPoint3D.of(5.24144, 15.9534, 23.00);
	controlPoints[2][2] = JgclPoint3D.of(10.0711, 17.2474, 13.00);
	controlPoints[3][2] = JgclPoint3D.of(14.9007, 18.5415, 18.00);

	controlPoints[0][3] = JgclPoint3D.of(-0.882286, 19.4889, 8.00);
	controlPoints[1][3] = JgclPoint3D.of(3.94734, 20.783, 13.00);
	controlPoints[2][3] = JgclPoint3D.of(8.77697, 22.0771, 3.00);
	controlPoints[3][3] = JgclPoint3D.of(13.6066, 23.3712, 8.00);

	JgclPureBezierSurface3D basisSurface =
	    new JgclPureBezierSurface3D(controlPoints);

	JgclCircle2D circle2D = new JgclCircle2D(JgclPoint2D.of(0.5, 0.5), 0.3);
	JgclSurfaceCurve3D surfaceCurve3D =
	    new JgclSurfaceCurve3D(null, basisSurface, circle2D,
				   JgclPreferredSurfaceCurveRepresentation.CURVE_2D_1);

	JgclTrimmedCurve3D trimmedCurve3D =
	    new JgclTrimmedCurve3D(surfaceCurve3D,
				   circle2D.parameterDomain().section());

	JgclCompositeCurveSegment3D[] segments = new JgclCompositeCurveSegment3D[1];

	segments[0] = new JgclCompositeCurveSegment3D(JgclTransitionCode.CONTINUOUS,
						      true,
						      trimmedCurve3D);

	JgclCompositeCurve3D outerBoundary =
	    new JgclCompositeCurve3D(segments, true);

	Vector innerBoundaries = new Vector();

	JgclCurveBoundedSurface3D surface = 
	    new JgclCurveBoundedSurface3D(basisSurface,
					  outerBoundary,
					  innerBoundaries);

	// surface.basisSurface().output(System.out);

	// JgclSetOfTriangles3D stri = surface.toSetOfTriangles(0.1, 0.01);
	JgclSetOfTriangles3D stri = surface.toSetOfTriangles(0.01, 0.001);

	int i = 0;
	for (Enumeration e = stri.edgeElements(); e.hasMoreElements();) {
	    JgclSetOfTriangles3D.Edge edge =
		(JgclSetOfTriangles3D.Edge)e.nextElement();
	    JgclSetOfTriangles3D.Vertex[] vrtcs = edge.getVerticesOfStartEnd();
	    JgclPoint3D pnt0 = vrtcs[0].getCoordinates();
	    JgclPoint3D pnt1 = vrtcs[1].getCoordinates();

	    System.out.println("JgclLine3D	lin" + i);
	    System.out.println("\tpnt\t" + pnt0.x() + " " + pnt0.y() + " " + pnt0.z());
	    System.out.println("\tpnt\t" + pnt1.x() + " " + pnt1.y() + " " + pnt1.z());
	    System.out.println("End");
	    i++;
	}
    }
}

// end of file
